﻿local addon, ns = ...
local cfg = ns.cfg
if not cfg.StyleDBM or not IsAddOnLoaded("DBM-Core") then return end
---------------- > style DBM (huge props to Affli and his DBM-Styler plug-in)
local dummy = function()end
local styled = false
-- make sure vars are available.
local ds=CreateFrame"Frame"
ds:RegisterEvent"VARIABLES_LOADED"
ds:SetScript("OnEvent", function()

local buttonsize=23
local font="Fonts\\FRIZQT__.ttf"
local tex="Interface\\TargetingFrame\\UI-StatusBar.blp"
local backdrop={
		bgFile = "Interface\\Buttons\\WHITE8x8",
		edgeFile = "Interface\\Buttons\\WHITE8x8",
		tile = false, tileSize = 0, edgeSize = 1, 
		insets = { left = -1, right = -1, top = -1, bottom = -1}
	}
local function SetTemplate(ds)
	if ds then
		ds:SetBackdrop(backdrop)
		ds:SetBackdropColor(.1,.1,.1,1)
		ds:SetBackdropBorderColor(0,0,0,1)
	end
end
-- this will inject our code to all dbm bars.
function SkinBars(self)
	for bar in self:GetBarIterator() do
		if not (bar.injected==styled) then
			bar.ApplyStyle=function()
			local frame = bar.frame
			local tbar = _G[frame:GetName().."Bar"]
			local spark = _G[frame:GetName().."BarSpark"]
			local texture = _G[frame:GetName().."BarTexture"]
			local icon1 = _G[frame:GetName().."BarIcon1"]
			local icon2 = _G[frame:GetName().."BarIcon2"]
			local name = _G[frame:GetName().."BarName"]
			local timer = _G[frame:GetName().."BarTimer"]
			if (icon1.overlay) then
				icon1.overlay = _G[icon1.overlay:GetName()]
			else
				icon1.overlay = CreateFrame("Frame", "$parentIcon1Overlay", tbar)
				icon1.overlay:SetWidth(buttonsize)
				icon1.overlay:SetHeight(buttonsize)
				icon1.overlay:SetFrameStrata("BACKGROUND")
				icon1.overlay:SetPoint("BOTTOMRIGHT", tbar, "BOTTOMLEFT", -buttonsize/4, -2)
				SetTemplate(icon1.overlay)				
			end
			if (icon2.overlay) then
				icon2.overlay = _G[icon2.overlay:GetName()]
			else
				icon2.overlay = CreateFrame("Frame", "$parentIcon2Overlay", tbar)
				icon2.overlay:SetWidth(buttonsize)
				icon2.overlay:SetHeight(buttonsize)
				icon2.overlay:SetFrameStrata("BACKGROUND")
				icon2.overlay:SetPoint("BOTTOMLEFT", tbar, "BOTTOMRIGHT", buttonsize/4, -2)
				SetTemplate(icon2.overlay)
			end
			if bar.color then
				tbar:SetStatusBarColor(bar.color.r, bar.color.g, bar.color.b)
			else
				tbar:SetStatusBarColor(bar.owner.options.StartColorR, bar.owner.options.StartColorG, bar.owner.options.StartColorB)
			end
			if bar.enlarged then frame:SetWidth(bar.owner.options.HugeWidth) else frame:SetWidth(bar.owner.options.Width) end
			if bar.enlarged then tbar:SetWidth(bar.owner.options.HugeWidth) else tbar:SetWidth(bar.owner.options.Width) end
			frame:SetScale(1)
			if not (frame.style==styled) then
				frame:SetHeight(buttonsize/2.5)
				SetTemplate(frame)
				frame.style=styled
			end
			if not (spark.style==styled) then
				spark:SetAlpha(0)
				spark:SetTexture(nil)
				spark.style=styled
			end
			if not (icon1.style==styled) then
				icon1:SetTexCoord(0.08, 0.92, 0.08, 0.92)
				icon1:ClearAllPoints()
				icon1:SetPoint("TOPLEFT", icon1.overlay, 2, -2)
				icon1:SetPoint("BOTTOMRIGHT", icon1.overlay, -2, 2)
				icon1.style=styled
			end
			if not (icon2.style==styled) then
				icon2:SetTexCoord(0.08, 0.92, 0.08, 0.92)
				icon2:ClearAllPoints()
				icon2:SetPoint("TOPLEFT", icon2.overlay, 2, -2)
				icon2:SetPoint("BOTTOMRIGHT", icon2.overlay, -2, 2)
				icon2.style=styled
			end
			texture:SetTexture(tex)
			if not (tbar.style==styled) then
				tbar:ClearAllPoints()
				tbar:SetPoint("TOPLEFT", frame, "TOPLEFT", 2, -2)
				tbar:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT", -2, 2)
				tbar.style=styled
			end
			if not (name.style==styled) then
				name:ClearAllPoints()
				name:SetPoint("BOTTOMLEFT", frame, "TOPLEFT", 0, 4)
				name:SetWidth(165)
				name:SetHeight(8)
				name:SetFont(font, 12, "OUTLINE")
				name:SetJustifyH("LEFT")
				name:SetShadowColor(0, 0, 0, 0)
				name.SetFont = dummy
				name.style=styled
			end
			if not (timer.style==styled) then	
				timer:ClearAllPoints()
				timer:SetPoint("BOTTOMRIGHT", frame, "TOPRIGHT", -1, 2)
				timer:SetFont(font, 12, "OUTLINE")
				timer:SetJustifyH("RIGHT")
				timer:SetShadowColor(0, 0, 0, 0)
				timer.SetFont = dummy
				timer.style=styled
			end
			if bar.owner.options.IconLeft then icon1:Show() icon1.overlay:Show() else icon1:Hide() icon1.overlay:Hide() end
			if bar.owner.options.IconRight then icon2:Show() icon2.overlay:Show() else icon2:Hide() icon2.overlay:Hide() end
			tbar:SetAlpha(1)
			frame:SetAlpha(1)
			texture:SetAlpha(1)
			frame:Show()
			bar:Update(0)
			styled = true
			bar.injected=styled
			end
			bar:ApplyStyle()
		end
	end
end
-- apply range check style
SkinRange = function(self)
	SetTemplate(self)
end
ds:UnregisterEvent"VARIABLES_LOADED"
end)
-- apply bars style
local ApplyStyle=function()
	if SkinBars and type(SkinBars)=="function" then
		SkinBars=SkinBars
	end
	if SkinRange and type(SkinRange)=="function" then
		SkinRange=SkinRange
	end
	hooksecurefunc(DBT,"CreateBar", SkinBars)
	DBM.RangeCheck:Show()
	DBM.RangeCheck:Hide()
	DBMRangeCheck:HookScript("OnShow",SkinRange)
end
local apply=CreateFrame"Frame"
apply:RegisterEvent"VARIABLES_LOADED"
apply:SetScript("OnEvent", function(self) ApplyStyle()
	self:UnregisterEvent"VARIABLES_LOADED"
end)

-- Load DBM varriables on demand
local SetDBM = function()
if(DBM_SavedOptions) then table.wipe(DBM_SavedOptions) end
	DBM_SavedOptions = {
		["SpecialWarningFontSize"] = 50,
		["ShowWarningsInChat"] = false,
		["DontSetIcons"] = false,
		["BigBrotherAnnounceToRaid"] = false,
		["ArrowPosX"] = 0,
		["InfoFrameY"] = -923,
		["SpecialWarningSound"] = "Sound\\Spells\\PVPFlagTaken.wav",
		["AutoRespond"] = true,
		["HealthFrameGrowUp"] = false,
		["StatusEnabled"] = true,
		["HideBossEmoteFrame"] = false,
		["InfoFrameX"] = 1144,
		["ShowBigBrotherOnCombatStart"] = false,
		["BlockVersionUpdatePopup"] = true,
		["AlwaysShowSpeedKillTimer"] = true,
		["RangeFrameY"] = -923,
		["SpecialWarningFont"] = "Fonts\\FRIZQT__.TTF",
		["ArchaeologyHumor"] = true,
		["ArrowPoint"] = "TOP",
		["SpamBlockRaidWarning"] = true,
		["ShowFakedRaidWarnings"] = true,
		["LatencyThreshold"] = 200,
		["DontSendBossAnnounces"] = false,
		["InfoFramePoint"] = "TOPLEFT",
		["SettingsMessageShown"] = true,
		["DontShowBossAnnounces"] = false,
		["HealthFrameLocked"] = false,
		["ArrowPosY"] = -150,
		["RangeFramePoint"] = "TOPLEFT",
		["SpecialWarningPoint"] = "CENTER",
		["AlwaysShowHealthFrame"] = false,
		["RaidWarningSound"] = "Sound\\interface\\RaidWarning.wav",
		["RangeFrameX"] = 1337,
		["FixCLEUOnCombatStart"] = false,
		["SpecialWarningX"] = -0.0001,
		["RangeFrameSound2"] = "none",
		["RangeFrameSound1"] = "none",
		["RaidWarningPosition"] = {
			["Y"] = -219,
			["X"] = 1,
			["Point"] = "TOP",
		},
		["DontSendBossWhispers"] = false,
		["Enabled"] = true,
		["HPFramePoint"] = "CENTER",
		["HealthFrameWidth"] = 200,
		["SpecialWarningY"] = 222,
		["WarningIconLeft"] = true,
		["RangeFrameLocked"] = true,
		["HPFrameY"] = 50,
		["SetCurrentMapOnPull"] = true,
		["HPFrameMaxEntries"] = 5,
		["ShowMinimapButton"] = false,
		["HPFrameX"] = -50,
		["ShowSpecialWarnings"] = true,
		["SpamBlockBossWhispers"] = false,
		["WarningIconRight"] = true,
		["HideTrivializedWarnings"] = false,
	}
if(DBT_SavedOptions) then table.wipe(DBT_SavedOptions) end
	DBT_SavedOptions = {
		["DBM"] = {
			["FontSize"] = 10,
			["HugeTimerY"] = -260,
			["HugeBarXOffset"] = 0,
			["Scale"] = 0.8,
			["IconLeft"] = true,
			["StartColorR"] = 1,
			["HugeWidth"] = 204,
			["TimerX"] = -340,
			["ClickThrough"] = true,
			["IconRight"] = false,
			["EndColorG"] = 0,
			["ExpandUpwards"] = true,
			["TimerPoint"] = "BOTTOM",
			["StartColorG"] = 0.7,
			["StartColorB"] = 0,
			["HugeScale"] = 1,
			["EndColorR"] = 1,
			["Width"] = 179,
			["HugeTimerPoint"] = "CENTER",
			["Font"] = "Fonts\\FRIZQT__.TTF",
			["HugeBarYOffset"] = 0,
			["TimerY"] = 0,
			["HugeTimerX"] = -221,
			["BarYOffset"] = -5,
			["BarXOffset"] = 0,
			["EndColorB"] = 0,
		},
	}
end
SLASH_SETDBM1 = "/setdbm"
SlashCmdList["SETDBM"] = function() SetDBM() ReloadUI() end