local latency = {}
local lbl = " ms"
local format, modf, GetNetStats = _G.string.format, math.modf, GetNetStats
latency.obj = _G.LibStub("LibDataBroker-1.1"):NewDataObject("Broker_Latency", {value = "0"..lbl, text = "0"..lbl})
_G.LibStub("AceTimer-3.0"):Embed(latency)

local function green(x)  return '|cff00ff00'..x..'|r' end
local function red(x)    return '|cffF5591C'..x..'|r' end
local function yellow(x) return '|cffffff00'..x..'|r' end

function latency:Update()
	local _,_,l,w = _G.GetNetStats()
	local sl = ('%.1f'):format(l)
	if l >= 400 then
		self.obj.text = sl..lbl
		self.obj.value = red(sl)..lbl
	elseif l >= 100 then
		self.obj.text = sl..lbl
		self.obj.value = yellow(sl)..lbl
	else
		self.obj.text = sl..lbl
		self.obj.value = green(sl)..lbl
	end
	local sw = ('%.1f'):format(w)
	if w >= 400 then
		wlv = red(sw)..lbl
	elseif w >= 100 then
		wlv = yellow(sw)..lbl
	else
		wlv = green(sw)..lbl
	end
end

local function ColorGradient(perc, r1, g1, b1, r2, g2, b2, r3, g3, b3)
	if perc >= 1 then return r3, g3, b3 elseif perc <= 0 then return r1, g1, b1 end
	local segment, relperc = modf(perc*2)
	if segment == 1 then r1, g1, b1, r2, g2, b2 = r2, g2, b2, r3, g3, b3 end
	return r1 + (r2-r1)*relperc, g1 + (g2-g1)*relperc, b1 + (b2-b1)*relperc
end

function latency.obj.OnTooltipShow(self)
	GameTooltip:AddLine("Задержка и пропускная способность",1,1,1)

	local binz, boutz, _ = GetNetStats()
	local rin, gin, bins = ColorGradient(binz/20, 0,1,0, 1,1,0, 1,0,0)
	local rout, gout, bout = ColorGradient(boutz/5, 0,1,0, 1,1,0, 1,0,0)
	
	GameTooltip:AddDoubleLine("|cffFF7A38Входящая|r пропускная способность:", format("%.2f кб/сек", binz), 1, 1, 1, rin, gin, bins)
	GameTooltip:AddDoubleLine("|cff06ddfaИсходящая|r пропускная способность:", format("%.2f кб/сек", boutz), 1, 1, 1, rout, gout, bout)
	GameTooltip:Show()
	
	GameTooltip:AddDoubleLine("\nЗадержка", "\n"..latency.obj.value, 1, 1, 1, 0, 1, 0)
	GameTooltip:AddDoubleLine("World Latency", wlv, 1, 1, 1, 0, 1, 0)
end

latency:ScheduleRepeatingTimer("Update", 30)
latency:ScheduleTimer("Update", 5)
