local ldb_tip
local frame   = CreateFrame("Button", "Broker_Hatter")
local ldb_obj = LibStub("LibDataBroker-1.1"):NewDataObject("Broker_Hatter", {
	icon     = "Interface\\Icons\\INV_Helmet_120.png",
	label    = "Hatter",
	text     = "Hatter",
	type     = "launcher"
})

local ___show = {}
___show.Helm  = ShowHelm
___show.Cloak = ShowCloak
ShowHelm      = function() end
ShowCloak     = function() end

frame:RegisterEvent"PLAYER_LOGIN"
frame:SetScript("OnEvent", function()
	if not HatterDB or not HatterDB.Init then
		HatterDB = { Helm = true, Cloak = true, Init = true }
	end

	___show.Helm(HatterDB.Helm)
	___show.Cloak(HatterDB.Cloak)
end)

function ldb_obj.OnTooltipShow(tip)
	if not ldb_tip then ldb_tip = tip end

	tip:ClearLines()
	tip:AddLine("Broker_Hatter: A DataBroker Plugin")
	tip:AddLine(" ")
	tip:AddLine("|cffffd700Статус шлема:|r |cffeeeeee"..(HatterDB.Helm and "Shown" or "Hidden").."|r")
	tip:AddLine("|cffffd700Статус плаща:|r |cffeeeeee"..(HatterDB.Cloak and "Shown" or "Hidden").."|r")
	tip:AddLine(" ")
	tip:AddLine("|cff69b950Левый-Клик:|r |cffeeeeeeПереключение шлема|r")
	tip:AddLine("|cff69b950Правый-Клик:|r |cffeeeeeeПереключение плаща|r")
end

function ldb_obj.OnClick(_, which)
	which = which == "LeftButton" and "Helm" or "Cloak"

	local state        = not _G["Showing"..which]()
	HatterDB[which] = state

	___show[which](state)

	ldb_obj.OnTooltipShow(ldb_tip)
end