local addon, ns = ...
local cargBags = ns.cargBags

local m_Bags = cargBags:NewImplementation("m_Bags")	-- Let the magic begin!
m_Bags:RegisterBlizzard() -- register the frame for use with BLizzard's ToggleBag()-functions
--local m_Bags = cargBags:GetImplementation("m_Bags")

-- A highlight function styles the button if they match a certain condition
local function highlightFunction(button, match)
	button:SetAlpha(match and 1 or 0.1)
end

local f = {}

function m_Bags:OnInit()
	-- The filters control which items go into which container
	local INVERTED = -1 -- with inverted filters (using -1), everything goes into this bag when the filter returns false

	local onlyBags =		function(item) return item.bagID >= 0 and item.bagID <= 4 end
	local onlyKeyring =		function(item) return item.bagID == -2 end
	local onlyBank =		function(item) return item.bagID == -1 or item.bagID >= 5 and item.bagID <= 11 end
	local onlyRareEpics =	function(item) return item.rarity and item.rarity > 3 end
	local onlyEpics =		function(item) return item.rarity and item.rarity > 3 end
	local hideJunk =		function(item) return not item.rarity or item.rarity > 0 end
	local hideEmpty =		function(item) return item.texture ~= nil end

	local MyContainer = m_Bags:GetContainerClass()

	-- The settings-table passed in the :New()
	-- Bagpack
	f.main = MyContainer:New("Main", {
			Columns = 10,
			Scale = 0.95,
			Bags = "backpack+bags",
			Movable = true,
	})
	f.main:SetFilter(onlyBags, true)
	f.main:SetPoint("BOTTOMRIGHT", -24*f.main.Settings.Scale, 215*f.main.Settings.Scale) -- bagpack position

	-- Bank frame and bank bags
	f.bank = MyContainer:New("Bank", {
			Columns = 12,
			Scale = f.main.Settings.Scale,
			Bags = "bankframe+bank",
	})
	f.bank:SetFilter(onlyBank, true) -- Take only items from the bank frame
	f.bank:SetPoint("BOTTOMRIGHT", f.main,"BOTTOMLEFT", -25*f.main.Settings.Scale, 0) -- bank frame position
	f.bank:Hide() -- Hide at the beginning
		
	f.key = MyContainer:New("Keyring", {Columns = 10, Scale = 0.95, Bags = "backpack+bags"})
	f.key:SetFilter(onlyKeyring, true)
	f.key:SetPoint("TOPLEFT", f.main,"BOTTOMLEFT", 0, -5*f.main.Settings.Scale) -- bank frame position
	f.key:Hide()
end

-- Bank frame toggling
function m_Bags:OnBankOpened()
	self:GetContainer("Bank"):Show()
end

function m_Bags:OnBankClosed()
	self:GetContainer("Bank"):Hide()
end

-- Class: ItemButton appearencence classification
local MyButton = m_Bags:GetItemButtonClass()
MyButton:Scaffold("Default")
function MyButton:OnUpdate(item)
	-- color the border based on bag type
	local bagType = (select(2, GetContainerNumFreeSlots(self.bagID)));
	-- keyring
	if self.bagID == KEYRING_CONTAINER then
		self.Border:SetVertexColor(1, 0.7, 0.1, 1);
	-- ammo / soulshards
	elseif(bagType and (bagType > 0 and bagType < 8)) then
		self.Border:SetVertexColor(0.85, 0.85, 0.35, 1);
	-- profession bags
	elseif(bagType and bagType > 4) then
		self.Border:SetVertexColor(0.1, 0.65, 0.1, 1);
	-- normal bags
	else
		self.Border:SetVertexColor(.7, .7, .7, .9);
	end
end

--	Class: BagButton is the template for all buttons on the BagBar
local BagButton = m_Bags:GetClass("BagButton", true, "BagButton")
-- We color the CheckedTexture golden, not bright yellow
function BagButton:OnCreate()
	self:GetCheckedTexture():SetVertexColor(0.3, 0.9, 0.9, 0.5)
end

-- Class: Container (Serves as a base for all containers/bags)
-- Fetch our container class that serves as a basis for all our containers/bags

local UpdateDimensions = function(self)
	local width, height = self:LayoutButtons("grid", self.Settings.Columns, 3, 6, -5)
	local margin = 40			-- Normal margin space for infobar
	if self.BagBar and self.BagBar:IsShown() then
		margin = margin + 40	-- Bag button space
	end
	self:SetHeight(height + margin)
end

local MyContainer = m_Bags:GetContainerClass()
function MyContainer:OnContentsChanged()
	-- sort our buttons based on the slotID
	self:SortButtons("bagSlot")
	-- Order the buttons in a layout, ("grid", columns, spacing, xOffset, yOffset) or ("circle", radius (optional), xOffset, yOffset)
	local width, height = self:LayoutButtons("grid", self.Settings.Columns, 3, 6, -5)
	-- function to update our size, reserve space for infobar at top
	self:SetSize(width + 12, height + 12)
	if (self.UpdateDimensions) then self:UpdateDimensions() end -- Update the bag's height
	if self.name == "Keyring" then
		self:SetSize(width + 12, height + 12)
	end
end

-- OnCreate is called every time a new container is created 
function MyContainer:OnCreate(name, settings)
	settings = settings or {}
    self.Settings = settings
	self.UpdateDimensions = UpdateDimensions
	
	self:EnableMouse(true)

	self:SetBackdrop{
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true, tileSize = 10, edgeSize = 8,
		insets = {left = 1, right = 1, top = 1, bottom = 1},
	}
	self:SetBackdropColor(0, 0, 0, 0.9)
	self:SetBackdropBorderColor(0, 0, 0, 0.8)

	self:SetParent(settings.Parent or m_Bags)
	self:SetFrameStrata("HIGH")

	if(settings.Movable) then
		self:SetMovable(true)
		self:RegisterForClicks("LeftButton", "RightButton");
	    self:SetScript("OnMouseDown", function()
			if IsAltKeyDown() then
				self:ClearAllPoints() 
				self:StartMoving()
			end
	    end)
		self:SetScript("OnMouseUp",  self.StopMovingOrSizing)
	end

	settings.Columns = settings.Columns or 10
	self:SetScale(settings.Scale or 1)
	if not (name == "Keyring") then -- don't need all that junk on "other" sections
		-- Creating infoFrame which serves as a basic bar for information and extra buttons
		local infoFrame = CreateFrame("Button", nil, self)
		infoFrame:SetPoint("BOTTOMLEFT", 45, 3)
		infoFrame:SetPoint("BOTTOMRIGHT", -10, 3)
		infoFrame:SetHeight(32)

		-- Plugin: TagDisplay
		-- Creating font strings to display space, currencies, ammo and money
		local space = self:SpawnPlugin("TagDisplay", "[space:free/max] free", infoFrame)
		space:SetFont("Fonts\\FrizQT__.ttf", 14)
		space:SetPoint("LEFT", infoFrame, "LEFT")
		space.bags = cargBags:ParseBags(settings.Bags) -- Temporary until I find a better solution

		-- This one shows currencies, ammo and - most important - money!
		local tagDisplay = self:SpawnPlugin("TagDisplay", "[money]", infoFrame)
		tagDisplay:SetFontObject("NumberFontNormal")
		tagDisplay:SetFont("Fonts\\FrizQT__.ttf", 14)
		tagDisplay:SetPoint("RIGHT", infoFrame, "RIGHT", -20, 0)
		
		-- Plugin: BagBar
		local bagBar = self:SpawnPlugin("BagBar", settings.Bags)
		bagBar:SetSize(bagBar:LayoutButtons("grid", 7))
		bagBar:SetScale(0.75)
		bagBar.highlightFunction = highlightFunction -- from above, optional, used when hovering over bag buttons
		bagBar.isGlobal = nil -- This would make the hover-effect apply to all containers instead of the current one
		bagBar:Hide()
		self.BagBar = bagBar
		
		-- positioning our BagBar
		if(name == "Bank") then
			bagBar:SetPoint("BOTTOMLEFT", self, "BOTTOMLEFT", 15, 46)
		else
			bagBar:SetPoint("BOTTOMLEFT", self, "BOTTOMLEFT", 33, 46)
		end
		-- creating button for toggling BagBar on and off
		self:UpdateDimensions()
		local bagToggle = CreateFrame("CheckButton", nil, self)
		bagToggle:SetHighlightTexture("Interface\\Buttons\\ButtonHilight-Square", "ADD")
		bagToggle:SetWidth(36)
		bagToggle:SetHeight(20)
		bagToggle:SetPoint("RIGHT", infoFrame,"LEFT",-3,0)
		--bagToggle:RegisterForClicks("LeftButtonUp")
		bagToggle:SetScript("OnClick", function()
			if(self.BagBar:IsShown()) then
				self.BagBar:Hide()
			else
				self.BagBar:Show()
			end
				self:UpdateDimensions()
		end)
		local bagToggleText = bagToggle:CreateFontString(nil, "OVERLAY")
		bagToggleText:SetPoint("CENTER", bagToggle)
		bagToggleText:SetFontObject(GameFontNormalSmall)
		bagToggleText:SetFont("Fonts\\FrizQT__.ttf", 14)
		bagToggleText:SetText("Bags")
		
		if(name == "Main") then
			local KRbutton = CreateFrame("CheckButton", nil, bagBar)
			--KRbutton:SetCheckedTexture("Interface\\Buttons\\CheckButtonHilight", "ADD")
			KRbutton:SetHighlightTexture("Interface\\Buttons\\ButtonHilight-Square", "ADD")
			KRbutton:SetWidth(18)
			KRbutton:SetHeight(37)
			KRbutton:RegisterForClicks("LeftButtonUp")

			local KRtexture = KRbutton:CreateTexture()
			KRtexture:SetTexture('Interface/Buttons/UI-Button-KeyRing')
			KRtexture:SetAllPoints(KRbutton)
			KRtexture:SetTexCoord(0, 0.6, 0, 0.6)
			KRbutton:SetPoint("BOTTOMRIGHT", bagBar, "BOTTOMLEFT", -5, 0)
			KRbutton:SetScript("OnClick", function()
                if f.key:IsShown() then
                    f.key:Hide()
                else
                    f.key:Show()
                end
            end)
		end
		-- Plugin: SearchBar
		local searchText = infoFrame:CreateFontString(nil, "OVERLAY")
		searchText:SetPoint("CENTER", infoFrame, "CENTER", -25, 0 )
		searchText:SetFont("Fonts\\FrizQT__.ttf", 14)
		searchText:SetText("Кажмите для поиска")
		-- our searchbar comes up when we click on infoFrame

		local search = self:SpawnPlugin("SearchBar", infoFrame)
		search.highlightFunction = highlightFunction -- same as above, only for search
		search.isGlobal = nil -- This would make the search apply to all containers instead of just this one
		search:SetPoint("BOTTOMRIGHT", infoFrame, -20, 0)

		local closebutton = CreateFrame("Button", nil, self)
		closebutton:SetFrameLevel(30)
		closebutton:SetPoint("BOTTOMRIGHT", -5, 11)
		closebutton:SetSize(20,14)
		
		local closebtex =	"Interface\\AddOns\\m_Loot\\media\\black-close"
		local close = closebutton:CreateTexture(nil, "ARTWORK")
		close:SetTexture(closebtex)
		close:SetTexCoord(0, .7, 0, 1)
		close:SetAllPoints(closebutton)
		close:SetVertexColor(0.5, 0.5, 0.4)
	
		closebutton:SetScript( "OnLeave", function() close:SetVertexColor(0.5, 0.5, 0.4) end )
		closebutton:SetScript( "OnEnter", function() close:SetVertexColor(0.7, 0.2, 0.2) end )
		closebutton:SetScript("OnClick", function(self) 
			if m_Bags:AtBank() and self.name == "Bank" then 
				CloseBankFrame() 
			else 
				CloseAllBags() 
			end 
		end)
	end
end
