  local addon, ns = ...
  local cfg = CreateFrame("Frame")

  -----------------------------
  -- MEDIA
  -----------------------------
  local MediaPath = "Interface\\Addons\\m_ActionBars\\media\\"
  cfg.textures_normal = MediaPath.."icon"
  cfg.textures_pushed = MediaPath.."icon"
  cfg.button_font = "Fonts\\FRIZQT__.TTF"
  
  -----------------------------
  -- CONFIG
  -----------------------------
  --ActionBars config
  cfg.enable_action_bars = true			-- enable action bars modifications
  cfg.enable_totembar = true			-- enable totembar modifications
	cfg.totembar_scale = 1				-- TotemBar scale
	cfg.totembar_enable_timers = true	-- Enable totember timers
	cfg.totembar_alpha = 1				-- Totembar's opacity
  cfg.size = 27							-- setting up default buttons size
  cfg.spacing = 2						-- spacing between buttons
  cfg.hide_side_bars = true				-- hiding LeftBar and RightBar making them available via /extra or /eb command
  cfg.hide_exit_vehicle_button = false	-- exit vehicle button
	cfg.EVB_user_placed = true			-- if set to false exit vehicle button will be always placed at ActionButton8 position
  cfg.hide_micromenu = true				-- hiding MicroMenu making it available via /extra or /eb command
	cfg.micromenu_scale = 0.85			-- Micromenu scale
	cfg.micromenu_onmouseover = false	-- Show micromenu bar on mouse over

  cfg.frame_positions = { 				-- Bars positioning
      [1]  =  { a= "BOTTOM",		x=	0,		y= 212	},  -- MainBar 
      [2]  =  { a= "BOTTOM",		x=	0,		y= 183	},  -- BottomLeftBar
      [3]  =  { a= "BOTTOMRIGHT",	x=	-334,	y= 32	},  -- BottomRightBar
      [4]  =  { a= "BOTTOMRIGHT",	x=	-26,	y= 190	},  -- LeftBar
      [5]  =  { a= "BOTTOMRIGHT",	x=	-26,	y= 225	},  -- RightBar
      [6]  =  { a= "BOTTOMRIGHT",	x=	-250,	y= 260	},  -- ShapeShiftBar
      [7]  =  { a= "BOTTOM",		x=	-292,	y= 343	},  -- PetBar
      [8]  =  { a= "BOTTOM",		x=	-292,	y= 359	},  -- PetBar for Death Knights (due to runebar, MonoUI specific)
      [9]  =  { a= "BOTTOM",		x=	0,  	y= 242	},  -- TotemBar
	  [11] =  { a= "BOTTOMRIGHT",	x=	-26,	y= 305	},  -- MicroMenu
	  [12] =  { a= "BOTTOM",		x=	-2,  	y= 0	},  -- RaidIconBar
	  [13] =  { a= "BOTTOMLEFT",	x=	412,	y= 23	},  -- MarkerFlareBar
	  [14] =  { a= "BOTTOM",		x=	-380,	y= 238	},	-- Vehicle Exit Button custom position if cfg.VEB_user_placed set to 'true'
  }
  cfg.config_mainbar = {		
	--[[orientation:]] "H",			--[[rows(H)/columns(V):]] 1,	--[[buttons:]] 8,	
	--[[button size:]] cfg.size,	--[[spacing between buttons:]] cfg.spacing,
	--[[disable bar:]] false,		--[[show on mouseover:]] false,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0.5
	}
  cfg.config_bottomleftbar = {	
	--[[orientation:]] "H",			--[[rows(H)/columns(V):]] 1,	--[[buttons:]] 8,					
	--[[button size:]] cfg.size,	--[[spacing between buttons:]] cfg.spacing,
	--[[disable bar:]] false,		--[[show on mouseover:]] false,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0.5
  	}
  cfg.config_bottomrightbar = {	
	--[[orientation:]] "V",			--[[rows(H)/columns(V):]] 2,	--[[buttons:]] 8,					
	--[[button size:]] 33,			--[[spacing between buttons:]] cfg.spacing,
	--[[disable bar:]] false,		--[[show on mouseover:]] false,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0
  	}
  cfg.config_leftbar = {		
	--[[orientation:]] "H",			--[[rows(H)/columns(V):]] 1,	--[[buttons:]] 12,
	--[[button size:]] 30, 			--[[spacing between buttons:]] cfg.spacing,
	--[[disable bar:]] false,		--[[show on mouseover:]] false,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0 
 	}
  cfg.config_rightbar = {		
	--[[orientation:]] "H",			--[[rows(H)/columns(V):]] 1,	--[[buttons:]] 12,
	--[[button size:]] 30,			--[[spacing between buttons:]] cfg.spacing,
	--[[disable bar:]] false,		--[[show on mouseover:]] false,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0  
	}
  cfg.config_shapeshiftbar = {	
	--[[orientation:]] "H",			--[[rows(H)/columns(V):]] 1,	--[[buttons:]] 5,	
	--[[button size:]] 30, 			--[[spacing between buttons:]] cfg.spacing,	
	--[[disable bar:]] true,		--[[show on mouseover:]] false,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0  
	}
  cfg.config_petbar = {			
	--[[orientation:]] "H",			--[[rows(H)/columns(V):]] 1,	--[[buttons:]] NUM_PET_ACTION_SLOTS,	
	--[[button size:]] cfg.size,	--[[spacing between buttons:]] cfg.spacing,	
	--[[disable bar:]] false,		--[[show on mouseover:]] true,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] .3  
	}
  cfg.config_raidiconbar = {	
	--[[orientation:]] "H",			--[[button size:]] 20,  		--[[spacing between buttons:]] 3,	
	--[[disable bar:]] false,		--[[show on mouseover:]] true,	--[[show when in combat:]] false,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0.2  
	}
  cfg.config_markerflarebar = {	
	--[[orientation:]] "V",			--[[button size:]] 23,			--[[spacing between buttons:]] cfg.spacing,	
	--[[disable bar:]] false,		--[[show on mouseover:]] true,	--[[show only when in group:]] true,
	--[[bar alpha:]] 1,				--[[fade out alpha:]] 0.2  
	}
  cfg.config_totembar = {	
	--[[enable timers:]] true,		--[[button size:]] 32,			--[[spacing between buttons:]] 8,	
	--[[disable bar:]] false,		--[[bar alpha:]] 1	
	}
  --ButtonsStyler config
  cfg.hide_hotkey = false		-- remove key binding text from the bars
  cfg.hide_macro_name = true	-- remove macro name text from the bars
  cfg.count_font_size = 12		-- remove count text from the bars
  cfg.hotkey_font_size = 11		-- font size for the key bindings text
  cfg.name_font_size = 8		-- font size for the macro name text
  cfg.colors = {
       normal = {r =  0,	g =  0, 	b =  0	},
       pushed = {r =  1,	g =  1, 	b =  1	},
    highlight = {r =  .9,	g =  .8,	b =  .6	},
      checked = {r =  .9,	g =  .8,	b =  .6	},
   outofrange = {r =  .8,	g =  .3, 	b =  .2	},
    outofmana = {r =  .3,	g = .3, 	b =  .7	},
       usable = {r =  1,	g =  1, 	b =  1	},
     unusable = {r = .4,	g = .4, 	b = .4	}
  }
  
  -- HANDOVER
  ns.cfg = cfg
