﻿--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 3.2.4 (<%codename%>)
	Revision: $Id: GatherNodes.lua 923 2010-12-23 08:54:58Z Esamynn $

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	Note 2:
		This file is automatically generated from data collected at
		http://www.wowhead.com/
		If you want to help contribute, please go there, get the client
		and upload your data.
		Wowhead Client: http://www.wowhead.com/?client
]]

Gatherer.Nodes = {}

local region = GetLocale();
if (region == "deDE") then -- German
	Gatherer.Nodes.Names = {
		["Kleine Thoriumader"] = 324, -- Small Thorium Vein
		["Pyrophormineralvorkommen"] = 1610, -- Incendicite Mineral Vein
		["Kupferader"] = 1731, -- Copper Vein
		["Zinnader"] = 1732, -- Tin Vein
		["Silberader"] = 1733, -- Silver Vein
		["Goldader"] = 1734, -- Gold Vein
		["Eisenvorkommen"] = 1735, -- Iron Deposit
		["Mithrilvorkommen"] = 2040, -- Mithril Deposit
		["Echtsilbervorkommen"] = 2047, -- Truesilver Deposit
		["Geringe Blutsteinablagerung"] = 2653, -- Lesser Bloodstone Deposit
		["Geringes Blutsteinvorkommen"] = 2653, -- Lesser Bloodstone Deposit
		["Induriummineralvorkommen"] = 19903, -- Indurium Mineral Vein
		["Schlammbedecktes Silbervorkommen"] = 73940, -- Ooze Covered Silver Vein
		["Schlammbedecktes Goldvorkommen"] = 73941, -- Ooze Covered Gold Vein
		["Schlammbedecktes Echtsilbervorkommen"] = 123309, -- Ooze Covered Truesilver Deposit
		["Schlammbedeckte Mithrilablagerung"] = 123310, -- Ooze Covered Mithril Deposit
		["Schlammbedeckte Thoriumader"] = 123848, -- Ooze Covered Thorium Vein
		["Dunkeleisenvorkommen"] = 165658, -- Dark Iron Deposit
		["Reiche Thoriumader"] = 175404, -- Rich Thorium Vein
		["Schlammbedecktes reiches Thoriumvorkommen"] = 177388, -- Ooze Covered Rich Thorium Vein
		["Hakkari Thoriumvorkommen"] = 180215, -- Hakkari Thorium Vein
		["Teufelseisenvorkommen"] = 181555, -- Fel Iron Deposit
		["Adamantitvorkommen"] = 181556, -- Adamantite Deposit
		["Khoriumader"] = 181557, -- Khorium Vein
		["Reiches Adamantitvorkommen"] = 181569, -- Rich Adamantite Deposit
		["Netheritvorkommen"] = 185877, -- Nethercite Deposit
		["Kobaltvorkommen"] = 189978, -- Cobalt Deposit
		["Reiches Kobaltvorkommen"] = 189979, -- Rich Cobalt Deposit
		["Saronitvorkommen"] = 189980, -- Saronite Deposit
		["Reiches Saronitvorkommen"] = 189981, -- Rich Saronite Deposit
		["Titanader"] = 191133, -- Titanium Vein
		["Titanvorkommen"] = 191133, -- Titanium Vein
		["Obsidiumvorkommen"] = 202736, -- Obsidium Deposit
		["Pyritvorkommen"] = 202737, -- Pyrite Deposit
		["Elementiumader"] = 202738, -- Elementium Vein
		["Gewaltige Obsidiantafel"] = 202739, -- Rich Obsidium Deposit
		["Reiches Obsidiumvorkommen"] = 202739, -- Rich Obsidium Deposit
		["Reiches Pyritvorkommen"] = 202740, -- Rich Pyrite Deposit
		["Reiche Elementiumader"] = 202741, -- Rich Elementium Vein
		["Silberblatt"] = 1617, -- Silverleaf
		["Friedensblume"] = 1618, -- Peacebloom
		["Erdwurzel"] = 1619, -- Earthroot
		["Maguskönigskraut"] = 1620, -- Mageroyal
		["Wilddornrose"] = 1621, -- Briarthorn
		["Beulengras"] = 1622, -- Bruiseweed
		["Wildstahlblume"] = 1623, -- Wild Steelbloom
		["Königsblut"] = 1624, -- Kingsblood
		["Grabmoos"] = 1628, -- Grave Moss
		["Lebenswurz"] = 2041, -- Liferoot
		["Blassblatt"] = 2042, -- Fadeleaf
		["Khadgars Schnurrbart"] = 2043, -- Khadgar's Whisker
		["Drachenzahn"] = 2044, -- Wintersbite
		["Würgetang"] = 2045, -- Stranglekelp
		["Golddorn"] = 2046, -- Goldthorn
		["Feuerblüte"] = 2866, -- Firebloom
		["Lila Lotus"] = 142140, -- Purple Lotus
		["Arthas' Tränen"] = 142141, -- Arthas' Tears
		["Arthas’ Tränen"] = 142141, -- Arthas' Tears
		["Sonnengras"] = 142142, -- Sungrass
		["Blindkraut"] = 142143, -- Blindweed
		["Geisterpilz"] = 142144, -- Ghost Mushroom
		["Gromsblut"] = 142145, -- Gromsblood
		["Goldener Sansam"] = 176583, -- Golden Sansam
		["Traumblatt"] = 176584, -- Dreamfoil
		["Bergsilbersalbei"] = 176586, -- Mountain Silversage
		["Trauermoos"] = 176587, -- Plaguebloom
		["Eiskappe"] = 176588, -- Icecap
		["Schwarzer Lotus"] = 176589, -- Black Lotus
		["Blutdistel"] = 181166, -- Bloodthistle
		["Teufelsgras"] = 181270, -- Felweed
		["Traumwinde"] = 181271, -- Dreaming Glory
		["Zottelkappe"] = 181275, -- Ragveil
		["Flammenkappe"] = 181276, -- Flame Cap
		["Terozapfen"] = 181277, -- Terocone
		["Urflechte"] = 181278, -- Ancient Lichen
		["Netherblüte"] = 181279, -- Netherbloom
		["Alptraumranke"] = 181280, -- Nightmare Vine
		["Manadistel"] = 181281, -- Mana Thistle
		["Netherstaubbusch"] = 185881, -- Netherdust Bush
		["Goldklee"] = 189973, -- Goldclover
		["Tigerlilie"] = 190169, -- Tiger Lily
		["Talandras Rose"] = 190170, -- Talandra's Rose
		["Lichblüte"] = 190171, -- Lichbloom
		["Eisdorn"] = 190172, -- Icethorn
		["Gefrorenes Kraut"] = 190175, -- Frozen Herb
		["Frostlotus"] = 190176, -- Frost Lotus
		["Schlangenzunge"] = 191019, -- Adder's Tongue
		["Feuerdorn"] = 191303, -- Firethorn
		["Aschenblüte"] = 202747, -- Cinderbloom
		["Sturmwinde"] = 202748, -- Stormvine
		["Azsharas Schleier"] = 202749, -- Azshara's Veil
		["Herzblüte"] = 202750, -- Heartblossom
		["Schattenjasmin"] = 202751, -- Twilight Jasmine
		["Gertenrohr"] = 202752, -- Whiptail
		["Versteckte Geldkassette"] = 2039, -- Hidden Strongbox
		["Riesenmuschel"] = 2744, -- Giant Clam
		["Ramponierte Truhe"] = 2843, -- Battered Chest
		["Robuste Truhe"] = 2850, -- Solid Chest
		["Wasserfass"] = 3658, -- Water Barrel
		["Fass Melonensaft"] = 3659, -- Barrel of Melon Juice
		["Rüstungskiste"] = 3660, -- Armor Crate
		["Waffenkiste"] = 3661, -- Weapon Crate
		["Nahrungsmittelkiste"] = 3662, -- Food Crate
		["Fass mit Milch"] = 3705, -- Barrel of Milk
		["Fass mit süßem Nektar"] = 3706, -- Barrel of Sweet Nectar
		["Geldkassette der Allianz"] = 3714, -- Alliance Strongbox
		["Kasten mit verschiedenen Ersatzteilen"] = 19019, -- Box of Assorted Parts
		["Verstreute Kiste"] = 28604, -- Scattered Crate
		["Große eisenbeschlagene Truhe"] = 74447, -- Large Iron Bound Chest
		["Große robuste Truhe"] = 74448, -- Large Solid Chest
		["Große ramponierte Truhe"] = 75293, -- Large Battered Chest
		["Geldkassette des Bukaniers"] = 123330, -- Buccaneer's Strongbox
		["Große mithrilbeschlagene Truhe"] = 131978, -- Large Mithril Bound Chest
		["Große Dunkelholztruhe"] = 131979, -- Large Darkwood Chest
		["Vorratskiste der Horde"] = 142191, -- Horde Supply Crate
		["Erdhaufen von Un'Goro"] = 157936, -- Un'Goro Dirt Pile
		["Blauer Machtkristall"] = 164658, -- Blue Power Crystal
		["Grüner Machtkristall"] = 164659, -- Green Power Crystal
		["Roter Machtkristall"] = 164660, -- Red Power Crystal
		["Gelber Machtkristall"] = 164661, -- Yellow Power Crystal
		["Gesäuberter Nachtdrache"] = 164881, -- Cleansed Night Dragon
		["Gesäuberte Liedblume"] = 164882, -- Cleansed Songflower
		["Gesäuberte Windblüte"] = 164884, -- Cleansed Windblossom
		["Blutblütensprössling"] = 164958, -- Bloodpetal Sprout
		["Gesäuberte Peitscherwurzel"] = 174622, -- Cleansed Whipper Root
		["Blut von Helden"] = 176213, -- Blood of Heroes
		["Schalentierfalle"] = 176582, -- Shellfish Trap
		["Übungsschließkassette"] = 178244, -- Practice Lockbox
		["Ramponierte Schließkiste"] = 179486, -- Battered Footlocker
		["Durchnässte Schließkiste"] = 179487, -- Waterlogged Footlocker
		["Verbeulte Schließkiste"] = 179492, -- Dented Footlocker
		["Moosbedeckte Schließkiste"] = 179493, -- Mossy Footlocker
		["Scharlachrote Schließkiste"] = 179498, -- Scarlet Footlocker
		["Grabtruhe"] = 181665, -- Burial Chest
		["Teufelseisentruhe"] = 181798, -- Fel Iron Chest
		["Schwere Teufelseisentruhe"] = 181800, -- Heavy Fel Iron Chest
		["Adamantitbeschlagene Truhe"] = 181802, -- Adamantite Bound Chest
		["Teufelsstahltruhe"] = 181804, -- Felsteel Chest
		["Glühkappe"] = 182053, -- Glowcap
		["Weidentruhe"] = 184740, -- Wicker Chest
		["Primitive Truhe"] = 184793, -- Primitive Chest
		["Robuste Teufelseisentruhe"] = 184930, -- Solid Fel Iron Chest
		["Beschlagene Teufelseisentruhe"] = 184931, -- Bound Fel Iron Chest
		["Beschlagene Adamantittruhe"] = 184936, -- Bound Adamantite Chest
		["Ei der Netherschwingen"] = 185915, -- Netherwing Egg
		["Immerfrostsplitter"] = 193997, -- Everfrost Chip
		["Archäologischer trollischer Fund"] = 202655, -- Troll Archaeology Find
		["Archäologischer nachtelfischer Fund"] = 203071, -- Night Elf Archaeology Find
		["Archäologischer nerubischer Fund"] = 203078, -- Nerubian Archaeology Find
		["Archäologischer zwergischer Fund"] = 204282, -- Dwarf Archaeology Find
		["Archäologischer fossiler Fund"] = 206836, -- Fossil Archaeology Find
		["Archäologischer orcischer Fund"] = 207187, -- Orc Archaeology Find
		["Archäologischer draeneiischer Fund"] = 207188, -- Draenei Archaeology Find
		["Archäologischer Fund der Vrykul"] = 207189, -- Vrykul Archaeology Find
		["Archäologischer Fund der Tol'vir"] = 207190, -- Tol'vir Archaeology Find
	}
elseif (region == "enUS") then -- Engligh
	Gatherer.Nodes.Names = {
		["Small Thorium Vein"] = 324,
		["Incendicite Mineral Vein"] = 1610,
		["Copper Vein"] = 1731,
		["Tin Vein"] = 1732,
		["Silver Vein"] = 1733,
		["Gold Vein"] = 1734,
		["Iron Deposit"] = 1735,
		["Mithril Deposit"] = 2040,
		["Truesilver Deposit"] = 2047,
		["Lesser Bloodstone Deposit"] = 2653,
		["Indurium Mineral Vein"] = 19903,
		["Ooze Covered Silver Vein"] = 73940,
		["Ooze Covered Gold Vein"] = 73941,
		["Ooze Covered Truesilver Deposit"] = 123309,
		["Ooze Covered Mithril Deposit"] = 123310,
		["Ooze Covered Thorium Vein"] = 123848,
		["Dark Iron Deposit"] = 165658,
		["Rich Thorium Vein"] = 175404,
		["Ooze Covered Rich Thorium Vein"] = 177388,
		["Hakkari Thorium Vein"] = 180215,
		["Fel Iron Deposit"] = 181555,
		["Adamantite Deposit"] = 181556,
		["Khorium Vein"] = 181557,
		["Rich Adamantite Deposit"] = 181569,
		["Nethercite Deposit"] = 185877,
		["Cobalt Deposit"] = 189978,
		["Rich Cobalt Deposit"] = 189979,
		["Saronite Deposit"] = 189980,
		["Rich Saronite Deposit"] = 189981,
		["Titanium Vein"] = 191133,
		["Obsidium Deposit"] = 202736,
		["Pyrite Deposit"] = 202737,
		["Elementium Vein"] = 202738,
		["Rich Obsidium Deposit"] = 202739,
		["Rich Pyrite Deposit"] = 202740,
		["Rich Elementium Vein"] = 202741,
		["Silverleaf"] = 1617,
		["Peacebloom"] = 1618,
		["Earthroot"] = 1619,
		["Mageroyal"] = 1620,
		["Briarthorn"] = 1621,
		["Bruiseweed"] = 1622,
		["Wild Steelbloom"] = 1623,
		["Kingsblood"] = 1624,
		["Grave Moss"] = 1628,
		["Liferoot"] = 2041,
		["Fadeleaf"] = 2042,
		["Khadgar's Whisker"] = 2043,
		["Dragon's Teeth"] = 2044, -- Wintersbite
		["Stranglekelp"] = 2045,
		["Goldthorn"] = 2046,
		["Firebloom"] = 2866,
		["Purple Lotus"] = 142140,
		["Arthas' Tears"] = 142141,
		["Sungrass"] = 142142,
		["Blindweed"] = 142143,
		["Ghost Mushroom"] = 142144,
		["Gromsblood"] = 142145,
		["Golden Sansam"] = 176583,
		["Dreamfoil"] = 176584,
		["Mountain Silversage"] = 176586,
		["Sorrowmoss"] = 176587, -- Plaguebloom
		["Icecap"] = 176588,
		["Black Lotus"] = 176589,
		["Bloodthistle"] = 181166,
		["Felweed"] = 181270,
		["Dreaming Glory"] = 181271,
		["Ragveil"] = 181275,
		["Flame Cap"] = 181276,
		["Terocone"] = 181277,
		["Ancient Lichen"] = 181278,
		["Netherbloom"] = 181279,
		["Nightmare Vine"] = 181280,
		["Mana Thistle"] = 181281,
		["Netherdust Bush"] = 185881,
		["Goldclover"] = 189973,
		["Tiger Lily"] = 190169,
		["Talandra's Rose"] = 190170,
		["Lichbloom"] = 190171,
		["Icethorn"] = 190172,
		["Frozen Herb"] = 190175,
		["Frost Lotus"] = 190176,
		["Adder's Tongue"] = 191019,
		["Firethorn"] = 191303,
		["Cinderbloom"] = 202747,
		["Stormvine"] = 202748,
		["Azshara's Veil"] = 202749,
		["Heartblossom"] = 202750,
		["Twilight Jasmine"] = 202751,
		["Whiptail"] = 202752,
		["Hidden Strongbox"] = 2039,
		["Giant Clam"] = 2744,
		["Battered Chest"] = 2843,
		["Tattered Chest"] = 2844,
		["Solid Chest"] = 2850,
		["Water Barrel"] = 3658,
		["Barrel of Melon Juice"] = 3659,
		["Armor Crate"] = 3660,
		["Weapon Crate"] = 3661,
		["Food Crate"] = 3662,
		["Barrel of Milk"] = 3705,
		["Barrel of Sweet Nectar"] = 3706,
		["Alliance Strongbox"] = 3714,
		["Box of Assorted Parts"] = 19019,
		["Scattered Crate"] = 28604,
		["Large Iron Bound Chest"] = 74447,
		["Large Solid Chest"] = 74448,
		["Large Battered Chest"] = 75293,
		["Buccaneer's Strongbox"] = 123330,
		["Large Mithril Bound Chest"] = 131978,
		["Large Darkwood Chest"] = 131979,
		["Horde Supply Crate"] = 142191,
		["Un'Goro Dirt Pile"] = 157936,
		["Blue Power Crystal"] = 164658,
		["Green Power Crystal"] = 164659,
		["Red Power Crystal"] = 164660,
		["Yellow Power Crystal"] = 164661,
		["Cleansed Night Dragon"] = 164881,
		["Cleansed Songflower"] = 164882,
		["Cleansed Windblossom"] = 164884,
		["Bloodpetal Sprout"] = 164958,
		["Cleansed Whipper Root"] = 174622,
		["Blood of Heroes"] = 176213,
		["Shellfish Trap"] = 176582,
		["Practice Lockbox"] = 178244,
		["Battered Footlocker"] = 179486,
		["Waterlogged Footlocker"] = 179487,
		["Dented Footlocker"] = 179492,
		["Mossy Footlocker"] = 179493,
		["Scarlet Footlocker"] = 179498,
		["Burial Chest"] = 181665,
		["Fel Iron Chest"] = 181798,
		["Heavy Fel Iron Chest"] = 181800,
		["Adamantite Bound Chest"] = 181802,
		["Felsteel Chest"] = 181804,
		["Glowcap"] = 182053,
		["Wicker Chest"] = 184740,
		["Primitive Chest"] = 184793,
		["Solid Fel Iron Chest"] = 184930,
		["Bound Fel Iron Chest"] = 184931,
		["Bound Adamantite Chest"] = 184936,
		["Netherwing Egg"] = 185915,
		["Everfrost Chip"] = 193997,
		["Troll Archaeology Find"] = 202655,
		["Night Elf Archaeology Find"] = 203071,
		["Nerubian Archaeology Find"] = 203078,
		["Dwarf Archaeology Find"] = 204282,
		["Fossil Archaeology Find"] = 206836,
		["Orc Archaeology Find"] = 207187,
		["Draenei Archaeology Find"] = 207188,
		["Vrykul Archaeology Find"] = 207189,
		["Tol'vir Archaeology Find"] = 207190,
	}
elseif (region == "esES") then -- Spanish
	Gatherer.Nodes.Names = {
		["Filón pequeño de torio"] = 324, -- Small Thorium Vein
		["Filón de incendicita"] = 1610, -- Incendicite Mineral Vein
		["Filón de cobre"] = 1731, -- Copper Vein
		["Filón de estaño"] = 1732, -- Tin Vein
		["Filón de plata"] = 1733, -- Silver Vein
		["Filón de oro"] = 1734, -- Gold Vein
		["Depósito de hierro"] = 1735, -- Iron Deposit
		["Depósito de mitril"] = 2040, -- Mithril Deposit
		["Depósito de veraplata"] = 2047, -- Truesilver Deposit
		["Depósito de sangrita inferior"] = 2653, -- Lesser Bloodstone Deposit
		["Filón de indurio"] = 19903, -- Indurium Mineral Vein
		["Filón de plata cubierto de moco"] = 73940, -- Ooze Covered Silver Vein
		["Filón de oro cubierto de moco"] = 73941, -- Ooze Covered Gold Vein
		["Depósito de veraplata cubierta de moco"] = 123309, -- Ooze Covered Truesilver Deposit
		["Depósito de mitril cubierto de moco"] = 123310, -- Ooze Covered Mithril Deposit
		["Filón de torio cubierto de moco"] = 123848, -- Ooze Covered Thorium Vein
		["Depósito de hierro negro"] = 165658, -- Dark Iron Deposit
		["Filón de torio enriquecido"] = 175404, -- Rich Thorium Vein
		["Filón de torio enriquecido cubierto de moco"] = 177388, -- Ooze Covered Rich Thorium Vein
		["Filón de torio de Hakkari"] = 180215, -- Hakkari Thorium Vein
		["Depósito de hierro vil"] = 181555, -- Fel Iron Deposit
		["Depósito de adamantita"] = 181556, -- Adamantite Deposit
		["Filón de korio"] = 181557, -- Khorium Vein
		["Depósito rico en adamantita"] = 181569, -- Rich Adamantite Deposit
		["Depósito de abisalita"] = 185877, -- Nethercite Deposit
		["Depósito de cobalto"] = 189978, -- Cobalt Deposit
		["Depósito de cobalto rico"] = 189979, -- Rich Cobalt Deposit
		["Depósito de saronita"] = 189980, -- Saronite Deposit
		["Depósito de saronita rico"] = 189981, -- Rich Saronite Deposit
		["Filón de titanio"] = 191133, -- Titanium Vein
		["Depósito de obsidium"] = 202736, -- Obsidium Deposit
		["Depósito de pirita"] = 202737, -- Pyrite Deposit
		["Filón de elementium"] = 202738, -- Elementium Vein
		["Depósito de obsidium rico"] = 202739, -- Rich Obsidium Deposit
		["Depósito de pirita rico"] = 202740, -- Rich Pyrite Deposit
		["Filón de elementium rico"] = 202741, -- Rich Elementium Vein
		["Hojaplata"] = 1617, -- Silverleaf
		["Flor de paz"] = 1618, -- Peacebloom
		["Raíz de tierra"] = 1619, -- Earthroot
		["Marregal"] = 1620, -- Mageroyal
		["Brezospina"] = 1621, -- Briarthorn
		["Hierba cardenal"] = 1622, -- Bruiseweed
		["Acérita salvaje"] = 1623, -- Wild Steelbloom
		["Sangrerregia"] = 1624, -- Kingsblood
		["Musgo de tumba"] = 1628, -- Grave Moss
		["Vidarraíz"] = 2041, -- Liferoot
		["Pálida"] = 2042, -- Fadeleaf
		["Mostacho de Khadgar"] = 2043, -- Khadgar's Whisker
		["Dientes de dragón"] = 2044, -- Wintersbite
		["Alga estranguladora"] = 2045, -- Stranglekelp
		["Espina de oro"] = 2046, -- Goldthorn
		["Flor de Fuego"] = 2866, -- Firebloom
		["Flor de fuego"] = 2866, -- Firebloom
		["Loto cárdeno"] = 142140, -- Purple Lotus
		["Lágrimas de Arthas"] = 142141, -- Arthas' Tears
		["Solea"] = 142142, -- Sungrass
		["Carolina"] = 142143, -- Blindweed
		["Champiñón fantasma"] = 142144, -- Ghost Mushroom
		["Gromsanguina"] = 142145, -- Gromsblood
		["Sansam dorado"] = 176583, -- Golden Sansam
		["Hojasueño"] = 176584, -- Dreamfoil
		["Salviargenta de montaña"] = 176586, -- Mountain Silversage
		["Musgopena"] = 176587, -- Plaguebloom
		["Setelo"] = 176588, -- Icecap
		["Loto negro"] = 176589, -- Black Lotus
		["Cardo de sangre"] = 181166, -- Bloodthistle
		["Hierba vil"] = 181270, -- Felweed
		["Gloria de ensueño"] = 181271, -- Dreaming Glory
		["Velada"] = 181275, -- Ragveil
		["Copo de llamas"] = 181276, -- Flame Cap
		["Teropiña"] = 181277, -- Terocone
		["Liquen antiguo"] = 181278, -- Ancient Lichen
		["Flor abisal"] = 181279, -- Netherbloom
		["Vid pesadilla"] = 181280, -- Nightmare Vine
		["Cardo de maná"] = 181281, -- Mana Thistle
		["Arbusto de polvo abisal"] = 185881, -- Netherdust Bush
		["Trébol de oro"] = 189973, -- Goldclover
		["Lirio atigrado"] = 190169, -- Tiger Lily
		["Rosa de Talandra"] = 190170, -- Talandra's Rose
		["Flor exánime"] = 190171, -- Lichbloom
		["Espina de hielo"] = 190172, -- Icethorn
		["Hierba congelada"] = 190175, -- Frozen Herb
		["Hierba de escarcha"] = 190175, -- Frozen Herb
		["Loto de escarcha"] = 190176, -- Frost Lotus
		["Lengua de víboris"] = 191019, -- Adder's Tongue
		["Espino de fuego"] = 191303, -- Firethorn
		["Flor de ceniza"] = 202747, -- Cinderbloom
		["Viñaviento"] = 202748, -- Stormvine
		["Velo de Azshara"] = 202749, -- Azshara's Veil
		["Flor de corazón"] = 202750, -- Heartblossom
		["Jazmín Crepuscular"] = 202751, -- Twilight Jasmine
		["Colátigo"] = 202752, -- Whiptail
		["Caja fuerte oculta"] = 2039, -- Hidden Strongbox
		["Almeja gigante"] = 2744, -- Giant Clam
		["Cofre maltrecho"] = 2843, -- Battered Chest
		["Cofre ajado"] = 2844, -- Tattered Chest
		["Cofre macizo"] = 2850, -- Solid Chest
		["Barrica de agua"] = 3658, -- Water Barrel
		["Barrica de zumo de melón"] = 3659, -- Barrel of Melon Juice
		["Cajón de armaduras"] = 3660, -- Armor Crate
		["Cajón de armas"] = 3661, -- Weapon Crate
		["Cajón de comida"] = 3662, -- Food Crate
		["Barrica de leche"] = 3705, -- Barrel of Milk
		["Barrica de néctar dulce"] = 3706, -- Barrel of Sweet Nectar
		["Caja fuerte de la Alianza"] = 3714, -- Alliance Strongbox
		["Caja de colección de piezas"] = 19019, -- Box of Assorted Parts
		["Cajón destrozado"] = 28604, -- Scattered Crate
		["Cofre reforzado con hierro grande"] = 74447, -- Large Iron Bound Chest
		["Cofre macizo grande"] = 74448, -- Large Solid Chest
		["Cofre grande abollado"] = 75293, -- Large Battered Chest
		["Caja fuerte de bucanero"] = 123330, -- Buccaneer's Strongbox
		["Cofre reforzado con mitril grande"] = 131978, -- Large Mithril Bound Chest
		["Cofre grande de Leñoscuro"] = 131979, -- Large Darkwood Chest
		["Cajón de suministros de la Horda"] = 142191, -- Horde Supply Crate
		["Montón de porquería de Un'Goro"] = 157936, -- Un'Goro Dirt Pile
		["Cristal de poder azul"] = 164658, -- Blue Power Crystal
		["Cristal de poder verde"] = 164659, -- Green Power Crystal
		["Cristal de poder rojo"] = 164660, -- Red Power Crystal
		["Cristal de poder amarillo"] = 164661, -- Yellow Power Crystal
		["Dragón nocturno limpio"] = 164881, -- Cleansed Night Dragon
		["Melodía limpia"] = 164882, -- Cleansed Songflower
		["Flor del viento limpia"] = 164884, -- Cleansed Windblossom
		["Brote Sangrepétalo"] = 164958, -- Bloodpetal Sprout
		["Brote pétalo de sangre"] = 164958, -- Bloodpetal Sprout
		["Blancoria limpia"] = 174622, -- Cleansed Whipper Root
		["Sangre de Héroes"] = 176213, -- Blood of Heroes
		["Sangre de héroes"] = 176213, -- Blood of Heroes
		["Trampa para marisco"] = 176582, -- Shellfish Trap
		["Arcón de prácticas"] = 178244, -- Practice Lockbox
		["Baúl maltrecho"] = 179486, -- Battered Footlocker
		["Baúl con marcas de agua"] = 179487, -- Waterlogged Footlocker
		["Baúl abollado"] = 179492, -- Dented Footlocker
		["Baúl mohoso"] = 179493, -- Mossy Footlocker
		["Baúl Escarlata"] = 179498, -- Scarlet Footlocker
		["Sarcófago"] = 181665, -- Burial Chest
		["Cofre de hierro vil"] = 181798, -- Fel Iron Chest
		["Cofre pesado de hierro vil"] = 181800, -- Heavy Fel Iron Chest
		["Cofre reforzado con adamantita"] = 181802, -- Adamantite Bound Chest
		["Cofre de acero vil"] = 181804, -- Felsteel Chest
		["Fluochampiñón"] = 182053, -- Glowcap
		["Cofre de mimbre"] = 184740, -- Wicker Chest
		["Cofre primitivo"] = 184793, -- Primitive Chest
		["Cofre sólido de hierro vil"] = 184930, -- Solid Fel Iron Chest
		["Cofre de hierro vil vinculado"] = 184931, -- Bound Fel Iron Chest
		["Huevo de Ala Abisal"] = 185915, -- Netherwing Egg
		["Esquirla de siemprescarcha"] = 193997, -- Everfrost Chip
		["Hallazgo arqueológico de los trols"] = 202655, -- Troll Archaeology Find
		["Hallazgo arqueológico de los elfos de la noche"] = 203071, -- Night Elf Archaeology Find
		["Hallazgo arqueológico nerubiano"] = 203078, -- Nerubian Archaeology Find
		["Hallazgo arqueológico de los enanos"] = 204282, -- Dwarf Archaeology Find
		["Hallazgo arqueológico fósil"] = 206836, -- Fossil Archaeology Find
		["Hallazgo arqueológico de los orcos"] = 207187, -- Orc Archaeology Find
		["Hallazgo arqueológico de los draenei"] = 207188, -- Draenei Archaeology Find
		["Vrykul Archaeology Chest 01"] = 207189, -- Vrykul Archaeology Find
		["Hallazgo arqueológico de los Tol'vir"] = 207190, -- Tol'vir Archaeology Find
	}
elseif (region == "esMX") then -- Latin American Spanish (Mapped from esES)
	Gatherer.Nodes.Names = {
		["Filón pequeño de torio"] = 324, -- Small Thorium Vein
		["Filón de incendicita"] = 1610, -- Incendicite Mineral Vein
		["Filón de cobre"] = 1731, -- Copper Vein
		["Filón de estaño"] = 1732, -- Tin Vein
		["Filón de plata"] = 1733, -- Silver Vein
		["Filón de oro"] = 1734, -- Gold Vein
		["Depósito de hierro"] = 1735, -- Iron Deposit
		["Depósito de mitril"] = 2040, -- Mithril Deposit
		["Depósito de veraplata"] = 2047, -- Truesilver Deposit
		["Depósito de sangrita inferior"] = 2653, -- Lesser Bloodstone Deposit
		["Filón de indurio"] = 19903, -- Indurium Mineral Vein
		["Filón de plata cubierto de moco"] = 73940, -- Ooze Covered Silver Vein
		["Filón de oro cubierto de moco"] = 73941, -- Ooze Covered Gold Vein
		["Depósito de veraplata cubierta de moco"] = 123309, -- Ooze Covered Truesilver Deposit
		["Depósito de mitril cubierto de moco"] = 123310, -- Ooze Covered Mithril Deposit
		["Filón de torio cubierto de moco"] = 123848, -- Ooze Covered Thorium Vein
		["Depósito de hierro negro"] = 165658, -- Dark Iron Deposit
		["Filón de torio enriquecido"] = 175404, -- Rich Thorium Vein
		["Filón de torio enriquecido cubierto de moco"] = 177388, -- Ooze Covered Rich Thorium Vein
		["Filón de torio de Hakkari"] = 180215, -- Hakkari Thorium Vein
		["Depósito de hierro vil"] = 181555, -- Fel Iron Deposit
		["Depósito de adamantita"] = 181556, -- Adamantite Deposit
		["Filón de korio"] = 181557, -- Khorium Vein
		["Depósito rico en adamantita"] = 181569, -- Rich Adamantite Deposit
		["Depósito de abisalita"] = 185877, -- Nethercite Deposit
		["Depósito de cobalto"] = 189978, -- Cobalt Deposit
		["Depósito de cobalto rico"] = 189979, -- Rich Cobalt Deposit
		["Depósito de saronita"] = 189980, -- Saronite Deposit
		["Depósito de saronita rico"] = 189981, -- Rich Saronite Deposit
		["Filón de titanio"] = 191133, -- Titanium Vein
		["Depósito de obsidium"] = 202736, -- Obsidium Deposit
		["Depósito de pirita"] = 202737, -- Pyrite Deposit
		["Filón de elementium"] = 202738, -- Elementium Vein
		["Depósito de obsidium rico"] = 202739, -- Rich Obsidium Deposit
		["Depósito de pirita rico"] = 202740, -- Rich Pyrite Deposit
		["Filón de elementium rico"] = 202741, -- Rich Elementium Vein
		["Hojaplata"] = 1617, -- Silverleaf
		["Flor de paz"] = 1618, -- Peacebloom
		["Raíz de tierra"] = 1619, -- Earthroot
		["Marregal"] = 1620, -- Mageroyal
		["Brezospina"] = 1621, -- Briarthorn
		["Hierba cardenal"] = 1622, -- Bruiseweed
		["Acérita salvaje"] = 1623, -- Wild Steelbloom
		["Sangrerregia"] = 1624, -- Kingsblood
		["Musgo de tumba"] = 1628, -- Grave Moss
		["Vidarraíz"] = 2041, -- Liferoot
		["Pálida"] = 2042, -- Fadeleaf
		["Mostacho de Khadgar"] = 2043, -- Khadgar's Whisker
		["Dientes de dragón"] = 2044, -- Wintersbite
		["Alga estranguladora"] = 2045, -- Stranglekelp
		["Espina de oro"] = 2046, -- Goldthorn
		["Flor de Fuego"] = 2866, -- Firebloom
		["Flor de fuego"] = 2866, -- Firebloom
		["Loto cárdeno"] = 142140, -- Purple Lotus
		["Lágrimas de Arthas"] = 142141, -- Arthas' Tears
		["Solea"] = 142142, -- Sungrass
		["Carolina"] = 142143, -- Blindweed
		["Champiñón fantasma"] = 142144, -- Ghost Mushroom
		["Gromsanguina"] = 142145, -- Gromsblood
		["Sansam dorado"] = 176583, -- Golden Sansam
		["Hojasueño"] = 176584, -- Dreamfoil
		["Salviargenta de montaña"] = 176586, -- Mountain Silversage
		["Musgopena"] = 176587, -- Plaguebloom
		["Setelo"] = 176588, -- Icecap
		["Loto negro"] = 176589, -- Black Lotus
		["Cardo de sangre"] = 181166, -- Bloodthistle
		["Hierba vil"] = 181270, -- Felweed
		["Gloria de ensueño"] = 181271, -- Dreaming Glory
		["Velada"] = 181275, -- Ragveil
		["Copo de llamas"] = 181276, -- Flame Cap
		["Teropiña"] = 181277, -- Terocone
		["Liquen antiguo"] = 181278, -- Ancient Lichen
		["Flor abisal"] = 181279, -- Netherbloom
		["Vid pesadilla"] = 181280, -- Nightmare Vine
		["Cardo de maná"] = 181281, -- Mana Thistle
		["Arbusto de polvo abisal"] = 185881, -- Netherdust Bush
		["Trébol de oro"] = 189973, -- Goldclover
		["Lirio atigrado"] = 190169, -- Tiger Lily
		["Rosa de Talandra"] = 190170, -- Talandra's Rose
		["Flor exánime"] = 190171, -- Lichbloom
		["Espina de hielo"] = 190172, -- Icethorn
		["Hierba congelada"] = 190175, -- Frozen Herb
		["Hierba de escarcha"] = 190175, -- Frozen Herb
		["Loto de escarcha"] = 190176, -- Frost Lotus
		["Lengua de víboris"] = 191019, -- Adder's Tongue
		["Espino de fuego"] = 191303, -- Firethorn
		["Flor de ceniza"] = 202747, -- Cinderbloom
		["Viñaviento"] = 202748, -- Stormvine
		["Velo de Azshara"] = 202749, -- Azshara's Veil
		["Flor de corazón"] = 202750, -- Heartblossom
		["Jazmín Crepuscular"] = 202751, -- Twilight Jasmine
		["Colátigo"] = 202752, -- Whiptail
		["Caja fuerte oculta"] = 2039, -- Hidden Strongbox
		["Almeja gigante"] = 2744, -- Giant Clam
		["Cofre maltrecho"] = 2843, -- Battered Chest
		["Cofre ajado"] = 2844, -- Tattered Chest
		["Cofre macizo"] = 2850, -- Solid Chest
		["Barrica de agua"] = 3658, -- Water Barrel
		["Barrica de zumo de melón"] = 3659, -- Barrel of Melon Juice
		["Cajón de armaduras"] = 3660, -- Armor Crate
		["Cajón de armas"] = 3661, -- Weapon Crate
		["Cajón de comida"] = 3662, -- Food Crate
		["Barrica de leche"] = 3705, -- Barrel of Milk
		["Barrica de néctar dulce"] = 3706, -- Barrel of Sweet Nectar
		["Caja fuerte de la Alianza"] = 3714, -- Alliance Strongbox
		["Caja de colección de piezas"] = 19019, -- Box of Assorted Parts
		["Cajón destrozado"] = 28604, -- Scattered Crate
		["Cofre reforzado con hierro grande"] = 74447, -- Large Iron Bound Chest
		["Cofre macizo grande"] = 74448, -- Large Solid Chest
		["Cofre grande abollado"] = 75293, -- Large Battered Chest
		["Caja fuerte de bucanero"] = 123330, -- Buccaneer's Strongbox
		["Cofre reforzado con mitril grande"] = 131978, -- Large Mithril Bound Chest
		["Cofre grande de Leñoscuro"] = 131979, -- Large Darkwood Chest
		["Cajón de suministros de la Horda"] = 142191, -- Horde Supply Crate
		["Montón de porquería de Un'Goro"] = 157936, -- Un'Goro Dirt Pile
		["Cristal de poder azul"] = 164658, -- Blue Power Crystal
		["Cristal de poder verde"] = 164659, -- Green Power Crystal
		["Cristal de poder rojo"] = 164660, -- Red Power Crystal
		["Cristal de poder amarillo"] = 164661, -- Yellow Power Crystal
		["Dragón nocturno limpio"] = 164881, -- Cleansed Night Dragon
		["Melodía limpia"] = 164882, -- Cleansed Songflower
		["Flor del viento limpia"] = 164884, -- Cleansed Windblossom
		["Brote Sangrepétalo"] = 164958, -- Bloodpetal Sprout
		["Brote pétalo de sangre"] = 164958, -- Bloodpetal Sprout
		["Blancoria limpia"] = 174622, -- Cleansed Whipper Root
		["Sangre de Héroes"] = 176213, -- Blood of Heroes
		["Sangre de héroes"] = 176213, -- Blood of Heroes
		["Trampa para marisco"] = 176582, -- Shellfish Trap
		["Arcón de prácticas"] = 178244, -- Practice Lockbox
		["Baúl maltrecho"] = 179486, -- Battered Footlocker
		["Baúl con marcas de agua"] = 179487, -- Waterlogged Footlocker
		["Baúl abollado"] = 179492, -- Dented Footlocker
		["Baúl mohoso"] = 179493, -- Mossy Footlocker
		["Baúl Escarlata"] = 179498, -- Scarlet Footlocker
		["Sarcófago"] = 181665, -- Burial Chest
		["Cofre de hierro vil"] = 181798, -- Fel Iron Chest
		["Cofre pesado de hierro vil"] = 181800, -- Heavy Fel Iron Chest
		["Cofre reforzado con adamantita"] = 181802, -- Adamantite Bound Chest
		["Cofre de acero vil"] = 181804, -- Felsteel Chest
		["Fluochampiñón"] = 182053, -- Glowcap
		["Cofre de mimbre"] = 184740, -- Wicker Chest
		["Cofre primitivo"] = 184793, -- Primitive Chest
		["Cofre sólido de hierro vil"] = 184930, -- Solid Fel Iron Chest
		["Cofre de hierro vil vinculado"] = 184931, -- Bound Fel Iron Chest
		["Huevo de Ala Abisal"] = 185915, -- Netherwing Egg
		["Esquirla de siemprescarcha"] = 193997, -- Everfrost Chip
		["Hallazgo arqueológico de los trols"] = 202655, -- Troll Archaeology Find
		["Hallazgo arqueológico de los elfos de la noche"] = 203071, -- Night Elf Archaeology Find
		["Hallazgo arqueológico nerubiano"] = 203078, -- Nerubian Archaeology Find
		["Hallazgo arqueológico de los enanos"] = 204282, -- Dwarf Archaeology Find
		["Hallazgo arqueológico fósil"] = 206836, -- Fossil Archaeology Find
		["Hallazgo arqueológico de los orcos"] = 207187, -- Orc Archaeology Find
		["Hallazgo arqueológico de los draenei"] = 207188, -- Draenei Archaeology Find
		["Vrykul Archaeology Chest 01"] = 207189, -- Vrykul Archaeology Find
		["Hallazgo arqueológico de los Tol'vir"] = 207190, -- Tol'vir Archaeology Find
	}
elseif (region == "frFR") then -- French
	Gatherer.Nodes.Names = {
		["Petit filon de thorium"] = 324, -- Small Thorium Vein
		["Filon d'incendicite"] = 1610, -- Incendicite Mineral Vein
		["Filon de cuivre"] = 1731, -- Copper Vein
		["Filon d'étain"] = 1732, -- Tin Vein
		["Filon d'argent"] = 1733, -- Silver Vein
		["Filon d'or"] = 1734, -- Gold Vein
		["Gisement de fer"] = 1735, -- Iron Deposit
		["Gisement de mithril"] = 2040, -- Mithril Deposit
		["Gisement de vrai-argent"] = 2047, -- Truesilver Deposit
		["Gisement de pierre de sang inférieure"] = 2653, -- Lesser Bloodstone Deposit
		["Filon d'indurium"] = 19903, -- Indurium Mineral Vein
		["Filon d'argent couvert de limon"] = 73940, -- Ooze Covered Silver Vein
		["Filon d'or couvert de limon"] = 73941, -- Ooze Covered Gold Vein
		["Gisement de vrai-argent couvert de vase"] = 123309, -- Ooze Covered Truesilver Deposit
		["Gisement de mithril couvert de vase"] = 123310, -- Ooze Covered Mithril Deposit
		["Filon de thorium couvert de limon"] = 123848, -- Ooze Covered Thorium Vein
		["Gisement de sombrefer"] = 165658, -- Dark Iron Deposit
		["Riche filon de thorium"] = 175404, -- Rich Thorium Vein
		["Riche filon de thorium couvert de limon"] = 177388, -- Ooze Covered Rich Thorium Vein
		["Filon de thorium Hakkari"] = 180215, -- Hakkari Thorium Vein
		["Gisement de gangrefer"] = 181555, -- Fel Iron Deposit
		["Gisement d'adamantite"] = 181556, -- Adamantite Deposit
		["Filon de khorium"] = 181557, -- Khorium Vein
		["Riche gisement d'adamantite"] = 181569, -- Rich Adamantite Deposit
		["Gisement de néanticite"] = 185877, -- Nethercite Deposit
		["Gisement de cobalt"] = 189978, -- Cobalt Deposit
		["Riche gisement de cobalt"] = 189979, -- Rich Cobalt Deposit
		["Gisement de saronite"] = 189980, -- Saronite Deposit
		["Riche gisement de saronite"] = 189981, -- Rich Saronite Deposit
		["Veine de titane"] = 191133, -- Titanium Vein
		["Morceau d'obsidium"] = 202736, -- Obsidium Deposit
		["Gisement de pyrite"] = 202737, -- Pyrite Deposit
		["Filon d'élémentium"] = 202738, -- Elementium Vein
		["Enorme bloc d'obsidium"] = 202739, -- Rich Obsidium Deposit
		["Riche gisement de pyrite"] = 202740, -- Rich Pyrite Deposit
		["Riche filon d'élémentium"] = 202741, -- Rich Elementium Vein
		["Feuillargent"] = 1617, -- Silverleaf
		["Pacifique"] = 1618, -- Peacebloom
		["Terrestrine"] = 1619, -- Earthroot
		["Mage royal"] = 1620, -- Mageroyal
		["Eglantine"] = 1621, -- Briarthorn
		["Doulourante"] = 1622, -- Bruiseweed
		["Aciérite sauvage"] = 1623, -- Wild Steelbloom
		["Sang-royal"] = 1624, -- Kingsblood
		["Tombeline"] = 1628, -- Grave Moss
		["Vietérule"] = 2041, -- Liferoot
		["Pâlerette"] = 2042, -- Fadeleaf
		["Moustache de Khadgar"] = 2043, -- Khadgar's Whisker
		["Dents de dragon"] = 2044, -- Wintersbite
		["Etouffante"] = 2045, -- Stranglekelp
		["Dorépine"] = 2046, -- Goldthorn
		["Fleur de feu"] = 2866, -- Firebloom
		["Lotus pourpre"] = 142140, -- Purple Lotus
		["Larmes d'Arthas"] = 142141, -- Arthas' Tears
		["Soleillette"] = 142142, -- Sungrass
		["Aveuglette"] = 142143, -- Blindweed
		["Champignon fantôme"] = 142144, -- Ghost Mushroom
		["Gromsang"] = 142145, -- Gromsblood
		["Sansam doré"] = 176583, -- Golden Sansam
		["Feuillerêve"] = 176584, -- Dreamfoil
		["Sauge-argent des montagnes"] = 176586, -- Mountain Silversage
		["Chagrinelle"] = 176587, -- Plaguebloom
		["Chapeglace"] = 176588, -- Icecap
		["Lotus noir"] = 176589, -- Black Lotus
		["Chardon sanglant"] = 181166, -- Bloodthistle
		["Gangrelette"] = 181270, -- Felweed
		["Glaurier"] = 181271, -- Dreaming Glory
		["Voile-misère"] = 181275, -- Ragveil
		["Chapeflamme"] = 181276, -- Flame Cap
		["Terocône"] = 181277, -- Terocone
		["Lichen ancien"] = 181278, -- Ancient Lichen
		["Néantine"] = 181279, -- Netherbloom
		["Cauchemardelle"] = 181280, -- Nightmare Vine
		["Chardon de mana"] = 181281, -- Mana Thistle
		["Buisson de pruinéante"] = 185881, -- Netherdust Bush
		["Trèfle doré"] = 189973, -- Goldclover
		["Lys tigré"] = 190169, -- Tiger Lily
		["Rose de Talandra"] = 190170, -- Talandra's Rose
		["Fleur-de-liche"] = 190171, -- Lichbloom
		["Glacépine"] = 190172, -- Icethorn
		["Herbe gelée"] = 190175, -- Frozen Herb
		["Lotus givré"] = 190176, -- Frost Lotus
		["Langue de serpent"] = 191019, -- Adder's Tongue
		["Epine de feu"] = 191303, -- Firethorn
		["Cendrelle"] = 202747, -- Cinderbloom
		["Vignétincelle"] = 202748, -- Stormvine
		["Voile d'Azshara"] = 202749, -- Azshara's Veil
		["Pétale de cœur"] = 202750, -- Heartblossom
		["Jasmin crépusculaire"] = 202751, -- Twilight Jasmine
		["Fouettine"] = 202752, -- Whiptail
		["Coffre dissimulé"] = 2039, -- Hidden Strongbox
		["Palourde géante"] = 2744, -- Giant Clam
		["Coffre endommagé"] = 2843, -- Battered Chest
		["Coffre en morceaux"] = 2844, -- Tattered Chest
		["Coffre solide"] = 2850, -- Solid Chest
		["Baril d'eau"] = 3658, -- Water Barrel
		["Tonneau d'eau"] = 3658, -- Water Barrel
		["Tonneau de jus de melon"] = 3659, -- Barrel of Melon Juice
		["Caisse d'armures"] = 3660, -- Armor Crate
		["Caisse d'armes"] = 3661, -- Weapon Crate
		["Caisse de nourriture"] = 3662, -- Food Crate
		["Tonneau de lait"] = 3705, -- Barrel of Milk
		["Tonneau de nectar sucré"] = 3706, -- Barrel of Sweet Nectar
		["Coffre de l'Alliance"] = 3714, -- Alliance Strongbox
		["Boîte de pièces assorties"] = 19019, -- Box of Assorted Parts
		["Caisse éparpillée"] = 28604, -- Scattered Crate
		["Grand coffre cerclé de fer"] = 74447, -- Large Iron Bound Chest
		["Grand coffre solide"] = 74448, -- Large Solid Chest
		["Grand coffre endommagé"] = 75293, -- Large Battered Chest
		["Coffre du boucanier"] = 123330, -- Buccaneer's Strongbox
		["Grand coffre cerclé de mithril"] = 131978, -- Large Mithril Bound Chest
		["Grand coffre de sombrebois"] = 131979, -- Large Darkwood Chest
		["Caisse de ravitaillement de la Horde"] = 142191, -- Horde Supply Crate
		["Tas de poussière d'Un'Goro"] = 157936, -- Un'Goro Dirt Pile
		["Cristal de puissance bleu"] = 164658, -- Blue Power Crystal
		["Cristal de puissance vert"] = 164659, -- Green Power Crystal
		["Cristal de puissance rouge"] = 164660, -- Red Power Crystal
		["Cristal de puissance jaune"] = 164661, -- Yellow Power Crystal
		["Dragon nocturne purifié"] = 164881, -- Cleansed Night Dragon
		["Fleur-de-chant purifiée"] = 164882, -- Cleansed Songflower
		["Fleur-de-vent purifiée"] = 164884, -- Cleansed Windblossom
		["Pousse de Pétale-de-sang"] = 164958, -- Bloodpetal Sprout
		["Navetille purifiée"] = 174622, -- Cleansed Whipper Root
		["Sang des héros"] = 176213, -- Blood of Heroes
		["Casier à crustacés"] = 176582, -- Shellfish Trap
		["Coffret d'entraînement"] = 178244, -- Practice Lockbox
		["Cantine endommagée"] = 179486, -- Battered Footlocker
		["Cantine détrempée"] = 179487, -- Waterlogged Footlocker
		["Cantine abîmée"] = 179492, -- Dented Footlocker
		["Cantine moisie"] = 179493, -- Mossy Footlocker
		["Cantine écarlate"] = 179498, -- Scarlet Footlocker
		["Coffre funéraire"] = 181665, -- Burial Chest
		["Coffre en gangrefer"] = 181798, -- Fel Iron Chest
		["Coffre lourd en gangrefer"] = 181800, -- Heavy Fel Iron Chest
		["Coffre cerclé d'adamantite"] = 181802, -- Adamantite Bound Chest
		["Coffre en gangracier"] = 181804, -- Felsteel Chest
		["Chapeluisant"] = 182053, -- Glowcap
		["Coffre en osier"] = 184740, -- Wicker Chest
		["Coffre primitif"] = 184793, -- Primitive Chest
		["Coffre solide en gangrefer"] = 184930, -- Solid Fel Iron Chest
		["Coffre cerclé de gangrefer"] = 184931, -- Bound Fel Iron Chest
		["Œuf de l'Aile-du-Néant"] = 185915, -- Netherwing Egg
		["Morceau de permagivre"] = 193997, -- Everfrost Chip
		["Trouvaille archéologique trolle"] = 202655, -- Troll Archaeology Find
		["Trouvaille archéologique elfe de la nuit"] = 203071, -- Night Elf Archaeology Find
		["Objet aqir perdu"] = 203078, -- Nerubian Archaeology Find
		["Trouvaille archéologique naine"] = 204282, -- Dwarf Archaeology Find
		["Trouvaille archéologique fossile"] = 206836, -- Fossil Archaeology Find
		["Trouvaille archéologique orque"] = 207187, -- Orc Archaeology Find
		["Trouvaille archéologique draeneï"] = 207188, -- Draenei Archaeology Find
		["Coffre d'archéologie vrykul 01"] = 207189, -- Vrykul Archaeology Find
		["Trouvaille archéologique tol'vir"] = 207190, -- Tol'vir Archaeology Find
	}
elseif (region == "ruRU") then -- Russian
	Gatherer.Nodes.Names = {
		["Малая ториевая жила"] = 324, -- Small Thorium Vein
		["Ароматитовая жила"] = 1610, -- Incendicite Mineral Vein
		["Медная жила"] = 1731, -- Copper Vein
		["Оловянная жила"] = 1732, -- Tin Vein
		["Серебряная жила"] = 1733, -- Silver Vein
		["Золотая жила"] = 1734, -- Gold Vein
		["Залежи железа"] = 1735, -- Iron Deposit
		["Мифриловые залежи"] = 2040, -- Mithril Deposit
		["Залежи истинного серебра"] = 2047, -- Truesilver Deposit
		["Малое месторождение кровавого камня"] = 2653, -- Lesser Bloodstone Deposit
		["Индарилиевая жила"] = 19903, -- Indurium Mineral Vein
		["Покрытая слизью серебряная жила"] = 73940, -- Ooze Covered Silver Vein
		["Покрытая слизью золотая жила"] = 73941, -- Ooze Covered Gold Vein
		["Покрытые слизью залежи истинного серебра"] = 123309, -- Ooze Covered Truesilver Deposit
		["Покрытые слизью мифриловые залежи"] = 123310, -- Ooze Covered Mithril Deposit
		["Покрытая слизью ториевая жила"] = 123848, -- Ooze Covered Thorium Vein
		["Залежи черного железа"] = 165658, -- Dark Iron Deposit
		["Богатая ториевая жила"] = 175404, -- Rich Thorium Vein
		["Покрытая слизью богатая ториевая жила"] = 177388, -- Ooze Covered Rich Thorium Vein
		["Месторождение оскверненного железа"] = 181555, -- Fel Iron Deposit
		["Залежи адамантита"] = 181556, -- Adamantite Deposit
		["Кориевая жила"] = 181557, -- Khorium Vein
		["Богатые залежи адамантита"] = 181569, -- Rich Adamantite Deposit
		["Месторождение хаотита"] = 185877, -- Nethercite Deposit
		["Залежи кобальта"] = 189978, -- Cobalt Deposit
		["Богатые залежи кобальта"] = 189979, -- Rich Cobalt Deposit
		["Месторождение саронита"] = 189980, -- Saronite Deposit
		["Богатое месторождение саронита"] = 189981, -- Rich Saronite Deposit
		["Залежи титана"] = 191133, -- Titanium Vein
		["Залежи обсидиана"] = 202736, -- Obsidium Deposit
		["Залежи колчедана"] = 202737, -- Pyrite Deposit
		["Элементиевая жила"] = 202738, -- Elementium Vein
		["Громадный кусок обсидиана"] = 202739, -- Rich Obsidium Deposit
		["Богатые залежи колчедана"] = 202740, -- Rich Pyrite Deposit
		["Богатая элементиевая жила"] = 202741, -- Rich Elementium Vein
		["Сребролист"] = 1617, -- Silverleaf
		["Мироцвет"] = 1618, -- Peacebloom
		["Земляной корень"] = 1619, -- Earthroot
		["Магороза"] = 1620, -- Mageroyal
		["Остротерн"] = 1621, -- Briarthorn
		["Синячник"] = 1622, -- Bruiseweed
		["Дикий сталецвет"] = 1623, -- Wild Steelbloom
		["Королевская кровь"] = 1624, -- Kingsblood
		["Могильный мох"] = 1628, -- Grave Moss
		["Корень жизни"] = 2041, -- Liferoot
		["Бледнолист"] = 2042, -- Fadeleaf
		["Кадгаров ус"] = 2043, -- Khadgar's Whisker
		["Драконьи зубы"] = 2044, -- Wintersbite
		["Морозник"] = 2044, -- Wintersbite
		["Удавник"] = 2045, -- Stranglekelp
		["Златошип"] = 2046, -- Goldthorn
		["Огнецвет"] = 2866, -- Firebloom
		["Лиловый лотос"] = 142140, -- Purple Lotus
		["Слезы Артаса"] = 142141, -- Arthas' Tears
		["Солнечник"] = 142142, -- Sungrass
		["Пастушья сумка"] = 142143, -- Blindweed
		["Призрачная поганка"] = 142144, -- Ghost Mushroom
		["Кровь Грома"] = 142145, -- Gromsblood
		["Золотой сансам"] = 176583, -- Golden Sansam
		["Снолист"] = 176584, -- Dreamfoil
		["Горный серебряный шалфей"] = 176586, -- Mountain Silversage
		["Печаль-трава"] = 176587, -- Plaguebloom
		["Ледяной зев"] = 176588, -- Icecap
		["Черный лотос"] = 176589, -- Black Lotus
		["Кровопийка"] = 181166, -- Bloodthistle
		["Сквернопля"] = 181270, -- Felweed
		["Сияние грез"] = 181271, -- Dreaming Glory
		["Кисейница"] = 181275, -- Ragveil
		["Огненный зев"] = 181276, -- Flame Cap
		["Терошишка"] = 181277, -- Terocone
		["Древний лишайник"] = 181278, -- Ancient Lichen
		["Пустоцвет"] = 181279, -- Netherbloom
		["Ползучий кошмарник"] = 181280, -- Nightmare Vine
		["Манаполох"] = 181281, -- Mana Thistle
		["Куст пустопраха"] = 185881, -- Netherdust Bush
		["Золотой клевер"] = 189973, -- Goldclover
		["Тигровая лилия"] = 190169, -- Tiger Lily
		["Роза Таландры"] = 190170, -- Talandra's Rose
		["Личецвет"] = 190171, -- Lichbloom
		["Ледошип"] = 190172, -- Icethorn
		["Мерзлая трава"] = 190175, -- Frozen Herb
		["Северный лотос"] = 190176, -- Frost Lotus
		["Язык аспида"] = 191019, -- Adder's Tongue
		["Огница"] = 191303, -- Firethorn
		["Пепельник"] = 202747, -- Cinderbloom
		["Ливневая лоза"] = 202748, -- Stormvine
		["Вуаль Азшары"] = 202749, -- Azshara's Veil
		["Цветущее сердце"] = 202750, -- Heartblossom
		["Сумеречный жасмин"] = 202751, -- Twilight Jasmine
		["Хлыстохвост"] = 202752, -- Whiptail
		["Потайной сейф"] = 2039, -- Hidden Strongbox
		["Гигантский моллюск"] = 2744, -- Giant Clam
		["Подбитый сундук"] = 2843, -- Battered Chest
		["Побитый сундук"] = 2844, -- Tattered Chest
		["Добротный сундук"] = 2850, -- Solid Chest
		["Бочка с водой"] = 3658, -- Water Barrel
		["Бочка дынного сока"] = 3659, -- Barrel of Melon Juice
		["Оружейный ящик"] = 3660, -- Armor Crate
		["Ящик с оружием"] = 3661, -- Weapon Crate
		["Ящик со съестными припасами"] = 3662, -- Food Crate
		["Бочка молока"] = 3705, -- Barrel of Milk
		["Бочка сладкого нектара"] = 3706, -- Barrel of Sweet Nectar
		["Сейф Альянса"] = 3714, -- Alliance Strongbox
		["Ящик с различными деталями"] = 19019, -- Box of Assorted Parts
		["Разбитый ящик"] = 28604, -- Scattered Crate
		["Большой сундук, окованный железом"] = 74447, -- Large Iron Bound Chest
		["Окованный железом большой сундук"] = 74447, -- Large Iron Bound Chest
		["Большой добротный сундук"] = 74448, -- Large Solid Chest
		["Большой побитый сундук"] = 75293, -- Large Battered Chest
		["Сейф буканьера"] = 123330, -- Buccaneer's Strongbox
		["Большой сундук, окованный мифрилом"] = 131978, -- Large Mithril Bound Chest
		["Окованный мифрилом большой сундук"] = 131978, -- Large Mithril Bound Chest
		["Ящик Орды с припасами"] = 142191, -- Horde Supply Crate
		["Куча земли Ун'Горо"] = 157936, -- Un'Goro Dirt Pile
		["Синий Кристалл Силы"] = 164658, -- Blue Power Crystal
		["Синий кристалл силы"] = 164658, -- Blue Power Crystal
		["Зеленый кристалл Силы"] = 164659, -- Green Power Crystal
		["Зеленый кристалл силы"] = 164659, -- Green Power Crystal
		["Красный Кристалл Силы"] = 164660, -- Red Power Crystal
		["Красный кристалл силы"] = 164660, -- Red Power Crystal
		["Желтый Кристалл Силы"] = 164661, -- Yellow Power Crystal
		["Желтый кристалл силы"] = 164661, -- Yellow Power Crystal
		["Очищенный Ночной дракон"] = 164881, -- Cleansed Night Dragon
		["Очищенный песнецвет"] = 164882, -- Cleansed Songflower
		["Очищенный ветроцвет"] = 164884, -- Cleansed Windblossom
		["Побег кровоцвета"] = 164958, -- Bloodpetal Sprout
		["Росток кровоцвета"] = 164958, -- Bloodpetal Sprout
		["Очищенный кнутокорень"] = 174622, -- Cleansed Whipper Root
		["Кровь героев"] = 176213, -- Blood of Heroes
		["Ловушка на моллюска"] = 176582, -- Shellfish Trap
		["Учебный сейф"] = 178244, -- Practice Lockbox
		["Побитый сундучок"] = 179486, -- Battered Footlocker
		["Затопленный сундучок"] = 179487, -- Waterlogged Footlocker
		["Проломленный сундучок"] = 179492, -- Dented Footlocker
		["Замшелый сундучок"] = 179493, -- Mossy Footlocker
		["Сундучок Алого ордена"] = 179498, -- Scarlet Footlocker
		["Сундучок Алых"] = 179498, -- Scarlet Footlocker
		["Погребальный сундук"] = 181665, -- Burial Chest
		["Сундук из оскверненного железа"] = 181798, -- Fel Iron Chest
		["Тяжелый сундук из оскверненного железа"] = 181800, -- Heavy Fel Iron Chest
		["Окованный адамантитом сундук"] = 181802, -- Adamantite Bound Chest
		["Сундук, окованный адамантитом"] = 181802, -- Adamantite Bound Chest
		["Сундук из оскверненной стали"] = 181804, -- Felsteel Chest
		["Огнешляпка"] = 182053, -- Glowcap
		["Плетеный ларец"] = 184740, -- Wicker Chest
		["Примитивный сундук"] = 184793, -- Primitive Chest
		["Добротный сундук из оскверненного железа"] = 184930, -- Solid Fel Iron Chest
		["Яйцо дракона из стаи Крыльев Пустоты"] = 185915, -- Netherwing Egg
		["Обломок вечной мерзлоты"] = 193997, -- Everfrost Chip
		["Частичка Вечного льда"] = 193997, -- Everfrost Chip
		["Тролльская археологическая находка"] = 202655, -- Troll Archaeology Find
		["Эльфийская археологическая находка"] = 203071, -- Night Elf Archaeology Find
		["Нерубская археологическая находка"] = 203078, -- Nerubian Archaeology Find
		["Дворфийская археологическая находка"] = 204282, -- Dwarf Archaeology Find
		["Находка-окаменелость"] = 206836, -- Fossil Archaeology Find
		["Оркская археологическая находка"] = 207187, -- Orc Archaeology Find
		["Дренейская археологическая находка"] = 207188, -- Draenei Archaeology Find
		["Врайкульская археологическая находка"] = 207189, -- Vrykul Archaeology Find
		["Тол'вирская археологическая находка"] = 207190, -- Tol'vir Archaeology Find
	}
elseif (region == "zhCN") then -- Chinese
	Gatherer.Nodes.Names = {
		["瑟银矿脉"] = 324, -- Small Thorium Vein
		["火岩矿脉"] = 1610, -- Incendicite Mineral Vein
		["铜矿"] = 1731, -- Copper Vein
		["锡矿"] = 1732, -- Tin Vein
		["银矿"] = 1733, -- Silver Vein
		["金矿石"] = 1734, -- Gold Vein
		["铁矿石"] = 1735, -- Iron Deposit
		["秘银矿脉"] = 2040, -- Mithril Deposit
		["真银矿石"] = 2047, -- Truesilver Deposit
		["次级血石矿脉"] = 2653, -- Lesser Bloodstone Deposit
		["精铁矿脉"] = 19903, -- Indurium Mineral Vein
		["软泥覆盖的银矿脉"] = 73940, -- Ooze Covered Silver Vein
		["软泥覆盖的金矿脉"] = 73941, -- Ooze Covered Gold Vein
		["软泥覆盖的真银矿脉"] = 123309, -- Ooze Covered Truesilver Deposit
		["软泥覆盖的秘银矿脉"] = 123310, -- Ooze Covered Mithril Deposit
		["软泥覆盖的瑟银矿脉"] = 123848, -- Ooze Covered Thorium Vein
		["黑铁矿脉"] = 165658, -- Dark Iron Deposit
		["富瑟银矿"] = 175404, -- Rich Thorium Vein
		["软泥覆盖的富瑟银矿脉"] = 177388, -- Ooze Covered Rich Thorium Vein
		["哈卡莱瑟银矿脉"] = 180215, -- Hakkari Thorium Vein
		["魔铁矿脉"] = 181555, -- Fel Iron Deposit
		["精金矿脉"] = 181556, -- Adamantite Deposit
		["氪金矿脉"] = 181557, -- Khorium Vein
		["富精金矿脉"] = 181569, -- Rich Adamantite Deposit
		["虚空矿脉"] = 185877, -- Nethercite Deposit
		["银叶草"] = 1617, -- Silverleaf
		["宁神花"] = 1618, -- Peacebloom
		["地根草"] = 1619, -- Earthroot
		["魔皇草"] = 1620, -- Mageroyal
		["石南草"] = 1621, -- Briarthorn
		["跌打草"] = 1622, -- Bruiseweed
		["野钢花"] = 1623, -- Wild Steelbloom
		["皇血草"] = 1624, -- Kingsblood
		["墓地苔"] = 1628, -- Grave Moss
		["活根草"] = 2041, -- Liferoot
		["枯叶草"] = 2042, -- Fadeleaf
		["卡德加的胡须"] = 2043, -- Khadgar's Whisker
		["荆棘藻"] = 2045, -- Stranglekelp
		["金棘草"] = 2046, -- Goldthorn
		["火焰花"] = 2866, -- Firebloom
		["紫莲花"] = 142140, -- Purple Lotus
		["阿尔萨斯之泪"] = 142141, -- Arthas' Tears
		["太阳草"] = 142142, -- Sungrass
		["盲目草"] = 142143, -- Blindweed
		["幽灵菇"] = 142144, -- Ghost Mushroom
		["格罗姆之血"] = 142145, -- Gromsblood
		["黄金参"] = 176583, -- Golden Sansam
		["梦叶草"] = 176584, -- Dreamfoil
		["山鼠草"] = 176586, -- Mountain Silversage
		["冰盖草"] = 176588, -- Icecap
		["黑莲花"] = 176589, -- Black Lotus
		["血蓟"] = 181166, -- Bloodthistle
		["魔草"] = 181270, -- Felweed
		["梦露花"] = 181271, -- Dreaming Glory
		["邪雾草"] = 181275, -- Ragveil
		["烈焰菇"] = 181276, -- Flame Cap
		["泰罗果"] = 181277, -- Terocone
		["远古苔"] = 181278, -- Ancient Lichen
		["虚空花"] = 181279, -- Netherbloom
		["噩梦藤"] = 181280, -- Nightmare Vine
		["法力蓟"] = 181281, -- Mana Thistle
		["灵尘灌木丛"] = 185881, -- Netherdust Bush
		["隐蔽的保险箱"] = 2039, -- Hidden Strongbox
		["巨型蚌壳"] = 2744, -- Giant Clam
		["破损的箱子"] = 2843, -- Battered Chest
		["破碎的箱子"] = 2844, -- Tattered Chest
		["坚固的箱子"] = 2850, -- Solid Chest
		["水桶"] = 3658, -- Water Barrel
		["一桶果汁"] = 3659, -- Barrel of Melon Juice
		["铠甲箱"] = 3660, -- Armor Crate
		["武器箱"] = 3661, -- Weapon Crate
		["食品箱"] = 3662, -- Food Crate
		["一桶牛奶"] = 3705, -- Barrel of Milk
		["一桶蜂蜜酒"] = 3706, -- Barrel of Sweet Nectar
		["联盟保险箱"] = 3714, -- Alliance Strongbox
		["一箱整理过的零件"] = 19019, -- Box of Assorted Parts
		["破烂的箱子"] = 28604, -- Scattered Crate
		["大型铁箍储物箱"] = 74447, -- Large Iron Bound Chest
		["坚固的大箱子"] = 74448, -- Large Solid Chest
		["破碎的大箱子"] = 75293, -- Large Battered Chest
		["海盗的保险箱"] = 123330, -- Buccaneer's Strongbox
		["大型秘银储物箱"] = 131978, -- Large Mithril Bound Chest
		["部落补给箱"] = 142191, -- Horde Supply Crate
		["安戈洛土堆"] = 157936, -- Un'Goro Dirt Pile
		["蓝色能量水晶"] = 164658, -- Blue Power Crystal
		["绿色能量水晶"] = 164659, -- Green Power Crystal
		["红色能量水晶"] = 164660, -- Red Power Crystal
		["黄色能量水晶"] = 164661, -- Yellow Power Crystal
		["净化过的夜龙草"] = 164881, -- Cleansed Night Dragon
		["净化过的轻歌花"] = 164882, -- Cleansed Songflower
		["净化过的迎风花"] = 164884, -- Cleansed Windblossom
		["血瓣花苗"] = 164958, -- Bloodpetal Sprout
		["净化过的鞭根草"] = 174622, -- Cleansed Whipper Root
		["英雄之血"] = 176213, -- Blood of Heroes
		["贝壳陷阱"] = 176582, -- Shellfish Trap
		["练习用保险箱"] = 178244, -- Practice Lockbox
		["破碎的提箱"] = 179486, -- Battered Footlocker
		["浸水的提箱"] = 179487, -- Waterlogged Footlocker
		["被砸过的箱子"] = 179492, -- Dented Footlocker
		["生苔的提箱"] = 179493, -- Mossy Footlocker
		["血色十字军提箱"] = 179498, -- Scarlet Footlocker
		["埋起来的箱子"] = 181665, -- Burial Chest
		["魔铁宝箱"] = 181798, -- Fel Iron Chest
		["重型魔铁宝箱"] = 181800, -- Heavy Fel Iron Chest
		["加固精金宝箱"] = 181802, -- Adamantite Bound Chest
		["魔钢宝箱"] = 181804, -- Felsteel Chest
		["亮顶蘑菇"] = 182053, -- Glowcap
		["柳条箱"] = 184740, -- Wicker Chest
		["粗糙的箱子"] = 184793, -- Primitive Chest
		["坚固的魔铁宝箱"] = 184930, -- Solid Fel Iron Chest
		["灵翼龙卵"] = 185915, -- Netherwing Egg
	}
elseif (region == "zhTW") then -- Traditional Chinese
	Gatherer.Nodes.Names = {
		["瑟銀礦脈"] = 324, -- Small Thorium Vein
		["火岩礦脈"] = 1610, -- Incendicite Mineral Vein
		["銅礦脈"] = 1731, -- Copper Vein
		["錫礦脈"] = 1732, -- Tin Vein
		["銀礦脈"] = 1733, -- Silver Vein
		["金礦脈"] = 1734, -- Gold Vein
		["鐵礦床"] = 1735, -- Iron Deposit
		["秘銀礦床"] = 2040, -- Mithril Deposit
		["真銀礦床"] = 2047, -- Truesilver Deposit
		["次級血石礦脈"] = 2653, -- Lesser Bloodstone Deposit
		["精鐵礦脈"] = 19903, -- Indurium Mineral Vein
		["軟泥覆蓋的銀礦脈"] = 73940, -- Ooze Covered Silver Vein
		["軟泥覆蓋的金礦脈"] = 73941, -- Ooze Covered Gold Vein
		["軟泥覆蓋的真銀礦脈"] = 123309, -- Ooze Covered Truesilver Deposit
		["軟泥覆蓋的祕銀礦床"] = 123310, -- Ooze Covered Mithril Deposit
		["軟泥覆蓋的瑟銀礦脈"] = 123848, -- Ooze Covered Thorium Vein
		["黑鐵礦床"] = 165658, -- Dark Iron Deposit
		["富瑟銀礦脈"] = 175404, -- Rich Thorium Vein
		["軟泥覆蓋的富瑟銀礦脈"] = 177388, -- Ooze Covered Rich Thorium Vein
		["哈卡萊瑟銀礦脈"] = 180215, -- Hakkari Thorium Vein
		["魔鐵礦床"] = 181555, -- Fel Iron Deposit
		["堅鋼礦床"] = 181556, -- Adamantite Deposit
		["克銀礦脈"] = 181557, -- Khorium Vein
		["豐沃的堅鋼礦床"] = 181569, -- Rich Adamantite Deposit
		["虛空傳喚礦床"] = 185877, -- Nethercite Deposit
		["鈷藍礦床"] = 189978, -- Cobalt Deposit
		["豐沃的鈷藍礦床"] = 189979, -- Rich Cobalt Deposit
		["薩鋼礦床"] = 189980, -- Saronite Deposit
		["豐沃的薩鋼礦床"] = 189981, -- Rich Saronite Deposit
		["泰坦鋼礦脈"] = 191133, -- Titanium Vein
		["黑曜石塊"] = 202736, -- Obsidium Deposit
		["黃鐵礦床"] = 202737, -- Pyrite Deposit
		["源質礦脈"] = 202738, -- Elementium Vein
		["巨型黑曜石片"] = 202739, -- Rich Obsidium Deposit
		["豐沃的黃鐵礦床"] = 202740, -- Rich Pyrite Deposit
		["豐沃的源質礦脈"] = 202741, -- Rich Elementium Vein
		["銀葉草"] = 1617, -- Silverleaf
		["寧神花"] = 1618, -- Peacebloom
		["地根草"] = 1619, -- Earthroot
		["魔皇草"] = 1620, -- Mageroyal
		["石南草"] = 1621, -- Briarthorn
		["跌打草"] = 1622, -- Bruiseweed
		["野鋼花"] = 1623, -- Wild Steelbloom
		["皇血草"] = 1624, -- Kingsblood
		["墓地苔"] = 1628, -- Grave Moss
		["活根草"] = 2041, -- Liferoot
		["枯葉草"] = 2042, -- Fadeleaf
		["卡德加的鬍鬚"] = 2043, -- Khadgar's Whisker
		["龍齒草"] = 2044, -- Wintersbite
		["荊棘藻"] = 2045, -- Stranglekelp
		["金棘草"] = 2046, -- Goldthorn
		["火焰花"] = 2866, -- Firebloom
		["紫蓮花"] = 142140, -- Purple Lotus
		["阿薩斯之淚"] = 142141, -- Arthas' Tears
		["太陽草"] = 142142, -- Sungrass
		["盲目草"] = 142143, -- Blindweed
		["幽靈菇"] = 142144, -- Ghost Mushroom
		["格羅姆之血"] = 142145, -- Gromsblood
		["黃金蔘"] = 176583, -- Golden Sansam
		["夢葉草"] = 176584, -- Dreamfoil
		["山鼠草"] = 176586, -- Mountain Silversage
		["悲傷苔蘚"] = 176587, -- Plaguebloom
		["冰蓋草"] = 176588, -- Icecap
		["黑蓮花"] = 176589, -- Black Lotus
		["血薊"] = 181166, -- Bloodthistle
		["魔獄草"] = 181270, -- Felweed
		["譽夢草"] = 181271, -- Dreaming Glory
		["拉格維花"] = 181275, -- Ragveil
		["火帽花"] = 181276, -- Flame Cap
		["泰魯草"] = 181277, -- Terocone
		["古老青苔"] = 181278, -- Ancient Lichen
		["虛空花"] = 181279, -- Netherbloom
		["夢魘根"] = 181280, -- Nightmare Vine
		["法力薊"] = 181281, -- Mana Thistle
		["虛空之塵灌木"] = 185881, -- Netherdust Bush
		["金黃苜蓿"] = 189973, -- Goldclover
		["虎百合"] = 190169, -- Tiger Lily
		["泰蘭卓的玫瑰"] = 190170, -- Talandra's Rose
		["低語藤"] = 190171, -- Lichbloom
		["冰棘"] = 190172, -- Icethorn
		["冰凍草藥"] = 190175, -- Frozen Herb
		["冰霜蓮花"] = 190176, -- Frost Lotus
		["奎蛇之舌"] = 191019, -- Adder's Tongue
		["火棘"] = 191303, -- Firethorn
		["燼花"] = 202747, -- Cinderbloom
		["風暴藤"] = 202748, -- Stormvine
		["艾薩拉的帷紗"] = 202749, -- Azshara's Veil
		["心綻花"] = 202750, -- Heartblossom
		["暮光茉莉"] = 202751, -- Twilight Jasmine
		["鞭尾蜥草"] = 202752, -- Whiptail
		["隱蔽的保險箱"] = 2039, -- Hidden Strongbox
		["巨型蚌殼"] = 2744, -- Giant Clam
		["破損的箱子"] = 2843, -- Battered Chest
		["破爛的箱子"] = 2844, -- Tattered Chest
		["堅固的箱子"] = 2850, -- Solid Chest
		["水桶"] = 3658, -- Water Barrel
		["一桶果汁"] = 3659, -- Barrel of Melon Juice
		["護甲箱"] = 3660, -- Armor Crate
		["武器箱"] = 3661, -- Weapon Crate
		["食物箱"] = 3662, -- Food Crate
		["一桶牛奶"] = 3705, -- Barrel of Milk
		["一桶蜂蜜酒"] = 3706, -- Barrel of Sweet Nectar
		["聯盟保險箱"] = 3714, -- Alliance Strongbox
		["一箱整理過的零件"] = 19019, -- Box of Assorted Parts
		["破爛的木箱"] = 28604, -- Scattered Crate
		["大型鐵箍物箱"] = 74447, -- Large Iron Bound Chest
		["堅固的大箱子"] = 74448, -- Large Solid Chest
		["破損的大箱子"] = 75293, -- Large Battered Chest
		["海盜的保險箱"] = 123330, -- Buccaneer's Strongbox
		["大型祕銀儲物箱"] = 131978, -- Large Mithril Bound Chest
		["大型暗木儲物箱"] = 131979, -- Large Darkwood Chest
		["部落補給箱"] = 142191, -- Horde Supply Crate
		["安戈洛土堆"] = 157936, -- Un'Goro Dirt Pile
		["藍色能量水晶"] = 164658, -- Blue Power Crystal
		["綠色能量水晶"] = 164659, -- Green Power Crystal
		["紅色能量水晶"] = 164660, -- Red Power Crystal
		["黃色能量水晶"] = 164661, -- Yellow Power Crystal
		["淨化過夜龍之息"] = 164881, -- Cleansed Night Dragon
		["淨化過輕歌花"] = 164882, -- Cleansed Songflower
		["淨化過的迎風花"] = 164884, -- Cleansed Windblossom
		["血瓣花苗"] = 164958, -- Bloodpetal Sprout
		["淨化過鞭根草"] = 174622, -- Cleansed Whipper Root
		["英雄之血"] = 176213, -- Blood of Heroes
		["貝殼陷阱"] = 176582, -- Shellfish Trap
		["練習用保險箱"] = 178244, -- Practice Lockbox
		["破碎的提箱"] = 179486, -- Battered Footlocker
		["浸水的提箱"] = 179487, -- Waterlogged Footlocker
		["被砸過的箱子"] = 179492, -- Dented Footlocker
		["生苔的提箱"] = 179493, -- Mossy Footlocker
		["血色十字軍提箱"] = 179498, -- Scarlet Footlocker
		["埋葬箱"] = 181665, -- Burial Chest
		["魔鐵箱"] = 181798, -- Fel Iron Chest
		["沉重的魔鐵箱"] = 181800, -- Heavy Fel Iron Chest
		["堅鋼裝訂箱"] = 181802, -- Adamantite Bound Chest
		["魔鋼箱"] = 181804, -- Felsteel Chest
		["白閃菇"] = 182053, -- Glowcap
		["柳條箱"] = 184740, -- Wicker Chest
		["遠古箱子"] = 184793, -- Primitive Chest
		["堅固的魔鐵箱"] = 184930, -- Solid Fel Iron Chest
		["受封的魔鐵箱"] = 184931, -- Bound Fel Iron Chest
		["受封的堅鋼箱子"] = 184936, -- Bound Adamantite Chest
		["虛空之翼蛋(虛空之翼岩架)"] = 185915, -- Netherwing Egg
		["永霜屑片"] = 193997, -- Everfrost Chip
	}
end

Gatherer.Nodes.Objects = {
	[324] = "MINE", -- Small Thorium Vein
	[1610] = "MINE", -- Incendicite Mineral Vein
	[1731] = "MINE", -- Copper Vein
	[1732] = "MINE", -- Tin Vein
	[1733] = "MINE", -- Silver Vein
	[1734] = "MINE", -- Gold Vein
	[1735] = "MINE", -- Iron Deposit
	[2040] = "MINE", -- Mithril Deposit
	[2047] = "MINE", -- Truesilver Deposit
	[2653] = "MINE", -- Lesser Bloodstone Deposit
	[19903] = "MINE", -- Indurium Mineral Vein
	[73940] = "MINE", -- Ooze Covered Silver Vein
	[73941] = "MINE", -- Ooze Covered Gold Vein
	[123309] = "MINE", -- Ooze Covered Truesilver Deposit
	[123310] = "MINE", -- Ooze Covered Mithril Deposit
	[123848] = "MINE", -- Ooze Covered Thorium Vein
	[165658] = "MINE", -- Dark Iron Deposit
	[175404] = "MINE", -- Rich Thorium Vein
	[177388] = "MINE", -- Ooze Covered Rich Thorium Vein
	[180215] = "MINE", -- Hakkari Thorium Vein
	[181555] = "MINE", -- Fel Iron Deposit
	[181556] = "MINE", -- Adamantite Deposit
	[181557] = "MINE", -- Khorium Vein
	[181569] = "MINE", -- Rich Adamantite Deposit
	[185877] = "MINE", -- Nethercite Deposit
	[189978] = "MINE", -- Cobalt Deposit
	[189979] = "MINE", -- Rich Cobalt Deposit
	[189980] = "MINE", -- Saronite Deposit
	[189981] = "MINE", -- Rich Saronite Deposit
	[191133] = "MINE", -- Titanium Vein
	[202736] = "MINE", -- Obsidium Deposit
	[202737] = "MINE", -- Pyrite Deposit
	[202738] = "MINE", -- Elementium Vein
	[202739] = "MINE", -- Rich Obsidium Deposit
	[202740] = "MINE", -- Rich Pyrite Deposit
	[202741] = "MINE", -- Rich Elementium Vein
	[1617] = "HERB", -- Silverleaf
	[1618] = "HERB", -- Peacebloom
	[1619] = "HERB", -- Earthroot
	[1620] = "HERB", -- Mageroyal
	[1621] = "HERB", -- Briarthorn
	[1622] = "HERB", -- Bruiseweed
	[1623] = "HERB", -- Wild Steelbloom
	[1624] = "HERB", -- Kingsblood
	[1628] = "HERB", -- Grave Moss
	[2041] = "HERB", -- Liferoot
	[2042] = "HERB", -- Fadeleaf
	[2043] = "HERB", -- Khadgar's Whisker
	[2044] = "HERB", -- Wintersbite
	[2045] = "HERB", -- Stranglekelp
	[2046] = "HERB", -- Goldthorn
	[2866] = "HERB", -- Firebloom
	[142140] = "HERB", -- Purple Lotus
	[142141] = "HERB", -- Arthas' Tears
	[142142] = "HERB", -- Sungrass
	[142143] = "HERB", -- Blindweed
	[142144] = "HERB", -- Ghost Mushroom
	[142145] = "HERB", -- Gromsblood
	[176583] = "HERB", -- Golden Sansam
	[176584] = "HERB", -- Dreamfoil
	[176586] = "HERB", -- Mountain Silversage
	[176587] = "HERB", -- Plaguebloom
	[176588] = "HERB", -- Icecap
	[176589] = "HERB", -- Black Lotus
	[181166] = "HERB", -- Bloodthistle
	[181270] = "HERB", -- Felweed
	[181271] = "HERB", -- Dreaming Glory
	[181275] = "HERB", -- Ragveil
	[181276] = "HERB", -- Flame Cap
	[181277] = "HERB", -- Terocone
	[181278] = "HERB", -- Ancient Lichen
	[181279] = "HERB", -- Netherbloom
	[181280] = "HERB", -- Nightmare Vine
	[181281] = "HERB", -- Mana Thistle
	[185881] = "HERB", -- Netherdust Bush
	[189973] = "HERB", -- Goldclover
	[190169] = "HERB", -- Tiger Lily
	[190170] = "HERB", -- Talandra's Rose
	[190171] = "HERB", -- Lichbloom
	[190172] = "HERB", -- Icethorn
	[190175] = "HERB", -- Frozen Herb
	[190176] = "HERB", -- Frost Lotus
	[191019] = "HERB", -- Adder's Tongue
	[191303] = "HERB", -- Firethorn
	[202747] = "HERB", -- Cinderbloom
	[202748] = "HERB", -- Stormvine
	[202749] = "HERB", -- Azshara's Veil
	[202750] = "HERB", -- Heartblossom
	[202751] = "HERB", -- Twilight Jasmine
	[202752] = "HERB", -- Whiptail
	[2039] = "OPEN", -- Hidden Strongbox
	[2744] = "OPEN", -- Giant Clam
	[2843] = "OPEN", -- Battered Chest
	[2844] = "OPEN", -- Tattered Chest
	[2850] = "OPEN", -- Solid Chest
	[3658] = "OPEN", -- Water Barrel
	[3659] = "OPEN", -- Barrel of Melon Juice
	[3660] = "OPEN", -- Armor Crate
	[3661] = "OPEN", -- Weapon Crate
	[3662] = "OPEN", -- Food Crate
	[3705] = "OPEN", -- Barrel of Milk
	[3706] = "OPEN", -- Barrel of Sweet Nectar
	[3714] = "OPEN", -- Alliance Strongbox
	[19019] = "OPEN", -- Box of Assorted Parts
	[28604] = "OPEN", -- Scattered Crate
	[74447] = "OPEN", -- Large Iron Bound Chest
	[74448] = "OPEN", -- Large Solid Chest
	[75293] = "OPEN", -- Large Battered Chest
	[123330] = "OPEN", -- Buccaneer's Strongbox
	[131978] = "OPEN", -- Large Mithril Bound Chest
	[131979] = "OPEN", -- Large Darkwood Chest
	[142191] = "OPEN", -- Horde Supply Crate
	[157936] = "OPEN", -- Un'Goro Dirt Pile
	[164658] = "OPEN", -- Blue Power Crystal
	[164659] = "OPEN", -- Green Power Crystal
	[164660] = "OPEN", -- Red Power Crystal
	[164661] = "OPEN", -- Yellow Power Crystal
	[164881] = "OPEN", -- Cleansed Night Dragon
	[164882] = "OPEN", -- Cleansed Songflower
	[164884] = "OPEN", -- Cleansed Windblossom
	[164958] = "OPEN", -- Bloodpetal Sprout
	[174622] = "OPEN", -- Cleansed Whipper Root
	[176213] = "OPEN", -- Blood of Heroes
	[176582] = "OPEN", -- Shellfish Trap
	[178244] = "OPEN", -- Practice Lockbox
	[179486] = "OPEN", -- Battered Footlocker
	[179487] = "OPEN", -- Waterlogged Footlocker
	[179492] = "OPEN", -- Dented Footlocker
	[179493] = "OPEN", -- Mossy Footlocker
	[179498] = "OPEN", -- Scarlet Footlocker
	[181665] = "OPEN", -- Burial Chest
	[181798] = "OPEN", -- Fel Iron Chest
	[181800] = "OPEN", -- Heavy Fel Iron Chest
	[181802] = "OPEN", -- Adamantite Bound Chest
	[181804] = "OPEN", -- Felsteel Chest
	[182053] = "OPEN", -- Glowcap
	[184740] = "OPEN", -- Wicker Chest
	[184793] = "OPEN", -- Primitive Chest
	[184930] = "OPEN", -- Solid Fel Iron Chest
	[184931] = "OPEN", -- Bound Fel Iron Chest
	[184936] = "OPEN", -- Bound Adamantite Chest
	[185915] = "OPEN", -- Netherwing Egg
	[193997] = "OPEN", -- Everfrost Chip
	[202655] = "ARCH", -- Troll Archaeology Find
	[203071] = "ARCH", -- Night Elf Archaeology Find
	[203078] = "ARCH", -- Nerubian Archaeology Find
	[204282] = "ARCH", -- Dwarf Archaeology Find
	[206836] = "ARCH", -- Fossil Archaeology Find
	[207187] = "ARCH", -- Orc Archaeology Find
	[207188] = "ARCH", -- Draenei Archaeology Find
	[207189] = "ARCH", -- Vrykul Archaeology Find
	[207190] = "ARCH", -- Tol'vir Archaeology Find
}

Gatherer.Nodes.PrimaryItems = {
	[189978] = 36909, -- Cobalt Deposit
	[189979] = 36909, -- Rich Cobalt Deposit
	[189980] = 36912, -- Saronite Deposit
	[189981] = 36912, -- Rich Saronite Deposit
	[191133] = 36910, -- Titanium Vein
	[202736] = 53038, -- Obsidium Deposit
	[202737] = 52183, -- Pyrite Deposit
	[202738] = 52185, -- Elementium Vein
	[202739] = 53038, -- Rich Obsidium Deposit
	[202740] = 52183, -- Rich Pyrite Deposit
	[202741] = 52185, -- Rich Elementium Vein
	[189973] = 36901, -- Goldclover
	[190169] = 36904, -- Tiger Lily
	[190170] = 36907, -- Talandra's Rose
	[190171] = 36905, -- Lichbloom
	[190172] = 36906, -- Icethorn
	[190176] = 36908, -- Frost Lotus
	[191019] = 36903, -- Adder's Tongue
	[202747] = 52983, -- Cinderbloom
	[202748] = 52984, -- Stormvine
	[202749] = 52985, -- Azshara's Veil
	[202750] = 52986, -- Heartblossom
	[202751] = 52987, -- Twilight Jasmine
	[202752] = 52988, -- Whiptail
	[193997] = 44724, -- Everfrost Chip
}
