﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11
-- global functions
local pairs = pairs
local tostring = tostring
local floor = floor
local table_insert = table.insert
local table_getn = table.getn
local tonumber=tonumber
local len=string.len
local table_sort = table.sort

local strfind=strfind
local string_gmatch=string.gmatch

NPA_Options={}

---page data
local ActiveKey="Core"
local PageCount=0
local Pages={}

local CurrentTip=1


--these codes are learnd from TipTac
local Localization={}
local SmallTips={}
local locale=GetLocale()
local Tooltips={}
local NPA_Options_AnchorLib_Localization={}

if(locale=="zhTW")then
	Localization={
		["SpellidToName"]="法術id查詢",
		["SpellNameToId"]="法術名稱查詢",
		["Id"]="Id",
		["Name"]="名稱",
		["Add"]="添加",
		["Remove"]="刪除",
		["Apply"]="套用",
		["Reset"]="重置",
		["Cancel"]="撤銷",
		["ResetAll"]="重置全部",
		["ReloadUI"]="重載UI",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Anchor"]="自身錨點",
		["ToAnchor"]="目標錨點",
		["Height"]="高度",
		["Width"]="寬度",
		["Color"]="顏色",
		["Red"]="紅",
		["Green"]="綠",
		["Blue"]="藍",
		["Alpha"]="透明",
		["Texture"]="材質",
		["Font"]="字體",
		["ShadowX"]="陰影X偏移",
		["ShadowY"]="陰影Y偏移",
		["File"]="文件",
		["Size"]="尺寸",
		["Left"]="材質定位左側",
		["Right"]="材質定位右側",
		["Top"]="材質定位頂端",
		["Bottom"]="材質定位底端",
		["Rotation"]="旋轉角度",
		["ClearAll"]="清除全部",
		["CombieLib"]="合併材質庫",
		["Tooltip"]="這裡顯示提示信息",
		["None"]="空",
		["NextTip"]="下一條",
		["InUse"]="使用",
		["NotUse"]="不使用",
		["MoveUp"]="上移",
		["MoveDown"]="下移",
	}
	SmallTips={
		[1]="自己的姓名板和自己寵物的姓名板在[追踪]模塊內",
		[2]="想要只顯示特定的buff/debuff,關閉[增減益]模塊的所有過濾選項,然後把想要顯示的法術填進白名單中",
		[3]="修改條的角度可以改變方向,0度是水平向右,90度是垂直向上,180度是水平像左,270度是垂直向下,其它角度在使用帶有邊緣的貼圖時才能達到最佳效果",
		[4]="動態貼圖的創建和使用說明保存在NPA\Texture\Animated\Animated readme.txt",
		[5]="使用[自動隱藏]的縮放和透明度,[血條]裡的高亮,和[姓名文本]裡的標記,來讓你的目標/focus/鼠標滑過更加明顯",
		[6]="在[核心]裡提高單位數據和框架更新間隔,可以降低cpu使用頻率",
		[7]="[核心]裡的猜測匹配可以在大多數情況下猜出npc姓名板的guid,從而不需要鼠標滑過,但是在許多血量相同的npc出現時會獲得錯誤的guid,需要鼠標滑過才能恢復正常",
		[8]="指向目標的箭頭是[目標]模塊的指示器功能",
		[9]="用暴雪默認的快捷鍵v,ctrl+v,shift+v來開關敵對/全部/友方姓名板",
		[10]="可以使用命令/console spreadnameplates 0 來關閉姓名板碰撞;暴雪的esc->界面->姓名裡還有更多的姓名板設置",
	}

	Tooltips={
		["NextTip"]="顯示下一條提示",
		["Close"]="关闭",
		["Open"]="顯示/隱藏下拉列表",
		["SpellidToName"]="用法術id查詢名稱",
		["SpellNameToId"]="用法術名稱查詢id",
		["Id"]="法術id",
		["Name"]="法術名稱",
		["Add"]="添加到列表",
		["Remove"]="從列表中移除",
		["Apply"]="套用當前頁的修改",
		["Reset"]="重置當前頁的修改",
		["Cancel"]="取消當前頁的改動",
		["ResetAll"]="重置所有頁面的設置到默認",
		["ReloadUI"]="重載全部插件",
		["OffsetX"]="從中心的X偏移量,正值為右方向",
		["OffsetY"]="從中心的Y偏移量,正值為上方向",
		["Height"]="高度,單位為像素",
		["Width"]="寬度,單位為像素",
		["Color"]="顏色",
		["Red"]="顏色的紅色部分,從0到1",
		["Green"]="顏色的綠色部分,從0到1",
		["Blue"]="顏色的藍色部分,從0到1",
		["Alpha"]="顏色的Alpha部分(透明度),從0到1",
		["Texture"]="材質",
		["Font"]="字體",
		["ShadowX"]="陰影從中心的X偏移量,正值為右方向",
		["ShadowY"]="陰影從中心的Y偏移量,正值為上方向",
		["File"]="文件路徑和文件名(不帶擴展名),範例:[Interface\\Addons\\NPA\\Texture\\Glow],查詢[NPA\\texture]和[NPA\\texture\\animated]路徑下的讀我文檔可獲得更多自定義細節",
		["Size"]="尺寸,單位為像素",
		["Left"]="材質顯示的左邊緣坐標,0表示原始材質的最左側,1表示最右側",
		["Right"]="材質顯示的右邊緣坐標,0表示原始材質的最左側,1表示最右側",
		["Top"]="材質顯示的上邊緣坐標,0表示原始材質的最上側,1表示最下側",
		["Bottom"]="材質顯示的下邊緣坐標,0表示原始材質的最上側,1表示最下側",
		["Rotation"]="貼圖旋轉角度,逆時針,從0到360",
		["ClearAll"]="清除整個列表",
		["CombieLib"]="在材質下拉菜單中同時顯示[邊框][圖標]和[條]貼圖",
		["BlendMode"]="設為5個貼圖混合方式中的1個,[DISABLE] -- 不透明; [BLEND] -- 使用材質的Alpha設定; [ALPHAKEY] -- 使用單字節Alpha;[ADD] -- 加法混合;[MOD] -- 餘數混合",
		["FontMode"]="字體標籤,以下3種的排列組合:[OUTLINE]--邊線,[THICKOUTLINE]--厚邊線, [MONOCHROME]--單色"

	}

	NPA_Options_AnchorLib_Localization={
		["TOP"]="頂部",
		["TOPRIGHT"]="頂部右側",
		["TOPLEFT"]="頂部左側",
		["CENTER"]="中央",
		["RIGHT"]="右側",
		["LEFT"]="左側",
		["BOTTOM"]="底部",
		["BOTTOMRIGHT"]="底部右側",
		["BOTTOMLEFT"]="底部左側"
	}


elseif(locale=="zhCN")then
	Localization={
		["SpellidToName"]="法术id查询",
		["SpellNameToId"]="法术名称查询",
		["Id"]="Id",
		["Name"]="名称",
		["Add"]="添加",
		["Remove"]="删除",
		["Apply"]="套用",
		["Reset"]="重置",
		["Cancel"]="撤销",
		["ResetAll"]="重置全部",
		["ReloadUI"]="重载UI",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Anchor"]="自身锚点",
		["ToAnchor"]="目标锚点",
		["Height"]="高度",
		["Width"]="宽度",
		["Color"]="颜色",
		["Red"]="红",
		["Green"]="绿",
		["Blue"]="蓝",
		["Alpha"]="透明",
		["Texture"]="材质",
		["Font"]="字体",
		["ShadowX"]="阴影X偏移",
		["ShadowY"]="阴影Y偏移",
		["File"]="文件",
		["Size"]="尺寸",
		["Left"]="材质定位左侧",
		["Right"]="材质定位右侧",
		["Top"]="材质定位顶端",
		["Bottom"]="材质定位底端",
		["Rotation"]="旋转角度",
		["ClearAll"]="清除全部",
		["CombieLib"]="合并材质库",
		["Tooltip"]="这里显示提示信息",
		["None"]="空",
		["NextTip"]="下一条",
		["InUse"]="使用",
		["NotUse"]="不使用",
		["MoveUp"]="上移",
		["MoveDown"]="下移",
	}
	SmallTips={ 
		[1]="自己的姓名板和自己宠物的姓名板在[追踪]模块内", 
		[2]="想要只显示特定的buff/debuff,关闭[增减益]模块的所有过滤选项,然后把想要显示的法术填进白名单中", 
		[3]="修改条的角度可以改变方向,0度是水平向右,90度是垂直向上,180度是水平像左,270度是垂直向下,其它角度在使用带有边缘的贴图时才能达到最佳效果", 
		[4]="动态贴图的创建和使用说明保存在NPA\Texture\Animated\Animated readme.txt", 
		[5]="使用[自动隐藏]的缩放和透明度,[血条]里的高亮,和[姓名文本]里的标记,来让你的目标/focus/鼠标滑过更加明显", 
		[6]="在[核心]里提高单位数据和框架更新间隔,可以降低cpu使用频率", 
		[7]="[核心]里的猜测匹配可以在大多数情况下猜出npc姓名板的guid,从而不需要鼠标滑过,但是在许多血量相同的npc出现时会获得错误的guid,需要鼠标滑过才能恢复正常",
		[8]="指向目标的箭头是[目标]模块的指示器功能", 
		[9]="用暴雪默认的快捷键v,ctrl+v,shift+v来开关敌对/全部/友方姓名板", 
		[10]="可以使用命令/console spreadnameplates 0 来关闭姓名板碰撞;暴雪的esc->界面->姓名里还有更多的姓名板设置", 
	}

	Tooltips={ 
		["NextTip"]="显示下一条提示",
		["Close"]="关闭",
		["Open"]="显示/隐藏下拉列表", 
		["SpellidToName"]="用法术id查询名称", 
		["SpellNameToId"]="用法术名称查询id", 
		["Id"]="法术id", 
		["Name"]="法术名称", 
		["Add"]="添加到列表", 
		["Remove"]="从列表中移除", 
		["Apply"]="套用当前页的修改", 
		["Reset"]="重置当前页的修改", 
		["Cancel"]="取消当前页的改动", 
		["ResetAll"]="重置所有页面的设置到默认", 
		["ReloadUI"]="重载全部插件", 
		["OffsetX"]="从中心的X偏移量,正值为右方向", 
		["OffsetY"]="从中心的Y偏移量,正值为上方向", 
		["Height"]="高度,单位为像素", 
		["Width"]="宽度,单位为像素", 
		["Color"]="颜色", 
		["Red"]="颜色的红色部分,从0到1", 
		["Green"]="颜色的绿色部分,从0到1", 
		["Blue"]="颜色的蓝色部分,从0到1", 
		["Alpha"]="颜色的Alpha部分(透明度),从0到1", 
		["Texture"]="材质", 
		["Font"]="字体", 
		["ShadowX"]="阴影从中心的X偏移量,正值为右方向", 
		["ShadowY"]="阴影从中心的Y偏移量,正值为上方向", 
		["File"]="文件路径和文件名(不带扩展名),范例:[Interface\\Addons\\NPA\\Texture\\Glow],查询[NPA\\texture]和[NPA\\texture \\animated]路径下的读我文档可获得更多自定义细节", 
		["Size"]="尺寸,单位为像素", 
		["Left"]="材质显示的左边缘坐标,0表示原始材质的最左侧,1表示最右侧", 
		["Right"]="材质显示的右边缘坐标,0表示原始材质的最左侧,1表示最右侧", 
		["Top"]="材质显示的上边缘坐标,0表示原始材质的最上侧,1表示最下侧", 
		["Bottom"]="材质显示的下边缘坐标,0表示原始材质的最上侧,1表示最下侧", 
		["Rotation"]="贴图旋转角度,逆时针,从0到360", 
		["ClearAll"]="清除整个列表", 
		["CombieLib"]="在材质下拉菜单中同时显示[边框][图标]和[条]贴图", 
		["BlendMode"]="设为5个贴图混合方式中的1个,[DISABLE] -- 不透明; [BLEND] -- 使用材质的Alpha设定; [ALPHAKEY] -- 使用单字节Alpha;[ADD ] -- 加法混合;[MOD] -- 余数混合", 
		["FontMode"]="字体标签,以下3种的排列组合:[OUTLINE]--边线,[THICKOUTLINE]--厚边线, [MONOCHROME]--单色" 

	}
	NPA_Options_AnchorLib_Localization={
		["TOP"]="顶部",
		["TOPRIGHT"]="顶部右侧",
		["TOPLEFT"]="顶部左侧",
		["CENTER"]="中央",
		["RIGHT"]="右侧",
		["LEFT"]="左侧",
		["BOTTOM"]="底部",
		["BOTTOMRIGHT"]="底部右侧",
		["BOTTOMLEFT"]="底部左侧"
	}

else
	Localization={
		["SpellidToName"]="Spellid to name",
		["SpellNameToId"]="Spell name to id",
		["Id"]="Id",
		["Name"]="Name",
		["Add"]="Add",
		["Remove"]="Remove",
		["Apply"]="Apply",
		["Reset"]="Reset",
		["Cancel"]="Cancel",
		["ResetAll"]="Reset All",
		["ReloadUI"]="Reload ui",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["Anchor"]="Self Anchor",
		["ToAnchor"]="Parent Anchor",
		["Height"]="Height",
		["Width"]="Width",
		["Color"]="Color",
		["Red"]="Red",
		["Green"]="Green",
		["Blue"]="Blue",
		["Alpha"]="Alpha",
		["Texture"]="Texture",
		["Font"]="Font",
		["ShadowX"]="Shadow offset X",
		["ShadowY"]="Shadow offset Y",
		["File"]="File",
		["Size"]="Size",
		["Left"]="Texture coordinate Left",
		["Right"]="Texture coordinate Right",
		["Top"]="Texture coordinate Top",
		["Bottom"]="Texture coordinate Bottom",
		["Rotation"]="Rotation angle",
		["ClearAll"]="Clear all",
		["CombieLib"]="Combie texture lib",
		["Tooltip"]="Tooltips displayed here",
		["None"]="None",
		["NextTip"]="Next one",
		["InUse"]="In use",
		["NotUse"]="Not use",
		["MoveUp"]="Up",
		["MoveDown"]="Down",
	}

	SmallTips = { 
		[1] = "Self namplate and pet nameplate are in [Tracker] module" ,
		[2] = "To show only certain buff/debuff, uncheck all filter in [aura] page , then filled spell wanted the white list",
		[3] = "Changing the angle of bar can change it's direction ,0 for right, 90 for up, 180 for left,and 270 for down; other angle would require certain texture with empty edges for best effect" ,
		[4] = "Instructions for creating and using animated texture are written in  NPA\Texture\Animated\Animated readme.txt", 
		[5] = "Using scaling and fading of [AutoHide], highlight of [HealthBar], and mark of [NameText], to make your target/focus/mouseover more obvious" ,
		[6] = "Increasing unitdata collecting and frame updating intervals in [Core] page can reduce cpu cost" ,
		[7] = "[Guess match] in [Core] page can guess the guid of certain npc unit most of the time, preventing mouseover requires; however sometime when many units with exact same health and name give it wrong guid, would need mouseover to fix",
		[8] = "The arrows pointing to target is [Indicator] of [Target] module" ,
		[9] = "Use the Blizzard default hotkeys [v], [ctrl + v], [shift + v] to switch hostile/all/friendly nameplates" ,
		[10] = "Use command /console spreadnameplates 0 to turn off nameplate collision; There're more options in Blizzard menu Esc->Interface ->Name", 
	}
	Tooltips={
		["NextTip"]="Show next tip",
		["Close"]="Close",
		["Open"]="Show/hide dropdown list",
		["SpellidToName"]="Spellid to name lookup",
		["SpellNameToId"]="Spell name to id lookup",
		["Id"]="Spell id",
		["Name"]="Spell name",
		["Add"]="Add into list",
		["Remove"]="Remove from list",
		["Apply"]="Apply changes on current page",
		["Reset"]="Reset settings on current page",
		["Cancel"]="Cancel changes on current page",
		["ResetAll"]="Reset all settings on all pages",
		["ReloadUI"]="Reload all ui",
		["OffsetX"]="Offset X from center, positive means right",
		["OffsetY"]="Offset Y from center, positive means up",
		["Height"]="Height by pixel",
		["Width"]="Width by pixel",
		["Color"]="Color",
		["Red"]="Red component of color, from 0 to 1",
		["Green"]="Green component of color ,from 0 to 1",
		["Blue"]="Blue component of color ,from 0 to 1",
		["Alpha"]="Alpha component of color (transparency), from 0 to 1",
		["Texture"]="Texture",
		["Font"]="Font file path and name (no filename extension)",
		["ShadowX"]="Shadow offset X from center, positive means right",
		["ShadowY"]="Shadow offset Y from center, positive means up",
		["File"]="File path and name (no filename extension) ,  example:[Interface\\Addons\\NPA\\Texture\\Glow] ,      check readme file under [NPA\\texture] and [NPA\\texture\\animated] for more details of customing",
		["Size"]="Size by pixel",
		["Left"]="Left end coordinate of displayed texture ,0 means left end of origin texture,1 means right end",
		["Right"]="Right end coordinate of displayed texture, 0 means left end of origin texture,1 means right end",
		["Top"]="Top end coordinate of displayed texture ,0 means top end of origin texture,1 means bottom end",
		["Bottom"]="Bottom end coordinate of displayed texture ,0 means top end of origin texture,1 means bottom end",
		["Rotation"]="Texture rotation angle, counter clockwise",
		["ClearAll"]="Clear whole list",
		["CombieLib"]="Display edge,icon and bar textures all in one dropdown menu",
		["BlendMode"]="Set 1 of 5 texture blend mode: [DISABLE] -- opaque; [BLEND] -- using texture alpha; [ALPHAKEY] -- using one-bit alpha;[ADD] -- additive blend;[MOD] -- modulating blend",
		["FontMode"]="Font flags, any comma-delimited combination of [OUTLINE],[THICKOUTLINE] and [MONOCHROME]"
	}
	NPA_Options_AnchorLib_Localization={
		["TOP"]="TOP",
		["TOPRIGHT"]="TOPRIGHT",
		["TOPLEFT"]="TOPLEFT",
		["CENTER"]="CENTER",
		["RIGHT"]="RIGHT",
		["LEFT"]="LEFT",
		["BOTTOM"]="BOTTOM",
		["BOTTOMRIGHT"]="BOTTOMRIGHT",
		["BOTTOMLEFT"]="BOTTOMLEFT"
	}

end


--------------texture lib and font lib
local NPA_Options_BorderTextureLib={
	[Localization["None"]]="",
	["Blizzard Achievement Wood"]= "Interface\\AchievementFrame\\UI-Achievement-WoodBorder",
	["Blizzard Chat Bubble"] = "Interface\\Tooltips\\ChatBubble-Backdrop",
	["Blizzard Dialog"] = "Interface\\DialogFrame\\UI-DialogBox-Border",
	["Blizzard Dialog Gold"] = "Interface\\DialogFrame\\UI-DialogBox-Gold-Border",
	["Blizzard Party"] = "Interface\\CHARACTERFRAME\\UI-Party-Border",
	["Blizzard Tooltip"] = "Interface\\Tooltips\\UI-Tooltip-Border",
	}
local NPA_Options_BarTextureLib={
	[Localization["None"]]="",
	["Blizzard Border"]="Interface\\Addons\\NPA\\texture\\defaultborder",
	["Blizzard Glow"]="Interface\\Addons\\NPA\\texture\\glow",
	["Blizzard Stausbar Border"] = "Interface\\Tooltips\\UI-StatusBar-Border",
	["Blizzard Bar"] = "Interface\\TargetingFrame\\UI-StatusBar",
	["Blizzard Character Skills Bar"] = "Interface\\PaperDollInfoFrame\\UI-Character-Skills-Bar",
	["NPA Animated Fire"]="Interface\\Addons\\NPA\\texture\\animated\\fire@7@7@100",
	["NPA Animated Snow"]="Interface\\Addons\\NPA\\texture\\animated\\snow@10@10@100",
	["NPA Animated Star"]="Interface\\Addons\\NPA\\texture\\animated\\star-white@11@11@50",
	["NPA Animated Burning Star"]="Interface\\Addons\\NPA\\texture\\animated\\star@11@11@50",
	["NPA Star"]="Interface\\Addons\\NPA\\texture\\star-white",
	["NPA Burning Star"]="Interface\\Addons\\NPA\\texture\\star",
	["Blizzard Bar Interrupt Shield"]="Interface\\Addons\\NPA\\texture\\barshield",
	["NPA Mono Bar"]="Interface\\Addons\\NPA\\texture\\mono\\bar",
	["NPA Mono Border"]="Interface\\Addons\\NPA\\texture\\mono\\border",
	["NPA Mono glow"]="Interface\\Addons\\NPA\\texture\\mono\\glow",
	["NPA Rune"]="Interface\\Addons\\NPA\\texture\\runes",
	["NPA Arrow"]="Interface\\Addons\\NPA\\texture\\arrow",
	["NPA Test1 Bar"]="Interface\\Addons\\NPA\\texture\\Test1\\bar",
	["NPA Test1 Bar Background"]="Interface\\Addons\\NPA\\texture\\Test1\\barbackground",
	["NPA Test1 Bar Border"]="Interface\\Addons\\NPA\\texture\\Test1\\border",
	["NPA Test1 Highlight"]="Interface\\Addons\\NPA\\texture\\Test1\\highlight",
	["NPA Sphere"]="Interface\\Addons\\NPA\\texture\\Sphere\\sphere",
	["NPA Sphere Overlay"]="Interface\\Addons\\NPA\\texture\\Sphere\\overlay",
	["NPA Thinking Cloud Left"]="Interface\\Addons\\NPA\\texture\\ThinkingCloud\\left",
	["NPA Thinking Cloud Right"]="Interface\\Addons\\NPA\\texture\\ThinkingCloud\\right",
	["NPA Thinking Cloud Center"]="Interface\\Addons\\NPA\\texture\\ThinkingCloud\\center",
	}
--debug
--for i=1,100 do
--	NPA_Options_BarTextureLib["test"..i]="Interface\\Addons\\NPA\\texture\\defaultborder"
--end

local NPA_Options_AnchorLib={
	["TOP"]="TOP",
	["TOPRIGHT"]="TOPRIGHT",
	["TOPLEFT"]="TOPLEFT",
	["CENTER"]="CENTER",
	["RIGHT"]="RIGHT",
	["LEFT"]="LEFT",
	["BOTTOM"]="BOTTOM",
	["BOTTOMRIGHT"]="BOTTOMRIGHT",
	["BOTTOMLEFT"]="BOTTOMLEFT"
}

local NPA_Options_IndicatorTextureLib={
	[Localization["None"]]="",
	["NPA Rune"]="Interface\\Addons\\NPA\\texture\\runes",
	["NPA Arrow"]="Interface\\Addons\\NPA\\texture\\arrow",
	["NPA Animated Fire"]="Interface\\Addons\\NPA\\texture\\animated\\fire@7@7@100",
	["NPA Animated Snow"]="Interface\\Addons\\NPA\\texture\\animated\\snow@10@10@100",
	["NPA Animated Burning Star"]="Interface\\Addons\\NPA\\texture\\animated\\star@11@11@50",
	["NPA Animated Star"]="Interface\\Addons\\NPA\\texture\\animated\\star-white@11@11@50",
	["NPA Star"]="Interface\\Addons\\NPA\\texture\\star-white",
	["NPA Burning Star"]="Interface\\Addons\\NPA\\texture\\star",
	["Blizzard Icon Interrupt Shield"]="Interface\\Addons\\NPA\\texture\\iconshield",
	["NPA Mono Arrow"]="Interface\\Addons\\NPA\\texture\\mono\\arrow",
	["Blank"]="Interface\\Addons\\NPA\\texture\\blank",
	["Blizzard Elite Icon"]="Interface\\Tooltips\\EliteNameplateIcon",
	["Blizzard Skull Icon"]="Interface\\TargetingFrame\\UI-TargetingFrame-Skull",
	["Blizzard Raid Icon"]="Interface\\TargetingFrame\\UI-RaidTargetingIcons",
	["Blizzard Class Icon"]="Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes",
	["Blizzard Elite Icon"]="Interface\\Tooltips\\EliteNameplateIcon",
	["NPA Test1 Target"]="Interface\\Addons\\NPA\\texture\\Test1\\target@4@4@15",
	["NPA Test1 Icon Background"]="Interface\\Addons\\NPA\\texture\\Test1\\iconbg",
	["NPA Combat Icon"]="Interface\\Addons\\NPA\\texture\\combaticon",
	["NPA Combat Icon Background"]="Interface\\Addons\\NPA\\combaticonbg",
	["Blizzard Spark Icon"]="Interface\\CastingBar\\UI-CastingBar-Spark",
	["NPA Thinking Cloud Left"]="Interface\\Addons\\NPA\\texture\\ThinkingCloud\\left",
	["NPA Thinking Cloud Right"]="Interface\\Addons\\NPA\\texture\\ThinkingCloud\\right",
	["NPA Thinking Cloud Center"]="Interface\\Addons\\NPA\\texture\\ThinkingCloud\\center",
	["Blizzard Role Icons"]="Interface\\LFGFrame\\UI-LFG-ICON-ROLES",
	}

local NPA_Options_FontLib={}
if(locale == "zhCN") then
	NPA_Options_FontLib={
		["伤害数字"] = "Fonts\\ZYKai_C.ttf",
		["默认"] = "Fonts\\ZYKai_T.ttf",
		["聊天"] = "Fonts\\ZYHei.ttf",
	}
elseif(locale == "zhTW") then
	NPA_Options_FontLib={
		["提示訊息"] = "Fonts\\bHEI00M.ttf",
		["聊天"] = "Fonts\\bHEI01B.ttf",
		["傷害數字"] = "Fonts\\bKAI00M.ttf",
		["預設"] = "Fonts\\bLEI00D.ttf",
	}
else
	NPA_Options_FontLib={
		["Arial Narrow"] = "Fonts\\ARIALN.TTF",
		["Friz Quadrata TT"] = "Fonts\FRIZQT__.TTF",
		["Morpheus"] = "Fonts\MORPHEUS.TTF",
		["Skurri"] = "Fonts\SKURRI.TTF",
	}
end

local NPA_Options_BlendMode={
	["DISABLE"]="DISABLE",
	["BLEND"]="BLEND",
	["ALPHAKEY"]="ALPHAKEY",
	["ADD"]="ADD",
	["MOD"]="MOD"
	}

local NPA_Options_FontMode={
	["Outline"]="OUTLINE",
	["Thick"]="THICKOUTLINE",
	["Mono"]="MONOCHROME",
	["O+T"]="OUTLINE,THICKOUTLINE",
	["O+M"]="OUTLINE,MONOCHROME",
	["T+M"]="THICKOUTLINE,MONOCHROME",
	["O+T+M"]="OUTLINE,THICKOUTLINE,MONOCHROME",
	[Localization["None"]]="",
	}
---------------

	
--------------------------
local mainframe=CreateFrame("Frame","NPA_Options_MainFrame",UIParents)
mainframe:SetBackdrop({ bgFile = "Interface\\ChatFrame\\ChatFrameBackground", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = 0, tileSize = 1, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
mainframe:SetBackdropColor(0.1,0.1,0.1,1)
mainframe:SetBackdropBorderColor(1,1,1,1)
local header=mainframe:CreateFontString("NPA_Options_MainFrame_Header")
header:SetFont(GameFontNormal:GetFont(),22,"THICKOUTLINE")
header:SetPoint("BOTTOM",mainframe,"TOP",0,0)
header:SetTextColor(1,1,0.5)
header:SetText("NamePlateAdvance Version "..NPA_Version)

local tooltipsbox=CreateFrame("EditBox","NPA_Options_TooltipsBox",mainframe)
tooltipsbox:Hide()
tooltipsbox:SetPoint("BOTTOMLEFT",mainframe,"TOPLEFT",0,30)
tooltipsbox:SetPoint("BOTTOMRIGHT",mainframe,"TOPRIGHT",0,30)
tooltipsbox:SetHeight(60)
tooltipsbox:SetMultiLine(1)
tooltipsbox:SetAutoFocus(nil)
tooltipsbox:EnableMouse(nil)
tooltipsbox:SetFont(GameFontNormal:GetFont(),24)
tooltipsbox:SetText(Localization["Tooltip"])

local tooltipsboxbg=tooltipsbox:CreateTexture("Crabby_ChatFrameBackground","BACKGROUND")
tooltipsboxbg:SetPoint("TOPLEFT",tooltipsbox,"TOPLEFT",-5,5)
tooltipsboxbg:SetPoint("BOTTOMRIGHT",tooltipsbox,"BOTTOMRIGHT",5,-5)
tooltipsboxbg:SetTexture("Interface\\Addons\\NPA\\texture\\Chatbubble")
tooltipsboxbg:SetTexCoord(0,1,0,0.7)
tooltipsboxbg:SetVertexColor(0.1,0.1,0.1,1)
tooltipsboxbg:Show()

local tooltipsboxbg2=tooltipsbox:CreateTexture("Crabby_ChatFrameBackground2","BACKGROUND")
tooltipsboxbg2:SetPoint("TOPLEFT",tooltipsboxbg,"BOTTOMLEFT",0,0)
tooltipsboxbg2:SetPoint("TOPRIGHT",tooltipsboxbg,"BOTTOMRIGHT",0,0)
tooltipsboxbg2:SetTexture("Interface\\Addons\\NPA\\texture\\Chatbubble")
tooltipsboxbg2:SetTexCoord(0.25,1,0.7,1)
tooltipsboxbg2:SetVertexColor(0.1,0.1,0.1,1)
tooltipsboxbg2:SetHeight(20)
tooltipsboxbg2:Show()


local function SetTooltip(text)
	if(text)then
		tooltipsbox:SetText(text)
		tooltipsbox:Show()
	else
		tooltipsbox:Hide()
	end
end

local function SetTooltipScript(frame,tooltip)
	if(frame and tooltip)then
		frame.Tooltip=tooltip
		frame:HookScript("OnEnter",function(self)
			SetTooltip(self.Tooltip)
			end)
		frame:HookScript("OnLeave",function(self)
			SetTooltip(nil)--Localization["Tooltip"])
			end)
		frame:EnableMouse(1)

	end
end

function NPA_Options:SetFrameTooltip(frame,text)
	SetTooltipScript(frame,text)
end

-----------------------------------------------------------


--options function lib--
--label
function NPA_Options:CreateLabel(name,parent,text)
	local label=parent:CreateFontString("ARTWORK",name,"GameFontNormal")
	label:SetText(text)
	return label
end
--edit box

function NPA_Options:CreateEditBox(name,parent,width,height,tooltip)
	frame=CreateFrame("EditBox",name.."EditBox",parent,"InputBoxTemplate")
	frame:SetWidth(width)
	frame:SetHeight(height)
	frame:SetAutoFocus(nil)
	frame:SetFontObject("GameFontHighlight")

	SetTooltipScript(frame,tooltip)

	frame:Show()
	return frame
end


--checkbox
local function NPA_Options_CheckBox_OnShow(self)
	self:SetChecked(NPA_Config[ActiveKey][self.Key])
	self.Value=NPA_Config[ActiveKey][self.Key]
end
local function NPA_Options_CheckBox_OnClick(self)
	self.Value=self:GetChecked()
	if(self.Value==nil)then
		self.Value=0
	end
end
function NPA_Options:CreateCheckBox(name,parent,height,text,key,tooltip)
	local checkbox=CreateFrame("CheckButton",name,parent)
	checkbox:Hide()
	checkbox:SetWidth(height)
	checkbox:SetHeight(height)
	checkbox:SetScript("OnShow",NPA_Options_CheckBox_OnShow)
	checkbox:SetScript("OnClick",NPA_Options_CheckBox_OnClick)
	
	checkbox:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up")
	checkbox:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down")
 	checkbox:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight")
	checkbox:SetDisabledCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check-Disabled")
	checkbox:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")

	if(text~=nil)then
		checkbox.Label=NPA_Options:CreateLabel(name.."label",checkbox,text);
		checkbox.Label:SetPoint("LEFT",checkbox,"RIGHT")
	end

	checkbox.Key=key

	checkbox:Show()

	SetTooltipScript(checkbox,tooltip)


	return checkbox
end

--button
function NPA_Options:CreateButton(name,parent,width,height,text,tooltip)
	local button=CreateFrame("Button","Button"..(name or nil),parent,"OptionsButtonTemplate")
	button:SetHeight(height)
	if(width==0 and text~=nil)then
		width=height*(len(text))/2
	end

	button:SetWidth(width)
	button:SetText(text)

	SetTooltipScript(button,tooltip)

	return button
end

-- frame
function NPA_Options:CreateFrame(name,parent,text,tooltip)
	local frame=CreateFrame("Frame",name.."Frame",parent)
	--"Interface\\Tooltips\\UI-Tooltip-Background"
	frame:SetBackdrop({ bgFile = "Interface\\ChatFrame\\ChatFrameBackground", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = 0, tileSize = 1, edgeSize = 16, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
	frame:SetBackdropColor(0.1,0.1,0.1,1)
	frame:SetBackdropBorderColor(1,1,1,1)
	
	if(text~=nil)then
		local header=NPA_Options:CreateLabel(name.."_Header",frame,text)
		header:SetFont(GameFontNormal:GetFont(),22,"THICKOUTLINE")
		header:SetPoint("BOTTOM",frame,"TOP",0,0)
		header:SetTextColor(1,1,0.5)
		frame.Text=header
	end

	SetTooltipScript(frame,tooltip)
	return frame
end


------------
local combielib=NPA_Options:CreateCheckBox("NPA_Options_CombieLib",mainframe,22,Localization["CombieLib"],nil,Tooltips["CombieLib"])
combielib:SetScript("OnShow",nil)
combielib:SetScript("OnClick",nil)
combielib:SetPoint("TOPLEFT",mainframe,"BOTTOMLEFT",0,-30)
combielib:Show()

------------------
-----------------
------slider + edit

local function NPA_Options_SliderEdit_OnEnter(self)
	local value=tonumber(self:GetText())
	local slider=self:GetParent().Slider
	local min,max=slider:GetMinMaxValues()
	if(value<min)then
		min=value
	elseif(value>max)then
		max=value
	end
	slider:SetMinMaxValues(min,max)
	slider:SetValue(value)
	self:SetText(value)
	self:GetParent().Value=value
	self:ClearFocus()
end

local function NPA_Options_SliderEdit_OnShow(self)
	local value=NPA_Config[ActiveKey][self.Key]
	self.EditBox:SetText(tostring(value))
	self.Slider:SetValue(tonumber(value))
	self.Value=value
end

local function NPA_Options_SliderEdit_OnValueChanged(self)
	local value=self:GetValue()
	self:GetParent().EditBox:SetText(value)
	self:GetParent().Value=value
end
local function NPA_Options_Slider_OnMouseWheel(self,value)
	self:SetValue(self:GetValue() + floor(value) * self:GetValueStep())
end



function NPA_Options:CreateSliderEdit(name,parent,text,key,min,max,step,width,height,tooltip)
	if(not width)then
		width=292
	end
	if(not height)then
		height=32
	end

	local frame=CreateFrame("Frame",name.."Frame",parent)
	frame:SetWidth(width)
	frame:SetHeight(height)
	frame:SetScript("OnShow",NPA_Options_SliderEdit_OnShow)
	
	frame.EditBox=CreateFrame("EditBox",name.."EditBox",frame,"InputBoxTemplate")
	frame.EditBox:SetWidth(45)
	frame.EditBox:SetHeight(11)
	frame.EditBox:SetPoint("BOTTOMLEFT")
	frame.EditBox:SetScript("OnEnterPressed",NPA_Options_SliderEdit_OnEnter)
	frame.EditBox:SetAutoFocus(nil)
	--frame.EditBox:SetNumeric(1)
	frame.EditBox:SetMaxLetters(len(tostring(max/step))+1)
	frame.EditBox:SetFontObject("GameFontHighlight")

	frame.Slider = CreateFrame("Slider",name.."Slider",frame,"OptionsSliderTemplate")
	frame.Slider:SetPoint("LEFT",frame.EditBox,"RIGHT",45)
	frame.Slider:SetPoint("BOTTOMRIGHT",0,-2)
	frame.Slider:SetMinMaxValues(min,max)
	frame.Slider:SetValueStep(step)
	frame.Slider:SetScript("OnValueChanged",NPA_Options_SliderEdit_OnValueChanged)
	frame.Slider:SetScript("OnMouseWheel",NPA_Options_Slider_OnMouseWheel)
	frame.Slider:EnableMouseWheel(1)
	
	if(text~=nil)then
		frame.Text=NPA_Options:CreateLabel(name.."_Header",frame,text)
		frame.Text:SetFont(GameFontNormal:GetFont(),12)
		frame.Text:SetPoint("TOP",frame,"TOP",0,-5)
		frame.Text:SetTextColor(1,1,0.5)
	end

	frame.Key=key

	SetTooltipScript(frame.Slider,tooltip)
	SetTooltipScript(frame.EditBox,tooltip)

	return frame
end
------------------------------

local function SpellNameToTexture(name)
	for j=1,100000 do
		local spellname,_,texture=GetSpellInfo(j)
		if(spellname==name and texture)then
			return texture
		end
	end
end
--------------------
--dropdown menu

function NPA_Options:InitDropDownMenu(main,abuttonlist,onclickfunc)
	frame=main.Frame

	local buttonlist={}
	for name,value in pairs(abuttonlist) do
		if(name~="DeepCheck")then
			table_insert(buttonlist,{Name=name,Value=value})
		end
	end
	table_sort(buttonlist,function(a,b) return a.Name<b.Name end)
	
	frame:SetWidth(1)
	frame:SetHeight(1)
	local size=table_getn(frame.Buttons)
	local count=1

	if(buttonlist)then
		for i=1,table_getn(buttonlist) do
			local name,value = buttonlist[i].Name,buttonlist[i].Value

			if(count>table_getn(frame.Buttons))then
				frame.Buttons[count]=NPA_Options:CreateCheckBox("NPA_Options_Aura_DropDown"..name,frame,18,name,name)
				local spellicon=frame.Buttons[count]:CreateTexture()
				frame.Buttons[count].Spellicon=spellicon
				spellicon:SetHeight(18)
				spellicon:SetWidth(18)
				spellicon:SetPoint("LEFT",frame.Buttons[count].Label,"RIGHT",5,0)
			end
			local icon

			if(name and main.ShowIcon==1)then
				local texture=SpellNameToTexture(name)
				if(texture)then
					frame.Buttons[count].Spellicon:SetTexture(texture)
					frame.Buttons[count].Spellicon:Show()
					icon=1
				else
					frame.Buttons[count].Spellicon:Hide()
				end
			else
				frame.Buttons[count].Spellicon:Hide()
			end

			local displayname
			if(main.Localization and main.Localization[name])then
				displayname=main.Localization[name]
			else
				displayname=name
			end

			frame.Buttons[count].Label:SetText(displayname)
			frame.Buttons[count]:SetScript("OnClick",onclickfunc)
			frame.Buttons[count]:SetScript("OnShow",nil)
			frame.Buttons[count].Value=value
			frame.Buttons[count].Key=name
			frame.Buttons[count]:SetPoint("TOPLEFT",frame,"TOPLEFT",5,-frame:GetHeight()-3)
			if(value==1)then
				frame.Buttons[count]:SetChecked(1)
			else
				frame.Buttons[count]:SetChecked(nil)
			end
		
			frame.Buttons[count]:Show()
			local width=frame.Buttons[count]:GetWidth()+frame.Buttons[count].Label:GetWidth()+20
			if(icon)then
				width=width+28
			end
			if(frame:GetWidth()<width)then
				frame:SetWidth(width)
			end
			frame:SetHeight(frame:GetHeight()+frame.Buttons[count]:GetHeight()+5)
			count=count+1
		end
	end

	main.Slider:SetValue(0)

	local height=frame:GetHeight()
	if(height>500)then
		main:SetHeight(500)
		main.Slider:SetMinMaxValues(0,height-500)
		main.Slider:Show()
	else
		main:SetHeight(height)
		main.Slider:Hide()
	end


	main:SetWidth(frame:GetWidth()+10)
	main:SetVerticalScroll(1)
	main:SetHorizontalScroll(1)

	for i=count,size do
		frame.Buttons[i]:Hide()
	end
end

function NPA_Options:CreateDropDownMenu(name,parent)
	local frame=NPA_Options:CreateFrame(name.."DropDownMenu",parent)
	frame:Show()
	frame.Buttons={}
	frame:SetHeight(1)
	frame:SetWidth(1)
	frame:SetFrameStrata("HIGH")

	local dropdown=CreateFrame("ScrollFrame","NPA_DropDown_ScrollFrame",parent)
	dropdown:SetFrameStrata("HIGH")
	dropdown:Hide()
	dropdown:SetClampedToScreen(1)
	dropdown:SetWidth(1)
	dropdown:SetHeight(1)

	local dropdownslider = CreateFrame("Slider","NPA_DropDown_Slider",dropdown,"OptionsSliderTemplate")
	dropdownslider:SetPoint("TOPLEFT",dropdown,"TOPRIGHT",-8,0)
	dropdownslider:SetPoint("BOTTOMLEFT",dropdown,"BOTTOMRIGHT",-8,0)
	dropdownslider:SetMinMaxValues(0,1)
	dropdownslider:SetValueStep(1)
	dropdownslider:SetValue(0)
	dropdownslider:SetOrientation("VERTICAL")
	dropdownslider:SetWidth(10)
	dropdownslider.Parent=dropdown
	dropdownslider:SetScript("OnValueChanged",function(self)
			self.Parent:SetVerticalScroll(self:GetValue())
		end)
	dropdownslider:SetScript("OnMouseWheel",function(self,value)
			self:SetValue(self:GetValue() - floor(value) * self:GetValueStep())
		end)
	dropdownslider:EnableMouseWheel(1)
	
	dropdown:EnableMouseWheel(1)
	dropdown.Slider=dropdownslider
	dropdown:SetScript("OnMouseWheel",function(self,value)
			local slider=self.Slider
			if(slider:IsShown())then
				slider:SetValue(slider:GetValue() - floor(value) * slider:GetValueStep()*40)
			end
		end)

	dropdown:SetScrollChild(frame)
	dropdown.Frame=frame
	frame.Main=dropdown
	frame.Slider=dropdownslider

	frame:SetPoint("TOPLEFT",dropdown,"TOPLEFT",0,0)

	return dropdown
end

--checklistedit
------------------
--checklist functions
local function NPA_Options_Checklist_DropDownButton_OnClick(self)
	local parent=self:GetParent():GetParent():GetParent()
	local key=parent.Key

	local check=self:GetChecked()
	if(check)then
		NPA_Config[ActiveKey][key][self.Key]=1
	else
		NPA_Config[ActiveKey][key][self.Key]=3
	end

	if(parent.Box)then
		parent.Box:SetText(self.Key)
	end
end

local function NPA_Options_Checklist_DropDown_OnShow(self)
	local key=self:GetParent().Key
	NPA_Options:InitDropDownMenu(self,NPA_Config[ActiveKey][key],NPA_Options_Checklist_DropDownButton_OnClick)
end

local function NPA_Options_Checklist_Add(self)
	local parent=self:GetParent()
	local text=parent.Box:GetText()
	if(text~=nil)then
		local key=parent.Key
		local dropdown=parent.DropDown
		NPA_Config[ActiveKey][key][text]=1
		NPA_Options:InitDropDownMenu(dropdown,NPA_Config[ActiveKey][key],NPA_Options_Checklist_DropDownButton_OnClick)
		dropdown:Show()
	end
end

local function NPA_Options_Checklist_Remove(self)
	local parent=self:GetParent()
	local text=parent.Box:GetText()
	if(text~=nil)then
		local dropdown=parent.DropDown
		local key=parent.Key
		NPA_Config[ActiveKey][key][text]=nil
		NPA_Options:InitDropDownMenu(dropdown,NPA_Config[ActiveKey][key],NPA_Options_Checklist_DropDownButton_OnClick)
		dropdown:Show()
	end
end

local function NPA_Options_Checklist_Seek(self)
	local dropdown=self:GetParent().DropDown
	if(dropdown:IsShown())then
		dropdown:Hide()
	else
		dropdown:Show()
	end
end
local function NPA_Options_Checklist_Reset(self)
	local key=self:GetParent().Key
	local dropdown=self:GetParent().DropDown
	NPA_Config[ActiveKey][key]={}
	NPA_Options:InitDropDownMenu(dropdown,NPA_Config[ActiveKey][key],NPA_Options_Checklist_DropDownButton_OnClick)
	dropdown:Hide()
end

-----------createfunction

function NPA_Options:CreateCheckListEdit(name,parent,text,key,tooltip,localization)
	local checklist=NPA_Options:CreateFrame(name.."frame",parent)
	checklist:SetWidth(190)
	checklist:SetHeight(46)

	SetTooltipScript(checklist,tooltip)


	local label=NPA_Options:CreateLabel(name.."label",checklist,text)
	label:SetPoint("TOPLEFT",checklist,"TOPLEFT",6,-6)

	local button4=NPA_Options:CreateButton(name.."_Reset",checklist,0,18,Localization["Reset"],Tooltips["Reset"])
	button4:SetPoint("TOPRIGHT",checklist,"TOPRIGHT",-3,-3)

	local button2=NPA_Options:CreateButton(name.."_Remove",checklist,0,18,Localization["Remove"],Tooltips["Remove"])
	button2:SetPoint("RIGHT",button4,"LEFT")

	local button1=NPA_Options:CreateButton(name.."_Add",checklist,0,18,Localization["Add"],Tooltips["Add"])
	button1:SetPoint("RIGHT",button2,"LEFT")

	local editbox=NPA_Options:CreateEditBox(name.."editbox",checklist,155,32)
	editbox:SetPoint("TOPLEFT",label,"BOTTOMLEFT",5,3)
	editbox:HookScript("OnEnterPressed",function(self)
		self:ClearFocus()
		end)

	local button3=NPA_Options:CreateButton(name.."open",checklist,18,18,"+",Tooltips["Open"])
	button3:SetPoint("LEFT",editbox,"RIGHT")

	local dropdown=NPA_Options:CreateDropDownMenu(name.."dropdown",checklist,localization)
	dropdown:SetPoint("LEFT",button3,"RIGHT")

	checklist.Button1=button1
	checklist.Button2=button2
	checklist.Button3=button3
	checklist.Button4=button4
	checklist.Label=label
	checklist.Box=editbox
	checklist.DropDown=dropdown
	checklist.Key=key
	
	button1:SetScript("OnClick",NPA_Options_Checklist_Add)
	button2:SetScript("OnClick",NPA_Options_Checklist_Remove)
	button3:SetScript("OnClick",NPA_Options_Checklist_Seek)
	button4:SetScript("OnClick",NPA_Options_Checklist_Reset)

	dropdown.Localizaton=localization
	dropdown:SetScript("OnShow",NPA_Options_Checklist_DropDown_OnShow)

	return checklist	
end

function NPA_Options:CreateCheckListEdit2(name,parent,text,key,tooltip,showicon,localization)
	local checklist=NPA_Options:CreateFrame(name.."frame",parent)
	checklist:SetWidth(190)
	checklist:SetHeight(26)

	SetTooltipScript(checklist,tooltip)

	local button=NPA_Options:CreateButton(name.."open",checklist,18,18,"+",Tooltips["Open"]..";"..(tooltip or ""))
	button:SetPoint("RIGHT",checklist,"RIGHT",-3,0)
	button:SetPoint("LEFT",checklist,"LEFT",3,0)
	button:SetText(text)

	local dropdown=NPA_Options:CreateDropDownMenu(name.."dropdown",checklist)
	dropdown:SetPoint("LEFT",button,"RIGHT")

	checklist.Button3=button3
	checklist.DropDown=dropdown
	checklist.Key=key

	button:SetScript("OnClick",NPA_Options_Checklist_Seek)

	dropdown.Localization=localization
	dropdown:SetScript("OnShow",NPA_Options_Checklist_DropDown_OnShow)

	dropdown.ShowIcon=showicon

	return checklist	
end
------------------------
local function NPA_Options_CheckList_GetValue(frame)
	local value={}
	for _,checkbox in pairs(frame.CheckBoxs) do
		if(checkbox:GetChecked())then
			value[checkbox.Key]=1
		else
			value[checkbox.Key]=nil
		end
	end
	return value
end
local function NPA_Options_CheckList_SetValue(frame,valuelist)
	for _,checkbox in pairs(frame.CheckBoxs) do
		if(valuelist[checkbox.Key])then
			checkbox:SetChecked(1)
		else
			checkbox:SetChecked(nil)
		end
	end
end

local function NPA_Options_Checklist_DropDownButton_OnClick3(self)
	local parent=self:GetParent():GetParent():GetParent()
	local key=parent.Key
	
	parent.Box:SetText(self.Key)
	parent.Box.OnEnterPressed(parent.Box)

	NPA_Options_CheckList_SetValue(parent.Frame1,self.Value.List1)
	NPA_Options_CheckList_SetValue(parent.Frame2,self.Value.List2)
end

local function NPA_Options_Checklist_Add3(self)
	local parent=self:GetParent()
	local text=parent.Box:GetText()
	if(text~=nil)then
		local key=parent.Key
		local dropdown=parent.DropDown
		NPA_Config[ActiveKey][key][text]={
			List1=NPA_Options_CheckList_GetValue(parent.Frame1),
			List2=NPA_Options_CheckList_GetValue(parent.Frame2),
			}

		dropdown.Init(dropdown)
		dropdown:Show()
	end
end

local function NPA_Options_Checklist_Remove3(self)
	local parent=self:GetParent()
	local text=parent.Box:GetText()
	if(text~=nil)then
		local dropdown=parent.DropDown
		local key=parent.Key
		NPA_Config[ActiveKey][key][text]=nil
		dropdown.Init(dropdown)
		dropdown:Show()
	end
end

local function NPA_Options_Checklist_Seek3(self)
	local dropdown=self:GetParent().DropDown
	if(dropdown:IsShown())then
		dropdown:Hide()
	else
		dropdown:Show()
	end
end
local function NPA_Options_Checklist_Reset3(self)
	local key=self:GetParent().Key
	local dropdown=self:GetParent().DropDown
	NPA_Config[ActiveKey][key]={}
	dropdown.Init(dropdown)
	dropdown:Hide()
end
local function NPA_Options_Checklist_DropDown_OnShow3(self)
	self.Init(self)
end


function NPA_Options:BuildCheckBoxList3(frame,valuelist)
	local count=0
	local width=0
	local buttonlist={}
	for key,name in pairs(valuelist)do
		table_insert(buttonlist,{Name=name,Key=key})
	end
	table_sort(buttonlist,function(a,b) return a.Name<b.Name end)

	local checkboxs={}
	for i=1,table_getn(buttonlist)do
		local key=buttonlist[i].Key
		local name=buttonlist[i].Name
		
		local checkbox=NPA_Options:CreateCheckBox("Checkbox Temp",frame,20,name,key)
		checkbox:SetPoint("TOPLEFT",frame,"TOPLEFT",6,-6-count*22)
		count=count+1
		
		local swap=checkbox:GetWidth()+checkbox.Label:GetWidth()+12
		if(swap>width)then
			width=swap
		end

		table_insert(checkboxs,checkbox)
	end
	frame:SetHeight(count*22+12)
	frame:SetWidth(width)

	frame.CheckBoxs=checkboxs
end

function NPA_Options:CreateCheckListEdit3(name,parent,text2,text3,key,valuelist1,valuelist2)
	local checklist=NPA_Options:CreateFrame(name.."frame",parent)

	SetTooltipScript(checklist,tooltip)

	local button1=NPA_Options:CreateButton(name.."_Add",checklist,0,18,Localization["Add"],Tooltips["Add"])
	button1:SetPoint("TOPLEFT",checklist,"TOPLEFT",5,-3)

	local button2=NPA_Options:CreateButton(name.."_Remove",checklist,0,18,Localization["Remove"],Tooltips["Remove"])
	button2:SetPoint("LEFT",button1,"RIGHT",5,0)

	local button4=NPA_Options:CreateButton(name.."_Reset",checklist,0,18,Localization["Reset"],Tooltips["Reset"])
	button4:SetPoint("LEFT",button2,"RIGHT",5,0)

	local label=NPA_Options:CreateLabel(name.."label",checklist,Localization["Id"])
	label:SetPoint("TOPLEFT",button1,"BOTTOMLEFT",0,-3)

	local editbox=NPA_Options:CreateEditBox(name.."editbox",checklist,155,32)
	editbox:SetPoint("LEFT",label,"RIGHT",5,0)
	editbox:SetPoint("RIGHT",checklist,"RIGHT",-25,0)
	editbox.OnEnterPressed=function(self)
			local text=GetSpellInfo(tonumber(self:GetText()) or 0)
			self:GetParent().Label2:SetText(Localization["Name"]..": |cffffff00"..(text or "none"))
			self:ClearFocus()
		end
	editbox:HookScript("OnEnterPressed",function(self)
			self.OnEnterPressed(self)
		end)
	local label2=NPA_Options:CreateLabel(name.."label2",checklist,Localization["Name"])
	label2:SetPoint("TOPLEFT",label,"BOTTOMLEFT",0,-6)

	local button3=NPA_Options:CreateButton(name.."open",checklist,18,18,"+",Tooltips["Open"])
	button3:SetPoint("LEFT",editbox,"RIGHT")

	local frame1=NPA_Options:CreateFrame(name.."frame1",checklist,text2)
	frame1:SetPoint("TOPLEFT",label2,"BOTTOMLEFT",0,-29)
	NPA_Options:BuildCheckBoxList3(frame1,valuelist1)

	local frame2=NPA_Options:CreateFrame(name.."frame2",checklist,text3)
	frame2:SetPoint("TOPLEFT",frame1,"BOTTOMLEFT",0,-29)
	NPA_Options:BuildCheckBoxList3(frame2,valuelist2)

	checklist:SetHeight(120+frame1:GetHeight()+frame2:GetHeight())
	local width=frame1:GetWidth()
	if(width<frame2:GetWidth())then
		width=frame2:GetWidth()
	elseif(width<190)then
		width=190
	end
	checklist:SetWidth(width)

	checklist.Button1=button1
	checklist.Button2=button2
	checklist.Button3=button3
	checklist.Button4=button4
	checklist.Frame1=frame1
	checklist.Frame2=frame2
	checklist.Label=label
	checklist.Label2=label2
	checklist.Box=editbox
	checklist.Key=key
		
	button1:SetScript("OnClick",NPA_Options_Checklist_Add3)
	button2:SetScript("OnClick",NPA_Options_Checklist_Remove3)
	button3:SetScript("OnClick",NPA_Options_Checklist_Seek3)
	button4:SetScript("OnClick",NPA_Options_Checklist_Reset3)

	local dropdown=NPA_Options:CreateDropDownMenu(name.."dropdown",checklist)
	dropdown:SetPoint("LEFT",button3,"RIGHT")

	checklist.DropDown=dropdown
	
	dropdown:SetScript("OnShow",NPA_Options_Checklist_DropDown_OnShow3)
	dropdown.Buttons={}
	dropdown.Init=function(self)
			NPA_Options:InitDropDownMenu2(self.Frame,NPA_Config[ActiveKey][self:GetParent().Key],NPA_Options_Checklist_DropDownButton_OnClick3,1,8)
		end

	return checklist	
end

------------------------------------------------
----------------editlist
--------------------------------------------------

function NPA_Options:InitDropDownMenu2(frame,abuttonlist,onclickfunc,limitrow,type)
	local buttonlist={}
	for name,value in pairs(abuttonlist) do
		if(type==3 and NPA_Options_AnchorLib_Localization[name])then
			table_insert(buttonlist,{Name=NPA_Options_AnchorLib_Localization[name],Value=(value or "CENTER")})
		elseif(type==7)then
			table_insert(buttonlist,{Name=value,Value=name})
		else
			table_insert(buttonlist,{Name=name,Value=(value or "")})
		end
	end

	if(type==5)then
		table_sort(buttonlist,function(a,b)
			local namea=GetSpellInfo(a.Name) or ""
			local nameb=GetSpellInfo(b.Name) or ""
			return namea<nameb
			end)
	else
		table_sort(buttonlist,function(a,b) return a.Name<b.Name end)
	end

	local defaultfont=GameFontNormal:GetFont()

	frame:SetWidth(12)
	frame:SetHeight(12)
	local size=table_getn(frame.Buttons)
	local count=1
	local row=15
	local maxwidth=50
	if(limitrow)then
		row=limitrow
	end

	local aheight
	if(type==5)then
		aheight=17
	else
		aheight=33
	end

	if(buttonlist)then
		for i=1,table_getn(buttonlist) do
			local spellid,value=buttonlist[i].Name,buttonlist[i].Value

			local button=frame.Buttons[count]
			if(not button)then
				button=CreateFrame("Button","NPA_Options_DropDownMenu_Button",frame,nil)
				frame.Buttons[count]=button

				button:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
				button.Text = button:CreateFontString(nil,"ARTWORK","GameFontNormal");
				button.Text:SetPoint("LEFT",button,"LEFT",5,0)
			end
			if(type==1)then
				button:SetNormalTexture(value)
			else
				button:SetNormalTexture(nil)
			end
			if(type==2)then
				button.Text:SetFont(value,15,"OUTLINE")
			elseif(type==4)then
				button.Text:SetFont(defaultfont,15,value)
			else
				button.Text:SetFont(defaultfont,15,"OUTLINE")				
			end

			button.Text:SetPoint("CENTER",button,"CENTER",0,0)
			if(type==5)then
				button.Text:SetText("|cff00ff00["..(GetSpellInfo(spellid) or "").."] |cffffff00("..spellid..") |cffffffff= "..value)
			elseif(type==6)then
				button.Text:SetText("|cff00ff00["..spellid.."] = "..value)
			elseif(type==8)then
				button.Text:SetText("|cff00ff00["..(GetSpellInfo(spellid or 0) or "").."] |cffffff00("..spellid..")")
			else
				button.Text:SetText(spellid)
			end
			button:SetScript("OnClick",onclickfunc)
			button:SetScript("OnShow",nil)
			button.Value=value
			button.Key=spellid
			local offset=count-1
			local offsetx=offset % row * 50 + 6
			local offsety=floor(offset/row) * aheight + 6
			if(limitrow)then
				button:SetPoint("TOP",frame,"TOP",0,-offsety)
			else
				button:SetPoint("TOPLEFT",frame,"TOPLEFT",10+offsetx,-offsety)
			end

			local width=button.Text:GetWidth()+20
			button:SetHeight(aheight-5)
			button:Show()

			frame:SetHeight(frame:GetHeight()+aheight)

			if(maxwidth<width)then
				maxwidth=width
			end

			count=count+1
		end
	end


	for j=1,count-1 do
		frame.Buttons[j]:SetWidth(maxwidth)
	end

	local height=frame:GetHeight()
	frame:SetWidth(maxwidth+10)

	if(frame.Main)then
		frame.Main:SetWidth(maxwidth+15)
	
		if(height>500)then
			frame.Slider:SetMinMaxValues(0,height-500)
			height=500
			frame.Slider:Show()
		else
			frame.Slider:Hide()
		end
		
		frame.Slider:SetValue(0)
		frame.Main:SetVerticalScroll(1)
		frame.Main:SetHorizontalScroll(1)
		frame.Main:SetHeight(height)
	end

	for i=count,size do
		frame.Buttons[i]:Hide()
	end
end

--------------------------
----------------------------

--editbox--
local function NPA_Options_EditBox_OnEnter(self)
	self:ClearFocus()
	self.Value=self:GetText()
	if(self.Type==2)then
		self.Font:SetFont(self.Value,11)
		self.Font:Show()
		self.Texture:Hide()
	else
		NPA_Core:TextureManager(self.Texture,self.Value)
		self.Font:Hide()
		self.Texture:Show()
	end
	if(self.OnValueChanged)then
		self.OnValueChanged(self)
	end

end

local function NPA_Options_EditBox_OnShow(self)
	local value=tostring(NPA_Config[ActiveKey][self.Key])
	self:SetText(value)
	if(self.Type==2)then
		self.Font:SetFont(value,11)
		self.Font:Show()
		self.Texture:Hide()
	else
		NPA_Core:TextureManager(self.Texture,value)
		self.Texture:Show()
		self.Font:Hide()
	end
	NPA_Core:TextureManager(self.Texture,self.Value)
	self.Value=value
	if(self.OnValueChanged)then
		self.OnValueChanged(self)
	end

end

local function NPA_Options_EditBox_OnHide(self)
	if(self.Type==2)then
		return 
	else
		NPA_Core:TextureManager(self.Texture,nil)
	end
end
----------------texture edit box
local function NPA_Options_TextureDropDownButtonOnClick(self)
	local parent=self:GetParent()
	local owner=parent.Owner
	owner:SetText(self.Key)
	if(owner.Type~=4 and owner.Type~=3)then
		owner:ClearFocus()
		NPA_Core:TextureManager(owner.Texture,self.Value)
	end
	owner.Value=self.Value
	if(owner.OnValueChanged)then
		owner.OnValueChanged(owner)
	end

	parent.Main:Hide()
end
---------
local function NPA_Options_AnchorDropDownButtonOnClick(self)
	local parent=self:GetParent()
	local owner=parent.Owner
	owner.Value=self.Value
	owner.OnValueChanged(owner)
	
	parent.Main:Hide()
end

-----------------
local function NPA_Options_DropDownSelectButtonOnClick(self)
	local parent=self:GetParent()
	local owner=parent.Owner
	owner.Value=self.Value
	owner.OnValueChanged(owner)
	parent.Main:Hide()
end


--EditList functions
local function NPA_Options_EditList_DropDownButton_OnClick(self)
	local parent=self:GetParent().Owner
	parent.Box:SetText(self.Key)
	parent.Box2:SetText(self.Value)
	parent.Label:SetText(GetSpellInfo(self.Key))
end


-------texture dropdown
local texturedropdown=CreateFrame("ScrollFrame","NPA_TextureDropDown_ScrollFrame",mainframe)
texturedropdown:SetFrameStrata("DIALOG")
texturedropdown:Hide()
texturedropdown:SetClampedToScreen(1)
texturedropdown:SetWidth(1)
texturedropdown:SetHeight(1)

local texturedropdownslider = CreateFrame("Slider","NPA_TextureDropDown_Slider",texturedropdown,"OptionsSliderTemplate")
texturedropdownslider:SetPoint("TOPLEFT",texturedropdown,"TOPRIGHT",-8,0)
texturedropdownslider:SetPoint("BOTTOMLEFT",texturedropdown,"BOTTOMRIGHT",-8,0)
texturedropdownslider:SetMinMaxValues(0,1)
texturedropdownslider:SetValueStep(1)
texturedropdownslider:SetValue(0)
texturedropdownslider:SetOrientation("VERTICAL")
texturedropdownslider:SetWidth(10)
texturedropdownslider.Parent=texturedropdown
texturedropdownslider:SetScript("OnValueChanged",function(self)
		self.Parent:SetVerticalScroll(self:GetValue())
	end)
texturedropdownslider:SetScript("OnMouseWheel",function(self,value)
		self:SetValue(self:GetValue() - floor(value) * self:GetValueStep())
	end)
texturedropdownslider:EnableMouseWheel(1)

texturedropdown:EnableMouseWheel(1)
texturedropdown.Slider=texturedropdownslider
texturedropdown:SetScript("OnMouseWheel",function(self,value)
		local slider=self.Slider
		if(slider:IsShown())then
			slider:SetValue(slider:GetValue() - floor(value) * slider:GetValueStep()*40)
		end
	end)

local texturedropdownmain=NPA_Options:CreateFrame("NPA_TextureDropDownMenu",texturedropdown)
texturedropdown:SetScrollChild(texturedropdownmain)

texturedropdownmain:SetFrameStrata("DIALOG")
texturedropdownmain:SetPoint("TOPLEFT",texturedropdown,"TOPLEFT",0,0)
texturedropdownmain:Show()
texturedropdownmain.Main=texturedropdown
texturedropdownmain.Slider=texturedropdownslider
texturedropdownmain.Buttons={}
texturedropdownmain:SetHeight(1)
texturedropdownmain:SetWidth(1)
texturedropdownmain:SetScript("OnShow",function(self)
		self.Owner=texturedropdown.Owner

		local maintype=self.Main.Type
		local buttonlist
		local type

		if(maintype==nil)then
			buttonlist=CopyTable(NPA_Options_BarTextureLib)
			if(LibStub)then
				local sharemedia=LibStub:GetLibrary("LibSharedMedia-3.0")
				for name,value in pairs(sharemedia.MediaTable.statusbar) do
					buttonlist[name]=value
				end
			end
			if(combielib:GetChecked()==1)then
				for name,value in pairs(NPA_Options_IndicatorTextureLib) do
					buttonlist[name]=value
				end
				for name,value in pairs(NPA_Options_BorderTextureLib) do
					buttonlist[name]=value
				end

				if(LibStub)then
					local sharemedia=LibStub:GetLibrary("LibSharedMedia-3.0")
					for name,value in pairs(sharemedia.MediaTable.border) do
						buttonlist[name]=value
					end
				end
			end

			type=1
		elseif(maintype==1)then
			buttonlist=CopyTable(NPA_Options_BorderTextureLib)
			if(LibStub)then
				local sharemedia=LibStub:GetLibrary("LibSharedMedia-3.0")
				for name,value in pairs(sharemedia.MediaTable.border) do
					buttonlist[name]=value
				end
			end
			type=1
		elseif(maintype==2)then
			buttonlist=CopyTable(NPA_Options_FontLib)
			if(LibStub)then
				local sharemedia=LibStub:GetLibrary("LibSharedMedia-3.0")
				for name,value in pairs(sharemedia.MediaTable.font) do
					buttonlist[name]=value
				end
			end
			type=2
		elseif(maintype==3)then
			buttonlist=CopyTable(NPA_Options_BlendMode)
			type=3
		elseif(maintype==4)then
			buttonlist=CopyTable(NPA_Options_FontMode)
			type=4
		elseif(maintype==5)then
			buttonlist=CopyTable(NPA_Options_IndicatorTextureLib)

			if(combielib:GetChecked()==1)then
				for name,value in pairs(NPA_Options_BarTextureLib) do
					buttonlist[name]=value
				end
				for name,value in pairs(NPA_Options_BorderTextureLib) do
					buttonlist[name]=value
				end

				if(LibStub)then
					local sharemedia=LibStub:GetLibrary("LibSharedMedia-3.0")
					for name,value in pairs(sharemedia.MediaTable.statusbar) do
						buttonlist[name]=value
					end
					local sharemedia=LibStub:GetLibrary("LibSharedMedia-3.0")
					for name,value in pairs(sharemedia.MediaTable.border) do
						buttonlist[name]=value
					end
				end
			end

			type=1
		elseif(maintype==6)then
			buttonlist=CopyTable(NPA_Options_AnchorLib)
			type=3
		elseif(maintype==7)then
			buttonlist=CopyTable(NPA_Config[ActiveKey][self.Owner.Key])
			type=5
		elseif(maintype==8)then
			buttonlist=CopyTable(NPA_Config[ActiveKey][self.Owner.Key])
			type=6
		elseif(maintype==9)then
			type=7
			buttonlist=CopyTable(self.Owner.Localization)
		end

		if(maintype==7)then
			NPA_Options:InitDropDownMenu2(self,buttonlist,NPA_Options_EditList_DropDownButton_OnClick,1,type)
		elseif(maintype==6)then
			NPA_Options:InitDropDownMenu2(self,buttonlist,NPA_Options_AnchorDropDownButtonOnClick,1,type)
		elseif(maintype==9)then
			NPA_Options:InitDropDownMenu2(self,buttonlist,NPA_Options_DropDownSelectButtonOnClick,1,type)
		else
			NPA_Options:InitDropDownMenu2(self,buttonlist,NPA_Options_TextureDropDownButtonOnClick,1,type)
		end

	end)

local button1=NPA_Options:CreateButton("NPA_Option_SliderDropdown_Close",texturedropdown,24,24,"X",Tooltips["Close"])
button1:SetPoint("TOPLEFT",texturedropdown,"TOPRIGHT",0,0)
button1:SetScript("OnClick",function(self) self:GetParent():Hide() end)

local function NPA_Options_DropDownSelect_OnClick(self)
	if(texturedropdown:IsShown() and texturedropdown.Owner==self:GetParent())then
		texturedropdown:Hide()
	else
		texturedropdown.Owner=self:GetParent()
		texturedropdown.Type=self.Type
		texturedropdown:Hide()
		texturedropdown:SetPoint("LEFT",self,"RIGHT",0,0)
		texturedropdown:Show()
	end
end

local function NPA_Options_DropDownSelect_OnClick2(self)
	if(texturedropdown:IsShown() and texturedropdown.Owner==self:GetParent())then
		texturedropdown:Hide()
	else
		texturedropdown.Owner=self
		texturedropdown.Type=self.Type
		texturedropdown:Hide()
		texturedropdown:SetPoint("LEFT",self,"RIGHT",0,0)
		texturedropdown:Show()
	end
end
----------------------------------------------
function NPA_Options:CreateDropDownSelect(name,parent,width,height,text,key,localization,tooltip)
	local frame=NPA_Options:CreateFrame(name.." MainFrame",parent,nil)
	frame:SetHeight(height)
	frame:SetWidth(width)
	frame:Hide()

	frame.OnValueChanged=function(self)
			self.Label2:SetText(self.Localization[self.Value])
		end
	frame:SetScript("OnShow",function(self)
			local value=tonumber(NPA_Config[ActiveKey][self.Key])
			self.Value=value
			self.Label2:SetText(self.Localization[value])
		end)

	frame.Label=NPA_Options:CreateLabel(name.." Label",frame,text.." :")
	frame.Label:SetPoint("LEFT",3,0)

	frame.Label2=NPA_Options:CreateLabel(name.." Label2",frame,"")
	frame.Label2:SetPoint("RIGHT",-3,0)

	frame.Button=NPA_Options:CreateButton(name.."DropDownButton",frame,0,height,"+",Tooltips["Open"])
	frame.Button:SetPoint("LEFT",frame,"RIGHT",2,0)
	frame.Button:SetScript("OnClick",NPA_Options_DropDownSelect_OnClick)
	
	frame.Button.Type=9
	frame.Localization=localization
	frame.Key=key
	frame.Value=nil

	frame:Show()

	return frame
	
end
----------------------------------------------

function NPA_Options:CreateTextureEditBox(name,parent,width,height,text,key,type,tooltip)
	local editbox=NPA_Options:CreateEditBox(name.."EditBox",parent,width,height)
	editbox:SetScript("OnEnterPressed",NPA_Options_EditBox_OnEnter)
	editbox:SetScript("OnShow",NPA_Options_EditBox_OnShow)
	editbox:SetScript("OnHide",NPA_Options_EditBox_OnHide)

	editbox:SetAutoFocus(nil)
	editbox:SetMaxLetters(255)
	editbox:SetFontObject("GameFontHighlight")

	editbox.Value=nil
	editbox.Key=key
	editbox.Type=type

	if(text~=nil)then
		editbox.Text=NPA_Options:CreateLabel(name.."_Header",editbox,text)
		editbox.Text:SetPoint("BOTTOMLEFT",editbox,"TOPLEFT",0,-3)
		editbox.Text:SetTextColor(1,1,0.5)
		editbox.Text:SetText(text)
	end

	editbox.Texture=editbox:CreateTexture("NPA_Options_Texture_Preview",editbox)
	editbox.Texture:SetWidth(width)
	editbox.Texture:SetHeight(height/2)
	editbox.Texture:SetPoint("TOPLEFT",editbox,"BOTTOMLEFT")
	editbox.Texture.Top=0
	editbox.Texture.Bottom=1
	editbox.Texture.Left=0
	editbox.Texture.Right=1

	editbox.Font=editbox:CreateFontString("NPA_Options_Font_Preview","OVERLAY",nil)
	editbox.Font:SetPoint("TOPLEFT",editbox,"BOTTOMLEFT",0,-6)
	editbox.Font:SetFont(GameFontNormal:GetFont(),20,"OUTLINE")
	editbox.Font:SetText("Sample 12345")

	editbox.Button=NPA_Options:CreateButton(name.."DropDownButton",editbox,0,height,"+",Tooltips["Open"])
	editbox.Button:SetPoint("LEFT",editbox,"RIGHT",2,0)
	editbox.Button.Type=type

	editbox.Button:SetScript("OnClick",NPA_Options_DropDownSelect_OnClick)

	SetTooltipScript(editbox,tooltip)
	SetTooltipScript(editbox.Button,Tooltips["Open"])

	return editbox
end

function NPA_Options:CreateBlendModeButton(name,parent,width,height,key)
	local button=NPA_Options:CreateButton(name.."button",parent,width,height,"",Tooltips["BlendMode"])
	button.Key=key
	button.Value=nil
	button.Type=4
	button:SetScript("OnShow",function(self)
			local value=tostring(NPA_Config[ActiveKey][self.Key])
			self:SetText(value)
			self.Value=value
		end)

	button:SetScript("OnClick",function(self)
			if(texturedropdown:IsShown() and texturedropdown.Owner==self)then
				texturedropdown:Hide()
			else
				texturedropdown.Owner=self
				texturedropdown.Type=3
				texturedropdown:Hide()
				texturedropdown:SetPoint("LEFT",self,"RIGHT",0,0)
				texturedropdown:Show()
			end
		end)

	return button
end
function NPA_Options:CreateFontModeButton(name,parent,width,height,key)
	local button=NPA_Options:CreateButton(name.."button",parent,width,height,"",Tooltips["FontMode"])
	button.Key=key
	button.Value=nil
	button.Type=4
	button:SetScript("OnShow",function(self)
			local value=tostring(NPA_Config[ActiveKey][self.Key])
			if(value)then
				local text
				for name,key in pairs(NPA_Options_BlendMode)do
					if(key==value)then
						text=name
						break
					end
				end
				if(not text)then
					for name,key in pairs(NPA_Options_FontMode)do
						if(key==value)then
							text=name
							break
						end
					end
				end
				if(text)then
					self:SetText(text)
				else
					self:SetText(value)
				end
				self.Value=value
			end
		end)

	button:SetScript("OnClick",NPA_Options_DropDownSelect_OnClick2)

	return button
end


function NPA_Options:CreateBlendModeButton2(name,parent,width,height,key)
	local button=NPA_Options:CreateButton(name.."button",parent,width,height,"",Tooltips["BlendMode"])
	button.Key=key
	button.Value=nil
	button.Type=3
	button:SetScript("OnShow",function(self)
			local value=self.Parent.Owner.Value.TextureBlend
			self:SetText(value)
			self.Value=value
		end)

	button:SetScript("OnClick",NPA_Options_DropDownSelect_OnClick2)

	return button
end
function NPA_Options:CreateFontModeButton2(name,parent,width,height,key)
	local button=NPA_Options:CreateButton(name.."button",parent,width,height,"",Tooltips["FontMode"])
	button.Key=key
	button.Value=nil
	button.Type=4
	button:SetScript("OnShow",function(self)
			local value=self.Parent.Owner.Value.Mode
			if(value)then
				local text
				for name,key in pairs(NPA_Options_BlendMode)do
					if(key==value)then
						text=name
						break
					end
				end
				if(not text)then
					for name,key in pairs(NPA_Options_FontMode)do
						if(key==value)then
							text=name
							break
						end
					end
				end
				if(text)then
					self:SetText(text)
				else
					self:SetText(value)
				end
				self.Value=value
			end
		end)

	button:SetScript("OnClick",NPA_Options_DropDownSelect_OnClick2)

	return button
end
---------------------------
------------------------------
-----------scroll dropdown
-------slider dropdown
local sliderdropdown=CreateFrame("ScrollFrame","NPA_sliderDropDown_ScrollFrame",mainframe)
sliderdropdown:SetFrameStrata("HIGH")
sliderdropdown:Hide()
sliderdropdown:SetWidth(1024)
sliderdropdown:SetHeight(530)
sliderdropdown:SetMovable(1)
sliderdropdown:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)

local sliderdropdownmain=NPA_Options:CreateFrame("NPA_SliderDropDownMenu",sliderdropdown)
sliderdropdown:SetScrollChild(sliderdropdownmain)
sliderdropdown.Child=sliderdropdownmain

sliderdropdownmain:SetFrameStrata("HIGH")
sliderdropdownmain:SetPoint("TOPLEFT",texturdropdown,"TOPLEFT",0,0)
sliderdropdownmain:Show()
sliderdropdownmain.Main=sliderdropdown
sliderdropdownmain:SetHeight(530)
sliderdropdownmain:SetWidth(334)

sliderdropdownmain:SetScript("OnMouseDown", function(self) sliderdropdown:StartMoving()end)
sliderdropdownmain:SetScript("OnMouseUp", function(self) sliderdropdown:StopMovingOrSizing() end)


local sliderdropdowntext=sliderdropdown:CreateFontString("NPA_Options_SliderDropDown_Header","OVERLAY",nil)
sliderdropdowntext:SetFont(GameFontNormal:GetFont(),20,"OUTLINE")
sliderdropdowntext:SetPoint("BOTTOM",sliderdropdownmain,"TOP",0,0)

sliderdropdown.Text=sliderdropdowntext


-----------------------
local function NPA_Options_AnchorDropEditOnValueChanged(self)
	local text=self.Value
	if(text and NPA_Options_AnchorLib_Localization[text])then
		text=NPA_Options_AnchorLib_Localization[text]
	end
	self.Text:SetText(text)
end
function NPA_Options:CreateAnchorDropEdit(name,parent,width,height,text,key,tooltip)
	local anchor=NPA_Options:CreateFrame(name.."_Mainframe",parent,nil,height)
	anchor:SetHeight(height)
	anchor:SetWidth(width)

	anchor.Value="CENTER"
	anchor.Key=key

	anchor.Label=NPA_Options:CreateLabel(name.."_Header",anchor)
	anchor.Label:SetPoint("LEFT",anchor,"LEFT",3,0)
	anchor.Label:SetTextColor(1,1,1)
	anchor.Label:SetText(text..": ")
	
	anchor.Text=NPA_Options:CreateLabel(name.."_Header",anchor)
	anchor.Text:SetPoint("LEFT",anchor.Label,"RIGHT",3,0)
	
	anchor.Text:SetTextColor(1,1,0.5)
	anchor.Text:SetText("CENTER")
	
	anchor.Button=NPA_Options:CreateButton(name.."_DropDownButton",anchor,0,height,"+",Tooltips["Open"])
	anchor.Button:SetPoint("RIGHT",anchor,"RIGHT",3,0)
	anchor.Button.Type=6

	anchor.Text:SetPoint("RIGHT",anchor.Button,"LEFT",-3,0)

	anchor.OnValueChanged=NPA_Options_AnchorDropEditOnValueChanged

	anchor.Button:SetScript("OnClick",function(self)
			if(texturedropdown:IsShown() and texturedropdown.Owner==self:GetParent())then
				texturedropdown:Hide()
			else
				texturedropdown.Owner=self:GetParent()
				texturedropdown.Type=self.Type
				texturedropdown:Hide()
				texturedropdown:SetPoint("LEFT",self,"RIGHT",0,0)
				texturedropdown:Show()
			end
		end)

	anchor:SetScript("OnShow",function(self)
		if(self.Key)then
			self.Value=tostring(NPA_Config[ActiveKey][self.Key])
			self.OnValueChanged(self)
		else
			self.OnValueChanged2(self)
		end
		
		end)

	SetTooltipScript(anchor,tooltip)
	SetTooltipScript(anchor.Button,Tooltips["Open"])

	return anchor
end

--------------------
local function NPA_SliderDropEditorOnValueChanged()
	local parent=sliderdropdownmain
	if(not parent.Init)then
		local value=parent.Owner.Value
		if(parent.Type==1 or parent.Type==3)then
			value.Height=parent.Height.Value
			value.Width=parent.Width.Value
			value.Texture=parent.Texture.Value
			value.TextureBlend=parent.TextureBlend.Value

			--value.CoordX=parent.CoordX.Value
			--value.CoordY=parent.CoordY.Value
			value.Left=parent.Left.Value
			value.Right=parent.Right.Value
			value.Top=parent.Top.Value
			value.Bottom=parent.Bottom.Value
			value.RAngle=parent.RAngle.Value
			NPA_Core:TextureManager2(parent.Texture.Texture,value)

			parent.Texture.Texture2:SetWidth(value.Width)
			parent.Texture.Texture2:SetHeight(value.Height)
			parent.Texture.Texture:Show()
			parent.Texture.Font:Hide()
		elseif(parent.Type==2)then
			value.ShadowX=parent.ShadowX.Value
			value.ShadowY=parent.ShadowY.Value
			value.Size=parent.Size.Value
			value.Font=parent.Font.Value
			value.Mode=parent.FontMode.Value

			parent.Font.Font:SetFont(value.Font,value.Size,value.Mode)
			parent.Font.Font:SetShadowOffset(value.ShadowX,value.ShadowY)
			parent.Font.Font:SetTextColor(value.Red,value.Green,value.Blue,value.Alpha)

			parent.Font.Texture:Hide()
			parent.Font.Font:Show()
		end

		value.Red=parent.Red.Value
		value.Green=parent.Green.Value
		value.Blue=parent.Blue.Value
		value.Alpha=parent.Alpha.Value
	
		value.OffsetX=parent.OffsetX.Value
		value.OffsetY=parent.OffsetY.Value

		value.Anchor=parent.Anchor.Value
		value.ToAnchor=parent.ToAnchor.Value
	end

end

local function NPA_Options_CreateSliderDropSlider(offsety,name,main,text,min,max,step,tooltip)
	local slideredit=NPA_Options:CreateSliderEdit("NPA_Options_SliderDropDown"..(name or ""),main,text,nil,min,max,step,270,nil,tooltip)
	slideredit.Min=min
	slideredit.Max=max
	slideredit:SetPoint("TOPLEFT",main,"TOPLEFT",20,-6-offsety*40)
	slideredit:SetScript("OnShow",function(self)
		local min,max=self.Min,self.Max
		local value=self.Value
		if(value)then
			if(value<min)then
				min=value
			elseif(value>max)then
				max=value
			end
			self.Slider:SetMinMaxValues(min,max)
		end
		end)
	slideredit.Parent=sliderdropdownmain
	slideredit.Slider:HookScript("OnValueChanged",NPA_SliderDropEditorOnValueChanged)
	return slideredit
end

local function NPA_Options_CreateSliderDropAnchor(offset,name,text,main,tooltip)
	local anchor=NPA_Options:CreateAnchorDropEdit("NPA_Options_SliderDropDown_Anchor",sliderdropdownmain,280,22,text,nil,tooltip)
	anchor:SetPoint("TOPLEFT",sliderdropdownmain,"TOPLEFT",16,-16-offset*40)
	anchor.Parent=sliderdropdownmain

	anchor.OnValueChanged2=NPA_Options_AnchorDropEditOnValueChanged
	anchor.OnValueChanged=function(self)
		anchor.OnValueChanged2(self)
		NPA_SliderDropEditorOnValueChanged()
		end
	
	return anchor
end

sliderdropdownmain.OffsetX=NPA_Options_CreateSliderDropSlider(0,"NPA_Options_SliderDropDown_OffsetX",sliderdropdownmain,Localization["OffsetX"],-100,100,1,Tooltips["OffsetX"])
sliderdropdownmain.OffsetY=NPA_Options_CreateSliderDropSlider(1,"NPA_Options_SliderDropDown_OffsetY",sliderdropdownmain,Localization["OffsetY"],-100,100,1,Tooltips["OffsetY"])

sliderdropdownmain.Anchor=NPA_Options_CreateSliderDropAnchor(2,"NPA_Options_SliderDropDown_Anchor",Localization["Anchor"],sliderdropdownmain)
sliderdropdownmain.ToAnchor=NPA_Options_CreateSliderDropAnchor(2.6,"NPA_Options_SliderDropDown_ToAnchor",Localization["ToAnchor"],sliderdropdownmain)

sliderdropdownmain.Red=NPA_Options_CreateSliderDropSlider(3.4,"NPA_Options_SliderDropDown_Red",sliderdropdownmain,Localization["Red"],0,1,0.01,Tooltips["Red"])
sliderdropdownmain.Green=NPA_Options_CreateSliderDropSlider(4.4,"NPA_Options_SliderDropDown_Green",sliderdropdownmain,Localization["Green"],0,1,0.01,Tooltips["Green"])
sliderdropdownmain.Blue=NPA_Options_CreateSliderDropSlider(5.4,"NPA_Options_SliderDropDown_Blue",sliderdropdownmain,Localization["Blue"],0,1,0.01,Tooltips["Blue"])
sliderdropdownmain.Alpha=NPA_Options_CreateSliderDropSlider(6.4,"NPA_Options_SliderDropDown_Alpha",sliderdropdownmain,Localization["Alpha"],0,1,0.01,Tooltips["Alpha"])

------------texturelistframe

local listframe=NPA_Options:CreateFrame("NPA_Options_SliderDrop_Texture",sliderdropdownmain)
listframe:SetPoint("TOPLEFT",sliderdropdownmain,"TOPLEFT",6,-326)
listframe:SetPoint("BOTTOMRIGHT",sliderdropdownmain,"BOTTOMRIGHT",-6,6)
listframe:Hide()
sliderdropdownmain.TextureList=listframe

local editbox=NPA_Options:CreateTextureEditBox("NPA_Options_SliderDropDown_Texture",listframe,220,22,Localization["File"],nil,nil,Tooltips["File"])
editbox:SetPoint("TOPLEFT",listframe,"TOPLEFT",20,-16)
editbox.Texture:ClearAllPoints()
editbox.Texture:SetPoint("LEFT",editbox,"RIGHT",100,0)
editbox.Texture2=editbox:CreateTexture(nil,"BACKGROUND",nil)
editbox.Texture2:SetPoint("LEFT",editbox,"RIGHT",100,0)
editbox.Texture2:SetTexture(0,0,0,1)
editbox:SetScript("OnShow",nil)
editbox.OnValueChanged=NPA_SliderDropEditorOnValueChanged
editbox.Parent=sliderdropdownmain
sliderdropdownmain.Texture=editbox

local button=NPA_Options:CreateBlendModeButton2("NPA_Options_SliderDropDown_TextureBlendMode",listframe,55,22)
button:SetPoint("LEFT",editbox,"RIGHT",15,0)
button.OnValueChanged=NPA_SliderDropEditorOnValueChanged
button.Parent=sliderdropdownmain
sliderdropdownmain.TextureBlend=button


sliderdropdownmain.Height=NPA_Options_CreateSliderDropSlider(1.5,"Height",listframe,Localization["Height"],1,400,1,Tooltips["Height"])
sliderdropdownmain.Width=NPA_Options_CreateSliderDropSlider(2.5,"Width",listframe,Localization["Width"],1,400,1,Tooltips["Width"])
sliderdropdownmain.Left=NPA_Options_CreateSliderDropSlider(3.5,"Left",listframe,Localization["Left"],0,1,0.01,Tooltips["Left"])
sliderdropdownmain.Right=NPA_Options_CreateSliderDropSlider(4.5,"Right",listframe,Localization["Right"],0,1,0.01,Tooltips["Right"])
sliderdropdownmain.Top=NPA_Options_CreateSliderDropSlider(5.5,"Top",listframe,Localization["Top"],0,1,0.01,Tooltips["Top"])
sliderdropdownmain.Bottom=NPA_Options_CreateSliderDropSlider(6.5,"Bottom",listframe,Localization["Bottom"],0,1,0.01,Tooltips["Bottom"])

sliderdropdownmain.RAngle=NPA_Options_CreateSliderDropSlider(7.5,"Rotation",listframe,Localization["Rotation"],0,360,1,Tooltips["Rotation"])

---------------font list frame


local listframe=NPA_Options:CreateFrame("NPA_Options_SliderDrop_Texture",sliderdropdownmain)
listframe:SetPoint("TOPLEFT",sliderdropdownmain,"TOPLEFT",6,-326)
listframe:SetPoint("BOTTOMRIGHT",sliderdropdownmain,"BOTTOMRIGHT",-6,6)
listframe:Hide()
sliderdropdownmain.FontList=listframe


local editbox=NPA_Options:CreateTextureEditBox("NPA_Options_SliderDropDown_Font",listframe,220,22,Localization["File"],nil,2,Tooltips["File"])
editbox:SetPoint("TOPLEFT",listframe,"TOPLEFT",20,-16)
editbox:SetScript("OnShow",nil)
editbox.OnValueChanged=NPA_SliderDropEditorOnValueChanged
editbox.Parent=sliderdropdownmain
sliderdropdownmain.Font=editbox

local button=NPA_Options:CreateFontModeButton2("NPA_Options_SliderDropDown_FontMode",listframe,55,22)
button:SetPoint("LEFT",editbox,"RIGHT",15,0)
button.OnValueChanged=NPA_SliderDropEditorOnValueChanged
button.Parent=sliderdropdownmain
sliderdropdownmain.FontMode=button

sliderdropdownmain.Size=NPA_Options_CreateSliderDropSlider(1.5,"Size",listframe,Localization["Size"],1,40,1,Tooltips["Size"])
sliderdropdownmain.ShadowX=NPA_Options_CreateSliderDropSlider(2.5,"ShadowX",listframe,Localization["ShadowX"],-10,10,1,Tooltips["ShadowX"])
sliderdropdownmain.ShadowY=NPA_Options_CreateSliderDropSlider(3.5,"ShadowY",listframe,Localization["ShadowY"],-10,10,1,Tooltips["ShadowY"])

------------------

sliderdropdownmain:SetScript("OnHide",function(self)
	self.Init=1
end)

local function SetSliderEdit(slider,value)
	slider.Slider:SetValue(tonumber(value))
	slider.EditBox:SetText(tostring(value))
	slider.Value=value
end

local function SetAnchorEdit(anchor,value)
	anchor.Value=value
	anchor.OnValueChanged2(anchor)
end


sliderdropdownmain:SetScript("OnShow",function(self)
	local main=self.Main
	local type=self.Type
	local value=self.Owner.Value
	self.Init=1

	if(type==1 or type==3)then
		self.Texture:SetText(value.Texture)
		self.Texture.Value=value.Texture

		SetSliderEdit(self.Height,value.Height)
		SetSliderEdit(self.Width,value.Width)

		--self.CoordX:SetValue(value.CoordX)
		--self.CoordY:SetValue(value.CoordY)
		SetSliderEdit(self.Left,value.Left)
		SetSliderEdit(self.Right,value.Right)
		SetSliderEdit(self.Top,value.Top)
		SetSliderEdit(self.Bottom,value.Bottom)

		SetSliderEdit(self.RAngle,value.RAngle)

		main:SetHeight(690)
		self:SetHeight(690)

		if(type==3)then
			self.Texture.Button.Type=5
			self.Texture.Texture:SetWidth(32)
		else
			self.Texture.Button.Type=nil
			self.Texture.Texture:SetWidth(256)
		end

		sliderdropdownmain.TextureList:Show()
		sliderdropdownmain.FontList:Hide()


	elseif(type==2)then
		self.Font:SetText(value.Font)
		self.Font.Value=value.Font

		SetSliderEdit(self.ShadowX,value.ShadowX)
		SetSliderEdit(self.ShadowY,value.ShadowY)
	
		SetSliderEdit(self.Size,value.Size)		

		main:SetHeight(530)
		self:SetHeight(530)

		sliderdropdownmain.FontList:Show()
		sliderdropdownmain.TextureList:Hide()

	end

	SetSliderEdit(self.Red,value.Red)
	SetSliderEdit(self.Green,value.Green)
	SetSliderEdit(self.Blue,value.Blue)
	SetSliderEdit(self.Alpha,value.Alpha)
	
	SetSliderEdit(self.OffsetX,value.OffsetX)
	SetSliderEdit(self.OffsetY,value.OffsetY)

	SetAnchorEdit(self.Anchor,value.Anchor)
	SetAnchorEdit(self.ToAnchor,value.ToAnchor)

	self.Init=nil

	NPA_SliderDropEditorOnValueChanged()

	main:SetVerticalScroll(1)
	main:SetHorizontalScroll(1)


end)


local button1=NPA_Options:CreateButton("NPA_Option_SliderDropdown_Close",sliderdropdown,24,24,"X",Tooltips["Close"])
button1:SetFrameStrata("MEDIUM")

button1:SetPoint("TOPLEFT",sliderdropdownmain,"TOPRIGHT",0,0)
button1:SetScript("OnClick",function(self) self:GetParent():Hide() end)


function NPA_Options:InitSliderEdit(owner,name,key,type,reset)
	if(sliderdropdown:IsShown() and sliderdropdownmain.Owner==owner)then
		sliderdropdown:Hide()
		texturedropdown:Hide()
	else
		texturedropdown:Hide()
		sliderdropdown:Hide()
		sliderdropdown.Text:SetText(name)
		--sliderdropdown:SetPoint("LEFT",owner,"RIGHT")

		sliderdropdownmain.Type=type
		sliderdropdownmain.Owner=owner

		sliderdropdownmain:Show()
		sliderdropdown:Show()
	end
end

function NPA_Options:CreateSliderEditButton(name,parent,key,type,Options,offsety,offsetx,tooltip)
	local button=NPA_Options:CreateButton("NPA_Options_SliderDropDown_Button_"..(name or ""),parent,48,24,name.."==>",tooltip)
	button.Key=key
	button.Type=type
	button.Name=name
	button:SetWidth(button:GetFontString():GetWidth() + 20)

	button:SetScript("OnShow",function(self)
			self.Value=CopyTable(NPA_Config[ActiveKey][self.Key])
		end)

	button:SetScript("OnClick",function(self)
			NPA_Options:InitSliderEdit(self,self.Name,self.Key,self.Type)
		end)

	button:SetPoint("TOPLEFT",parent,"TOPLEFT",20+(offsetx or 0)*150,-6-offsety*30)

	table_insert(Options,button)
	return button
end
--------------------------------
----------------------------------
----------editlist

local function NPA_Options_EditList_Add(self)
	local parent=self:GetParent()
	local text=parent.Box:GetNumber()
	local value=parent.Box2:GetNumber()
	if(text and text~="" and value)then
		local key=parent.Key
		NPA_Config[ActiveKey][key][text]=value
		texturedropdown:Hide()
		texturedropdown.Owner=self:GetParent()
		texturedropdown.Type=7
		texturedropdown:SetPoint("LEFT",self:GetParent(),"RIGHT",0,0)
		texturedropdown:Show()
	end
end

local function NPA_Options_EditList_Remove(self)
	local parent=self:GetParent()
	local text=parent.Box:GetNumber()
	if(text and text~="")then
		local key=parent.Key
		NPA_Config[ActiveKey][key][text]=nil
		texturedropdown:Hide()
		texturedropdown.Owner=self:GetParent()
		texturedropdown.Type=7
		texturedropdown:SetPoint("LEFT",self:GetParent(),"RIGHT",0,0)
		texturedropdown:Show()
	end
end

local function NPA_Options_EditList_Seek(self)
	if(texturedropdown:IsShown() and texturedropdown.Owner==self:GetParent())then
		texturedropdown:Hide()
	else
		texturedropdown:Hide()
		texturedropdown.Owner=self:GetParent()
		texturedropdown.Type=7
		texturedropdown:SetPoint("LEFT",self:GetParent(),"RIGHT",0,0)
		texturedropdown:Show()
	end
end


local function NPA_Options_EditList_Clear(self)
	local key=self:GetParent().Key
	NPA_Config[ActiveKey][key]={}
	texturedropdown:Hide()
	texturedropdown:Show()
end


-----------createfunction

function NPA_Options:CreateEditList(name,parent,label,text1,text2,key)
	local EditList=NPA_Options:CreateFrame(name.."frame",parent)
	EditList:SetWidth(190)
	EditList:SetHeight(105)

	local label=NPA_Options:CreateLabel(name.."label",EditList,label)
	label:SetPoint("TOPLEFT",EditList,"TOPLEFT",6,-6)

	local button2=NPA_Options:CreateButton(name.."_Remove",EditList,0,18,Localization["Remove"],Tooltips["Remove"])
	button2:SetPoint("TOPRIGHT",EditList,"TOPRIGHT",-3,-3)

	local button1=NPA_Options:CreateButton(name.."_Apply",EditList,0,18,Localization["Add"],Tooltips["Add"])
	button1:SetPoint("RIGHT",button2,"LEFT")

	local label1=NPA_Options:CreateLabel(name.."label",EditList,text1)
	label1:SetPoint("TOPLEFT",label,"BOTTOMLEFT",0,-6)

	local editbox=NPA_Options:CreateEditBox(name.."editbox",EditList,125,32)
	editbox:SetPoint("LEFT",label1,"RIGHT",5,0)
	editbox:SetPoint("RIGHT",EditList,"RIGHT",-5,0)

	local label3=NPA_Options:CreateLabel(name.."label",EditList,Localization["Name"],Tooltips["Name"])
	label3:SetPoint("TOPLEFT",label1,"BOTTOMLEFT",0,-6)

	local label4=NPA_Options:CreateLabel(name.."label",EditList)
	label4:SetPoint("LEFT",label3,"RIGHT",5,0)
	label4:SetTextColor(0,1,0,1)

	local label2=NPA_Options:CreateLabel(name.."label",EditList,text2)
	label2:SetPoint("TOPLEFT",label3,"BOTTOMLEFT",0,-6)

	local editbox2=NPA_Options:CreateEditBox(name.."editbox2",EditList,125,32)
	editbox2:SetPoint("LEFT",label2,"RIGHT",5,0)
	editbox2:SetPoint("RIGHT",EditList,"RIGHT",-5,0)

	local button3=NPA_Options:CreateButton(name.."open",EditList,18,18,"+",Tooltips["Open"])
	button3:SetPoint("LEFT",label,"RIGHT",5)

	local button4=NPA_Options:CreateButton(name.."ClearAll",EditList,0,18,Localization["ClearAll"],Tooltips["ClearAll"])
	button4:SetPoint("BOTTOMLEFT",EditList,"BOTTOMLEFT",6,6)

	EditList.Box=editbox
	EditList.Box2=editbox2
	EditList.Key=key
	EditList.Label=label4
	EditList.Label3=label3

	button1:SetScript("OnClick",NPA_Options_EditList_Add)
	button2:SetScript("OnClick",NPA_Options_EditList_Remove)
	button3:SetScript("OnClick",NPA_Options_EditList_Seek)
	button4:SetScript("OnClick",NPA_Options_EditList_Clear)


	editbox:HookScript("OnEnterPressed",function(self)
		self:SetText(self:GetNumber())
		self:GetParent().Label:SetText(GetSpellInfo(self:GetNumber()))
		self:ClearFocus()
		end)
	editbox2:HookScript("OnEnterPressed",function(self)
		self:SetText(self:GetNumber())
		self:ClearFocus()
		end)

	return EditList	
end
-------------------------
-------------------------
----------editlist2

local function NPA_Options_EditList2_EditBox_OnEnterPressed(self)
	self.Value=self:GetNumber()
	self.Label:SetText(Localization["Name"]..":   |cff00ff00"..(GetSpellInfo(self:GetNumber()) or ""))
	self:ClearFocus()
end
local function NPA_Options_EditList2_OnUpdate(button)
	button.Parent.Value[button.Key]=button.Value
end

local function NPA_Options_EditList2_Init2(main,self)
	local buttonlist=main.ButtonList2

	local count=1

	if(self)then

	local valuelist={}
	for key,value in pairs(self.Value) do
		table_insert(valuelist,{Key=key,Value=value})
	end
	table_sort(valuelist,function(a,b)
		local namea=GetSpellInfo(a.Key) or ""
		local nameb=GetSpellInfo(b.Key) or ""
		return namea<nameb
		
		end)

	for _,t in pairs(valuelist) do
		local key=t.Key
		local value=t.Value

		local button=buttonlist[count]
		if(not button)then
			button=CreateFrame("Button","NPA_Options_EditList2_Button"..count,main.List2,nil)
			button:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
			button.Text = button:CreateFontString(nil,"ARTWORK","GameFontNormal");
			button.Text:SetPoint("LEFT",button,"LEFT",5,0)
			button:SetPoint("TOPLEFT",main.List2,"TOPLEFT",0,-(count-1)*20-3)
			button:SetPoint("RIGHT",main.List2,"RIGHT",-3,0)
			button:SetHeight(18)
			button:SetScript("OnClick",function(self)
				local parent=self.Parent
				parent.EditBox2:SetText(tonumber(self.Key))
				NPA_Options_EditList2_EditBox_OnEnterPressed(parent.EditBox2)
				parent.EditBox3:SetText(tonumber(self.Value))

				parent.Hl2:SetPoint("CENTER",self,"CENTER",0,0)
				parent.Hl2:Show()

				end)

			button.Parent=main
			buttonlist[count]=button
		end

		button.Text:SetText("|cff00ff00["..(GetSpellInfo(key) or "").."]|cffffff00 ("..key..") |cffffffff= "..value)
		button.Key=key
		button.Value=value
		button:Show()

		count=count+1
	end
	
	end

	for i=count, table_getn(buttonlist) do
		buttonlist[i]:Hide()
	end
	local height=count*20+6
	if(height<200)then
		main.List2:SetHeight(200)
		main.Scroll2.Slider:SetMinMaxValues(0,1)
	else
		main.List2:SetHeight(height)
		main.Scroll2.Slider:SetMinMaxValues(0,height-200)
	end

	main.Scroll2.Slider:SetValue(0)
	main.Scroll2:SetVerticalScroll(1)
	main.Scroll2:SetHorizontalScroll(1)

end

local function NPA_Options_EditList2_Init1(self)
	local buttonlist=self.ButtonList1
		
	local valuelist={}
	for key,list in pairs(self.Value) do
		table_insert(valuelist,{Key=key,List=list})
	end
	table_sort(valuelist,function(a,b)
		local namea=GetSpellInfo(a.Key) or ""
		local nameb=GetSpellInfo(b.Key) or ""
		return namea<nameb
		
		end)


	self.KeyToButton={}
	local count=1
	for _,t in pairs(valuelist) do
		local key=t.Key
		local list=t.List
		local button=buttonlist[count]
		if(not button)then
			button=CreateFrame("Button","NPA_Options_EditList2_Button"..count,self.List1,nil)
			button:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
			button.Text = button:CreateFontString(nil,"ARTWORK","GameFontNormal");
			button.Text:SetPoint("LEFT",button,"LEFT",5,0)
			button:SetPoint("TOPLEFT",self.List1,"TOPLEFT",3,-(count-1)*20-3)
			button:SetPoint("RIGHT",self.List1,"RIGHT",-3,0)
			button:SetHeight(18)
			button.Parent=self
			button:SetScript("OnClick",function(self)
					local parent=self.Parent
					parent.EditBox1:SetText(tonumber(self.Key))
					NPA_Options_EditList2_EditBox_OnEnterPressed(parent.EditBox1)
					NPA_Options_EditList2_Init2(parent,self)

					parent.ActiveKey=self.Key
					parent.Hl1:SetPoint("CENTER",self,"CENTER",0,0)
					parent.Hl1:Show()
					parent.Hl2:Hide()
				end)

			buttonlist[count]=button
		end

		button.Text:SetText("|cff00ff00["..(GetSpellInfo(key) or "").."] |cffffff00("..key..")")
		button.Key=key
		button.Value=list
		
		self.KeyToButton[key]=button
		button:Show()


		count=count+1
	end
	for i=count, table_getn(buttonlist) do
		buttonlist[i]:Hide()
	end
	local height=(count-1)*20+6
	if(height<200)then
		self.List1:SetHeight(200)
		self.Scroll1.Slider:SetMinMaxValues(0,1)
	else
		self.List1:SetHeight(height)
		self.Scroll1.Slider:SetMinMaxValues(0,height-200)
	end

	self.Scroll1.Slider:SetValue(0)
	self.Scroll1:SetVerticalScroll(1)
	self.Scroll1:SetHorizontalScroll(1)

end

function NPA_Options:CreateScrollSlider(main)
	local slider = CreateFrame("Slider","NPA_ScrollFrame_Slider",main,"OptionsSliderTemplate")
	slider:SetPoint("TOPLEFT",main,"TOPRIGHT",-8,0)
	slider:SetPoint("BOTTOMLEFT",main,"BOTTOMRIGHT",-8,0)
	slider:SetMinMaxValues(0,1)
	slider:SetValueStep(1)
	slider:SetValue(0)
	slider:SetOrientation("VERTICAL")
	slider:SetWidth(10)
	slider.Parent=main
	slider:SetScript("OnValueChanged",function(self)
			self.Parent:SetVerticalScroll(self:GetValue())
		end)
	slider:SetScript("OnMouseWheel",function(self,value)
			self:SetValue(self:GetValue() - floor(value) * self:GetValueStep())
		end)
	slider:EnableMouseWheel(1)

	main:EnableMouseWheel(1)
	main.Slider=slider
	main:SetScript("OnMouseWheel",function(self,value)
			local slider=self.Slider
			if(slider:IsShown())then
				slider:SetValue(slider:GetValue() - floor(value) * slider:GetValueStep()*40)
			end
		end)

	main:HookScript("OnShow",function(self)
		self.Slider:SetValue(0)
		self:SetVerticalScroll(1)
		self:SetHorizontalScroll(1)

		end)
end


function NPA_Options:CreateEditList2(name,parent,label,text1,text2,text3,key)
	local main=NPA_Options:CreateFrame(name.."main frame",parent)
	main:SetHeight(280)
	main:SetWidth(510)
	main:Show()

	local scroll1=CreateFrame("ScrollFrame","NPA_ScrollFrame",main)
	scroll1:Show()
	scroll1:SetWidth(250)
	scroll1:SetHeight(200)
	scroll1:SetPoint("BOTTOMLEFT",main,"BOTTOMLEFT",3,3)
	NPA_Options:CreateScrollSlider(scroll1)

	local list1=NPA_Options:CreateFrame(name.."list1",main)
	list1:SetWidth(250)
	list1:SetPoint("TOPLEFT",scroll1,"TOPLEFT",0,0)
	scroll1:SetScrollChild(list1)

	local scroll2=CreateFrame("ScrollFrame","NPA_ScrollFrame",main)
	scroll2:Show()
	scroll2:SetWidth(250)
	scroll2:SetHeight(200)
	scroll2:SetPoint("BOTTOMRIGHT",main,"BOTTOMRIGHT",-3,3)
	NPA_Options:CreateScrollSlider(scroll2)


	local list2=NPA_Options:CreateFrame(name.."list2",main)
	list2:SetWidth(250)
	list2:SetPoint("TOPLEFT",scroll2,"TOPLEFT",0,0)
	scroll2:SetScrollChild(list2)


	local label=NPA_Options:CreateLabel(name.."label",main,label)
	label:SetPoint("BOTTOM",main,"TOP",0,0)

	local button1=NPA_Options:CreateButton(name.."_Add1",main,0,18,Localization["Add"],Tooltips["Add"])
	button1:SetPoint("BOTTOMLEFT",scroll1,"TOPLEFT",5,3)
	button1.Parent=main
	button1:SetScript("OnClick",function(self)
		local parent=self.Parent
		local value=parent.EditBox1:GetNumber()
		if(value)then
			parent.Value[value]={}
			NPA_Options_EditList2_Init1(parent)
			local button=parent.KeyToButton[value]
			NPA_Options_EditList2_Init2(parent,button)
			NPA_Options_EditList2_OnUpdate(button)

			parent.ActiveKey=value
			parent.Hl1:SetPoint("CENTER",button,"CENTER",0,0)
			parent.Hl1:Show()
			parent.Hl2:Hide()

		end

		end)

	local button2=NPA_Options:CreateButton(name.."_Remove1",main,0,18,Localization["Remove"],Tooltips["Remove"])
	button2:SetPoint("LEFT",button1,"RIGHT",3,0)
	button2.Parent=main
	button2:SetScript("OnClick",function(self)
		local parent=self.Parent
		local value=parent.EditBox1:GetNumber()
		if(value)then
			parent.Value[value]=nil
			NPA_Options_EditList2_Init1(parent)
			NPA_Options_EditList2_Init2(parent,nil)

			parent.ActiveKey=nil

			parent.Hl1:Hide()
			parent.Hl2:Hide()
		end
		
		end)

	local button3=NPA_Options:CreateButton(name.."ClearAll1",main,0,18,Localization["ClearAll"],Tooltips["ClearAll"])
	button3:SetPoint("LEFT",button2,"RIGHT",3,0)
	button3.Parent=main
	button3:SetScript("OnClick",function(self)
		local parent=self.Parent
		for key,_ in pairs(parent.Value)do
			parent.Value[key]=nil
		end
		NPA_Options_EditList2_Init1(parent)
		NPA_Options_EditList2_Init2(parent,nil)

		parent.ActiveKey=nil

		parent.Hl1:Hide()
		parent.Hl2:Hide()

		end)


	local button4=NPA_Options:CreateButton(name.."_Add2",main,0,18,Localization["Add"],Tooltips["Add"])
	button4:SetPoint("BOTTOMLEFT",scroll2,"TOPLEFT",5,3)
	button4.Parent=main
	button4:SetScript("OnClick",function(self)
		local parent=self.Parent

		if(not parent.ActiveKey)then
			return
		end

		local value=parent.EditBox2:GetNumber()
		local name=GetSpellInfo((value or 0))
		if(name)then
			local t=parent.EditBox3:GetNumber() or 0
			local button=parent.KeyToButton[parent.ActiveKey]
			button.Value[value]=t
			NPA_Options_EditList2_OnUpdate(button)
			NPA_Options_EditList2_Init2(parent,button)
		end

		end)



	local button5=NPA_Options:CreateButton(name.."_Remove2",main,0,18,Localization["Remove"],Tooltips["Remove"])
	button5:SetPoint("LEFT",button4,"RIGHT",3,0)
	button5.Parent=main
	button5:SetScript("OnClick",function(self)
		local parent=self.Parent
		if(not parent.ActiveKey)then
			return
		end
		local value=parent.EditBox2:GetNumber()
		if(value)then
			local button=parent.KeyToButton[parent.ActiveKey]
			button.Value[value]=nil
			parent.Hl2:Hide()
			NPA_Options_EditList2_OnUpdate(button)
			NPA_Options_EditList2_Init2(parent,button)
		end

		end)

	local button6=NPA_Options:CreateButton(name.."ClearAll2",main,0,18,Localization["ClearAll"],Tooltips["ClearAll"])
	button6:SetPoint("LEFT",button5,"RIGHT",3,0)
	button6.Parent=main
	button6:SetScript("OnClick",function(self)
		local parent=self.Parent
		if(not parent.ActiveKey)then
			return
		end
		local button=parent.KeyToButton[parent.ActiveKey]
		for key,_ in pairs(button.Value) do
			button.Value[key]=nil
		end
		parent.Hl2:Hide()
		NPA_Options_EditList2_OnUpdate(button)
		NPA_Options_EditList2_Init2(parent,nil)

		end)


	local label1=NPA_Options:CreateLabel(name.."label",main,Localization["Name"]..":")
	label1:SetPoint("BOTTOMLEFT",button1,"TOPLEFT",0,3)

	local label2=NPA_Options:CreateLabel(name.."label",main,Localization["Name"]..":")
	label2:SetPoint("BOTTOMLEFT",button4,"TOPLEFT",0,3)


	local label3=NPA_Options:CreateLabel(name.."label",main,text1)
	label3:SetPoint("BOTTOMLEFT",label1,"TOPLEFT",0,3)

	local label5=NPA_Options:CreateLabel(name.."label",main,text3)
	label5:SetPoint("BOTTOMLEFT",label2,"TOPLEFT",0,3)

	local label4=NPA_Options:CreateLabel(name.."label",main,text2)
	label4:SetPoint("BOTTOMLEFT",label5,"TOPLEFT",0,6)


	local editbox1=NPA_Options:CreateEditBox(name.."editbox1",main,125,32)
	editbox1:SetPoint("LEFT",label3,"RIGHT",5,0)
	editbox1:SetPoint("RIGHT",scroll1,"RIGHT",-5,0)
	editbox1.Label=label1

	local editbox2=NPA_Options:CreateEditBox(name.."editbox2",main,125,32)
	editbox2:SetPoint("LEFT",label4,"RIGHT",5,0)
	editbox2:SetPoint("RIGHT",scroll2,"RIGHT",-5,0)
	editbox2.Label=label2

	local editbox3=NPA_Options:CreateEditBox(name.."editbox3",main,125,32)
	editbox3:SetPoint("LEFT",label5,"RIGHT",5,0)
	editbox3:SetPoint("RIGHT",scroll2,"RIGHT",-5,0)
	editbox3:SetScript("OnEnterPressed",function(self) self:ClearFocus() end)
	editbox3:SetText(0)

	editbox1:SetScript("OnEnterPressed",NPA_Options_EditList2_EditBox_OnEnterPressed)
	editbox2:SetScript("OnEnterPressed",NPA_Options_EditList2_EditBox_OnEnterPressed)


	local highlight1=list1:CreateTexture()
	highlight1:SetHeight(15)
	highlight1:SetWidth(235)
	highlight1:SetTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	highlight1:Hide()

	local highlight2=list2:CreateTexture()
	highlight2:SetHeight(15)
	highlight2:SetWidth(235)
	highlight2:SetTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	highlight2:Hide()

	main.Key=key
	main.ButtonList1={}
	main.ButtonList2={}
	main.List1=list1
	main.List2=list2
	main.EditBox1=editbox1
	main.EditBox2=editbox2
	main.EditBox3=editbox3
	main.Scroll1=scroll1
	main.Scroll2=scroll2
	main.Hl1=highlight1
	main.Hl2=highlight2

	main:SetScript("OnShow",function(self)
		self.Value=NPA_Config[ActiveKey][key]
		NPA_Options_EditList2_Init1(self)
		NPA_Options_EditList2_Init2(self,nil)
		self.Hl1:Hide()
		self.Hl2:Hide()
		
		end)


	return main
end
--------------------------------
----------------------------------
----------editlist3

local function NPA_Options_EditList3_Add(self)
	local parent=self:GetParent()
	local text=parent.Box:GetText()
	local value=parent.Box2:GetNumber()
	if(text and text~="" and value)then
		local key=parent.Key
		NPA_Config[ActiveKey][key][text]=value
		texturedropdown:Hide()
		texturedropdown.Owner=self:GetParent()
		texturedropdown.Type=8
		texturedropdown:SetPoint("TOPLEFT",self:GetParent():GetParent(),"BOTTOMLEFT",0,-6)
		texturedropdown:Show()
	end
end

local function NPA_Options_EditList3_Remove(self)
	local parent=self:GetParent()
	local text=parent.Box:GetText()
	if(text and text~="")then
		local key=parent.Key
		NPA_Config[ActiveKey][key][text]=nil
		texturedropdown:Hide()
		texturedropdown.Owner=self:GetParent()
		texturedropdown.Type=8
		texturedropdown:SetPoint("TOPLEFT",self:GetParent():GetParent(),"BOTTOMLEFT",0,-6)
		texturedropdown:Show()
	end
end

local function NPA_Options_EditList3_Seek(self)
	if(texturedropdown:IsShown() and texturedropdown.Owner==self:GetParent())then
		texturedropdown:Hide()
	else
		texturedropdown:Hide()
		texturedropdown.Owner=self:GetParent()
		texturedropdown.Type=8
		texturedropdown:SetPoint("TOPLEFT",self:GetParent():GetParent(),"BOTTOMLEFT",0,-6)
		texturedropdown:Show()
	end
end


local function NPA_Options_EditList3_Clear(self)
	local key=self:GetParent().Key
	NPA_Config[ActiveKey][key]={}
	texturedropdown:Hide()
	texturedropdown:Show()
end


-----------createfunction

function NPA_Options:CreateEditList3(name,parent,label,text1,key)
	local EditList=NPA_Options:CreateFrame(name.."frame",parent)
	EditList:SetWidth(200)
	EditList:SetHeight(84)

	local label=NPA_Options:CreateLabel(name.."label",EditList,label)
	label:SetPoint("TOPLEFT",EditList,"TOPLEFT",6,-6)

	local button2=NPA_Options:CreateButton(name.."_Remove",EditList,0,18,Localization["Remove"],Tooltips["Remove"])
	button2:SetPoint("TOPRIGHT",EditList,"TOPRIGHT",-3,-3)

	local button1=NPA_Options:CreateButton(name.."_Apply",EditList,0,18,Localization["Add"],Tooltips["Add"])
	button1:SetPoint("RIGHT",button2,"LEFT")

	local label1=NPA_Options:CreateLabel(name.."label",EditList,Localization["Name"],Tooltips["Name"])
	label1:SetPoint("TOPLEFT",label,"BOTTOMLEFT",0,-6)

	local editbox=NPA_Options:CreateEditBox(name.."editbox",EditList,125,32)
	editbox:SetPoint("LEFT",label1,"RIGHT",5,0)
	editbox:SetPoint("RIGHT",EditList,"RIGHT",-5,0)

	local label2=NPA_Options:CreateLabel(name.."label",EditList,text1)
	label2:SetPoint("TOPLEFT",label1,"BOTTOMLEFT",0,-6)

	local editbox2=NPA_Options:CreateEditBox(name.."editbox2",EditList,125,32)
	editbox2:SetPoint("LEFT",label2,"RIGHT",5,0)
	editbox2:SetPoint("RIGHT",EditList,"RIGHT",-5,0)

	local button3=NPA_Options:CreateButton(name.."open",EditList,18,18,"+",Tooltips["Open"])
	button3:SetPoint("LEFT",label,"RIGHT",5)

	local button4=NPA_Options:CreateButton(name.."ClearAll",EditList,0,18,Localization["ClearAll"],Tooltips["ClearAll"])
	button4:SetPoint("BOTTOMLEFT",EditList,"BOTTOMLEFT",6,6)

	EditList.Box=editbox
	EditList.Box2=editbox2
	EditList.Key=key
	EditList.Label=label1
	EditList.Label2=label2

	button1:SetScript("OnClick",NPA_Options_EditList3_Add)
	button2:SetScript("OnClick",NPA_Options_EditList3_Remove)
	button3:SetScript("OnClick",NPA_Options_EditList3_Seek)
	button4:SetScript("OnClick",NPA_Options_EditList3_Clear)


	editbox:HookScript("OnEnterPressed",function(self)
		self:ClearFocus()
		end)
	editbox2:HookScript("OnEnterPressed",function(self)
		self:SetText(self:GetNumber())
		self:ClearFocus()
		end)

	return EditList	
end
--------------------------
--------------------------
-----checkbox list

function NPA_Options:BuildCheckBoxList(listname,listframe,height,checkboxdata,step,Options,autoheight,autowidth,tooltipslist)
	local count=0
	local width=0
	local buttonlist={}
	for key,name in pairs(checkboxdata)do
		table_insert(buttonlist,{Name=name,Key=key})
	end
	table_sort(buttonlist,function(a,b) return a.Name<b.Name end)
	for i=1,table_getn(buttonlist)do
		local key=buttonlist[i].Key
		local name=buttonlist[i].Name
		local tooltip
		if(tooltipslist)then
			tooltip=tooltipslist[key]
		end

		local checkbox=NPA_Options:CreateCheckBox(listname..name,listframe,height,name,key,tooltip)
		checkbox:SetPoint("TOPLEFT",listframe,"TOPLEFT",6,-6-count*step)
		table_insert(Options,checkbox)
		count=count+1
		
		local swap=checkbox:GetWidth()+checkbox.Label:GetWidth()+12
		if(swap>width)then
			width=swap
		end
	end
	if(autoheight)then
		listframe:SetHeight(count*step+12)
	end
	if(autowidth)then
		listframe:SetWidth(width)
	end
end


function NPA_Options:BuildCheckBoxList2(listname,listframe,height,checkboxdata,step,mainkey,autoheight,autowidth,tooltipslist)
	listframe:Hide()
	local count=0
	local width=0
	local buttonlist={}
	for key,name in pairs(checkboxdata)do
		table_insert(buttonlist,{Name=name,Key=key})
	end
	table_sort(buttonlist,function(a,b) return a.Name<b.Name end)
	listframe.Key=mainkey
	listframe.ButtonList={}
	listframe:SetScript("OnShow",function(self)
		self.Value=NPA_Config[ActiveKey][self.Key]
		for _,button in pairs(self.ButtonList)do
			button.Value=self.Value[button.Key]
			if(button.Value==1)then
				button:SetChecked(1)
			else
				button:SetChecked(nil)
			end
		end

		end)
	for i=1,table_getn(buttonlist)do
		local key=buttonlist[i].Key
		local name=buttonlist[i].Name
		local tooltip
		if(tooltipslist)then
			tooltip=tooltipslist[key]
		end

		local checkbox=NPA_Options:CreateCheckBox(listname..name,listframe,height,name,key,tooltip)
		checkbox.Parent=listframe
		checkbox:SetScript("OnShow",nil)
		checkbox:HookScript("OnClick",function(self)
			self.Parent.Value[self.Key]=self.Value
			end)
		checkbox:SetPoint("TOPLEFT",listframe,"TOPLEFT",6,-6-count*step)
		table_insert(listframe.ButtonList,checkbox)
		count=count+1
		
		local swap=checkbox:GetWidth()+checkbox.Label:GetWidth()+6
		if(swap>width)then
			width=swap
		end
	end
	if(autoheight)then
		listframe:SetHeight(count*step+12)
	end
	if(autowidth)then
		listframe:SetWidth(width)
	end
	listframe:Show()
end

function NPA_Options:BuildSliderList(listname,mainframe,sliderdata,Options,tooltipslist)
	for key,data in pairs(sliderdata) do
		local tooltip
		if(tooltipslist)then
			tooltip=tooltipslist[key]
		end
		local slideredit=NPA_Options:CreateSliderEdit(listname..(data.Name or ""),mainframe,data.Name,key,data.Min,data.Max,data.Step,data.Width,nil,tooltip)
		slideredit:SetPoint("TOPLEFT",mainframe,"TOPLEFT",data.OffsetX,data.OffsetY)
		table_insert(Options,slideredit)
	end
end


--------------------------------------------------------
local function NPA_Options_OrderEditOnUpdate(self)
	local orderlist=self.OrderList
	local ignorelist=self.IgnoreList
	local buttonlist=self.ButtonList

	for i=1,table_getn(orderlist) do 
		local button=buttonlist[orderlist[i]]
		button:ClearAllPoints()
		button:SetPoint("TOPLEFT",self.OrderListFrame,"TOPLEFT",3,-3-(i-1)*30)
		button.Index=i
		button.Type=1
		button.ButtonUp:Show()
		button.ButtonDown:Show()
		button.Label:SetText(i)
		button.Label:Show()
		self.Value[orderlist[i]]=i
	end
	for i=1,table_getn(ignorelist) do
		local button=buttonlist[ignorelist[i]]
		button:ClearAllPoints()
		button:SetPoint("TOPRIGHT",self.IgnoreListFrame,"TOPRIGHT",-3,-3-(i-1)*30)
		button.Index=i
		button.Type=0
		button.ButtonUp:Hide()
		button.ButtonDown:Hide()
		button.Label:Hide()
		self.Value[ignorelist[i]]=0
	end
end
local function NPA_Options_OrderEditButtonOnClickUp(frame)
	local self=frame:GetParent()
	if(self.Index==1)then
		return
	end

	local parent=self:GetParent()
	local list=parent.OrderList
	local index=self.Index

	local button=parent.ButtonList[list[index-1]]
	button.Index=index

	local swap=list[index-1]
	list[index-1]=list[index]
	list[index]=swap

	self.Index=self.Index-1
		
	NPA_Options_OrderEditOnUpdate(parent)
end
local function NPA_Options_OrderEditButtonOnClickDown(frame)
	local self=frame:GetParent()
	local parent=self:GetParent()
	local list=parent.OrderList
	if(self.Index==table_getn(list))then
		return
	end

	local index=self.Index
	local button=parent.ButtonList[list[index+1]]
	button.Index=index
	
	local swap=list[index+1]
	list[index+1]=list[index]
	list[index]=swap

	self.Index=self.Index+1

	NPA_Options_OrderEditOnUpdate(parent)
end
local function NPA_Options_OrderEditButtonOnClickChange(self)
	local parent=self:GetParent()
	local listfrom,listto
	if(self.Type==0)then
		listfrom=parent.IgnoreList
		listto=parent.OrderList
		self.Type=1
	else
		listfrom=parent.OrderList
		listto=parent.IgnoreList
		self.Type=0
	end
	
	local index=self.Index
	local indexto=table_getn(listto)+1
	listto[indexto]=listfrom[index]
	self.Index=indexto

	local maxfrom=table_getn(listfrom)
	for i=index,maxfrom-1 do
		listfrom[i]=listfrom[i+1]
	end
	listfrom[maxfrom]=nil

	NPA_Options_OrderEditOnUpdate(parent)
end

local function NPA_Options_CreateOrderEditButton(name,mainframe,text,key)
	local frame=NPA_Options:CreateButton(name.." ButtonFrame",mainframe,140,30,text)
	frame:SetScript("OnClick",NPA_Options_OrderEditButtonOnClickChange)
	
	frame.Label=NPA_Options:CreateLabel(name.." Label",frame,"")
	frame.Label:SetPoint("LEFT",5,0)

	local buttonup=NPA_Options:CreateButton(name.." ButtonUp",frame,40,20,Localization["MoveUp"])
	buttonup:SetPoint("TOPLEFT",frame,"TOPRIGHT",0,0)
	buttonup:SetPoint("BOTTOMLEFT",frame,"RIGHT",0,0)
	buttonup:SetScript("OnClick",NPA_Options_OrderEditButtonOnClickUp)
	frame.ButtonUp=buttonup

	local buttondown=NPA_Options:CreateButton(name.." ButtonDown",frame,40,20,Localization["MoveDown"])
	buttondown:SetPoint("BOTTOMLEFT",frame,"BOTTOMRIGHT",0,0)
	buttondown:SetPoint("TOPLEFT",frame,"RIGHT",0,0)
	buttondown:SetScript("OnClick",NPA_Options_OrderEditButtonOnClickDown)
	frame.ButtonDown=buttondown

	return frame
end

function NPA_Options:CreateOrderEdit(name,mainframe,text,key,localization)
	local frame=NPA_Options:CreateFrame(name.." Mainframe",mainframe,text)
	frame:SetWidth(350)
	frame:SetHeight(230)
	frame.Key=key
	frame:Hide()
	frame.Localization=localization

	local orderlistframe=NPA_Options:CreateFrame(name.." Order List",frame,Localization["InUse"])
	orderlistframe:SetPoint("TOPLEFT",3,-20)
	orderlistframe:SetPoint("BOTTOMLEFT",3,3)
	orderlistframe:SetWidth(190)
	frame.OrderListFrame=orderlistframe

	local ignorelistframe=NPA_Options:CreateFrame(name.." Ignore List",frame,Localization["NotUse"])
	ignorelistframe:SetPoint("TOPRIGHT",-3,-20)
	ignorelistframe:SetPoint("BOTTOMRIGHT",-3,3)
	ignorelistframe:SetWidth(145)
	frame.IgnoreListFrame=ignorelistframe

	frame.ButtonList={}

	frame:SetScript("OnShow",function(self)
			self.Value=CopyTable(NPA_Config[ActiveKey][self.Key])

			local orderlist={}
			local oi=1
			local ignorelist={}
			local ii=1
			local swaporderlist={}
			local maxorderlist=0
			local buttonlist=frame.ButtonList
			local localization=self.Localization
			table_sort(self.Value,function(a,b) return a>b end)
			for key,value in pairs(self.Value) do
				if(key~="DeepCheck")then
					if(value==0)then
						ignorelist[ii]=key
						ii=ii+1
					else
						swaporderlist[value]=key
						if(value>maxorderlist)then
							maxorderlist=value
						end
					end
					if(not buttonlist[key])then
						buttonlist[key]=NPA_Options_CreateOrderEditButton(name.." button",self,localization[key],key)
					end
				end
			end
			for i=1,maxorderlist do
				if(swaporderlist[i])then
					orderlist[oi]=swaporderlist[i]
					oi=oi+1
				end
			end

			self.OrderList=orderlist
			self.IgnoreList=ignorelist
			
			NPA_Options_OrderEditOnUpdate(self)
		end)

	frame:Show()

	return frame
end
-----------------------------------------------------------

--------------tips control
local function NPA_Options_RandomTip()
	CurrentTip=floor(random()*table_getn(SmallTips))
	SetTooltip(SmallTips[CurrentTip])

end

local nextbutton=NPA_Options:CreateButton("NPA_Options_Tips_NextButton",mainframe,0,21,Localization["NextTip"],Tooltips["NextTip"])
nextbutton:SetScript("OnClick",function()
	CurrentTip=CurrentTip+1
	if(CurrentTip>table_getn(SmallTips))then
		CurrentTip=1
	end
	SetTooltip(SmallTips[CurrentTip])
end)
nextbutton:SetPoint("BOTTOMLEFT",tooltipsbox,"BOTTOMRIGHT",6,0)
nextbutton:Show()

------------------------
--mainframe--


mainframe:SetWidth(690)
mainframe:SetHeight(584)
mainframe:SetMovable(1)
mainframe:EnableMouse(1)
mainframe:SetToplevel(1)
mainframe:SetClampedToScreen(1)
mainframe:SetPoint("CENTER")
mainframe.Scale=0.8
mainframe:SetScale(0.8)
mainframe:SetScript("OnMouseDown",function() mainframe:StartMoving() end);
mainframe:SetScript("OnMouseUp",function() mainframe:StopMovingOrSizing();end)
mainframe:SetScript("OnHide",function()
		texturedropdown:Hide()
		sliderdropdown:Hide()
		end)
mainframe:SetScript("OnShow",function()
		mainframe:SetScale(mainframe.Scale)
		sliderdropdown:ClearAllPoints()
		sliderdropdown:SetPoint("BOTTOMRIGHT",NPA_Options.MainFrame,"BOTTOMRIGHT",704,0)


		NPA_Options_RandomTip()
		
		end)

local mainframeslider = CreateFrame("Slider","NPA_MainFrame_Slider",mainframe,"OptionsSliderTemplate")
mainframeslider:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",0,0)
mainframeslider:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMLEFT",0,0)
mainframeslider:SetMinMaxValues(0.4,1.2)
mainframeslider:SetValueStep(0.01)
mainframeslider:SetOrientation("VERTICAL")
mainframeslider:SetWidth(10)
mainframeslider.Parent=mainframe
mainframeslider:SetScript("OnValueChanged",function(self)
		local value=self:GetValue()
		local scale=mainframe.Scale
		if(value-scale>0.2)then
			value=scale+0.2
		elseif(scale-value>0.2)then
			value=scale-0.2
		end

		self:SetValue(value)
		
		mainframe:SetScale(value)
		mainframe.Scale=value
	end)
mainframeslider:SetScript("OnMouseWheel",function(self,value)
		self:SetValue(self:GetValue() - floor(value) * self:GetValueStep())
	end)
mainframeslider:EnableMouseWheel(1)

mainframeslider:SetValue(0.8)


local outline=NPA_Options:CreateFrame("NPA_Options_OutLine",mainframe,nil)
outline:SetPoint("TOPLEFT",6,-6);
outline:SetPoint("BOTTOMLEFT",6,6);
outline:SetWidth(84);

local buttonclose=NPA_Options:CreateButton("NPA_Options_ButtonClose",mainframe,24,24,"X",Tooltips["Close"])
buttonclose:SetPoint("BOTTOMRIGHT",mainframe,"TOPRIGHT")
buttonclose:SetScript("OnClick",function() mainframe:Hide() end)

local buttonresetall=NPA_Options:CreateButton("NPA_Options_ButtonResetAll",mainframe,0,24,Localization["ResetAll"],Tooltips["ResetAll"])
buttonresetall:SetPoint("TOPLEFT",mainframe,"BOTTOMLEFT")
buttonresetall:SetScript("OnClick",function() NPA_Config=nil ReloadUI() end)

local buttonreloadui=NPA_Options:CreateButton("NPA_Options_ButtonReloadUI",mainframe,0,24,Localization["ReloadUI"],Tooltips["ReloadUI"])
buttonreloadui:SetPoint("LEFT",buttonresetall,"RIGHT",10,0)
buttonreloadui:SetScript("OnClick",function() ReloadUI() end)

NPA_Options.MainFrame=mainframe
mainframe:Show()


---spell lookup frames

local strfind=strfind

local function NPA_Options_SpellidToName_Edit_OnEnterPressed(self)
	local name,_,icon=GetSpellInfo(self:GetNumber())
	local parent=self:GetParent()
	parent.Label:SetText(name)
	parent.Icon:SetTexture(icon)
	self:ClearFocus()
end

local idtoname=NPA_Options:CreateFrame("NPA_Options_SpellidToName",mainframe,Localization["SpellidToName"],Tooltips["SpellidToName"])

idtoname:SetPoint("TOPRIGHT",mainframe,"BOTTOMRIGHT",0,-50)
idtoname:Hide()
idtoname:SetHeight(60)
idtoname:SetWidth(250)

local label1=NPA_Options:CreateLabel("NPA_Options_SpellidToName_label1",idtoname,Localization["Id"],Tooltips["Id"])
label1:SetPoint("TOPLEFT",idtoname,"TOPLEFT",6,-16)

local label2=NPA_Options:CreateLabel("NPA_Options_SpellidToName_label2",idtoname,Localization["Name"],Tooltips["Name"])
label2:SetPoint("TOPLEFT",idtoname,"TOPLEFT",6,-37)

local label3=NPA_Options:CreateLabel("NPA_Options_SpellidToName_label2",idtoname,nil)
label3:SetText(nil)
label3:SetTextColor(1,1,1,1)
label3:SetPoint("LEFT",label2,"RIGHT")

local editbox=NPA_Options:CreateEditBox("NPA_Options_SpellidToName",idtoname,100,18)
editbox:SetPoint("LEFT",label1,"RIGHT",10,0)


editbox:SetAutoFocus(nil)
editbox:SetMaxLetters(255)
editbox:SetFontObject("GameFontHighlight")

editbox.Label=label3
editbox:SetScript("OnEnterPressed",NPA_Options_SpellidToName_Edit_OnEnterPressed)

local icon=idtoname:CreateTexture("NPA_Options_SpellidToName_Icon","ARTWORK")
icon:SetPoint("TOPRIGHT",-6,-6)
icon:SetPoint("BOTTOMRIGHT",-6,6)
icon:SetWidth(48)

idtoname.Label=label3
idtoname.EditBox=editbox
idtoname.Icon=icon
NPA_Options.IdToName=idtoname



idtoname:SetScript("OnEnter",function(self)
	local id=self.EditBox:GetNumber()
	if(id and GetSpellInfo(id))then
		GameTooltip:SetOwner(self,"ANCHOR_RIGHT")
		GameTooltip:AddSpellByID(id)
		GameTooltip:ClearAllPoints()
		GameTooltip:Show()
	end
end)

idtoname:SetScript("OnLeave",function()
	GameTooltip:Hide()
end)


local idtonamebutton=NPA_Options:CreateButton("IDToNameButton",NPA_Options.MainFrame,16,16,"+",Tooltips["Open"])
idtonamebutton:SetPoint("TOPRIGHT",NPA_Options.MainFrame,"BOTTOMRIGHT",0,0)
idtonamebutton:SetScript("OnClick",function()
	if(idtoname:IsShown())then
		idtoname:Hide()
	else
		idtoname:Show()
	end
end)


---------------------------------spell name to id----------------------------

local NPA_Options_SpellNameToId_Max=200
local NPA_Options_SpellNameToId_Row=10
local NPA_Options_SpellNameToId_Buttons={}

local nametoid=NPA_Options:CreateFrame("NPA_Options_SpellidToName",mainframe,Localization["SpellNameToId"],Tooltips["SpellNameToId"])

nametoid:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
nametoid:Hide()
nametoid:SetHeight(540)
nametoid:SetWidth(252)

local function NPA_Options_SpellNameToId_Button_OnEnter(self)
	if(self.Spellid and GetSpellInfo(self.Spellid))then
		GameTooltip:SetOwner(self,"ANCHOR_RIGHT")
		GameTooltip:AddSpellByID(self.Spellid)
		GameTooltip:AddLine(Localization["Id"]..": |cff00ff00"..self.Spellid)
		GameTooltip:Show()
	end
end

for i=1,NPA_Options_SpellNameToId_Max do
	local button=CreateFrame("Frame","NPA_Options_SpellNameToId_Button",nametoid)
	button:SetHeight(24)
	button:SetWidth(24)
	button.Icon=button:CreateTexture("NPA_Options_SpellNameToId_Icon","ARTWORK")
	button.Icon:SetPoint("CENTER",button,"CENTER")
	button.Icon:SetWidth(24)
	button.Icon:SetHeight(24)

	local offset=(i-1)
	local offsetx=offset % NPA_Options_SpellNameToId_Row * 24 +6
	local offsety=-(floor(offset/NPA_Options_SpellNameToId_Row) * 24 +54)

	button:SetPoint("TOPLEFT",nametoid,"TOPLEFT",offsetx,offsety)
	button:SetScript("OnEnter",NPA_Options_SpellNameToId_Button_OnEnter)
	button:SetScript("OnLeave",function()
			GameTooltip:Hide()	end)

	button:SetScript("OnMouseDown",function(self)
			if(self.Spellid and GetSpellInfo(self.Spellid))then
				nametoid.Label:SetText(self.Spellid)
				nametoid.EditBox:SetText(GetSpellInfo(self.Spellid))
			end
		end)
	button:EnableMouse(1)

	button.Spellid=nil
	button:Show()

	NPA_Options_SpellNameToId_Buttons[i]=button
	
end

local function NPA_Options_SpellNameToId_SetButton(index,id)
	local name,_,texture=GetSpellInfo(id)
	if(name)then
		local button=NPA_Options_SpellNameToId_Buttons[index]
		button.Spellid=id
		button.Icon:SetTexture(texture)
	else
		local button=NPA_Options_SpellNameToId_Buttons[index]
		button.Spellid=nil
		button.Icon:SetTexture(nil)
	end
end

local function NPA_Options_SpellNameToId_Edit_OnEnterPressed(self)
	self:ClearFocus()

	local name=self:GetText()
	local i=1
	for j=1,100000 do
		local spellname=GetSpellInfo(j)
		if(spellname and strfind(spellname,name) and i<NPA_Options_SpellNameToId_Max)then
			NPA_Options_SpellNameToId_SetButton(i,j)
			i=i+1
		end
	end
	for j=i,NPA_Options_SpellNameToId_Max do
		NPA_Options_SpellNameToId_SetButton(j,0)
	end
end




local label1=NPA_Options:CreateLabel("NPA_Options_SpellNameToId_label1",nametoid,Localization["Name"],Tooltips["Name"])
label1:SetPoint("TOPLEFT",nametoid,"TOPLEFT",6,-16)

local editbox=NPA_Options:CreateEditBox("NPA_Options_SpellNameToId",nametoid,200,18)
editbox:SetScript("OnEnterPressed",NPA_Options_SpellNameToId_Edit_OnEnterPressed)
editbox:SetPoint("LEFT",label1,"RIGHT",10,0)

local label2=NPA_Options:CreateLabel("NPA_Options_SpellNameToId_label2",nametoid,Localization["Id"],Tooltips["Id"])
label2:SetPoint("TOPLEFT",label1,"BOTTOMLEFT",0,-5)

local label3=NPA_Options:CreateLabel("NPA_Options_SpellNameToId_label3",nametoid)
label3:SetPoint("LEFT",label2,"RIGHT",20,0)
label3:SetTextColor(0,1,0,1)


editbox:SetAutoFocus(nil)
editbox:SetMaxLetters(255)
editbox:SetFontObject("GameFontHighlight")

nametoid.EditBox=editbox
nametoid.Label=label3

NPA_Options.NameToId=nametoid



local nametoidbutton=NPA_Options:CreateButton("NameToIdButton",NPA_Options.MainFrame,16,16,"+",Tooltips["Open"])
nametoidbutton:SetPoint("TOPLEFT",NPA_Options.MainFrame,"TOPRIGHT",0,0)
nametoidbutton:SetFrameStrata("HIGH")
nametoidbutton:SetScript("OnClick",function()
	if(nametoid:IsShown())then
		nametoid:Hide()
	else
		nametoid:Show()
	end
end)
----------------------------------------------------------------------------

---pages function

local function NPA_Options_ButtonOnClick(self)
	texturedropdown:Hide()
	sliderdropdown:Hide()
	for key,frame in pairs(Pages) do
		if(key==self.Key)then
			ActiveKey=key
			frame:Show()
		else
			frame:Hide()
		end
	end
end

function NPA_Options:AddPage(name,text,key,tooltip)
	frame=NPA_Options:CreateFrame(name,NPA_Options.MainFrame,text,Options)
	frame:SetPoint("TOPRIGHT",-6,-14);
	frame:SetPoint("BOTTOMRIGHT",-6,6);
	frame:SetWidth(590);
	frame:Hide()
	frame:SetScript("OnHide",function()
		texturedropdown:Hide()
		sliderdropdown:Hide()
		end)

	local button=NPA_Options:CreateButton("NPA_Options_Button"..PageCount,NPA_Options.MainFrame,80,24,text)
	button:SetPoint("TOP",outline,"TOP",0,-22*PageCount)
	button:SetScript("OnClick",NPA_Options_ButtonOnClick)
	button.Key=key

	SetTooltipScript(button,tooltip)
	SetTooltipScript(frame,tooltip)

	PageCount=PageCount+1
	Pages[key]=frame
	
	local function NPA_Options_ClassInfo_Cancel()
		mainframe:Hide()
		mainframe:Show()
	end

	frame.Options={}


	return frame
end

local button1=NPA_Options:CreateButton("NPA_Option_Apply",mainframe,80,24,Localization["Apply"],Tooltips["Apply"])
button1:SetPoint("TOP",mainframe,"BOTTOM",80,0)
button1.Parent=frame
button1:SetScript("OnClick",function()
	for _,value in pairs(Pages[ActiveKey].Options) do
		if(type(value.Value)=="table")then
			NPA_Config[ActiveKey][value.Key]=CopyTable(value.Value)
		else
			NPA_Config[ActiveKey][value.Key]=value.Value
		end
	end
	NPA_Core:ApplyModuleConfig(ActiveKey)
end)

local button2=NPA_Options:CreateButton("NPA_Option_Reset",mainframe,80,24,Localization["Reset"],Tooltips["Reset"])
button2:SetPoint("LEFT",button1,"RIGHT",6,0)
button2.Parent=frame
button2:SetScript("OnClick",function()
	NPA_Core:ResetModuleConfig(ActiveKey)
	NPA_Core:ApplyModuleConfig(ActiveKey)
	Pages[ActiveKey]:Hide()
	Pages[ActiveKey]:Show()
end)

local button3=NPA_Options:CreateButton("NPA_Option_Cancel",mainframe,80,24,Localization["Cancel"],Tooltips["Cancel"])
button3:SetPoint("LEFT",button2,"RIGHT",6,0)
button3.Parent=frame
button3:SetScript("OnClick",function()
	Pages[ActiveKey]:Hide()
	Pages[ActiveKey]:Show()

end)
