﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("exCombat"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="脫離戰鬥",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Bar"]="條",
		["Background"]="條背景",
		["Overlay"]="條前景",
		["Text"]="文本",
		["ColorBar"]="條按時間點著色",
		["ShowText"]="顯示文本",
		["ShowBar"]="顯示條"
	}
	Tooltips={
		["exCombat"]="顯示單位脫離戰鬥倒計時圖標,計時器和計時條",
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="脱离战斗",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Bar"]="条",
		["Background"]="条背景",
		["Overlay"]="条前景",
		["Text"]="文本",
		["ColorBar"]="条按时间着色",
		["ShowText"]="显示文本",
		["ShowBar"]="显示条"
	}
	Tooltips={
		["exCombat"]="显示单位脱离战斗倒计时图标,计时器和计时条",
	}
else
	Localization={
		["PageName"]="exCombat",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["Bar"]="Bar",
		["Background"]="Bar background",
		["Overlay"]="Bar overlay",
		["Text"]="Text",
		["ColorBar"]="Color bar by time",
		["ShowText"]="Show text",
		["ShowBar"]="Show bar"
	}
	Tooltips={
		["exCombat"]="Shows out of combat icon, timer and timer bar",
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_exCombat",Localization["PageName"],"exCombat",Tooltips["exCombat"])

local Options=mainframe.Options


----------------
local sliderlist={
	["exCombat_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["exCombat_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	}
}

NPA_Options:BuildSliderList("NPA_Options_exCombat",mainframe,sliderlist,Options)


NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"exCombat_BarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"exCombat_BarOverlayData",1,Options,4)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"exCombat_BarBackgroundData",1,Options,5)

NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"exCombat_TextData",2,Options,6.5)



-------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_exCombat_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(200)

local checkboxdata={
	["exCombat_Color"]=Localization["ColorBar"],
	["exCombat_ShowText"]=Localization["ShowText"],
	["exCombat_ShowBar"]=Localization["ShowBar"]

}

NPA_Options:BuildCheckBoxList("NPA_Options_exCombat",listframe,21,checkboxdata,18,Options,1)
end