﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("Threat"))then

local Localization={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs
local Tooltips={}
if(locale=="zhTW")then
	Localization={
		["PageName"]="仇恨",
		["ShowHostileGainThreat"]="顯示高敵對仇恨",
		["ShowHostileLostThreat"]="顯示低敵對仇恨",
		["ShowNonHostileGainThreat"]="顯示非敵對高仇恨",
		["ShowNonHostileLostThreat"]="顯示非敵對低仇恨",
		["ShowHostileTanking"]="顯示正在坦的敵對目標",
		["ShowNonHostileTanking"]="顯示正在坦的友方目標",

		["ShowText"]="顯示文本",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
	
		["Bar"]="條",
		["Overlay"]="前景",
		["Background"]="背景",
		["Text"]="文本",

		["ShowBar"]="顯示條",
		["ColorBar"]="條著色",
		
		["Glow"]="高仇恨發光",
		["Glow2"]="低仇恨發光",
		["Glow3"]="坦克發光",
		["Glow4"]="目標是我的敵對發光",
		["Glow5"]="目標是我的非敵對發光",
		["ShowHostileTargetingMe"]="顯示目標是我的敵對",
		["ShowNonHostileTargetingMe"]="顯示目標是我的非敵對",
	Tooltips={
		["Threat"]="顯示單位高仇恨/低仇恨/被敵對目標選中/被友方目標選中的高亮顯示",
		["Glow"]="這個會在仇恨接近或者超過第一仇恨時(非坦克),或者只比第二仇恨略高時(不穩定的坦克) 顯示",
		["Glow2"]="這個會在仇恨比第一仇恨低很多時顯示",
		["Glow3"]="這個會在仇恨比第二仇恨高很多時顯示(穩定的坦克)",
		["Glow4"]="這個會在敵對單位的目標是自己時顯示,不論仇恨如何",
		["Glow5"]="這個會在非敵對單位的目標是自己時顯示",
	}
}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="仇恨",
		["ShowHostileGainThreat"]="显示高敌对仇恨",
		["ShowHostileLostThreat"]="显示低敌对仇恨",
		["ShowNonHostileGainThreat"]="显示非敌对高仇恨",
		["ShowNonHostileLostThreat"]="显示非敌对低仇恨",
		["ShowHostileTanking"]="显示正在坦的敌对目标",
		["ShowNonHostileTanking"]="显示正在坦的友方目标",
		["ShowText"]="显示文本",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",

		["Bar"]="条",
		["Overlay"]="前景",
		["Background"]="背景",
		["Text"]="文本",

		["ShowBar"]="显示条",
		["ColorBar"]="条着色",

		["Glow"]="高仇恨发光",
		["Glow2"]="低仇恨发光",
		["Glow3"]="坦克发光",
		["Glow4"]="目标是我的敌对发光",
		["Glow5"]="目标是我的非敌对发光",
		["ShowHostileTargetingMe"]="显示目标是我的敌对",
		["ShowNonHostileTargetingMe"]="显示目标是我的非敌对",
	}
	Tooltips={
		["Threat"]="显示单位高仇恨/低仇恨/被敌对目标选中/被友方目标选中的高亮显示",
		["Glow"]="这个会在仇恨接近或者超过第一仇恨时(非坦克),或者只比第二仇恨略高时(不稳定的坦克) 显示",
		["Glow2"]="这个会在仇恨比第一仇恨低很多时显示",
		["Glow3"]="这个会在仇恨比第二仇恨高很多时显示(稳定的坦克)",
		["Glow4"]="这个会在敌对单位的目标是自己时显示,不论仇恨如何",
		["Glow5"]="这个会在非敌对单位的目标是自己时显示",
	}
else
	Localization={
		["PageName"]="Threat",
		["ShowHostileGainThreat"]="Show high threat",
		["ShowHostileLostThreat"]="Show low threat",
		["ShowNonHostileGainThreat"]="Show non-hostile high threat",
		["ShowNonHostileLostThreat"]="Show non-hostile low threat",
		["ShowHostileTanking"]="Show a hostile tanking by self",
		["ShowNonHostileTanking"]="Show a tanking non-hostile",
		["ShowText"]="Show text",

		["Bar"]="Bar",
		["Overlay"]="Overlay",
		["Background"]="Background",
		["Text"]="Text",

		["ShowBar"]="Show bar",
		["ColorBar"]="Color bar",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",

		["Glow"]="High threat glow",
		["Glow2"]="Low threat glow",
		["Glow3"]="Tanking glow",
		["Glow4"]="Hostile targeting me glow",
		["Glow5"]="Non-hostile targeting me glow",
		["ShowHostileTargetingMe"]="Show hostile targeting me",
		["ShowNonHostileTargetingMe"]="Show non-hostile targeting me",
	}

	Tooltips={
		["Threat"]="Show glowing for high threat/low threat/targeting by enemy/targeting by friend for unit",
		["Glow"]="This will show when threat is close or higher than first threat(non-tank) , or slightly higher than second threat(unstable tanking)",
		["Glow2"]="This will show when threat is much lower than first threat",
		["Glow3"]="This will show when threat is much higher than second threat (stable tanking)",
		["Glow4"]="This will show when hostile unit is targeting self, no matter how threat level is",
		["Glow5"]="This will show when non-hostile unit is targeting self",
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_Threat",Localization["PageName"],"Threat",Tooltips["Threat"])

local Options=mainframe.Options

----------------
local sliderlist={
	["Threat_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["Threat_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	}
}

NPA_Options:BuildSliderList("NPA_Options_ComboPoint",mainframe,sliderlist,Options)

NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"Threat_BarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"Threat_OverlayData",1,Options,4)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"Threat_BackgroundData",1,Options,5)

NPA_Options:CreateSliderEditButton(Localization["Glow"],mainframe,"Threat_Glow2Data",1,Options,6.5,nil,Tooltips["Glow"])
NPA_Options:CreateSliderEditButton(Localization["Glow2"],mainframe,"Threat_Glow3Data",1,Options,7.5,nil,Tooltips["Glow2"])
NPA_Options:CreateSliderEditButton(Localization["Glow3"],mainframe,"Threat_Glow1Data",1,Options,8.5,nil,Tooltips["Glow3"])
NPA_Options:CreateSliderEditButton(Localization["Glow4"],mainframe,"Threat_Glow4Data",1,Options,9.5,nil,Tooltips["Glow4"])
NPA_Options:CreateSliderEditButton(Localization["Glow5"],mainframe,"Threat_Glow5Data",1,Options,10.5,nil,Tooltips["Glow5"])


NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"Threat_TextData",2,Options,12)


-------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_Threat_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(200)

local checkboxdata={
	["Threat_GlowHostileThreat"]=Localization["ShowHostileGainThreat"],
	["Threat_GlowHostileLostThreat"]=Localization["ShowHostileLostThreat"],
	["Threat_GlowNonHostileThreat"]=Localization["ShowNonHostileGainThreat"],
	["Threat_GlowNonHostileLostThreat"]=Localization["ShowNonHostileLostThreat"],
	["Threat_GlowHostileTanking"]=Localization["ShowHostileTanking"],
	["Threat_GlowNonHostileTanking"]=Localization["ShowNonHostileTanking"],
	["Threat_GlowHostileTargetingMe"]=Localization["ShowHostileTargetingMe"],
	["Threat_GlowNonHostileTargetingMe"]=Localization["ShowNonHostileTargetingMe"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_Threat",listframe,21,checkboxdata,18,Options,1)

local listframe2=NPA_Options:CreateFrame("NPA_Options_Threat_Filter",mainframe)
listframe2:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,0)
listframe2:SetWidth(200)

local checkboxdata={
	["Threat_Text"]=Localization["ShowText"],
	["Threat_ShowBar"]=Localization["ShowBar"],
	["Threat_ColorBar"]=Localization["ColorBar"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_Threat",listframe2,21,checkboxdata,18,Options,1)

end