﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local Localization={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["Test"]="測試",
		["Generate"]="生成",
		["Auto"]="自動(每3秒)",

	}
elseif(locale=="zhCN")then
	Localization={
		["Test"]="测试",
		["Generate"]="生成",
		["Auto"]="自动(每3秒)",

	}
else
	Localization={
		["Test"]="Test",
		["Generate"]="Generate",
		["Auto"]="Auto(every 3s)",
	}
end

local mainframe=NPA_Options.MainFrame

local function NPA_Test_CreateFrame()
	local frame=CreateFrame("Frame","NPA_Test_Frame",UIParent)
	frame.TimeStack=0
	frame:Hide()

	--module mainframe
	local rendermain=CreateFrame("Frame","NPA_RenderMainFrame",frame)
	rendermain:SetHeight(1)
	rendermain:SetWidth(1)
	rendermain:SetPoint("CENTER",frame,"CENTER")
	rendermain.Attach=frame
	rendermain:Show()

	local modulemain=CreateFrame("Frame","NPA_RenderMainFrame",rendermain)
	modulemain:SetHeight(20)
	modulemain:SetWidth(120)
	modulemain:SetPoint("CENTER",frame,"CENTER")
	modulemain:Show()
	modulemain:SetScale(1)

	modulemain.Parent=frame
	modulemain.TimeStack=100

	frame.IsTracker=1
	
	--scroll frame
	local scrollframe=CreateFrame("ScrollFrame","NPA_LayerFrame",frame)
	scrollframe:SetHeight(512)
	scrollframe:SetWidth(512)
	scrollframe:SetPoint("CENTER",frame,"CENTER")
	scrollframe:SetScrollChild(rendermain)
	scrollframe:SetFrameStrata("BACKGROUND")
	scrollframe:Show()

	modulemain.RenderMain=scrollframe
	
	frame.ModuleMain=modulemain


	NPA_Core:HookAll(modulemain)
	NPA_Core:HookModuleMain(modulemain)

	return frame
end
local testframe=NPA_Test_CreateFrame()


local button=NPA_Options:CreateButton("NPA_TestButton",mainframe,80,24,Localization["Generate"])
button:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMLEFT",-20,0)
button:SetScript("OnClick",function()
	NPA_Core:GenerateTest()
	testframe:Show()
	end)
local button2=NPA_Options:CreateButton("NPA_TestCloseButton",mainframe,24,24,"X")
button2:SetPoint("RIGHT",button,"LEFT",-2,0)
button2:SetScript("OnClick",function()
	testframe:Hide()
	end)

local checkbox=NPA_Options:CreateCheckBox("NPA_TestCheckBox",mainframe,24,Localization["Auto"],nil)
checkbox:SetPoint("TOPLEFT",button2,"BOTTOMLEFT",0,-2)
checkbox:SetScript("OnClick",nil)
checkbox:SetScript("OnShow",nil)



testframe.GUID=-100
NPA_Core.GUIDToFrame[-100]=testframe
testframe.ModuleMain.GUID=-100
testframe:SetHeight(150)
testframe:SetWidth(200)
testframe:SetScript("OnUpdate",function(self,stack)
	if(checkbox:GetChecked())then
		self.TimeStack=self.TimeStack+stack
		if(self.TimeStack>3)then
			NPA_Core:GenerateTest()
			self.TimeStack=0
		end
	end

	end)
testframe:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMLEFT",-100,50)
testframe.ModuleMain:Show()

mainframe:HookScript("OnHide",function() testframe:Hide() end)
mainframe:HookScript("OnShow",function() testframe:Show() end)
