﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("Target"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="目標",
		["StickToBuff"]="固定文本到buff框體",
		["StickToDebuff"]="固定文本到debuff框體",
		["ShowText"]="顯示文本",
		["IndicatorTexture"]="指示器材質",
		["IndicatorOffsetX"]="指示器X偏移",
		["IndicatorOffsetY"]="指示器Y偏移",
		["IndicatorCount"]="指示器數量(設為0則關閉)",
		["Color"]="根據目標陣營著色",
		["MyTarget"]="顯示自己的指示器",
		["MyTargetTarget"]="顯示目標的指示器",
		["Other"]="顯示其它單位的指示器",
		["Hostile"]="顯示敵對的指示器",
		["NonHostile"]="顯示非敵對的指示器",
		["Color2"]="根據陣營上色",
		["Indicator"]="指示器",
		["Text"]="文本",
		["IndicatorSpeed"]="指示器速度(設為0則靜止)",
		["IndicatorGapScale"]="指示器間隙縮放",
		["FixedGap"]="指示器使用固定間隙",
		["GapX"]="指示器間隙寬度",
		["GapY"]="指示器間隙高度",
		["BlinkCasting"]="施法時閃爍指示器",
		["TargetFrameShow"]="顯示目標框體",
		["TargetFrameOffsetX"]="目標框體X偏移",
		["TargetFrameOffsetY"]="目標框體Y偏移",
		["TargetFrameSize"]="目標框體縮放",
		["TargetFrameHideWhenOnScreen"]="當目標在屏幕上時不顯示",
		["ModuleList"]="目標框體模塊(需要重載ui)",
		["Border"]="邊框",
		["Background"]="背景",
		["ShowBorder"]="顯示邊框",
		["ShowBackground"]="顯示背景",
		["ShowPortrait"]="顯示目標頭像",
		["OnlyPlayer"]="只顯示玩家目標",
		["Portrait"]="頭像",
		["PortraitCacheCount"]="最大頭像數量",

		["IndicatorStretch"]="拉伸指示器圖標",
		["IndicatorStretchStart"]="指示器拉伸起始尺寸",
		["IndicatorStretchEnd"]="指示器拉伸結束尺寸",

		["Aura"]="增減益",
		["AutoHide"]="自動隱藏",
		["CastWarning"]="施法警告",
		["ClassIcon"]="職業圖標",
		["ComboPoint"]="連擊點數",
		["CoolDown"]="技能冷卻",
		["CrowdControl"]="控場提示",
		["HealthBar"]="生命條",
		["ManaBar"]="法力條",
		["QuestMark"]="任務指示",
		["RaidIcon"]="團隊標記",
		["ScrollText"]="戰鬥文字",
		["Speed"]="移動速度",
		["Target"]="目標",
		["Threat"]="仇恨",
		["Tracker"]="追踪",
		["ClassInfo"]="職業信息",
		["NameText"]="名稱文本",
		["exCombat"]="脫離戰鬥",
		["RangeCheck"]="距離檢測",
		["CounterSpell"]="法術反制",
		["RoleCheck"]="職位檢查",
		["TargetCount"]="目標計數",
		["ShieldWatch"]="護盾監視",
	}
	Tooltips={
		["Target"]="顯示單位的目標和指向目標的指示器",
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="目标",
		["StickToBuff"]="固定文本到buff框体",
		["StickToDebuff"]="固定文本到debuff框体",
		["ShowText"]="显示文本",
		["IndicatorTexture"]="指示器材质",
		["IndicatorOffsetX"]="指示器X偏移",
		["IndicatorOffsetY"]="指示器Y偏移",
		["IndicatorCount"]="指示器数量 (设为0则关闭)",
		["Color"]="根据目标阵营着色",
		["MyTarget"]="显示自己的指示器",
		["MyTargetTarget"]="显示目标的指示器",
		["Other"]="显示其它单位的指示器",
		["Hostile"]="显示敌对的指示器",
		["NonHostile"]="显示非敌对的指示器",
		["Color2"]="根据阵营上色",
		["Indicator"]="指示器",
		["Text"]="文本",
		["IndicatorSpeed"]="指示器速度(设为0则静止)",
		["IndicatorGapScale"]="指示器间隙缩放",
		["FixedGap"]="指示器使用固定间隙",
		["GapX"]="指示器间隙宽度",
		["GapY"]="指示器间隙高度",
		["BlinkCasting"]="施法时闪烁指示器",
		["TargetFrameShow"]="显示目标框体",
		["TargetFrameOffsetX"]="目标框体X偏移",
		["TargetFrameOffsetY"]="目标框体Y偏移",
		["TargetFrameSize"]="目标框体缩放",
		["TargetFrameHideWhenOnScreen"]="当目标在屏幕上时不显示",
		["ModuleList"]="目标框体模块(需要重载ui)",
		["Border"]="边框",
		["Background"]="背景",
		["ShowBorder"]="显示边框",
		["ShowBackground"]="显示背景",

		["ShowPortrait"]="显示目标头像",
		["OnlyPlayer"]="只显示玩家目标",
		["Portrait"]="头像",
		["PortraitCacheCount"]="最大头像数量",

		["IndicatorStretch"]="拉伸指示器图标",
		["IndicatorStretchStart"]="指示器拉伸起始尺寸",
		["IndicatorStretchEnd"]="指示器拉伸结束尺寸",

		["Aura"]="增减益",
		["AutoHide"]="自动隐藏",
		["CastWarning"]="施法警告",
		["ClassIcon"]="职业图标",
		["ComboPoint"]="连击点数",
		["CoolDown"]="技能冷却",
		["CrowdControl"]="控场提示",
		["HealthBar"]="生命条",
		["ManaBar"]="法力条",
		["QuestMark"]="任务指示",
		["RaidIcon"]="团队标记",
		["ScrollText"]="战斗文字",
		["Speed"]="移动速度",
		["Target"]="目标",
		["Threat"]="仇恨",
		["RangeCheck"]="距离检测",
		["Tracker"]="追踪",
		["CounterSpell"]="法术反制",
		["NameText"]="名称文本",
		["TargetCount"]="目标计数",
		["ShieldWatch"]="护盾监视",
		["RoleCheck"]="职位检查",
		["exCombat"]="脱离战斗",
		["ClassInfo"]="职业信息",
	}
	Tooltips={
		["Target"]="显示单位的目标和指向目标的指示器",
	}
else
	Localization={
		["PageName"]="Target",
		["StickToBuff"]="Stick text to Buff",
		["StickToDebuff"]="Stick text to Debuff",
		["ShowText"]="Show text",
		["IndicatorTexture"]="Indicator texture",
		["IndicatorOffsetX"]="Indicator offset X",
		["IndicatorOffsetY"]="Indicator offset Y",
		["IndicatorCount"]="Indicator count (set 0 to turn off)",
		["Color"]="Color by target's faction",
		["MyTarget"]="Indicator of myself",
		["MyTargetTarget"]="Indicator of my target",
		["Other"]="Indicator of others",
		["Hostile"]="Indicator of hostile",
		["NonHostile"]="Indicator of non-hostile",
		["Color2"]="Color by faction",
		["Indicator"]="Indicator",
		["Text"]="Text",
		["IndicatorSpeed"]="Indicator speed(Set to 0 for static)",
		["IndicatorGapScale"]="Indicator gap scale",
		["FixedGap"]="Indicators use fixed gap",
		["GapX"]="Indicator gap width",
		["GapY"]="Indicator gap height",
		["BlinkCasting"]="Blink indicators when casting",
		["TargetFrameShow"]="Show target frame",
		["TargetFrameOffsetX"]="Target frame offset X",
		["TargetFrameOffsetY"]="Target frame offset Y",
		["TargetFrameSize"]="Target frame size",
		["TargetFrameHideWhenOnScreen"]="Hide when target is on screen",

		["ModuleList"]="Target frame module(require ui reload)",

		["Border"]="Border",
		["Background"]="Background",
		["ShowBorder"]="Show border",
		["ShowBackground"]="Show background",

		["ShowPortrait"]="Show target portrait",
		["OnlyPlayer"]="Show only player target",
		["Portrait"]="Portrait",
		["PortraitCacheCount"]="Max portraits number",

		["IndicatorStretch"]="Stretch indicator icon",
		["IndicatorStretchStart"]="Indicator stretch start size",
		["IndicatorStretchEnd"]="Indicator stretch end size",

		["Aura"]="Aura",
		["AutoHide"]="AutoHide",
		["CastWarning"]="CastWarning",
		["ClassIcon"]="ClassIcon",
		["ComboPoint"]="ComboPoint",
		["CoolDown"]="CoolDown",
		["CrowdControl"]="CrowdControl",
		["HealthBar"]="HealthBar",
		["ManaBar"]="ManaBar",
		["QuestMark"]="QuestMark",
		["RaidIcon"]="RaidIcon",
		["ScrollText"]="ScrollText",
		["Speed"]="Speed",
		["Target"]="Target",
		["Threat"]="Threat",
		["RangeCheck"]="RangeCheck",
		["Tracker"]="Tracker",
		["CounterSpell"]="CounterSpell",
		["ClassInfo"]="ClassInfo",
		["NameText"]="NameText",
		["TargetCount"]="TargetCount",
		["ShieldWatch"]="ShieldWatch",
		["RoleCheck"]="RoleCheck",
		["exCombat"]="exCombat",

	}
	Tooltips={
		["Target"]="Shows unit's target and indicator to unit's target from unit",
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_Target",Localization["PageName"],"Target",Tooltips["Target"])

local Options=mainframe.Options

----------------
local sliderlist={
	["Target_Indicator_OffsetX"]={
		Name=Localization["IndicatorOffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["Target_Indicator_OffsetY"]={
		Name=Localization["IndicatorOffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	},

	["Target_Indicator_Count"]={
		Name=Localization["IndicatorCount"],
		Min=1,
		Max=10,
		Step=1,
		Width=280,
		OffsetX=20,
		OffsetY=-45
	},
	["Target_Indicator_Speed"]={
		Name=Localization["IndicatorSpeed"],
		Min=0,
		Max=2,
		Step=0.1,
		Width=280,
		OffsetX=20,
		OffsetY=-85
	},
	["Target_Indicator_GapScale"]={
		Name=Localization["IndicatorGapScale"],
		Min=0,
		Max=1,
		Step=0.1,
		Width=280,
		OffsetX=20,
		OffsetY=-125
	},


	["Target_Indicator_GapX"]={
		Name=Localization["GapX"],
		Min=1,
		Max=50,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-165
	},
	["Target_Indicator_GapY"]={
		Name=Localization["GapY"],
		Min=1,
		Max=50,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-165
	},

	["Target_TargetFrame_OffsetX"]={
		Name=Localization["TargetFrameOffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-345
	},
	["Target_TargetFrame_OffsetY"]={
		Name=Localization["TargetFrameOffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-345
	},

	["Target_TargetFrame_Size"]={
		Name=Localization["TargetFrameSize"],
		Min=1,
		Max=5,
		Step=0.01,
		Width=140,
		OffsetX=20,
		OffsetY=-385
	},

	["Target_PortraitCacheCount"]={
		Name=Localization["PortraitCacheCount"],
		Min=1,
		Max=5,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-445
	},

	["Target_Indicator_StretchStart"]={
		Name=Localization["IndicatorStretchStart"],
		Min=1,
		Max=5,
		Step=0.1,
		Width=140,
		OffsetX=20,
		OffsetY=-505
	},

	["Target_Indicator_StretchEnd"]={
		Name=Localization["IndicatorStretchEnd"],
		Min=1,
		Max=5,
		Step=0.1,
		Width=140,
		OffsetX=190,
		OffsetY=-505
	},


}

NPA_Options:BuildSliderList("NPA_Options_Target",mainframe,sliderlist,Options)


NPA_Options:CreateSliderEditButton(Localization["Indicator"],mainframe,"Target_IndicatorData",3,Options,7.5)
NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"Target_TextData",2,Options,8.5)

NPA_Options:CreateSliderEditButton(Localization["Border"],mainframe,"Target_BorderData",1,Options,7.5,1)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"Target_BackgroundData",1,Options,8.5,1)


NPA_Options:CreateSliderEditButton(Localization["Portrait"],mainframe,"Target_PortraitData",3,Options,10)


-------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_Target_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(240)

local checkboxdata={
	["Target_OnlyPlayer"]=Localization["OnlyPlayer"],
	["Target_ShowPortrait"]=Localization["ShowPortrait"],
	["Target_ShowText"]=Localization["ShowText"],
	["Target_StickToBuff"]=Localization["StickToBuff"],
	["Target_StickToDebuff"]=Localization["StickToDebuff"],
	["Target_Indicator_Color"]=Localization["Color"],
	["Target_Indicator_Color2"]=Localization["Color2"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_Target",listframe,21,checkboxdata,17,Options,1)

local listframe3=NPA_Options:CreateFrame("NPA_Options_Target_Filter2",mainframe)
listframe3:SetPoint("TOPLEFT",listframe,"BOTTOMLEFT",0,3)
listframe3:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,3)

local checkboxdata={
	["Target_Indicator_MyTarget"]=Localization["MyTarget"],
	["Target_Indicator_MyTargetTarget"]=Localization["MyTargetTarget"],
	["Target_Indicator_Other"]=Localization["Other"],
	["Target_Indicator_Hostile"]=Localization["Hostile"],
	["Target_Indicator_NonHostile"]=Localization["NonHostile"]

}
NPA_Options:BuildCheckBoxList("NPA_Options_Target",listframe3,21,checkboxdata,17,Options,1)

local listframe4=NPA_Options:CreateFrame("NPA_Options_Target_Filter3",mainframe)
listframe4:SetPoint("TOPLEFT",listframe3,"BOTTOMLEFT",0,3)
listframe4:SetPoint("TOPRIGHT",listframe3,"BOTTOMRIGHT",0,3)


local checkboxdata={
	["Target_Indicator_FixedGap"]=Localization["FixedGap"],
	["Target_Indicator_BlinkCasting"]=Localization["BlinkCasting"],
	["Target_Indicator_Stretch"]=Localization["IndicatorStretch"],

}
NPA_Options:BuildCheckBoxList("NPA_Options_Target",listframe4,21,checkboxdata,17,Options,1)

local listframe5=NPA_Options:CreateFrame("NPA_Options_Target_Filter3",mainframe)
listframe5:SetPoint("TOPLEFT",listframe4,"BOTTOMLEFT",0,3)
listframe5:SetPoint("TOPRIGHT",listframe4,"BOTTOMRIGHT",0,3)

local checkboxdata={
	["Target_TargetFrame_Show"]=Localization["TargetFrameShow"],
	["Target_TargetFrame_HideWhenOnScreen"]=Localization["TargetFrameHideWhenOnScreen"],
	["Target_ShowBorder"]=Localization["ShowBorder"],
	["Target_ShowBackground"]=Localization["ShowBackground"],
}
NPA_Options:BuildCheckBoxList("NPA_Options_Target",listframe5,21,checkboxdata,17,Options,1)


local modulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_Target_ModuleList",mainframe,Localization["ModuleList"],"Target_ModuleList",nil,nil,Localization)
modulelist:SetPoint("TOPLEFT",listframe5,"BOTTOMLEFT",0,-3)
modulelist:SetPoint("TOPRIGHT",listframe5,"BOTTOMRIGHT",0,-3)

end