﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("ShieldWatch"))then

local Localization={}
local localization={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="護盾監視",
		["ShowBorder"]="顯示邊框",
		["ShowRemaining"]="顯示剩餘吸收量",
		["ShowTimeleft"]="顯示剩餘時間",
		["Seperate"]="獨立顯示不同的法術",
		["AltDisplay"]="修改獨立顯示方式",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Height"]="高度",
		["Width"]="寬度",
		["Timeleft"]="剩餘時間文本",
		["Remaining"]="剩餘量文本",
		["Bar"]="條",
		["Background"]="條背景",
		["Border"]="條前景",
		["ColorText"]="用條顏色著色文本",
		["SeperateText"]="分離文本顯示",
		["Short"]="縮寫長數字",
		["Break"]="分割長數字",
	}
	Tooltips={
		["ShieldWatch"]="顯示單位擁有的傷害吸收盾的剩餘量,計時器,和計數條(只能工作在wow4.x中)"
	}

elseif(locale=="zhCN")then
	Localization={
		["PageName"]="护盾监视",
		["ShowBorder"]="显示边框",
		["ShowRemaining"]="显示剩余吸收量",
		["ShowTimeleft"]="显示剩余时间",
		["Seperate"]="独立显示不同的法术",
		["AltDisplay"]="修改独立显示方式",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Height"]="高度",
		["Width"]="宽度",
		["Timeleft"]="剩余时间文本",
		["Remaining"]="剩余量文本",
		["Bar"]="条",
		["Background"]="条背景",
		["Border"]="条前景",
		["ColorText"]="用条颜色着色文本",
		["SeperateText"]="分离文本显示",
		["Short"]="缩写长数字",
		["Break"]="分割长数字",
	}
	Tooltips={
		["ShieldWatch"]="显示单位拥有的伤害吸收盾的剩余量,计时器,和计数条(只能工作在wow4.x中)"
	}

else
	Localization={
		["PageName"]="ShieldWatch",
		["ShowBorder"]="Show border",
		["ShowRemaining"]="Show remaining amount",
		["ShowTimeleft"]="Show remaining time",
		["Seperate"]="Seperate different spell",
		["AltDisplay"]="Alt seperate display",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["Height"]="Height",
		["Width"]="Width",
		["Timeleft"]="Text for timeleft",
		["Remaining"]="Text for remaining",
		["Bar"]="Bar",
		["Background"]="Bar background",
		["Border"]="Bar Border",
		["ColorText"]="Color text as bar",
		["SeperateText"]="Seperate text display",
		["Short"]="Short long number",
		["Break"]="Break long number",
	}
	Tooltips={
		["ShieldWatch"]="Show amount, timer, and amout bar for damage shield of unit(only works in wow 4.x)"
	}

end


local mainframe=NPA_Options:AddPage("NPA_Options_ShieldWatch",Localization["PageName"],"ShieldWatch",Tooltips["ShieldWatch"])

local Options=mainframe.Options

----------------
local sliderlist={
	["ShieldWatch_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["ShieldWatch_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	},
	["ShieldWatch_BarWidth"]={
		Name=Localization["Width"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-45
	},
	["ShieldWatch_BarHeight"]={
		Name=Localization["Height"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-45
	}
}

NPA_Options:BuildSliderList("NPA_Options_ShieldWatch",mainframe,sliderlist,Options)

NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"ShieldWatch_BarData",1,Options,6)
NPA_Options:CreateSliderEditButton(Localization["Border"],mainframe,"ShieldWatch_BorderData",1,Options,7)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"ShieldWatch_BackgroundData",1,Options,8)

NPA_Options:CreateSliderEditButton(Localization["Timeleft"],mainframe,"ShieldWatch_TextData",2,Options,9.5)
NPA_Options:CreateSliderEditButton(Localization["Remaining"],mainframe,"ShieldWatch_Text2Data",2,Options,10.5)


-------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_ShieldWatch_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(200)

local checkboxdata={
	["ShieldWatch_ShowBorder"]=Localization["ShowBorder"],
	["ShieldWatch_Seperate"]=Localization["Seperate"],
	["ShieldWatch_AltDisplay"]=Localization["AltDisplay"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_ShieldWatch",listframe,21,checkboxdata,18,Options,1)

local listframe2=NPA_Options:CreateFrame("NPA_Options_ShieldWatch_Filter2",mainframe)
listframe2:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,-6)
listframe2:SetWidth(200)

local checkboxdata={
	["ShieldWatch_ShowRemaining"]=Localization["ShowRemaining"],
	["ShieldWatch_ShowTimeleft"]=Localization["ShowTimeleft"],
	["ShieldWatch_SeperateText"]=Localization["SeperateText"],
	["ShieldWatch_ColorText"]=Localization["ColorText"],
	["ShieldWatch_Short"]=Localization["Short"],
	["ShieldWatch_Break"]=Localization["Break"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_ShieldWatch",listframe2,21,checkboxdata,18,Options,1)
end