﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("ScrollText"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs
local Tooltips={}

if(locale=="zhTW")then
	Localization={
		["PageName"]="戰鬥文字", 
		["UpdateInterval"]="更新間隔(秒)", 

		["Speed​​X"]="基礎x速度", 
		["Speed​​Y"]="基礎y速度", 
		["AccX"]="x加速度", 
		["AccY"]="y加速度", 
		["Max"]="最大數量", 
		["Life"]="存活時間(秒)", 
		["OffsetX"]="X偏移", 
		["OffsetY"]="Y偏移", 
		["SpreadX"]="X擴散範圍", 
		["SpreadY"]="Y擴散範圍", 

		["Icon"]="圖標", 
		["Text"]="文本", 
		["Overlay"]="前景", 
		["Background"]="背景", 
		["CritIcon"]="暴擊圖標", 
		["CritText"]="暴擊文本", 
		["CritOverlay"]="暴擊前景", 
		["CritBackground"]="暴擊背景", 

		["Melee"]="近戰傷害",
		["Range"]="遠程傷害",
		["Spell"]="法術傷害",
		["SpellShield"]="反射盾傷害",
		["Environmental"]="環境傷害",
		["Dot"]="持續傷害",

		["Heal"]="治療",
		["Hot"]="持續治療",
		
		["DamageMiss"]="普通傷害未擊中",
		["DamageShieldMiss"]="傷害盾未擊中",
		["SpellMiss"]="法術未擊中",
		["DispelMiss"]="驅散失敗",
		["Stolen"]="法術偷取",
		["Dispel"]="驅散",
		["AuraGain"]="獲得效果",
		["AuraLost"]="失去效果",
		["Interrupt"]="打斷",
		["Energized"]="獲得能量",
		["Kill"]="擊殺",

		["ShowCaster"]="單位名稱", 
		["ShowSelf"]="自己的法術標記", 
		["ShowSpellName"]="法術名稱", 
		["ShowSpellRank"]="法術等級", 
		["ShowAbsorb"]="吸收/過量", 

		["HideFullOverHeal"]="隱藏完全過量治療", 
		["HideByFrame"]="隨框體隱藏", 
		["AlphaByFrame"]="隨框體透明", 
		["StickCrit"]="粘滯暴擊", 
		["ShakeCrit"]="抖動暴擊", 

		["DamageType"]="傷害類",
		["HealType"]="治療類",
		["MiscType"]="其它類",

		["DamageFilter"]="傷害過濾",
		["HealFilter"]="治療過濾",
		["MiscFilter"]="其它內容過濾",

		["ShowFromSelf"]="顯示來自於自己",
		["ShowFromHostile"]="顯示來自敵對",
		["ShowFromNonHostile"]="顯示來自非敵對",
		["ShowFromFocus"]="顯示來自Focus",
		["ShowFromTarget"]="顯示來自目標",
		["ShowFromPet"]="顯示來自寵物",

		["ShowToSelf"]="顯示目標為自己",
		["ShowToHostile"]="顯示目標為敵對",
		["ShowToNonHostile"]="顯示目標為敵對",
		["ShowToFocus"]="顯示目標為Focus",
		["ShowToTarget"]="顯示目標為目標",
		["ShowToPet"]="顯示目標為寵物",

		["InstantCast"]="瞬發法術", 

		["FlyingIcon"]="飛行圖標", 
		["In"]="承受效果", 
		["Out"]="輸出效果", 
		["Enabled"]="啟用" 
	}
	Tooltips={
		["ScrollText"]="顯示單位對應的戰鬥記錄信息(傷害/治療/光環/打斷)",
		["In"]="顯示一個單位承受的來自其它來源的效果",
		["Out"]="顯示一個單位對其它目標造成的效果",
		["FlyingIcon"]="把傷害/效果顯示為從施法者到目標之間飛行的圖標"

	}

elseif(locale=="zhCN")then
	Localization={
		["PageName"]="战斗文字",
		["UpdateInterval"]="更新间隔(秒)",
		
		["SpeedX"]="基础x速度",
		["SpeedY"]="基础y速度",
		["AccX"]="x加速度",
		["AccY"]="y加速度",
		["Max"]="最大数量",
		["Life"]="存活时间(秒)",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["SpreadX"]="X扩散范围",
		["SpreadY"]="Y扩散范围",

		["Icon"]="图标",
		["Text"]="文本",
		["Overlay"]="前景",
		["Background"]="背景",
		["CritIcon"]="暴击图标",
		["CritText"]="暴击文本",
		["CritOverlay"]="暴击前景",
		["CritBackground"]="暴击背景",
		
		["Melee"]="近战伤害",
		["Range"]="远程伤害",
		["Spell"]="法术伤害",
		["SpellShield"]="反射盾伤害",
		["Environmental"]="环境伤害",
		["Dot"]="持续伤害",
		
		["Heal"]="治疗",
		["Hot"]="持续治疗",
		
		["DamageMiss"]="普通伤害未击中",
		["DamageShieldMiss"]="伤害盾未击中",
		["SpellMiss"]="法术未击中",
		["DispelMiss"]="驱散失败",
		["Stolen"]="法术偷取",
		["Dispel"]="驱散",
		["AuraGain"]="获得效果",
		["AuraLost"]="失去效果",
		["Interrupt"]="打断",
		["Energized"]="获得能量",
		["Kill"]="击杀",

		["ShowCaster"]="单位名称",
		["ShowSelf"]="自己的法术标记",
		["ShowSpellName"]="法术名称",
		["ShowSpellRank"]="法术等级",
		["ShowAbsorb"]="吸收/过量",

		["HideFullOverHeal"]="隐藏完全过量治疗",
		["HideByFrame"]="随框体隐藏",
		["AlphaByFrame"]="随框体透明",
		["StickCrit"]="粘滞暴击",
		["ShakeCrit"]="抖动暴击",
		
		["DamageType"]="伤害类",
		["HealType"]="治疗类",
		["MiscType"]="其它类",

		["DamageFilter"]="伤害过滤",
		["HealFilter"]="治疗过滤",
		["MiscFilter"]="其它内容过滤",

		["ShowFromSelf"]="显示来自于自己",
		["ShowFromHostile"]="显示来自敌对",
		["ShowFromNonHostile"]="显示来自非敌对",
		["ShowFromFocus"]="显示来自Focus",
		["ShowFromTarget"]="显示来自目标",
		["ShowFromPet"]="显示来自宠物",

		["ShowToSelf"]="显示目标为自己",
		["ShowToHostile"]="显示目标为敌对",
		["ShowToNonHostile"]="显示目标为敌对",
		["ShowToFocus"]="显示目标为Focus",
		["ShowToTarget"]="显示目标为目标",
		["ShowToPet"]="显示目标为宠物",

		
		["InstantCast"]="瞬发法术",

		["FlyingIcon"]="飞行图标",
		["In"]="承受效果",
		["Out"]="输出效果",
		["Enabled"]="启用"
	}
	Tooltips={
		["ScrollText"]="显示单位对应的战斗记录信息(伤害/治疗/光环/打断)",
		["In"]="显示一个单位承受的来自其它来源的效果",
		["Out"]="显示一个单位对其它目标造成的效果",
		["FlyingIcon"]="把伤害/效果显示为从施法者到目标之间飞行的图标"
	}

else
	Localization={
		["PageName"] = "ScrollText", 
		["UpdateInterval"] = "Update interval (second)" ,

		["SpeedX"] = "Basic speed X", 
		["SpeedY"] = "Basic speed Y", 
		["AccX"] = "Acceleration X" ,
		["AccY"] = "Acceleration Y", 
		["Max"] = "Max number", 
		["Life"] = "Life time (second)" ,
		["OffsetX"] = "Offset X", 
		["OffsetY"] = "Offset Y" ,
		["SpreadX"] = "Spread X" ,
		["SpreadY"] = "Spread Y" ,

		["Icon"] = "Icon", 
		["Text"] = "Text", 
		["Overlay"] = "Overlay", 
		["Background"] = "Background", 
		["CritIcon"] = "Crit Icon" ,
		["CritText"] = "Crit Text" ,
		["CritOverlay"] = "Crit Overlay", 
		["CritBackground"] = "Crit Background", 

		["Melee"]="Melee damage",
		["Range"]="Range damage",
		["Spell"]="Spell damage",
		["SpellShield"]="Damage shield damage",
		["Environmental"]="Environmental damage",
		["Dot"]="Dot",

		["Heal"]="Heal",
		["Hot"]="Hot",

		["DamageMiss"]="Normal damage miss",
		["DamageShieldMiss"]="Damage shield miss",
		["SpellMiss"]="Spell miss",
		["DispelMiss"]="Dispel miss",
		["Stolen"]="Stolen",
		["Dispel"]="Dispel",
		["AuraGain"]="Aura gain",
		["AuraLost"]="Aura lost",
		["Interrupt"]="Interrupt",
		["Energized"]="Energized",
		["Kill"]="Kill",
		
		["ShowCaster"] = "Unit name", 
		["ShowSelf"] = "Marker for self",
		["ShowSpellName"] = "Spell name" ,
		["ShowSpellRank"] = "Spell level", 
		["ShowAbsorb"] = "Absorb / Overkill", 

		["HideFullOverHeal"] = "Hide full over-heal", 
		["HideByFrame"] = "Hide with frame", 
		["AlphaByFrame"] = "Alpha with frame", 
		["StickCrit"] = "Stick crit" ,
		["ShakeCrit"] = "Shake crit" ,

		["DamageType"]="Damage type",
		["HealType"]="Heal type",
		["MiscType"]="Other type",

		["DamageFilter"]="Damage filters",
		["HealFilter"]="Heal filters",
		["MiscFilter"]="Other filters",

		["ShowFromSelf"]="Show from self",
		["ShowFromHostile"]="Show from Hostile",
		["ShowFromNonHostile"]="Show from non-hostile",
		["ShowFromFocus"]="Show from focus",
		["ShowFromTarget"]="Show from target",
		["ShowFromPet"]="Show from pet",

		["ShowToSelf"]="Show to self",
		["ShowToHostile"]="Show to hostile",
		["ShowToNonHostile"]="Show to non-hostile",
		["ShowToFocus"]="Show to focus",
		["ShowToTarget"]="Show to target",
		["ShowToPet"]="Show to pet",

		["InstantCast"] = "Instant cast" ,
		
		["FlyingIcon"] = "Flying Icons" ,
		["In"] = "Effect taken", 
		["Out"] = "Effect output", 
		["Enabled"] = "Enabled",
	}

	Tooltips={
		["ScrollText"]="Show combat log info for unit (damage/heal/aura/inturrept)",
		["In"]="Show effects a unit taken from other source",
		["Out"]="Show effects a unit outputs to other target",
		["FlyingIcon"]="Show effect/damage as icon flying from caster to target"
	}

end


local mainframe=NPA_Options:AddPage("NPA_Options_ScrollText",Localization["PageName"],"ScrollText",Tooltips["ScrollText"])

local Options=mainframe.Options

local sliderlist={
	["ScrollText_UpdateInterval"]={
		Name=Localization["UpdateInterval"],
		Min=0.01,
		Max=1,
		Step=0.01,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
}

NPA_Options:BuildSliderList("NPA_Options_ScrollText",mainframe,sliderlist,Options)

local optionsframe1=NPA_Options:CreateFrame("NPA_Options_ScrollText_InPage",mainframe,Localization["In"])
optionsframe1:SetPoint("TOPLEFT",mainframe,"TOPLEFT",3,-65)
optionsframe1:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",-3,3)

local optionsframe2=NPA_Options:CreateFrame("NPA_Options_ScrollText_OutPage",mainframe,Localization["Out"])
optionsframe2:SetPoint("TOPLEFT",mainframe,"TOPLEFT",3,-65)
optionsframe2:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",-3,3)

local optionsframe3=NPA_Options:CreateFrame("NPA_Options_ScrollText_FlyingIcon",mainframe,Localization["FlyingIcon"])
optionsframe3:SetPoint("TOPLEFT",mainframe,"TOPLEFT",3,-65)
optionsframe3:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",-3,3)


local button1=NPA_Options:CreateButton("NPA_Options_ScrollText_In",mainframe,0,17,Localization["In"],Tooltips["In"])
local button2=NPA_Options:CreateButton("NPA_Options_ScrollText_Out",mainframe,0,17,Localization["Out"],Tooltips["Out"])
local button3=NPA_Options:CreateButton("NPA_Options_ScrollText_FlyingIcon",mainframe,0,17,Localization["FlyingIcon"],Tooltips["FlyingIcon"])

button1:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",350,-15)
button1:SetScript("OnClick",function()
	button1:SetButtonState("PUSHED") 
	button2:SetButtonState("NORMAL")
	button3:SetButtonState("NORMAL")
	optionsframe1:Show()
	optionsframe2:Hide()
	optionsframe3:Hide()
	end)

button2:SetPoint("LEFT",button1,"RIGHT",3,0)
button2:SetScript("OnClick",function()
	button1:SetButtonState("NORMAL")
	button2:SetButtonState("PUSHED") 
	button3:SetButtonState("NORMAL")
	
	optionsframe1:Hide()
	optionsframe2:Show()
	optionsframe3:Hide()
	end)

button3:SetPoint("LEFT",button2,"RIGHT",3,0)
button3:SetScript("OnClick",function()
	button1:SetButtonState("NORMAL")
	button2:SetButtonState("NORMAL")
	button3:SetButtonState("PUSHED") 

	optionsframe1:Hide()
	optionsframe2:Hide()
	optionsframe3:Show()
	end)

button1:HookScript("OnShow",function()
	optionsframe1:Show()
	optionsframe2:Show()
	optionsframe3:Show()

	optionsframe2:Hide()
	optionsframe3:Hide()
	
	button1:SetButtonState("PUSHED") 
	button2:SetButtonState("NORMAL")
	button3:SetButtonState("NORMAL")
	end)

-----------------scrolltext in
local checkbox1=NPA_Options:CreateCheckBox("NPA_Options_ScrollText_Enabled",optionsframe1,21,Localization["Enabled"],"ScrollText_Enabled")
checkbox1:SetPoint("TOPLEFT",20,-5)
table_insert(Options,checkbox1)


local sliderlist={
	["ScrollText_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-25
	},
	["ScrollText_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-25
	},
	["ScrollText_SpeedX"]={
		Name=Localization["SpeedX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-65
	},
	["ScrollText_SpeedY"]={
		Name=Localization["SpeedY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-65
	},
	["ScrollText_SpreadX"]={
		Name=Localization["SpreadX"],
		Min=0,
		Max=300,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-105
	},
	["ScrollText_SpreadY"]={
		Name=Localization["SpreadY"],
		Min=0,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-105
	},
	["ScrollText_AccX"]={
		Name=Localization["AccX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-145
	},
	["ScrollText_AccY"]={
		Name=Localization["AccY"],
		Min=-150,
		Max=15,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-145
	},
	["ScrollText_Life"]={
		Name=Localization["Life"],
		Min=0,
		Max=5,
		Step=0.1,
		Width=140,
		OffsetX=20,
		OffsetY=-185
	},
	["ScrollText_Max"]={
		Name=Localization["Max"],
		Min=1,
		Max=600,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-185
	}
}

NPA_Options:BuildSliderList("NPA_Options_ScrollText",optionsframe1,sliderlist,Options)

NPA_Options:CreateSliderEditButton(Localization["Icon"],optionsframe1,"ScrollText_IconData",3,Options,8)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],optionsframe1,"ScrollText_OverlayData",3,Options,9)
NPA_Options:CreateSliderEditButton(Localization["Background"],optionsframe1,"ScrollText_BackgroundData",3,Options,10)
NPA_Options:CreateSliderEditButton(Localization["Text"],optionsframe1,"ScrollText_TextData",2,Options,11)

NPA_Options:CreateSliderEditButton(Localization["CritIcon"],optionsframe1,"ScrollText_CritIconData",3,Options,8,1)
NPA_Options:CreateSliderEditButton(Localization["CritOverlay"],optionsframe1,"ScrollText_CritOverlayData",3,Options,9,1)
NPA_Options:CreateSliderEditButton(Localization["CritBackground"],optionsframe1,"ScrollText_CritBackgroundData",3,Options,10,1)
NPA_Options:CreateSliderEditButton(Localization["CritText"],optionsframe1,"ScrollText_CritTextData",2,Options,11,1)

---------------------

local damagetype=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_In_DamageType",optionsframe1,Localization["DamageType"],"ScrollText_Filter_In_Damage_Type",nil ,nil ,Localization)
damagetype:SetPoint("TOPRIGHT",optionsframe1,"TOPRIGHT",-6,-5)
damagetype:SetWidth(200)

local damagefilter=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_In_DamageType",optionsframe1,Localization["DamageFilter"],"ScrollText_Filter_In_Damage",nil ,nil ,Localization)
damagefilter:SetPoint("TOPRIGHT",damagetype,"BOTTOMRIGHT",0,-3)
damagefilter:SetWidth(200)

local healtype=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_In_HealType",optionsframe1,Localization["HealType"],"ScrollText_Filter_In_Heal_Type",nil ,nil ,Localization)
healtype:SetPoint("TOPRIGHT",damagefilter,"BOTTOMRIGHT",0,-25)
healtype:SetWidth(200)

local healfilter=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_In_HealType",optionsframe1,Localization["HealFilter"],"ScrollText_Filter_In_Heal",nil ,nil ,Localization)
healfilter:SetPoint("TOPRIGHT",healtype,"BOTTOMRIGHT",0,-3)
healfilter:SetWidth(200)

local misctype=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_In_MiscType",optionsframe1,Localization["MiscType"],"ScrollText_Filter_In_Misc_Type",nil ,nil ,Localization)
misctype:SetPoint("TOPRIGHT",healfilter,"BOTTOMRIGHT",0,-25)
misctype:SetWidth(200)

local miscfilter=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_In_MiscType",optionsframe1,Localization["MiscFilter"],"ScrollText_Filter_In_Misc",nil ,nil ,Localization)
miscfilter:SetPoint("TOPRIGHT",misctype,"BOTTOMRIGHT",0,-3)
miscfilter:SetWidth(200)


local listframe5=NPA_Options:CreateFrame("NPA_Options_ScrollText_Filter2",optionsframe1)
listframe5:SetPoint("BOTTOMLEFT",optionsframe1,"BOTTOMLEFT",6,6)

local checkboxdata={
	["ScrollText_Filter_StickCrit"]=Localization["StickCrit"],
	["ScrollText_Filter_ShakeCrit"]=Localization["ShakeCrit"],
	["ScrollText_HideFullOverHeal"]=Localization["HideFullOverHeal"],
	["ScrollText_HideByFrame"]=Localization["HideByFrame"],
	["ScrollText_AlphaByFrame"]=Localization["AlphaByFrame"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_ScrollText",listframe5,21,checkboxdata,16,Options,1,1)

local listframe3=NPA_Options:CreateFrame("NPA_Options_ScrollText_Filter2",optionsframe1)
listframe3:SetPoint("BOTTOMLEFT",listframe5,"BOTTOMRIGHT",6,0)

local checkboxdata={
	["ScrollText_Filter_Absorb"]=Localization["ShowAbsorb"],
	["ScrollText_Filter_ShowSpellName"]=Localization["ShowSpellName"],
	["ScrollText_Filter_ShowSpellRank"]=Localization["ShowSpellRank"],
	["ScrollText_Filter_ShowCaster"]=Localization["ShowCaster"],
	["ScrollText_Filter_ShowSelf"]=Localization["ShowSelf"],

}
NPA_Options:BuildCheckBoxList("NPA_Options_ScrollText",listframe3,21,checkboxdata,16,Options,1,1)


----------Scrolltext out


local checkbox1=NPA_Options:CreateCheckBox("NPA_Options_ScrollText_Out_Enabled",optionsframe2,21,Localization["Enabled"],"ScrollText_Out_Enabled")
checkbox1:SetPoint("TOPLEFT",20,-5)
table_insert(Options,checkbox1)


local sliderlist={
	["ScrollText_Out_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-25
	},
	["ScrollText_Out_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-25
	},
	["ScrollText_Out_SpeedX"]={
		Name=Localization["SpeedX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-65
	},
	["ScrollText_Out_SpeedY"]={
		Name=Localization["SpeedY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-65
	},
	["ScrollText_Out_SpreadX"]={
		Name=Localization["SpreadX"],
		Min=0,
		Max=300,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-105
	},
	["ScrollText_Out_SpreadY"]={
		Name=Localization["SpreadY"],
		Min=0,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-105
	},
	["ScrollText_Out_AccX"]={
		Name=Localization["AccX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-145
	},
	["ScrollText_Out_AccY"]={
		Name=Localization["AccY"],
		Min=-150,
		Max=15,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-145
	},
	["ScrollText_Out_Life"]={
		Name=Localization["Life"],
		Min=0,
		Max=5,
		Step=0.1,
		Width=140,
		OffsetX=20,
		OffsetY=-185
	},
	["ScrollText_Out_Max"]={
		Name=Localization["Max"],
		Min=1,
		Max=600,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-185
	}
}

NPA_Options:BuildSliderList("NPA_Options_ScrollText_Out",optionsframe2,sliderlist,Options)

NPA_Options:CreateSliderEditButton(Localization["Icon"],optionsframe2,"ScrollText_Out_IconData",3,Options,8)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],optionsframe2,"ScrollText_Out_OverlayData",3,Options,9)
NPA_Options:CreateSliderEditButton(Localization["Background"],optionsframe2,"ScrollText_Out_BackgroundData",3,Options,10)
NPA_Options:CreateSliderEditButton(Localization["Text"],optionsframe2,"ScrollText_Out_TextData",2,Options,11)

NPA_Options:CreateSliderEditButton(Localization["CritIcon"],optionsframe2,"ScrollText_Out_CritIconData",3,Options,8,1)
NPA_Options:CreateSliderEditButton(Localization["CritOverlay"],optionsframe2,"ScrollText_Out_CritOverlayData",3,Options,9,1)
NPA_Options:CreateSliderEditButton(Localization["CritBackground"],optionsframe2,"ScrollText_Out_CritBackgroundData",3,Options,10,1)
NPA_Options:CreateSliderEditButton(Localization["CritText"],optionsframe2,"ScrollText_Out_CritTextData",2,Options,11,1)

---------------------

local damagetype=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_Out_DamageType",optionsframe2,Localization["DamageType"],"ScrollText_Filter_Out_Damage_Type",nil ,nil ,Localization)
damagetype:SetPoint("TOPRIGHT",optionsframe2,"TOPRIGHT",-6,-5)
damagetype:SetWidth(200)

local damagefilter=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_Out_DamageType",optionsframe2,Localization["DamageFilter"],"ScrollText_Filter_Out_Damage",nil ,nil ,Localization)
damagefilter:SetPoint("TOPRIGHT",damagetype,"BOTTOMRIGHT",0,-3)
damagefilter:SetWidth(200)

local healtype=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_Out_HealType",optionsframe2,Localization["HealType"],"ScrollText_Filter_Out_Heal_Type",nil ,nil ,Localization)
healtype:SetPoint("TOPRIGHT",damagefilter,"BOTTOMRIGHT",0,-25)
healtype:SetWidth(200)

local healfilter=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_Out_HealType",optionsframe2,Localization["HealFilter"],"ScrollText_Filter_Out_Heal",nil ,nil ,Localization)
healfilter:SetPoint("TOPRIGHT",healtype,"BOTTOMRIGHT",0,-3)
healfilter:SetWidth(200)

local misctype=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_Out_MiscType",optionsframe2,Localization["MiscType"],"ScrollText_Filter_Out_Misc_Type",nil ,nil ,Localization)
misctype:SetPoint("TOPRIGHT",healfilter,"BOTTOMRIGHT",0,-25)
misctype:SetWidth(200)

local miscfilter=NPA_Options:CreateCheckListEdit2("NPA_Options_ScrollText_Out_MiscType",optionsframe2,Localization["MiscFilter"],"ScrollText_Filter_Out_Misc",nil ,nil ,Localization)
miscfilter:SetPoint("TOPRIGHT",misctype,"BOTTOMRIGHT",0,-3)
miscfilter:SetWidth(200)


local listframe5=NPA_Options:CreateFrame("NPA_Options_ScrollText_Out_Filter2",optionsframe2)
listframe5:SetPoint("BOTTOMLEFT",optionsframe2,"BOTTOMLEFT",6,6)

local checkboxdata={
	["ScrollText_Out_Filter_StickCrit"]=Localization["StickCrit"],
	["ScrollText_Out_Filter_ShakeCrit"]=Localization["ShakeCrit"],
	["ScrollText_Out_HideFullOverHeal"]=Localization["HideFullOverHeal"],
	["ScrollText_Out_HideByFrame"]=Localization["HideByFrame"],
	["ScrollText_Out_AlphaByFrame"]=Localization["AlphaByFrame"],
}


NPA_Options:BuildCheckBoxList("NPA_Options_ScrollText_Out",listframe5,21,checkboxdata,16,Options,1,1)

local listframe3=NPA_Options:CreateFrame("NPA_Options_ScrollText_Out_Filter2",optionsframe2)
listframe3:SetPoint("BOTTOMLEFT",listframe5,"BOTTOMRIGHT",6,0)

local checkboxdata={
	["ScrollText_Out_Filter_Absorb"]=Localization["ShowAbsorb"],
	["ScrollText_Out_Filter_ShowSpellName"]=Localization["ShowSpellName"],
	["ScrollText_Out_Filter_ShowSpellRank"]=Localization["ShowSpellRank"],
	["ScrollText_Out_Filter_ShowCaster"]=Localization["ShowCaster"],
	["ScrollText_Out_Filter_ShowSelf"]=Localization["ShowSelf"],
	

}
NPA_Options:BuildCheckBoxList("NPA_Options_ScrollText_Out",listframe3,21,checkboxdata,16,Options,1,1)


---------scrolltext flyingicon


local checkbox1=NPA_Options:CreateCheckBox("NPA_Options_ScrollText_FlyingIcon_Enabled",optionsframe3,21,Localization["Enabled"],"ScrollText_FlyingIcon_Enabled")
checkbox1:SetPoint("TOPLEFT",20,-5)
table_insert(Options,checkbox1)

local sliderlist={
	["ScrollText_FlyingIcon_Max"]={
		Name=Localization["Max"],
		Min=1,
		Max=50,
		Step=1,
		Width=280,
		OffsetX=20,
		OffsetY=-25
	},
}

NPA_Options:BuildSliderList("NPA_Options_ScrollText_FlyingIcon",optionsframe3,sliderlist,Options)

NPA_Options:CreateSliderEditButton(Localization["Icon"],optionsframe3,"ScrollText_FlyingIcon_IconData",3,Options,4)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],optionsframe3,"ScrollText_FlyingIcon_OverlayData",3,Options,5)
NPA_Options:CreateSliderEditButton(Localization["Background"],optionsframe3,"ScrollText_FlyingIcon_BackgroundData",3,Options,6)

local listframe=NPA_Options:CreateFrame("NPA_Options_ScrollText_FlyingIcon_Filter",optionsframe3,Localization["Show"])
listframe:SetPoint("TOPRIGHT",-6,-5)
listframe:SetWidth(200)

local checkboxdata={
	["ScrollText_FlyingIcon_InstantCast"]=Localization["InstantCast"],
	["ScrollText_FlyingIcon_Melee"]=Localization["Melee"],
	["ScrollText_FlyingIcon_Range"]=Localization["Range"],
	["ScrollText_FlyingIcon_Spell"]=Localization["Spell"],
	["ScrollText_FlyingIcon_Dot"]=Localization["Dot"],
	["ScrollText_FlyingIcon_Miss"]=Localization["Miss"],
	["ScrollText_FlyingIcon_Aura"]=Localization["Aura"],
	["ScrollText_FlyingIcon_Heal"]=Localization["Heal"],
	["ScrollText_FlyingIcon_Interrupt"]=Localization["Interrupt"],
	["ScrollText_FlyingIcon_Energized"]=Localization["Energized"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_ScrollText_FlyingIcon",listframe,21,checkboxdata,16,Options,1)

local listframe5=NPA_Options:CreateFrame("NPA_Options_ScrollText_Out_Filter2",optionsframe3)
listframe5:SetPoint("TOPLEFT",listframe,"BOTTOMLEFT",0,-3)
listframe5:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,-3)

local checkboxdata={
	["ScrollText_FlyingIcon_HideByFrame"]=Localization["HideByFrame"],
	["ScrollText_FlyingIcon_AlphaByFrame"]=Localization["AlphaByFrame"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_ScrollText_FlyingIcon",listframe5,21,checkboxdata,16,Options,1)

end