﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("RoleCheck"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="職位檢查",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",

		["HealerBar"]="治療條",
		["HealerBackground"]="治療條背景",
		["HealerOverlay"]="治療條邊框",
		["HealerText"]="治療條文本",

		["DamagerBar"]="傷害條",
		["DamagerBackground"]="傷害條背景",
		["DamagerOverlay"]="傷害條邊框",
		["DamagerText"]="傷害條文本",

		["TankBar"]="坦克條",
		["TankBackground"]="坦克條背景",
		["TankOverlay"]="坦克條邊框",
		["TankText"]="坦克條文本",

		["Healer"]="治療圖標",
		["Damager"]="傷害圖標",
		["Tank"]="坦克圖標",

		["ShowHealerIcon"]="顯示治療圖標",
		["ShowDamagerIcon"]="顯示傷害圖標",
		["ShowTankIcon"]="顯示坦克圖標",

		["ShowBar"]="顯示條",
		["ShowHealerBar"]="顯示治療條",
		["ShowDamagerBar"]="顯示傷害條",
		["ShowTankBar"]="顯示坦克條",
		["OnlyBestBar"]="只顯示最佳條",
		
		["ShowText"]="顯示文本",
		["ShowTotal"]="顯示總量",
		["ShowPerSecond"]="顯示秒平均值",
		["ShowPercent"]="顯示百分比",
		["BreakLongNumber"]="分割長數字",
		["ShortLongNumber"]="縮寫長數字",

		
		["TotalAsMax"]="以總量做最大值",
		["OnlyEffective"]="不計算過量",
		["UseBattleFieldScore"]="當可用時使用戰場統計信息",
		["ResetWhenCombat"]="進入戰鬥時重置",

		["AlwaysShowIcon"]="總是顯示全部圖標",

		["OnlyBattleground"]="只在戰場中顯示",
		["StopWhenOutCombat"]="離開戰鬥時停止統計",
		["DontFade"]="不被自動隱藏模塊隱藏",

	}
	Tooltips={
		["RoleCheck"]="顯示單位的輸出/治療/坦克統計數據,以及對應的圖標"
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="职位检查",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		
		["HealerBar"]="治疗条", 
		["HealerBackground"]="治疗条背景", 
		["HealerOverlay"]="治疗条边框", 
		["HealerText"]="治疗条文本", 

		["DamagerBar"]="伤害条", 
		["DamagerBackground"]="伤害条背景", 
		["DamagerOverlay"]="伤害条边框", 
		["DamagerText"]="伤害条文本", 

		["TankBar"]="坦克条", 
		["TankBackground"]="坦克条背景", 
		["TankOverlay"]="坦克条边框", 
		["TankText"]="坦克条文本", 

		["Healer"]="治疗图标", 
		["Damager"]="伤害图标", 
		["Tank"]="坦克图标", 

		["ShowHealerIcon"]="显示治疗图标", 
		["ShowDamagerIcon"]="显示伤害图标", 
		["ShowTankIcon"]="显示坦克图标", 

		["ShowBar"]="显示条", 
		["ShowHealerBar"]="显示治疗条", 
		["ShowDamagerBar"]="显示伤害条", 
		["ShowTankBar"]="显示坦克条", 
		["OnlyBestBar"]="只显示最佳条", 

		["ShowText"]="显示文本", 
		["ShowTotal"]="显示总量", 
		["ShowPerSecond"]="显示秒平均值", 
		["ShowPercent"]="显示百分比", 
		["BreakLongNumber"]="分割长数字",
		["ShortLongNumber"]="缩写长数字",


		["TotalAsMax"]="以总量做最大值", 
		["OnlyEffective"]="不计算过量", 
		["UseBattleFieldScore"]="当可用时使用战场统计信息",
		["ResetWhenCombat"]="进入战斗时重置",

		["AlwaysShowIcon"]="总是显示全部图标",

		["OnlyBattleground"]="只在战场中显示",
		["StopWhenOutCombat"]="离开战斗时停止统计",
		["DontFade"]="不被自动隐藏模块隐藏",
	}
	Tooltips={
		["RoleCheck"]="显示单位的输出/治疗/坦克统计数据,以及对应的图标"
	}

else
	Localization={
		["PageName"]="RoleCheck",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",

		["HealerBar"]="Healer bar",
		["HealerBackground"]="Healer bar background",
		["HealerOverlay"]="Healer bar overlay",
		["HealerText"]="Healer bar text",

		["DamagerBar"]="Damager bar",
		["DamagerBackground"]="Damager bar background",
		["DamagerOverlay"]="Damager bar overlay",
		["DamagerText"]="Damager bar text",

		["TankBar"]="Tank bar",
		["TankBackground"]="Tank bar background",
		["TankOverlay"]="Tank bar overlay",
		["TankText"]="Tank bar text",

		["Healer"]="Healer icon",
		["Damager"]="Damager icon",
		["Tank"]="Tank icon",

		["ShowHealerIcon"]="Show healer icon",
		["ShowDamagerIcon"]="Show damager icon",
		["ShowTankIcon"]="Show tank icon",

		["ShowBar"]="Show bar",
		["ShowHealerBar"]="Show healer bar",
		["ShowDamagerBar"]="Show damager bar",
		["ShowTankBar"]="Show tank bar",
		["OnlyBestBar"]="Show only best bar",
		
		["ShowText"]="Show text",
		["ShowTotal"]="Show amount",
		["ShowPerSecond"]="Show per second",
		["ShowPercent"]="Show percent",
		["BreakLongNumber"]="Break long number",
		["ShortLongNumber"]="Short long number",
		
		["TotalAsMax"]="Use total as max",
		["OnlyEffective"]="Count only effective amount",
		["UseBattleFieldScore"]="Use battlefield score when aviliable",
		["ResetWhenCombat"]="Reset when entering combat",

		["AlwaysShowIcon"]="Always show all icons",

		["OnlyBattleground"]="Show only when in battleground",
		["StopWhenOutCombat"]="Stop counting when out combat",
		["DontFade"]="Don't fade by [autohide] module",


	}
	Tooltips={
		["RoleCheck"]="Show statistic of dps/heal/tank and corresponding icons for unit"
	}

end


local mainframe=NPA_Options:AddPage("NPA_Options_RoleCheck",Localization["PageName"],"RoleCheck",Tooltips["RoleCheck"])

local Options=mainframe.Options



----------------
local sliderlist={
	["RoleCheck_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["RoleCheck_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	}
}

NPA_Options:BuildSliderList("NPA_Options_RoleCheck",mainframe,sliderlist,Options)

NPA_Options:CreateSliderEditButton(Localization["Healer"],mainframe,"RoleCheck_HealerData",3,Options,2)
NPA_Options:CreateSliderEditButton(Localization["HealerBar"],mainframe,"RoleCheck_HealerBarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["HealerOverlay"],mainframe,"RoleCheck_HealerOverlayData",1,Options,4)
NPA_Options:CreateSliderEditButton(Localization["HealerBackground"],mainframe,"RoleCheck_HealerBackgroundData",1,Options,5)
NPA_Options:CreateSliderEditButton(Localization["HealerText"],mainframe,"RoleCheck_HealerTextData",2,Options,6)

NPA_Options:CreateSliderEditButton(Localization["Damager"],mainframe,"RoleCheck_DamagerData",3,Options,7.5)
NPA_Options:CreateSliderEditButton(Localization["DamagerBar"],mainframe,"RoleCheck_DamagerBarData",1,Options,8.5)
NPA_Options:CreateSliderEditButton(Localization["DamagerOverlay"],mainframe,"RoleCheck_DamagerOverlayData",1,Options,9.5)
NPA_Options:CreateSliderEditButton(Localization["DamagerBackground"],mainframe,"RoleCheck_DamagerBackgroundData",1,Options,10.5)
NPA_Options:CreateSliderEditButton(Localization["DamagerText"],mainframe,"RoleCheck_DamagerTextData",2,Options,11.5)

NPA_Options:CreateSliderEditButton(Localization["Tank"],mainframe,"RoleCheck_TankData",3,Options,13)
NPA_Options:CreateSliderEditButton(Localization["TankBar"],mainframe,"RoleCheck_TankBarData",1,Options,14)
NPA_Options:CreateSliderEditButton(Localization["TankOverlay"],mainframe,"RoleCheck_TankOverlayData",1,Options,15)
NPA_Options:CreateSliderEditButton(Localization["TankBackground"],mainframe,"RoleCheck_TankBackgroundData",1,Options,16)
NPA_Options:CreateSliderEditButton(Localization["TankText"],mainframe,"RoleCheck_TankTextData",2,Options,17)

---------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_RoleCheck_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(200)

local checkboxdata={
	["RoleCheck_ShowHealerIcon"]=Localization["ShowHealerIcon"],
	["RoleCheck_ShowDamagerIcon"]=Localization["ShowDamagerIcon"],
	["RoleCheck_ShowTankIcon"]=Localization["ShowTankIcon"],
	["RoleCheck_AlwaysShowIcon"]=Localization["AlwaysShowIcon"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_RoleCheck",listframe,21,checkboxdata,18,Options,1)


local listframe2=NPA_Options:CreateFrame("NPA_Options_RoleCheck_Filter",mainframe)
listframe2:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,-6)
listframe2:SetWidth(200)

local checkboxdata={
	["RoleCheck_ShowBar"]=Localization["ShowBar"],
	["RoleCheck_OnlyBestBar"]=Localization["OnlyBestBar"],
	["RoleCheck_ShowHealerBar"]=Localization["ShowHealerBar"],
	["RoleCheck_ShowDamagerBar"]=Localization["ShowDamagerBar"],
	["RoleCheck_ShowTankBar"]=Localization["ShowTankBar"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_RoleCheck",listframe2,21,checkboxdata,18,Options,1)


local listframe3=NPA_Options:CreateFrame("NPA_Options_RoleCheck_Filter",mainframe)
listframe3:SetPoint("TOPRIGHT",listframe2,"BOTTOMRIGHT",0,-6)
listframe3:SetWidth(200)

local checkboxdata={
	["RoleCheck_ShowText"]=Localization["ShowText"],
	["RoleCheck_ShowTotal"]=Localization["ShowTotal"],
	["RoleCheck_ShowPerSecond"]=Localization["ShowPerSecond"],
	["RoleCheck_ShowPercent"]=Localization["ShowPercent"],
	["RoleCheck_BreakLongNumber"]=Localization["BreakLongNumber"],
	["RoleCheck_ShortLongNumber"]=Localization["ShortLongNumber"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_RoleCheck",listframe3,21,checkboxdata,18,Options,1)


local listframe4=NPA_Options:CreateFrame("NPA_Options_RoleCheck_Filter",mainframe)
listframe4:SetPoint("TOPRIGHT",listframe3,"BOTTOMRIGHT",0,-6)
listframe4:SetWidth(200)

local checkboxdata={
	["RoleCheck_TotalAsMax"]=Localization["TotalAsMax"],
	["RoleCheck_OnlyEffective"]=Localization["OnlyEffective"],
	["RoleCheck_UseBattleFieldScore"]=Localization["UseBattleFieldScore"],
	["RoleCheck_ResetWhenCombat"]=Localization["ResetWhenCombat"],
	["RoleCheck_OnlyBattleground"]=Localization["OnlyBattleground"],
	["RoleCheck_StopWhenOutCombat"]=Localization["StopWhenOutCombat"],
	["RoleCheck_DontFade"]=Localization["DontFade"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_RoleCheck",listframe4,21,checkboxdata,18,Options,1)



end