﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("RangeCheck"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="距離檢測",
		["Close"]="近距離",
		["Middle"]="中等距離",
		["Far"]="遠距離",
		["Show"]="顯示",
		["Hostile"]="敵對",
		["NonHostile"]="非敵對",
		["Target"]="目標",
		["Focus"]="焦點",
		["PetTarget"]="寵物目標",
		["GuessTeam"]="估算準確距離(只對隊友生效)",
		["HideOutRange"]="超出遠距離隱藏",
		["Text"]="文本",
	}
	Tooltips={
		["RangeCheck"]="顯示自己到單位的距離",
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="距离检测",
		["Close"]="近距离",
		["Middle"]="中等距离",
		["Far"]="远距离",
		["Show"]="显示",
		["Hostile"]="敌对",
		["NonHostile"]="非敌对",
		["Target"]="目标",
		["Focus"]="焦点",
		["PetTarget"]="宠物目标",
		["GuessTeam"]="估算准确距离(只对队友生效)",
		["HideOutRange"]="超出远距离隐藏",
		["Text"]="文本",
	}
	Tooltips={
		["RangeCheck"]="显示自己到单位的距离",
	}

else
	Localization={
		["PageName"]="RangeCheck",
		["Close"]="Close distance",
		["Middle"]="Middle distance",
		["Far"]="Far distance",
		["Show"]="Show",
		["Hostile"]="Hostile",
		["NonHostile"]="Non-hostile",
		["Target"]="Target",
		["Focus"]="Focus",
		["PetTarget"]="PetTarget",
		["GuessTeam"]="Guess exact range (only work on teammates)",
		["HideOutRange"]="Hide out of far range",
		["Text"]="Text",
	}
	Tooltips={
		["RangeCheck"]="Show the distance of unit from self",
	}

end


local mainframe=NPA_Options:AddPage("NPA_Options_RangeCheck",Localization["PageName"],"RangeCheck",Tooltips["RangeCheck"])

local Options=mainframe.Options

---buttons

local sliderlist={
	["RangeCheck_Close"]={
		Name=Localization["Close"],
		Min=1,
		Max=100,
		Step=0.01,
		Width=280,
		OffsetX=20,
		OffsetY=-5
	},
	["RangeCheck_Middle"]={
		Name=Localization["Middle"],
		Min=1,
		Max=100,
		Step=1,
		Width=280,
		OffsetX=20,
		OffsetY=-45
	},
	["RangeCheck_Far"]={
		Name=Localization["Far"],
		Min=1,
		Max=100,
		Step=1,
		Width=280,
		OffsetX=20,
		OffsetY=-85
	},
}



NPA_Options:BuildSliderList("NPA_Options_RangeCheck",mainframe,sliderlist,Options)


---------------
NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"RangeCheck_TextData",2,Options,6)


--------------------filter
local listframe=NPA_Options:CreateFrame("NPA_Options_RangeCheck_Filter",mainframe,Localization["Show"])
listframe:SetPoint("TOPRIGHT",-6,-26)
listframe:SetWidth(200)


local checkboxdata={
	["RangeCheck_Hostile"]=Localization["Hostile"],
	["RangeCheck_NonHostile"]=Localization["NonHostile"],
	["RangeCheck_Target"]=Localization["Target"],
	["RangeCheck_PetTarget"]=Localization["PetTarget"],
	["RangeCheck_Focus"]=Localization["Focus"],
	["RangeCheck_HideOutRange"]=Localization["HideOutRange"],
}


NPA_Options:BuildCheckBoxList("NPA_Options_RangeCheck",listframe,21,checkboxdata,16,Options,1)


end