﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("RaidIcon"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="團隊圖標",
		["Icon"]="圖標",
		["Background"]="背景",
		["Overlay"]="前景",
		["Text"]="單位ID文本",
		["ShowText"]="顯示單位ID文本",
		["ShowPartyID"]="顯示小隊ID",
		["ShowRaidID"]="顯示團隊ID",
		["ShowArenaID"]="顯示競技場ID",
		["ShowPrefix"]="顯示ID前綴",
		["ColorText"]="著色ID文本",
	}
	Tooltips={
		["RaidIcon"]="顯示團隊標記圖標以及單位的ID"
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="团队图标",
		["Icon"]="图标",
		["Background"]="背景",
		["Overlay"]="前景",
		["Text"]="单位ID文本",
		["ShowText"]="显示单位ID文本",
		["ShowPartyID"]="显示小队ID",
		["ShowRaidID"]="显示团队ID",
		["ShowArenaID"]="显示竞技场ID",
		["ShowPrefix"]="显示ID前缀",
		["ColorText"]="着色ID文本",
	}
	Tooltips={
		["RaidIcon"]="显示团队标记图标以及单位的ID"
	}
else
	Localization={
		["PageName"]="RaidIcon",
		["Icon"]="Icon",
		["Background"]="Background",
		["Overlay"]="Overlay",
		["Text"]="Unit ID text",
		["ShowText"]="Show unit ID text",
		["ShowPartyID"]="Show party ID",
		["ShowRaidID"]="Show raid ID",
		["ShowArenaID"]="Show arena ID",
		["ShowPrefix"]="Show ID prefix",
		["ColorText"]="Color id text",
	}
	Tooltips={
		["RaidIcon"]="Show raid icon and unit id"
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_RaidIcon",Localization["PageName"],"RaidIcon",Tooltips["RaidIcon"])

local Options=mainframe.Options
---buttons

NPA_Options:CreateSliderEditButton(Localization["Icon"],mainframe,"RaidIcon_IconData",3,Options,0.5)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"RaidIcon_BackgroundData",3,Options,1.5)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"RaidIcon_OverlayData",3,Options,2.5)


NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"RaidIcon_TextData",2,Options,4)

local listframe=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(200)

local checkboxdata={
	["RaidIcon_ShowText"]=Localization["ShowText"],
	["RaidIcon_ShowPartyID"]=Localization["ShowPartyID"],
	["RaidIcon_ShowRaidID"]=Localization["ShowRaidID"],
	["RaidIcon_ShowArenaID"]=Localization["ShowArenaID"],
	["RaidIcon_ShowPrefix"]=Localization["ShowPrefix"],
	["RaidIcon_ColorText"]=Localization["ColorText"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_HealthBar",listframe,21,checkboxdata,18,Options,1)
end