﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs
local tostring=tostring
local table_getn=table.getn
local table_sort=table.sort

if(locale=="zhTW")then
	Localization={
		["Profile"]="配置",
		["Save"]="保存",
		["Load"]="載入",
		["Delete"]="刪除",
		["Seperate"]="按角色分離保存",
		["Name"]="名稱"
	}

elseif(locale=="zhCN")then
	Localization={
		["Profile"]="配置",
		["Save"]="保存",
		["Load"]="载入",
		["Delete"]="删除",
		["Seperate"]="按角色分离保存",
		["Name"]="名称"
	}
else
	Localization={
		["Profile"]="Profile",
		["Save"]="Save",
		["Load"]="Load",
		["Delete"]="Delete",
		["Seperate"]="Seperatly save per character",
		["Name"]="Name"
	}
end


--load style
if(not NPA_Profiles["default"])then

end

local main=NPA_Options:CreateFrame("NPA_Options_Profile",NPA_Options.MainFrame,Localization["Profile"])
main:Hide()
main.Button={}
local checkbox=CreateFrame("CheckButton","NPA_Options_Profile_Seperate",main)
local editbox=NPA_Options:CreateEditBox("NPA_Options_Profile",main,150,18)
local listframe=NPA_Options:CreateFrame("NPA_Options_Profile_List",main)


local function NPA_Options_Profile_CreateButton(index)
	local button=CreateFrame("Button","NPA_Options_Profile_Button",listframe,nil)
	button:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight");

	button:SetScript("OnClick",function(self)
		local text=tostring(self.Text:GetText())
		if(text~=nil and text~="")then
			editbox:SetText(text)
		end
		
		end)

	button.Text = button:CreateFontString(nil,"ARTWORK","GameFontNormal");
	button.Text:SetPoint("CENTER",button,"CENTER",0,0)

	button:SetPoint("TOP",listframe,"TOP",0,-(index-1)*20-6)
	button:SetHeight(16)
	button:SetWidth(220)
	return button
end

function NPA_Options_Profile_BuildList()
	if(NPA_Profiles==nil)then
		return
	end
	
	local index=0
	local key=GetRealmName().."-"..GetUnitName("Player")
	local buttonlist={}
	for name,_ in pairs(NPA_Profiles) do
		table_insert(buttonlist,name)
	end
	table_sort(buttonlist)
	for i=1,table_getn(buttonlist) do
		local name=buttonlist[i]
		if(name~="Seperate" and name~=key)then
			index=index+1
			if(not main.Button[index])then
				main.Button[index]=NPA_Options_Profile_CreateButton(index)
			end
	
			main.Button[index].Text:SetText(name)
			main.Button[index]:Show()
		end
	end
	listframe:SetHeight(index*20+12)
	for i=index+1,table.getn(main.Button) do
		main.Button[i]:Hide()
	end

	if(NPA_Profiles["Seperate"]==1)then
		checkbox:SetChecked(1)
	else
		checkbox:SetChecked(nil)
	end
end



main:SetWidth(250)
main:SetHeight(80)
main:SetScript("OnShow",NPA_Options_Profile_BuildList)
main:SetPoint("TOPRIGHT",NPA_Options.MainFrame,"TOPLEFT",-10,0)

checkbox:SetWidth(18)
checkbox:SetHeight(18)
checkbox:SetPoint("TOPLEFT",main,"TOPLEFT",12,-11)
checkbox:SetScript("OnClick",function(self)
	local checked=self:GetChecked()
	if(checked)then
		NPA_Profiles["Seperate"]=1
		local key=GetRealmName().."-"..GetUnitName("Player")
		if(not NPA_Profiles[key])then
			NPA_Profiles[key]=CopyTable(NPA_Config)
			NPA_Options_Profile_BuildList()
		end
	else
		NPA_Profiles["Seperate"]=0
	end
end)

checkbox:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up")
checkbox:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down")
checkbox:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight")
checkbox:SetDisabledCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check-Disabled")
checkbox:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")

checkbox.Label=NPA_Options:CreateLabel("NPA_Options_Profile_Seperate_label",checkbox,Localization["Seperate"]);
checkbox.Label:SetPoint("LEFT",checkbox,"RIGHT")

checkbox:Show()


local label1=NPA_Options:CreateLabel("NPA_Options_Profile_Label",main,Localization["Name"])
label1:SetPoint("TOPLEFT",main,"TOPLEFT",12,-37)


editbox:SetPoint("LEFT",label1,"RIGHT",10,0)
editbox:SetScript("OnEnterPressed",function(self) self:ClearFocus() end)


listframe:SetWidth(250)
listframe:SetHeight(20)
listframe:SetPoint("TOP",main,"BOTTOM",0,0)


local button1=NPA_Options:CreateButton("NPA_Option_Profile_Save",main,80,24,Localization["Save"])
button1:SetPoint("TOPLEFT",main,"TOPLEFT",6,-50)
button1:SetScript("OnClick",function()
	local text=tostring(editbox:GetText())
	if(text~=nil and text~="")then
		if(NPA_Profiles[text]==nil)then
			NPA_Profiles[text]=CopyTable(NPA_Config)
			NPA_Options_Profile_BuildList()
		else
			NPA_Profiles[text]=CopyTable(NPA_Config)
		end
		print(Localization["Save"].." "..Localization["Profile"].." ".."["..text.."]")
			
	end
end)

local button2=NPA_Options:CreateButton("NPA_Option_Profile_Load",main,80,24,Localization["Load"])
button2:SetPoint("LEFT",button1,"RIGHT",0,0)
button2:SetScript("OnClick",function()
	local text=tostring(editbox:GetText())
	if(text~=nil and text~="" and NPA_Profiles[text])then
		NPA_Config=CopyTable(NPA_Profiles[text])
		NPA_Core:ApplyConfig()
		NPA_Core:ApplyAllModuleConfig()

		NPA_Options.MainFrame:Hide()
		NPA_Options.MainFrame:Show()

		print(Localization["Load"].." "..Localization["Profile"].." ".."["..text.."]")
	end

end)

local button3=NPA_Options:CreateButton("NPA_Option_Profile_Delete",main,80,24,Localization["Delete"])
button3:SetPoint("LEFT",button2,"RIGHT",0,0)
button3:SetScript("OnClick",function()
	local text=tostring(editbox:GetText())
	NPA_Profiles[text]=nil
	NPA_Options_Profile_BuildList()
end)

main:Show()