﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("ManaBar"))then


local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="法力條",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["PowerText"]="當前法力",
		["PowerMax"]="最大法力",
		["PowerPercent"]="法力百分比",
		["ShowBorder"]="顯示邊框",
		["Short"]="縮寫數字",
		["Break"]="長數字分段",
		["Bar"]="法力條",
		["Border"]="邊框",
		["Background"]="背景",
		["Text"]="生命文本",
	}
	Tooltips={
		["ManaBar"]="顯示單位的法力/怒氣/能量/集中值/符能"
	}

elseif(locale=="zhCN")then
	Localization={
		["PageName"]="法力条",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["PowerText"]="當前法力",
		["PowerMax"]="最大法力",
		["PowerPercent"]="法力百分比",
		["ShowBorder"]="显示边框",
		["Short"]="缩写数字",
		["Break"]="长数字分段",

		["Bar"]="法力条",
		["Border"]="边框",
		["Background"]="背景",
		["Text"]="文本",

	}
	Tooltips={
		["ManaBar"]="显示单位的法力/怒气/能量/集中值/符能"
	}

else
	Localization={
		["PageName"]="ManaBar",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["PowerText"]="Current power",
		["PowerMax"]="Max power",
		["PowerPercent"]="Power percent",
		["ShowBorder"]="Show border",
		["Short"]="Short number",
		["Break"]="Break long number",

		["Bar"]="Mana bar",
		["Border"]="Border",
		["Background"]="Background",
		["Text"]="Text",

	}
	Tooltips={
		["ManaBar"]="Show mana/rage/energy/focus/rune power of unit"
	}

end


local mainframe=NPA_Options:AddPage("NPA_Options_ManaBar",Localization["PageName"],"ManaBar",Tooltips["ManaBar"])

local Options=mainframe.Options
local sliderlist={
	["ManaBar_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["ManaBar_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	}
}

NPA_Options:BuildSliderList("NPA_Options_ManaBar",mainframe,sliderlist,Options)


NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"ManaBar_BarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["Border"],mainframe,"ManaBar_BorderData",1,Options,4)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"ManaBar_BackgroundData",1,Options,5)

NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"ManaBar_TextData",2,Options,6.5)
-------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_ManaBar_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetHeight(360)
listframe:SetWidth(200)

local checkboxdata={
	["ManaBar_PowerText"]=Localization["PowerText"],
	["ManaBar_PowerMax"]=Localization["PowerMax"],
	["ManaBar_PowerPercent"]=Localization["PowerPercent"],
	["ManaBar_Short"]=Localization["Short"],
	["ManaBar_Break"]=Localization["Break"],
	["ManaBar_ShowBorder"]=Localization["ShowBorder"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_HealthBar",listframe,21,checkboxdata,18,Options,1)

end