﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("HealthBar"))then


local Localization={}
local ColorLocalization={}
local ColorLocalization2={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="血條",
		["HealthText"]="當前生命值",
		["HealthMax"]="最大生命值",
		["HealthPercent"]="生命百分比",
		["LevelText"]="等級文本",
		["ColorByHealth"]="條按生命值著色",
		["ColorByFaction"]="背景按陣營著色",
		["BreakDown"]="分割長數字",
		["Short"]="縮寫長數字",
		["HideTotem"]="隱藏圖騰血條",
		["DefaultColor"]="使用默認顏色",
		["Elite"]="顯示精英圖標",
		["LeftElite"]="精英圖標在左側",
		["Boss"]="顯示首領圖標",
		["PercentMarker"]="顯示 '%'",
		["ColorByClass"]="條按職業著色",
		["Bar"]="血條",
		["Border"]="邊框",
		["Background"]="背景",
		["Highlight"]="高亮",
		["Text"]="生命文本",
		["Level"]="等級文本",
		["ColorTextByClass"]="文本按職業著色",
		["ColorTextByHealth"]="文本按職業著色",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["ColorByThreat"]="條按仇恨著色",
		["AlwaysHide"]="圖騰即使選中也隱藏",
		["ShowLowHealth"]="顯示低血量警告",
		["LowHealthPercent"]="低血量警告百分比",
		["LowHealth"]="低血量警告",
		["Tapped"]="屬於其它玩家時顯示灰色",
		["SeparateHighlight"]="分離高亮設置",
		["FocusHighlight"]="Focus高亮",
		["MouseoverHighlight"]="鼠標滑過高亮",
		["DontColorPlayerByThreat"]="不按仇恨上色玩家",

		["CustomBar"]="啟動自定義條",
		["CustomBarSetting"]="自定義條設置",
		["HostilePlayer"]="敵對玩家",
		["FriendlyPlayer"]="友方玩家",
		["NeutralPlayer"]="中立玩家",
		["HighThreatPlayer"]="高仇恨玩家",
		["LowThreatPlayer"]="低仇恨玩家",
		["TankingPlayer"]="在坦怪的玩家",
		["FriendlyNonPlayer"]="友方非玩家",
		["HostileNonPlayer"]="敵對非玩家",
		["NeutralNonPlayer"]="中立非玩家",
		["HighThreatNonPlayer"]="高仇恨非玩家",
		["LowThreatNonPlayer"]="低仇恨非玩家",
		["TappedMob"]="被搶先的怪物",
		["Color"]="條著色設置",
		["CustomBarOrderList"]="自定義條優先級",

		["DontColorTappedMob"]="不修改被搶先怪物的顏色",

	}
	Tooltips={
		["HealthBar"]="顯示血條和鼠標滑過高亮"
	}

	ColorLocalization={
		[0]="按照血量",
		[1]="按照陣營",
		[2]="按照職業",
		[3]="不修改",
	}
	ColorLocalization2={
		[0]="按照血量",
		[1]="按照陣營",
		[3]="不修改",
	}

elseif(locale=="zhCN")then
	Localization={
		["PageName"]="血条",
		["HealthText"]="当前生命值",
		["HealthMax"]="最大生命值",
		["HealthPercent"]="生命百分比",
		["LevelText"]="等级文本",
		["ColorByHealth"]="条按生命着色",
		["ColorByFaction"]="背景按阵营着色",
		["BreakDown"]="分割长数字",
		["Short"]="缩写长数字",
		["HideTotem"]="隐藏图腾血条",
		["DefaultColor"]="使用默认颜色",
		["Elite"]="精英图标",
		["Boss"]="首领图标",
		["PercentMarker"]="显示 '%'",
		["ColorByClass"]="条按职业着色",
		["Bar"]="血条",
		["Border"]="边框",
		["Background"]="背景",
		["Highlight"]="高亮",
		["Text"]="生命文本",
		["Level"]="等级文本",
		["ColorTextByClass"]="文本按职业着色",
		["ColorTextByHealth"]="文本按生命着色",
		["ColorByThreat"]="条按仇恨着色",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["AlwaysHide"]="图腾即使选中也隐藏",
		["ShowLowHealth"]="显示低血量警告",
		["LowHealthPercent"]="低血量警告百分比",
		["LowHealth"]="低血量警告",
		["Tapped"]="属于其它玩家时显示灰色",
		["SeparateHighlight"]="独立高亮设置",
		["FocusHighlight"]="Focus高亮",
		["MouseoverHighlight"]="鼠标滑过高亮",
		["DontColorPlayerByThreat"]="不按仇恨上色玩家",

		["CustomBar"]="启动自定义条", 
		["CustomBarSetting"]="自定义条设置", 
		["HostilePlayer"]="敌对玩家", 
		["FriendlyPlayer"]="友方玩家", 
		["NeutralPlayer"]="中立玩家", 
		["HighThreatPlayer"]="高仇恨玩家", 
		["LowThreatPlayer"]="低仇恨玩家", 
		["TankingPlayer"]="在坦怪的玩家", 
		["FriendlyNonPlayer"]="友方非玩家", 
		["HostileNonPlayer"]="敌对非玩家", 
		["NeutralNonPlayer"]="中立非玩家", 
		["HighThreatNonPlayer"]="高仇恨非玩家", 
		["LowThreatNonPlayer"]="低仇恨非玩家", 
		["TappedMob"]="被抢先的怪物", 
		["Color"]="条着色设置", 
		["CustomBarOrderList"]="自定义条优先级",

		["DontColorTappedMob"]="不修改被抢先怪物的颜色",


	}
	Tooltips={
		["HealthBar"]="显示血条和鼠标滑过高亮"
	}
	ColorLocalization={
		[0]="按照血量",
		[1]="按照阵营",
		[2]="按照职业",
		[3]="不修改",
	}
	ColorLocalization2={
		[0]="按照血量",
		[1]="按照阵营",
		[3]="不修改",
	}
else
	Localization={
		["PageName"]="HealthBar",
		["HealthText"]="Current health",
		["HealthMax"]="Max health",
		["HealthPercent"]="Health percent",
		["LevelText"]="Level Text",
		["ColorByHealth"]="Color bar by health",
		["ColorByFaction"]="Color background by faction",
		["BreakDown"]="Break down long number",
		["Short"]="Shorten long number",
		["HideTotem"]="Hide totem's healthbar",
		["DefaultColor"]="Use default color",
		["Elite"]="Elite icon",
		["Boss"]="Boss icon",
		["PercentMarker"]="Show '%'",
		["ColorByClass"]="Color bar by class",
		["Bar"]="Health bar",
		["Border"]="Border",
		["Background"]="Background",
		["Highlight"]="Highlight",
		["Text"]="Health text",
		["Level"]="Level text",
		["ColorTextByClass"]="Color text by class",
		["ColorTextByHealth"]="Color text by Health",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["ColorByThreat"]="Color bar by threat",
		["AlwaysHide"]="Hide totem even selected",
		["ShowLowHealth"]="Show low health warning",
		["LowHealthPercent"]="Low health warning percent",
		["LowHealth"]="Low health warning",
		["Tapped"]="Color grey when tapped by other player",
		["SeparateHighlight"]="Separate highlight settings",
		["FocusHighlight"]="Focus highlight",
		["MouseoverHighlight"]="Mouseover highlight",
		["DontColorPlayerByThreat"]="Don't color player by threat",

		["CustomBar"]="Enable custom bar", 
		["CustomBarSetting"]="Custom bar setting", 
		["HostilePlayer"]="Hostile player", 
		["FriendlyPlayer"]="Friendly player", 
		["NeutralPlayer"]="Neutral player", 
		["HighThreatPlayer"]="High threat player", 
		["LowThreatPlayer"]="Low threat player", 
		["TankingPlayer"]="Tanking player", 
		["FriendlyNonPlayer"]="Friendly non-player", 
		["HostileNonPlayer"]="Hostile non-player", 
		["NeutralNonPlayer"]="Neutral non-player", 
		["HighThreatNonPlayer"]="High threat non-player", 
		["LowThreatNonPlayer"]="Low threat non-player", 
		["TappedMob"]="Tapped mob", 
		["Color"]="Bar coloring setting", 
		["CustomBarOrderList"]="Custom bar priority",

		["DontColorTappedMob"]="Don't color tapped mob",


	}
	Tooltips={
		["HealthBar"]="Shows healthbar and mouseover highlight"
	}

	ColorLocalization={
		[0]="With health percent",
		[1]="With faction",
		[2]="With class",
		[3]="Dont' change",
	}
	ColorLocalization2={
		[0]="With health percent",
		[1]="With faction",
		[3]="Dont' change",
	}

end


local mainframe=NPA_Options:AddPage("NPA_Options_HealthBar",Localization["PageName"],"HealthBar",Tooltips["HealthBar"])

local Options=mainframe.Options

local sliderlist={
	["HealthBar_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["HealthBar_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	},
	["HealthBar_LowHealthPercent"]={
		Name=Localization["LowHealthPercent"],
		Min=0,
		Max=100,
		Step=1,
		Width=280,
		OffsetX=20,
		OffsetY=-330
	},

}

NPA_Options:BuildSliderList("NPA_Options_HealthBar",mainframe,sliderlist,Options)

NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"HealthBar_BarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["Border"],mainframe,"HealthBar_BorderData",1,Options,3,0.8)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"HealthBar_BackgroundData",1,Options,3,1.6)

NPA_Options:CreateSliderEditButton(Localization["Highlight"],mainframe,"HealthBar_HighlightData",1,Options,4.5)
NPA_Options:CreateSliderEditButton(Localization["Elite"],mainframe,"HealthBar_EliteData",3,Options,5.5)
NPA_Options:CreateSliderEditButton(Localization["Boss"],mainframe,"HealthBar_BossData",3,Options,6.5)

NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"HealthBar_TextData",2,Options,8)
NPA_Options:CreateSliderEditButton(Localization["Level"],mainframe,"HealthBar_LevelTextData",2,Options,8,1)

NPA_Options:CreateSliderEditButton(Localization["LowHealth"],mainframe,"HealthBar_LowHealthData",1,Options,9.5)

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_HealthBar_SeparateHighlight",mainframe,21,Localization["SeparateHighlight"],"HealthBar_SeparateHighlight")
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",200,-140)
table_insert(Options,checkbox)

local function CheckSeparateFilter(self)
	buttonh1:Show()
	buttonh2:Show()

	if(self:GetChecked())then
		buttonh1:Show()
		buttonh2:Show()
	else
		buttonh1:Hide()
		buttonh2:Hide()
	end
end

checkbox:HookScript("OnShow",CheckSeparateFilter)
checkbox:HookScript("OnClick",CheckSeparateFilter)


buttonh1=NPA_Options:CreateSliderEditButton(Localization["FocusHighlight"],mainframe,"HealthBar_FocusHighlightData",1,Options,5.5,1)
buttonh2=NPA_Options:CreateSliderEditButton(Localization["MouseoverHighlight"],mainframe,"HealthBar_MouseoverHighlightData",1,Options,6.5,1)

----------------------------



local checkbox2=NPA_Options:CreateCheckBox("NPA_Options_HealthBar_EnableCustomBar",mainframe,21,Localization["CustomBar"],"HealthBar_EnableCustomBar")
checkbox2:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-420)
table_insert(Options,checkbox2)

-------------------------------------------------------

local barframe=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",checkbox2,Localization["CustomBarSetting"])

local button=NPA_Options:CreateButton("NPA_Options_HealthBar_CustomBarSetting",mainframe,0,21,Localization["CustomBarSetting"])
button:SetPoint("TOPLEFT",checkbox2,"BOTTOMLEFT",0,-6)
button:SetScript("OnClick",function()
		if(barframe:IsShown())then
			barframe:Hide()
		else
			barframe:Show()
		end
	end)

barframe:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",0,10)
barframe:SetWidth(350)
barframe:SetHeight(620)
barframe:SetFrameStrata("HIGH")
barframe:Hide()

---------------------------------------------------------------
local buttonframe1=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",barframe)
buttonframe1:SetPoint("TOPRIGHT",barframe,"TOPRIGHT",-3,-3)
buttonframe1:SetPoint("TOPLEFT",barframe,"TOPLEFT",3,-3)
buttonframe1:SetHeight(190)

NPA_Options:CreateSliderEditButton(Localization["HostilePlayer"],buttonframe1,"HealthBar_HostilePlayer_BarData",1,Options,0)
NPA_Options:CreateSliderEditButton(Localization["FriendlyPlayer"],buttonframe1,"HealthBar_FriendlyPlayer_BarData",1,Options,1)
NPA_Options:CreateSliderEditButton(Localization["NeutralPlayer"],buttonframe1,"HealthBar_NeutralPlayer_BarData",1,Options,2)
NPA_Options:CreateSliderEditButton(Localization["HighThreatPlayer"],buttonframe1,"HealthBar_HighThreatPlayer_BarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["LowThreatPlayer"],buttonframe1,"HealthBar_LowThreatPlayer_BarData",1,Options,4)
NPA_Options:CreateSliderEditButton(Localization["TankingPlayer"],buttonframe1,"HealthBar_TankingPlayer_BarData",1,Options,5)

NPA_Options:CreateSliderEditButton(Localization["FriendlyNonPlayer"],buttonframe1,"HealthBar_FriendlyNonPlayer_BarData",1,Options,0,1)
NPA_Options:CreateSliderEditButton(Localization["HostileNonPlayer"],buttonframe1,"HealthBar_HostileNonPlayer_BarData",1,Options,1,1)
NPA_Options:CreateSliderEditButton(Localization["NeutralNonPlayer"],buttonframe1,"HealthBar_NeutralNonPlayer_BarData",1,Options,2,1)
NPA_Options:CreateSliderEditButton(Localization["HighThreatNonPlayer"],buttonframe1,"HealthBar_HighThreatNonPlayer_BarData",1,Options,3,1)
NPA_Options:CreateSliderEditButton(Localization["LowThreatNonPlayer"],buttonframe1,"HealthBar_LowThreatNonPlayer_BarData",1,Options,4,1)
NPA_Options:CreateSliderEditButton(Localization["TappedMob"],buttonframe1,"HealthBar_TappedMob_BarData",1,Options,5,1)
------------------------------

local orderbutton=NPA_Options:CreateOrderEdit("NPA_Options_HealthBar_CustomBar_Order",barframe,Localization["CustomBarOrderList"],"HealthBar_CustomBarData",Localization)
orderbutton:SetPoint("TOPLEFT",buttonframe1,"BOTTOMLEFT",0,-25)
orderbutton:SetPoint("BOTTOMRIGHT",barframe,"BOTTOMRIGHT",-3,5)
table_insert(Options,orderbutton)

--------------------------------------
------------------------------------
local colorframe=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",mainframe,Localization["Color"])

local button2=NPA_Options:CreateButton("NPA_Options_HealthBar_CustomBarSetting",mainframe,0,21,Localization["Color"])
button2:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-390)
button2:SetScript("OnClick",function()
		if(colorframe:IsShown())then
			colorframe:Hide()
		else
			colorframe:Show()
		end
	end)

colorframe:SetPoint("LEFT",button2,"RIGHT",0,10)
colorframe:SetWidth(280)
colorframe:SetFrameStrata("HIGH")
colorframe:SetHeight(190)
colorframe:Hide()

local dropselect1=NPA_Options:CreateDropDownSelect("NPA_Options_HealthBar_ColorHostilePlayerBar",colorframe,220,24,Localization["HostilePlayer"],"HealthBar_ColorHostilePlayerBarData",ColorLocalization)
dropselect1:SetPoint("TOPLEFT",colorframe,"TOPLEFT",20,-10)
table_insert(Options,dropselect1)

local dropselect2=NPA_Options:CreateDropDownSelect("NPA_Options_HealthBar_ColorNeutralPlayerBar",colorframe,220,24,Localization["NeutralPlayer"],"HealthBar_ColorNeutralPlayerBarData",ColorLocalization)
dropselect2:SetPoint("TOPLEFT",dropselect1,"BOTTOMLEFT",0,-5)
table_insert(Options,dropselect2)

local dropselect3=NPA_Options:CreateDropDownSelect("NPA_Options_HealthBar_ColorFriendlyPlayerBar",colorframe,220,24,Localization["FriendlyPlayer"],"HealthBar_ColorFriendlyPlayerBarData",ColorLocalization)
dropselect3:SetPoint("TOPLEFT",dropselect2,"BOTTOMLEFT",0,-5)
table_insert(Options,dropselect3)

local dropselect4=NPA_Options:CreateDropDownSelect("NPA_Options_HealthBar_ColorHostileNonPlayerBar",colorframe,220,24,Localization["HostileNonPlayer"],"HealthBar_ColorHostileNonPlayerBarData",ColorLocalization2)
dropselect4:SetPoint("TOPLEFT",dropselect3,"BOTTOMLEFT",0,-5)
table_insert(Options,dropselect4)

local dropselect5=NPA_Options:CreateDropDownSelect("NPA_Options_HealthBar_ColorNeutralNonPlayerBar",colorframe,220,24,Localization["NeutralNonPlayer"],"HealthBar_ColorNeutralNonPlayerBarData",ColorLocalization2)
dropselect5:SetPoint("TOPLEFT",dropselect4,"BOTTOMLEFT",0,-5)
table_insert(Options,dropselect5)

local dropselect6=NPA_Options:CreateDropDownSelect("NPA_Options_HealthBar_ColorFriendlyNonPlayerBar",colorframe,220,24,Localization["FriendlyNonPlayer"],"HealthBar_ColorFriendlyNonPlayerBarData",ColorLocalization2)
dropselect6:SetPoint("TOPLEFT",dropselect5,"BOTTOMLEFT",0,-5)
table_insert(Options,dropselect6)
------------------------------------------------------------------
mainframe:HookScript("OnShow",function()
		barframe:Show()
		barframe:Hide()
		colorframe:Show()
		colorframe:Hide()
	end)
-------------------------------------------------------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(200)

local checkboxdata={
	["HealthBar_HealthText"]=Localization["HealthText"],
	["HealthBar_LevelText"]=Localization["LevelText"],
	["HealthBar_PercentMarker"]=Localization["PercentMarker"],
	["HealthBar_Elite"]=Localization["Elite"],
	["HealthBar_BossIcon"]=Localization["Boss"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_HealthBar",listframe,21,checkboxdata,18,Options,1)


local listframe3=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",mainframe)
listframe3:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,-6)
listframe3:SetWidth(200)

local checkboxdata={
	["HealthBar_HealthMax"]=Localization["HealthMax"],
	["HealthBar_HealthPercent"]=Localization["HealthPercent"],
	["HealthBar_BreakDown"]=Localization["BreakDown"],
	["HealthBar_Short"]=Localization["Short"],
	["HealthBar_ColorTextByClass"]=Localization["ColorTextByClass"],
	["HealthBar_ColorTextByHealth"]=Localization["ColorTextByHealth"],
	["HealthBar_ColorByFaction"]=Localization["ColorByFaction"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_HealthBar",listframe3,21,checkboxdata,18,Options,1)

local listframe4=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",mainframe)
listframe4:SetPoint("TOPRIGHT",listframe3,"BOTTOMRIGHT",0,-6)
listframe4:SetWidth(200)

local checkboxdata={
	["HealthBar_HideTotem"]=Localization["HideTotem"],
	["HealthBar_AlwaysHide"]=Localization["AlwaysHide"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_HealthBar",listframe4,21,checkboxdata,18,Options,1)



local listframe5=NPA_Options:CreateFrame("NPA_Options_HealthBar_Filter",mainframe)
listframe5:SetPoint("TOPRIGHT",listframe4,"BOTTOMRIGHT",0,-6)
listframe5:SetWidth(200)

local checkboxdata={
	["HealthBar_ShowLowHealth"]=Localization["ShowLowHealth"],
	["HealthBar_DontColorTappedMob"]=Localization["DontColorTappedMob"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_HealthBar",listframe5,21,checkboxdata,18,Options,1)


end