﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("CrowdControl"))then

local table_insert = table.insert
local pairs = pairs

local Localization={}
local Tooltips={}
local locale=GetLocale()
if(locale=="zhTW")then
	Localization={
		["PageName"]="控場提示",
		["CrowdControl_OffsetX"]="X偏移",
		["CrowdControl_OffsetY"]="Y偏移",
		["CrowdControl_Max"]="最大數量",
		["CrowdControl_CCList"]="控場列表",
		["CrowdControl_SpellId"]="法術ID",
		["CrowdControl_Level"]="優先級",
		["GapHeight"]="間隙高度",
		["GapWidth"]="間隙寬度",
		["MaxPerRow"]="每行數量",
		["GrowUpward"]="向上增長",
		["GrowRightward"]="向右增長",
		["Time"]="時間",
		["Stack"]="層數",
		["Icon"]="圖標",
		["Background"]="背景",
		["Overlay"]="前景",
		["Decile"]="最後一秒顯示十分位",
		["ShowCC"]="顯示控場",
		["ShowDR"]="顯示控場遞減",
		["DRList"]="遞減列表",
		["DRType"]="遞減類型",
		["Bar"]="計時器條",
		["ShowBar"]="顯示計時器條",
		["ColorTextByTime"]="按時間著色文本",
		["ColorBarByTime"]="按時間著色計時器條",
		["AlterDecile"]="修改小數顯示",
		["ColorBackground"]="上色背景材質",
		["ColorBar"]="上色計時器條",
		["ColorMagic"]="上色魔法",
		["ColorPosion"]="上色毒",
		["ColorDisease"]="上色疾病",
		["ColorCurse"]="上色詛咒",
		["ColorPhysic"]="上色物理",
		["ColorEnrage"]="上色激怒",
		["DRHideList"]="隱藏遞減",
	}
	Tooltips={
		["CrowdControl"]="顯示控場技能,特殊技能,以及控制遞減,的圖標,計時器,和計時條"
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="控场提示",
		["CrowdControl_OffsetX"]="X偏移",
		["CrowdControl_OffsetY"]="Y偏移",
		["CrowdControl_Max"]="最大数量",
		["CrowdControl_CCList"]="控场列表",
		["CrowdControl_SpellId"]="法术ID",
		["CrowdControl_Level"]="优先级",
		["GapHeight"]="间隙高度",
		["GapWidth"]="间隙宽度",
		["MaxPerRow"]="每行数量",
		["GrowUpward"]="向上增长",
		["GrowRightward"]="向右增长",
		["Time"]="时间",
		["Stack"]="层数",
		["Icon"]="图标",
		["Background"]="背景",
		["Overlay"]="前景",
		["Decile"]="最后一秒显示十分位",
		["ShowCC"]="显示控场",
		["ShowDR"]="显示控场递减",
		["DRList"]="递减列表",
		["DRType"]="递减类型",
		["Bar"]="计时器条",
		["ShowBar"]="显示计时器条",
		["ColorTextByTime"]="按时间着色文本",
		["ColorBarByTime"]="按时间着色计时器条",
		["AlterDecile"]="修改小数显示",
		["ColorBackground"]="上色背景材质",
		["ColorBar"]="上色计时器条",
		["ColorMagic"]="上色魔法",
		["ColorPosion"]="上色毒",
		["ColorDisease"]="上色疾病",
		["ColorCurse"]="上色诅咒",
		["ColorPhysic"]="上色物理",
		["ColorEnrage"]="上色激怒",
		["DRHideList"]="隐藏递减",
	}
	Tooltips={
		["CrowdControl"]="显示控场技能,特殊技能,以及控制递减,的图标,计时器和计时条"
	}
else
	Localization={
		["PageName"]="CrowdControls",
		["Apply"]="Apply",
		["Reset"]="Reset",
		["Cancel"]="Cancel",
		["CrowdControl_OffsetX"]="Offset X",
		["CrowdControl_OffsetY"]="Offset Y",
		["CrowdControl_Max"]="Max icons",
		["CrowdControl_CCList"]="CC list",
		["CrowdControl_SpellId"]="Spellid",
		["CrowdControl_Level"]="Display level",
		["GapHeight"]="Gap height",
		["GapWidth"]="Gap width",
		["MaxPerRow"]="Icon per row",
		["GrowUpward"]="Grow upward",
		["GrowRightward"]="Grow rightward",
		["Time"]="Time",
		["Stack"]="Stack",
		["Icon"]="Icon",
		["Background"]="Background",
		["Overlay"]="Overlay",
		["Decile"]="Decile on last second",
		["ShowCC"]="Show crowdcontrol",
		["ShowDR"]="Show diminishing return",
		["DRList"]="DR list",
		["DRType"]="DR type",
		["Bar"]="Timer bar",
		["ShowBar"]="Show timer bar",
		["ColorTextByTime"]="Color text by time",
		["ColorBarByTime"]="Color timer bar by time",
		["AlterDecile"]="Alter decile display",
		["ColorBackground"]="Color background texture",
		["ColorBar"]="Color timer bar",
		["ColorMagic"]="Color magic",
		["ColorPosion"]="Color posion",
		["ColorDisease"]="Color disease",
		["ColorCurse"]="Color curse",
		["ColorPhysic"]="Color physic",
		["ColorEnrage"]="Color enrage",
		["DRHideList"]="Hide DR",

	}
	Tooltips={
		["CrowdControl"]="Shows icon,timer and timer bar for crowdcontrol spell, speical spell and crowdcontrol diminishing return"
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_CrowdControl",Localization["PageName"],"CrowdControl",Tooltips["CrowdControl"])

local Options=mainframe.Options

local sliderlist={
	["CrowdControl_OffsetX"]={
		Name=Localization["CrowdControl_OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["CrowdControl_OffsetY"]={
		Name=Localization["CrowdControl_OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	},

	["CrowdControl_Max"]={
		Name=Localization["CrowdControl_Max"],
		Min=1,
		Max=30,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-45
	},

	["CrowdControl_MaxPerRow"]={
		Name=Localization["MaxPerRow"],
		Min=1,
		Max=6,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-45
	},
	["CrowdControl_GapHeight"]={
		Name=Localization["GapHeight"],
		Min=1,
		Max=100,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-85
	},
	["CrowdControl_GapWidth"]={
		Name=Localization["GapWidth"],
		Min=1,
		Max=100,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-85
	},


}

NPA_Options:BuildSliderList("NPA_Options_CrowdControl",mainframe,sliderlist,Options)



NPA_Options:CreateSliderEditButton(Localization["Icon"],mainframe,"CrowdControl_IconData",3,Options,4.5)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"CrowdControl_BackgroundData",3,Options,5.5)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"CrowdControl_OverlayData",3,Options,6.5)
NPA_Options:CreateSliderEditButton(Localization["Time"],mainframe,"CrowdControl_TimeData",2,Options,7.5)
NPA_Options:CreateSliderEditButton(Localization["Stack"],mainframe,"CrowdControl_StackData",2,Options,8.5)
NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"CrowdControl_BarData",1,Options,9.5)


-----------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_CrowdControl_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(180)


local checkboxdata={
	["CrowdControl_Outline"]=Localization["CrowdControl_Outline"],
	["CrowdControl_AltDisplay"]=Localization["CrowdControl_AltDisplay"],
	["CrowdControl_GrowUpward"]=Localization["GrowUpward"],
	["CrowdControl_GrowRightward"]=Localization["GrowRightward"],
	["CrowdControl_Decile"]=Localization["Decile"],
	["CrowdControl_ShowBar"]=Localization["ShowBar"],
	["CrowdControl_ColorTextByTime"]=Localization["ColorTextByTime"],
	["CrowdControl_ColorBarByTime"]=Localization["ColorBarByTime"],
	["CrowdControl_AlterDecile"]=Localization["AlterDecile"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_CrowdControl",listframe,20,checkboxdata,17,Options,1)


local listframe2=NPA_Options:CreateFrame("NPA_Options_CrowdControl_Filter",mainframe)
listframe2:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,-6)
listframe2:SetWidth(180)
local checkboxdata={
	["CrowdControl_ShowCC"]=Localization["ShowCC"],
	["CrowdControl_ShowDR"]=Localization["ShowDR"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_CrowdControl",listframe2,20,checkboxdata,17,Options,1)


local listframe3=NPA_Options:CreateFrame("NPA_Options_CrowdControl_Filter",mainframe)
listframe3:SetPoint("TOPRIGHT",listframe2,"BOTTOMRIGHT",0,-6)
listframe3:SetWidth(180)
local checkboxdata={
	["CrowdControl_ColorBackground"]=Localization["ColorBackground"],
	["CrowdControl_ColorBar"]=Localization["ColorBar"],
	["CrowdControl_ColorMagic"]=Localization["ColorMagic"],
	["CrowdControl_ColorPoison"]=Localization["ColorPoison"],
	["CrowdControl_ColorDisease"]=Localization["ColorDisease"],
	["CrowdControl_ColorCurse"]=Localization["ColorCurse"],
	["CrowdControl_ColorPhysic"]=Localization["ColorPhysic"],
	["CrowdControl_ColorEnrage"]=Localization["ColorEnrage"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_CrowdControl",listframe3,20,checkboxdata,17,Options,1)


-----------------------------
local cclist=NPA_Options:CreateEditList("NPA_Options_CrowdControl_CCList",mainframe,Localization["CrowdControl_CCList"],Localization["CrowdControl_SpellId"],Localization["CrowdControl_Level"],"CrowdControl_Data")
cclist:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",-6,3)

local drlist=NPA_Options:CreateEditList("NPA_Options_CrowdControl_DRList",mainframe,Localization["DRList"],Localization["CrowdControl_SpellId"],Localization["DRType"],"CrowdControl_DRData")
drlist:SetPoint("BOTTOMRIGHT",cclist,"TOPRIGHT",0,3)
--------------------------------


local hidelist=NPA_Options:CreateCheckListEdit("NPA_Options_CrowdControl_DRHideList",mainframe,Localization["DRHideList"],"CrowdControl_DRHideList")
hidelist:SetPoint("BOTTOMRIGHT",cclist,"BOTTOMLEFT",0,6)
hidelist:SetWidth(240)

hidelist:HookScript("OnShow",function()
	local list={}
	for _,type in pairs(NPA_Config["CrowdControl"]["CrowdControl_DRData"]) do
		if(NPA_Config["CrowdControl"]["CrowdControl_DRHideList"][type]==1)then
			list[type]=1
		else
			list[type]=0
		end
	end

	NPA_Config["CrowdControl"]["CrowdControl_DRHideList"]=CopyTable(list)

	end)


end