﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("CounterSpell"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="法術反制",
		["CounterSpell_List"]="法術列表",
		["CounterSpell_SpellId"]="法術ID",
		["CounterSpell_LockTime"]="反制時間",
		["TextFont"]="文本字體",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Bar"]="條",
		["Background"]="條背景",
		["Overlay"]="條前景",
		["Text"]="文本",
	}
	Tooltips={
		["CounterSpell"]="顯示單位被反制的持續時間倒計時和計時條",
	}
		

elseif(locale=="zhCN")then
	Localization={
		["PageName"]="法术反制",
		["CounterSpell_List"]="法术列表",
		["CounterSpell_SpellId"]="法术ID",
		["CounterSpell_LockTime"]="反制时间",
		["TextFont"]="文本字体",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Bar"]="条",
		["Background"]="条背景",
		["Overlay"]="条前景",
		["Text"]="文本",
	}
	Tooltips={
		["CounterSpell"]="显示单位被反制的持续时间倒计时和计时条",
	}

else
	Localization={
		["PageName"]="CounterSpell",
		["CounterSpell_List"]="Spell list",
		["CounterSpell_SpellId"]="Spellid",
		["CounterSpell_LockTime"]="Spelllock time",
		["TextFont"]="Text font",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["Bar"]="Bar",
		["Background"]="Bar background",
		["Overlay"]="Bar overlay",
		["Text"]="Text",
	}
	Tooltips={
		["CounterSpell"]="Shows remaining time and timer bar of spelllock of unit",
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_CounterSpell",Localization["PageName"],"CounterSpell",Tooltips["CounterSpell"])

local Options=mainframe.Options

----------------
local sliderlist={
	["CounterSpell_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["CounterSpell_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	}
}

NPA_Options:BuildSliderList("NPA_Options_CounterSpell",mainframe,sliderlist,Options)


NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"CounterSpell_BarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"CounterSpell_BarOverlayData",1,Options,4)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"CounterSpell_BarBackgroundData",1,Options,5)

NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"CounterSpell_TextData",2,Options,6.5)



-----------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_CounterSpell_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetHeight(400)
listframe:SetWidth(200)

local cclist=NPA_Options:CreateEditList("NPA_Options_CounterSpell_List",listframe,Localization["CounterSpell_List"],Localization["CounterSpell_SpellId"],Localization["CounterSpell_LockTime"],"CounterSpell_Data")
cclist:SetPoint("TOP",listframe,"TOP",0,-6)

end