﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11
--global functions
local table_insert = table.insert
local pairs = pairs

local Localization={}
local locale=GetLocale()
local Tooltips={}
if(locale=="zhTW")then
	Localization={
		["PageName"]="核心",
		["UnitData_UpdateInterval"]="單位數據採集間隔(秒)",
		["Frame_UpdateInterval"]="框架更新間隔(秒)",
		["GlobalSize"]="全局縮放",

		["Aura"]="增減益",
		["AutoHide"]="自動隱藏",
		["CastWarning"]="施法警告",
		["ClassIcon"]="職業圖標",
		["ComboPoint"]="連擊點數",
		["CoolDown"]="技能冷卻",
		["CrowdControl"]="控場提示",
		["HealthBar"]="生命條",
		["ManaBar"]="法力條",
		["QuestMark"]="任務指示",
		["RaidIcon"]="團隊標記",
		["ScrollText"]="戰鬥文字",
		["Speed"]="移動速度",
		["Target"]="目標",
		["Threat"]="仇恨",
		["Tracker"]="追踪",
		["ClassInfo"]="職業信息",
		["NameText"]="名稱文本",
		["exCombat"]="脫離戰鬥",
		["RangeCheck"]="距離檢測",
		["CounterSpell"]="法術反制",
		["RoleCheck"]="職位檢查",
		["TargetCount"]="目標計數",
		["ShieldWatch"]="護盾監視",

		["HostilePlayer"]="敵對玩家",
		["HostileNonPlayer"]="敵對非玩家",
		["NonHostilePlayer"]="非敵對玩家",
		["NonHostileNonPlayer"]="非敵對非玩家",

		["EnableModule"]="全局模塊(需要重載UI)",
		["ModuleList"]="模塊列表",
		["SeparateModuleList"]="分離模塊設置",

		["PowerMatch"]="猜測單位GUID(只針對NPC,高資源佔用)",
		["CleanUp"]="釋放內存間隔(秒)(0表示不釋放)",
		["CleanUpTimer"]="釋放此時間內沒有更新過的數據(秒)",
		["Enabled"]="啟用數據收集",
		["idtip"]="在鼠標提示中顯示法術id",
		["Modules"]="模塊",
		["OnlySelected"]="未選中的目標不顯示複雜模塊(提升性能)" ,
		["SychonizeAnimation"]="同步所有動畫",
		["OffsetX"]="全局X偏移",
		["OffsetY"]="全局Y偏移",
		["SaveData"]="保存單位數據(需要重載UI生效)",
		["CollectHostile"]="收集敵對目標數據",
		["CollectNonHostile"]="收集非敵對目標數據",
		["CollectUnitFromCombatLog"]="從戰鬥記錄中收集單位信息",
		["CollectAuraFromCombatLog"]="從戰鬥記錄中收集增減益信息",
		["ClearDataWhenEnteringArena"]="進入競技場時清除數據",
		["NotClassColor"]="不修改系統選項(選中這個選項會降低GUID命中率)",
		["ClearAllDataRightNow"]="立即清除所有現存數據",

		["AlterInstant"]="將瞬發法術作為1秒施法",


		["LayerOrder"]="調整圖層順序",
		["Mouseover"]="鼠標滑過",
		["Focus"]="Focus",
		["CollectList"]="收集單位信息"
	}
	LocalizationCollect={
		["Aura"]="增減益",
		["Casting"]="施法",
		["Target"]="目標",
		["Speed​​"]="速度",
		["Position"]="位置",
		["Range"]="距離",
		["Portrait"]="頭像",
		["Threat"]="仇恨",
		["Tapped"]="怪物被搶先",
		["TargetCount"]="目標計數",
		["GuessHealth"]="猜測生命值",
		["NameGuild"]="姓名和工會",
		["Class"]="職業",
		["Resource"]="資源",
		["Combat"]="戰鬥",
		["Raid"]="團隊",
		["PvP"]="PvP狀態",
		["Level"]="等級",
	}
	Tooltips={ 
		["Core"]="控制所有模塊的開關,更新間隔,和整體偏移定位",
		["UnitData_UpdateInterval"]="兩次數據收集之間的時間間隔", 
		["Frame_UpdateInterval"]="兩次框體更新之間的時間間隔", 
		["GlobalSize"]="全局縮放,1表示100%", 
		["PowerMatch"]="使用收集到的名稱和血量數據來對照pve中的怪物,開啟時可以在大部分時間都不需要鼠標滑過,但是可能會不精確(當兩個怪物擁有完全相同的血量和名稱時--這種情況很少),並且佔用一些CPU資源", 
		["CleanUp"]="兩次釋放之間的時間間隔,釋放會清除指定時間內沒有更新的單位數據", 
		["CleanUpTimer"]="釋放所使用的最小時間限制", 
		["Enabled"]="一些模塊需要數據收集才能工作,比如[增減益][速度][法力條][施法警告]等等,關閉數據收集會停止這些模塊,但是其它模塊仍然會正常工作", 
		["idtip"]="附加到默認工具提示功能,顯示所有法術的法術id", 
		["Modules"]="模塊開關", 
		["OnlySelected"]="自動關閉未選中目標的大部分模塊(像[增減益]和[冷卻])來節約CPU資源", 
		["SychonizeAnimation"]="使所有的動畫從同樣的起點開始播放,速度和幀數量不會受到影響", 
		["Offset"]="全局偏移",

		["EnableModule"]="在這里關閉的模塊將不會被載入內存",
		["CollectList"]="在這裡禁用的數據類型不會被收集,相應的模塊也會停止工作",
		["LayerOrder"]="修改姓名板圖層的顯示順序"
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="核心",
		["UnitData_UpdateInterval"]="单位数据采集间隔(秒)",
		["Frame_UpdateInterval"]="框架更新间隔(秒)",
		["GlobalSize"]="全局缩放",

		["Aura"]="增减益",
		["AutoHide"]="自动隐藏",
		["CastWarning"]="施法警告",
		["ClassIcon"]="职业图标",
		["ComboPoint"]="连击点数",
		["CoolDown"]="技能冷却",
		["CrowdControl"]="控场提示",
		["HealthBar"]="生命条",
		["ManaBar"]="法力条",
		["QuestMark"]="任务指示",
		["RaidIcon"]="团队标记",
		["ScrollText"]="战斗文字",
		["Speed"]="移动速度",
		["Target"]="目标",
		["Threat"]="仇恨",
		["RangeCheck"]="距离检测",
		["Tracker"]="追踪",
		["CounterSpell"]="法术反制",
		["NameText"]="名称文本",
		["TargetCount"]="目标计数",
		["ShieldWatch"]="护盾监视",
		["RoleCheck"]="职位检查",
		["exCombat"]="脱离战斗",
		["ClassInfo"]="职业信息",
		
		["HostilePlayer"]="敌对玩家",
		["HostileNonPlayer"]="敌对非玩家",
		["NonHostilePlayer"]="非敌对玩家",
		["NonHostileNonPlayer"]="非敌对非玩家",

		["EnableModule"]="全局模块(需要重载UI)",
		["ModuleList"]="模块列表",
		["SeparateModuleList"]="分离模块设置",
		
		["PowerMatch"]="猜测单位GUID(只针对NPC,高资源占用)",
		["CleanUp"]="释放内存间隔(秒)(0表示不释放)",
		["CleanUpTimer"]="释放此时间内没有更新过的数据(秒)",
		["Enabled"]="启用数据收集",
		["idtip"]="在鼠标提示中显示法术id",
		["Modules"]="模块",
		["OnlySelected"]="未选定的目标不显示复杂模块(提升性能)" ,
		["SychonizeAnimation"]="同步所有动画",
		["OffsetX"]="全局X偏移",
		["OffsetY"]="全局Y偏移",
		["SaveData"]="保存单位数据(需要重载UI生效)",
		["CollectHostile"]="收集敌对目标数据",
		["CollectNonHostile"]="收集非敌对目标数据",
		["CollectUnitFromCombatLog"]="从战斗记录中收集单位信息",
		["CollectAuraFromCombatLog"]="从战斗记录中收集增减益信息",
		["ClearDataWhenEnteringArena"]="进入竞技场时清除数据",
		["NotClassColor"]="不修改系统选项(选中这个选项会降低GUID命中率)",
		["ClearAllDataRightNow"]="立即清除所有现存数据",

		["AlterInstant"]="将瞬发法术作为1秒施法",

		["LayerOrder"]="调整图层顺序",
		["Mouseover"]="鼠标滑过",
		["Focus"]="Focus",

		["CollectList"]="收集单位信息表"
	}
	LocalizationCollect={
		["Aura"]="增减益",
		["Casting"]="施法",
		["Target"]="目标",
		["Speed"]="速度",
		["Position"]="位置",
		["Range"]="距离",
		["Portrait"]="头像",
		["Threat"]="仇恨",
		["Tapped"]="怪物被抢先",
		["TargetCount"]="目标计数",
		["GuessHealth"]="猜测生命值",
		["NameGuild"]="姓名和工会",
		["Class"]="职业",
		["Resource"]="资源",
		["Combat"]="战斗",
		["Raid"]="团队",
		["PvP"]="PvP状态",
		["Level"]="等级",
	}
	Tooltips={
		["Core"]="控制所有模块的开关,更新间隔,和整体偏移定位",
		["UnitData_UpdateInterval"]="两次数据收集之间的时间间隔",
		["Frame_UpdateInterval"]="两次框体更新之间的时间间隔",
		["GlobalSize"]="全局缩放,1表示100%",
		["PowerMatch"]="使用收集到的名称和血量数据来对照pve中的怪物,开启时可以在大部分时间都不需要鼠标滑过,但是可能会不精确(当两个怪物拥有完全相同的血量和名称时--这种情况很少),并且占用一些CPU资源",
		["CleanUp"]="两次释放之间的时间间隔,释放会清除指定时间内没有更新的单位数据",
		["CleanUpTimer"]="释放所使用的最小时间限制",
		["Enabled"]="一些模块需要数据收集才能工作,比如[增减益][速度][法力条][施法警告]等等,关闭数据收集会停止这些模块,但是其它模块仍然会正常工作",
		["idtip"]="附加到默认工具提示功能,显示所有法术的法术id",
		["Modules"]="模块开关",
		["OnlySelected"]="自动关闭未选中目标的大部分模块(像[增减益]和[冷却])来节约CPU资源",
		["SychonizeAnimation"]="使所有的动画从同样的起点开始播放,速度和帧数量不会受到影响",
		["Offset"]="全局偏移",

		["EnableModule"]="在这里关闭的模块将不会被载入内存",
		["CollectList"]="在这里禁用的数据类型不会被收集,相应的模块也会停止工作",
		["LayerOrder"]="修改姓名板图层的显示顺序"
	}
else
	Localization={
		["PageName"]="Core",
		["UnitData_UpdateInterval"]="Unit data update interval (Second)",
		["Frame_UpdateInterval"]="Frame update interval (Second)",
		["GlobalSize"]="Global size",

		["Aura"]="Aura",
		["AutoHide"]="AutoHide",
		["CastWarning"]="CastWarning",
		["ClassIcon"]="ClassIcon",
		["ComboPoint"]="ComboPoint",
		["CoolDown"]="CoolDown",
		["CrowdControl"]="CrowdControl",
		["HealthBar"]="HealthBar",
		["ManaBar"]="ManaBar",
		["QuestMark"]="QuestMark",
		["RaidIcon"]="RaidIcon",
		["ScrollText"]="ScrollText",
		["Speed"]="Speed",
		["Target"]="Target",
		["Threat"]="Threat",
		["RangeCheck"]="RangeCheck",
		["Tracker"]="Tracker",
		["CounterSpell"]="CounterSpell",
		["ClassInfo"]="ClassInfo",
		["NameText"]="NameText",
		["TargetCount"]="TargetCount",
		["ShieldWatch"]="ShieldWatch",
		["RoleCheck"]="RoleCheck",
		["exCombat"]="exCombat",

		["HostilePlayer"]="Hostile player",
		["HostileNonPlayer"]="Hostile non-player",
		["NonHostilePlayer"]="Non-hostile player",
		["NonHostileNonPlayer"]="Non-hostile non-player",

		["EnableModule"]="Global module(Require UIReload)",
		["ModuleList"]="Module list",
		["SeparateModuleList"]="Separate module list",

		["PowerMatch"]="Guessing GUID (High CPU usage)",
		["CleanUp"]="Release memory every (Second)(0 means don't)",
		["CleanUpTimer"]="Release data not updated in (Second)",
		["Enabled"]="Enable data collect",
		["idtip"]="Show spellid in tooltips",
		["Modules"]="Modules",
		["OnlySelected"]="Hide complex modules on non-selected (Increase performance)",
		["SychonizeAnimation"]="Sychonize all animation",
		["OffsetX"]="Global offsetX",
		["OffsetY"]="Global offsetY",
		["SaveData"]="Save unit data (Require ui reload)",
		["CollectHostile"]="Collect hostile data",
		["CollectNonHostile"]="Collect non-hostile data",
		["CollectUnitFromCombatLog"]="Collect unit data from combatlog",
		["CollectAuraFromCombatLog"]="Collect aura data from combatlog",
		["ClearDataWhenEnteringArena"]="Clear data when entering arena",
		["NotClassColor"]="Don't change system option (checking this will reduce GUID matching)",
		["ClearAllDataRightNow"]="Clear all current data immediately",

		["AlterInstant"]="Count instant spell as 1s casting",

		["LayerOrder"]="Adjust layer order",
		["Mouseover"]="Mouseover",
		["Focus"]="Focus",

		["CollectList"]="Collect unit info"
	}
	LocalizationCollect={
		["Aura"]="Aura",
		["Casting"]="Casting",
		["Target"]="Target",
		["Speed"]="Speed",
		["Position"]="Position",
		["Range"]="Range",
		["Portrait"]="Portrait",
		["Threat"]="Threat",
		["Tapped"]="Tapped",
		["TargetCount"]="Target count",
		["GuessHealth"]="Guess health",
		["NameGuild"]="Name and Guild",
		["Class"]="Class",
		["Resource"]="Resource",
		["Combat"]="Combat",
		["Raid"]="Raid",
		["PvP"]="PvP state",
		["Level"]="Level",
	}

	Tooltips={
		["Core"]="Controls on/off ,updating interval,and offsets of all modules",
		["UnitData_UpdateInterval"]="How much time between two data-collecting",
		["Frame_UpdateInterval"]="How much time between two updates of frame",
		["GlobalSize"]="Global size, 1 means 100%",
		["PowerMatch"]="Using collected name and health to match pve mob frame, turn it on can make mouseover unrequired most of the time, but maybe inaccurcy(if two mob have exactly same name and health -- which is rare) and cost some cpu power",
		["CleanUp"]="How much time between two clear, clear will delete unit data which are not updated within time limit",
		["CleanUpTimer"]="The time limit for releaseing memory",
		["Enabled"]="Some of modules depend on data collecting,like [Aura][Speed][ManaBar][CastWarning] etc., turn it off will disable those ,but other modules would still work",
		["idtip"]="Addition to default tooltip function to show a spellid for all spells",
		["Modules"]="Modules switches",
		["OnlySelected"]="Automaticly turn off most modules(like [Aura] and [Cooldown]) when not seleted to save cpu power",
		["SychonizeAnimation"]="Make all animated texture plays at the same start point, speed and frame count are not affected",
		["Offset"]="Global offset",

		["EnableModule"]="Modules disabled here won't be loaded",
		["CollectList"]="Data type turned off here won't be collected, also prevent related modules stop working",
		["LayerOrder"]="Change nameplate layer displaying order"
	}
end

local mainframe=NPA_Options:AddPage("NPA_Options_Core",Localization["PageName"],"Core",Tooltips["Core"])
local Options=mainframe.Options

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_Core_idtip",mainframe,21,Localization["idtip"],"idtip",Tooltips["idtip"])
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-3)
table_insert(Options,checkbox)

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_Core_Enabled",mainframe,21,Localization["Enabled"],"Enabled",Tooltips["Enabled"])
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-24)
table_insert(Options,checkbox)



local slideredit=NPA_Options:CreateSliderEdit("NPA_Options_Core_UnitData_UpdateInterval",mainframe,Localization["UnitData_UpdateInterval"],"UnitData_UpdateInterval",0.01,1,0.01,nil,nil,Tooltips["UnitData_UpdateInterval"])
slideredit:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-45)
table_insert(Options,slideredit)

local slideredit=NPA_Options:CreateSliderEdit("NPA_Options_Core_Frame_UpdateInterval",mainframe,Localization["Frame_UpdateInterval"],"Frame_UpdateInterval",0.01,1,0.01,nil,nil,Tooltips["Frame_UpdateInterval"])
slideredit:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-85)
table_insert(Options,slideredit)

local slideredit=NPA_Options:CreateSliderEdit("NPA_Options_Core_GlobalSize",mainframe,Localization["GlobalSize"],"GlobalSize",0.1,10,0.1,nil,nil,Tooltips["GlobalSize"])
slideredit:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-135)
table_insert(Options,slideredit)

local sliderlist={
	["OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-50,
		Max=50,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-175
	},
	["OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-50,
		Max=50,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-175
	},
}

local tooltipslist={
	["OffsetX"]=Tooltips["Offset"],
	["OffsetY"]=Tooltips["Offset"],
}

NPA_Options:BuildSliderList("NPA_Options_Core",mainframe,sliderlist,Options,tooltipslist)


local slideredit=NPA_Options:CreateSliderEdit("NPA_Options_Core_CleanUp",mainframe,Localization["CleanUp"],"CleanUp",0,3600,1,nil,nil,Tooltips["CleanUp"])
slideredit:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-235)
table_insert(Options,slideredit)

local slideredit=NPA_Options:CreateSliderEdit("NPA_Options_Core_CleanUpTimer",mainframe,Localization["CleanUpTimer"],"CleanUpTimer",30,3600,1,nil,nil,Tooltips["CleanUpTimer"])
slideredit:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-278)
table_insert(Options,slideredit)

----------------------------------
local button=NPA_Options:CreateButton("NPA_Options_Core_ClearUpButton",mainframe,230,22,Localization["ClearAllDataRightNow"])
button:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",-6,6)
button:SetScript("OnClick",function()
		NPA_Core:ClearAllData()
		print("All data cleaned")
	end)
----------------------


local listframe=NPA_Options:CreateFrame("NPA_Options_Core_PerformanceOptions",mainframe)
listframe:SetPoint("BOTTOMLEFT",mainframe,"BOTTOMLEFT",3,3)

local checkboxdata={
	["SychonizeAnimation"]=Localization["SychonizeAnimation"],
	["OnlySelected"]=Localization["OnlySelected"],
	["PowerMatch"]=Localization["PowerMatch"],
	["SaveData"]=Localization["SaveData"],
	["CollectHostile"]=Localization["CollectHostile"],
	["CollectNonHostile"]=Localization["CollectNonHostile"],
	["CollectUnitFromCombatLog"]=Localization["CollectUnitFromCombatLog"],
	["CollectAuraFromCombatLog"]=Localization["CollectAuraFromCombatLog"],
	["ClearDataWhenEnteringArena"]=Localization["ClearDataWhenEnteringArena"],
	["Data_AlterInstant"]=Localization["AlterInstant"]
	--["NotClassColor"]=Localization["NotClassColor"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_Core",listframe,21,checkboxdata,21,Options,1,1,Tooltips)


-----------filters
--------------------
----------------------

local mainmodulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_Core_EnableModuleList",mainframe,Localization["EnableModule"],"EnableModule",Tooltips["EnableModule"],nil,Localization)
mainmodulelist:SetPoint("TOPRIGHT",mainframe,"TOPRIGHT",-3,-6)
mainmodulelist:SetWidth(160)

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_Core_SeparateModuleList",mainframe,21,Localization["SeparateModuleList"],"SeparateModuleList")
checkbox:SetPoint("TOPLEFT",mainmodulelist,"BOTTOMLEFT",0,-18)
table_insert(Options,checkbox)

local enablemodulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_Core_EnableModuleList",mainframe,Localization["ModuleList"],"MainModuleList",nil,nil,Localization)
enablemodulelist:SetPoint("TOPRIGHT",mainmodulelist,"BOTTOMRIGHT",0,-50)
enablemodulelist:SetPoint("TOPLEFT",mainmodulelist,"BOTTOMLEFT",0,-50)

local listframe=NPA_Options:CreateFrame("NPA_Options_Core_ModuleList",mainframe,Localization["ModuleList"])
listframe:SetPoint("TOPRIGHT",mainmodulelist,"BOTTOMRIGHT",0,-70)
listframe:SetPoint("TOPLEFT",mainmodulelist,"BOTTOMLEFT",0,-70)
listframe:SetHeight(120)

local hostileplayermodulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_Core_HostilePlayerModuleList",listframe,Localization["HostilePlayer"],"HostilePlayerModuleList",nil,nil,Localization)
hostileplayermodulelist:SetPoint("TOPRIGHT",listframe,"TOPRIGHT",-3,-3)
hostileplayermodulelist:SetPoint("TOPLEFT",listframe,"TOPLEFT",3,-3)

local nonhostileplayermodulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_Core_NonHostilePlayerModuleList",listframe,Localization["NonHostilePlayer"],"NonHostilePlayerModuleList",nil,nil,Localization)
nonhostileplayermodulelist:SetPoint("TOPRIGHT",hostileplayermodulelist,"BOTTOMRIGHT",0,-3)
nonhostileplayermodulelist:SetPoint("TOPLEFT",hostileplayermodulelist,"BOTTOMLEFT",0,-3)

local hostilenonplayermodulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_Core_HostileNonPlayerModuleList",listframe,Localization["HostileNonPlayer"],"HostileNonPlayerModuleList",nil,nil,Localization)
hostilenonplayermodulelist:SetPoint("TOPRIGHT",nonhostileplayermodulelist,"BOTTOMRIGHT",0,-3)
hostilenonplayermodulelist:SetPoint("TOPLEFT",nonhostileplayermodulelist,"BOTTOMLEFT",0,-3)

local nonhostilenonplayermodulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_Core_NonHostileNonPlayerModuleList",listframe,Localization["NonHostileNonPlayer"],"NonHostileNonPlayerModuleList",nil,nil,Localization)
nonhostilenonplayermodulelist:SetPoint("TOPRIGHT",hostilenonplayermodulelist,"BOTTOMRIGHT",0,-3)
nonhostilenonplayermodulelist:SetPoint("TOPLEFT",hostilenonplayermodulelist,"BOTTOMLEFT",0,-3)

local function CheckSeparateFilter()
	if(checkbox:GetChecked())then
		enablemodulelist:Hide()
		listframe:Show()
	else
		enablemodulelist:Show()
		listframe:Hide()
	end
end

checkbox:HookScript("OnClick",CheckSeparateFilter)


-----------------------------------------
local listframe2=NPA_Options:CreateOrderEdit("NPA_Options_Core_LayerOrder",mainframe,Localization["LayerOrder"],"LayerData",Localization)
listframe2:SetPoint("TOPRIGHT",mainframe,"TOPRIGHT",-180,-55)
table_insert(Options,listframe2)
listframe2:SetFrameStrata("HIGH")
listframe2:SetHeight(120)

local button3=NPA_Options:CreateButton("NPA_Options_Core_LayerButton",mainframe,160,22,Localization["LayerOrder"],Tooltips["LayerOrder"])
button3:SetPoint("TOPRIGHT",mainframe,"TOPRIGHT",-180,-10)
button3:SetScript("OnClick",function()
		if(listframe2:IsShown())then
			listframe2:Hide()
		else
			listframe2:Show()
		end
	end)


--------------------------------------------

mainframe:HookScript("OnShow",function()
		listframe2:Show()
		listframe2:Hide()

		listframe:Show()
		CheckSeparateFilter()
	end)


local collectlist=NPA_Options:CreateCheckListEdit2("NPA_Options_Core_CollectList",mainframe,Localization["CollectList"],"Data_Filter",Tooltips["CollectList"],nil,LocalizationCollect)
collectlist:SetPoint("TOPRIGHT",button3,"BOTTOMRIGHT",0,-3)
collectlist:SetWidth(160)


mainframe:Show()