﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("CoolDown"))then

local table_insert = table.insert
local pairs = pairs

local Localization={}
local locale=GetLocale()
local Tooltips={}

if(locale=="zhTW")then
	Localization={
		["PageName"]="技能冷卻",
		["CoolDown_OffsetX"]="X偏移",
		["CoolDown_OffsetY"]="Y偏移",
		["CoolDown_Row"]="每行數量",
		["CoolDown_Max"]="最大數量",
		["CoolDown_Short"]="縮寫長CD時間",
		["CoolDown_GrowUp"]="向上增長",
		["CoolDown_List"]="冷卻列表",
		["CoolDown_SpellId"]="法術ID",
		["CoolDown_CoolDownLength"]="冷卻時間(秒)",
		["CoolDown_GrowRight"]="向右增長",
		["GapWidth"]="間隙寬度",
		["GapHeight"]="間隙高度",
		["Time"]="時間",
		["Icon"]="圖標",
		["Background"]="背景",
		["Overlay"]="前景",
		["Decile"]="最後一秒顯示十分位",
		["ReseterList"]="特殊法術列表",
		["SpellList"]="被影響的法術id",
		["ReduceLength"]="時間(見註釋)",
		["Bar"]="計時器條",
		["ShowBar"]="顯示計時器條",
		["ColorTextByTime"]="按時間著色文本",
		["ColorBarByTime"]="按時間著色計時器條",
		["AlterDecile"]="修改小數顯示",
		["CombiePet"]="合併寵物CD"
		}

	Tooltips={
		["CoolDown"]="顯示單位的技能冷卻圖標,計時器和計時條",
		["SpecialTime"]="[時間]欄填0為重置冷卻時間,例如[急速冷卻]影響[冰環]填0; 時間欄填-1為使用後才產生冷卻,例如[自然迅捷]影響[自然迅捷]填-1;時間欄填其它負數為產生公共冷卻,例如[反擊風暴]影響[盾牆]填-12",
		["CoolDownList"]="填入飾品觸發的buff的法術id和cd就也可以監視飾品冷卻"

	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="技能冷却",
		["CoolDown_OffsetX"]="X偏移",
		["CoolDown_OffsetY"]="Y偏移",
		["CoolDown_Row"]="每行数量",
		["CoolDown_Max"]="最大数量",
		["CoolDown_Short"]="缩写长CD时间",
		["CoolDown_GrowUp"]="向上增长",
		["CoolDown_List"]="冷却列表",
		["CoolDown_SpellId"]="法术ID",
		["CoolDown_CoolDownLength"]="冷却时间(秒)",
		["CoolDown_GrowRight"]="向右增长",
		["GapWidth"]="间隙宽度",
		["GapHeight"]="间隙高度",
		["Time"]="时间",
		["Icon"]="图标",
		["Background"]="背景",
		["Overlay"]="前景",
		["Decile"]="最后一秒显示十分位",
		["ReseterList"]="特殊法术列表",
		["SpellList"]="影响的法术id",
		["ReduceLength"]="时间(见注释)",
		["Bar"]="计时器条",
		["ShowBar"]="显示计时器条",
		["ColorTextByTime"]="按时间着色文本",
		["ColorBarByTime"]="按时间着色计时器条",
		["AlterDecile"]="修改小数显示",
		["CombiePet"]="合并宠物CD"

		}

	Tooltips={
		["CoolDown"]="显示单位的技能冷却图标,计时器,和计时条",
		["SpecialTime"]="[时间]栏填0为重置冷却时间,例如[急速冷却]影响[冰环]填0; 时间栏填-1为使用后才产生冷却,例如[自然迅捷]影响[自然迅捷]填-1;时间栏填其它负数为产生公共冷却,例如[反击风暴]影响[盾墙]填-12",
		["CoolDownList"]="填入饰品触发的buff的法术id和cd就也可以监视饰品冷却"
	}
else
	Localization={
		["PageName"]="CoolDowns",
		["CoolDown_OffsetX"]="Offset X",
		["CoolDown_OffsetY"]="Offset Y",
		["CoolDown_Row"]="Icons per row",
		["CoolDown_Max"]="Max number of icons",
		["CoolDown_Short"]="Shorten long cooldown",
		["CoolDown_GrowUp"]="Grow upward",
		["CoolDown_List"]="CD list",
		["CoolDown_SpellId"]="Spellid",
		["CoolDown_CoolDownLength"]="Cooldown length(s)",
		["CoolDown_GrowRight"]="Grow rightward",
		["GapWidth"]="Gap width",
		["GapHeight"]="Gap height",
		["Time"]="Time",
		["Icon"]="Icon",
		["Background"]="Background",
		["Overlay"]="Overlay",
		["Decile"]="Decile on last second",
		["ReseterList"]="Special spell list",
		["SpellList"]="Affect spell id",
		["ReduceLength"]="Time(See tooltips)",
		["Bar"]="Timer bar",
		["ShowBar"]="Show timer bar",
		["ColorTextByTime"]="Color text by time",
		["ColorBarByTime"]="Color timer bar by time",
		["AlterDecile"]="Alter decile display",
		["CombiePet"]="Combie pet cooldown"

	}

	Tooltips={
		["CoolDown"]="Shows icon,timer and timer bar of unit's cooldown",
		["SpecialTime"]="Fill [Time] with 0 for reset cooldown (i.e. 0 for [Cold Snap] affects [Frost Nova];Fill [time] with -1 for cooldown begins after use (i.e. -1 for [Nature's Swiftness] affects [Nature's Swiftness];Fill [time] with other negative number for shared cooldown (i.e. -12 for [Retaliation] affects [Shield Wall]",
		["CoolDownList"]="To fill in tinket's buff spellid and cd time can also track trinket cd"
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_CoolDown",Localization["PageName"],"CoolDown",Tooltips["CoolDown"])

local Options=mainframe.Options



local sliderlist={
	["CoolDown_OffsetX"]={
		Name=Localization["CoolDown_OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["CoolDown_OffsetY"]={
		Name=Localization["CoolDown_OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	},

	["CoolDown_Max"]={
		Name=Localization["CoolDown_Max"],
		Min=1,
		Max=30,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-45
	},

	["CoolDown_Row"]={
		Name=Localization["CoolDown_Row"],
		Min=1,
		Max=6,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-45
	},
	["CoolDown_GapHeight"]={
		Name=Localization["GapHeight"],
		Min=1,
		Max=100,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-85
	},
	["CoolDown_GapWidth"]={
		Name=Localization["GapWidth"],
		Min=1,
		Max=100,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-85
	},


}

NPA_Options:BuildSliderList("NPA_Options_CoolDown",mainframe,sliderlist,Options)



NPA_Options:CreateSliderEditButton(Localization["Icon"],mainframe,"CoolDown_IconData",3,Options,4.5)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"CoolDown_BackgroundData",3,Options,5.5)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"CoolDown_OverlayData",3,Options,6.5)
NPA_Options:CreateSliderEditButton(Localization["Time"],mainframe,"CoolDown_TimeData",2,Options,7.5)
NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"CoolDown_BarData",1,Options,7.5,1)

-----------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_CoolDown_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(160)


local checkboxdata={
	["CoolDown_ColorTextByTime"]=Localization["ColorTextByTime"],
	["CoolDown_ColorBarByTime"]=Localization["ColorBarByTime"],
	["CoolDown_Short"]=Localization["CoolDown_Short"],
	["CoolDown_GrowUp"]=Localization["CoolDown_GrowUp"],
	["CoolDown_Outline"]=Localization["CoolDown_Outline"],
	["CoolDown_AltDisplay"]=Localization["CoolDown_AltDisplay"],
	["CoolDown_GrowRight"]=Localization["CoolDown_GrowRight"],
	["CoolDown_Decile"]=Localization["Decile"],
	["CoolDown_ShowBar"]=Localization["ShowBar"],
	["CoolDown_AlterDecile"]=Localization["AlterDecile"],
	["CoolDown_CombiePet"]=Localization["CombiePet"]

}

NPA_Options:BuildCheckBoxList("NPA_Options_CoolDown",listframe,20,checkboxdata,17,Options,1)


--------------------------------------

local reseterlist=NPA_Options:CreateEditList2("NPA_Options_CoolDown_List",listframe,Localization["ReseterList"],Localization["CoolDown_SpellId"],Localization["SpellList"],Localization["ReduceLength"],"CoolDown_Reseter",Tooltips["SpecialTime"])
reseterlist:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",-6,6)
NPA_Options:SetFrameTooltip(reseterlist,Tooltips["SpecialTime"])

local cclist=NPA_Options:CreateEditList("NPA_Options_CoolDown_List",listframe,Localization["CoolDown_List"],Localization["CoolDown_SpellId"],Localization["CoolDown_CoolDownLength"],"CoolDown_Data")
cclist:SetPoint("BOTTOMRIGHT",reseterlist,"TOPRIGHT",0,3)
NPA_Options:SetFrameTooltip(cclist,Tooltips["CoolDownList"])

end