﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("ComboPoint"))then

local Localization={}
local Tooltips={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="連擊點數",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Bar"]="條",
		["Background"]="條背景",
		["Overlay"]="條前景",
		["Text"]="文本",
		["ColorBar"]="條按連擊點著色",
		["ShowText"]="顯示文本",
		["ShowBar"]="顯示條"
	}
	Tooltips={
		["ComboPoint"]="顯示自己在單位上的連擊點計數器和計數條"
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="连击点数",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Bar"]="条",
		["Background"]="条背景",
		["Overlay"]="条前景",
		["Text"]="文本",
		["ColorBar"]="条按连击点着色",
		["ShowText"]="显示文本",
		["ShowBar"]="显示条"

	}
	Tooltips={
		["ComboPoint"]="显示自己在单位上的连击点计数器和计数条"
	}
else
	Localization={
		["PageName"]="ComboPoint",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["Bar"]="Bar",
		["Background"]="Bar background",
		["Overlay"]="Bar overlay",
		["Text"]="Text",
		["ColorBar"]="Color bar by points",
		["ShowText"]="Show text",
		["ShowBar"]="Show bar"
	}
	Tooltips={
		["ComboPoint"]="Shows counter and bar for combopoints on unit from self"
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_ComboPoint",Localization["PageName"],"ComboPoint",Tooltips["ComboPoint"])

local Options=mainframe.Options


----------------
local sliderlist={
	["ComboPoint_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["ComboPoint_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	}
}

NPA_Options:BuildSliderList("NPA_Options_ComboPoint",mainframe,sliderlist,Options)


NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"ComboPoint_BarData",1,Options,3)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"ComboPoint_BarOverlayData",1,Options,4)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"ComboPoint_BarBackgroundData",1,Options,5)

NPA_Options:CreateSliderEditButton(Localization["Text"],mainframe,"ComboPoint_TextData",2,Options,6.5)



-------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_ComboPoint_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetWidth(200)

local checkboxdata={
	["ComboPoint_Color"]=Localization["ColorBar"],
	["ComboPoint_ShowText"]=Localization["ShowText"],
	["ComboPoint_ShowBar"]=Localization["ShowBar"]

}

NPA_Options:BuildCheckBoxList("NPA_Options_ComboPoint",listframe,21,checkboxdata,18,Options,1)
end