﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("ClassInfo"))then


local Localization={}
local Tooltips={}

local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

if(locale=="zhTW")then
	Localization={
		["PageName"]="職業信息",
		["Apply"]="套用",
		["Reset"]="重置",
		["Cancel"]="撤銷",
		["StanceIconOffsetX"]="姿態圖標X偏移",
		["StanceIconOffsetY"]="姿態圖標Y偏移",
		["IconSize"]="圖標尺寸",
		["ResourceOffsetX"]="資源條X偏移",
		["ResourceOffsetY"]="資源條Y偏移",
		["ResourceWidth"]="資源條寬度",
		["ResourceHeight"]="資源條高度",
		["Show"]="顯示",
		["Stance"]="姿態",
		["Totem"]="薩滿圖騰",
		["ComboPoint"]="盜賊連擊點",
		["Rune"]="死亡騎士符文",
		["ResourceBarTexture"]="資源條材質",
		["ResourceBorderTexture"]="資源條邊框材質",
		["Stick"]="固定到其它框體",
		["HolyPower"]="聖騎士聖能",
		["ComboPointDruid"]="德魯伊連擊點",
		["HunterCombo"]="獵人射擊大師",
		["Shard"]="術士靈魂碎片",
		["LunarEnergy"]="平衡德魯伊月能",
		["Icon"]="圖標",
		["IconBackground"]="圖標背景",
		["IconOverlay"]="圖標前景",
		["Spark"]="閃光",
		["Ghoul"]="顯示食屍鬼計時器",
		["ShadowFiend"]="顯示暗影魔計時器",
		["Treant"]="顯示樹人計時器",
		["PetFrameOffsetX"]="寵物計時器X偏移",
		["PetFrameOffsetY"]="寵物計時器Y偏移",
		["CPOffsetX"]="連擊點X偏移",
		["CPOffsetY"]="連擊點Y偏移",
		["LunarOffsetX"]="月能條X偏移",
		["LunarOffsetY"]="月能條Y偏移",
		["TotemOffsetX"]="圖騰條X偏移",
		["TotemOffsetY"]="圖騰條Y偏移",
		["PetIcon"]="寵物圖標",
		["PetBackground"]="寵物圖標背景",
		["PetOverlay"]="寵物圖標前景",
		["PetText"]="寵物計時器文本",
		["CPBar"]="連擊點條",
		["CPOverlay"]="連擊點條邊框",
		["CPBackground"]="連擊點條背景",
	}
	Tooltips={
		["ClassInfo"]="顯示職業相關的特殊信息(例如盜賊的連擊點,死亡騎士的符文,聖騎士的聖能,戰士的姿態,等等)(只能工作在wow4.x版本)"
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="职业信息",
		["Apply"]="套用",
		["Reset"]="重置",
		["Cancel"]="撤销",
		["StanceIconOffsetX"]="姿态图标X偏移",
		["StanceIconOffsetY"]="姿态图标Y偏移",
		["IconSize"]="图标尺寸",
		["ResourceOffsetX"]="资源条X偏移",
		["ResourceOffsetY"]="资源条Y偏移",
		["ResourceWidth"]="资源条宽度",
		["ResourceHeight"]="资源条高度",
		["Show"]="显示",
		["Stance"]="姿态",
		["Totem"]="萨满图腾",
		["ComboPoint"]="盗贼连击点",
		["Rune"]="死亡骑士符文",
		["ResourceBarTexture"]="资源条材质",
		["ResourceBorderTexture"]="资源条边框材质",
		["Stick"]="固定到其它框体",
		["HolyPower"]="圣骑士圣能",
		["ComboPointDruid"]="德鲁伊连击点",
		["HunterCombo"]="猎人射击大师",
		["Shard"]="术士灵魂碎片",
		["LunarEnergy"]="平衡德鲁伊月能",
		["Icon"]="图标",
		["IconBackground"]="图标背景",
		["IconOverlay"]="图标前景",
		["Spark"]="闪光",
		["Ghoul"]="显示食尸鬼计时器",
		["ShadowFiend"]="显示暗影魔计时器",
		["Treant"]="显示树人计时器",
		["PetFrameOffsetX"]="宠物计时器X偏移",
		["PetFrameOffsetY"]="宠物计时器Y偏移",
		["CPOffsetX"]="连击点X偏移",
		["CPOffsetY"]="连击点Y偏移",
		["LunarOffsetX"]="月能条X偏移",
		["LunarOffsetY"]="月能条Y偏移",
		["TotemOffsetX"]="图腾条X偏移",
		["TotemOffsetY"]="图腾条Y偏移",
		["PetIcon"]="宠物图标",
		["PetBackground"]="宠物图标背景",
		["PetOverlay"]="宠物图标前景",
		["PetText"]="宠物计时器文本",
		["CPBar"]="连击点条",
		["CPOverlay"]="连击点条边框",
		["CPBackground"]="连击点条背景",
	}
	Tooltips={
		["ClassInfo"]="显示职业相关的特殊信息(例如盗贼的连击点,死亡骑士的符文,圣骑士的圣能,战士的姿态,等等)(只能工作在wow4.x版本)"
	}
else
	Localization={
		["PageName"]="ClassInfo",
		["Apply"]="Apply",
		["Reset"]="Reset",
		["Cancel"]="Cancel",
		["StanceIconOffsetX"]="Stance icon offset X",
		["StanceIconOffsetY"]="Stance icon offset Y",
		["IconSize"]="Icon size",
		["ResourceOffsetX"]="Resource bar offset X",
		["ResourceOffsetY"]="Resource bar offset Y",
		["ResourceWidth"]="Resource bar width",
		["ResourceHeight"]="Resource bar height",
		["Show"]="Show",
		["Stance"]="Stance",
		["Totem"]="Totem of shaman",
		["ComboPoint"]="Combo point of Rogue",
		["Rune"]="Rune of deathknight",
		["ResourceBarTexture"]="Resource bar texture",
		["ResourceBorderTexture"]="Resource bar border texture",
		["Stick"]="Stick to other frames",
		["HolyPower"]="Paladin holy power",
		["ComboPointDruid"]="Combo point of druid",
		["HunterCombo"]="Master Marksman of hunter",
		["Shard"]="Soul shard of warlock",
		["LunarEnergy"]="Lunar energy of balance druid",
		["Icon"]="Stance icon",
		["IconBackground"]="Stance icon background",
		["IconOverlay"]="Stance icon overlay",
		["Spark"]="Lunar bar spark",
		["Ghoul"]="Show ghoul timer",
		["ShadowFiend"]="Show shadowfiend timer",
		["Treant"]="Show treant timer",
		["PetFrameOffsetX"]="Pet timer offset X",
		["PetFrameOffsetY"]="Pet timer offset Y",
		["CPOffsetX"]="Combopoint offset X",
		["CPOffsetY"]="Combopoint offset Y",
		["LunarOffsetX"]="Lunar bar offset X",
		["LunarOffsetY"]="Lunar bar offset Y",
		["TotemOffsetX"]="Totem offset X",
		["TotemOffsetY"]="Totem offset Y",
		["PetIcon"]="Pet icon",
		["PetBackground"]="Pet icon background",
		["PetOverlay"]="Pet icon overlay",
		["PetText"]="Pet timer text",
		["CPBar"]="Combo point bar",
		["CPOverlay"]="Combo point bar overlay",
		["CPBackground"]="Combo point bar background",
	}
	Tooltips={
		["ClassInfo"]="Shows special information about different classes (i.e. combopoint of rogue, runes of deathknight, holypower of paladin, stance of warrior etc.)(Only works in wow4.x)"
	}
end





local mainframe=NPA_Options:AddPage("NPA_Options_ClassInfo",Localization["PageName"],"ClassInfo",Tooltips["ClassInfo"])

local Options=mainframe.Options

----------------
local sliderlist={
	["ClassInfo_ResourceOffsetX"]={
		Name=Localization["ResourceOffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["ClassInfo_ResourceOffsetY"]={
		Name=Localization["ResourceOffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	},
	["ClassInfo_ResourceWidth"]={
		Name=Localization["ResourceWidth"],
		Min=1,
		Max=350,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-45
	},
	["ClassInfo_ResourceHeight"]={
		Name=Localization["ResourceHeight"],
		Min=1,
		Max=50,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-45
	}
}

NPA_Options:BuildSliderList("NPA_Options_ClassInfo",mainframe,sliderlist,Options)



NPA_Options:CreateSliderEditButton(Localization["Icon"],mainframe,"ClassInfo_IconData",3,Options,3.5)
NPA_Options:CreateSliderEditButton(Localization["IconBackground"],mainframe,"ClassInfo_IconBackgroundData",3,Options,4.5)
NPA_Options:CreateSliderEditButton(Localization["IconOverlay"],mainframe,"ClassInfo_IconOverlayData",3,Options,5.5)

NPA_Options:CreateSliderEditButton(Localization["Spark"],mainframe,"ClassInfo_SparkData",3,Options,7)

NPA_Options:CreateSliderEditButton(Localization["PetIcon"],mainframe,"ClassInfo_PetIconData",3,Options,3.5,1.2)
NPA_Options:CreateSliderEditButton(Localization["PetBackground"],mainframe,"ClassInfo_PetBackgroundData",3,Options,4.5,1.2)
NPA_Options:CreateSliderEditButton(Localization["PetOverlay"],mainframe,"ClassInfo_PetOverlayData",3,Options,5.5,1.2)
NPA_Options:CreateSliderEditButton(Localization["PetText"],mainframe,"ClassInfo_PetTextData",2,Options,6.5,1.2)

NPA_Options:CreateSliderEditButton(Localization["CPBar"],mainframe,"ClassInfo_CPBarData",1,Options,8.5)
NPA_Options:CreateSliderEditButton(Localization["CPBackground"],mainframe,"ClassInfo_CPBarBackgroundData",1,Options,9.5)
NPA_Options:CreateSliderEditButton(Localization["CPOverlay"],mainframe,"ClassInfo_CPBarOverlayData",1,Options,10.5)

local editbox=NPA_Options:CreateTextureEditBox("NPA_Options_ClassInfo_ResourceBarTexture",mainframe,300,22,Localization["ResourceBarTexture"],"ClassInfo_ResourceBarTexture")
editbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-385)
table_insert(Options,editbox)


local editbox=NPA_Options:CreateTextureEditBox("NPA_Options_ClassInfo_ResourceBorderTexture",mainframe,240,22,Localization["ResourceBorderTexture"],"ClassInfo_ResourceBorderTexture",1)
editbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-430)
table_insert(Options,editbox)
local button=NPA_Options:CreateBlendModeButton("NPA_Options_ClassInfo_ResourceBorderTextureBlendMode",mainframe,65,22,"ClassInfo_ResourceBorderTextureBlend")
button:SetPoint("LEFT",editbox,"RIGHT",10,0)
table_insert(Options,button)

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_ClassInfo_Stick",mainframe,21,Localization["Stick"],"ClassInfo_Stick")
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-470)
table_insert(Options,checkbox)

---------filter
------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_ClassInfo_Filter",mainframe,Localization["Show"])
listframe:SetPoint("TOPRIGHT",-6,-26)
listframe:SetPoint("BOTTOMRIGHT",-6,6)
listframe:SetWidth(200)

local checkboxdata={
	["ClassInfo_Stance"]=Localization["Stance"],
	["ClassInfo_Totem"]=Localization["Totem"],
	["ClassInfo_ComboPoint"]=Localization["ComboPoint"],
	["ClassInfo_Rune"]=Localization["Rune"],
	["ClassInfo_HolyPower"]=Localization["HolyPower"],
	["ClassInfo_ComboPointDruid"]=Localization["ComboPointDruid"],
	["ClassInfo_HunterCombo"]=Localization["HunterCombo"],
	["ClassInfo_Shard"]=Localization["Shard"],
	["ClassInfo_LunarEnergy"]=Localization["LunarEnergy"],
	["ClassInfo_Ghoul"]=Localization["Ghoul"],
	["ClassInfo_ShadowFiend"]=Localization["ShadowFiend"],
	["ClassInfo_Treant"]=Localization["Treant"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_ScrollText",listframe,21,checkboxdata,17,Options)


end