﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

if(NPA_Core:CheckHook("ClassIcon"))then

local Localization={}
local locale=GetLocale()
local table_insert = table.insert
local pairs = pairs

local Tooltips={}
if(locale=="zhTW")then
	Localization={
		["PageName"]="職業圖標",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Center"]="血條不顯示時居中",
		["Double"]="居中時放大尺寸",
		["ShowClass"]="顯示職業圖標",
		["ShowTotem"]="顯示圖騰图标",
		["Icon"]="圖標",
		["IconBackground"]="圖標背景",
		["IconOverlay"]="圖標前景",
		["HideList"]="圖騰隱藏列表",
		["TotemIcon"]="圖騰圖標",
		["TotemIconBackground"]="圖騰圖標背景",
		["TotemIconOverlay"]="圖騰圖標前景",
		["EnlargeLevel"]="放大比例",
		["Separate"]="獨立的圖騰圖標設置",
		["TotemList"]="自定義圖騰名稱",
		["HideWhenSelected"]="即使選中也隱藏",
		["FuzzyMatch"]="自動匹配圖騰等級(3.35版wow)"
	}

	Tooltips={
		["ClassIcon"]="顯示職業圖標和圖騰圖標"
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="职业图标",
		["OffsetX"]="X偏移",
		["OffsetY"]="Y偏移",
		["Center"]="血条不显示时居中",
		["Double"]="居中时放大尺寸",
		["ShowClass"]="显示职业图标",
		["ShowTotem"]="显示图腾图标",
		["Icon"]="图标",
		["IconBackground"]="图标背景",
		["IconOverlay"]="图标前景",
		["HideList"]="图腾隐藏列表",
		["TotemIcon"]="图腾图标",
		["TotemIconBackground"]="图腾图标背景",
		["TotemIconOverlay"]="图腾图标前景",
		["EnlargeLevel"]="放大比例",
		["Separate"]="独立的图腾图标设置",
		["TotemList"]="自定义图腾名称",
		["HideWhenSelected"]="即使选中也隐藏",
		["FuzzyMatch"]="自动匹配图腾等级(3.35版wow)"
	}
	Tooltips={
		["ClassIcon"]="显示职业图标和图腾图标"
	}
else
	Localization={
		["PageName"]="ClassIcon",
		["OffsetX"]="Offset X",
		["OffsetY"]="Offset Y",
		["Center"]="Center when healthbar is off",
		["Double"]="Enlarge when center",
		["ShowClass"]="Show class icon",
		["ShowTotem"]="Show totem icon",
		["Icon"]="Icon",
		["IconBackground"]="Icon background",
		["IconOverlay"]="Icon overlay",
		["HideList"]="Totem hide-list",
		["TotemIcon"]="Totem icon",
		["TotemIconBackground"]="Totem icon background",
		["TotemIconOverlay"]="Totem icon overlay",
		["EnlargeLevel"]="Enlarge scale",
		["Separate"]="Separate totem icon settings",
		["TotemList"]="Custom totem name",
		["HideWhenSelected"]="Hide even selected",
		["FuzzyMatch"]="Auto match totemlevel(for wow3.35)"
	}
	Tooltips={
		["ClassIcon"]="Shows class icon and totem icon"
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_ClassIcon",Localization["PageName"],"ClassIcon",Tooltips["ClassIcon"])

local Options=mainframe.Options


----------------
----------------
local sliderlist={
	["ClassIcon_OffsetX"]={
		Name=Localization["OffsetX"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-5
	},
	["ClassIcon_OffsetY"]={
		Name=Localization["OffsetY"],
		Min=-150,
		Max=150,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-5
	},
	["ClassIcon_EnlargeLevel"]={
		Name=Localization["EnlargeLevel"],
		Min=1,
		Max=5,
		Step=0.1,
		Width=280,
		OffsetX=20,
		OffsetY=-200
	}
}

NPA_Options:BuildSliderList("NPA_Options_ClassIcon",mainframe,sliderlist,Options)


NPA_Options:CreateSliderEditButton(Localization["Icon"],mainframe,"ClassIcon_IconData",3,Options,2.5)
NPA_Options:CreateSliderEditButton(Localization["IconBackground"],mainframe,"ClassIcon_IconBackgroundData",3,Options,3.5)
NPA_Options:CreateSliderEditButton(Localization["IconOverlay"],mainframe,"ClassIcon_IconOverlayData",3,Options,4.5)

local button1=NPA_Options:CreateSliderEditButton(Localization["TotemIcon"],mainframe,"ClassIcon_TotemIconData",3,Options,11)
local button2=NPA_Options:CreateSliderEditButton(Localization["TotemIconBackground"],mainframe,"ClassIcon_TotemIconBackgroundData",3,Options,12)
local button3=NPA_Options:CreateSliderEditButton(Localization["TotemIconOverlay"],mainframe,"ClassIcon_TotemIconOverlayData",3,Options,13)


local checkbox4=NPA_Options:CreateCheckBox("NPA_Options_ClassIcon_Separate",mainframe,21,Localization["Separate"],"ClassIcon_Separate")
checkbox4:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-300)

local function CheckSeparateFilter(self)
	button1:Show()
	button2:Show()
	button3:Show()

	if(self:GetChecked())then
		button1:Show()
		button2:Show()
		button3:Show()
	else
		button1:Hide()
		button2:Hide()
		button3:Hide()
	end
end

checkbox4:HookScript("OnShow",CheckSeparateFilter)
checkbox4:HookScript("OnClick",CheckSeparateFilter)

table_insert(Options,checkbox4)
-------------------
local listframe=NPA_Options:CreateFrame("NPA_Options_ClassIcon_Filter",mainframe)
listframe:SetPoint("TOPRIGHT",-6,-6)
listframe:SetHeight(360)
listframe:SetWidth(200)


local checkboxdata={
	["ClassIcon_ShowClass"]=Localization["ShowClass"],
	["ClassIcon_ShowTotem"]=Localization["ShowTotem"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_ClassIcon_Filter",listframe,21,checkboxdata,17,Options,1)

local listframe2=NPA_Options:CreateFrame("NPA_Options_ClassIcon_Filter",mainframe)
listframe2:SetPoint("TOPRIGHT",listframe,"BOTTOMRIGHT",0,-6)
listframe2:SetHeight(360)
listframe2:SetWidth(200)


local checkboxdata={
	["ClassIcon_Center"]=Localization["Center"],
	["ClassIcon_Double"]=Localization["Double"],

}

NPA_Options:BuildCheckBoxList("NPA_Options_ClassIcon_Filter",listframe2,21,checkboxdata,17,Options,1)

----------
local hidelist=NPA_Options:CreateCheckListEdit2("NPA_Options_ClassIcon_HideList",mainframe,Localization["HideList"],"ClassIcon_HideList",nil,1)
hidelist:SetPoint("TOPLEFT",listframe2,"BOTTOMLEFT",0,-40)


local totemlist=NPA_Options:CreateCheckListEdit("NPA_Options_ClassIcon_TotemList",mainframe," ","ClassIcon_TotemList")
totemlist:SetPoint("TOPLEFT",hidelist,"BOTTOMLEFT",0,-20)
local label=totemlist:CreateFontString(nil,"OVERLAY")
label:SetFont(GameFontNormal:GetFont(),18)
label:SetPoint("BOTTOMLEFT",totemlist,"TOPLEFT",0,0)
label:SetText(Localization["TotemList"])


local listframe3=NPA_Options:CreateFrame("NPA_Options_ClassIcon_Filter",mainframe)
listframe3:SetPoint("TOPLEFT",totemlist,"BOTTOMLEFT",0,-6)
listframe3:SetHeight(360)
listframe3:SetWidth(200)

local checkboxdata={
	["ClassIcon_HideWhenSelected"]=Localization["HideWhenSelected"],
	["ClassIcon_FuzzyMatch"]=Localization["FuzzyMatch"]

}

NPA_Options:BuildCheckBoxList("NPA_Options_ClassIcon_Filter",listframe3,21,checkboxdata,17,Options,1)
end