﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11
if(NPA_Core:CheckHook("AutoHide"))then

local table_insert = table.insert
local table_remove = table.remove
local pairs = pairs


local Localization={}
local locale=GetLocale()
local Tooltips={}
if(locale=="zhTW")then
	Localization={
		["PageName"]="自動隱藏",
		["AlwaysShow"]="不淡化",
		["FadeHostile"]="淡化敵對",
		["HostileFadeLevel"]="敵對淡化程度",
		["FadeNonHostile"]="淡化非敵對",
		["NonHostileFadeLevel"]="非敵對淡化程度",
		["DefaultFade"]="沒有目標時",
		["ShowPet"]="我的寵物",
		["ShowHaveBuff"]="有buff圖標時",
		["ShowHaveDebuff"]="有debuff圖標時",
		["ShowHaveRaidIcon"]="有raid標記時",
		["ShowTarget"]="我的目標",
		["ShowPetTarget"]="我的寵物的目標",
		["ShowMouseOver"]="鼠標滑過的目標",
		["ShowTargetingMe"]="目標是我時",
		["ShowTargetingPet"]="目標是我的寵物時",
		["ShowCastingOnMe"]="對我施法時",
		["ShowCrowdControl"]="有控場提示時",
		["ShowCasting"]="正在施法時",
		["ShowQuestMark"]="有任務標記時",
		["WhiteList"]="白名單",
		["BlackList"]="黑名單",
		["UseBlackList"]="使用黑名單",
		["UseWhiteList"]="使用白名單",
		["PowerMatch"]="模糊匹配",
		["Focus"]="焦點",
		["InRange"]="符合最小距離檢測",
		["CounterSpell"]="被反制時",
		["LowHealth"]="低血量時",
		["CoolDown"]="有技能冷卻時",
		["Threat"]="有仇恨指示時",
		["TargetCount"]="有目標計數時",
		["IsTotem"]="當是圖騰時",
		["ZoomLevel"]="縮放級別",
		["ZoomTarget"]="縮放目標",
		["ZoomFocus"]="縮放focus",
		["ZoomThreat"]="縮放仇恨",
		["ZoomFilter"]="縮放符合過濾條件的",
		["IsInArena"]="在競技場中",
		["SpecficFadeBlackList"]="指定黑名單淡化級別",
		["SpecficFadeNonPlayer"]="指定非玩家淡化級別",
		["NonPlayerNonHostileFadeLevel"]="非敵對的非玩家",
		["NonPlayerHostileFadeLevel"]="敵對的非玩家",
		["BlackListFadeLevel"]="黑名單的淡化級別",
		["HostilePlayerFilter"]="敵對玩家過濾",
		["NonHostilePlayerFilter"]="非敵對玩家過濾",
		["HostileNonPlayerFilter"]="敵對的非玩家過濾",
		["NonHostileNonPlayerFilter"]="非敵對的非玩家過濾",
		["GlobalFilter"]="全局過濾",
		["SeparateFilter"]="使用獨立的過濾器",
		
		["Zoom"]="自定義縮放",
		["UseZoom"]="啟動自定義縮放",
		["ZoomTarget"]="縮放目標",
		["ZoomFocus"]="縮放focus",
		["ZoomHighThreatPlayer"]="縮放高仇恨玩家",
		["ZoomTankingPlayer"]="縮放坦克中的玩家",
		["ZoomHighThreatMob"]="縮放高仇恨npc",
		["ZoomTankingMob"]="縮放坦克中的npc",
		["ZoomLowThreatPlayer"]="縮放低仇恨玩家",
		["ZoomLowThreatMob"]="縮放低仇恨npc",

		["ZoomFilter"]="縮放符合過濾條件的單位",
		["ZoomHostilePlayer"]="縮放敵對玩家",
		["ZoomNonHostilePlayer"]="縮放非敵對玩家",
		["ZoomHostileNonPlayer"]="縮放敵對非玩家",
		["ZoomNonHostileNonPlayer"]="縮放非敵對非玩家",
		["ZoomHostilePet"]="縮放敵對寵物",
		["ZoomNonHostilePet"]="縮放非敵對寵物",
		["ZoomHostileGuardian"]="縮放敵對護衛",
		["ZoomNonHostileGuardian"]="縮放非敵對護衛",
		["ZoomSpecial"]="縮放特殊單位(首領/稀有)",

		["UseZoomList"]="使用縮放姓名表",
		["ZoomList"]="姓名表",	

		["EnableSeparateFade"]="啟用分離淡化",
		["SeparateFadeList"]="淡化模塊列表",


		["Aura"]="增減益",
		["CastWarning"]="施法警告",
		["ClassIcon"]="職業圖標",
		["ComboPoint"]="連擊點",
		["CoolDown"]="冷卻",
		["CrowdControl"]="控場",
		["HealthBar"]="血條",
		["ManaBar"]="法力條",
		["RaidIcon"]="團隊標記",
		["Speed​​"]="速度",
		["Target"]="目標",
		["Threat"]="仇恨",
		["QuestMark"]="任務提示",
		["RangeCheck"]="距離檢測",
		["CounterSpell"]="法術反制",
		["ClassInfo"]="職業信息",
		["TargetCount"]="目標計數",
		["ShieldWatch"]="護盾監視",
		["exCombat"]="脫離戰鬥",
		["RoleCheck"]="職位檢查",
	}
	Tooltips={
		["AutoHide"]="控制姓名板顯示的透明度和尺寸(透明度為0時則隱藏),特定的過濾需要相關模塊也啟用才可以生效",
		["FadeLevel"]="淡化的程度,從0到1,0表示不可見,1表示不透明",
		["PowerMatch"]="如果單位名稱裡包含列表中的一個名字,也會被認為是匹配的",
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="自动隐藏",
		["AlwaysShow"]="不淡化",
		["FadeHostile"]="淡化敌对",
		["HostileFadeLevel"]="敌对淡化程度",
		["FadeNonHostile"]="淡化非敌对",
		["NonHostileFadeLevel"]="非敌对淡化程度",
		["DefaultFade"]="没有目标时",
		["ShowPet"]="我的宠物",
		["ShowHaveBuff"]="当有buff图标时",
		["ShowHaveDebuff"]="当有debuff图标时",
		["ShowHaveRaidIcon"]="当有团队标记时",
		["ShowTarget"]="我的目标",
		["ShowPetTarget"]="我的宠物的目标",
		["ShowMouseOver"]="鼠标滑过的目标",
		["ShowTargetingMe"]="目标是我时",
		["ShowTargetingPet"]="目标是我的宠物时",
		["ShowCastingOnMe"]="对我施法时",
		["ShowCrowdControl"]="有控场提示时",
		["ShowCasting"]="正在施法时",
		["ShowQuestMark"]="有任务标记时",
		["WhiteList"]="白名单",
		["BlackList"]="黑名单",
		["UseBlackList"]="使用黑名单",
		["UseWhiteList"]="使用白名单",
		["PowerMatch"]="模糊匹配",
		["Focus"]="焦点",
		["InRange"]="符合最小距离检测",
		["CounterSpell"]="被反制时",
		["LowHealth"]="低血量时",
		["CoolDown"]="有技能冷却时",
		["Threat"]="有仇恨指示时",
		["TargetCount"]="有目标计数时",
		["IsTotem"]="当是图腾时",
		["ZoomLevel"]="缩放级别",
		["ZoomTarget"]="缩放目标",
		["ZoomFocus"]="缩放focus",
		["ZoomThreat"]="缩放仇恨",
		["ZoomFilter"]="缩放符合过滤条件的",
		["IsInArena"]="在竞技场中",
		["SpecficFadeBlackList"]="指定黑名单淡化级别", 
		["SpecficFadeNonPlayer"]="指定非玩家淡化级别", 
		["NonPlayerNonHostileFadeLevel"]="非敌对的非玩家", 
		["NonPlayerHostileFadeLevel"]="敌对的非玩家", 
		["BlackListFadeLevel"]="黑名单的淡化级别", 
		["HostilePlayerFilter"]="敌对玩家过滤", 
		["NonHostilePlayerFilter"]="非敌对玩家过滤", 
		["HostileNonPlayerFilter"]="敌对的非玩家过滤", 
		["NonHostileNonPlayerFilter"]="非敌对的非玩家过滤", 
		["GlobalFilter"]="全局过滤", 
		["SeparateFilter"]="使用独立的过滤器",
		
		["Zoom"]="自定义缩放",
		["UseZoom"]="启动自定义缩放",
		["ZoomTarget"]="缩放目标",
		["ZoomFocus"]="缩放focus",
		["ZoomHighThreatPlayer"]="缩放高仇恨玩家",
		["ZoomTankingPlayer"]="缩放坦克中的玩家",
		["ZoomHighThreatMob"]="缩放高仇恨npc",
		["ZoomTankingMob"]="缩放坦克中的npc",
		["ZoomLowThreatPlayer"]="缩放低仇恨玩家",
		["ZoomLowThreatMob"]="缩放低仇恨npc",

		["ZoomFilter"]="缩放符合过滤条件的单位",
		["ZoomHostilePlayer"]="缩放敌对玩家",
		["ZoomNonHostilePlayer"]="缩放非敌对玩家",
		["ZoomHostileNonPlayer"]="缩放敌对非玩家",
		["ZoomNonHostileNonPlayer"]="缩放非敌对非玩家",
		["ZoomHostilePet"]="缩放敌对宠物",
		["ZoomNonHostilePet"]="缩放非敌对宠物",
		["ZoomHostileGuardian"]="缩放敌对护卫",
		["ZoomNonHostileGuardian"]="缩放非敌对护卫",
		["ZoomSpecial"]="缩放特殊单位(首领/稀有)",


		["UseZoomList"]="使用缩放姓名表",
		["ZoomList"]="姓名表",

		["EnableSeparateFade"]="启用分离淡化",
		["SeparateFadeList"]="淡化模块列表",

		["Aura"]="增减益",
		["CastWarning"]="施法警告",
		["ClassIcon"]="职业图标",
		["ComboPoint"]="连击点",
		["CoolDown"]="冷却",
		["CrowdControl"]="控场",
		["HealthBar"]="血条",
		["ManaBar"]="法力条",
		["RaidIcon"]="团队标记",
		["Speed"]="速度",
		["Target"]="目标",
		["Threat"]="仇恨",
		["QuestMark"]="任务提示",
		["RangeCheck"]="距离检测",
		["CounterSpell"]="法术反制",
		["ClassInfo"]="职业信息",
		["TargetCount"]="目标计数",
		["ShieldWatch"]="护盾监视",
		["exCombat"]="脱离战斗",
		["RoleCheck"]="职位检查",

		}
	Tooltips={
		["AutoHide"]="控制姓名板显示的透明度和尺寸(透明度为0时则隐藏),特定的过滤条件需要相关模块同时启用才能生效",
		["FadeLevel"]="淡化的程度,从0到1,0表示不可见,1表示不透明",
		["PowerMatch"]="如果单位名称里包含列表中的一个名字,也会被认为是匹配的",
	}
else
	Localization={
		["PageName"]="AutoHide",
		["AlwaysShow"]="Don't fade",
		["FadeHostile"]="Fade hostile",
		["HostileFadeLevel"]="Hostile fade out level",
		["FadeNonHostile"]="Fade non-hostile",
		["NonHostileFadeLevel"]="Non-hostile fade out level",
		["DefaultFade"]="When have no target",
		["ShowPet"]="My pet",
		["ShowHaveBuff"]="When with buff icons",
		["ShowHaveDebuff"]="When with debuff icons",
		["ShowHaveRaidIcon"]="When with raid icon",
		["ShowTarget"]="My target",
		["ShowPetTarget"]="My pet's target",
		["ShowMouseOver"]="Mouseover",
		["ShowTargetingMe"]="When target is me",
		["ShowTargetingPet"]="When target is my pet",
		["ShowCastingOnMe"]="When casting spell on me",
		["ShowCrowdControl"]="When with CC icon",
		["ShowCasting"]="When casting spell",
		["ShowQuestMark"]="When with quest mark",
		["WhiteList"]="Name white list",
		["BlackList"]="Name black list",
		["UseWhiteList"]="Use white list",
		["UseBlackList"]="Use black list",
		["PowerMatch"]="Fuzzy match",
		["Focus"]="Focus",
		["InRange"]="Within nearest range check",
		["CounterSpell"]="When being spelllocked",
		["LowHealth"]="When low health",
		["CoolDown"]="When has cooldown",
		["Threat"]="When has threat glow",
		["TargetCount"]="When has target count",
		["IsTotem"]="When is totem",
		["IsInArena"]="Is in arena",
		["SpecficFadeBlackList"]="Specfic blacklist fade level",
		["SpecficFadeNonPlayer"]="Specfic non-player fade level",
		["NonPlayerNonHostileFadeLevel"]="Non-player non-hostile",
		["NonPlayerHostileFadeLevel"]="Non-player hostile",
		["BlackListFadeLevel"]="Blacklist fade level",
		["HostilePlayerFilter"]="Hostile player filter",
		["NonHostilePlayerFilter"]="Non-hostile player filter",
		["HostileNonPlayerFilter"]="Hostile non-player filter",
		["NonHostileNonPlayerFilter"]="Non-hostile non-player filter",
		["GlobalFilter"]="Global filter",
		["SeparateFilter"]="Use separated filters",

		["Zoom"]="Custom zoom",
		["UseZoom"]="Enable custom zoom",
		["ZoomTarget"]="Zoom target",
		["ZoomFocus"]="Zoom focus",
		["ZoomHighThreatPlayer"]="Zoom high threat player",
		["ZoomTankingPlayer"]="Zoom tanking player",
		["ZoomHighThreatMob"]="Zoom high threat npc",
		["ZoomTankingMob"]="Zoom tanking npc",
		["ZoomLowThreatPlayer"]="Zoom low threat player",
		["ZoomLowThreatMob"]="Zoom low threat npc",


		["ZoomFilter"]="Zoom fitting filter",
		["ZoomHostilePlayer"]="Zoom hostile player",
		["ZoomNonHostilePlayer"]="Zoom non-hostile player",
		["ZoomHostileNonPlayer"]="Zoom hostile non-player",
		["ZoomNonHostileNonPlayer"]="Zoom non-hostile non-player",
		["ZoomHostilePet"]="Zoom hostile pet",
		["ZoomNonHostilePet"]="Zoom non-hostile pet",
		["ZoomHostileGuardian"]="Zoom hostile guardian",
		["ZoomNonHostileGuardian"]="Zoom non-hostile guardian",
		["ZoomSpecial"]="Zoom special unit(boss/rare)",


		["UseZoomList"]="Use zoom namelist",
		["ZoomList"]="Namelist",

		["EnableSeparateFade"]="Enable separate fade",
		["SeparateFadeList"]="Module fade list",

		["Aura"]="Aura",
		["CastWarning"]="CastWarning",
		["ClassIcon"]="ClassIcon",
		["ComboPoint"]="ComboPoint",
		["CoolDown"]="CoolDown",
		["CrowdControl"]="CrowdControl",
		["HealthBar"]="HealthBar",
		["ManaBar"]="ManaBar",
		["RaidIcon"]="RaidIcon",
		["Speed​​"]="Speed​​",
		["Target"]="Target",
		["Threat"]="Threat",
		["QuestMark"]="QuestMark",
		["RangeCheck"]="RangeCheck",
		["CounterSpell"]="CounterSpell",
		["ClassInfo"]="ClassInfo",
		["TargetCount"]="TargetCount",
		["ShieldWatch"]="ShieldWatch",
		["exCombat"]="exCombat",
		["RoleCheck"]="RoleCheck",
	}
	Tooltips={
		["AutoHide"]="Controls the alpha of nameplats(hidden when alpha is 0),certain filter requires corresponding module enabled to work",
		["FadeLevel"]="How much to fade, from 0 to 1, 0 means invisible, 1 means opaque",
		["PowerMatch"]="If a name in the list is contained in the unit's name, also count as a match",
	}
end

local mainframe=NPA_Options:AddPage("NPA_Options_AutoHide",Localization["PageName"],"AutoHide",Tooltips["AutoHide"])

local Options=mainframe.Options

----------------

local sliderlist={
	["AutoHide_HostileFadeLevel"]={
		Name=Localization["HostileFadeLevel"],
		Min=0,
		Max=1,
		Step=0.01,
		Width=140,
		OffsetX=20,
		OffsetY=-25
	},
	["AutoHide_NonHostileFadeLevel"]={
		Name=Localization["NonHostileFadeLevel"],
		Min=0,
		Max=1,
		Step=0.01,
		Width=140,
		OffsetX=190,
		OffsetY=-25
	},
	["AutoHide_NonPlayer_HostileFadeLevel"]={
		Name=Localization["NonPlayerHostileFadeLevel"],
		Min=0,
		Max=1,
		Step=0.01,
		Width=140,
		OffsetX=20,
		OffsetY=-90
	},
	["AutoHide_NonPlayer_NonHostileFadeLevel"]={
		Name=Localization["NonPlayerNonHostileFadeLevel"],
		Min=0,
		Max=1,
		Step=0.01,
		Width=140,
		OffsetX=190,
		OffsetY=-90
	},
	["AutoHide_BlackListFadeLevel"]={
		Name=Localization["BlackListFadeLevel"],
		Min=0,
		Max=1,
		Step=0.01,
		Width=140,
		OffsetX=20,
		OffsetY=-155
	},
}

NPA_Options:BuildSliderList("NPA_Options_AutoHide",mainframe,sliderlist,Options)

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_FadeHostile",mainframe,21,Localization["FadeHostile"],"AutoHide_FadeHostile")
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-5)
table_insert(Options,checkbox)

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_FadeNonHostile",mainframe,21,Localization["FadeNonHostile"],"AutoHide_FadeNonHostile")
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",190,-5)
table_insert(Options,checkbox)

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_CustomFadeNonPlayer",mainframe,21,Localization["SpecficFadeNonPlayer"],"AutoHide_SpecficFadeNonPlayer")
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-70)
table_insert(Options,checkbox)


local checkbox=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_CustomFadeBlackList",mainframe,21,Localization["SpecficFadeBlackList"],"AutoHide_SpecficFadeBlackList")
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-135)
table_insert(Options,checkbox)

-----------filters
--------------------
local checkboxdata={
	["ShowTarget"]=Localization["ShowTarget"],
	["ShowPetTarget"]=Localization["ShowPetTarget"],
	["ShowMouseOver"]=Localization["ShowMouseOver"],
	["ShowTarget"]=Localization["ShowTarget"],
	["ShowPetTarget"]=Localization["ShowPetTarget"],
	["ShowMouseOver"]=Localization["ShowMouseOver"],
	["ShowHaveBuff"]=Localization["ShowHaveBuff"],
	["ShowHaveDebuff"]=Localization["ShowHaveDebuff"],
	["ShowHaveRaidIcon"]=Localization["ShowHaveRaidIcon"],
	["ShowTargetingMe"]=Localization["ShowTargetingMe"],
	["ShowTargetingPet"]=Localization["ShowTargetingPet"],
	["ShowCasting"]=Localization["ShowCasting"],
	["ShowCastingOnMe"]=Localization["ShowCastingOnMe"],
	["ShowCrowdControl"]=Localization["ShowCrowdControl"],
	["ShowQuestMark"]=Localization["ShowQuestMark"],
	["ShowFocus"]=Localization["Focus"],
	["ShowInRange"]=Localization["InRange"],
	["WithCounterSpell"]=Localization["CounterSpell"],
	["LowHealth"]=Localization["LowHealth"],
	["CoolDown"]=Localization["CoolDown"],
	["Threat"]=Localization["Threat"],
	["TargetCount"]=Localization["TargetCount"],
	["IsTotem"]=Localization["IsTotem"],
	["Arena"]=Localization["IsInArena"],
	["DefaultFade"]=Localization["DefaultFade"],
}


local listframe=NPA_Options:CreateFrame("NPA_Options_AutoHide_HostilePlayerFilter",mainframe,Localization["HostilePlayerFilter"])
listframe:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
listframe:SetWidth(200)
NPA_Options:BuildCheckBoxList2("NPA_Options_AutoHide",listframe,21,checkboxdata,18,"AutoHide_HostilePlayerFilter",1)
table_insert(Options,listframe)
------------

local listframe2=NPA_Options:CreateFrame("NPA_Options_AutoHide_NonHostilePlayerFilter",mainframe,Localization["NonHostilePlayerFilter"])
listframe2:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
listframe2:SetWidth(200)
NPA_Options:BuildCheckBoxList2("NPA_Options_AutoHide",listframe2,21,checkboxdata,18,"AutoHide_NonHostilePlayerFilter",1)
table_insert(Options,listframe2)
listframe2:Hide()

-----------
local listframe3=NPA_Options:CreateFrame("NPA_Options_AutoHide_HostileNonPlayerFilter",mainframe,Localization["HostileNonPlayerFilter"])
listframe3:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
listframe3:SetWidth(200)
NPA_Options:BuildCheckBoxList2("NPA_Options_AutoHide",listframe3,21,checkboxdata,18,"AutoHide_HostileNonPlayerFilter",1)
table_insert(Options,listframe3)
listframe3:Hide()

-------------
checkboxdata["ShowPet"]=Localization["ShowPet"]

local listframe4=NPA_Options:CreateFrame("NPA_Options_AutoHide_NonHostileNonPlayerFilter",mainframe,Localization["NonHostileNonPlayerFilter"])
listframe4:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
listframe4:SetWidth(200)
NPA_Options:BuildCheckBoxList2("NPA_Options_AutoHide",listframe4,21,checkboxdata,18,"AutoHide_NonHostileNonPlayerFilter",1)
table_insert(Options,listframe4)
listframe4:Hide()
-----------
local listframe5=NPA_Options:CreateFrame("NPA_Options_AutoHide_GlobalFilter",mainframe,Localization["GlobalFilter"])
listframe5:SetPoint("TOPRIGHT",mainframe,"TOPRIGHT",-3,-46)
listframe5:SetWidth(200)
NPA_Options:BuildCheckBoxList2("NPA_Options_AutoHide",listframe5,21,checkboxdata,18,"AutoHide_GlobalFilter",1)
table_insert(Options,listframe5)
listframe5:Hide()


local button1=NPA_Options:CreateButton("NPA_Options_AutoHide_HostilePlayerFilter",mainframe,0,22,Localization["HostilePlayerFilter"])
local button2=NPA_Options:CreateButton("NPA_Options_AutoHide_NonHostilePlayerFilter",mainframe,0,22,Localization["NonHostilePlayerFilter"])
local button3=NPA_Options:CreateButton("NPA_Options_AutoHide_HostileNonPlayerFilter",mainframe,0,22,Localization["HostileNonPlayerFilter"])
local button4=NPA_Options:CreateButton("NPA_Options_AutoHide_NonHostileNonPlayerFilter",mainframe,0,22,Localization["NonHostileNonPlayerFilter"])

button1:SetPoint("TOPRIGHT",-6,-25)
button1:SetScript("OnClick",function()
	if(listframe:IsShown())then
		listframe:Hide()
	else
		listframe:Show()
	end
	listframe2:Hide()
	listframe3:Hide()
	listframe4:Hide()
	end)
button1:SetWidth(200)
button2:SetPoint("TOPRIGHT",button1,"BOTTOMRIGHT",0,-5)
button2:SetScript("OnClick",function()
	listframe:Hide()
	if(listframe2:IsShown())then
		listframe2:Hide()
	else
		listframe2:Show()
	end
	listframe3:Hide()
	listframe4:Hide()
	end)
button2:SetWidth(200)
button3:SetPoint("TOPRIGHT",button2,"BOTTOMRIGHT",0,-5)
button3:SetScript("OnClick",function()
	listframe:Hide()
	listframe2:Hide()
	if(listframe3:IsShown())then
		listframe3:Hide()
	else
		listframe3:Show()
	end
	listframe4:Hide()
	end)
button3:SetWidth(200)
button4:SetPoint("TOPRIGHT",button3,"BOTTOMRIGHT",0,-5)
button4:SetScript("OnClick",function()
	listframe:Hide()
	listframe2:Hide()
	listframe3:Hide()
	if(listframe4:IsShown())then
		listframe4:Hide()
	else
		listframe4:Show()
	end
	end)
button4:SetWidth(200)


local checkbox4=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_SeparateFilter",mainframe,21,Localization["SeparateFilter"],"AutoHide_SeparateFilter")
checkbox4:SetPoint("TOPRIGHT",mainframe,"TOPRIGHT",-183,-3)

local function CheckSeparateFilter(self)
	listframe:Show()
	listframe2:Show()
	listframe3:Show()
	listframe4:Show()
	listframe5:Show()
	listframe:Hide()
	listframe2:Hide()
	listframe3:Hide()
	listframe4:Hide()
	if(self:GetChecked())then
		button1:Show()
		button2:Show()
		button3:Show()
		button4:Show()
		listframe5:Hide()
	else
		button1:Hide()
		button2:Hide()
		button3:Hide()
		button4:Hide()
		listframe5:Show()
	end
end

checkbox4:HookScript("OnShow",CheckSeparateFilter)
checkbox4:HookScript("OnClick",CheckSeparateFilter)

table_insert(Options,checkbox4)

-----namelist
local namelist=NPA_Options:CreateFrame("NPA_Options_AutoHide_NameList",mainframe,Localization["NameList"])
namelist:SetPoint("BOTTOMLEFT",mainframe,"BOTTOMLEFT",3,3)
namelist:SetWidth(195)
namelist:SetHeight(126)

local whitelist=NPA_Options:CreateCheckListEdit("NPA_Options_AutoHide_NameWhiteList",namelist," ","AutoHide_NameWhiteList")
whitelist:SetPoint("TOP",namelist,"TOP",0,-3)
local label=whitelist:CreateFontString(nil,"OVERLAY")
label:SetFont(GameFontNormal:GetFont(),18)
label:SetPoint("BOTTOMLEFT",whitelist,"TOPLEFT",0,0)
label:SetText(Localization["WhiteList"])

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_WhiteListAbsolute",namelist,21,Localization["PowerMatch"],"AutoHide_ListPowerMatch",Tooltips["PowerMatch"])
checkbox:SetPoint("TOPLEFT",whitelist,"TOPRIGHT")
table_insert(Options,checkbox)

local checkbox2=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_UseWhiteList",mainframe,21,Localization["UseWhiteList"],"AutoHide_UseWhiteList")
checkbox2:SetPoint("TOPLEFT",checkbox,"BOTTOMLEFT",0,-3)
table_insert(Options,checkbox2)

local blacklist=NPA_Options:CreateCheckListEdit("NPA_Options_AutoHide_NameBlackList",namelist," ","AutoHide_NameBlackList")
blacklist:SetPoint("TOP",whitelist,"BOTTOM",0,-23)
local label=blacklist:CreateFontString(nil,"OVERLAY")
label:SetFont(GameFontNormal:GetFont(),18)
label:SetPoint("BOTTOMLEFT",blacklist,"TOPLEFT",0,0)
label:SetText(Localization["BlackList"])

local checkbox3=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_UseBlackList",mainframe,21,Localization["UseBlackList"],"AutoHide_UseBlackList")
checkbox3:SetPoint("TOPLEFT",checkbox2,"BOTTOMLEFT",0,-3)
table_insert(Options,checkbox3)


------------------------
-------zoom page
------------------------

local checkbox=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_UseZoom",mainframe,21,Localization["UseZoom"],"AutoHide_UseZoom")
checkbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-235)
table_insert(Options,checkbox)

local button=NPA_Options:CreateButton("NPA_Options_AutoHide_ZoomButton",mainframe,0,21,Localization["Zoom"])
button:SetPoint("TOPLEFT",checkbox,"BOTTOMLEFT",0,-6)


local zoomframe=NPA_Options:CreateFrame("NPA_Options_AutoHide_CustomZoomMainFrame",mainframe,Localization["Zoom"])
zoomframe:SetPoint("LEFT",button,"RIGHT")
zoomframe:SetWidth(540)
zoomframe:SetHeight(455)
zoomframe:SetFrameStrata("HIGH")


local listframe4=NPA_Options:CreateFrame("NPA_Options_AutoHide_Zoom",zoomframe)
listframe4:SetPoint("TOPLEFT",6,-6)
listframe4:SetWidth(200)

local checkboxdata={
	["AutoHide_ZoomTarget"]=Localization["ZoomTarget"],
	["AutoHide_ZoomFocus"]=Localization["ZoomFocus"],
	["AutoHide_ZoomHighThreatPlayer"]=Localization["ZoomHighThreatPlayer"],
	["AutoHide_ZoomTankingPlayer"]=Localization["ZoomTankingPlayer"],
	["AutoHide_ZoomHighThreatMob"]=Localization["ZoomHighThreatMob"],
	["AutoHide_ZoomTankingMob"]=Localization["ZoomTankingMob"],
	["AutoHide_ZoomLowThreatPlayer"]=Localization["ZoomLowThreatPlayer"],
	["AutoHide_ZoomLowThreatMob"]=Localization["ZoomLowThreatMob"],

	["AutoHide_ZoomFilter"]=Localization["ZoomFilter"],
	["AutoHide_ZoomHostilePlayer"]=Localization["ZoomHostilePlayer"],
	["AutoHide_ZoomNonHostilePlayer"]=Localization["ZoomNonHostilePlayer"],
	["AutoHide_ZoomHostileNonPlayer"]=Localization["ZoomHostileNonPlayer"],
	["AutoHide_ZoomNonHostileNonPlayer"]=Localization["ZoomNonHostileNonPlayer"],
	["AutoHide_UseZoomList"]=Localization["UseZoomList"],
	["AutoHide_ZoomHostilePet"]=Localization["ZoomHostilePet"],
	["AutoHide_ZoomNonHostilePet"]=Localization["ZoomNonHostilePet"],
	["AutoHide_ZoomHostileGuardian"]=Localization["ZoomHostileGuardian"],
	["AutoHide_ZoomNonHostileGuardian"]=Localization["ZoomNonHostileGuardian"],
	["AutoHide_ZoomSpecial"]=Localization["ZoomSpecial"],

}


NPA_Options:BuildCheckBoxList("NPA_Options_AutoHide",listframe4,21,checkboxdata,17,Options,1)

local zoomlist=NPA_Options:CreateEditList3("NPA_Options_AutoHide_ZoomList",zoomframe,Localization["ZoomList"],Localization["Zoom"],"AutoHide_ZoomList")
zoomlist:SetPoint("TOPLEFT",listframe4,"BOTTOMLEFT",0,-6)

local sliderlist={
	["AutoHide_ZoomTargetLevel"]={
		Name=Localization["ZoomTarget"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-5
	},
	["AutoHide_ZoomFocusLevel"]={
		Name=Localization["ZoomFocus"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-5
	},
	["AutoHide_ZoomFilterLevel"]={
		Name=Localization["ZoomFilter"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-55
	},
	["AutoHide_ZoomSpecialLevel"]={
		Name=Localization["ZoomSpecial"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-55
	},


	["AutoHide_ZoomHighThreatPlayerLevel"]={
		Name=Localization["ZoomHighThreatPlayer"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-105
	},
	["AutoHide_ZoomTankingPlayerLevel"]={
		Name=Localization["ZoomTankingPlayer"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-105
	},
	["AutoHide_ZoomHighThreatMobLevel"]={
		Name=Localization["ZoomHighThreatMob"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-155
	},
	["AutoHide_ZoomTankingMobLevel"]={
		Name=Localization["ZoomTankingMob"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-155
	},

	["AutoHide_ZoomLowThreatPlayerLevel"]={
		Name=Localization["ZoomLowThreatPlayer"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-405
	},

	["AutoHide_ZoomLowThreatMobLevel"]={
		Name=Localization["ZoomLowThreatMob"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-405
	},


	["AutoHide_ZoomHostilePlayerLevel"]={
		Name=Localization["ZoomHostilePlayer"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-205
	},
	["AutoHide_ZoomHostileNonPlayerLevel"]={
		Name=Localization["ZoomHostileNonPlayer"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-205
	},
	["AutoHide_ZoomNonHostilePlayerLevel"]={
		Name=Localization["ZoomNonHostilePlayer"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-255
	},
	["AutoHide_ZoomNonHostileNonPlayerLevel"]={
		Name=Localization["ZoomNonHostileNonPlayer"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-255
	},

	["AutoHide_ZoomHostilePetLevel"]={
		Name=Localization["ZoomHostilePet"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-305
	},
	["AutoHide_ZoomNonHostilePetLevel"]={
		Name=Localization["ZoomNonHostilePet"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-305
	},
	["AutoHide_ZoomHostileGuardianLevel"]={
		Name=Localization["ZoomHostileGuardian"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=220,
		OffsetY=-355
	},
	["AutoHide_ZoomNonHostileGuardianLevel"]={
		Name=Localization["ZoomNonHostileGuardian"],
		Min=0,
		Max=2,
		Step=0.01,
		Width=140,
		OffsetX=380,
		OffsetY=-355
	},
}

NPA_Options:BuildSliderList("NPA_Options_AutoHide",zoomframe,sliderlist,Options)


local function CheckZoom(self)
	zoomframe:Show()
	zoomframe:Hide()
end
checkbox:HookScript("OnShow",CheckZoom)

button:SetScript("OnClick",function()
	if(zoomframe:IsShown())then
		zoomframe:Hide()
	else
		zoomframe:Show()
	end
end)



------------------------
-------separate fade page
------------------------


local checkbox2=NPA_Options:CreateCheckBox("NPA_Options_AutoHide_EnableSeparateFade",mainframe,21,Localization["EnableSeparateFade"],"AutoHide_EnableSeparateFade")
checkbox2:SetPoint("TOPLEFT",mainframe,"TOPLEFT",20,-305)
table_insert(Options,checkbox2)

local modulelist=NPA_Options:CreateCheckListEdit2("NPA_Options_AutoHide_SeparateFadeList",mainframe,Localization["SeparateFadeList"],"AutoHide_SeparateFade",nil ,nil ,Localization)
modulelist:SetPoint("TOPLEFT",checkbox2,"BOTTOMLEFT",0,-3)

end