﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11
if(NPA_Core:CheckHook("Aura"))then

local table_insert = table.insert
local pairs = pairs

local Localization={}
local locale=GetLocale()
local Tooltips={}
if(locale=="zhTW")then
	Localization={
		["PageName"]="增減益",
		["Aura_OffsetX"]="X偏移",
		["Aura_OffsetY"]="Y偏移",
		["Aura_MaxBuff"]="Buff數量",
		["Aura_MaxDebuff"]="Debuff數量",

		["Buff"]="增益",
		["Debuff"]="減益",
		["From"]="來自於",
		["To"]="目標為",

		["Self"]="自己",
		["Pet"]="寵物",
		["Target"]="目標",
		["Focus"]="Focus",
		["Mouseover"]="鼠標滑過",
		["HostilePlayer"]="敵對玩家",
		["HostileNonPlayer"]="敵對非玩家",
		["NonHostilePlayer"]="非敵對玩家",
		["NonHostileNonPlayer"]="非敵對非玩家",

		["WhiteList"]="白名單",
		["BlackList"]="黑名單",
		["BySpellid"]="id",
		["BySpellname"]="名",
		["BuffTime"]="buff時間",
		["DebuffTime"]="debuff時間",
		["Magic"]="魔法",
		["Physic"]="物理",
		["Poison"]="毒",
		["Disease"]="疾病",
		["Enrage"]="激怒",
		["Other"]="其它人的",
		["Stealable"]="可偷取的",
		["Mine"]="我的",
		["BuffPerRow"]="每行buff",
		["DebuffPerRow"]="每行debuff",
		["Anchor"]="主框體錨點",
		["BuffAnchor"]="Buff框體錨點",
		["DebuffAnchor"]="Debuff框體錨點",
		["GapWidth"]="間隙寬度",
		["GapHeight"]="間隙高度",
		["Time"]="時間",
		["Stack"]="層數",
		["Icon"]="圖標",
		["Background"]="背景",
		["Overlay"]="前景",
		["Curse"]="詛咒",
		["BuffOffsetX"]="Buff X",
		["BuffOffsetY"]="Buff Y",
		["DebuffOffsetX"]="Debuff X",
		["DebuffOffsetY"]="Debuff Y",
		["BuffGrowUpward"]="Buff向上增長",
		["BuffGrowRightward"]="Buff向右增長",
		["DebuffGrowUpward"]="Debuff向上增長",
		["DebuffGrowRightward"]="Debuff向右增長",
		["BuffOnDebuff"]="buff定位在debuff上",
		["DebuffOnBuff"]="debuff定位在buff上",
		["Decile"]="最後一秒顯示十分位",
		["BuffScale"]="Buff縮放",
		["DebuffScale"]="Debuff縮放",
		["UseHighlightScale"]="縮放高亮",
		["HighlightScale"]="高亮縮放",
		["Highlight"]="高亮",
		["UseHighlight"]="啟用高亮",
		["SpellId"]="法術id",
		["ScaleList"]="特殊縮放",
		["Scale"]="縮放",
		["BuffFilter"]="Buff過濾",
		["DebuffFilter"]="Debuff過濾",
		["SchoolFilter"]="系別過濾",
		["HighlightList"]="特殊高亮",
		["Bar"]="計時器條",
		["ShowBar"]="顯示計時器條",
		["ColorHighlight"]="上色高亮材質",
		["ColorBackground"]="上色背景材質",
		["ColorBar"]="上色計時器條",
		["ColorMagic"]="上色魔法",
		["ColorPosion"]="上色毒",
		["ColorDisease"]="上色疾病",
		["ColorCurse"]="上色詛咒",
		["ColorPhysic"]="上色物理",
		["ColorTextByTime"]="按時間著色文本",
		["ColorBarByTime"]="按時間著色計時器條",
		["AlterDecile"]="修改小數顯示",
		["SortBySpellid"]="按法術id排序图标",
		["SortByTimeleft"]="按剩餘時間排序图标",
	}
	Tooltips={
		["Aura"]="顯示buff和debuff圖標",
		["WhiteList"]="不論過濾設置如何,這個列表中的增減益將總是被顯示",
		["BlackList"]="不論過濾設置如何,這個列表中的增減益將總是被隱藏",
		["BuffTime"]="剩餘時間超越這個數字(單位為秒)的buff將被隱藏,設置為0則關閉",
		["DebuffTime"]="剩餘時間超越這個數字(單位為秒)的debuff將被隱藏,設置為0則關閉",
	}
elseif(locale=="zhCN")then
	Localization={
		["PageName"]="增减益",
		["Aura_OffsetX"]="X偏移",
		["Aura_OffsetY"]="Y偏移",
		["Aura_MaxBuff"]="Buff数量",
		["Aura_MaxDebuff"]="Debuff数量",

		["Buff"]="增益",
		["Debuff"]="减益",
		["From"]="来自于",
		["To"]="目标为",

		["Self"]="自己",
		["Pet"]="宠物",
		["Target"]="目标",
		["Focus"]="Focus",
		["Mouseover"]="鼠标滑过",
		["HostilePlayer"]="敌对玩家",
		["HostileNonPlayer"]="敌对非玩家",
		["NonHostilePlayer"]="非敌对玩家",
		["NonHostileNonPlayer"]="非敌对非玩家",

		["WhiteList"]="白名单",
		["BlackList"]="黑名单",
		["BySpellid"]="id",
		["BySpellname"]="名",
		["BuffTime"]="buff时间",
		["DebuffTime"]="debuff时间",
		["Magic"]="魔法",
		["Physic"]="物理",
		["Poison"]="毒",
		["Disease"]="疾病",
		["Enrage"]="激怒",
		["Other"]="其它人的",
		["Stealable"]="可偷取的",
		["Mine"]="我的",
		["BuffPerRow"]="每行buff",
		["DebuffPerRow"]="每行debuff",
		["Anchor"]="主框体锚点",
		["BuffAnchor"]="Buff框体锚点",
		["DebuffAnchor"]="Debuff框体锚点",
		["GapWidth"]="间隙宽度",
		["GapHeight"]="间隙高度",
		["Time"]="时间",
		["Stack"]="层数",
		["Icon"]="图标",
		["Background"]="背景",
		["Overlay"]="前景",
		["Curse"]="诅咒",
		["BuffOffsetX"]="Buff X",
		["BuffOffsetY"]="Buff Y",
		["DebuffOffsetX"]="Debuff X",
		["DebuffOffsetY"]="Debuff Y",
		["BuffGrowUpward"]="Buff向上增长",
		["BuffGrowRightward"]="Buff向右增长",
		["DebuffGrowUpward"]="Debuff向上增长",
		["DebuffGrowRightward"]="Debuff向右增长",
		["BuffOnDebuff"]="buff定位在debuff上",
		["DebuffOnBuff"]="debuff定位在buff上",
		["Decile"]="最后一秒显示十分位",
		["BuffScale"]="Buff缩放",
		["DebuffScale"]="Debuff缩放",
		["Highlight"]="高亮",
		["UseHighlight"]="启用高亮",
		["SpellId"]="法术id",
		["ScaleList"]="特殊缩放",
		["Scale"]="缩放",
		["UseHighlightScale"]="缩放高亮",
		["HighlightScale"]="高亮缩放",
		["BuffFilter"]="Buff过滤",
		["DebuffFilter"]="Debuff过滤",
		["SchoolFilter"]="系别过滤",
		["HighlightList"]="特殊高亮",
		["Bar"]="计时器条",
		["ShowBar"]="显示计时器条",
		["ColorHighlight"]="上色高亮材质",
		["ColorBackground"]="上色背景材质",
		["ColorBar"]="上色计时器条",
		["ColorMagic"]="上色魔法",
		["ColorPosion"]="上色毒",
		["ColorDisease"]="上色疾病",
		["ColorCurse"]="上色诅咒",
		["ColorPhysic"]="上色物理",
		["ColorTextByTime"]="按时间着色文本",
		["ColorBarByTime"]="按时间着色计时器条",
		["AlterDecile"]="修改小数显示",
		["SortBySpellid"]="按法术id排序图标",
		["SortByTimeleft"]="按剩余时间排序图标",
		
	}
	Tooltips={
		["Aura"]="显示buff和debuff图标",
		["WhiteList"]="不论过滤设置如何,这个列表中的增减益将总是被显示",
		["BlackList"]="不论过滤设置如何,这个列表中的增减益将总是被隐藏",
		["BuffTime"]="剩余时间超越这个数字(单位为秒)的buff将被隐藏,设置为0则关闭",
		["DebuffTime"]="剩余时间超越这个数字(单位为秒)的debuff将被隐藏,设置为0则关闭",
	}
else
	Localization={
		["PageName"]="Auras",
		["Aura_OffsetX"]="Offset X",
		["Aura_OffsetY"]="Offset Y",
		["Aura_MaxBuff"]="Max Buffs",
		["Aura_MaxDebuff"]="Max Debuffs",

		["Buff"]="Buff",
		["Debuff"]="Debuff",
		["From"]="From",
		["To"]="On",

		["Self"]="Self",
		["Pet"]="Pet",
		["Target"]="Target",
		["Focus"]="Focus",
		["Mouseover"]="Mouseover",
		["HostilePlayer"]="Hostile player",
		["HostileNonPlayer"]="Hostile non-player",
		["NonHostilePlayer"]="Non-hostile player",
		["NonHostileNonPlayer"]="Non-hostile non-player",

		["WhiteList"]="Whitelist",
		["BlackList"]="BlackList",
		["BySpellid"]="By id",
		["BySpellname"]="By name",
		["Aura_StackSize"]="Stack text size",
		["Aura_TimeSize"]="Timer text size",
		["BuffTime"]="Buff time",
		["DebuffTime"]="Debuff time",
		["Magic"]="Magic",
		["Physic"]="Physic",
		["Poison"]="Poison",
		["Disease"]="Disease",
		["Enrage"]="Enrage",
		["Other"]="Other's",
		["Stealable"]="Stealable",
		["Mine"]="Mine",
		["BuffPerRow"]="Buffs per row",
		["DebuffPerRow"]="Debuffs per row",
		["Anchor"]="Main frame anchor",
		["BuffAnchor"]="Buff frame anchor",
		["DebuffAnchor"]="Debuff frame anchor",
		["GapWidth"]="Gap width",
		["GapHeight"]="Gap height",
		["Time"]="Time",
		["Stack"]="Stack",
		["Icon"]="Icon",
		["Background"]="Background",
		["Overlay"]="Overlay",
		["Curse"]="Curse",
		["BuffOffsetX"]="Buff X",
		["BuffOffsetY"]="Buff Y",
		["DebuffOffsetX"]="Debuff X",
		["DebuffOffsetY"]="Debuff Y",
		["BuffGrowUpward"]="Buff grows upward",
		["BuffGrowRightward"]="Buff grows rightward",
		["DebuffGrowUpward"]="Debuff grows upward",
		["DebuffGrowRightward"]="Debuff grows rightward",
		["BuffOnDebuff"]="Buff anchor on debuff",
		["DebuffOnBuff"]="Debuff anchor on buff",
		["Decile"]="Decile on last second",
		["BuffScale"]="Buff scale",
		["DebuffScale"]="Debuff scale",
		["Highlight"]="Highlight",
		["UseHighlight"]="Enable highlight",
		["SpellId"]="Spell id",
		["ScaleList"]="Special scale",
		["Scale"]="Scale",
		["UseHighlightScale"]="Enable highlight scale",
		["HighlightScale"]="Highlight scale",
		["BuffFilter"]="Buff filters",
		["DebuffFilter"]="Debuff filters",
		["SchoolFilter"]="School filters",
		["HighlightList"]="Highlight list",
		["Bar"]="Timer bar",
		["ShowBar"]="Show timer bar",
		["ColorHighlight"]="Color highlight texture",
		["ColorBackground"]="Color background texture",
		["ColorBar"]="Color timer bar",
		["ColorMagic"]="Color magic",
		["ColorPosion"]="Color posion",
		["ColorDisease"]="Color disease",
		["ColorCurse"]="Color curse",
		["ColorPhysic"]="Color physic",
		["ColorTextByTime"]="Color text by time",
		["ColorBarByTime"]="Color timer bar by time",
		["AlterDecile"]="Alter decile display",
		["SortBySpellid"]="Resort icon by spellid",
		["SortByTimeleft"]="Resort icon by timeleft",
		
	}
	Tooltips={
		["Aura"]="Show buff and debuff icons",
		["WhiteList"]="Aura in this list will be always shown ignoring filter settings",
		["BlackList"]="Aura in this list will be always hidden ignoring filter settings",
		["BuffTime"]="Hide buff has more time left than this(by second), set to 0 to turn off",
		["DebuffTime"]="Hide debuff has more time left than this(by second), set to 0 to turn off",
	}
end


local mainframe=NPA_Options:AddPage("NPA_Options_Aura",Localization["PageName"],"Aura",Tooltips["Aura"])

local Options=mainframe.Options



local sliderlist={
	["Aura_OffsetX"]={
		Name=Localization["Aura_OffsetX"],
		Min=-50,
		Max=50,
		Step=1,
		Width=70,
		OffsetX=20,
		OffsetY=-5
	},
	["Aura_OffsetY"]={
		Name=Localization["Aura_OffsetY"],
		Min=-50,
		Max=50,
		Step=1,
		Width=70,
		OffsetX=105,
		OffsetY=-5
	},
	["Aura_GapY"]={
		Name=Localization["GapHeight"],
		Min=1,
		Max=100,
		Step=1,
		Width=70,
		OffsetX=190,
		OffsetY=-5
	},
	["Aura_GapX"]={
		Name=Localization["GapWidth"],
		Min=1,
		Max=100,
		Step=1,
		Width=70,
		OffsetX=275,
		OffsetY=-5
	},

	["Aura_MaxBuff"]={
		Name=Localization["Aura_MaxBuff"],
		Min=0,
		Max=30,
		Step=1,
		Width=70,
		OffsetX=20,
		OffsetY=-45
	},
	["Aura_MaxDebuff"]={
		Name=Localization["Aura_MaxDebuff"],
		Min=1,
		Max=30,
		Step=1,
		Width=70,
		OffsetX=105,
		OffsetY=-45
	},
	["Aura_BuffPerRow"]={
		Name=Localization["BuffPerRow"],
		Min=1,
		Max=30,
		Step=1,
		Width=70,
		OffsetX=190,
		OffsetY=-45
	},
	["Aura_DebuffPerRow"]={
		Name=Localization["DebuffPerRow"],
		Min=1,
		Max=30,
		Step=1,
		Width=70,
		OffsetX=275,
		OffsetY=-45
	},

	["Aura_Filter_BuffTime"]={
		Name=Localization["BuffTime"],
		Min=0,
		Max=360,
		Step=1,
		Width=140,
		OffsetX=20,
		OffsetY=-85
	},
	["Aura_Filter_DebuffTime"]={
		Name=Localization["DebuffTime"],
		Min=0,
		Max=360,
		Step=1,
		Width=140,
		OffsetX=190,
		OffsetY=-85
	},


	["Aura_BuffOffsetX"]={
		Name=Localization["BuffOffsetX"],
		Min=-50,
		Max=50,
		Step=1,
		Width=70,
		OffsetX=190,
		OffsetY=-125
	},
	["Aura_BuffOffsetY"]={
		Name=Localization["BuffOffsetY"],
		Min=-50,
		Max=50,
		Step=1,
		Width=70,
		OffsetX=275,
		OffsetY=-125
	},
	["Aura_DebuffOffsetX"]={
		Name=Localization["DebuffOffsetX"],
		Min=-50,
		Max=50,
		Step=1,
		Width=70,
		OffsetX=190,
		OffsetY=-165
	},
	["Aura_DebuffOffsetY"]={
		Name=Localization["DebuffOffsetY"],
		Min=-50,
		Max=50,
		Step=1,
		Width=70,
		OffsetX=275,
		OffsetY=-165
	},

	["Aura_BuffScale"]={
		Name=Localization["BuffScale"],
		Min=0.1,
		Max=5,
		Step=0.1,
		Width=110,
		OffsetX=20,
		OffsetY=-500
	},
	["Aura_DebuffScale"]={
		Name=Localization["DebuffScale"],
		Min=0.1,
		Max=5,
		Step=0.1,
		Width=110,
		OffsetX=140,
		OffsetY=-500
	},
	["Aura_HighlightScale"]={
		Name=Localization["HighlightScale"],
		Min=0.1,
		Max=5,
		Step=0.1,
		Width=110,
		OffsetX=260,
		OffsetY=-500
	},

}

local tooltipslist={
	["Aura_Filter_BuffTime"]=Tooltips["BuffTime"],
	["Aura_Filter_DebuffTime"]=Tooltips["DebuffTime"],
}

NPA_Options:BuildSliderList("NPA_Options_Aura",mainframe,sliderlist,Options,tooltipslist)
		

NPA_Options:CreateSliderEditButton(Localization["Icon"],mainframe,"Aura_IconData",3,Options,4.2)
NPA_Options:CreateSliderEditButton(Localization["Background"],mainframe,"Aura_BackgroundData",3,Options,5.0)
NPA_Options:CreateSliderEditButton(Localization["Overlay"],mainframe,"Aura_OverlayData",3,Options,5.8)
NPA_Options:CreateSliderEditButton(Localization["Highlight"],mainframe,"Aura_HighlightData",3,Options,6.6)

NPA_Options:CreateSliderEditButton(Localization["Time"],mainframe,"Aura_TimeData",2,Options,7.9)
NPA_Options:CreateSliderEditButton(Localization["Stack"],mainframe,"Aura_StackData",2,Options,8.7)
NPA_Options:CreateSliderEditButton(Localization["Bar"],mainframe,"Aura_BarData",1,Options,9.5)



local listframe5=NPA_Options:CreateFrame("NPA_Options_Aura_Filter",mainframe)
listframe5:SetPoint("TOPLEFT",mainframe,"TOPLEFT",195,-350)
listframe5:SetWidth(180)

local checkboxdata={
	["Aura_Decile"]=Localization["Decile"],
	["Aura_BuffAnchorDebuff"]=Localization["BuffOnDebuff"],
	["Aura_DebuffAnchorBuff"]=Localization["DebuffOnBuff"],
	["Aura_ShowBar"]=Localization["ShowBar"],
	["Aura_ColorTextByTime"]=Localization["ColorTextByTime"],
	["Aura_ColorBarByTime"]=Localization["ColorBarByTime"],
	["Aura_AlterDecile"]=Localization["AlterDecile"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_Aura",listframe5,20,checkboxdata,17,Options,1)


local listframe4=NPA_Options:CreateFrame("NPA_Options_Aura_Filter",mainframe)
listframe4:SetPoint("TOPLEFT",mainframe,"TOPLEFT",5,-350)
listframe4:SetWidth(180)

local checkboxdata={
	["Aura_BuffGrowUpward"]=Localization["BuffGrowUpward"],
	["Aura_BuffGrowRightward"]=Localization["BuffGrowRightward"],
	["Aura_DebuffGrowUpward"]=Localization["DebuffGrowUpward"],
	["Aura_DebuffGrowRightward"]=Localization["DebuffGrowRightward"],
	["Aura_SortBySpellid"]=Localization["SortBySpellid"],
	["Aura_SortByTimeleft"]=Localization["SortByTimeleft"]
}

NPA_Options:BuildCheckBoxList("NPA_Options_Aura",listframe4,20,checkboxdata,17,Options,1)

local editbox=NPA_Options:CreateAnchorDropEdit("NPA_Options_Aura_Anchor",mainframe,210,22,Localization["Anchor"],"Aura_FrameAnchor")
editbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",160,-245)
table_insert(Options,editbox)

local editbox=NPA_Options:CreateAnchorDropEdit("NPA_Options_Aura_BuffAnchor",mainframe,210,22,Localization["BuffAnchor"],"Aura_BuffFrameAnchor")
editbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",160,-265)
table_insert(Options,editbox)

local editbox=NPA_Options:CreateAnchorDropEdit("NPA_Options_Aura_DebuffAnchor",mainframe,210,22,Localization["DebuffAnchor"],"Aura_DebuffFrameAnchor")
editbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",160,-285)
table_insert(Options,editbox)



---------filter
------------------buff filter
local listframe=NPA_Options:CreateFrame("NPA_Options_Aura_Buff_Filter",mainframe,Localization["BuffFilter"])
listframe:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
listframe:SetWidth(200)

local fromframe1=NPA_Options:CreateFrame("NPA_Options_Aura_Buff_FromFilter",listframe,Localization["From"])
fromframe1:SetPoint("TOPLEFT",listframe,"TOPLEFT",3,-23)
fromframe1:SetPoint("TOPRIGHT",listframe,"TOPRIGHT",-3,-23)
local checkboxdata={
	["Aura_Filter_Buff_FromSelf"]=Localization["Self"],
	["Aura_Filter_Buff_FromPet"]=Localization["Pet"],
	["Aura_Filter_Buff_FromTarget"]=Localization["Target"],
	["Aura_Filter_Buff_FromFocus"]=Localization["Focus"],
	["Aura_Filter_Buff_FromMouseover"]=Localization["Mouseover"],
	["Aura_Filter_Buff_FromHostilePlayer"]=Localization["HostilePlayer"],
	["Aura_Filter_Buff_FromHostileNonPlayer"]=Localization["HostileNonPlayer"],
	["Aura_Filter_Buff_FromNonHostilePlayer"]=Localization["NonHostilePlayer"],
	["Aura_Filter_Buff_FromNonHostileNonPlayer"]=Localization["NonHostileNonPlayer"],
}
NPA_Options:BuildCheckBoxList("NPA_Options_Aura_Buff_From",fromframe1,20,checkboxdata,17,Options,1)
---
local toframe1=NPA_Options:CreateFrame("NPA_Options_Aura_Buff_ToFilter",listframe,Localization["To"])
toframe1:SetPoint("TOPLEFT",fromframe1,"BOTTOMLEFT",0,-23)
toframe1:SetPoint("TOPRIGHT",fromframe1,"BOTTOMRIGHT",0,-23)
local checkboxdata={
	["Aura_Filter_Buff_ToSelf"]=Localization["Self"],
	["Aura_Filter_Buff_ToPet"]=Localization["Pet"],
	["Aura_Filter_Buff_ToTarget"]=Localization["Target"],
	["Aura_Filter_Buff_ToFocus"]=Localization["Focus"],
	["Aura_Filter_Buff_ToMouseover"]=Localization["Mouseover"],
	["Aura_Filter_Buff_ToHostilePlayer"]=Localization["HostilePlayer"],
	["Aura_Filter_Buff_ToHostileNonPlayer"]=Localization["HostileNonPlayer"],
	["Aura_Filter_Buff_ToNonHostilePlayer"]=Localization["NonHostilePlayer"],
	["Aura_Filter_Buff_ToNonHostileNonPlayer"]=Localization["NonHostileNonPlayer"],
}
NPA_Options:BuildCheckBoxList("NPA_Options_Aura_Buff_To",toframe1,20,checkboxdata,17,Options,1)

listframe:SetHeight(fromframe1:GetHeight()+toframe1:GetHeight()+50)

--------------------debuff filter

local listframe3=NPA_Options:CreateFrame("NPA_Options_Aura_DebuffFilter",mainframe,Localization["DebuffFilter"])
listframe3:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
listframe3:SetWidth(200)

local fromframe2=NPA_Options:CreateFrame("NPA_Options_Aura_Debuff_FromFilter",listframe3,Localization["From"])
fromframe2:SetPoint("TOPLEFT",listframe3,"TOPLEFT",3,-23)
fromframe2:SetPoint("TOPRIGHT",listframe3,"TOPRIGHT",-3,-23)
local checkboxdata={
	["Aura_Filter_Debuff_FromSelf"]=Localization["Self"],
	["Aura_Filter_Debuff_FromPet"]=Localization["Pet"],
	["Aura_Filter_Debuff_FromTarget"]=Localization["Target"],
	["Aura_Filter_Debuff_FromFocus"]=Localization["Focus"],
	["Aura_Filter_Debuff_FromMouseover"]=Localization["Mouseover"],
	["Aura_Filter_Debuff_FromHostilePlayer"]=Localization["HostilePlayer"],
	["Aura_Filter_Debuff_FromHostileNonPlayer"]=Localization["HostileNonPlayer"],
	["Aura_Filter_Debuff_FromNonHostilePlayer"]=Localization["NonHostilePlayer"],
	["Aura_Filter_Debuff_FromNonHostileNonPlayer"]=Localization["NonHostileNonPlayer"],
}
NPA_Options:BuildCheckBoxList("NPA_Options_Aura_Debuff_From",fromframe2,20,checkboxdata,17,Options,1)
---
local toframe2=NPA_Options:CreateFrame("NPA_Options_Aura_ToFilter",listframe3,Localization["To"])
toframe2:SetPoint("TOPLEFT",fromframe2,"BOTTOMLEFT",0,-23)
toframe2:SetPoint("TOPRIGHT",fromframe2,"BOTTOMRIGHT",0,-23)
local checkboxdata={
	["Aura_Filter_Debuff_ToSelf"]=Localization["Self"],
	["Aura_Filter_Debuff_ToPet"]=Localization["Pet"],
	["Aura_Filter_Debuff_ToTarget"]=Localization["Target"],
	["Aura_Filter_Debuff_ToFocus"]=Localization["Focus"],
	["Aura_Filter_Debuff_ToMouseover"]=Localization["Mouseover"],
	["Aura_Filter_Debuff_ToHostilePlayer"]=Localization["HostilePlayer"],
	["Aura_Filter_Debuff_ToHostileNonPlayer"]=Localization["HostileNonPlayer"],
	["Aura_Filter_Debuff_ToNonHostilePlayer"]=Localization["NonHostilePlayer"],
	["Aura_Filter_Debuff_ToNonHostileNonPlayer"]=Localization["NonHostileNonPlayer"],
}
NPA_Options:BuildCheckBoxList("NPA_Options_Debuff_To",toframe2,20,checkboxdata,17,Options,1)

listframe3:SetHeight(fromframe2:GetHeight()+toframe2:GetHeight()+50)

------------------------------school filter
local listframe2=NPA_Options:CreateFrame("NPA_Options_Aura_SchoolFilter",mainframe,Localization["SchoolFilter"])
listframe2:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
--listframe2:SetPoint("BOTTOMLEFT",mainframe,"BOTTOMRIGHT",10,0)
listframe2:SetWidth(200)

local checkboxdata={
	["Aura_Filter_Magic"]=Localization["Magic"],
	["Aura_Filter_Poison"]=Localization["Poison"],
	["Aura_Filter_Disease"]=Localization["Disease"],
	["Aura_Filter_Stealable"]=Localization["Stealable"],
	["Aura_Filter_Curse"]=Localization["Curse"],
	["Aura_Filter_Physic"]=Localization["Physic"],
	["Aura_Filter_Enrage"]=Localization["Enrage"],
	["Aura_ColorBackground"]=Localization["ColorBackground"],
	["Aura_ColorHighlight"]=Localization["ColorHighlight"],
	["Aura_ColorBar"]=Localization["ColorBar"],
	["Aura_ColorMagic"]=Localization["ColorMagic"],
	["Aura_ColorPoison"]=Localization["ColorPoison"],
	["Aura_ColorDisease"]=Localization["ColorDisease"],
	["Aura_ColorCurse"]=Localization["ColorCurse"],
	["Aura_ColorPhysic"]=Localization["ColorPhysic"],
	["Aura_ColorEnrage"]=Localization["ColorEnrage"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_Aura",listframe2,20,checkboxdata,17,Options,1)

---------------highlight filter

local listframe4=NPA_Options:CreateFrame("NPA_Options_Aura_Filter",mainframe,Localization["Highlight"])
listframe4:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)
--listframe4:SetPoint("BOTTOMLEFT",mainframe,"BOTTOMRIGHT",10,0)
listframe4:SetWidth(200)

local checkboxdata={
	["Aura_UseHighlightScale"]=Localization["UseHighlightScale"],
	["Aura_Highlight"]=Localization["UseHighlight"],
	["Aura_Filter_Highlight_Magic"]=Localization["Magic"],
	["Aura_Filter_Highlight_Poison"]=Localization["Poison"],
	["Aura_Filter_Highlight_Disease"]=Localization["Disease"],
	["Aura_Filter_Highlight_Physic"]=Localization["Physic"],
	["Aura_Filter_Highlight_Curse"]=Localization["Curse"],
	["Aura_Filter_Highlight_Enrage"]=Localization["Enrage"],
	["Aura_Filter_Highlight_Stealable"]=Localization["Stealable"],
	["Aura_Filter_Highlight_Mine"]=Localization["Mine"],
	["Aura_Filter_Highlight_Other"]=Localization["Other"],
}

NPA_Options:BuildCheckBoxList("NPA_Options_Aura",listframe4,20,checkboxdata,17,Options,1)

-------------------------------------
local FromList={
		["Self"]=Localization["Self"],
		["Pet"]=Localization["Pet"],
		["Target"]=Localization["Target"],
		["Focus"]=Localization["Focus"],
		["Mouseover"]=Localization["Mouseover"],
		["HostilePlayer"]=Localization["HostilePlayer"],
		["HostileNonPlayer"]=Localization["HostileNonPlayer"],
		["NonHostilePlayer"]=Localization["NonHostilePlayer"],
		["NonHostileNonPlayer"]=Localization["NonHostileNonPlayer"],
	}
------------------------whitelist filter
local listframe5=NPA_Options:CreateFrame("NPA_Options_Aura_Whitelist_Filter",mainframe,Localization["WhiteList"],1)
listframe5:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)

--------------------whitelist
------------------------------------
local whitelist=NPA_Options:CreateCheckListEdit3("NPA_Options_Aura_Filter_WhiteList",listframe5,Localization["From"],Localization["To"],"Aura_Filter_WhiteList_Spellid",FromList,FromList)
whitelist:SetPoint("TOPLEFT",listframe5,"TOPLEFT",3,-3)

listframe5:SetHeight(whitelist:GetHeight()+10)
listframe5:SetWidth(whitelist:GetWidth()+10)

------------------------blacklist filter
local listframe6=NPA_Options:CreateFrame("NPA_Options_Aura_Blacklist_Filter",mainframe,Localization["BlackList"],1)
listframe6:SetPoint("TOPLEFT",mainframe,"TOPRIGHT",10,0)

--------------------blacklist
------------------------------------
local blacklist=NPA_Options:CreateCheckListEdit3("NPA_Options_Aura_Filter_BlackList",listframe6,Localization["From"],Localization["To"],"Aura_Filter_BlackList_Spellid",FromList,FromList)
blacklist:SetPoint("TOPLEFT",listframe6,"TOPLEFT",3,-3)

listframe6:SetHeight(blacklist:GetHeight()+10)
listframe6:SetWidth(blacklist:GetWidth()+10)

-------------------------------------

mainframe:HookScript("OnShow",function()
		listframe:Show()
		listframe2:Show()
		listframe3:Show()
		listframe4:Show()
		listframe5:Show()
		listframe6:Show()

		listframe:Hide()
		listframe2:Hide()
		listframe3:Hide()
		listframe4:Hide()
		listframe5:Hide()
		listframe6:Hide()
	end)

local button1=NPA_Options:CreateButton("NPA_Options_Aura_Button1",mainframe,0,21,Localization["BuffFilter"])
button1:SetPoint("TOPLEFT",mainframe,"TOPLEFT",370,-5)
button1:SetPoint("TOPRIGHT",mainframe,"TOPRIGHT",-5,-5)
button1:SetScript("OnClick",function()
		if(listframe:IsShown())then
			listframe:Hide()
		else
			listframe:Show()
		end
		listframe2:Hide()
		listframe3:Hide()
		listframe4:Hide()
		listframe5:Hide()
		listframe6:Hide()
	end)
local button2=NPA_Options:CreateButton("NPA_Options_Aura_Button2",mainframe,0,21,Localization["DebuffFilter"])
button2:SetPoint("TOPLEFT",button1,"BOTTOMLEFT",0,-3)
button2:SetPoint("TOPRIGHT",button1,"BOTTOMRIGHT",0,-3)
button2:SetScript("OnClick",function()
		listframe:Hide()
		listframe2:Hide()
		if(listframe3:IsShown())then
			listframe3:Hide()
		else
			listframe3:Show()
		end
		listframe4:Hide()
		listframe5:Hide()
		listframe6:Hide()
	end)

local button3=NPA_Options:CreateButton("NPA_Options_Aura_Button3",mainframe,0,21,Localization["SchoolFilter"])
button3:SetPoint("TOPLEFT",button2,"BOTTOMLEFT",0,-3)
button3:SetPoint("TOPRIGHT",button2,"BOTTOMRIGHT",0,-3)
button3:SetScript("OnClick",function()
		listframe:Hide()
		if(listframe2:IsShown())then
			listframe2:Hide()
		else
			listframe2:Show()
		end
		listframe3:Hide()
		listframe4:Hide()
		listframe5:Hide()
		listframe6:Hide()
	end)
local button4=NPA_Options:CreateButton("NPA_Options_Aura_Button4",mainframe,0,21,Localization["Highlight"])
button4:SetPoint("TOPLEFT",button3,"BOTTOMLEFT",0,-3)
button4:SetPoint("TOPRIGHT",button3,"BOTTOMRIGHT",0,-3)
button4:SetScript("OnClick",function()
		listframe:Hide()
		listframe2:Hide()
		listframe3:Hide()
		if(listframe4:IsShown())then
			listframe4:Hide()
		else
			listframe4:Show()
		end
		listframe5:Hide()
		listframe6:Hide()
	end)

local button5=NPA_Options:CreateButton("NPA_Options_Aura_Button5",mainframe,0,21,Localization["WhiteList"])
button5:SetPoint("TOPLEFT",button4,"BOTTOMLEFT",0,-3)
button5:SetPoint("TOPRIGHT",button4,"BOTTOMRIGHT",0,-3)
button5:SetScript("OnClick",function()
		listframe:Hide()
		listframe2:Hide()
		listframe3:Hide()
		listframe4:Hide()
		if(listframe5:IsShown())then
			listframe5:Hide()
		else
			listframe5:Show()
		end
		listframe6:Hide()
	end)

local button6=NPA_Options:CreateButton("NPA_Options_Aura_Button6",mainframe,0,21,Localization["BlackList"])
button6:SetPoint("TOPLEFT",button5,"BOTTOMLEFT",0,-3)
button6:SetPoint("TOPRIGHT",button5,"BOTTOMRIGHT",0,-3)
button6:SetScript("OnClick",function()
		listframe:Hide()
		listframe2:Hide()
		listframe3:Hide()
		listframe4:Hide()
		listframe5:Hide()
		if(listframe6:IsShown())then
			listframe6:Hide()
		else
			listframe6:Show()
		end
	end)


local scalelist=NPA_Options:CreateEditList("NPA_Options_Aura_ScaleList",mainframe,Localization["ScaleList"],Localization["SpellId"],Localization["Scale"],"Aura_ScaleList")
scalelist:SetPoint("BOTTOMRIGHT",mainframe,"BOTTOMRIGHT",-5,5)

local highlightlist=NPA_Options:CreateEditList("NPA_Options_Aura_ScaleList",listframe4,Localization["HighlightList"],Localization["SpellId"],nil,"Aura_HighlightList")
highlightlist:SetPoint("TOPLEFT",listframe4,"BOTTOMLEFT",5,-5)
highlightlist.Box2:Hide()
highlightlist.Box2:SetText(1)
highlightlist:SetHeight(90)
end