-- Author      : Nogarder
-- Create Date : 2010/6/26 15:47:34
NPA_Version="2011.12.2"


local select, UnitBuff, UnitDebuff, UnitAura, tonumber, strfind, hooksecurefunc =
	select, UnitBuff, UnitDebuff, UnitAura, tonumber, strfind, hooksecurefunc

-- get global functions
local ipairs = ipairs
local pairs = pairs
local select = select
local tostring = tostring
local floor = floor
local table_getn = table.getn
local table_insert = table.insert
local table_remove = table.remove
local tonumber=tonumber
local bit_band=bit.band
local COMBATLOG_OBJECT_TYPE_PLAYER=COMBATLOG_OBJECT_TYPE_PLAYER
local COMBATLOG_OBJECT_TYPE_PET=COMBATLOG_OBJECT_TYPE_PET
local COMBATLOG_OBJECT_TYPE_GUARDIAN=COMBATLOG_OBJECT_TYPE_GUARDIAN

local sqrt=sqrt
local string_gsub=string.gsub
local string_gmatch=string.gmatch
local mod=mod

local cos=cos
local sin=sin
local abs=abs
local max=max
local min=min

local CopyTable=CopyTable

local _,_,_,interfaceversion=GetBuildInfo()
NPA_Core={}

--config
local NPA_Core_DefaultSetting={
	["UnitData_UpdateInterval"]=0.2,
	["Frame_UpdateInterval"]=0.03,
	["GlobalSize"]=1,
	["idtip"]=1,
	["PowerMatch"]=1,
	["Enabled"]=1,

	["EnableModule"]={
		["Aura"]=1,
		["AutoHide"]=1,
		["CastWarning"]=1,
		["ClassIcon"]=1,
		["ComboPoint"]=1,
		["CoolDown"]=1,
		["CrowdControl"]=1,
		["HealthBar"]=1,
		["ManaBar"]=1,
		["RaidIcon"]=1,
		["ScrollText"]=1,
		["Speed"]=0,
		["Target"]=1,
		["Threat"]=1,
		["QuestMark"]=1,
		["RangeCheck"]=1,
		["Tracker"]=1,
		["CounterSpell"]=1,
		["ClassInfo"]=1,
		["NameText"]=1,
		["TargetCount"]=1,
		["ShieldWatch"]=1,
		["exCombat"]=1,
		["RoleCheck"]=0,
		DeepCheck=1
	},

	["MainModuleList"]={
		["Aura"]=1,
		["AutoHide"]=1,
		["CastWarning"]=1,
		["ClassIcon"]=1,
		["ComboPoint"]=1,
		["CoolDown"]=1,
		["CrowdControl"]=1,
		["HealthBar"]=1,
		["ManaBar"]=1,
		["RaidIcon"]=1,
		["ScrollText"]=1,
		["Speed"]=0,
		["Target"]=1,
		["Threat"]=1,
		["QuestMark"]=1,
		["RangeCheck"]=1,
		["Tracker"]=1,
		["CounterSpell"]=1,
		["ClassInfo"]=1,
		["NameText"]=1,
		["TargetCount"]=1,
		["ShieldWatch"]=1,
		["exCombat"]=1,
		["RoleCheck"]=0,
		DeepCheck=1
	},
	["HostilePlayerModuleList"]={
		["Aura"]=1,
		["AutoHide"]=1,
		["CastWarning"]=1,
		["ClassIcon"]=1,
		["ComboPoint"]=1,
		["CoolDown"]=1,
		["CrowdControl"]=1,
		["HealthBar"]=1,
		["ManaBar"]=1,
		["RaidIcon"]=1,
		["ScrollText"]=1,
		["Speed"]=0,
		["Target"]=1,
		["Threat"]=1,
		["QuestMark"]=1,
		["RangeCheck"]=1,
		["Tracker"]=1,
		["CounterSpell"]=1,
		["ClassInfo"]=1,
		["NameText"]=1,
		["TargetCount"]=1,
		["ShieldWatch"]=1,
		["exCombat"]=1,
		["RoleCheck"]=0,
		DeepCheck=1
	},
	["NonHostilePlayerModuleList"]={
		["Aura"]=1,
		["AutoHide"]=1,
		["CastWarning"]=1,
		["ClassIcon"]=1,
		["ComboPoint"]=1,
		["CoolDown"]=1,
		["CrowdControl"]=1,
		["HealthBar"]=1,
		["ManaBar"]=1,
		["RaidIcon"]=1,
		["ScrollText"]=1,
		["Speed"]=0,
		["Target"]=1,
		["Threat"]=1,
		["QuestMark"]=1,
		["RangeCheck"]=1,
		["Tracker"]=1,
		["CounterSpell"]=1,
		["ClassInfo"]=1,
		["NameText"]=1,
		["TargetCount"]=1,
		["ShieldWatch"]=1,
		["exCombat"]=1,
		["RoleCheck"]=0,
		DeepCheck=1
	},
	["HostileNonPlayerModuleList"]={
		["Aura"]=1,
		["AutoHide"]=1,
		["CastWarning"]=1,
		["ClassIcon"]=1,
		["ComboPoint"]=1,
		["CoolDown"]=1,
		["CrowdControl"]=1,
		["HealthBar"]=1,
		["ManaBar"]=1,
		["RaidIcon"]=1,
		["ScrollText"]=1,
		["Speed"]=0,
		["Target"]=1,
		["Threat"]=1,
		["QuestMark"]=1,
		["RangeCheck"]=1,
		["Tracker"]=1,
		["CounterSpell"]=1,
		["ClassInfo"]=1,
		["NameText"]=1,
		["TargetCount"]=1,
		["ShieldWatch"]=1,
		["exCombat"]=1,
		["RoleCheck"]=0,
		DeepCheck=1
	},
	["NonHostileNonPlayerModuleList"]={
		["Aura"]=1,
		["AutoHide"]=1,
		["CastWarning"]=1,
		["ClassIcon"]=1,
		["ComboPoint"]=1,
		["CoolDown"]=1,
		["CrowdControl"]=1,
		["HealthBar"]=1,
		["ManaBar"]=1,
		["RaidIcon"]=1,
		["ScrollText"]=1,
		["Speed"]=0,
		["Target"]=1,
		["Threat"]=1,
		["QuestMark"]=1,
		["RangeCheck"]=1,
		["Tracker"]=1,
		["CounterSpell"]=1,
		["ClassInfo"]=1,
		["NameText"]=1,
		["TargetCount"]=1,
		["ShieldWatch"]=1,
		["exCombat"]=1,
		["RoleCheck"]=0,
		DeepCheck=1
	},

	["CleanUp"]=0,
	["CleanUpTimer"]=120,

	["SeparateModuleList"]=0,
	["SychonizeAnimation"]=0,

	["OnlySelected"]=0,
	
	["OffsetX"]=0,
	["OffsetY"]=0,

	["SaveData"]=0,

	["CollectHostile"]=1,
	["CollectNonHostile"]=1,
	["CollectUnitFromCombatLog"]=1,
	["CollectAuraFromCombatLog"]=1,
	["ClearDataWhenEnteringArena"]=1,

	["NotClassColor"]=1,

	["LayerData"]={
		["Target"]=1,
		["Mouseover"]=2,
		["Focus"]=3,
		DeepCheck=1,
		},
	["Data_AlterInstant"]=0,

	["Data_Filter"]={
		["Aura"]=1,
		["Casting"]=1,
		["Target"]=1,
		["Speed"]=1,
		["Position"]=1,
		["Range"]=1,
		["Portrait"]=1,
		["Threat"]=1,
		["Tapped"]=1,
		["TargetCount"]=1,
		["GuessHealth"]=1,
		["NameGuild"]=1,
		["Class"]=1,
		["Resource"]=1,
		["Combat"]=1,
		["Raid"]=1,
		["PvP"]=1,
		["Level"]=1,
		DeepCheck=1,
		},

}

local NPA_Core_Config=CopyTable(NPA_Core_DefaultSetting)

function NPA_Core:ResetConfig()
	NPA_Config["Core"]=CopyTable(NPA_Core_DefaultSetting)
end

if(NPA_Config==nil)then
	NPA_Config={}
end


--unitdata
local NPA_UnitData={}

local NPA_Core_Frame={}


local NPA_UnitData_NameToGUID={}

local NPA_UnitData_FrameLookUpData={}

local GetTime = GetTime

local UnitName=UnitName
local UnitSex=UnitSex
local UnitHealth=UnitHealth
local UnitHealthMax=UnitHealthMax
local UnitMana=UnitMana
local UnitManaMax=UnitManaMax
		
local GetUnitSpeed=GetUnitSpeed
local UnitAffectingCombat=UnitAffectingCombat
local UnitClass=UnitClass
local UnitClassification=UnitClassification
local UnitCreatureFamily=UnitCreatureFamily
local UnitCreatureType=UnitCreatureType
local UnitPowerType=UnitPowerType
local UnitInParty=UnitInParty
local UnitInRaid=UnitInRaid
local UnitCharmed=UnitIsCharmed
local UnitConnected=UnitIsConnected
local UnitIsEnemy=UnitIsEnemy
local UnitIsFriend=UnitIsFriend
local UnitIsPvP=UnitIsPVP
local UnitIsPlayer=UnitIsPlayer
local UnitLevel=UnitLevel

local UnitBuff=UnitBuff
local UnitAura=UnitAura
local UnitDebuff=UnitDebuff

local UnitCastingInfo=UnitCastingInfo

--other global stuff
local WorldFrame = WorldFrame

local NPA_Core_IsInArena
local NPA_Core_IsInBattleground

--nameplate main frame
local NPA_NumChildren=0

NPA_Core.GUIDToFrame={}
local GUIDToFrame=NPA_Core.GUIDToFrame

NPA_Core.CombatEventFunc={}

local NPA_GUIDMatched={}

local NPA_NameHealthToGUID={}

--targetcount
local NPA_Core_TargetCount={}


--range check and team pointer 
local NPA_RangeCheckData={}
local NPA_Core_MapScale=1
local NPA_Core_LastPosition={X=0,Y=0}
local NPA_Core_LastSpeed =0

local NPA_Core_Hooks={}
local NPA_Core_ModuleList={}
local NPA_Core_GUIDModules={}
local NPA_Core_FrameModules={}
local NPA_Core_Back_FrameModules={}
local NPA_Core_Back_GUIDModules={}

NPA_Core.Aura_Duration_Cache={}
NPA_Core.SpellData={}

	-- index=[hostile]  [player]
	--[0][0]=frienly + non-player
	--[0][1]=frienly + player
	--[1][1]=hostile + player

local NPA_Core_EnabledModuleList={
	[0]={
		[0]={},
		[1]={}
		},
	[1]={
		[0]={},
		[1]={}
		},
	}

local NPA_Core_MainEnabledModuleList={}

local NPA_Core_TypeCache={}


local NPA_Core_GuildNameCache={}
local NPA_Core_FriendNameCache={}
local NPA_Core_PartyNameCache={}
local NPA_Core_RaidNameCache={}

local NPA_Core_TextureList={}

local NPA_CachePortrait=0
local NPA_PortraitModuleList={}

local NPA_Core_LayerList={}
----------------------
function NPA_Core.RequestPortrait(_,modulename,number)
	NPA_PortraitModuleList[modulename]=(number or 1)
	NPA_CachePortrait=0
	for _,value in pairs(NPA_PortraitModuleList) do
		NPA_CachePortrait=NPA_CachePortrait+value
	end
end
function NPA_Core.UnrequestPortrait(_,modulename)
	NPA_PortraitModuleList[modulename]=nil
	NPA_CachePortrait=0
	for name,value in pairs(NPA_PortraitModuleList) do
		NPA_CachePortrait=NPA_CachePortrait+1
	end
end

local function NPA_Core_Rotation(x,y,angle)
	local ca=floor(cos(angle)*1000)/1000
	local sa=floor(sin(angle)*1000)/1000
	return x*ca-y*sa,x*sa+y*ca
end

local function NPA_Core_SetTextureRotation(texture,left,right,top,bottom,angle)
	local centerx=(left+right)/2
	local centery=(top+bottom)/2

	local dleft=left-centerx
	local dright=right-centerx
	local dtop=top-centery
	local dbottom=bottom-centery
	
	local tlx,tly=NPA_Core_Rotation(dleft,dtop,angle)
	local blx,bly=NPA_Core_Rotation(dleft,dbottom,angle)
	local trx,try=NPA_Core_Rotation(dright,dtop,angle)
	local brx,bry=NPA_Core_Rotation(dright,dbottom,angle)

	texture.Centerx, texture.Centery = centerx,centery
	texture.TLx=tlx
	texture.BLx=blx
	texture.TRx=trx
	texture.BRx=brx
	texture.DWidth=(right-left)/2

	tlx=tlx+centerx
	tly=tly+centery
	blx=blx+centerx
	bly=bly+centery
	trx=trx+centerx
	try=try+centery
	brx=brx+centerx
	bry=bry+centery

	texture.TLy=tly
	texture.BLy=bly
	texture.TRy=try
	texture.BRy=bry

	texture:SetTexCoord(tlx,tly,blx,bly,trx,try,brx,bry)
end
local function NPA_Core_GetRotationCoord(left,right,top,bottom,angle)
	local centerx=(left+right)/2
	local centery=(top+bottom)/2

	local dleft=left-centerx
	local dright=right-centerx
	local dtop=top-centery
	local dbottom=bottom-centery
	
	local tlx,tly=NPA_Core_Rotation(dleft,dtop,angle)
	local blx,bly=NPA_Core_Rotation(dleft,dbottom,angle)
	local trx,try=NPA_Core_Rotation(dright,dtop,angle)
	local brx,bry=NPA_Core_Rotation(dright,dbottom,angle)

	tlx=tlx+centerx
	tly=tly+centery
	blx=blx+centerx
	bly=bly+centery
	trx=trx+centerx
	try=try+centery
	brx=brx+centerx
	bry=bry+centery

	return tly,bly,try,bry
end

local function NPA_Core_PremadeAnimData(texture,texturedata)
	if(not texture)then
		return
	end
	local path=texturedata.Texture

	if(path and strfind(path,"@"))then
		for count,step,time in string_gmatch(path,"@(%d+)@(%d+)@(%d+)") do
			if(count~=0 and step~=0 and time~=0)then
				local data
				data={
					Step=step-1,
					Time=100/time,
				}

				if(NPA_Core_Config["SychonizeAnimation"]==1)then
					data.Offset=0
				else
					data.Offset=random()
				end

				local angle=texture.Angle

				NPA_Core_TextureList[texture]=data
				
				local height=1/step
	
				texture.AData={}
	
				if(angle)then
					local tly,bly,try,bry=NPA_Core_GetRotationCoord(texturedata.Left,texturedata.Right,texturedata.Top,texturedata.Bottom,angle)
					tly=tly/step
					bly=bly/step
					try=try/step
					bry=bry/step
					for i=0,step-1 do
						texture.AData[i]={
							TLy=tly+height*(i+1),
							BLy=bly+height*(i+1),
							TRy=try+height*(i+1),
							BRy=bry+height*(i+1)
						}
							
					end
				else
					local top=(texturedata.Top or 0)/step
					local bottom=(texturedata.Bottom or 1)/step
					for i=0,step-1 do
						texture.AData[i]={
							Top=top+height*(i+1),
							Bottom=bottom+height*(i+1),
							}
					end
				end

				break
			end
		end
		
		path=string_gsub(path,"@%d+@%d+@%d+","")
		texture:SetTexture(path)
	else
		texture:SetTexture(path)
		NPA_Core_TextureList[texture]=nil
	end
end


function NPA_Core_BoxRotation(width,height,angle)
	local ax=width/2
	local ay=height/2

	local tlx,tly=NPA_Core_Rotation(-ax,-ay,angle)
	local llx,lly=NPA_Core_Rotation(-ax,ay,angle)
	local trx,try=NPA_Core_Rotation(ax,-ay,angle)
	local lrx,lry=NPA_Core_Rotation(ax,ay,angle)

	local rwidth=max(tlx,llx,trx,lrx)*2
	local rheight=max(tly,lly,try,lry)*2

	return rwidth,rheight
end

function NPA_Core:TextureManager(texture,path,angle)
	if(texture and path and strfind(path,"@"))then
		for count,step,time in string_gmatch(path,"@(%d+)@(%d+)@(%d+)") do
			if(count~=0 and step~=0 and time~=0)then
				local data
				data={
					Step=step-1,
					Time=100/time,
				}

				if(NPA_Core_Config["SychonizeAnimation"]==1)then
					data.Offset=0
				else
					data.Offset=random()
				end

	
				NPA_Core_TextureList[texture]=data
				
				local height=1/step
	
				texture.AData={}
	
				if(angle)then
					local tly,bly,try,bry=NPA_Core_GetRotationCoord(0,1,0,1,angle)
					tly=tly/step
					bly=bly/step
					try=try/step
					bry=bry/step
					for i=0,step-1 do
						texture.AData[i]={
							TLy=tly+height*(i+1),
							BLy=bly+height*(i+1),
							TRy=try+height*(i+1),
							BRy=bry+height*(i+1)
						}
							
					end
				else
					local top=(0)/step
					local bottom=(1)/step
					for i=0,step-1 do
						texture.AData[i]={
							Top=top+height*(i+1),
							Bottom=bottom+height*(i+1),
							}
					end
				end

				break
			end
		end

		path=string_gsub(path,"@%d+@%d+@%d+","")
		texture:SetTexture(path)

	else
		texture:SetTexture(path)
		NPA_Core_TextureList[texture]=nil
	end
end
function NPA_Core:TextureManager2(texture,data,frame,switch)
	if(data)then
		texture:SetBlendMode(data.TextureBlend)
		texture:SetVertexColor(data.Red,data.Green,data.Blue,data.Alpha)
		texture.R=data.Red
		texture.G=data.Green
		texture.B=data.Blue

		texture.Anchor=data.Anchor or "CENTER"
		texture.ToAnchor=data.Toanchor or "CENTER"
		texture.Parent=frame
	
		if(switch==1)then
			texture.Width=data.Width
			texture.Percent=texture.Percent or 0
			texture.OffsetX=data.OffsetX
			texture.OffsetY=data.OffsetY
		elseif(frame)then
			texture:ClearAllPoints()
			texture:SetPoint(texture.Anchor,texture.Parent,texture.ToAnchor,data.OffsetX,data.OffsetY)
		end

		texture:SetHeight(data.Height)
		texture:SetWidth(data.Width)

		local angle=data.RAngle
		if(angle==nil or angle==0)then
			texture.IsBar=nil
			texture.Angle=nil
			texture.TWidth=data.Right-data.Left
			texture.TLeft=data.Left
			texture:SetTexCoord(data.Left,data.Right,data.Top,data.Bottom)
	
			if(switch==1)then
				local offsetx=-data.Width/2
				NPA_Core:ManageBar(texture)
				texture:ClearAllPoints()
				texture:SetPoint(texture.Anchor,texture.Parent,texture.ToAnchor,data.OffsetX+offsetx,data.OffsetY)
			end
		else
			texture.IsBar=1
			texture.Height=data.Height
			texture.Width=data.Width

			texture.Angle=angle
			NPA_Core_SetTextureRotation(texture,data.Left,data.Right,data.Top,data.Bottom,angle)
			
			if(switch==1)then
				texture:ClearAllPoints()
				NPA_Core:ManageBar(texture)
			end
		end

		if(switch~=2)then
			NPA_Core_PremadeAnimData(texture,data)
		end
	end
end

local function NPA_Core_SetBarPercent(bar)
	local ax=(bar.Percent-1)

	local dcenterx = bar.Centerx + ax * bar.DWidth
	local scalex=(1-abs(ax))
	local tlx,tly = bar.TLx * scalex, bar.TLy
	local blx,bly = bar.BLx * scalex, bar.BLy
	local trx,try = bar.TRx * scalex, bar.TRy
	local brx,bry = bar.BRx * scalex, bar.BRy

	tlx=tlx+dcenterx
	blx=blx+dcenterx
	trx=trx+dcenterx
	brx=brx+dcenterx

	bar:SetTexCoord(tlx,tly,blx,bly,trx,try,brx,bry)
end

local function NPA_Core_SetBarPosition(bar)
	local percent=bar.Percent

	local ax,ay=NPA_Core_Rotation(percent-1,0,bar.Angle)
	local width,height=bar.Width,bar.Height
	local dcenterx=bar.OffsetX + ax * width /2
	local dcentery=bar.OffsetY + ay * height /2
	local scalex=(1-abs(ax))
	local scaley=(1-abs(ay))
	local dwidth=width*scalex
	local dheight=height*scaley
	
	bar:SetPoint(bar.Anchor,bar.Parent,bar.ToAnchor,dcenterx,dcentery)
	bar:SetHeight(dheight)
	bar:SetWidth(dwidth)
end

function NPA_Core:ManageBar(bar,color)
	local percent=bar.Percent or 0
	if(percent<=0)then
		bar.Percent=0
		bar:Hide()
		return
	elseif(percent>1)then
		percent=1
		bar.Percent=1
	end

	if(bar.Angle)then
		NPA_Core_SetBarPercent(bar)
		NPA_Core_SetBarPosition(bar)
		bar:Show()
	else
		local ax=bar.Width*(percent-1)/2
		local length=bar.Width*percent
		local _,top,_,bottom=bar:GetTexCoord()
		local left=bar.TLeft
		local width=bar.TWidth
		bar:SetTexCoord(left,left+width*percent,top,bottom)
		bar:SetWidth(length)
		bar:SetPoint(bar.Anchor,bar.Parent,bar.ToAnchor,bar.OffsetX+ax,bar.OffsetY)
		bar:Show()
	end

	if(color==1)then
		bar:SetVertexColor(bar.R*(1-percent),bar.G*percent,bar.B)
	end
end

function NPA_Core:FontManager(font,data,frame)
	if(data)then
		font:SetFont(data.Font,data.Size,data.Mode)
		font:ClearAllPoints()
		font:SetPoint(data.Anchor,frame,data.ToAnchor,data.OffsetX,data.OffsetY)
		font:SetTextColor(data.Red,data.Green,data.Blue)
		font:SetShadowOffset(data.ShadowX,data.ShadowY)

		font.R=data.Red
		font.G=data.Green
		font.B=data.Blue
	end
end

local ManageTexture=NPA_Core.TextureManager2

function NPA_Core.BindPortrait(guid,portrait,frame,portraitdata)
	if((not portrait))then
		return
	end

	local por=frame.Portrait
	if(por and frame.PortraitGUID==guid and por.Binded==frame)then
		frame.Portrait:Show()
	else
		if(por and por.Binded==frame)then
			por:Hide()
			por.Binded=nil
		end

		for _,ins in pairs(portrait) do
			if((not ins:IsVisible()) or (not ins.Binded))then
				ins.Binded=frame

				ins:SetParent(frame)

				ManageTexture(nil,ins,portraitdata,"CENTER",frame,"CENTER",2)

				frame.Portrait=ins
				frame.PortraitGUID=guid
	
				ins:Show()

				return
			end
		end
		frame.Portrait=nil
		frame.PortraitGUID=nil
	end
end
function NPA_Core.UnbindPortrait(frame)
	frame.PortraitGUID=nil
	local portrait=frame.Portrait
	if(portrait)then
		portrait:Hide()
		portrait.Binded=nil
	end
end


function NPA_Core:AddModule(name,main)
	NPA_Core_ModuleList[name]=main
end

NPA_Core:AddModule("Core",NPA_Core)

function NPA_Core:AddHook(name,func)
	NPA_Core_Hooks[name]=func
end
function NPA_Core:HookUpdate(key,func,type)
	if(type==1)then
		NPA_Core_FrameModules[key]=func
		NPA_Core_Back_FrameModules[key]=func
	elseif(type==2)then
		NPA_Core_GUIDModules[key]=func
		NPA_Core_Back_GUIDModules[key]=func
	end
end

function NPA_Core:ApplyModuleConfig(name)
	if(NPA_Core_ModuleList[name] and NPA_Core_ModuleList[name]:ApplyConfig())then
		NPA_Core_ModuleList[name]:ApplyConfig()
	end
end

function NPA_Core:ResetModuleConfig(name)
	if(NPA_Core_ModuleList[name] and NPA_Core_ModuleList[name]:ResetConfig())then
		NPA_Core_ModuleList[name]:ResetConfig()
	end
end

function NPA_Core:CheckHook(name)
	if(NPA_Core_ModuleList[name])then
		return 1
	else
		return nil
	end
end



function NPA_Core:CheckAura(unitdata,spellid)
	if(unitdata)then
		local swap=unitdata.Aura
		if(swap)then
			swap=swap[spellid]
			if(swap and table_getn(swap)>0)then
				return true
			end
		end
	end
	return false
end

function NPA_Core:GetUnitData(guid)
	return NPA_UnitData[guid]
end

local function NPA_UnitData_Aura_Add(casterguid,targetguid,spellid,amount,isdose)
	
	local count
	local school,expirationtime,stealable

	if(NPA_UnitData[targetguid]==nil)then
		NPA_UnitData[targetguid]={
			Aura={
				[spellid]={}
				}
		}
	elseif(NPA_UnitData[targetguid].Aura==nil)then
		NPA_UnitData[targetguid].Aura={
				[spellid]={}
				}
	elseif(NPA_UnitData[targetguid].Aura[spellid]==nil)then
		NPA_UnitData[targetguid].Aura[spellid]={}
	end

	local aura=NPA_UnitData[targetguid].Aura[spellid]

	if(isdose or amount==nil or amount==0)then
		local durationcache=NPA_Core.Aura_Duration_Cache[spellid]
		if(durationcache)then
			durationcache=durationcache[casterguid]
			if(durationcache)then
				expirationtime=GetTime()+durationcache
			end
		end
		count=amount
	end

	local buff={
		CasterGUID=casterguid,
		Count=count,
		ExpirationTime=expirationtime,
	}


	for i,spell in pairs(aura) do
		if(spell.CasterGUID==casterguid) then
			NPA_UnitData[targetguid].Aura[spellid][i]=buff
			return
		end
	end

	table_insert(aura,buff)

end

local function NPA_UnitData_Aura_Refresh(casterguid,targetguid,spellid)
	local count
	local school,expirationtime,stealable

	if(NPA_UnitData[targetguid]==nil)then
		NPA_UnitData[targetguid]={
			Aura={
				[spellid]={}
				}
		}
	elseif(NPA_UnitData[targetguid].Aura==nil)then
		NPA_UnitData[targetguid].Aura={
				[spellid]={}
				}
	elseif(NPA_UnitData[targetguid].Aura[spellid]==nil)then
		NPA_UnitData[targetguid].Aura[spellid]={}
	end

	local aura=NPA_UnitData[targetguid].Aura[spellid]

	local buff={
		CasterGUID=casterguid,
	}


	for i,spell in pairs(aura) do
		if(spell.CasterGUID==casterguid) then
			NPA_UnitData[targetguid].Aura[spellid][i]=buff
			return
		end
	end

	table_insert(aura,buff)

end

local function NPA_UnitData_Aura_Remove(casterguid,targetguid,spellid,dose)
	if(NPA_UnitData[targetguid])then
		local auras=NPA_UnitData[targetguid].Aura[spellid]
		if(auras)then
			for i,spell in pairs(auras) do
				if(spell.CasterGUID==casterguid)then
					if(dose>0 and spell.Count)then
						spell.Count=spell.Count-dose
						if(spell.Count<1)then
							table_remove(auras,i)
						end
					else
						table_remove(auras,i)
					end
				end
			end
		end
	end
end

local function NPA_UnitData_SortAura(cache, spellcache,aura, guid, name, icon , count , school , duration , expirationtime , unitcaster , stealable , spellid ,type ,nTime)
	local casterguid
	if(unitcaster)then
		casterguid=UnitGUID(unitcaster) or -5
	else
		casterguid=-5
	end

	buff={
		CasterGUID=casterguid,
		Count=count,
		ExpirationTime=expirationtime,
	}

	if(not cache[spellid])then
		cache[spellid]={}
	end
	cache[spellid][casterguid]=duration

	if(not spellcache[spellid])then
		spellcache[spellid]={
			School=school,
			Stealable=stealable,
			Name=name,
			Icon=icon,
			Type=type,
			}
	end
		
	if(not aura[spellid])then
		aura[spellid]={[1]=buff}
	else
		table_insert(aura[spellid],buff)
	end
end

local function NPA_UnitData_GetUnitAura(unit,guid)
	local aura={}

	local i=1
	local buff
	--name, rank, icon , count , bufftype , duration , expirationtime , unitcaster , isstealable , shouldconsolidate , spellid = UnitBuff(unit,i)
	local name, _, icon , count , school , duration , expirationtime , unitcaster , stealable ,_ , spellid = UnitBuff(unit,i)
	local casterguid

	local cache=NPA_Core.Aura_Duration_Cache
	local spellcache=NPA_Core.SpellData

	local nTime=GetTime()

	while(name) do
		NPA_UnitData_SortAura(cache, spellcache, aura, guid, name, icon , count , school , duration , expirationtime , unitcaster , stealable , spellid, "BUFF")
		i=i+1		
		name, rank, icon , count , school , duration , expirationtime , unitcaster , stealable , _ , spellid = UnitBuff(unit,i)
	end
	
	i=1
	name, _ , icon , count , school , duration , expirationtime , unitcaster , stealable , _ , spellid = UnitDebuff(unit,i)
	while(name) do
		NPA_UnitData_SortAura(cache, spellcache, aura, guid, name, icon , count , school , duration , expirationtime , unitcaster , stealable ,spellid ,"DEBUFF")
		i=i+1		
		name, rank, icon , count , school , duration , expirationtime , unitcaster , stealable , _ , spellid = UnitDebuff(unit,i)
	end

	return aura
end

local function NPA_UnitData_GetMapPosition(unit)
	if(not NPA_Core_MapScale)then
		return
	end
	
	local x,y=GetPlayerMapPosition(unit)
	if(x and y and x~=0 and y~=0)then
		x=x*NPA_Core_MapScale
		y=y*NPA_Core_MapScale

		local data={X=x,Y=y}
		return data
	else
		return nil
	end
end


local function NPA_UnitData_GetUnitCastInfo(unit)
	-- spellname, rank, displayName, icon, startTime, endTime, isTradeSkill, castID, notinterrupt
	local _,_,name,icon,starttime,endtime ,_,_,notinterrupt = UnitCastingInfo(unit)

	local channel=nil
	if(name==nil)then
		_,_,name,icon,starttime,endtime = UnitChannelInfo(unit)
		if(name==nil)then
			return nil
		end
		channel=1

	end

	local nTime=GetTime()

	local data={
		Name=name,
		Icon=icon,
		StartTime=(starttime or nTime*1000)/1000,
		EndTime=(endtime or (nTime*1000+1000))/1000,	
		Channel=channel,
		NotInterrupt=notinterrupt
	}
	return data	
end

local function NPA_Core_RangeCheck(unit)
	if(UnitGUID(unit)==UnitGUID("player"))then
		return nil
	end

	local data

	local x,y=GetPlayerMapPosition(unit)

	if(x~=0 or y~=0)then
		local posx,posy=GetPlayerMapPosition("player")
		data={}
		data.Min=sqrt((posx-x)^2+(posy-y)^2)*NPA_Core_MapScale
		data.Max=data.Min
	else
		local close=0
		local far=1000
		for _,spell in pairs(NPA_RangeCheckData) do
			if(IsSpellInRange(spell.Name,unit)==1)then
				if(close<spell.Min)then
					close=spell.Min
				end
				if(far>spell.Max)then
					far=spell.Max
				end
			end
		end
		for _,spell in pairs(NPA_RangeCheckData) do
			if(IsSpellInRange(spell.Name,unit)==0)then
				if(close>=spell.Min and far>=spell.Max and close<=spell.Max)then
					close=spell.Max
				end
				if(close<=spell.Min and far>=spell.Max)then
					close=spell.Max
				end

				if(close<=spell.Min and far<=spell.Max and far>=spell.Min)then
					far=spell.Min
				end
			end
		end

		local checkrange=CheckInteractDistance
		if(checkrange)then
			if(checkrange(unit,4))then
				if(far>28)then
					far=28
				end
				if(close>28)then
					close=28
				end
			end
			if(checkrange(unit,2))then
				if(far>11)then
					far=11
				end
				if(close>11)then
					close=11
				end
			end
			if(checkrange(unit,3))then
				if(far>10)then
					far=10
				end
				if(close>10)then
					close=10
				end
			end
		end
					

		data={Min=close,Max=far}
	end

	return data
end

local NPA_Core_UnitData_UpdateInterval=0
local NPA_Core_UnitData_RecentUpdateInterval=0.5
local NPA_Core_UnitData_FrameUpdateInterval=0

local NPA_Core_UnitData_CollectFunc={}

local function NPA_Core_BuildCollectFunc()
	NPA_Core_UnitData_CollectFunc={}
	if(NPA_Core_Config["Data_Filter"]["Aura"]==1)then
		NPA_Core_UnitData_CollectFunc["Aura"]=function(unit,data)
				data.Aura=NPA_UnitData_GetUnitAura(unit,guid)
			end
	else
		NPA_Core_UnitData_CollectFunc["Aura"]=function(unit,data)
				data.Aura={}
			end
	end

	if(NPA_Core_Config["Data_Filter"]["Casting"]==1)then
		NPA_Core_UnitData_CollectFunc["Casting"]=function(unit,data)
				castinfo=NPA_UnitData_GetUnitCastInfo(unit)
				if(castinfo)then
					data.CastInfo=castinfo
				elseif(not(data.CastInfo and data.CastInfo.Instant))then
					data.CastInfo=nil
				end
			end
	end
	if(NPA_Core_Config["Data_Filter"]["Target"]==1)then
		NPA_Core_UnitData_CollectFunc["Target"]=function(unit,data,unittarget)
			data.Target={
					TargetGUID=UnitGUID(unittarget),
					TargetName=UnitName(unittarget),
					IsPlayerEnemy=UnitIsEnemy(unittarget,"player"),
					IsPlayerFriend=UnitIsFriend(unittarget,"player"),
					IsEnemy=UnitIsEnemy(unit,unittarget),
					IsFriend=UnitIsFriend(unit,unittarget),
				}
			end
	end
	if(NPA_Core_Config["Data_Filter"]["Speed"]==1)then
		NPA_Core_UnitData_CollectFunc["Speed"]=function(unit,data)
				data.Speed=floor(GetUnitSpeed(unit)/7*100)
			end
	end
	--if(NPA_Core_Config["Data_Filter"]["Position"]==1)then
	--	NPA_Core_UnitData_CollectFunc["Position"]=function(unit,data)
	--		end
	--end
	if(NPA_Core_Config["Data_Filter"]["Range"]==1)then
		NPA_Core_UnitData_CollectFunc["Range"]=function(unit,data)
				data.Range=NPA_Core_RangeCheck(unit)
			end
	end
	if(NPA_Core_Config["Data_Filter"]["Portrait"]==1)then
		NPA_Core_UnitData_CollectFunc["Portrait"]=function(unit,data)
				if(not data.Portrait)then
					if(NPA_CachePortrait>0)then
						local portrait={}
						for i=1,NPA_CachePortrait do 
							local ins=NPA_MainFrame:CreateTexture("NPA_Portrait_Cache","OVERLAY",nil)
							table_insert(portrait,ins)
							SetPortraitTexture(ins,unit)
						end
						data.Portrait=portrait
					end
				else
					if(NPA_CachePortrait>0)then
						if(unitdata.Portrait)then
							portrait=unitdata.Portrait
							for i=1,NPA_CachePortrait do
								if(not portrait[i])then
									local ins=NPA_MainFrame:CreateTexture("NPA_Portrait_Cache","OVERLAY",nil)
									SetPortraitTexture(ins,unit)
									portrait[i]=ins
								end
							end
						else
							portrait={}
							for i=1,NPA_CachePortrait do
								local ins=NPA_MainFrame:CreateTexture("NPA_Portrait_Cache","OVERLAY",nil)
								table_insert(portrait,ins)
								SetPortraitTexture(ins,unit)
							end
						end
					end
				end

			end
	end
	if(NPA_Core_Config["Data_Filter"]["Threat"]==1)then
		NPA_Core_UnitData_CollectFunc["Threat"]=function(unit,data,unittarget,isfriend)
				local threatpercent
				local threatstatus
				if(isfriend)then
					_,_,threatpercent=UnitDetailedThreatSituation(unit,unittarget)
					threatstatus=UnitThreatSituation(unit)
				else
					_,threatstatus,threatpercent=UnitDetailedThreatSituation("player",unit)
				end
				data.ThreatPercent=threatpercent
				data.ThreatStatus=threatstatus
			end
	end

	if(NPA_Core_Config["Data_Filter"]["Tapped"]==1)then
		NPA_Core_UnitData_CollectFunc["Tapped"]=function(unit,data)
				if((not UnitPlayerControlled(unit)) and UnitIsTapped(unit) and (not UnitIsTappedByPlayer(unit)) and (not UnitIsTappedByAllThreatList(unit)) ) then
					data.Tapped=1
				end
			end
	end
	if(NPA_Core_Config["Data_Filter"]["TargetCount"]==1)then
		NPA_Core_UnitData_CollectFunc["TargetCount"]=function(unit,data,unittarget,isfriend,isplayer,nTime)
				if(UnitExists(unittarget))then
					local targetcount
					local targetguid=UnitGUID(unittarget)
					local guid=data.GUID
					--count target
					if(NPA_Core_TargetCount[targetguid]==nil)then
						NPA_Core_TargetCount[targetguid]={[1]={},[2]={},[3]={},[4]={}}
					end
					if(isfriend)then
						if(isplayer)then
							NPA_Core_TargetCount[targetguid][1][guid]=nTime
						else
							NPA_Core_TargetCount[targetguid][3][guid]=nTime
						end
					else
						if(isplayer)then
							NPA_Core_TargetCount[targetguid][2][guid]=nTime
						else
							NPA_Core_TargetCount[targetguid][4][guid]=nTime
						end
					end

					--count self
					if(NPA_Core_TargetCount[guid])then
						targetcount={[1]=0,[2]=0,[3]=0,[4]=0}
						for i=1,4 do
							if(NPA_Core_TargetCount[guid][i])then
								for nguid,ntime in pairs(NPA_Core_TargetCount[guid][i]) do
									if(nTime-ntime<0.5)then
										targetcount[i]=targetcount[i]+1
									else
										NPA_Core_TargetCount[guid][i][nguid]=nil
									end
								end
							end
						end
					end
					data.TargetCount=targetcount
				end
			end
	end

	if(NPA_Core_Config["Data_Filter"]["GuessHealth"]==1)then
		NPA_Core_UnitData_CollectFunc["GuessHealth"]=function(unit,data,_,_,isplayer,nTime)
				local name=data.Name
				if(NPA_NameHealthToGUID[name] and NPA_NameHealthToGUID[name][data.GuessedHealth])then
					NPA_NameHealthToGUID[name][data.GuessedHealth]=nil
				end

				if((not isplayer) and data.Health and data.Health>1)then
					if(not NPA_NameHealthToGUID[name])then
						NPA_NameHealthToGUID[name]={}
					end		
					NPA_NameHealthToGUID[name][data.Health]=guid
				end
				data.GuessedHealth=data.Health
				data.LastGuessed=nTime
			end
	end
	if(NPA_Core_Config["Data_Filter"]["NameGuild"]==1)then
		NPA_Core_UnitData_CollectFunc["NameGuild"]=function(unit,data)
				data.PVPName=UnitPVPName(unit)
				data.Guild=GetGuildInfo(unit)
			end
	end
	if(NPA_Core_Config["Data_Filter"]["Class"]==1)then
		NPA_Core_UnitData_CollectFunc["Class"]=function(unit,data)
				--local classname,classmark=UnitClass(unit)
				local _,classmark=UnitClass(unit)
				--CreatureFamily=UnitCreatureFamily(unit),
				--CreatureType=UnitCreatureType(unit),
				--ClassName=classname,
				data.ClassMark=classmark
				data.Classification=UnitClassification(unit)
			end
	end
	if(NPA_Core_Config["Data_Filter"]["Resource"]==1)then
		NPA_Core_UnitData_CollectFunc["Resource"]=function(unit,data)
				data.Health=UnitHealth(unit)
				data.HealthMax=UnitHealthMax(unit)
				data.Mana=UnitMana(unit)
				data.ManaMax=UnitManaMax(unit)
				data.PowerType=UnitPowerType(unit)
			end
	end
	if(NPA_Core_Config["Data_Filter"]["Combat"]==1)then
		NPA_Core_UnitData_CollectFunc["Combat"]=function(unit,data)
				data.InCombat=UnitAffectingCombat(unit)
			end
	end

	if(NPA_Core_Config["Data_Filter"]["Raid"]==1)then
		NPA_Core_UnitData_CollectFunc["Raid"]=function(unit,data)
				data.RaidTarget=GetRaidTargetIndex(unit)
			end
	end
	if(NPA_Core_Config["Data_Filter"]["PvP"]==1)then
		NPA_Core_UnitData_CollectFunc["PvP"]=function(unit,data)
				data.IsPvP=UnitIsPvP(unit)
			end
	end
	if(NPA_Core_Config["Data_Filter"]["Level"]==1)then
		NPA_Core_UnitData_CollectFunc["Level"]=function(unit,data)
				data.Level=UnitLevel(unit)
			end
	end
end


local function NPA_CollectDataByUnit(unit,force)
	local guid=UnitGUID(unit)
	if(not guid)then
		return
	end

	local nTime=GetTime()
	local data

	local isfriend=UnitIsFriend(unit,"player")

	if(force)then
		data=NPA_UnitData[guid]
		if(not data)then
			NPA_UnitData[guid]={}
			data=NPA_UnitData[guid]
		end
	else
		if(isfriend)then
			if(NPA_Core_Config["CollectNonHostile"]~=1)then
				return
			end
		else
			if(NPA_Core_Config["CollectHostile"]~=1)then
				return
			end
		end
		data=NPA_UnitData[guid]

		if(not data)then
			NPA_UnitData[guid]={}
			data=NPA_UnitData[guid]
		elseif(data.LastUpdate and nTime-data.LastUpdate < NPA_Core_UnitData_UpdateInterval)then
			return
		end
	end

	--data temp

	--get map position
	--local position
	--if((UnitInParty(unit) or UnitInRaid(unit))and (NPA_Core_Config["TeamPointer"]==1  or NPA_Core_Config["RangeCheck"]==1))then
	--	position=NPA_UnitData_GetMapPosition(unit)
	--end
	
	local isplayer=UnitIsPlayer(unit)

	local unittarget=unit.."target"
	local unitpet=unit.."pet"
	local petguid=UnitGUID(unitpet)

	if(petguid)then
		if(UnitIsPlayer(unitpet))then
			NPA_Core_TypeCache[petguid]=nil
		else
			if(isenemy)then
				NPA_Core_TypeCache[petguid]=5
			else
				NPA_Core_TypeCache[petguid]=2
			end
		end
	end
	
	local name=UnitName(unit)

	data.GUID=guid
	data.PetGUID=petguid
	data.Name=name
	--Sex=UnitSex(unit),
	--InParty=UnitInParty(unit),
	--InRaid=UnitInRaid(unit),
	--Charmed=UnitIsCharmed(unit),
	--Connected=UnitIsConnected(unit),
	data.IsEnemy=UnitIsEnemy(unit,"player")
	data.IsFriend=isfriend
	data.IsPlayer=isplayer
	data.LastUpdate=nTime
	data.LastLog=nTime

	for _,func in pairs(NPA_Core_UnitData_CollectFunc) do
		func(unit,data,unittarget,isfriend,isplayer,nTime)
	end

	--setup name to guid lookups
	if(isplayer==1)then
		NPA_UnitData_NameToGUID[name]=guid
	end
end


local function NPA_IsNamePlateFrame(frame)
--	print(frame:GetName())
--	if (frame:GetName())then
--		return false
--	else 
		local _, region = frame:GetRegions()
		if (region and region:GetObjectType() == "Texture" and region:GetTexture() == "Interface\\Tooltips\\Nameplate-Border") then
			return true
		else
			return false
		end
--	end
end


local function NPA_Frame_SetupGUID(frame,guid,switch)
	GUIDToFrame[guid]=frame
	frame.ModuleMain.GUID=guid
	frame.HealthBar.GUID=guid

	if(switch==1)then
		NPA_GUIDMatched[guid]=1
	else
		NPA_GUIDMatched[guid]=2
	end
end 

local NPA_Core_ClassColorTable={}
--generate colortable
	for class,color in pairs(RAID_CLASS_COLORS) do
	local r=floor(color.r*100/4)
	local g=floor(color.g*100/4)
	local b=floor(color.b*100/4)
	if(not NPA_Core_ClassColorTable[r])then
		NPA_Core_ClassColorTable[r]={}
	end
	if(not  NPA_Core_ClassColorTable[r][g])then
		NPA_Core_ClassColorTable[r][g]={}
	end
	if(not  NPA_Core_ClassColorTable[r][g][b])then
		NPA_Core_ClassColorTable[r][g][b]=class
	end

	if(not NPA_Core_ClassColorTable[0])then
		NPA_Core_ClassColorTable[0]=
			{[0]={
				[25]="FriendlyPlayer"
				}
			}
	elseif(not NPA_Core_ClassColorTable[0][0])then
		NPA_Core_ClassColorTable[0][0]={[25]="FriendlyPlayer"}
	else
		NPA_Core_ClassColorTable[0][0][25]="FriendlyPlayer"
	end
end

local function NPA_Core_CheckPlayer(name,maxhealth,frame,healthbar)
	local guid=NPA_UnitData_NameToGUID[name]
	--check guid, data,  name and health
	if(guid==nil or NPA_UnitData[guid]==nil or NPA_UnitData[guid].Name~=name or NPA_UnitData[guid].HealthMax==nil)then --don't know this one yet
		return
	else
		local check
		--check player with bar
		local r,g,b = healthbar:GetStatusBarColor()
		---green, blue, yellow are non-hostile
		if(r==0 and g>0.9 and b==0)then
			check=1
		elseif(r==0 and g==0 and b>0.9)then
			check=1
		elseif(r>0.9 and g>0.9 and b==0)then
			--check=nil
		elseif(r>0.9 and g==0 and b==0)then -- red is non-player
			--check=nil
		else
			check=1
		end
		if(check==1)then
			local checkmax=NPA_UnitData[guid].HealthMax
			if(maxhealth==checkmax)then
				NPA_Frame_SetupGUID(frame,guid,1)
			else
				local ar=floor(r*25)
				local ag=floor(g*25)
				local ab=floor(b*25)
				if(NPA_Core_ClassColorTable[ar] and NPA_Core_ClassColorTable[ar][ag] and NPA_Core_ClassColorTable[ar][ag][ab])then
					NPA_Frame_SetupGUID(frame,guid,1)
				else
					--check max health to make sure
					local percent=maxhealth/checkmax
					--90% or 110% , should take care of most buff/debuff
					if(percent>0.9 and percent<1.1)then
						NPA_Frame_SetupGUID(frame,guid)
					end
				end
			end
		end
	end
	
	return nil
end

local function NPA_ClearGUID(frame)
	local guid=frame.ModuleMain.GUID
	if(guid)then
		GUIDToFrame[guid]=nil
		NPA_GUIDMatched[guid]=nil
	end

	frame.HealthBar.GUID=nil
	frame.ModuleMain.GUID=nil
end



local function NPA_HookOnUpdate(frame,elapsed)
	if(NPA_GUIDMatched[guid]==1)then
		return
	end

	local default=frame.Default
	local name=default.NameText:GetText()
	local healthbar=default.HealthBar
	local health=healthbar:GetValue()
	local _,maxhealth=healthbar:GetMinMaxValues()
	
	--if mouseover
	if (default.Highlight:IsShown() and UnitExists("mouseover") and name==UnitName("mouseover") and maxhealth==UnitHealthMax("mouseover")) then
		NPA_Frame_SetupGUID(frame,UnitGUID("mouseover"),1)
		return
	end
	if (frame:GetAlpha()==1 and UnitExists("target") and name==UnitName("target") and maxhealth==UnitHealthMax("target")) then
		for _,oframe in pairs(NPA_Core_Frame) do
			if(oframe~=frame)then
				if(oframe:GetAlpha()==1)then
					break
				else
					NPA_Frame_SetupGUID(frame,UnitGUID("target"),1)
					return
				end
			end
		end
		NPA_Frame_SetupGUID(frame,UnitGUID("target"),1)
	end
	--pet
	if(UnitExists("playerpet") and
		(name==UnitName("playerpet") and maxhealth==UnitHealthMax("playerpet") and health==UnitHealth("playerpet")))then
			NPA_Frame_SetupGUID(frame,UnitGUID("playerpet"),1)
			return
	end

	--check player
	NPA_Core_CheckPlayer(name,maxhealth,frame,healthbar)

	--guess check
	if(NPA_Core_Config["PowerMatch"]==1)then
		if(NPA_GUIDMatched[guid]~=2)then
			if(health~=maxhealth and NPA_NameHealthToGUID[name] and NPA_NameHealthToGUID[name][health])then
				local guid=NPA_NameHealthToGUID[name][health]
				if(NPA_UnitData[guid] and NPA_UnitData[guid].HealthMax==maxhealth)then
					NPA_Frame_SetupGUID(frame,NPA_NameHealthToGUID[name][health])
					NPA_NameHealthToGUID[name][health]=nil
				end
			end
		end
	end
end

local function NPA_HealthBarHookOnValueChanged(self)
	local guid=self.GUID
	if(guid and NPA_UnitData[guid])then
		local value=self:GetValue()
		local _,maxhealth=self:GetMinMaxValues()
		NPA_UnitData[guid].Health=value
		NPA_UnitData[guid].HealthMax=maxhealth
		NPA_UnitData[guid].GuessedHealth=value
		NPA_UnitData[guid].LastGuessed=GetTime()
	end

end

local function NPA_Modules_HideAll(frame,modules)
	for key,_ in pairs(modules) do
		local main=frame[key]
		if(main)then
			main:Hide()
		end
	end
end

local function NPA_HookOnShow(frame)
	NPA_ClearGUID(frame)
	frame.ModuleMain:Show()
	frame.ModuleMain.TimeStack=NPA_Core_UnitData_FrameUpdateInterval

end

local function NPA_HookOnHide(frame)
	NPA_ClearGUID(frame)
	frame.ModuleMain:Hide()
	frame.ModuleMain.TimeStack=NPA_Core_UnitData_FrameUpdateInterval

end


local function NPA_Core_CheckHostile(bar)
	local r,g,b = bar:GetStatusBarColor()
	---green, blue, yellow are non-hostile
	if(r==0 and g>0.9 and b==0)then -- green is friendly npc
		return 0,0
	elseif(r==0 and g==0 and b>0.9)then --- blue is friendly player
		return 0,1
	elseif(r>0.9 and g>0.9 and b==0)then --- yellow is netural npc
		return 2,0
	elseif(r>0.9 and g==0 and b==0)then -- red is non-player hostile
		return 1,0
	else
		return 1,1 -- unknow , counts as hostile player
	end

end


local function NPA_ModuleMain_OnUpdate(frame,elapsed)
	frame.TimeStack=frame.TimeStack+elapsed

	if (frame.TimeStack <NPA_Core_UnitData_FrameUpdateInterval ) then
		return
	end
	
	frame.TimeStack=0

	if(not frame.Parent:IsShown())then
		frame:Hide()
		return
	end


	local nTime=GetTime()

	local guid=frame.GUID or -1
	local unitdata=NPA_UnitData[guid]
	local selfguid=UnitGUID("player") or 0


	local guids={
		Pet=UnitGUID("playerpet") or -2,
		Target=UnitGUID("playertarget") or -2,
		Focus=UnitGUID("focus") or -2,
		Mouseover=UnitGUID("mouseover") or -2,
		}

	local render=frame.RenderMain
	if(guid==guids.Target)then
		render:SetFrameStrata("LOW")
		render:SetFrameLevel(NPA_Core_LayerList["Target"])
	elseif(guid==guids.Mouseover)then
		render:SetFrameStrata("LOW")
		render:SetFrameLevel(NPA_Core_LayerList["Mouseover"])
	elseif(guid==guids.Focus)then
		render:SetFrameStrata("LOW")
		render:SetFrameLevel(NPA_Core_LayerList["Focus"])
	else
		render:SetFrameStrata("BACKGROUND")
		render:SetFrameLevel(0)
	end

	local default=frame.Default
	local recentUpdated
	local recentGuessed

	local hostile
	local isplayer

	local fade
	if(NPA_Core_Config["OnlySelected"]==1 and guid~=guids.Pet and guid~=selfguid
		and guid~=guids.Target and guid~=guids.Focus and guid~=guids.Mouseover
		and default)then
		
		fade=1
	end

	--guild and friend check
	local name
	if(default)then
		name=default.NameText:GetText()
	elseif(unitdata)then
		name=unitdata.Name
	else
		name=-1
	end

	local isfriend=NPA_Core_FriendNameCache[name]
	local isguild=NPA_Core_GuildNameCache[name]
	local isparty=NPA_Core_PartyNameCache[name]
	local israid=NPA_Core_RaidNameCache[name]
	local isinstance=IsInInstance()

	local typecache=NPA_Core_TypeCache[guid]

	local threat
	
	local modulelist

	if(unitdata)then
		if(unitdata.IsEnemy)then
			hostile=1
		elseif(unitdata.IsFriend)then
			hostile=0
		else
			hostile=2
		end
		isplayer=unitdata.IsPlayer or 0

		if(frame.ModuleList)then
			modulelist=frame.ModuleList
		elseif(NPA_Core_Config["SeparateModuleList"]==1)then
			local index
			if(hostile==0)then
				index=0
			else
				index=1
			end
			modulelist=NPA_Core_EnabledModuleList[index][isplayer]
		else
			modulelist=NPA_Core_MainEnabledModuleList
		end

		local last=unitdata.LastGuessed
		if(last and nTime-last<10)then
			recentGuessed=1
		end
		last=unitdata.LastUpdate
		if(last and nTime-last<NPA_Core_UnitData_RecentUpdateInterval)then
			recentUpdated=1
		end

		if(UnitAffectingCombat("player") and recentUpdated)then
			threat=unitdata.ThreatStatus
		end

		if(fade~=1)then
			for key,func in pairs(NPA_Core_GUIDModules) do
				local main=frame[key]
				if(main)then
					if(modulelist[key]==1)then
						func(nTime,main,guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed,isfriend,isguild,isparty,israid,isinstance,NPA_Core_IsInArena,NPA_Core_IsInBattleground,typecache,threat)
					else
						main:Hide()
					end
				end
			end
		else
			NPA_Modules_HideAll(frame,NPA_Core_GUIDModules)
		end
	else
		local checkbar=frame.CheckBar
		if(checkbar)then
			hostile,isplayer=NPA_Core_CheckHostile(checkbar)
		else
			hostile=1
			isplayer=0
		end

		NPA_Modules_HideAll(frame,NPA_Core_GUIDModules)

		if(frame.ModuleList)then
			modulelist=frame.ModuleList
		elseif(NPA_Core_Config["SeparateModuleList"]==1)then
			local index
			if(hostile==0)then
				index=0
			else
				index=1
			end
			modulelist=NPA_Core_EnabledModuleList[index][isplayer]
		else
			modulelist=NPA_Core_MainEnabledModuleList
		end

		if(UnitAffectingCombat("player"))then
			if(default)then
				local threatglow=default.NativeGlow
				if(threatglow:IsShown())then
					threat=1
				else
					threat=0
				end
			else
				threat=0
			end
		else
			threat=nil
		end
	end

	for key,func in pairs(NPA_Core_FrameModules) do
		local main=frame[key]
		if(main)then
			if(modulelist[key]==1)then
				func(nTime,main,guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed,isfriend,isguild,isparty,israid,isinstance,NPA_Core_IsInArena,NPA_Core_IsInBattleground,typecache,threat)
			else
				main:Hide()
			end
		end
	end
end

function NPA_Core:HookModuleMain(frame)
	frame:SetScript("OnUpdate",NPA_ModuleMain_OnUpdate)
end

function NPA_Core:HookFrame(name,frame)
	if(NPA_Core_Hooks[name])then
		NPA_Core_Hooks[name](frame)
	end
end
function NPA_Core:HookAll(frame)
	for _,func in pairs(NPA_Core_Hooks) do
		func(frame)
	end
end

local function debuginfo(region)
	if(region)then
		print(region:GetObjectType())
	else
		print("emepty")
	end
end

local function NPA_Core_HookFrameFunc(modulemain)
	for name,_ in pairs(NPA_Core_GUIDModules) do
		local func=NPA_Core_Hooks[name]
		if(func and (not modulemain[name]))then
			func(modulemain)
		end
	end
	for name,_ in pairs(NPA_Core_FrameModules) do
		local func=NPA_Core_Hooks[name]
		if(func and (not modulemain[name]))then
			func(modulemain)
		end
	end
	NPA_Modules_HideAll(modulemain,NPA_Core_GUIDModules)
	NPA_Modules_HideAll(modulemain,NPA_Core_FrameModules)
end

local function NPA_Core_HookFrame(frame)
	frame.NPAHooked=1

	--default frame data
	if(not frame:GetRegions())then
		return
	end
	--old version--local nativeGlowRegion, overlayRegion, castBarOverlayRegion, castBarShieldRegion, spellIconRegion, highlightRegion, nameTextRegion, levelTextRegion, bossIconRegion, raidIconRegion, stateIconRegion = frame:GetRegions()
	-- threatflash, border, highlightglow, nametext, leveltext, bossicon, raidicon, eliteicon

	-- healthbar: barfill
	-- castbar: barfill, border, shield,icon


	local healthBar,castBar = frame:GetChildren()
	local nativeGlowRegion, overlayRegion, castBarOverlayRegion, castBarShieldRegion, spellIconRegion, highlightRegion, nameTextRegion, levelTextRegion, bossIconRegion, raidIconRegion, stateIconRegion
	local castBarOverlayRegion, castBarShieldRegion, spellIconRegion
	if(interfaceversion<40100)then
		nativeGlowRegion, overlayRegion, castBarOverlayRegion, castBarShieldRegion, spellIconRegion, highlightRegion, nameTextRegion, levelTextRegion, bossIconRegion, raidIconRegion, stateIconRegion = frame:GetRegions()
	else
		nativeGlowRegion, overlayRegion, highlightRegion, nameTextRegion, levelTextRegion, bossIconRegion, raidIconRegion, stateIconRegion = frame:GetRegions()
		_,castBarOverlayRegion, castBarShieldRegion, spellIconRegion=castBar:GetRegions()
	end

	--debug functions

	--debuginfo(nativeGlowRegion)
	--debuginfo(overlayRegion)
	--debuginfo(castBarOverlayRegion)
	--debuginfo(castBarShieldRegion)
	--debuginfo(spellIconRegion)
	--debuginfo(highlightRegion)
	--debuginfo(nameTextRegion)
	--debuginfo(levelTextRegion)
	--debuginfo(bossIconRegion)
	--debuginfo(raidIconRegion)
	--debuginfo(stateIconRegion)
	--debuginfo(healthBar)
	--debuginfo(castBar)

	--local r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11 = frame:GetRegions()
	--local b1,b2=frame:GetChildren()

	--print(r1:GetTexture())
	--print(r2:GetTexture())
	--print(r3:GetTexture())
	--print(r4:GetText())
	--print(r5:GetText())
	--print(r6:GetTexture())
	--print(r7:GetTexture())
	--print(r8:GetTexture())
	--print("empty")
	--print("empty")
	--print("empty")
	--print(b1:GetStatusBarTexture())
	--print(b2:GetStatusBarTexture())

	--local r1,r2,r3,r4,r5=b1:GetRegions()

	--debuginfo(r1)
	--debuginfo(r2)
	--debuginfo(r3)
	--debuginfo(r4)
	--debuginfo(r5)
	--print(r1:GetTexture())
	--print("---")

	--local r1,r2,r3,r4,r5=b2:GetRegions()
	--debuginfo(r1)
	--debuginfo(r2)
	--debuginfo(r3)
	--debuginfo(r4)
	--debuginfo(r5)
	--print(r1:GetTexture())
	--print(r2:GetTexture())
	--print(r3:GetTexture())
	--print(r4:GetTexture())




	local default= {
		NativeGlow = nativeGlowRegion, --texture
		Overlay = overlayRegion, --texture
		CastBarOverlay = castBarOverlayRegion, --texture
		CastBarShield = castBarShieldRegion, --texture
		SpellIcon= spellIconRegion,--texture
		Highlight = highlightRegion, --texture
		NameText = nameTextRegion, --fontstring
		LevelText = levelTextRegion, --fontstring
		BossIcon = bossIconRegion, --texture
		RaidIcon = raidIconRegion, --texture
		StateIcon= stateIconRegion, --texture
		
		HealthBar = healthBar, --statusbar
		CastBar = castBar, -- statusbar
		}
	healthBar.Parent=frame
	healthBar:HookScript("OnValueChanged",NPA_HealthBarHookOnValueChanged)
	
	frame.Default=default
	frame.HealthBar=healthBar

	--hook functions
	frame:HookScript("OnUpdate",NPA_HookOnUpdate)
	frame:HookScript("OnShow",NPA_HookOnShow)
	frame:HookScript("OnHide",NPA_HookOnHide)

	--module mainframe
	local rendermain=CreateFrame("Frame","NPA_RenderMainFrame",UIParent)
	rendermain:SetHeight(3)
	rendermain:SetWidth(3)
	rendermain:Show()

	local modulemain=CreateFrame("Frame","NPA_ModuleMainFrame",rendermain)
	modulemain:SetHeight(20)
	modulemain:SetWidth(120)
	modulemain:SetPoint("CENTER",frame,"CENTER",NPA_Core_Config["OffsetX"],NPA_Core_Config["OffsetY"])

	modulemain:SetScale(NPA_Core_Config["GlobalSize"])

	modulemain.Default=default
	modulemain.Parent=frame
	modulemain.CheckBar=healthBar

	rendermain:SetPoint("CENTER",modulemain,"CENTER")

	modulemain.TimeStack=0

	--scroll frame
	local scrollframe=CreateFrame("ScrollFrame","NPA_LayerFrame",UIParent)
	scrollframe:SetHeight(2048)
	scrollframe:SetWidth(2048)
	scrollframe:SetPoint("CENTER",modulemain,"CENTER")
	scrollframe:SetScrollChild(rendermain)
	scrollframe:SetFrameStrata("BACKGROUND")
	scrollframe:Show()

	modulemain.RenderMain=scrollframe

	NPA_Core_HookFrameFunc(modulemain)

	frame.ModuleMain=modulemain

	modulemain:SetScript("OnHide",function(self)
		NPA_Modules_HideAll(self,NPA_Core_GUIDModules)
		NPA_Modules_HideAll(self,NPA_Core_FrameModules)
	end)


	modulemain:SetScript("OnUpdate",NPA_ModuleMain_OnUpdate)

	modulemain:Show()


	table_insert(NPA_Core_Frame,frame)
end

function NPA_Core:SetOnHide(frame)
	frame:HookScript("OnHide",function(self)
		NPA_Modules_HideAll(self,NPA_Core_GUIDModules)
		NPA_Modules_HideAll(self,NPA_Core_FrameModules)
		end)
end



local function NPA_SetupFrame()
	local frames={WorldFrame:GetChildren()}
	local frame
	
	for _,frame in pairs(frames) do
		if (NPA_IsNamePlateFrame(frame))then
			--setup frame data			
			if(frame.NPAHooked~=1)then
				NPA_Core_HookFrame(frame)
				NPA_HookOnShow(frame)
			end
		end
	end 
end



local function NPA_Unit_CastStop(casterguid,spellschool)
	if(NPA_UnitData[casterguid]==nil)then
		return
	end

	NPA_UnitData[casterguid].CastInfo=nil
	NPA_UnitData[casterguid].SpellSchool=spellschool
end


local function NPA_Unit_CastCheckStop(guid,spellid)
	if(NPA_UnitData[guid] and NPA_UnitData[guid].CastInfo and NPA_UnitData[guid].CastInfo.Id==spellid)then
		NPA_Unit_CastStop(guid)
	end
end

local function NPA_Unit_CastStart(casterguid,spellid,spellname,spellschool,targetguid,targetname)
	if(NPA_UnitData[casterguid]==nil)then
		return
	end

	local nTime=GetTime()
	local info=NPA_UnitData[casterguid].CastInfo
	if(info and spellname==info.Name and info.EndTime>nTime)then
		return
	end
	
	--name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo()
	
	local name, _,icon,_,_,_,casttime=GetSpellInfo(spellid)
	if(casttime==nil) then
		casttime=1
	else
		casttime=casttime/1000
	end


	NPA_UnitData[casterguid].CastInfo={
		Name=name,
		SpellId=spellid,
		Icon=icon,
		StartTime=nTime,
		EndTime=nTime+casttime,
	}

	NPA_UnitData[casterguid].SpellSchool=spellschool

	if(NPA_UnitData[casterguid].Target and targetname~=0)then
		NPA_UnitData[casterguid].Target.TargetGUID=targetguid
		NPA_UnitData[casterguid].Target.TargetName=targetname
		NPA_UnitData[casterguid].Target.LastUpdate=nTime
	end
end

local function NPA_Unit_CastInstant(casterguid,spellid,spellname,spellschool,targetguid,targetname)
	if(NPA_UnitData[casterguid]==nil)then
		return
	end

	local nTime=GetTime()
	local info=NPA_UnitData[casterguid].CastInfo
	if(info and spellname==info.Name and info.EndTime>nTime)then
		return
	end
	
	--name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo()
	
	local name, _,icon=GetSpellInfo(spellid)

	NPA_UnitData[casterguid].CastInfo={
		Name=name,
		SpellId=spellid,
		Icon=icon,
		StartTime=nTime,
		EndTime=nTime+1,
		Instant=1
	}

	NPA_UnitData[casterguid].SpellSchool=spellschool

	if(NPA_UnitData[casterguid].Target and targetname~=0)then
		NPA_UnitData[casterguid].Target.TargetGUID=targetguid
		NPA_UnitData[casterguid].Target.TargetName=targetname
		NPA_UnitData[casterguid].Target.LastUpdate=nTime
	end
end



local NPA_CombatLog_Health={
	["SWING_DAMAGE"]=1,
	["RANGE_DAMAGE"]=2,
	["SPELL_DAMAGE"]=2,
	["DAMAGE_SHIELD"]=2,
	["DAMAGE_SPLIT"]=2,
	["SPELL_DAMAGE"]=2,
	["SPELL_PERIODIC_DAMAGE"]=2,
	["SPELL_HEAL"]=3,
	["SPELL_PERIODIC_HEAL"]=3
}

local NPA_CombatLog_Filter={}
local NPA_OnEventFilterFunction={}

local function NPA_Core_BuildCombatLogFilter()
	if(NPA_Core_Config["Data_Filter"]["Aura"]==1)then
		NPA_CombatLog_Filter["SPELL_AURA_APPLIED"]={1}
		NPA_CombatLog_Filter["SPELL_AURA_REFRESH"]={1}
		NPA_CombatLog_Filter["SPELL_AURA_APPLIED_DOSE"]={1,1}

		NPA_CombatLog_Filter["SPELL_AURA_REMOVED"]={2,0}
		NPA_CombatLog_Filter["SPELL_AURA_REMOVED_DOSE"]={2,13}

		NPA_CombatLog_Filter["SPELL_AURA_BROKEN"]={2,0}
		NPA_CombatLog_Filter["SPELL_AURA_BROKEN_SPELL"]={2,0}
	
		NPA_CombatLog_Filter["SPELL_DISPEL"]={2,0}
		NPA_CombatLog_Filter["SPELL_STOLEN"]={2,0}
	end
	
	if(NPA_Core_Config["Data_Filter"]["Casting"]==1)then
		NPA_CombatLog_Filter["SPELL_CAST_START"]={3}

		NPA_CombatLog_Filter["SPELL_CAST_SUCCESS"]={4}

		--NPA_CombatLog_Filter["SPELL_CAST_FAILED"]={7}

		NPA_CombatLog_Filter["SPELL_MISS"]={4}

		NPA_CombatLog_Filter["SPELL_INTERRUPT"]={4}

		NPA_CombatLog_Filter["SPELL_DAMAGE"]={5}
	end


	NPA_OnEventFilterFunction={
	[1]=function(uarg,filter)
		--NPA_UnitData_Aura_Add(casterguid,targetguid,spellid,type,count,amount)

		NPA_UnitData_Aura_Add(uarg[3],uarg[6],uarg[9],uarg[13],filter[2])

		NPA_Unit_CastCheckStop(uarg[3],uarg[9])
		end,
	[2]=function(uarg,filter)
		NPA_UnitData_Aura_Remove(uarg[3],uarg[6],uarg[9],filter[2])
		end,
	[3]=function(uarg)
		NPA_Unit_CastStart(uarg[3],uarg[9],uarg[10],uarg[11],uarg[6],uarg[7])
		end,
	[5]=function(uarg)
		NPA_Unit_CastCheckStop(uarg[3],uarg[9])
		end,
	[6]=function(uarg)
		NPA_UnitData_Aura_Refresh(uarg[3],uarg[6],uarg[9],uarg[13])
		end,
	}

	if(NPA_Core_Config["Data_AlterInstant"]==1)then
		NPA_OnEventFilterFunction[4]=function(uarg)
			NPA_Unit_CastInstant(uarg[3],uarg[9],uarg[10],uarg[11],uarg[6],uarg[7])
		end
	else
		NPA_OnEventFilterFunction[4]=function(uarg)
			NPA_Unit_CastStop(uarg[3],uarg[11])
		end
	end

end

NPA_Core.RebuildFilters=NPA_Core_BuildCombatLogFilter

local function NPA_BuildRangeCheckList()
	--build range check spell data
	local list={}
	
	if(GetSpellBookItemInfo)then
		local i=1
		while(GetSpellBookItemInfo(i, "player"))do
			local type,spellid=GetSpellBookItemInfo(i, "player")
			local ispassive=IsPassiveSpell(i,"player")
			if(type=="SPELL" and ispassive==nil)then
				local name,_,_,_,_,_,_,minrange,maxrange=GetSpellInfo(spellid)
				local isharmspell=IsSpellInRange(name,"player")
				if(IsHarmfulSpell and IsHarmfulSpell(name) and maxrange==0)then
					maxrange=5
				end
				local match=0
				if(minrange~=0 or maxrange~=0)then
					for index,spell in pairs(list) do
						if(minrange==spell.Min and maxrange==spell.Max and isharmspell==spell.Harm)then
							match=1
							break
						end
					end
					if(match==0)then
						table_insert(list,{Name=name,Min=minrange,Max=maxrange,Harm=isharmspell})
					end
				end
			end
			i=i+1
		end
		NPA_RangeCheckData=list
	elseif(GetSpellName)then
		local i=1
		while(GetSpellName(i, "player"))do
			local name=GetSpellName(i, "player")
			local ispassive=IsPassiveSpell(i,"player")
			local _,_,_,_,_,_,_,minrange,maxrange=GetSpellInfo(name)
			if(ispassive==nil)then
				local isharmspell=IsSpellInRange(name,"player")
				if(IsHarmfulSpell and IsHarmfulSpell(name) and maxrange==0)then
					maxrange=5
				end
				local match=0
				if(minrange~=0 or maxrange~=0)then
					for index,spell in pairs(list) do
						if(minrange==spell.Min and maxrange==spell.Max and isharmspell==spell.Harm)then
							match=1
							break
						end
					end
					if(match==0)then
						table_insert(list,{Name=name,Min=minrange,Max=maxrange,Harm=isharmspell})
					end
				end
			end
			i=i+1
		end
		NPA_RangeCheckData=list
	end
end

local NPA_Core_UnitCheckList={
	[1]="player",
	[2]="playertarget",
	[3]="focus",
	[4]="mouseover"}
for i=1,5 do
	NPA_Core_UnitCheckList[i+4]="arena"..tostring(i)
end
for i=1,4 do
	NPA_Core_UnitCheckList[i+9]="party"..tostring(i)
end
for i=1,40 do
	NPA_Core_UnitCheckList[i+13]="raid"..tostring(i)
end

local NPA_Core_UnitCheckIndex=1

local function NPA_OnUpdate(self,elapse)
	if(NPA_Core_Config["Enabled"]==1)then

	if(NPA_Core_Config["RangeCheck"]==1)then
		local x,y=GetPlayerMapPosition("player")
		local r=sqrt((x-NPA_Core_LastPosition.X)^2+(y-NPA_Core_LastPosition.Y)^2)
			
		if(r~=0 and NPA_Core_LastSpeed~=0)then
			local scale=NPA_Core_LastSpeed*elapse/r
			--if(scale>NPA_Core_MapScale)then
				NPA_Core_MapScale=scale
			--end
			NPA_Core_LastPosition={X=x,Y=y}
		end
		NPA_Core_LastSpeed=GetUnitSpeed("player")
	end

	--collect data
	--collect data
	--target
	NPA_CollectDataByUnit("player",1)
	NPA_CollectDataByUnit("target")
	NPA_CollectDataByUnit("mouseover")
	NPA_CollectDataByUnit("focus",1)
	NPA_CollectDataByUnit("targettarget")
	NPA_CollectDataByUnit("targettargettarget")
	NPA_CollectDataByUnit("mouseovertarget")
	NPA_CollectDataByUnit("focustarget")
	NPA_CollectDataByUnit("playerpet",1)
	NPA_CollectDataByUnit("playerpettarget")
	NPA_CollectDataByUnit("targetpet")
	NPA_CollectDataByUnit("targetpettarget")
	
	--party /raid  -maybe heavy
	--in raid
	local raidn=GetNumRaidMembers()
	if(raidn and raidn~=0) then
		for  i = 1,raidn do 
			--raid members
			local index="raid"..tostring(i)
			NPA_CollectDataByUnit(index)
			--raid pets
			local index2=index.."pet"
			NPA_CollectDataByUnit(index2)
			--raid member targets
			index=index.."-target"
			NPA_CollectDataByUnit(index)
			--raid pet targets
			index2=index2.."-target"
			NPA_CollectDataByUnit(index2)
		end 
	else
		local partyn=GetNumPartyMembers()
		if(partyn) then
			for  i=1,partyn do
				local index="party"..tostring(i)
				NPA_CollectDataByUnit(index)
				local index2=index.."pet"
				NPA_CollectDataByUnit(index2)
				--party target data
				index=index.."-target"
				NPA_CollectDataByUnit(index)
				index2=index2.."-target"
				NPA_CollectDataByUnit(index2)
			end 
		end
	end
	
	--arena
	if(NPA_Core_IsInArena==1)then
		for i=1 ,5 do
			--arena enemy 
			local index="arena"..tostring(i)
			NPA_CollectDataByUnit(index)
			local index2=index.."-pet"
			NPA_CollectDataByUnit(index2)
			--arena enemy target
			index=index.."-target"
			NPA_CollectDataByUnit(index)
			index2=index2.."-target"
			NPA_CollectDataByUnit(index2)
		end
	end

	--detect name plate frame	
	
	local num=WorldFrame:GetNumChildren()
	if(num~=NPA_NumChildren)then
		NPA_NumChildren=num
		NPA_SetupFrame()
	end

	local nTime=GetTime()

	--dynamic texture
	for texture,data in pairs(NPA_Core_TextureList)do
		if(texture:IsShown())then
			local offset=(nTime+data.Offset)*data.Time
			local index=floor((offset-floor(offset))*(data.Step))
			local adata=texture.AData[index]
			if(adata)then
				local tlx,_,blx,_,trx,_,brx = texture:GetTexCoord()
				if(texture.Angle)then
					local adata=texture.AData[index]
					texture:SetTexCoord(tlx,adata.TLy,blx,adata.BLy,trx,adata.TRy,brx,adata.BRy)
				else
					texture:SetTexCoord(tlx,adata.Top,blx,adata.Bottom,trx,adata.Top,brx,adata.Bottom)
				end
			end
		end
	end


	if(NPA_Core_Config["CleanUp"]==0 or NPA_UnitData==nil or (self.CleanUpTimer and nTime-self.CleanUpTimer<NPA_Core_Config["CleanUp"]))then
		return
	end

	self.CleanUpTimer=nTime
	for guid,data in pairs(NPA_UnitData) do
		if(data.LastUpdate and nTime-data.LastUpdate>NPA_Core_Config["CleanUpTimer"])then
			NPA_UnitData[guid]=nil
		end
	end
	
	end
end

--config 
local CombatEventFunc=NPA_Core.CombatEventFunc

local function NPA_Core_CheckIsPlayer(arg)
	if(bit_band(arg,COMBATLOG_OBJECT_TYPE_PLAYER)>0)then
		return 1

	else
		return nil
	end
end

	
local function NPA_Core_CheckUnitData(guid,nTime,name)
	if(not NPA_UnitData[guid])then
		NPA_UnitData[guid]={
				Aura={},
				LastLog=nTime,
				Name=name
				}
	else
		local unitdata=NPA_UnitData[guid]
		
		unitdata.LastLog=nTime
		if(not unitdata.Name)then
			unitdata.Name=name
		end
	end
end

function NPA_Core:ApplyAllModuleConfig()
	for name,main in pairs(NPA_Core_ModuleList) do
		if(name~="Core")then
			main:ApplyConfig()
		end
	end
end

function NPA_Core:ClearAllData()
	for _,main in pairs(NPA_Core_ModuleList) do
		if(main.ClearData)then
			main:ClearData()
		end
	end
end
local NPA_OnMainEventFilterFunction={
	["PLAYER_ENTERING_WORLD"]=function()
		NPA_BuildRangeCheckList()

		local _,area=IsInInstance()
		if(area=="arena")then
			if(NPA_Core_Config["ClearDataWhenEnteringArena"]==1)then
				NPA_Core:ClearAllData()
			end
			NPA_Core_IsInArena=1
		else
			NPA_Core_IsInArena=nil

			if(area=="pvp")then
				NPA_Core_IsInBattleground=1
			else
				NPA_Core_IsInBattleground=nil
			end
		end


	end,
	["VARIABLES_LOADED"]=function()
		if(not NPA_Profiles)then
			NPA_Profiles={["Default"]=NPA_Core_DefaultSetting}
		end

		if(NPA_Profiles["Seperate"]==1)then
			local key=GetRealmName().."-"..GetUnitName("Player")
			if(NPA_Profiles[key])then
				NPA_Config=CopyTable(NPA_Profiles[key])
			else
				NPA_Profiles[key]=CopyTable(NPA_Config)
			end
		end

		NPA_Core:CheckConfigEntry("Core",NPA_Core_DefaultSetting)
	
		NPA_Core:ApplyConfig()

		for name,main in pairs(NPA_Core_ModuleList) do
			if(name~="Core")then
				main:ApplyConfig()
			end
		end


		if((not NPA_Data) or NPA_Config["Core"]["SaveData"]~=1)then
			NPA_Data={}
		end
		if(NPA_Config["Core"]["SaveData"]~=1 or (not NPA_Data.Unit))then
			NPA_Data.Unit={}
		end
		if(NPA_Config["Core"]["SaveData"]~=1 or (not NPA_Data.NameToGUID))then
			NPA_Data.NameToGUID={}
		end
	
		if(NPA_Config["Core"]["SaveData"]~=1)then
			NPA_UnitData={}
			NPA_UnitData_NameToGUID={}
		else
			NPA_UnitData=NPA_Data.Unit
			NPA_UnitData_NameToGUID=NPA_Data.NameToGUID

			for _,unitdata in pairs(NPA_UnitData) do
				unitdata.Portrait=nil
			end
		end


		print("NamePlateAdvance Version "..NPA_Version.." Loaded")
		print("Detected interface version:"..(interfaceversion or "unknow"))
		print("type /npa for options")

		NPA_MainFrame:UnregisterEvent("VARIABLES_LOADED")
		NPA_MainFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
		NPA_MainFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
		NPA_MainFrame:RegisterEvent("FRIENDLIST_UPDATE")
		NPA_MainFrame:RegisterEvent("GUILD_ROSTER_UPDATE")
		NPA_MainFrame:RegisterEvent("PARTY_MEMBERS_CHANGED")
		NPA_MainFrame:RegisterEvent("RAID_ROSTER_UPDATE")
		NPA_MainFrame:RegisterEvent("CVAR_UPDATE")
		NPA_MainFrame:SetScript("OnUpdate",NPA_OnUpdate)
	end,
	["PARTY_MEMBERS_CHANGED"]=function()
		NPA_Core_PartyNameCache={}
		NPA_Core_RaidNameCache={}

		local playername=UnitName("player")
		local raidn=GetNumRaidMembers()
		if(raidn)then
			for i=1,raidn do
				local name=UnitName("raid"..i)
				if(name~=playername)then
					NPA_Core_RaidNameCache[name]=1
				end
			end
		end

		local partyn=GetNumPartyMembers()
		if(partyn)then
			for i=1,partyn do
				local name=UnitName("party"..i)
				NPA_Core_PartyNameCache[name]=1
			end
		end

	end,
	["RAID_ROSTER_UPDATE"]=function()
		NPA_Core_PartyNameCache={}
		NPA_Core_RaidNameCache={}
		
		local playername=UnitName("player")

		local raidn=GetNumRaidMembers()
		if(raidn)then
			for i=1,raidn do
				local name=UnitName("raid"..i)
				if(name~=playername)then
					NPA_Core_RaidNameCache[name]=1
				end
			end
		end
		local partyn=GetNumPartyMembers()
		if(partyn)then
			for i=1,partyn do
				local name=UnitName("party"..i)
				NPA_Core_PartyNameCache[name]=1
			end
		end

	end,
	["FRIENDLIST_UPDATE"]=function()
		NPA_Core_FriendNameCache={}
		--numberOfFriends, onlineFriends = GetNumFriends()
		local num = GetNumFriends() or 0
		local myname=UnitName("player")
		for i=1,num do
			--name, level, class, area, connected, status, note = GetFriendInfo(friendIndex);
			local name,_,_,_,connected=GetFriendInfo(i)
			if(connected and name and name~=myname)then
				NPA_Core_FriendNameCache[name]=1
			end
		end

	end,
	["GUILD_ROSTER_UPDATE"]=function()
		NPA_Core_GuildNameCache={}
		--numTotalMembers, numOnlineMembers = GetNumGuildMembers();
		local num = GetNumGuildMembers() or 0
		local myname=UnitName("player")
		for i=1,num do
			--name, rank, rankIndex, level, class, zone, note, 
			--officernote, online, status, classFileName, 
			--achievementPoints, achievementRank, isMobile = GetGuildRosterInfo(index);
			local name,_,_,_,_,_,_,_,online = GetGuildRosterInfo(i)
			if(online and name~=myname)then
				NPA_Core_GuildNameCache[name]=1
			end
		end
		
	end,

	["CVAR_UPDATE"]=function()
		if(NPA_Core_Config["NotClassColor"]~=1)then
			SetCVar("ShowClassColorInNameplate",1)
		end

	end,
	}

function NPA_Core:RegisteEvent(event,func)
	NPA_OnMainEventFilterFunction[event]=func
	if(func)then
		NPA_MainFrame:RegisterEvent(event)
	else
		NPA_MainFrame:UnregisterEvent(event)
	end
end

local function NPA_Core_BuildTypeCache(guid,flag)
--skip player
	if(bit_band(flag,COMBATLOG_OBJECT_TYPE_PLAYER)>0)then
		NPA_Core_TypeCache[guid]=nil
	else
		if(bit_band(flag,COMBATLOG_OBJECT_TYPE_PET)>0)then
			if(bit_band(flag,COMBATLOG_OBJECT_REACTION_HOSTILE)>0)then
				NPA_Core_TypeCache[guid]=5  --5 means hostile pet
			else
				NPA_Core_TypeCache[guid]=2  --2 means non-hostile pet
			end
		elseif(bit_band(flag,COMBATLOG_OBJECT_TYPE_GUARDIAN)>0)then
			if(bit_band(flag,COMBATLOG_OBJECT_REACTION_HOSTILE)>0)then
				NPA_Core_TypeCache[guid]=6  --6 means hostile guardian
			else
				NPA_Core_TypeCache[guid]=3  --3 means non-hostile guardian
			end
		end
	end
end

------------------------------------------
local NPA_Core_PowerMatchFunc=function(uarg)
		if(NPA_CombatLog_Health[uarg[2]] and bit_band(uarg[8],COMBATLOG_OBJECT_TYPE_PLAYER)<=0  and NPA_UnitData[uarg[6]])then
			local name=NPA_UnitData[uarg[6]].Name
			local health=NPA_UnitData[uarg[6]].GuessedHealth
	
			if(health==nil or health<2)then
				return
			else
				if(NPA_NameHealthToGUID[name]==nil)then
					NPA_NameHealthToGUID[name]={}
				end
				NPA_NameHealthToGUID[name][health]=nil
				
				local value

				if(NPA_CombatLog_Health[uarg[2]]==1)then
					value=-uarg[9]

				elseif(NPA_CombatLog_Health[uarg[2]]==2)then
					value=-uarg[12]
				
				elseif(NPA_CombatLog_Health[uarg[2]]==3)then
					value=(uarg[12]-uarg[13]-uarg[14])
				end
				
				health=health+value

				local healthmax=NPA_UnitData[uarg[6]].HealthMax
				if(health>1 and health<healthmax and NPA_GUIDMatched[uarg[6]]~=1)then
					NPA_NameHealthToGUID[name][health]=uarg[6]
				elseif(health<=1)then
					health=1
				elseif(health>healthmax)then
					health=NPA_UnitData[uarg[6]].HealthMax
				end

				NPA_UnitData[uarg[6]].GuessedHealth=health
				NPA_UnitData[uarg[6]].LastGuessed=uarg["Time"]
			end
		end
	end
------------------------------------------------------------------
local NPA_Core_AuraCollectFunc=function(uarg)
		local filter=NPA_CombatLog_Filter[uarg[2]]
		if(filter)then
			NPA_OnEventFilterFunction[filter[1]](uarg,filter)
		end
	end
-----------------------------------------------------------------
local NPA_Core_CombatLogCollectFunc	=function(uarg)
		NPA_Core_CheckUnitData(uarg[3],uarg["Time"],uarg[4])
		NPA_Core_CheckUnitData(uarg[6],uarg["Time"],uarg[7])

		NPA_Core_BuildTypeCache(uarg[3],uarg[5])
		NPA_Core_BuildTypeCache(uarg[6],uarg[8])
	end
-----------------------------------------------------------------
function NPA_Core:GetCurrentModules()
	local templist={}
	for key,_ in pairs(NPA_Core_GUIDModules) do
		templist[key]=1
	end
	for key,_ in pairs(NPA_Core_FrameModules) do
		templist[key]=1
	end
	return templist
end
-------------------------------------------------------------------
function NPA_Core:BuildModuleList(frame,list)
	if(not list)then
		list={}
	end
	local rlist={}
	for key,func in pairs(NPA_Core_GUIDModules) do
		if(list[key])then
			rlist[key]=func
		end
	end
	frame.GUIDModule=CopyTable(rlist)
	rlist={}
	for key,func in pairs(NPA_Core_FrameModules) do
		if(list[key])then
			rlist[key]=func
		end
	end
	frame.FrameModule=CopyTable(rlist)
	return
end

--------------------------------------------------------------------
local function NPA_Core_BuildLayerList()
	NPA_Core_LayerList={}

	local sortedtable=CopyTable(NPA_Core_Config["LayerData"])
	for name,value in pairs(sortedtable)do
		if(name~="DeepCheck")then
			if(value~=0)then
				NPA_Core_LayerList[name]=3-value
			else
				NPA_Core_LayerList[name]=0
			end
		end
	end
end
--------------------------------------------------------------------
local function NPA_Core_BuildModuleLists()
	-- index=[hostile]  [player]
	--[0][0]=frienly + non-player
	--[0][1]=frienly + player
	--[1][1]=hostile + player
	NPA_Core_EnabledModuleList={
		[0]={
			[0]={},
			[1]={},
			},
		[1]={
			[0]={},
			[1]={},
			},
		}
	for name,value in pairs(NPA_Core_Config["NonHostileNonPlayerModuleList"]) do
		if(name~="DeepCheck" and value==1)then
			NPA_Core_EnabledModuleList[0][0][name]=1
		end
	end
	for name,value in pairs(NPA_Core_Config["NonHostilePlayerModuleList"]) do
		if(name~="DeepCheck"and value==1)then
			NPA_Core_EnabledModuleList[0][1][name]=1
		end
	end
	for name,value in pairs(NPA_Core_Config["HostileNonPlayerModuleList"]) do
		if(name~="DeepCheck"and value==1)then
			NPA_Core_EnabledModuleList[1][0][name]=1
		end
	end
	for name,value in pairs(NPA_Core_Config["HostilePlayerModuleList"]) do
		if(name~="DeepCheck"and value==1)then
			NPA_Core_EnabledModuleList[1][1][name]=1
		end
	end

	NPA_Core_MainEnabledModuleList={}

	for name,value in pairs(NPA_Core_Config["MainModuleList"]) do
		if(name~="DeepCheck"and value==1)then
			NPA_Core_MainEnabledModuleList[name]=1
		end
	end
	-----------------------------------
	for name,_ in pairs(NPA_Core_FrameModules) do
		if(NPA_Core_Config["EnableModule"][name]~=1)then
			NPA_Core_FrameModules[name]=nil
		end
	end
	for name,_ in pairs(NPA_Core_GUIDModules) do
		if(NPA_Core_Config["EnableModule"][name]~=1)then
			NPA_Core_GUIDModules[name]=nil
		end
	end
	for name,value in pairs(NPA_Core_Config["EnableModule"]) do
		if(value==1 and name~="DeepCheck")then
			if(NPA_Core_Back_FrameModules[name])then
				NPA_Core_FrameModules[name]=NPA_Core_Back_FrameModules[name]
			elseif(NPA_Core_Back_GUIDModules[name])then
				NPA_Core_GUIDModules[name]=NPA_Core_Back_GUIDModules[name]
			end
		end
	end


end

function NPA_Core:ApplyConfig()
--apply size
	if(NPA_Core_ModuleList["AutoHide"])then
		NPA_Core_ModuleList["AutoHide"]:ApplySize()
	end

	NPA_Core:CheckConfigEntry("Core",NPA_Core_DefaultSetting)
	NPA_Core_Config=NPA_Config["Core"]
	
	NPA_Core_BuildCollectFunc()

	NPA_Core_UnitData_UpdateInterval=NPA_Core_Config["UnitData_UpdateInterval"]
	NPA_Core_UnitData_RecentUpdateInterval=NPA_Core_UnitData_UpdateInterval+0.5
	NPA_Core_UnitData_FrameUpdateInterval=NPA_Core_Config["Frame_UpdateInterval"]

	for _,frame in pairs(NPA_Core_Frame) do
		local modulemain=frame.ModuleMain
		modulemain:Hide()
		modulemain:SetScale(NPA_Core_Config["GlobalSize"])
		modulemain:SetAlpha(1)
		modulemain:SetPoint("CENTER",frame,"CENTER",NPA_Core_Config["OffsetX"],NPA_Core_Config["OffsetY"])
	
		NPA_Core_HookFrameFunc(modulemain)

		NPA_Modules_HideAll(modulemain,NPA_Core_FrameModules)
		NPA_Modules_HideAll(modulemain,NPA_Core_GUIDModules)

		NPA_ClearGUID(frame)
	end

	NPA_Core_BuildModuleLists()
	
	for _,frame in pairs(NPA_Core_Frame) do
		if(frame:IsShown())then
			frame.ModuleMain:Show()
		end
	end
		
	NPA_Core_BuildCombatLogFilter()

	if(NPA_Core_Config["PowerMatch"]==1)then
		CombatEventFunc["PowerMatch"]=NPA_Core_PowerMatchFunc
	else
		CombatEventFunc["PowerMatch"]=nil
	end

	if(NPA_Core_Config["CollectUnitFromCombatLog"]==1)then
		CombatEventFunc["CollectUnitFromCombatLog"]=NPA_Core_CombatLogCollectFunc
	else
		CombatEventFunc["CollectUnitFromCombatLog"]=nil
	end

	if(NPA_Core_Config["CollectAuraFromCombatLog"]==1)then
		CombatEventFunc["CollectAura"]=NPA_Core_AuraCollectFunc
	else
		CombatEventFunc["CollectAura"]=nil
	end

	if(NPA_Core_Config["Enabled"]==1)then
		NPA_OnMainEventFilterFunction["COMBAT_LOG_EVENT_UNFILTERED"]=function(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20,arg21,arg22,arg23)

		local uarg={
			[1]=arg1 or 0,
			[2]=arg2 or 0,
			[3]=arg3 or 0,
			[4]=arg4 or 0,
			[5]=arg5 or 0,
			[6]=arg6 or 0,
			[7]=arg7 or 0,
			[8]=arg8 or 0,
			[9]=arg9 or 0,
			[10]=arg10 or 0,
			[11]=arg11 or 0,
			[12]=arg12 or 0,
			[13]=arg13 or 0,
			[14]=arg14 or 0,
			[15]=arg15 or 0,
			[16]=arg16 or 0,
			[17]=arg17 or 0,
			[18]=arg18 or 0,
			[19]=arg19 or 0,
			[20]=arg20 or 0,
			[21]=arg21 or 0,
			[22]=arg21 or 0,
			[23]=arg21 or 0,
			["Time"]=GetTime(),
			[0]=0
			}

		--lastlog
		local nTime=GetTime()

		--track buff&debuff
		--wild match

		for _,func in pairs(CombatEventFunc) do
			func(uarg)
		end

		end
	else
		NPA_OnMainEventFilterFunction["COMBAT_LOG_EVENT_UNFILTERED"]=nil
	end

	NPA_Core_BuildLayerList()
end



function NPA_Core:ClearData()
	NPA_UnitData={}
end





local function NPA_OnEvent_PRE41(this,event,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20)
	--timestamp , event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellID,spellName,spellSchool

	--handle events
	local checkevent=NPA_OnMainEventFilterFunction[event]
	if(checkevent) then
		checkevent(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20)
	end
end
local function NPA_OnEvent_41(this,event,arg1,arg2,arg21,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20)
	--timestamp , event, sourceGUID, hideCaster, sourceName, sourceFlags, destGUID, destName, destFlags, spellID,spellName,spellSchool

	--handle events
	local checkevent=NPA_OnMainEventFilterFunction[event]
	if(checkevent) then
		checkevent(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20,arg21)
	end
end
local function NPA_OnEvent_42(this,event,arg1,arg2,arg21,arg3,arg4,arg5,arg22,arg6,arg7,arg8,arg23,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20)
	--timestamp , event, sourceGUID, hideCaster, sourceName, sourceFlags, sourceRaidFlag, destGUID, destName, destFlags, destRaidFlag, spellID,spellName,spellSchool

	--handle events
	local checkevent=NPA_OnMainEventFilterFunction[event]
	if(checkevent) then
		checkevent(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20,arg21,arg22,arg23)
	end
end


--slash command handler
_G["SLASH_NPA1"]="/NPA"
SlashCmdList["NPA"]=function(cmd)
	local loaded, reason=LoadAddOn("NPA_Options")
	if(loaded)then
		NPA_Options.MainFrame:Show()
		NPA_Options.MainFrame:SetPoint("CENTER",UIParent,"CENTER",0,0)
	else
		print("Options Load Error:"..reason)
	end
end



function NPA_Core:CheckConfigEntry(masterkey,default)
	if((not NPA_Config[masterkey]) or type(NPA_Config[masterkey])~="table")then
		NPA_Config[masterkey]=default
		return
	end

	for key,value in pairs(default) do
		if(type(value)=="table")then
			if(NPA_Config[masterkey][key]==nil)then
				NPA_Config[masterkey][key]=CopyTable(value)
			elseif(value.DeepCheck==1)then
				for akey,avalue in pairs(value) do
					if(NPA_Config[masterkey][key][akey]==nil)then
						NPA_Config[masterkey][key][akey]=avalue
					end
				end
			end
		else
			if(NPA_Config[masterkey][key]==nil)then
				NPA_Config[masterkey][key]=value
			end

		end
					
	end
	for key,value in pairs(NPA_Config[masterkey]) do
		if(default[key]==nil)then
			NPA_Config[masterkey][key]=nil
		else
			if(type(default[key])=="table" and default[key].DeepCheck==1)then
				for akey,avalue in pairs(value)do
					if(default[key][akey]==nil)then
						NPA_Config[masterkey][key][akey]=nil
					end
				end
			end
		end
	end

	if(NPA_Profiles["Seperate"]==1)then
		local key=GetRealmName().."-"..GetUnitName("Player")
		NPA_Profiles[key][masterkey]=CopyTable(NPA_Config[masterkey])
	end
end


----return data 
function NPA_Core_GetUnitData(guid)
	return NPA_UnitData[guid]
end


--onload function
NPA_MainFrame=CreateFrame("Frame","NPA_Core_Frame",UIParent)
NPA_MainFrame:RegisterEvent("VARIABLES_LOADED")
if(interfaceversion<40100)then
	NPA_MainFrame:SetScript("OnEvent",NPA_OnEvent_PRE41)
elseif(interfaceversion<40200)then
	NPA_MainFrame:SetScript("OnEvent",NPA_OnEvent_41)
else
	NPA_MainFrame:SetScript("OnEvent",NPA_OnEvent_42)
end


function NPA_Core:Test()
	local nTime=GetTime()

	--aura
	local aura={}

	if(NPA_Config["Aura"])then

	local spellcache=NPA_Core.SpellData

	local stealable
	--if(random()>0.5)then
		stealable=1
	--end
	NPA_Core.SpellData[-100]={
			School=floor(random()*10),
			Stealable=stealable,
			Name="TestAura",
			Icon="Interface\\Icons\\INV_Misc_Herb_Felblossom",
			Type="BUFF",
			}
	if(random()>0.5)then
		stealable=1
	else
		stealable=nil
	end

	NPA_Core.SpellData[-101]={
			School=floor(random()*10),
			Stealable=stealable,
			Name="TestAura2",
			Icon="Interface\\Icons\\Ability_Rogue_KidneyShot",
			Type="DEBUFF",
			}

	---------------
	NPA_Core.SpellData[-99]={
			School=1,
			Stealable=1,
			Name="BuffAnchor",
			Icon="Interface\\Addons\\NPA\\texture\\Anchor",
			Type="BUFF",
			}
	NPA_Core.SpellData[-98]={
			School=1,
			Stealable=1,
			Name="DebuffAnchor",
			Icon="Interface\\Addons\\NPA\\texture\\Anchor",
			Type="DEBUFF",
			}
	

	local buff={
		CasterGUID=UnitGUID("player"),
		Count=1,
		ExpirationTime=nTime+1000
		}
	aura[-99]={[1]=CopyTable(buff)}

	aura[-98]={[1]=CopyTable(buff)}


	local id=-100

	for i=1,NPA_Config["Aura"]["Aura_MaxBuff"]-1 do

		local casterguid
		if(random()>0.5)then
			casterguid=UnitGUID("player")
		else
			casterguid=-100
		end
		local count=1+floor(random()*5)
		local exTime=nTime+random()*100+5
		local buff={
			CasterGUID=casterguid,
			Count=count,
			ExpirationTime=exTime
			}

		if(not aura[id])then
			aura[id]={[1]=buff}
		else
			table_insert(aura[id],buff)
		end
	end

	local id=-101

	for i=1,NPA_Config["Aura"]["Aura_MaxDebuff"]-1 do

		local casterguid
		if(random()>0.5)then
			casterguid=UnitGUID("player")
		else
			casterguid=-100
		end
		local count=1+floor(random()*5)
		local exTime=nTime+random()*100+5
		local buff={
			CasterGUID=casterguid,
			Count=count,
			ExpirationTime=exTime
			}

		if(not aura[id])then
			aura[id]={[1]=buff}
		else
			table_insert(aura[id],buff)
		end

	end
	end


	--casting
	-- spellname, rank, displayName, icon, startTime, endTime, isTradeSkill, castID, notinterrupt
	local notinterrupt
	if(random()>0.5)then
		notinterrupt=1
	end

	local channel
	if(random()>0.5)then
		channel=1
	end
	
	local castinfo={
		SpellId=nil,
		Name="Test Spell",
		Icon="Interface\\Icons\\Spell_Shadow_ShadowBolt",
		StartTime=nTime,
		EndTime=random()*10+nTime,	
		Channel=channel,
		NotInterrupt=notinterrupt
	}

	nTime=nTime+100
	local isplayer
	if(random()>0.5)then
		isplayer=1
	end
	local boss
	if(random()>0.5)then
		boss="worldboss"
	end
	local classdata={}
	for class,_ in pairs(CLASS_ICON_TCOORDS) do
		table_insert(classdata,class)
	end
	local class=classdata[floor(random()*table_getn(classdata))]
	

	NPA_UnitData[-100]={
		GUID=-100,
		Name="Test object",

		Health=floor(random()*1000000),
		HealthMax=floor(random()*1000000)+1000000,
		Mana=floor(random()*1000000),
		ManaMax=floor(random()*1000000)+1000000,
		
		ThreatPercent=floor(random()*100),
		ThreatStatus=floor(random()*6),

		Speed=floor(random()*400),

		ClassMark=class,
		Classification=boss,

		PowerType=floor(random(3)),

		InCombat=1,

		IsEnemy=floor(random()),
		IsFriend=floor(random()),
		IsPlayer=isplayer,
		Level=floor(random()*88),

		Target={TargetGUID=UnitGUID("player"),
			TargetName=UnitName("player"),
			IsPlayerEnemy=floor(random()),
			IsPlayerFriend=UnitIsFriend("player","player"),
			IsEnemy=UnitIsFriend("player","player"),
			IsFriend=UnitIsFriend("player","player"),
			},

		
		Range={Min=floor(random()*25),Max=floor(random()*20+25)},
		
		Aura=aura,
		
		CastInfo=castinfo,

		LastUpdate=nTime,

		GuessedHealth=floor(random()*1000000),
		LastGuessed=nTime,

		LastLog=nTime,
		
		SpellSchool=2^floor(random()*6),

		TargetCount={
			[1]=floor(random()*10),
			[2]=floor(random()*10),
			[3]=floor(random()*10),
			[4]=floor(random()*10)
			},

		Guild="Test Guild"
		}
end

function NPA_Core:GenerateTest()
	for name,main in pairs(NPA_Core_ModuleList) do
		if(main.Test)then
			main.Test()
		end
	end
end

function NPA_Core:CheckAura(guid,id)
	local unitdata=UnitData[guid]
	if(not unitdata)then
		return
	end
	local aura=unitdata.Aura
	if(not aura)then
		return
	end
	for spellid,auras in pairs(aura) do
		if(table_getn(auras)>0)then
			if(spellid==id)then
				return 1
			end
		end
	end
	return
end


--------spellid in tip
--copied from idtip


local function idtip_addLine(self,id,isItem)
	self:AddLine("SpellID: |cffffff00"..id)
end

-- Spell Hooks ----------------------------------------------------------------
hooksecurefunc(GameTooltip, "SetUnitBuff", function(self,...)
	if(NPA_Core_Config["idtip"]==1)then
		local id = select(11,UnitBuff(...))
		if id then idtip_addLine(self,id) end
	end
end)

hooksecurefunc(GameTooltip, "SetUnitDebuff", function(self,...)
	if(NPA_Core_Config["idtip"]==1)then
		local id = select(11,UnitDebuff(...))
		if id then idtip_addLine(self,id) end
	end
end)

hooksecurefunc(GameTooltip, "SetUnitAura", function(self,...)
	if(NPA_Core_Config["idtip"]==1)then
		local id = select(11,UnitAura(...))
		if id then idtip_addLine(self,id) end
	end
end)

GameTooltip:HookScript("OnTooltipSetSpell", function(self)
	if(NPA_Core_Config["idtip"]==1)then
		local id = select(3,self:GetSpell())
		if id then idtip_addLine(self,id) end
	end
end)
