-- Author      : Nogarder
-- Create Date : 2010/7/4 18:39:17


local NPA_exCombat_TargetGUID=nil
local NPA_exCombat_Num=0
local bit_band=bit.band
local floor=floor

local NPA_exCombat={}
--config
local NPA_exCombat_DefaultSetting={
		["exCombat_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["exCombat_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=15,
			Width=18,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\combaticon",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["exCombat_BarOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=30,
			Width=30,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["exCombat_BarBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=30,
			Width=30,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\combaticonbg",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["exCombat_OffsetX"]=-75,
		["exCombat_OffsetY"]=25,

		["exCombat_Color"]=0,
		["exCombat_ShowText"]=1,
		["exCombat_ShowBar"]=1,

	}
local NPA_exCombat_Config=NPA_exCombat_DefaultSetting

function NPA_exCombat:ResetConfig()
	NPA_Config["exCombat"]=CopyTable(NPA_exCombat_DefaultSetting)
end


--global function
local UnitGUID=UnitGUID

local NPA_exCombat_Frame={}
local table_insert=table.insert

function NPA_exCombat:GetexCombat()
	return NPA_exCombat_Num
end

local ManageBar=NPA_Core.ManageBar

local NPA_exCombat_Data={}
local NPA_Combat_Length=6


local function NPA_exCombat_OnUpdate(nTime,self,guid,unitdata,_,_,_,_,_,_,recentUpdated)
	local data=NPA_exCombat_Data[guid]
	local timeleft
	if(data)then
		timeleft=data-nTime
	else
		timeleft=0
	end
	if(unitdata)then
		petguid=unitdata.PetGUID
		if(petguid)then
			local petdata=NPA_exCombat_Data[petguid]
			if(petdata)then
				local pettimeleft=petdata-nTime
				if(pettimeleft>timeleft)then
					timeleft=pettimeleft
				end
			end
		end
	end

	if(timeleft>0 and (not(recentUpdated and unitdata.InCombat==nil)) )then
		local percent=timeleft/NPA_Combat_Length
		local bpercent=1-percent


		if(NPA_exCombat_Config["exCombat_ShowBar"]==1)then
			local bar=self.Bar
			bar.Percent=percent
			ManageBar(nil,bar)
			if(NPA_exCombat_Config["exCombat_Color"]==1)then
				bar:SetVertexColor(bar.R*percent,bar.G*bpercent,bar.B)
			end
		else
			self.Bar:Hide()
		end

		if(NPA_exCombat_Config["exCombat_ShowText"]==1)then
			local text=self.Text
			text:SetText(floor(timeleft))
			text:SetTextColor(text.R*percent,text.G*bpercent,0)
			text:Show()
		else
			self.Text:Hide()
		end

		self:Show()
	elseif(recentUpdated and unitdata.ThreatStatus or unitdata.InCombat)then
		if(NPA_exCombat_Config["exCombat_ShowBar"]==1)then
			local bar=self.Bar
			bar.Percent=1
			ManageBar(nil,bar)
			bar:SetVertexColor(bar.R,bar.G,bar.B)
		else
			self.Bar:Hide()
		end

		self.Text:Hide()

		self:Show()
	else
		self:Hide()
	end
end


local NPA_exCombat_EventFilter={
	["SWING_DAMAGE"]=1,
	["SWING_MISS"]=1,
	["RANGE_DAMAGE"]=2,
	["RANGE_MISS"]=2,
	["SPELL_DAMAGE"]=3,
	["SPELL_MISS"]=3,
}

local NPA_exCombat_SpecialEventFilter={
	["SPELL_CAST_SUCCESS"]=3,
	["SPELL_HEAL"]=1,
	["SPELL_AURA_DISPELLED"]=1,
	["SPELL_AURA_APPLIED"]=2,
}


local function NPA_exCombat_OnEvent(uarg)
	local combatTime=GetTime()+NPA_Combat_Length
	if(NPA_exCombat_EventFilter[uarg[2]])then
		NPA_exCombat_Data[uarg[3] or 0]=combatTime
		NPA_exCombat_Data[uarg[6] or 0]=combatTime
	elseif(NPA_exCombat_SpecialEventFilter[uarg[2]] and uarg[3] and uarg[6])then
		if(uarg[3]~=uarg[6] and 
			((NPA_exCombat_Data[uarg[6]] and NPA_exCombat_Data[uarg[6]]>GetTime()) or 
			(bit_band(uarg[5],COMBATLOG_OBJECT_REACTION_HOSTILE)~=bit_band(uarg[8],COMBATLOG_OBJECT_REACTION_HOSTILE)) ) )then
			NPA_exCombat_Data[uarg[3]]=combatTime
		end
	end		
	
end


local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_exCombat_SetFrame(mainframe)
	mainframe:SetPoint("CENTER",mainframe:GetParent(),"CENTER",NPA_exCombat_Config["exCombat_OffsetX"],NPA_exCombat_Config["exCombat_OffsetY"])
	ManageTexture(nil,mainframe.Bar,NPA_exCombat_Config["exCombat_BarData"],mainframe,1)
	ManageTexture(nil,mainframe.Background,NPA_exCombat_Config["exCombat_BarBackgroundData"],mainframe)
	ManageTexture(nil,mainframe.Overlay,NPA_exCombat_Config["exCombat_BarOverlayData"],mainframe)

	ManageFont(nil,mainframe.Text,NPA_exCombat_Config["exCombat_TextData"],mainframe)

	if(NPA_exCombat_Config["exCombat_ShowBar"]==1)then
		mainframe.Background:Show()
		mainframe.Overlay:Show()
	else
		mainframe.Background:Hide()
		mainframe.Overlay:Hide()
	end
end

local function NPA_exCombat_HookFrame(frame)
	local mainframe=CreateFrame("Frame","NPA_exCombat_MainFrame",frame)
	mainframe:SetPoint("CENTER",frame,"CENTER")
	mainframe:SetHeight(1)
	mainframe:SetWidth(1)
	mainframe:Hide()

	local text=mainframe:CreateFontString("NPA_exCombat_Text","OVERLAY",nil)

	local bar=mainframe:CreateTexture("NPA_exCombat_Bar","ARTWORK",nil)
	local overlay=mainframe:CreateTexture("NPA_exCombat_Bar","OVERLAY",nil)
	local background=mainframe:CreateTexture("NPA_exCombat_Bar","BACKGROUND",nil)

	mainframe.Bar=bar
	mainframe.Background=background
	mainframe.Overlay=overlay
	mainframe.Text=text
	
	NPA_exCombat_SetFrame(mainframe)

	table_insert(NPA_exCombat_Frame,mainframe)

	frame["exCombat"]=mainframe
end

function NPA_exCombat:Test()
	NPA_exCombat_Data[-100]=GetTime()+random()*6
end

function NPA_exCombat:ApplyConfig()
	NPA_Core:CheckConfigEntry("exCombat",NPA_exCombat_DefaultSetting)

	NPA_exCombat_Config=NPA_Config["exCombat"]

	for _,mainframe in pairs(NPA_exCombat_Frame) do
		NPA_exCombat_SetFrame(mainframe)
	end


	if(NPA_Config["Core"]["EnableModule"]["exCombat"]==1)then
		NPA_Core.CombatEventFunc["exCombat"]=NPA_exCombat_OnEvent
	else
		NPA_Core.CombatEventFunc["exCombat"]=nil
	end
end


NPA_Core:AddHook("exCombat",NPA_exCombat_HookFrame)
NPA_Core:AddModule("exCombat",NPA_exCombat)
NPA_Core:HookUpdate("exCombat",NPA_exCombat_OnUpdate,2)