﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime
local pairs=pairs
local table_insert=table.insert
local bit_band=bit.band
local COMBATLOG_OBJECT_TYPE_PLAYER
local table_remove=table.remove

local NPA_Tracker_Frame={}
local NPA_Tracker_FrameSlot={}
local NPA_Tracker_GUIDList={}
local NPA_Tracker_Count=0

local NPA_Tracker_TrackList={}
local floor=floor
local abs=abs

local GUIDToFrame=NPA_Core.GUIDToFrame

local NPA_Tracker_UpdateInterval=0.2

local NPA_Tracker={}

local COMBATLOG_OBJECT_REACTION_HOSTILE=COMBATLOG_OBJECT_REACTION_HOSTILE

local NPA_Tracker_MainFrame=CreateFrame("Frame","NPA_Tracker_Frame",UIParent)
local NPA_Tracker_SelfFrame
local NPA_Tracker_PetFrame

--config
local NPA_Tracker_DefaultSetting={
		["Tracker_Frame_UpdateInterval"]=0.03,
		["Tracker_UpdateInterval"]=0.1,

		["Tracker_OffsetX"]=-400,
		["Tracker_OffsetY"]=110,
		["Tracker_Height"]=80,
		["Tracker_Width"]=180,
		["Tracker_Size"]=1,
		["Tracker_Count"]=4,
		["Tracker_Row"]=1,
		["Tracker_LeftWard"]=0,
		["Tracker_UpWard"]=0,
		["Tracker_Hostile"]=1,
		["Tracker_NonHostile"]=0,
		["Tracker_Aura"]=1,
		["Tracker_Cast"]=0,
		["Tracker_CastOnMe"]=1,
		["Tracker_CrowdControl"]=1,
		["Tracker_TimeOut"]=45,
		["Tracker_CounterSpell"]=1,
		["Tracker_CoolDown"]=0,

		["Tracker_Self"]=1,
		["Tracker_SelfOffsetX"]=0,
		["Tracker_SelfOffsetY"]=-100,
		["Tracker_SelfSize"]=1,
		["Tracker_SelfName"]=1,
		["Tracker_SelfAlpha"]=1,
		["Tracker_SelfEnableMouse"]=0,

		["Tracker_Pet"]=1,
		["Tracker_PetOffsetX"]=200,
		["Tracker_PetOffsetY"]=-100,
		["Tracker_PetSize"]=1,
		["Tracker_PetName"]=1,
		["Tracker_PetAlpha"]=1,
		["Tracker_PetEnableMouse"]=0,


		["Tracker_Focus"]=0,
		["Tracker_FocusOffsetX"]=-200,
		["Tracker_FocusOffsetY"]=-100,
		["Tracker_FocusSize"]=1,
		["Tracker_FocusName"]=1,
		["Tracker_FocusAlpha"]=1,
		["Tracker_FocusEnableMouse"]=0,

		["Tracker_Target"]=0,
		["Tracker_TargetOffsetX"]=0,
		["Tracker_TargetOffsetY"]=-150,
		["Tracker_TargetSize"]=1,
		["Tracker_TargetName"]=1,
		["Tracker_TargetAlpha"]=1,
		["Tracker_TargetEnableMouse"]=0,


		["Tracker_ModuleList"]={
			["Aura"]=1,
			["AutoHide"]=1,
			["CastWarning"]=1,
			["ClassIcon"]=1,
			["ComboPoint"]=1,
			["CoolDown"]=1,
			["CrowdControl"]=1,
			["HealthBar"]=1,
			["ManaBar"]=1,
			["RaidIcon"]=1,
			["Speed"]=1,
			["Target"]=1,
			["Threat"]=1,
			["QuestMark"]=1,
			["RangeCheck"]=1,

			["CounterSpell"]=1,
			["ClassInfo"]=1,
			["NameText"]=1,
			["TargetCount"]=1,
			["ShieldWatch"]=1,
			["exCombat"]=1,
			["RoleCheck"]=1,
			DeepCheck=1

			},

		["Tracker_SelfModuleList"]={
			["Aura"]=1,
			["AutoHide"]=1,
			["CastWarning"]=1,
			["ClassIcon"]=1,
			["ComboPoint"]=1,
			["CoolDown"]=1,
			["CrowdControl"]=1,
			["HealthBar"]=1,
			["ManaBar"]=1,
			["RaidIcon"]=1,
			["Speed"]=1,
			["Target"]=1,
			["Threat"]=1,
			["QuestMark"]=1,
			["RangeCheck"]=1,

			["CounterSpell"]=1,
			["ClassInfo"]=1,
			["NameText"]=1,
			["TargetCount"]=1,
			["ShieldWatch"]=1,
			["exCombat"]=1,
			["RoleCheck"]=1,
			DeepCheck=1

			},

		["Tracker_PetModuleList"]={
			["Aura"]=1,
			["AutoHide"]=1,
			["CastWarning"]=1,
			["ClassIcon"]=1,
			["ComboPoint"]=1,
			["CoolDown"]=1,
			["CrowdControl"]=1,
			["HealthBar"]=1,
			["ManaBar"]=1,
			["RaidIcon"]=1,
			["Speed"]=1,
			["Target"]=1,
			["Threat"]=1,
			["QuestMark"]=1,
			["RangeCheck"]=1,

			["CounterSpell"]=1,
			["ClassInfo"]=1,
			["NameText"]=1,
			["TargetCount"]=1,
			["ShieldWatch"]=1,
			["exCombat"]=1,
			["RoleCheck"]=1,
			DeepCheck=1

			},

		["Tracker_FocusModuleList"]={
			["Aura"]=1,
			["AutoHide"]=1,
			["CastWarning"]=1,
			["ClassIcon"]=1,
			["ComboPoint"]=1,
			["CoolDown"]=1,
			["CrowdControl"]=1,
			["HealthBar"]=1,
			["ManaBar"]=1,
			["RaidIcon"]=1,
			["Speed"]=1,
			["Target"]=1,
			["Threat"]=1,
			["QuestMark"]=1,
			["RangeCheck"]=1,

			["CounterSpell"]=1,
			["ClassInfo"]=1,
			["NameText"]=1,
			["TargetCount"]=1,
			["ShieldWatch"]=1,
			["exCombat"]=1,
			["RoleCheck"]=1,
			DeepCheck=1

			},


		["Tracker_TargetModuleList"]={
			["Aura"]=1,
			["AutoHide"]=1,
			["CastWarning"]=1,
			["ClassIcon"]=1,
			["ComboPoint"]=1,
			["CoolDown"]=1,
			["CrowdControl"]=1,
			["HealthBar"]=1,
			["ManaBar"]=1,
			["RaidIcon"]=1,
			["Speed"]=1,
			["Target"]=1,
			["Threat"]=1,
			["QuestMark"]=1,
			["RangeCheck"]=1,

			["CounterSpell"]=1,
			["ClassInfo"]=1,
			["NameText"]=1,
			["TargetCount"]=1,
			["ShieldWatch"]=1,
			["exCombat"]=1,
			["RoleCheck"]=1,
			DeepCheck=1

			},
	}
local NPA_Tracker_Config=NPA_Tracker_DefaultSetting

function NPA_Tracker:ResetConfig()
	NPA_Config["Tracker"]=CopyTable(NPA_Tracker_DefaultSetting)
end
local NPA_Tracker_Enable=0

local NPA_Tracker_CombatLogFilter={}
local function NPA_Tracker_BuildFilter()
	NPA_Tracker_CombatLogFilter={}

	if(NPA_Tracker_Config["Tracker_Aura"]==1)then
		NPA_Tracker_CombatLogFilter["SPELL_AURA_APPLIED"]=1
		NPA_Tracker_CombatLogFilter["SPELL_AURA_APPLIED_DOSE"]=1
		NPA_Tracker_CombatLogFilter["SPELL_AURA_REFRESH"]=1
	end

	if(NPA_Tracker_Config["Tracker_CounterSpell"]==1)then
		NPA_Tracker_CombatLogFilter["SPELL_INTERRUPT"]=1
	end

	if(NPA_Tracker_Config["Tracker_Cast"]==1)then
		NPA_Tracker_CombatLogFilter["SPELL_CAST_START"]=2
	elseif(NPA_Tracker_Config["Tracker_CastOnMe"]==1)then
		NPA_Tracker_CombatLogFilter["SPELL_CAST_START"]=3
	end

	if(NPA_Tracker_Config["Tracker_CoolDown"])then
		NPA_Tracker_CombatLogFilter["SPELL_CAST_SUCCESS"]=2
	end
end

--NPA_Tracker_BuildFilter()


local function NPA_Tracker_IsHostile(flag)
	local bit=bit.band(flag,COMBATLOG_OBJECT_REACTION_HOSTILE)
	if(bit>0)then
		return 1
	else
		return 0
	end
end

local function NPA_Tracker_AddTracker(arg6,arg8)
	
	local hostile=bit_band(arg8,COMBATLOG_OBJECT_REACTION_HOSTILE)

	if((hostile>0 and NPA_Tracker_Config["Tracker_Hostile"]==1) or
		(hostile<=0 and NPA_Tracker_Config["Tracker_NonHostile"]==1))then
		
		NPA_Tracker_TrackList[arg6]=1
	end
	
end



local function NPA_Tracker_FrameTargetPosition(slot)
	if(slot>0)then
		slot=slot-1
	end
	local row
	local col
	if(NPA_Tracker_Config["Tracker_LeftWard"]==1)then
		row=-1
	else
		row=1
	end

	if(NPA_Tracker_Config["Tracker_UpWard"]==1)then
		col=1
	else
		col=-1
	end
		

	local x=(slot % NPA_Tracker_Config["Tracker_Row"]) *NPA_Tracker_Config["Tracker_Width"] * row
	local y=floor(slot / NPA_Tracker_Config["Tracker_Row"])*NPA_Tracker_Config["Tracker_Height"] * col
	
	dx,dy=NPA_Tracker_MainFrame:GetCenter()
	x=x+dx
	y=y+dy

	return x,y
end

local GetUnitData=NPA_Core_GetUnitData

local function NPA_Tracker_Check(frame,key)
	if(frame)then
		local main=frame[key]
		if(main and main:IsShown())then
			return 1
		else
			return nil
		end
	end
end

local function NPA_Tracker_FindEmptySlot(limit)
	local range
	if(limit)then
		range=limit
	else
		range=NPA_Tracker_Config["Tracker_Count"]
	end

	for i=1,range do
		if(NPA_Tracker_FrameSlot[i]==nil)then
			return i
		end
	end
end

local function NPA_Tracker_ResortFrame()
	for i=1,NPA_Tracker_Config["Tracker_Count"] do
		if(NPA_Tracker_FrameSlot[i]==nil)then
			for j=i+1,NPA_Tracker_Config["Tracker_Count"] do
				if(NPA_Tracker_FrameSlot[j])then
					local index=j-1
					local frame=NPA_Tracker_Frame[NPA_Tracker_FrameSlot[j]]
					NPA_Tracker_FrameSlot[index]=NPA_Tracker_FrameSlot[j]
					NPA_Tracker_FrameSlot[j]=nil
					frame.Slot=index
					frame.TargetX,frame.TargetY=NPA_Tracker_FrameTargetPosition(index)
				end
			end
		end
	end
end

local function NPA_Tracker_FrameOnUpdate(self,elapsed)
	self.TimeStack=self.TimeStack+elapsed
	if(self.TimeStack<NPA_Tracker_Config["Tracker_Frame_UpdateInterval"])then
		return
	end


	local selfguid=UnitGUID("player")
	local petguid=UnitGUID("playerpet")
	local focusguid=UnitGUID("focus")
	local targetguid=UnitGUID("target")

	local modulemain=self.ModuleMain

	local nTime=GetTime()


	if(self.Type)then
		local type=self.Type
		if(type==1)then
			if(selfguid)then
				NPA_Tracker_GUIDList[selfguid]=1

				self.GUID=selfguid
				GUIDToFrame[selfguid]=self
				modulemain.GUID=selfguid
				modulemain:Show()
			else
				modulemain:Hide()
			end
		elseif(type==2)then
			if(petguid)then
				NPA_Tracker_GUIDList[petguid]=1

				self.GUID=petguid
				GUIDToFrame[petguid]=self
				modulemain.GUID=petguid
				modulemain:Show()
			else
				modulemain:Hide()
			end
		elseif(type==3)then
			if(focusguid)then
				self.GUID=focusguid
				modulemain.GUID=focusguid
				modulemain:Show()
			else
				modulemain:Hide()
			end
		elseif(type==4)then
			if(targetguid)then
				self.GUID=targetguid
				modulemain.GUID=targetguid
				modulemain:Show()
			else
				modulemain:Hide()
			end
		end
		return
	elseif(self.GUID==nil or (self.GUID==focusguid and NPA_Tracker_Config["Tracker_Focus"]==1) or 
		(self.GUID==targetguid and NPA_Tracker_Config["Tracker_Target"]==1))then
		self:Hide()
		return
	end

	local guid=self.GUID
	local frame=GUIDToFrame[guid]
	local framemodulemain
	if(frame)then
		framemodulemain=frame.ModuleMain	
	end

	local show

	if( (NPA_Tracker_Config["Tracker_Aura"]==1 and (NPA_Tracker_Check(modulemain,"Aura") or NPA_Tracker_Check(framemodulemain,"Aura"))) or
		((NPA_Tracker_Config["Tracker_Cast"]==1 or NPA_Tracker_Config["Tracker_CastOnMe"]==1) and (NPA_Tracker_Check(modulemain,"CastWarning") or NPA_Tracker_Check(framemodulemain,"CastWarning"))) or
		(NPA_Tracker_Config["Tracker_CrowdControl"]==1 and (NPA_Tracker_Check(modulemain,"CrowdControl") or NPA_Tracker_Check(framemodulemain,"CrowdControl"))) or
		(NPA_Tracker_Config["Tracker_CounterSpell"]==1 and (NPA_Tracker_Check(modulemain,"CounterSpell") or NPA_Tracker_Check(framemodulemain,"CounterSpell"))) or
		(NPA_Tracker_Config["Tracker_CoolDown"]==1 and (NPA_Tracker_Check(modulemain,"CoolDown") or NPA_Tracker_Check(framemodulemain,"CoolDown")))	)then

		show=1

	elseif(nTime<self.SpawnTime)then
		return
	end

	
	local unitdata=GetUnitData(guid)
	if(unitdata==nil or show==nil or (unitdata.GuessedHealth and unitdata.GuessedHealth<1)  or (unitdata.LastLog==nil or nTime-unitdata.LastLog>NPA_Tracker_Config["Tracker_TimeOut"]) or NPA_Tracker_Enable~=1)then
		modulemain:Hide()
		self:Hide()
		NPA_Tracker_GUIDList[guid]=nil

		NPA_Tracker_FrameSlot[self.Slot]=nil
		NPA_Tracker_Count=NPA_Tracker_Count-1

		self.GUID=nil
		self.TimeStack=0

		NPA_Tracker_ResortFrame()

		return
	end

	modulemain.GUID=guid

	local targettype

	if(frame and frame:IsShown())then
		local targetx=frame:GetLeft() or 0
		local targety=frame:GetBottom() or 0

		self.TargetX=targetx
		self.TargetY=targety

		targettype=1

		if(self.Slot~=0)then
			NPA_Tracker_FrameSlot[self.Slot]=nil
			self.Slot=0
		end
	elseif(self.Slot==0)then
		local i=NPA_Tracker_FindEmptySlot()
		if(i)then
			NPA_Tracker_FrameSlot[i]=self.Index
			self.Slot=i
			self.TargetX,self.TargetY=NPA_Tracker_FrameTargetPosition(i)
		end
	end

	local currentx=self:GetLeft() or 0
	local currenty=self:GetBottom() or 0
	local targetx=self.TargetX
	local targety=self.TargetY

	if(currentx~=targetx or currenty~=targety)then
		local timestep=self.TimeStack
		local width=targetx-currentx
		local height=targety-currenty
		local stepx=width*timestep*4
		local stepy=height*timestep*4

		local x
		local y
		local alpha

		if(targettype==1)then
			if(abs(width)<15 and abs(height)<15)then
				x=targetx
				y=targety
				alpha=0.01
			else
				x=currentx+stepx
				y=currenty+stepy
				alpha=abs(width+height)/500
			end
		else
			if(abs(width)<15 and abs(height)<15)then
				x=targetx
				y=targety
				alpha=1
			else
				x=currentx+stepx
				y=currenty+stepy
				alpha=1-(width+height)/500
			end
		end
		if(alpha<0.01)then
				alpha=0.01
		end
		self:SetAlpha(alpha)
		self:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",x,y)
		modulemain:Show()
	else
		if(targettype==1)then
			self:SetAlpha(0.01)
		else
			self:SetAlpha(1)
		end
	end

	self.TimeStack=0
end


local function NPA_Tracker_CreateFrame(modulelist)
	local frame=CreateFrame("Frame","NPA_Tracker_Frame",NPA_Tracker_MainFrame)
	frame:SetHeight(20)
	frame:SetWidth(160)
	frame:Hide()
	frame:SetScript("OnUpdate",NPA_Tracker_FrameOnUpdate)

	--module mainframe


	local rendermain=CreateFrame("Frame","NPA_RenderMainFrame",frame)
	rendermain:SetHeight(1)
	rendermain:SetWidth(1)
	rendermain:SetPoint("CENTER",frame,"CENTER")
	rendermain.Attach=frame
	rendermain:Show()

	local modulemain=CreateFrame("Frame","NPA_RenderMainFrame",rendermain)
	modulemain:SetHeight(20)
	modulemain:SetWidth(120)
	modulemain:SetPoint("CENTER",frame,"CENTER")
	modulemain:Show()
	modulemain:SetScale(NPA_Tracker_Config["Tracker_Size"])

	modulemain.Parent=frame
	modulemain.TimeStack=100


	--scroll frame
	local scrollframe=CreateFrame("ScrollFrame","NPA_ScrollMainFrame",frame)
	scrollframe:SetHeight(512)
	scrollframe:SetWidth(512)
	scrollframe:SetPoint("CENTER",frame,"CENTER")
	scrollframe:SetScrollChild(rendermain)
	scrollframe:SetFrameStrata("BACKGROUND")
	scrollframe:Show()

	modulemain.RenderMain=scrollframe
	frame.IsTracker=1

	NPA_Core:HookAll(modulemain)

	modulemain.ModuleList=modulelist
	
	frame.ModuleMain=modulemain

	frame:EnableMouse(false)
	
	NPA_Core:SetOnHide(modulemain)

	NPA_Core:HookModuleMain(modulemain)
			

	frame.Slot=0
	frame.TimeStack=0
	frame.SpawnTime=0

	return frame
end

local function NPA_Tracker_InitSpecialFrame(enable,unit,frame,modulelist,offsetx,offsety,size,alpha,showname,enablemouse,type)
	if(enable==1 and NPA_Tracker_Enable==1)then
		if(not frame)then
			frame=NPA_Tracker_CreateFrame(modulelist)
			frame:HookScript("OnHide",function(self)
					if(self.Name)then
						self.Name:Hide()
					end
				end)
		end
		frame:Hide()

		frame:SetPoint("CENTER",UIParent,"CENTER",offsetx,offsety)
		frame.GUID=0


		local main=frame.ModuleMain
		main:SetScale(size)
		main:SetAlpha(alpha)

		main.ModuleList=modulelist


		local name=main["NameText"]
		if(not name)then
			name=frame.Name
		end
	
		if(name)then
			if(showname==1)then
				main["NameText"]=name
				name:Show()
			else
				frame.Name=name
				name:Hide()
				main["NameText"]=nil
			end
		end
		frame.Type=type

		frame:Show()

		if(enablemouse==1)then
			if(not frame.ClickFrame)then
				frame.ClickFrame=CreateFrame("Button","TrackerClickFrame",frame,"SecureUnitButtonTemplate")
				frame.ClickFrame:SetHeight(30)
				frame.ClickFrame:SetWidth(130)
				frame.ClickFrame:SetPoint("CENTER",frame,"CENTER",0,0)

				SecureUnitButton_OnLoad(frame.ClickFrame,unit)
			end

			frame:EnableMouse(true)
			frame.ClickFrame:EnableMouse(true)
			frame.ClickFrame:Show()
		else
			if(frame.ClickFrame)then
				frame:EnableMouse(false)
				frame.ClickFrame:EnableMouse(false)
				frame.ClickFrame:Hide()

				frame.ClickFrame:Hide()
			end
		end
				

	else
		if(type==1 or type==2)then
			local guid=UnitGUID(unit)
			if(guid)then
				GUIDToFrame[guid]=nil
			end
		end

		if(frame)then
			frame:Hide()
		end
	end

	return frame
end

local function NPA_Tracker_InitFrames()

	local interval=(NPA_Config["Core"]["Frame_UpdateInterval"] or 0.1)*1.5
	if(interval>0.2)then
		NPA_Tracker_UpdateInterval=interval
	else
		NPA_Tracker_UpdateInterval=0.2
	end

	for i=1,NPA_Tracker_Config["Tracker_Count"] do
		if(not NPA_Tracker_Frame[i])then
			NPA_Tracker_Frame[i]=NPA_Tracker_CreateFrame(NPA_Tracker_Config["Tracker_ModuleList"])
			NPA_Tracker_Frame[i].Index=i
		elseif(NPA_Tracker_Frame[i]:IsShown() and NPA_Tracker_Frame[i].Slot~=0)then

			NPA_Tracker_Frame[i].TargetX,NPA_Tracker_Frame[i].TargetY=NPA_Tracker_FrameTargetPosition(NPA_Tracker_Frame[i].Slot)

			NPA_Tracker_Frame[i]:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",NPA_Tracker_Frame[i].TargetX,NPA_Tracker_Frame[i].TargetY)
		else
			NPA_Tracker_Frame[i]:Hide()
		end

		NPA_Tracker_Frame[i].ModuleMain.ModuleList=NPA_Tracker_Config["Tracker_ModuleList"]
		--NPA_Tracker_HookFrameFuc(NPA_Tracker_Frame[i].ModuleMain,NPA_Tracker_Config["Tracker_ModuleList"])

		NPA_Tracker_Frame[i].ModuleMain:SetScale(NPA_Tracker_Config["Tracker_Size"])
	end

	NPA_Tracker_SelfFrame=NPA_Tracker_InitSpecialFrame(NPA_Tracker_Config["Tracker_Self"],
					"player",
					NPA_Tracker_SelfFrame,
					NPA_Tracker_Config["Tracker_SelfModuleList"],
					NPA_Tracker_Config["Tracker_SelfOffsetX"],
					NPA_Tracker_Config["Tracker_SelfOffsetY"],
					NPA_Tracker_Config["Tracker_SelfSize"],
					NPA_Tracker_Config["Tracker_SelfAlpha"],
					NPA_Tracker_Config["Tracker_SelfName"],
					NPA_Tracker_Config["Tracker_SelfEnableMouse"],
					1)

	NPA_Tracker_PetFrame=NPA_Tracker_InitSpecialFrame(NPA_Tracker_Config["Tracker_Pet"],
					"playerpet",
					NPA_Tracker_PetFrame,
					NPA_Tracker_Config["Tracker_PetModuleList"],
					NPA_Tracker_Config["Tracker_PetOffsetX"],
					NPA_Tracker_Config["Tracker_PetOffsetY"],
					NPA_Tracker_Config["Tracker_PetSize"],
					NPA_Tracker_Config["Tracker_PetAlpha"],
					NPA_Tracker_Config["Tracker_PetName"],
					NPA_Tracker_Config["Tracker_PetEnableMouse"],
					2)

	NPA_Tracker_FocusFrame=NPA_Tracker_InitSpecialFrame(NPA_Tracker_Config["Tracker_Focus"],
					"focus",
					NPA_Tracker_FocusFrame,
					NPA_Tracker_Config["Tracker_FocusModuleList"],
					NPA_Tracker_Config["Tracker_FocusOffsetX"],
					NPA_Tracker_Config["Tracker_FocusOffsetY"],
					NPA_Tracker_Config["Tracker_FocusSize"],
					NPA_Tracker_Config["Tracker_FocusAlpha"],
					NPA_Tracker_Config["Tracker_FocusName"],
					NPA_Tracker_Config["Tracker_FocusEnableMouse"],
					3)

	NPA_Tracker_TargetFrame=NPA_Tracker_InitSpecialFrame(NPA_Tracker_Config["Tracker_Target"],
					"target",
					NPA_Tracker_TargetFrame,
					NPA_Tracker_Config["Tracker_TargetModuleList"],
					NPA_Tracker_Config["Tracker_TargetOffsetX"],
					NPA_Tracker_Config["Tracker_TargetOffsetY"],
					NPA_Tracker_Config["Tracker_TargetSize"],
					NPA_Tracker_Config["Tracker_TargetAlpha"],
					NPA_Tracker_Config["Tracker_TargetName"],
					NPA_Tracker_Config["Tracker_TargetEnableMouse"],
					4)
end


local function NPA_Tracker_OnEvent(uarg)
	if(NPA_Tracker_Count<NPA_Tracker_Config["Tracker_Count"])then

		local myguid=UnitGUID("player")
		local petguid=UnitGUID("playerpet") or 0
		local filter=NPA_Tracker_CombatLogFilter[uarg[2]]

		if(NPA_Tracker_GUIDList[uarg[6]]==nil and filter==1 and
			uarg[6]~=myguid and uarg[6]~=petguid)then

			NPA_Tracker_AddTracker(uarg[6],uarg[8])

		elseif(NPA_Tracker_GUIDList[uarg[3]]==nil and
				((uarg[6]==myguid and filter==3) or filter==2) and
				uarg[3] and uarg[3]~=myguid and uarg[3]~=petguid )then
		
				NPA_Tracker_AddTracker(uarg[3],uarg[5])
		end

	end

end

function NPA_Tracker:ApplyConfig()
	NPA_Core:CheckConfigEntry("Tracker",NPA_Tracker_DefaultSetting)

	NPA_Tracker_Config=NPA_Config["Tracker"]
	NPA_Tracker_Enable=NPA_Config["Core"]["EnableModule"]["Tracker"]

	NPA_Tracker_MainFrame:SetPoint("CENTER",UIParent,"CENTER",NPA_Tracker_Config["Tracker_OffsetX"],NPA_Tracker_Config["Tracker_OffsetY"])

	NPA_Tracker_BuildFilter()
	NPA_Tracker_InitFrames()

	if(NPA_Tracker_Enable==1)then
		NPA_Core.CombatEventFunc["Tracker"]=NPA_Tracker_OnEvent
	else
		NPA_Core.CombatEventFunc["Tracker"]=nil
	end

end


function NPA_Tracker:ClearData()
	
end


local function NPA_Tracker_AddFrame(guid)
	for j=1,NPA_Tracker_Config["Tracker_Count"] do
		if(not NPA_Tracker_Frame[j]:IsShown()) then
			local frame=NPA_Tracker_Frame[j]
		
			frame:Show()
			frame.GUID=guid

			frame.TimeStack=0

			local modulemain=frame.ModuleMain

			modulemain:Show()
			modulemain.GUID=guid
			
			frame:SetAlpha(0.01)

			frame.Slot=0
		
			NPA_Tracker_GUIDList[guid]=1

			NPA_Tracker_Count=NPA_Tracker_Count+1

			frame.SpawnTime=GetTime()+0.5
	

			local target=GUIDToFrame[guid]

			if(target and target:IsShown())then
				local targetx=target:GetLeft() or 0
				local targety=target:GetBottom() or 0
				frame:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",targetx,targety)
			end

			return 1
		end	
	end
	
end

local function NPA_Tracker_MainFrame_OnUpdate(self,elapsed)
	self.TimeStack=self.TimeStack+elapsed
	if(self.TimeStack<NPA_Tracker_Config["Tracker_UpdateInterval"] or NPA_Tracker_Count>=NPA_Tracker_Config["Tracker_Count"])then
		return
	end
	self.TimeStack=0


	local nTime=GetTime()
	for guid,_ in pairs(NPA_Tracker_TrackList) do
		if(NPA_Tracker_GUIDList[guid] or (not GetUnitData(guid)) or
			NPA_Tracker_AddFrame(guid)) then
			NPA_Tracker_TrackList[guid]=nil
		end
	end

end

NPA_Tracker_MainFrame.TimeStack=0

NPA_Tracker_MainFrame:SetScript("OnUpdate",NPA_Tracker_MainFrame_OnUpdate)
NPA_Tracker_MainFrame:SetHeight(1)
NPA_Tracker_MainFrame:SetWidth(1)

NPA_Core:AddModule("Tracker",NPA_Tracker)