﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime
local table_insert=table.insert
local NPA_Threat_Frame={}

local NPA_Threat={}
--config
local NPA_Threat_DefaultSetting={
		["Threat_Glow1Data"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=1,
			Green=0,
			Blue=0,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Threat_Glow2Data"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=1,
			Green=1,
			Blue=0,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Threat_Glow3Data"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=0,
			Green=1,
			Blue=0,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Threat_Glow4Data"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=1,
			Green=0,
			Blue=0,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Threat_Glow5Data"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=0,
			Green=1,
			Blue=0,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["Threat_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Threat_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Threat_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=90,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["Threat_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Threat_GlowHostileThreat"]=1,
		["Threat_GlowHostileLostThreat"]=0,

		["Threat_GlowNonHostileThreat"]=0,
		["Threat_GlowNonHostileLostThreat"]=0,

		["Threat_GlowHostileTanking"]=1,
		["Threat_GlowNonHostileTanking"]=0,

		["Threat_GlowHostileTargetingMe"]=0,
		["Threat_GlowNonHostileTargetingMe"]=0,

		["Threat_Text"]=1,
		["Threat_ShowBar"]=0,
		["Threat_ColorBar"]=1,

		["Threat_OffsetX"]=75,
		["Threat_OffsetY"]=-22,
		}
local NPA_Threat_Config=NPA_Threat_DefaultSetting

function NPA_Threat:ResetConfig()
	NPA_Config["Threat"]=CopyTable(NPA_Threat_DefaultSetting)
end

local function NPA_Threat_CheckHostile(bar)
	local r,g,b = bar:GetStatusBarColor()
	---green, blue, yellow are non-hostile
	if(r==0 and g>0.9 and b==0)then
		return 0
	elseif(r==0 and g==0 and b>0.9)then
		return 0
	elseif(r>0.9 and g>0.9 and b==0)then
		return 2
	elseif(r>0.9 and g==0 and b==0)then -- red is non-player
		return 1
	end

	return 1
end

local ManageBar=NPA_Core.ManageBar
						--nTime,main,guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed,isfriend,isguild,isparty,israid,isinstance,NPA_Core_IsInArena,NPA_Core_IsInBattleground,typecache,threat)
local function NPA_Threat_OnUpdate(_,self,_,unitdata,selfguid,_,frame,hostile,_,_,recentUpdated,_,_,_,_,_,_,_,_,_,threat)
	local healthbar=frame["HealthBar"]
	if(not(healthbar and healthbar:IsShown()))then
		self:Hide()
		return
	end

	local show	

	if(recentUpdated)then
		local percent=unitdata.ThreatPercent

		if(percent)then
			local bpercent=percent/100
			local cpercent=1-bpercent
			if(NPA_Threat_Config["Threat_Text"]==1)then
				local st=self.Text
				st:SetText(floor(percent).."%")
				st:SetTextColor(bpercent*st.R,cpercent*st.G,0)
				st:Show()
			else
				self.Text:Hide()
			end
			if(NPA_Threat_Config["Threat_ShowBar"]==1)then
				local bar=self.Bar
				if(NPA_Threat_Config["Threat_ColorBar"]==1)then
					bar:SetVertexColor(bar.R*bpercent,bar.G*cpercent,0)
				else
					bar:SetVertexColor(bar.R,bar.G,bar.B)
				end
				bar.Percent=bpercent
				ManageBar(nil,bar)
				self.Background:Show()
				self.Overlay:Show()
				show=1
			else
				self.Bar:Hide()
				self.Background:Hide()
				self.Overlay:Hide()
			end

		else
			self.Text:Hide()
			self.Bar:Hide()
			self.Background:Hide()
			self.Overlay:Hide()
		end

		local target=unitdata.Target
		if((not threat) and target and target.TargetGUID==selfguid)then
			if(hostile~=0 and NPA_Threat_Config["Threat_GlowHostileTargetingMe"]==1)then
				self.Glow4:Show()
				show=1
			else
				self.Glow4:Hide()
				if(hostile==0 and NPA_Threat_Config["Threat_GlowNonHostileTargetingMe"]==1)then
					self.Glow5:Show()
					show=1
				else
					self.Glow5:Hide()
				end
			end
		else
			self.Glow4:Hide()
			self.Glow5:Hide()
		end
	else
		self.Text:Hide()	
		self.Bar:Hide()
		self.Background:Hide()
		self.Overlay:Hide()
		
		self.Glow4:Hide()
		self.Glow5:Hide()
	end

	-- nil = unit is not on otherunit's threat table. 
	-- 0 = not tanking, lower threat than tank. 
	-- 1 = not tanking, higher threat than tank. 
	-- 2 = insecurely tanking, another unit have higher threat but not tanking. 
	-- 3 = securely tanking, highest threat


	if((threat==1 or threat==2) and ((NPA_Threat_Config["Threat_GlowHostileThreat"]==1 and hostile~=0) or
			(NPA_Threat_Config["Threat_GlowNonHostileThreat"]==1 and hostile==0)))then

			self.Glow2:Show()
			show=1
	else
		self.Glow2:Hide()
	end

	if(threat==0 and ((NPA_Threat_Config["Threat_GlowHostileLostThreat"]==1 and hostile~=0) or
			(NPA_Threat_Config["Threat_GlowNonHostileLostThreat"]==1 and hostile==0)))then

			self.Glow3:Show()
			show=1
	else
		self.Glow3:Hide()
	end

	if(threat==3 and ((NPA_Threat_Config["Threat_GlowHostileTanking"]==1 and hostile~=0) or
			(NPA_Threat_Config["Threat_GlowNonHostileTanking"]==1 and hostile==0)))then

			self.Glow:Show()
			show=1
	else
		self.Glow:Hide()
	end


	self.ThreatType=threat

	if(show==1)then
		self:Show()
	else
		self:Hide()
	end
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_Threat_SetFrame(main)
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_Threat_Config["Threat_OffsetX"],NPA_Threat_Config["Threat_OffsetY"])
	ManageTexture(nil,main.Glow,NPA_Threat_Config["Threat_Glow1Data"],main:GetParent())
	ManageTexture(nil,main.Glow2,NPA_Threat_Config["Threat_Glow2Data"],main:GetParent())
	ManageTexture(nil,main.Glow3,NPA_Threat_Config["Threat_Glow3Data"],main:GetParent())
	ManageTexture(nil,main.Glow4,NPA_Threat_Config["Threat_Glow4Data"],main:GetParent())
	ManageTexture(nil,main.Glow5,NPA_Threat_Config["Threat_Glow5Data"],main:GetParent())

	ManageFont(nil,main.Text,NPA_Threat_Config["Threat_TextData"],main)

	ManageTexture(nil,main.Bar,NPA_Threat_Config["Threat_BarData"],main,1)
	ManageTexture(nil,main.Background,NPA_Threat_Config["Threat_BackgroundData"],main)
	ManageTexture(nil,main.Overlay,NPA_Threat_Config["Threat_OverlayData"],main)

	if(NPA_Threat_Config["Threat_ShowBar"]==1)then
		main.Background:Show()
		main.Overlay:Show()
	else
		main.Background:Hide()
		main.Overlay:Hide()
	end

	main:Hide()
end
local function NPA_Threat_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_Threat_MainFrame",frame)
	main:SetHeight(1)
	main:SetWidth(1)
	main:SetPoint("CENTER",frame,"CENTER")
	main:SetFrameStrata("LOW")

	local text=main:CreateFontString("NPA_Threat_Text","OVERLAY",nil)
	text:Hide()
	
	local glow=main:CreateTexture("NPA_Threat_Glow","OVERLAY",nil)
	glow:Hide()
	local glow2=main:CreateTexture("NPA_Threat_Glow","OVERLAY",nil)
	glow2:Hide()
	local glow3=main:CreateTexture("NPA_Threat_Glow","OVERLAY",nil)
	glow3:Hide()
	local glow4=main:CreateTexture("NPA_Threat_Glow","OVERLAY",nil)
	glow4:Hide()
	local glow5=main:CreateTexture("NPA_Threat_Glow","OVERLAY",nil)
	glow5:Hide()

	local bar=main:CreateTexture("NPA_Threat_Bar","ARTWORK",nil)
	bar:Hide()
	local overlay=main:CreateTexture("NPA_Threat_Overlay","OVERLAY",nil)
	overlay:Hide()
	local background=main:CreateTexture("NPA_Threat_Background","BACKGROUND",nil)
	background:Hide()
	
	main.Text=text
	main.Glow=glow
	main.Glow2=glow2
	main.Glow3=glow3
	main.Glow4=glow4
	main.Glow5=glow5

	main.Overlay=overlay
	main.Bar=bar
	main.Background=background


	NPA_Threat_SetFrame(main)
	table_insert(NPA_Threat_Frame,main)

	frame["Threat"]=main
end

function NPA_Threat:ApplyConfig()
	NPA_Core:CheckConfigEntry("Threat",NPA_Threat_DefaultSetting)

	NPA_Threat_Config=NPA_Config["Threat"]

	for _,main in pairs(NPA_Threat_Frame) do
		NPA_Threat_SetFrame(main)
	end
end

NPA_Core:AddHook("Threat",NPA_Threat_HookFrame)
NPA_Core:AddModule("Threat",NPA_Threat)
NPA_Core:HookUpdate("Threat",NPA_Threat_OnUpdate,1)