﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime

local NPA_TargetCount={}
--config
local NPA_TargetCount_DefaultSetting={
		["TargetCount_ShowHostile"]=1,
		["TargetCount_ShowNonHostile"]=1,
		
		["TargetCount_OnlyPlayer"]=0,

		["TargetCount_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=-50,
			OffsetY=-40,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

	}
local NPA_TargetCount_Config=NPA_TargetCount_DefaultSetting

function NPA_TargetCount:ResetConfig()
	NPA_Config["TargetCount"]=CopyTable(NPA_TargetCount_DefaultSetting)
end


--global function
local NPA_TargetCount_Frame={}
local table_insert=table.insert


local function NPA_TargetCount_OnUpdate(_,self,_,unitdata,_,_,_,_,_,_,recentUpdated)
	if(recentUpdated) then --updated recently
		local count=unitdata.TargetCount
		if(count)then
			local text=""
			if(NPA_TargetCount_Config["TargetCount_ShowNonHostile"]==1 and count[1]~=0)then
				if(NPA_TargetCount_Config["TargetCount_OnlyPlayer"]==1)then
					text=text.."|cff00ff00["..count[1].."]"
				else
					text=text.."|cff00ff00["..(count[1]+count[3]).."]"
				end
			end
			if(NPA_TargetCount_Config["TargetCount_ShowHostile"]==1 and count[2]~=0)then
				if(NPA_TargetCount_Config["TargetCount_OnlyPlayer"]==1)then
					text=text.."|cffff0000["..count[2].."]"
				else
					text=text.."|cffff0000["..(count[2]+count[4]).."]"
				end
			end
			if(text~="")then
				self:SetText(text)
				self:Show()
			else
				self:Hide()
			end
		else
			self:Hide()
		end
	else
		self:Hide()
	end

end
local ManageFont=NPA_Core.FontManager

local function NPA_TargetCount_SetText(text)

	ManageFont(nil,text,NPA_TargetCount_Config["TargetCount_TextData"],text:GetParent())

end

local function NPA_TargetCount_HookFrame(frame)
	local text=frame:CreateFontString("NPA_TargetCount_Text","OVERLAY")
	text:SetTextColor(1,1,0,1)
	text:Hide()
	
	NPA_TargetCount_SetText(text)
	table_insert(NPA_TargetCount_Frame,text)

	frame["TargetCount"]=text

end

function NPA_TargetCount:ApplyConfig()
	NPA_Core:CheckConfigEntry("TargetCount",NPA_TargetCount_DefaultSetting)

	NPA_TargetCount_Config=NPA_Config["TargetCount"]

	for _,text in pairs(NPA_TargetCount_Frame) do
		NPA_TargetCount_SetText(text)
	end
end

NPA_Core:AddHook("TargetCount",NPA_TargetCount_HookFrame)
NPA_Core:AddModule("TargetCount",NPA_TargetCount)
NPA_Core:HookUpdate("TargetCount",NPA_TargetCount_OnUpdate,2)