﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime
local table_insert=table.insert
local NPA_Target_Frame={}
local sqrt=sqrt
local atan=math.atan
local abs=abs
local floor=floor
local table_getn=table.getn
local unpack=unpack
local sin=sin

local NPA_Target={}
--config
local NPA_Target_DefaultSetting={

		["Target_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="BOTTOM",
			ToAnchor="TOP",
			},
	
		["Target_IndicatorData"]={
			OffsetX=0,
			OffsetY=0,
			Height=30,
			Width=30,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\arrow",
			TextureBlend="ADD",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["Target_BorderData"]={
			OffsetX=0,
			OffsetY=0,
			Height=40,
			Width=140,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["Target_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=40,
			Width=140,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},


		["Target_ModuleList"]={
			["Aura"]=1,
			["AutoHide"]=1,
			["CastWarning"]=1,
			["ClassIcon"]=1,
			["ComboPoint"]=1,
			["CoolDown"]=1,
			["CrowdControl"]=1,
			["HealthBar"]=1,
			["ManaBar"]=1,
			["RaidIcon"]=1,
			["Speed"]=1,
			["Threat"]=1,
			["QuestMark"]=1,
			["RangeCheck"]=1,
			["Tracker"]=1,
			["CounterSpell"]=1,
			["ClassInfo"]=1,
			["NameText"]=1,
			["TargetCount"]=1,
			["ShieldWatch"]=1,
			["exCombat"]=1,
			["RoleCheck"]=1,
			},

	

		["Target_PortraitData"]={
			OffsetX=0,
			OffsetY=50,
			Height=40,
			Width=40,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
		["Target_ShowText"]=1,
		["Target_StickToDebuff"]=1,
		["Target_StickToBuff"]=1,


		["Target_Indicator_OffsetX"]=0,
		["Target_Indicator_OffsetY"]=0,

		["Target_Indicator_Count"]=5,
		["Target_Indicator_Color"]=0,

		["Target_Indicator_MyTarget"]=1,
		["Target_Indicator_MyTargetTarget"]=1,
		["Target_Indicator_Other"]=1,

		["Target_Indicator_Color2"]=1,
		
		["Target_Indicator_Hostile"]=1,
		["Target_Indicator_NonHostile"]=1,

		["Target_Indicator_GapScale"]=1,
		["Target_Indicator_Speed"]=1,

		["Target_Indicator_FixedGap"]=0,
		["Target_Indicator_GapX"]=10,
		["Target_Indicator_GapY"]=10,

		["Target_Indicator_BlinkCasting"]=1,

		["Target_TargetFrame_Show"]=0,
		["Target_TargetFrame_Size"]=1,
		["Target_TargetFrame_OffsetX"]=0,
		["Target_TargetFrame_OffsetY"]=50,
		["Target_TargetFrame_HideWhenOnScreen"]=1,

		["Target_ShowBorder"]=0,
		["Target_ShowBackground"]=0,

		["Target_ShowPortrait"]=0,
		["Target_OnlyPlayer"]=0,

		["Target_PortraitCacheCount"]=2,

		["Target_Indicator_Stretch"]=0,
		["Target_Indicator_StretchStart"]=1,
		["Target_Indicator_StretchEnd"]=2,
	}

local NPA_Target_Config=NPA_Target_DefaultSetting

function NPA_Target:ResetConfig()
	NPA_Config["Target"]=CopyTable(NPA_Target_DefaultSetting)
end


local function NPA_Target_GetCover(target)
	local color
	local front="=>>"
	local back="<<="
	
	if(target.IsEnemy==1)then
		color="|cffff0000"
	elseif(target.IsFriend==1)then
		color="|cff00ff00"
	else
		color="|cffffff00"
	end
	
	front=color..front
	back=color..back
	return front,back

end

local function NPA_Target_GetName(target,selfguid)
	local text
	if(target.TargetGUID==selfguid)then
		text="|cffff0000!!!You!!!"
	else
		text=target.TargetName
		if(NPA_Target_Config["Target_Indicator_Color"]==1)then
			if(target.IsEnemy)then
				text="|cffff0000"..text
			elseif(target.IsFriend)then
				text="|cff00ff00"..text
			else
				text="|cffffff00"..text
			end
		elseif(NPA_Target_Config["Target_Indicator_Color2"]==1)then
			if(target.IsPlayerEnemy)then
				text="|cffff0000"..text
			elseif(target.IsPlayerFriend)then
				text="|cff00ff00"..text
			else
				text="|cffffff00"..text
			end
		end
	end

	return text
end

local GUIDToFrame=NPA_Core.GUIDToFrame

local function Swap(a,b)
	local c=b
	b=a
	a=c
end

local ManageFont=NPA_Core.FontManager
local ManageTexture=NPA_Core.TextureManager2

local function NPA_Target_CreateTexture(frame)
	local indicator=frame:CreateTexture("NPA_Target_Indicator","BACKGROUND",nil)
	ManageTexture(nil,indicator,NPA_Target_Config["Target_IndicatorData"])
	indicator.Height=NPA_Target_Config["Target_IndicatorData"].Height
	indicator.Width=NPA_Target_Config["Target_IndicatorData"].Width
	indicator:Hide()

	return indicator

end

local GUIDToFrame=NPA_Core.GUIDToFrame


local BindPortrait=NPA_Core.BindPortrait
local UnbindPortrait=NPA_Core.UnbindPortrait

local GetUnitData=NPA_Core.GetUnitData

local function NPA_Target_OnUpdate(nTime,self,guid,unitdata,selfguid,guids,frame,hostile,isplayer,_,recentUpdated)
	if((not unitdata) or ((not (isplayer==1)) and NPA_Target_Config["Target_OnlyPlayer"]==1))then
		self:Hide()
		UnbindPortrait(self)
		return
	end
	local target=unitdata.Target
	if(target and recentUpdated and target.TargetGUID) then --updated recently
		local show

		if(NPA_Target_Config["Target_TargetFrame_Show"]==1 and ((not GUIDToFrame[target.TargetGUID]) or NPA_Target_Config["Target_TargetFrame_HideWhenOnScreen"]~=1))then
			self.TargetFrame.GUID=target.TargetGUID
			self.TargetFrame.ModuleMain.GUID=target.TargetGUID
			self.TargetFrame:Show()
			show=1
		else
			self.TargetFrame:Hide()		
		end

		if(NPA_Target_Config["Target_ShowText"]==1 and target.TargetName~="")then
			local coverfront,coverback=NPA_Target_GetCover(target)
			local name=NPA_Target_GetName(target,selfguid)

			local text=self.Text
			text:SetText(coverfront..name..coverback)
			
			text:Show()

			show=1
		else
			self.Text:Hide()
		end

		if(NPA_Target_Config["Target_Indicator_Count"]>0 and
			((NPA_Target_Config["Target_Indicator_Other"]==1 and guid~=selfguid and guid~=guids.Target and guid~=guids.Mouseover) or
			(guid==selfguid and NPA_Target_Config["Target_Indicator_MyTarget"]==1) or
			((guid==guids.Target or guid==guids.Mouseover) and NPA_Target_Config["Target_Indicator_MyTargetTarget"]==1) or 
			(NPA_Target_Config["Target_Indicator_Hostile"]==1 and ishostile==1) or 
			(NPA_Target_Config["Target_Indicator_NonHostile"]==1 and ishostile~=1) ) )then

			local targetframe=GUIDToFrame[target.TargetGUID]
			if(targetframe and targetframe:IsShown())then
				--targetframe=targetframe.ModuleMain
				local selfframe=frame.Parent
				local indicator=self.Indicator
				local selfcenterx,selfcentery=selfframe:GetCenter()
				local targetcenterx,targetcentery=targetframe:GetCenter()

				local scale=UIParent:GetScale()
				if(frame.Parent.IsTracker)then
					selfcenterx=(selfcenterx or 0)*scale
					selfcentery=(selfcentery or 0)*scale
				else
					selfcenterx=(selfcenterx or 0)
					selfcentery=(selfcentery or 0)
				end
				if(targetframe.IsTracker)then
					targetcenterx=(targetcenterx or 0)*scale
					targetcentery=(targetcentery or 0)*scale
				else
					targetcenterx=(targetcenterx or 0)
					targetcentery=(targetcentery or 0)
				end
				local lengthx=(targetcenterx - selfcenterx)
				local lengthy=(targetcentery - selfcentery)

				local angle=atan(lengthy/abs(lengthx))
				if(lengthx<0)then
					angle=3.14-angle
				end


				local count,index,stepx,stepy
				local maxcount=NPA_Target_Config["Target_Indicator_Count"]

	
				if(NPA_Target_Config["Target_Indicator_FixedGap"]==1)then
					local lth=sqrt(lengthx^2+lengthy^2)
					stepx=lengthx/lth*NPA_Target_Config["Target_Indicator_GapX"]
					stepy=lengthy/lth*NPA_Target_Config["Target_Indicator_GapY"]
					count=maxcount
					index=count+2*NPA_Target_Config["Target_Indicator_GapScale"]
				else
					count=floor(max(abs(lengthx/self.Width),abs(lengthy/self.Height)))
					if(count>maxcount)then
						count=maxcount
					end
					index=count+2*NPA_Target_Config["Target_Indicator_GapScale"]

					stepx=lengthx/index*NPA_Target_Config["Target_Indicator_GapScale"]
					stepy=lengthy/index*NPA_Target_Config["Target_Indicator_GapScale"]
				end

				local selfscale=selfframe:GetScale()*scale
				stepx=stepx/selfscale
				stepy=stepy/selfscale
				
				local oTime=nTime*NPA_Target_Config["Target_Indicator_Speed"]
				local offset=oTime-floor(oTime)
				local offsetx=(NPA_Target_Config["Target_Indicator_OffsetX"]+offset*stepx)
				local offsety=(NPA_Target_Config["Target_Indicator_OffsetY"]+offset*stepy)

				local color
				local alpha
				local castbar=frame["CastWarning"]
				if(NPA_Target_Config["Target_Indicator_BlinkCasting"]==1 and castbar and castbar:IsShown())then
					alpha=sin(offset*720)/3+0.66
				else
					alpha=1
				end
				if(NPA_Target_Config["Target_Indicator_Color2"]==1)then
					if(unitdata.IsEnemy)then
						color={self.R,0,0,alpha}
					elseif(unitdata.IsFriend)then
						color={0,self.G,0,alpha}
					else
						color={self.R,self.G,0,alpha}
					end
				elseif(NPA_Target_Config["Target_Indicator_Color"]==1)then
					if(target.IsPlayerEnemy)then
						color={self.R,0,0,alpha}
					elseif(target.IsPlayerFriend)then
						color={0,self.G,0,alpha}
					else
						color={self.R,self.G,0,alpha}
					end
				else
					color={self.R,self.G,self.B,alpha}
				end
				for i=1,count do
					indicator[i]:SetPoint("CENTER",frame,"CENTER",offsetx+stepx*i,offsety+stepy*i)
					indicator[i]:SetRotation(angle)			
					indicator[i]:SetVertexColor(unpack(color))
					indicator[i]:Show()
				end
				if(NPA_Target_Config["Target_Indicator_Stretch"]==1)then
					local start=NPA_Target_Config["Target_Indicator_StretchStart"]
					local step=NPA_Target_Config["Target_Indicator_StretchEnd"]-start
					for i=1,count do
						local size=i/count*step+start
						indicator[i]:SetHeight(indicator[i].Height*size)
						indicator[i]:SetWidth(indicator[i].Width*size)
					end
				end

				for i=count+1,maxcount do
					indicator[i]:Hide()
				end

				indicator:Show()
				show=1
			else
				self.Indicator:Hide()
			end
		else
			self.Indicator:Hide()
		end

		if(NPA_Target_Config["Target_ShowPortrait"]==1)then
			local targetguid=target.TargetGUID
			local targetdata=GetUnitData(nil,targetguid)
			if(targetdata)then
				BindPortrait(targetguid,targetdata.Portrait,self,NPA_Target_Config["Target_PortraitData"])
				show=1
			else
				UnbindPortrait(self)
			end
		else
			UnbindPortrait(self)
		end

		if(show==1)then
			local aura=frame["Aura"]
			if(aura and aura:IsShown())then
				local buffmain=aura.BuffMain
				local debuffmain=aura.DebuffMain
				if(NPA_Target_Config["Target_StickToDebuff"]==1 and debuffmain:IsShown())then
					self:SetPoint("BOTTOM",debuffmain,"TOP")
				elseif(NPA_Target_Config["Target_StickToBuff"]==1 and buffmain:IsShown())then
					self:SetPoint("BOTTOM",buffmain,"TOP")
				else
					self:SetPoint("BOTTOM",frame,"TOP",NPA_Target_Config["Target_TextData"].OffsetX,NPA_Target_Config["Target_TextData"].OffsetY)
				end
			else
				self:SetPoint("BOTTOM",frame,"TOP",NPA_Target_Config["Target_TextData"].OffsetX,NPA_Target_Config["Target_TextData"].OffsetY)
			end

			self:Show()
		else
			self:Hide()
		end
	else
		self:Hide()
		UnbindPortrait(self)
	end

end

local function NPA_Target_SetFrame(frame)
	local text=frame.Text
	ManageFont(nil,text,NPA_Target_Config["Target_TextData"],frame)

	local indicator=frame.Indicator
	for i=1,NPA_Target_Config["Target_Indicator_Count"] do
		if(not indicator[i])then
			indicator[i]=NPA_Target_CreateTexture(indicator)
		else
			ManageTexture(nil,indicator[i],NPA_Target_Config["Target_IndicatorData"])

			indicator[i].Height=NPA_Target_Config["Target_IndicatorData"].Height
			indicator[i].Width=NPA_Target_Config["Target_IndicatorData"].Width

			indicator[i]:SetHeight(indicator[i].Height)
			indicator[i]:SetWidth(indicator[i].Width)

			indicator[i]:Hide()
		end
	end
	for i=NPA_Target_Config["Target_Indicator_Count"]+1,table_getn(indicator)do
		indicator[i]:Hide()
	end

	frame.R=NPA_Target_Config["Target_IndicatorData"].Red
	frame.G=NPA_Target_Config["Target_IndicatorData"].Green
	frame.B=NPA_Target_Config["Target_IndicatorData"].Blue

	frame.Width=NPA_Target_Config["Target_IndicatorData"].Width
	frame.Height=NPA_Target_Config["Target_IndicatorData"].Height


	frame.TargetFrame:SetPoint("CENTER",frame,"CENTER",NPA_Target_Config["Target_TargetFrame_OffsetX"],NPA_Target_Config["Target_TargetFrame_OffsetY"])
	frame.TargetFrame:Hide()
	frame.TargetFrame.ModuleMain:Show()
	frame.TargetFrame.ModuleMain:SetScale(NPA_Target_Config["Target_TargetFrame_Size"])

	ManageTexture(nil,frame.Border,NPA_Target_Config["Target_BorderData"],frame)
	ManageTexture(nil,frame.Background,NPA_Target_Config["Target_BackgroundData"],frame)

	if(NPA_Target_Config["Target_ShowBorder"]==1)then
		frame.Border:Show()
	else
		frame.Border:Hide()
	end

	if(NPA_Target_Config["Target_ShowBackground"]==1)then
		frame.Background:Show()
	else
		frame.Background:Hide()
	end



	UnbindPortrait(frame)

end



local function NPA_ModuleMain_OnHide(self)
	local nametext=self["NameText"]
	if(nametext)then
		nametext:Hide()
	end

	self.Indicator:Hide()

end

local function NPA_Target_CreateMainFrame(mainframe)
	local frame=CreateFrame("Frame","NPA_Target_Frame",mainframe)
	frame:SetHeight(20)
	frame:SetWidth(160)
	frame:Hide()

	--module mainframe


	local rendermain=CreateFrame("Frame","NPA_RenderMainFrame",frame)
	rendermain:SetHeight(1)
	rendermain:SetWidth(1)
	rendermain:SetPoint("CENTER",frame,"CENTER")
	rendermain.Attach=frame
	rendermain:Show()

	local modulemain=CreateFrame("Frame","NPA_RenderMainFrame",rendermain)
	modulemain:SetHeight(20)
	modulemain:SetWidth(120)
	modulemain:SetPoint("CENTER",frame,"CENTER")
	modulemain:Show()
	modulemain:SetScale(NPA_Target_Config["Target_TargetFrame_Size"])

	modulemain.Parent=frame
	modulemain.TimeStack=100

	--scroll frame
	local scrollframe=CreateFrame("ScrollFrame","NPA_ScrollMainFrame",frame)
	scrollframe:SetHeight(512)
	scrollframe:SetWidth(512)
	scrollframe:SetPoint("CENTER",frame,"CENTER")
	scrollframe:SetScrollChild(rendermain)
	scrollframe:SetFrameStrata("BACKGROUND")
	scrollframe:Show()

	modulemain.RenderMain=scrollframe

	for name,key in pairs(NPA_Target_Config["Target_ModuleList"]) do
		if(key==1)then
			NPA_Core:HookFrame(name,modulemain)
		end
	end
	
	frame.ModuleList=NPA_Target_Config["Target_ModuleList"]

	frame.ModuleMain=modulemain

	modulemain:SetScript("OnHide",NPA_ModuleMain_OnHide)

	NPA_Core:HookModuleMain(modulemain)

	return frame
end

local function NPA_Target_HookFrame(frame)
	local target=CreateFrame("Frame","NPA_Target_MainFrame",frame)
	target:SetPoint("CENTER",frame,"CENTER")
	target:SetHeight(1)
	target:SetWidth(1)
	target:Hide()
	
	local text=target:CreateFontString("NPA_Target_Text","OVERLAY",nil)
	text:Hide()

	local border=target:CreateTexture("NPA_HealthBar_Border","OVERLAY",nil)
	local background=target:CreateTexture("NPA_HealthBar_Background","BACKGROUND",nil)

	target.Border=border
	target.Background=background

	local indicatormain=CreateFrame("Frame","NPA_Target_Indicator_MainFrame",frame:GetParent():GetParent())
	indicatormain:SetPoint("CENTER",target,"CENTER")
	indicatormain:SetWidth(1)
	indicatormain:SetHeight(1)
	indicatormain:SetFrameStrata("BACKGROUND")
	indicatormain:Show()

	target.TargetFrame=NPA_Target_CreateMainFrame(target)

	target.Indicator=indicatormain
	target.Text=text

	target:SetScript("OnHide",function(self)
			self.Indicator:Hide()
		end)

	NPA_Target_SetFrame(target)
	table_insert(NPA_Target_Frame,target)
	
	frame["Target"]=target
end


function NPA_Target:ApplyConfig()
	NPA_Core:CheckConfigEntry("Target",NPA_Target_DefaultSetting)

	NPA_Target_Config=NPA_Config["Target"]

	for _,frame in pairs(NPA_Target_Frame) do
		NPA_Target_SetFrame(frame)
	end


	if(NPA_Target_Config["Target_ShowPortrait"]==1)then
		NPA_Core:RequestPortrait("Target",NPA_Target_Config["Target_PortraitCacheCount"])
	else
		NPA_Core:UnrequestPortrait("Target")
	end
end

NPA_Core:AddHook("Target",NPA_Target_HookFrame)
NPA_Core:AddModule("Target",NPA_Target)
NPA_Core:HookUpdate("Target",NPA_Target_OnUpdate,1)
