﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime

local NPA_Speed={}
--config
local NPA_Speed_DefaultSetting={
		["Speed_OffsetX"]=-75,
		["Speed_OffsetY"]=-22,

		["Speed_ColorText"]=1,
		["Speed_ColorBar"]=1,
		["Speed_ShowText"]=1,
		["Speed_ShowBar"]=1,

		["Speed_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=18,
			Width=18,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Speed_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=90,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["Speed_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["Speed_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=-15,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	}
local NPA_Speed_Config=NPA_Speed_DefaultSetting

function NPA_Speed:ResetConfig()
	NPA_Config["Speed"]=CopyTable(NPA_Speed_DefaultSetting)
end


--global function
local NPA_Speed_Frame={}
local table_insert=table.insert
local tonumber=tonumber

local ManageBar=NPA_Core.ManageBar

local function NPA_Speed_OnUpdate(_,self,_,unitdata,_,_,_,_,_,_,recentUpdated)
	if(recentUpdated)then
		local speed=tonumber(unitdata.Speed)
		if(speed and speed~=0)then
			if(NPA_Speed_Config["Speed_ShowText"]==1)then
				local text=self.Text
				text:SetText(unitdata.Speed.."%")
				if(NPA_Speed_Config["Speed_ColorText"]==1)then
					if(unitdata.Speed>100)then
						text:SetTextColor(text.R,0,0)
					elseif(unitdata.Speed<70)then
						text:SetTextColor(0,text.G,0)
					else
						text:SetTextColor(text.R,text.G,0)
					end
				end
				text:Show()
			else
				self.Text:Hide()
			end
			if(NPA_Speed_Config["Speed_ShowBar"]==1)then
				local bar=self.Bar
				local percent=speed/150
				bar.Percent=percent
	
				if(NPA_Speed_Config["Speed_ColorBar"]==1)then
					local bpercent=1-percent
					bar:SetVertexColor(bar.R*bpercent,bar.G*percent)
				end
				ManageBar(nil,bar)
			else
				self.Bar:Hide()
			end
			self:Show()
		else
			self:Hide()
		end
	else
		self:Hide()
	end
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager


local function NPA_Speed_SetFrame(main)
	main:Hide()
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_Speed_Config["Speed_OffsetX"],NPA_Speed_Config["Speed_OffsetY"])

	ManageTexture(nil,main.Bar,NPA_Speed_Config["Speed_BarData"],main,1)
	ManageTexture(nil,main.Overlay,NPA_Speed_Config["Speed_OverlayData"],main)
	ManageTexture(nil,main.Background,NPA_Speed_Config["Speed_BackgroundData"],main)

	ManageFont(nil,main.Text,NPA_Speed_Config["Speed_TextData"],main)

	if(NPA_Speed_Config["Speed_ShowBar"]==1)then
		main.Background:Show()
		main.Overlay:Show()
	else
		main.Background:Hide()
		main.Overlay:Hide()
	end
end

local function NPA_Speed_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_Speed_MainFrame",frame)
	main:SetHeight(1)
	main:SetWidth(1)
	main:SetPoint("CENTER",frame,"CENTER",0,0)
	main:Hide()

	local bar=main:CreateTexture("NPA_Speed_Bar","ARTWORK")
	bar:Hide()

	local background=main:CreateTexture("NPA_Speed_Background","BACKGROUND")
	background:Show()

	local overlay=main:CreateTexture("NPA_Speed_Overlay","OVERLAY")
	overlay:Show()

	local text=main:CreateFontString("NPA_Speed_Text","OVERLAY")
	text:Show()
	
	main.Text=text
	main.Bar=bar
	main.Overlay=overlay
	main.Background=background
	
	NPA_Speed_SetFrame(main)
	table_insert(NPA_Speed_Frame,main)

	frame["Speed"]=main
end

function NPA_Speed:ApplyConfig()
	NPA_Core:CheckConfigEntry("Speed",NPA_Speed_DefaultSetting)

	NPA_Speed_Config=NPA_Config["Speed"]

	for _,main in pairs(NPA_Speed_Frame) do
		NPA_Speed_SetFrame(main)
	end
end

NPA_Core:AddHook("Speed",NPA_Speed_HookFrame)
NPA_Core:AddModule("Speed",NPA_Speed)
NPA_Core:HookUpdate("Speed",NPA_Speed_OnUpdate,2)