﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime

local NPA_ShieldWatch={}
--config
local NPA_ShieldWatch_DefaultSetting={
		["ShieldWatch_OffsetX"]=0,
		["ShieldWatch_OffsetY"]=15,
		["ShieldWatch_BarWidth"]=120,
		["ShieldWatch_BarHeight"]=10,

		["ShieldWatch_ShowRemaining"]=1,
		["ShieldWatch_ShowTimeleft"]=1,

		["ShieldWatch_Seperate"]=1,
		["ShieldWatch_AltDisplay"]=1,

		["ShieldWatch_ColorText"]=0,
		["ShieldWatch_SeperateText"]=0,

		["ShieldWatch_Short"]=0,
		["ShieldWatch_Break"]=0,
		
		["ShieldWatch_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="LEFT",
			ToAnchor="LEFT",
			},
			
		["ShieldWatch_Text2Data"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="RIGHT",
			ToAnchor="RIGHT",
			},

		["ShieldWatch_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ShieldWatch_BorderData"]={
			OffsetX=0,
			OffsetY=0,
			Height=18,
			Width=126,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["ShieldWatch_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

	}
local NPA_ShieldWatch_Config=NPA_ShieldWatch_DefaultSetting

function NPA_ShieldWatch:ResetConfig()
	NPA_Config["ShieldWatch"]=CopyTable(NPA_ShieldWatch_DefaultSetting)
end


--global function
local NPA_ShieldWatch_Frame={}
local table_insert=table.insert
local pairs=pairs
local table_getn=table.getn

local NPA_ShieldWatch_Data={}
local NPA_ShieldWatch_DataMax={}
local NPA_ShieldWatch_SchoolCache={}

local unpack=unpack



local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager


local function NPA_ShieldWatch_CreateBar(frame)
	local bar=frame:CreateTexture("NPA_ShieldWatch_Bar","ARTWORK")
	bar:Show()

	return bar	
end

local function NPA_ShieldWatch_CheckTimeLeft(auras,caster,spellid,nTime)
	if(auras[spellid])then
		for _,aura in pairs(auras[spellid]) do
			if(aura.CasterGUID==caster and aura.ExpirationTime)then
				local timeleft=aura.ExpirationTime-nTime
				return timeleft
			end
		end
	end

	return -1
end

local function NPA_ShieldWatch_InitBar(bar,main)
	bar:Hide()

	ManageTexture(nil,bar,NPA_ShieldWatch_Config["ShieldWatch_BarData"],main,1)

end


local NPA_ShieldWatch_SpellTypeColor={
	[0]={r=1,g=1,b=1},
	[1]={r=1,g=1,b=0},
	[2]={r=1,g=1,b=0.5},
	[4]={r=1,g=0.3,b=0},
	[8]={r=0.25,g=1,b=0.25},
	[16]={r=0.5,g=1,b=1},
	[32]={r=0.5,g=0.5,b=1},
	[64]={r=1,g=0.5,b=1}
}

local NPA_ShieldWatch_SpellTypeColor2={
	[0]="|cffffffff",
	[1]="|cffffff00",
	[2]="|cffffff88",
	[4]="|cffff7700",
	[8]="|cffA2ffA2",
	[16]="|cff88ffff",
	[32]="|cff8888ff",
	[64]="|cffff88ff"
}
local ManageBar=NPA_Core.ManageBar

local function NPA_ShieldWatch_ShortNumber(value)
	local ret
	local short=floor(value/100000000)/10
	if(short>1)then
		return (short).."g"
	else
		short=floor(value/100000)/10
		if(short>1)then
			return (short).."m"
		else
			short=floor(value/100)/10
			if(short>1)then
				return (short).."k"
			else
				return value
			end
		end
	end
end

local function NPA_ShieldWatch_BreakNumber(value)
	local str=""
	
	local bre=floor(value/1000000000)
	if(bre>0)then
		value=value-bre*1000000000
		str=bre..","
	end
	bre=floor(value/1000000)
	if(bre>0)then
		value=value-bre*1000000
		str=str..bre..","
	end
	bre=floor(value/1000)
	if(bre>0)then
		value=value-bre*1000
		str=str..bre..","
	end
	str=str..value

	return str
end

local function NPA_ShieldWatch_SetBar(bar,value,max,timeleft,color)
	local percent
	if(not value or max==0)then
		percent=0
	else
		percent=value/max
	end

	if(color)then
		bar:SetVertexColor(bar.R*color.r,bar.G*color.g,bar.B*color.b)
	else
		local bpercent=1-percent
		bar:SetVertexColor(bpercent*bar.R,percent*bar.G,0)
	end
	bar.Percent=percent

end
local function NPA_ShieldWatch_SetTime(main,value,time,percent)
	local remaining=main.Remaining
	if(remaining:IsShown())then
		remaining:SetText(value)
	end
	local timeleft=main.Timeleft
	if(timeleft:IsShown())then
		timeleft:SetText(time)
	end

	if(percent and NPA_ShieldWatch_Config["ShieldWatch_ColorText"]==1)then
		local bpercent=1-percent
		remaining:SetTextColor(bpercent*remaining.R,percent*remaining.G,0)
		timeleft:SetTextColor(bpercent*remaining.R,percent*remaining.G,0)
	end
end

local function NPA_ShieldWatch_OnUpdate(nTime,self,guid,unitdata)
	local data=NPA_ShieldWatch_Data[guid]
	if((not data) or data=={})then
		return
	end
	
	local auras=unitdata.Aura

	if(NPA_ShieldWatch_Config["ShieldWatch_Seperate"]~=1)then --show as one bar
		local bars=self.Bars
		local bar=bars[1]
		local total=0
		local max=0
		local timeleft=0
		for caster,spells in pairs(data) do
			for spellid, absorb in pairs(spells) do
				local checktime
				if(auras)then
					checktime=NPA_ShieldWatch_CheckTimeLeft(auras,caster,spellid,nTime)
				else
					checktime=0
				end
				
				if(checktime>=0)then
					if(checktime>timeleft)then
						timeleft=checktime
					end
					total=total+absorb
					max=max+NPA_ShieldWatch_DataMax[guid][caster][spellid]
				end
			end
		end
		for i=2,table_getn(self.Bars) do
			bars[i]:Hide()
		end
		if(total>0)then
			NPA_ShieldWatch_SetBar(bar,total,max,timeleft)

			timeleft=floor(timeleft)
			if(NPA_ShieldWatch_Config["ShieldWatch_Short"]==1)then
				NPA_ShieldWatch_ShortNumber(total)
			elseif(NPA_ShieldWatch_Config["ShieldWatch_Break"]==1)then
				NPA_ShieldWatch_BreakNumber(total)
			end

			NPA_ShieldWatch_SetTime(self,total,timeleft,bar.Percent)
			ManageBar(nil,bar)
			self:Show()
		else
			self:Hide()
		end	
	else
		local count=0
		local bars=self.Bars
		local timetext
		local absorbtext

		local seperate=NPA_ShieldWatch_Config["ShieldWatch_SeperateText"]
		local colorize=NPA_ShieldWatch_Config["ShieldWatch_ColorText"]
		if(seperate==1)then
			timetext=""
			absorbtext=""
		else
			timetext=0
			absorbtext=0
		end
		local bestcolor=""

		for caster,spells in pairs(data) do
			for spellid, absorb in pairs(spells) do
				local checktime
				if(auras)then
					checktime=NPA_ShieldWatch_CheckTimeLeft(auras,caster,spellid,nTime)
				else
					checktime=0
				end
				if(checktime>=0 and absorb>0)then
					count=count+1
					local max=NPA_ShieldWatch_DataMax[guid][caster][spellid]
					local bar=bars[count]
					if(not bar)then
						bar=NPA_ShieldWatch_CreateBar(self)
						bars[count]=bar
						NPA_ShieldWatch_InitBar(bar,self)
					end

					local school=NPA_ShieldWatch_SchoolCache[spellid or 0] or 0
					local color=NPA_ShieldWatch_SpellTypeColor[school] or {r=1,g=1,b=1}

					NPA_ShieldWatch_SetBar(bar,absorb,max,timeleft,color)

					if(seperate==1)then
						if(checktime==0)then
							checktime="*"
						end

						checktime=floor(checktime)
						if(NPA_ShieldWatch_Config["ShieldWatch_Short"]==1)then
							absorb=NPA_ShieldWatch_ShortNumber(absorb)
							checktime=NPA_ShieldWatch_ShortNumber(checktime)
						elseif(NPA_ShieldWatch_Config["ShieldWatch_Break"]==1)then
							absorb=NPA_ShieldWatch_BreakNumber(absorb)
							checktime=NPA_ShieldWatch_BreakNumber(checktime)
						end

						if(colorize==1)then
							local textcolor=NPA_ShieldWatch_SpellTypeColor2[school] or "|cffffffff"
							timetext=timetext..textcolor.."["..checktime.."]"
							absorbtext=absorbtext..textcolor.."["..absorb.."]"
						else
							timetext=timetext.."["..checktime.."]"
							absorbtext=absorbtext.."["..absorb.."]"
						end
					else
						if(checktime>timetext)then
							if(colorize==1)then
								bestcolor=NPA_ShieldWatch_SpellTypeColor2[school] or "|cffffffff"
							end
							timetext=floor(checktime)
						end
						absorbtext=absorbtext+absorb
					end
				end
			end
		end
		if(count==0)then
			self:Hide()
		else
			NPA_ShieldWatch_SetTime(self,bestcolor..absorbtext,bestcolor..timetext)	

			if(NPA_ShieldWatch_Config["ShieldWatch_AltDisplay"]==1)then
				local width=self.Width/count
				local height=self.Height
				local offsetx=-(self.Width+width)/2
				for i=1,count do
					local ox=offsetx+width*i
					bars[i].OffsetX=ox
					bars[i].OffsetY=0
					bars[i]:SetWidth(width)
					bars[i].Width=width
					bars[i]:SetHeight(height)
					bars[i].Height=height
					ManageBar(nil,bars[i])
				end
			else
				local width=self.Width
				local height=self.Height/count
				local offsety=-(self.Height+height)/2
				for i=1,count do
					local oy=offsety+height*i
					bars[i].OffsetX=0
					bars[i].OffsetY=oy
					bars[i]:SetWidth(width)
					bars[i].Width=width
					bars[i]:SetHeight(height)
					bars[i].Height=height
					ManageBar(nil,bars[i])
				end
			end
			for i=count+1,table_getn(bars)do
				bars[i]:Hide()
			end
			self:Show()
		end			
	end
end

local function NPA_ShieldWatch_SetFrame(main)
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_ShieldWatch_Config["ShieldWatch_OffsetX"],NPA_ShieldWatch_Config["ShieldWatch_OffsetY"])
	main:SetHeight(NPA_ShieldWatch_Config["ShieldWatch_BarHeight"])
	main:SetWidth(NPA_ShieldWatch_Config["ShieldWatch_BarWidth"])


	main.Width=NPA_ShieldWatch_Config["ShieldWatch_BarWidth"]
	main.Height=NPA_ShieldWatch_Config["ShieldWatch_BarHeight"]

	ManageTexture(nil,main.Border,NPA_ShieldWatch_Config["ShieldWatch_BorderData"],main)

	ManageFont(nil,main.Remaining,NPA_ShieldWatch_Config["ShieldWatch_Text2Data"],main)
	ManageFont(nil,main.Timeleft,NPA_ShieldWatch_Config["ShieldWatch_TextData"],main)


	if(NPA_ShieldWatch_Config["ShieldWatch_ShowRemaining"]~=1 or value==0)then
		main.Remaining:Hide()
	else
		main.Remaining:Show()
	end
	if(NPA_ShieldWatch_Config["ShieldWatch_ShowTimeleft"]~=1 or timeleft==0)then
		main.Timeleft:Hide()
	else
		main.Timeleft:Show()
	end

	for _,bar in pairs(main.Bars) do
		NPA_ShieldWatch_InitBar(bar,main)
	end
end

local function NPA_ShieldWatch_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_ShieldWatch_MainFrame",frame)
	main:SetWidth(1)
	main:SetHeight(1)
	main:Hide()
	main:SetFrameStrata("LOW")

	local border=main:CreateTexture("NPA_ShieldWatch_Border","OVERLAY",nil)
	border:Show()
	
	local remaining=main:CreateFontString("NPA_ShieldWatch_Text","OVERLAY")
	remaining:Show()

	local timeleft=main:CreateFontString("NPA_ShieldWatch_Text","OVERLAY")
	timeleft:Show()

	main.Remaining=remaining
	main.Timeleft=timeleft

	main.Border=border

	main.Bars={[1]=NPA_ShieldWatch_CreateBar(main)}
	
	
	NPA_ShieldWatch_SetFrame(main)
	table_insert(NPA_ShieldWatch_Frame,main)

	frame["ShieldWatch"]=main
end

function NPA_ShieldWatch:Test()
	NPA_ShieldWatch_Data[-100]={
		[-100]={[-100]=floor(random()*1000)},
		[UnitGUID("player") or -100]={[-101]=floor(random()*1000)},
		}


	NPA_ShieldWatch_DataMax[-100]={
		[-100]={[-100]=1000},
		[UnitGUID("player") or -100]={[-101]=1000},
		}	

	NPA_ShieldWatch_SchoolCache[-100]=2^floor(random()*6)
	NPA_ShieldWatch_SchoolCache[-101]=2^floor(random()*6)
		
end



function NPA_ShieldWatch:ClearData()
	NPA_ShieldWatch_Data={}
	NPA_ShieldWatch_DataMax={}
	NPA_ShieldWatch_SchoolCache={}
end

local NPA_ShieldWatch_Filter={
	["SPELL_AURA_APPLIED"]=1,
	["SPELL_AURA_REFRESH"]=1,
	["SPELL_AURA_REMOVED"]=2,
	["SPELL_AURA_DISPEL"]=2,
	["SPELL_AURA_STOLEN"]=2
}



local function NPA_ShieldWatch_OnEvent(uarg)
	if(uarg[13] and uarg[12]=="BUFF" and NPA_ShieldWatch_Filter[uarg[2]])then
		NPA_ShieldWatch_SchoolCache[uarg[9]]=uarg[11]

		if(uarg[2]=="SPELL_AURA_REMOVED")then
			if(NPA_ShieldWatch_Data[uarg[6]] and NPA_ShieldWatch_Data[uarg[6]][uarg[3]])then
				NPA_ShieldWatch_Data[uarg[6]][uarg[3]][uarg[9]]=nil
			end	
		else
			if(not NPA_ShieldWatch_Data[uarg[6]])then
				NPA_ShieldWatch_Data[uarg[6]]={}
			end
			if(not NPA_ShieldWatch_Data[uarg[6]][uarg[3]])then
				NPA_ShieldWatch_Data[uarg[6]][uarg[3]]={}
			end
			if(uarg[13]<=0)then
				NPA_ShieldWatch_Data[uarg[6]][uarg[3]][uarg[9]]=nil
			else
				NPA_ShieldWatch_Data[uarg[6]][uarg[3]][uarg[9]]=uarg[13]
			
				--record max
				if(not NPA_ShieldWatch_DataMax[uarg[6]])then
					NPA_ShieldWatch_DataMax[uarg[6]]={}
				end
				if(not NPA_ShieldWatch_DataMax[uarg[6]][uarg[3]])then
					NPA_ShieldWatch_DataMax[uarg[6]][uarg[3]]={}
				end
				local max=NPA_ShieldWatch_DataMax[uarg[6]][uarg[3]][uarg[9]]
				if(uarg[2]=="SPELL_AURA_APPLIED" or (not max) or max<uarg[13])then
					NPA_ShieldWatch_DataMax[uarg[6]][uarg[3]][uarg[9]]=uarg[13]
				end
			end
		end
	end
end


function NPA_ShieldWatch:ApplyConfig()
	NPA_Core:CheckConfigEntry("ShieldWatch",NPA_ShieldWatch_DefaultSetting)

	NPA_ShieldWatch_Config=NPA_Config["ShieldWatch"]
	NPA_ShieldWatch_Config["ShieldWatch"]=NPA_Config["Core"]["ShieldWatch"]


	for _,main in pairs(NPA_ShieldWatch_Frame) do
		NPA_ShieldWatch_SetFrame(main)
	end

	if(NPA_Config["Core"]["EnableModule"]["ShieldWatch"]==1)then
		NPA_Core.CombatEventFunc["ShieldWatch"]=NPA_ShieldWatch_OnEvent
	else
		NPA_Core.CombatEventFunc["ShieldWatch"]=nil
	end
end

NPA_Core:AddHook("ShieldWatch",NPA_ShieldWatch_HookFrame)
NPA_Core:AddModule("ShieldWatch",NPA_ShieldWatch)
NPA_Core:HookUpdate("ShieldWatch",NPA_ShieldWatch_OnUpdate,2)
