﻿-- Author      : Nogarder
-- Create Date : 2010/7/5 2:09:16

local Localization={}
if(locale=="zhTW")then
	Localization={
		["Unknow"]="未知",
	}
elseif(locale=="zhCN")then
	Localization={
		["Unknow"]="未知",
	}
else
	Localization={
		["Unknow"]="Unknow",
	}
end

--global functions

local pairs=pairs
local strfind=strfind
local GetSpellInfo=GetSpellInfo
local GetTime=GetTime
local unpack=unpack
local random=random
local abs=abs

local table_insert=table.insert

local GetTime=GetTime

local COMBATLOG_OBJECT_REACTION_HOSTILE=COMBATLOG_OBJECT_REACTION_HOSTILE
local bit_band=bit.band


local GUIDToFrame=NPA_Core.GUIDToFrame

--config
local NPA_ScrollText={}


local NPA_ScrollText_DefaultSetting={
		["ScrollText_UpdateInterval"]=0.03,

		["ScrollText_Enabled"]=1,

		--scrolltext in (original)

		["ScrollText_IconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=25,
			Width=25,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="RIGHT",
			ToAnchor="LEFT",
			},
		["ScrollText_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ScrollText_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ScrollText_CritIconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=40,
			Width=40,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="RIGHT",
			ToAnchor="LEFT",
			},
		["ScrollText_CritBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ScrollText_CritOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["ScrollText_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=20,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="LEFT",
			ToAnchor="RIGHT",
			},
	
		["ScrollText_CritTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=40,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="LEFT",
			ToAnchor="RIGHT",
			},

		["ScrollText_OffsetX"]=0,
		["ScrollText_OffsetY"]=20,
		["ScrollText_SpeedX"]=0,
		["ScrollText_SpeedY"]=150,
		["ScrollText_Max"]=50,
		["ScrollText_SpreadX"]=100,
		["ScrollText_SpreadY"]=50,
		["ScrollText_AccX"]=0,
		["ScrollText_AccY"]=-200,
		["ScrollText_Life"]=1.5,

		["ScrollText_Filter_In_Damage_Type"]={
				["Melee"]=1,
				["Range"]=1,
				["Spell"]=1,
				["SpellShield"]=1,
				["Environmental"]=1,
				["Dot"]=1,
			},
		["ScrollText_Filter_In_Damage"]={
				["ShowFromSelf"]=1,
				["ShowFromHostile"]=1,
				["ShowFromNonHostile"]=1,
				["ShowFromFocus"]=1,
				["ShowFromTarget"]=1,
				["ShowFromPet"]=1,

				["ShowToHostile"]=1,
				["ShowToSelf"]=1,
				["ShowToNonHostile"]=1,
				["ShowToFocus"]=1,
				["ShowToTarget"]=1,
				["ShowToPet"]=1,

				DeepCheck=1,
			},
		["ScrollText_Filter_In_Heal_Type"]={
				["Heal"]=1,
				["Hot"]=1,
			},
		["ScrollText_Filter_In_Heal"]={
				["ShowFromSelf"]=1,
				["ShowFromHostile"]=1,
				["ShowFromNonHostile"]=1,
				["ShowFromFocus"]=1,
				["ShowFromTarget"]=1,
				["ShowFromPet"]=1,

				["ShowToHostile"]=1,
				["ShowToSelf"]=1,
				["ShowToNonHostile"]=1,
				["ShowToFocus"]=1,
				["ShowToTarget"]=1,
				["ShowToPet"]=1,

				DeepCheck=1,
			},
		["ScrollText_Filter_In_Misc_Type"]={
				["DamageMiss"]=1,
				["DamageShieldMiss"]=1,
				["SpellMiss"]=1,
				["DispelMiss"]=1,
				["Stolen"]=1,
				["Dispel"]=1,
				["AuraGain"]=1,
				["AuraLost"]=1,
				["Interrupt"]=1,
				["Energized"]=1,
			},
		["ScrollText_Filter_In_Misc"]={
				["ShowFromSelf"]=1,
				["ShowFromHostile"]=1,
				["ShowFromNonHostile"]=1,
				["ShowFromFocus"]=1,
				["ShowFromTarget"]=1,
				["ShowFromPet"]=1,

				["ShowToHostile"]=1,
				["ShowToSelf"]=1,
				["ShowToNonHostile"]=1,
				["ShowToFocus"]=1,
				["ShowToTarget"]=1,
				["ShowToPet"]=1,

				DeepCheck=1,
			},

		["ScrollText_Filter_ShowCaster"]=0,
		["ScrollText_Filter_ShowSpellName"]=0,
		["ScrollText_Filter_ShowSelf"]=0,
		["ScrollText_Filter_ShowSpellRank"]=0,
		["ScrollText_Filter_StickCrit"]=1,
		["ScrollText_Filter_ShakeCrit"]=1,
		["ScrollText_Filter_Absorb"]=1,
		["ScrollText_HideByFrame"]=0,
		["ScrollText_AlphaByFrame"]=0,
		["ScrollText_HideFullOverHeal"]=0,

	---scrolltext flying icon
		["ScrollText_FlyingIcon_Enabled"]=0,
		["ScrollText_FlyingIcon_IconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",

			},

		["ScrollText_FlyingIcon_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ScrollText_FlyingIcon_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["ScrollText_FlyingIcon_Max"]=10,
		["ScrollText_FlyingIcon_HideByFrame"]=0,
		["ScrollText_FlyingIcon_AlphaByFrame"]=0,
		["ScrollText_FlyingIcon_InstantCast"]=1,
		["ScrollText_FlyingIcon_Melee"]=1,
		["ScrollText_FlyingIcon_Range"]=1,
		["ScrollText_FlyingIcon_Spell"]=1,
		["ScrollText_FlyingIcon_Miss"]=1,
		["ScrollText_FlyingIcon_Aura"]=0,
		["ScrollText_FlyingIcon_Heal"]=1,
		["ScrollText_FlyingIcon_Dot"]=1,
		["ScrollText_FlyingIcon_Interrupt"]=1,
		["ScrollText_FlyingIcon_Energized"]=1,


		--scrolltext_out
		["ScrollText_Out_Enabled"]=0,
	
		["ScrollText_Out_IconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=25,
			Width=25,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="RIGHT",
			ToAnchor="LEFT",
			},
		["ScrollText_Out_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ScrollText_Out_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ScrollText_Out_CritIconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=40,
			Width=40,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="RIGHT",
			ToAnchor="LEFT",
			},
		["ScrollText_Out_CritBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ScrollText_Out_CritOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["ScrollText_Out_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=20,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="LEFT",
			ToAnchor="RIGHT",
			},
	
		["ScrollText_Out_CritTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=40,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="LEFT",
			ToAnchor="RIGHT",
			},

		["ScrollText_Out_OffsetX"]=0,
		["ScrollText_Out_OffsetY"]=-20,
		["ScrollText_Out_SpeedX"]=0,
		["ScrollText_Out_SpeedY"]=-150,
		["ScrollText_Out_Max"]=50,
		["ScrollText_Out_SpreadX"]=100,
		["ScrollText_Out_SpreadY"]=-50,
		["ScrollText_Out_AccX"]=0,
		["ScrollText_Out_AccY"]=200,
		["ScrollText_Out_Life"]=1.5,

		["ScrollText_Filter_Out_Damage_Type"]={
				["Melee"]=1,
				["Range"]=1,
				["Spell"]=1,
				["SpellShield"]=1,
				["Environmental"]=1,
				["Dot"]=1,

			},
		["ScrollText_Filter_Out_Damage"]={
				["ShowFromSelf"]=1,
				["ShowFromHostile"]=1,
				["ShowFromNonHostile"]=1,
				["ShowFromFocus"]=1,
				["ShowFromTarget"]=1,
				["ShowFromPet"]=1,

				["ShowToHostile"]=1,
				["ShowToSelf"]=1,
				["ShowToNonHostile"]=1,
				["ShowToFocus"]=1,
				["ShowToTarget"]=1,
				["ShowToPet"]=1,

				DeepCheck=1,
			},
		["ScrollText_Filter_Out_Heal_Type"]={
				["Heal"]=1,
				["Hot"]=1,
			},
		["ScrollText_Filter_Out_Heal"]={
				["ShowFromSelf"]=1,
				["ShowFromHostile"]=1,
				["ShowFromNonHostile"]=1,
				["ShowFromFocus"]=1,
				["ShowFromTarget"]=1,
				["ShowFromPet"]=1,

				["ShowToHostile"]=1,
				["ShowToSelf"]=1,
				["ShowToNonHostile"]=1,
				["ShowToFocus"]=1,
				["ShowToTarget"]=1,
				["ShowToPet"]=1,

				DeepCheck=1,
			},
		["ScrollText_Filter_Out_Misc_Type"]={
				["DamageMiss"]=1,
				["DamageShieldMiss"]=1,
				["SpellMiss"]=1,
				["DispelMiss"]=1,
				["Stolen"]=1,
				["Dispel"]=1,
				["AuraGain"]=1,
				["AuraLost"]=1,
				["Interrupt"]=1,
				["Energized"]=1,

			},
		["ScrollText_Filter_Out_Misc"]={
				["ShowFromSelf"]=1,
				["ShowFromHostile"]=1,
				["ShowFromNonHostile"]=1,
				["ShowFromFocus"]=1,
				["ShowFromTarget"]=1,
				["ShowFromPet"]=1,

				["ShowToHostile"]=1,
				["ShowToSelf"]=1,
				["ShowToNonHostile"]=1,
				["ShowToFocus"]=1,
				["ShowToTarget"]=1,
				["ShowToPet"]=1,

				DeepCheck=1,
			},

		["ScrollText_Out_Filter_ShowCaster"]=0,
		["ScrollText_Out_Filter_ShowSpellName"]=0,
		["ScrollText_Out_Filter_ShowSelf"]=0,
		["ScrollText_Out_Filter_ShowSpellRank"]=0,
		["ScrollText_Out_Filter_StickCrit"]=1,
		["ScrollText_Out_Filter_ShakeCrit"]=1,
		["ScrollText_Out_Filter_Absorb"]=1,
		["ScrollText_Out_HideByFrame"]=0,
		["ScrollText_Out_AlphaByFrame"]=0,
		["ScrollText_Out_HideFullOverHeal"]=0,
	}


local NPA_ScrollText_Config=NPA_ScrollText_DefaultSetting

local NPA_ScrollText_Max=0
local NPA_ScrollText_Out_Max=0
local NPA_ScrollText_FlyingIcon_Max=0

local NPA_ScrollText_Scrolls={}
local NPA_ScrollText_ScrollCount=1

local NPA_ScrollText_Out_Scrolls={}
local NPA_ScrollText_Out_ScrollCount=1

local NPA_ScrollText_Icons={}
local NPA_ScrollText_IconCount=1



function NPA_ScrollText:ResetConfig()
	NPA_Config["ScrollText"]=CopyTable(NPA_ScrollText_DefaultSetting)
	NPA_Config["ScrollText_Out"]=CopyTable(NPA_ScrollText_DefaultSetting)
	NPA_Config["ScrollText_FlyingIcon"]=CopyTable(NPA_ScrollText_FlyingIcon_DefaultSetting)
end


local NPA_ScrollText_CombatLogFilter={}
local NPA_ScrollText_Out_CombatLogFilter={}

local NPA_ScrollText_OnEventFilterDest={
		[1]={},
		[2]={},
		[3]={},
	}
local NPA_ScrollText_OnEventFilterFrom={
		[1]={},
		[2]={},
		[3]={},
	}

local NPA_ScrollText_Out_OnEventFilterDest={
		[1]={},
		[2]={},
		[3]={},
	}
local NPA_ScrollText_Out_OnEventFilterFrom={
		[1]={},
		[2]={},
		[3]={},
	}

local NPA_ScrollText_OnEventFunc={}

local NPA_ScrollText_FlyingIconFilter={}
local NPA_ScrollText_Out_FlyingIconFilter={}

local NPA_ScrollText_ShowOnSelf
local NPA_ScrollText_Out_ShowFromSelf

local NPA_ScrollText_Template={}
local NPA_ScrollText_OutTemplate={}


local NPA_ScrollText_PowerColor={
	[0]={r=0.00, g=0.00, b=1.00 }, --mana
	[1]={r=1.00, g=0.00, b=0.00 }, --rage
	[2]={r=1.00, g=0.50, b=0.25 }, --focus
	[3]={r=1.00, g=1.00, b=0.00 }, --enegry
	[4]={r=0.00, g=1.00, b=1.00 }, --happiness
	[5]={r=0.50, g=0.50, b=0.50 }, --rune
	[6]={r=0.00, g=0.82, b=1.00 }, --rune power
	[7]={r=0.50, g=0.32, b=0.55 }, --soul shard
	[8]={r=0.30, g=0.52, b=0.90 }, --lunar power
	[9]={r=0.95, g=0.90, b=0.60 }  --holy power
}
--spelltype color data /r,g,b
local NPA_ScrollText_SpellTypeColor={
	[1]={r=1,g=1,b=0},
	[2]={r=1,g=1,b=0.5},
	[4]={r=1,g=0.3,b=0},
	[8]={r=0.25,g=1,b=0.25},
	[16]={r=0.5,g=1,b=1},
	[32]={r=0.5,g=0.5,b=1},
	[64]={r=1,g=0.5,b=1}
}


local function NPA_ScrollText_CopyTemplate(target,template)
	target.X=template.X
	target.Y=template.Y
	target.AccX=template.AccX
	target.AccY=template.AccY
	target.Life=template.Life
	target.MaxLife=template.MaxLife
	target.StickCrit=template.StickCrit
	target.ShakeCrit=template.ShakeCrit
	target.HideByFrame=template.HideByFrame
	target.AlphaByFrame=template.AlphaByFrame

end


local function NPA_ScrollText_AddScroll(guid,spellid,text,spelltype,large,extratype)

	local frame=GUIDToFrame[guid]
	if(not(frame and frame:IsShown()))then
		return
	end
	
	
	NPA_ScrollText_ScrollCount=NPA_ScrollText_ScrollCount+1
	if(NPA_ScrollText_ScrollCount>NPA_ScrollText_Max)then
		NPA_ScrollText_ScrollCount=1
	end
	local scroll=NPA_ScrollText_Scrolls[NPA_ScrollText_ScrollCount]

	local name,rank,icon
	if(spellid and spellid~=75 and spellid~=5019)then --override shoot /wand shoot
		name,rank,icon = GetSpellInfo(spellid)
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_ShowSpellName"]==1 and name)then
		text=text.."("..name..")"
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_ShowSpellRank"]==1 and rank)then
		text=text.."("..rank..")"
	end

	--debug
	--text=text..spellid

	
	local color
	if(extratype)then
		color=NPA_ScrollText_PowerColor[extratype] or {r=1,g=1,b=1}
	elseif(spelltype)then
		color=NPA_ScrollText_SpellTypeColor[spelltype] or {r=1,g=1,b=1}
	else
		color={r=1,g=1,b=1}
	end
	

	NPA_ScrollText_CopyTemplate(scroll,NPA_ScrollText_Template)

	scroll.OffsetX,scroll.OffsetY=frame:GetCenter()
	scroll.StepX=(random()-0.5) * NPA_ScrollText_Config["ScrollText_SpreadX"]+NPA_ScrollText_Config["ScrollText_SpeedX"]
	scroll.StepY=(random())*NPA_ScrollText_Config["ScrollText_SpreadY"]+NPA_ScrollText_Config["ScrollText_SpeedY"]
	scroll.GUID=guid
	
	local st
	local si
	if(large==1)then
		scroll.Crit=1

		scroll.Text:Hide()
		scroll.Icon:Hide()
		scroll.Background:Hide()
		scroll.Overlay:Hide()

		scroll.CritText:Show()
		scroll.CritIcon:Show()
		scroll.CritBackground:Show()
		scroll.CritOverlay:Show()

		if(scroll.StickCrit==1)then
			scroll.StepX=scroll.StepX*2
			scroll.AccX=0
			scroll.AccY=0
		end

		st=scroll.CritText
		si=scroll.CritIcon
	else
		scroll.Crit=nil

		scroll.Text:Show()
		scroll.Icon:Show()
		scroll.Background:Show()
		scroll.Overlay:Show()

		scroll.CritText:Hide()
		scroll.CritIcon:Hide()
		scroll.CritBackground:Hide()
		scroll.CritOverlay:Hide()

		st=scroll.Text
		si=scroll.Icon

	end
	st:SetText(text)
	st:SetTextColor(st.R*color.r,st.G*color.g,st.B*color.b)
	si:SetTexture(icon)

	scroll:Show()

end


local function NPA_ScrollText_Out_AddScroll(guid,spellid,text,spelltype,large,extratype)

	local frame=GUIDToFrame[guid]
	if(not(frame and frame:IsShown()))then
		return
	end


	NPA_ScrollText_Out_ScrollCount=NPA_ScrollText_Out_ScrollCount+1
	if(NPA_ScrollText_Out_ScrollCount>NPA_ScrollText_Out_Max)then
		NPA_ScrollText_Out_ScrollCount=1
	end
	
	local scroll=NPA_ScrollText_Out_Scrolls[NPA_ScrollText_Out_ScrollCount]

	local name,rank,icon
	if(spellid and spellid~=75 and spellid~=5019)then --override shoot /wand shoot
		name,rank,icon = GetSpellInfo(spellid)
	end
	
	if(NPA_ScrollText_Config["ScrollText_Out_Filter_ShowSpellName"]==1 and name)then
		text=text.."("..name..")"
	end

	if(NPA_ScrollText_Config["ScrollText_Out_Filter_ShowSpellRank"]==1 and rank)then
		text=text.."("..rank..")"
	end

	--debug
	--text=text..spellid

	
	local color
	if(extratype)then
		color=NPA_ScrollText_PowerColor[extratype] or {r=1,g=1,b=1}
	elseif(spelltype)then
		color=NPA_ScrollText_SpellTypeColor[spelltype] or {r=1,g=1,b=1}
	else
		color={r=1,g=1,b=1}
	end
	
	NPA_ScrollText_CopyTemplate(scroll,NPA_ScrollText_Out_Template)
	scroll.OffsetX,scroll.OffsetY=frame:GetCenter()
	scroll.StepX=(random()-0.5) * NPA_ScrollText_Config["ScrollText_Out_SpreadX"]+NPA_ScrollText_Config["ScrollText_Out_SpeedX"]
	scroll.StepY=(random())*NPA_ScrollText_Config["ScrollText_Out_SpreadY"]+NPA_ScrollText_Config["ScrollText_Out_SpeedY"]
	scroll.GUID=guid
	
	local st
	local si
	if(large==1)then
		scroll.Crit=1

		scroll.Text:Hide()
		scroll.Icon:Hide()
		scroll.Background:Hide()
		scroll.Overlay:Hide()

		scroll.CritText:Show()
		scroll.CritIcon:Show()
		scroll.CritBackground:Show()
		scroll.CritOverlay:Show()

		if(scroll.StickCrit==1)then
			scroll.StepX=scroll.StepX*2
			scroll.AccX=0
			scroll.AccY=0
		end

		st=scroll.CritText
		si=scroll.CritIcon
	else
		scroll.Crit=nil

		scroll.Text:Show()
		scroll.Icon:Show()
		scroll.Background:Show()
		scroll.Overlay:Show()

		scroll.CritText:Hide()
		scroll.CritIcon:Hide()
		scroll.CritBackground:Hide()
		scroll.CritOverlay:Hide()

		st=scroll.Text
		si=scroll.Icon

	end
	st:SetText(text)
	st:SetTextColor(st.R*color.r,st.G*color.g,st.B*color.b)
	si:SetTexture(icon)

	scroll:Show()

end

	------------flying icon----------------
local function NPA_ScrollText_AddIcon(sourceGUID,destGUID,spellid,switch)
	if(sourceGUID==destGUID)then
		return
	end

	if((not spellid) or switch==2)then
		spellid=24817
	end

	local _,_,icon=GetSpellInfo(spellid)

	
	local sourceframe=GUIDToFrame[sourceGUID]
	local destframe=GUIDToFrame[destGUID]

	if(icon
		and destframe and destframe:IsShown()
		and sourceframe and sourceframe:IsShown())then

		local flyingicon=NPA_ScrollText_Icons[NPA_ScrollText_IconCount]
		
		NPA_ScrollText_IconCount=NPA_ScrollText_IconCount+1
		if(NPA_ScrollText_IconCount>NPA_ScrollText_FlyingIcon_Max)then
			NPA_ScrollText_IconCount=1
		end

		flyingicon.GUID=destGUID

		local sx,sy=sourceframe:GetCenter()
		sx=sx or 0
		sy=sy or 0

		local scale=UIParent:GetScale()

		if(sourceframe.IsTracker)then
			sx=sx*scale
			sy=sy*scale
		end

		flyingicon.X=sx
		flyingicon.Y=sy

		flyingicon.TargetX=sx+20
		flyingicon.TargetY=sy+20
		flyingicon:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",sx/scale,sy/scale)
		
		flyingicon.Icon:SetTexture(icon)

		flyingicon:Show()
	end
end


local NPA_ScrollText_CombatEventFunctions={
--               2             3          4       5    6       7    8        9     10   11   12   13   14   15   16   17    18                            
--_,event,_,combatevent ,sourceGUID, sourceName, _, destGUID, _, destFlags, arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)
	[1]=function(name,uarg)
		local text
		if(NPA_ScrollText_Config["ScrollText_Filter_Absorb"]==1)then
			local absorb=uarg[12]+ uarg[13] + uarg[14]
			local a=uarg[10]
			if(type(a)=="number" and tonumber(a)>0)then
				absorb=absorb+a
			end
			if(absorb~=0)then
				text=" -"..uarg[9].."(-"..absorb..")"
			else
				text=" -"..uarg[9]
			end
		else
			text=" -"..uarg[9]
		end
		NPA_ScrollText_AddScroll(uarg[6],nil,text..name,nil,uarg[18])
	end,

	[2]=function(name,uarg)
		local text
		if(NPA_ScrollText_Config["ScrollText_Filter_Absorb"]==1)then
			local absorb=uarg[15]+ uarg[16]+ uarg[17]
			local a=uarg[10]
			if(type(a)=="number" and a>0)then
				absorb=absorb+a
			end

			if(absorb~=0)then
				text=" -"..uarg[12].."(-"..absorb..")"
			else
				text=" -"..uarg[12]
			end
		else
			text=" -"..uarg[12]
		end
		
		NPA_ScrollText_AddScroll(uarg[6],uarg[9],text..name,uarg[11],uarg[18])
	end,

	[3]=function(name,uarg)
		NPA_ScrollText_AddScroll(uarg[6],uarg[9]," +"..name,uarg[11])

	end,
	[4]=function(name,uarg)
		NPA_ScrollText_AddScroll(uarg[6],uarg[9]," -"..name,uarg[11])

	end,
	[5]=function(name,uarg)
		local absorb=uarg[13] + uarg[14]
		if(NPA_ScrollText_Config["ScrollText_HideFullOverHeal"]~=1 or uarg[12]>absorb)then
			local text
			if(NPA_ScrollText_Config["ScrollText_Filter_Absorb"]==1)then
				if(absorb~=0)then
					text=" +"..(uarg[12]-absorb).."("..absorb..")"
				else
					text=" +"..uarg[12]
				end
			else
				text=" +"..uarg[12]
			end
			NPA_ScrollText_AddScroll(uarg[6],uarg[9],text..name,uarg[11],uarg[15])
		end
	end,

--               2             3          4       5    6       7    8        9     10   11   12   13   14   15   16   17    18                            
--_,event,_,combatevent ,sourceGUID, sourceName, _, destGUID, _, destFlags, arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)

	[6]=function(name,uarg)
		NPA_ScrollText_AddScroll(uarg[6],uarg[12]," X"..name,uarg[14],1)
	end,
	[7]=function(name,uarg)
		NPA_ScrollText_AddScroll(uarg[6],uarg[9]," +"..uarg[12],nil,nil,uarg[13])
	end,
	[8]=function(name,uarg)
		NPA_ScrollText_AddScroll(uarg[6],uarg[9]," X"..name,uarg[11],1)
	end,
}

local NPA_ScrollText_Out_CombatEventFunctions={
--               2             3          4       5    6       7    8        9     10   11   12   13   14   15   16   17    18                            
--_,event,_,combatevent ,sourceGUID, sourceName, _, destGUID, _, destFlags, arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)
	[1]=function(name,uarg)
		local text
		if(NPA_ScrollText_Config["ScrollText_Out_Filter_Absorb"]==1)then
			local absorb=uarg[12]+ uarg[13] + uarg[14]
			local a=uarg[10]
			if(type(a)=="number" and tonumber(a)>0)then
				absorb=absorb+a
			end
			if(absorb~=0)then
				text=" -"..uarg[9].."(-"..absorb..")"
			else
				text=" -"..uarg[9]
			end
		else
			text=" -"..uarg[9]
		end
		NPA_ScrollText_Out_AddScroll(uarg[3],nil,text..name,nil,uarg[18])
	end,

	[2]=function(name,uarg)
		local text
		if(NPA_ScrollText_Config["ScrollText_Out_Filter_Absorb"]==1)then
			local absorb=uarg[15]+ uarg[16]+ uarg[17]
			local a=uarg[10]
			if(type(a)=="number" and a>0)then
				absorb=absorb+a
			end

			if(absorb~=0)then
				text=" -"..uarg[12].."(-"..absorb..")"
			else
				text=" -"..uarg[12]
			end
		else
			text=" -"..uarg[12]
		end
		
		NPA_ScrollText_Out_AddScroll(uarg[3],uarg[9],text..name,uarg[11],uarg[18])
	end,

	[3]=function(name,uarg)
		NPA_ScrollText_Out_AddScroll(uarg[3],uarg[9]," +"..name,uarg[11])

	end,
	[4]=function(name,uarg)
		NPA_ScrollText_Out_AddScroll(uarg[3],uarg[9]," -"..name,uarg[11])

	end,
	[5]=function(name,uarg)
		local absorb=uarg[13] + uarg[14]
		if(NPA_ScrollText_Config["ScrollText_Out_HideFullOverHeal"]~=1 or uarg[12]>absorb)then
			local text
			if(NPA_ScrollText_Config["ScrollText_Out_Filter_Absorb"]==1)then
				if(absorb~=0)then
					text=" +"..(uarg[12]-absorb).."("..absorb..")"
				else
					text=" +"..uarg[12]
				end
			else
				text=" +"..uarg[12]
			end
			NPA_ScrollText_Out_AddScroll(uarg[3],uarg[9],text..name,uarg[11],uarg[15])
		end
	end,

--               2             3          4       5    6       7    8        9     10   11   12   13   14   15   16   17    18                            
--_,event,_,combatevent ,sourceGUID, sourceName, _, destGUID, _, destFlags, arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)

	[6]=function(name,uarg)
		NPA_ScrollText_Out_AddScroll(uarg[3],uarg[12]," X"..name,uarg[14],1)
	end,
	[7]=function(name,uarg)
		NPA_ScrollText_Out_AddScroll(uarg[3],uarg[9]," +"..uarg[12],nil,nil,uarg[13])
	end,
	[8]=function(name,uarg)
		NPA_ScrollText_Out_AddScroll(uarg[3],uarg[9]," X"..name,uarg[11],1)
	end,
}

local NPA_ScrollText_OnEventFilterData={
	--source func
	["ShowFromHostile"]=function(sourcehostile)
		if(sourcehostile>0)then
			return 1
		end
	end,

	["ShowFromNonHostile"]=function(sourcehostile,sourceGUID,_,_,selfguid)
		if(sourcehostile<=0 and srouce~=selfguid)then
			return 1
		end
	end,

	["ShowFromSelf"]=function(_,sourceGUID,_,_,selfguid)
		if(sourceGUID ==selfguid)then
			return 1
		end
	end,

	["ShowFromPet"]=function(_,sourceGUID,_,_,_,petguid)
		if(sourceGUID==petguid)then
			return 1
		end
	end,

	["ShowFromFocus"]=function(_,sourceGUID,_,focusguid)
		if(sourceGUID ==focusguid)then
			return 1
		end
	end,
	
	["ShowFromTarget"]=function(_,sourceGUID,targetguid)
		if(sourceGUID ==targetguid)then
			return 1
		end
	end,

	--dest func
	["ShowToHostile"]=function(desthostile)
		if(desthostile>0)then
			return 1
		end
	end,

	["ShowToNonHostile"]=function(desthostile,destGUID,_,_,selfguid)
		if(desthostile<=0 and destGUID~=selfguid)then
			return 1
		end
	end,

	["ShowToFocus"]=function(_,destGUID,_,focusguid)
		if(destGUID ==focusguid)then
			return 1
		end
	end,

	["ShowToTarget"]=function(_,destGUID,targetguid)
		if(destGUID ==targetguid)then
			return 1
		end
	end,

	["ShowToSelf"]=function(_,destGUID,_,_,selfguid)
		if(destGUID ==selfguid)then
			return 1
		end
	end,
	
	["ShowToPet"]=function(_,destGUID,_,_,_,petguid)
		if(destGUID ==petguid)then
			return 1
		end
	end
}



local function NPA_ScrollText_BuildFilter()
	NPA_ScrollText_CombatLogFilter={}

	--damage
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage_Type"]["Melee"]==1)then
		NPA_ScrollText_CombatLogFilter["SWING_DAMAGE"]={
			func=NPA_ScrollText_CombatEventFunctions[1],
			type=1 -- 1 =damage
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage_Type"]["Range"]==1)then
		NPA_ScrollText_CombatLogFilter["RANGE_DAMAGE"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=1
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage_Type"]["SpellShield"]==1)then
		NPA_ScrollText_CombatLogFilter["DAMAGE_SHIELD"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=1
			}
		NPA_ScrollText_CombatLogFilter["DAMAGE_SPLIT"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=1
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage_Type"]["Spell"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_DAMAGE"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=1
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage_Type"]["Environmental"]==1)then
		NPA_ScrollText_CombatLogFilter["ENVIRONMENTAL_DAMAGE"]={
			func=NPA_ScrollText_CombatEventFunctions[1],
			type=1
			}
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage_Type"]["Dot"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_PERIODIC_DAMAGE"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=1
			}
	end
	
	--heal
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal_Type"]["Heal"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_HEAL"]={
			func=NPA_ScrollText_CombatEventFunctions[5],
			type=2 --2=heal
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal_Type"]["Hot"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_PERIODIC_HEAL"]={
			func=NPA_ScrollText_CombatEventFunctions[5],
			type=2
			}
	end

	--misc
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["DamageMiss"]==1)then
		NPA_ScrollText_CombatLogFilter["SWING_MISSED"]={
			func=NPA_ScrollText_CombatEventFunctions[1],
			type=3 --3= misc
			}
		NPA_ScrollText_CombatLogFilter["RANGE_MISSED"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["DamageShieldMiss"]==1)then
		NPA_ScrollText_CombatLogFilter["DAMAGE_SHIELD_MISSED"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["SpellMiss"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_MISSED"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["DispelMiss"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_DISPEL_FAILED"]={
			func=NPA_ScrollText_CombatEventFunctions[2],
			type=3
			}
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["Interrupt"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_INTERRUPT"]={
			func=NPA_ScrollText_CombatEventFunctions[6],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["Stolen"]==1)then	
		NPA_ScrollText_CombatLogFilter["SPELL_STOLEN"]={
			func=NPA_ScrollText_CombatEventFunctions[6],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["Dispel"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_AURA_BROKEN"]={
			func=NPA_ScrollText_CombatEventFunctions[8],
			type=3
			}
		NPA_ScrollText_CombatLogFilter["SPELL_AURA_BROKEN_SPELL"]={
			func=NPA_ScrollText_CombatEventFunctions[8],
			type=3
			}
		NPA_ScrollText_CombatLogFilter["SPELL_DISPEL"]={
			func=NPA_ScrollText_CombatEventFunctions[6],
			type=3
			}
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["AuraGain"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_AURA_APPLIED"]={
			func=NPA_ScrollText_CombatEventFunctions[3],
			type=3
			}
		NPA_ScrollText_CombatLogFilter["SPELL_AURA_APPLIED_DOSE"]={
			func=NPA_ScrollText_CombatEventFunctions[3],
			type=3
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["AuraLost"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_AURA_REMOVED"]={
			func=NPA_ScrollText_CombatEventFunctions[4],
			type=3
			}
		NPA_ScrollText_CombatLogFilter["SPELL_AURA_REMOVED_DOSE"]={
			func=NPA_ScrollText_CombatEventFunctions[4],
			type=3
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc_Type"]["Energized"]==1)then
		NPA_ScrollText_CombatLogFilter["SPELL_ENERGIZE"]={
			func=NPA_ScrollText_CombatEventFunctions[7],
			type=3
			}
		NPA_ScrollText_CombatLogFilter["SPELL_PERIODIC_ENERGIZE"]={
			func=NPA_ScrollText_CombatEventFunctions[7],
			type=3
			}
	end
	------------------------- out 
	NPA_ScrollText_Out_CombatLogFilter={}

	--damage
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage_Type"]["Melee"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SWING_DAMAGE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[1],
			type=1 -- 1 =damage
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage_Type"]["Range"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["RANGE_DAMAGE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=1
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage_Type"]["SpellShield"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["DAMAGE_SHIELD"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=1
			}
		NPA_ScrollText_Out_CombatLogFilter["DAMAGE_SPLIT"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=1
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage_Type"]["Spell"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_DAMAGE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=1
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage_Type"]["Environmental"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["ENVIRONMENTAL_DAMAGE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[1],
			type=1
			}
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage_Type"]["Dot"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_PERIODIC_DAMAGE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=1
			}
	end
	
	--heal
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal_Type"]["Heal"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_HEAL"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[5],
			type=2 --2=heal
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal_Type"]["Hot"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_PERIODIC_HEAL"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[5],
			type=2
			}
	end

	--misc
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["DamageMiss"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SWING_MISSED"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[1],
			type=3 --3= misc
			}
		NPA_ScrollText_Out_CombatLogFilter["RANGE_MISSED"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["DamageShieldMiss"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["DAMAGE_SHIELD_MISSED"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["SpellMiss"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_MISSED"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=3
			}
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["DispelMiss"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_DISPEL_FAILED"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[2],
			type=3
			}
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["Interrupt"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_INTERRUPT"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[6],
			type=3
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["Stolen"]==1)then	
		NPA_ScrollText_Out_CombatLogFilter["SPELL_STOLEN"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[6],
			type=3
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["Dispel"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_AURA_BROKEN"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[8],
			type=3
			}
		NPA_ScrollText_Out_CombatLogFilter["SPELL_AURA_BROKEN_SPELL"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[8],
			type=3
			}
		NPA_ScrollText_Out_CombatLogFilter["SPELL_DISPEL"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[6],
			type=3
			}
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["AuraGain"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_AURA_APPLIED"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[3],
			type=3
			}
		NPA_ScrollText_Out_CombatLogFilter["SPELL_AURA_APPLIED_DOSE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[3],
			type=3
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["AuraLost"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_AURA_REMOVED"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[4],
			type=3
			}
		NPA_ScrollText_Out_CombatLogFilter["SPELL_AURA_REMOVED_DOSE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[4],
			type=3
			}
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc_Type"]["Energized"]==1)then
		NPA_ScrollText_Out_CombatLogFilter["SPELL_ENERGIZE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[7],
			type=3
			}
		NPA_ScrollText_Out_CombatLogFilter["SPELL_PERIODIC_ENERGIZE"]={
			func=NPA_ScrollText_Out_CombatEventFunctions[7],
			type=3
			}
	end

	
	-----------flying icon
	NPA_ScrollText_FlyingIconFilter={}

	if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Enabled"]==1)then
		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_InstantCast"]==1)then
			NPA_ScrollText_FlyingIconFilter["SPELL_CAST_SUCCESS"]=1
		end
	
		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Melee"]==1)then
			NPA_ScrollText_FlyingIconFilter["SWING_DAMAGE"]=2
		end

		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Range"]==1)then
			NPA_ScrollText_FlyingIconFilter["RANGE_DAMAGE"]=1
		end

		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Spell"]==1)then
			NPA_ScrollText_FlyingIconFilter["DAMAGE_SHIELD"]=1
			NPA_ScrollText_FlyingIconFilter["DAMAGE_SPLIT"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_DAMAGE"]=1
			NPA_ScrollText_FlyingIconFilter["ENVIRONMENTAL_DAMAGE"]=1		
		end
	
		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Dot"]==1)then
			NPA_ScrollText_FlyingIconFilter["SPELL_PERIODIC_DAMAGE"]=1
		end
	

		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Miss"]==1)then
			NPA_ScrollText_FlyingIconFilter["SWING_MISSED"]=1
			NPA_ScrollText_FlyingIconFilter["RANGE_MISSED"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_MISSED"]=1
			NPA_ScrollText_FlyingIconFilter["DAMAGE_SHIELD_MISSED"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_DISPEL_FAILED"]=1
		end
	
	
		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Interrupt"]==1)then
			NPA_ScrollText_FlyingIconFilter["SPELL_INTERRUPT"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_DISPEL"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_STOLEN"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_AURA_BROKEN"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_AURA_BROKEN_SPELL"]=1
		end
	
		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Aura"]==1)then
			NPA_ScrollText_FlyingIconFilter["SPELL_AURA_APPLIED"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_AURA_APPLIED_DOSE"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_AURA_REMOVED"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_AURA_REMOVED_DOSE"]=1
		end
		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Heal"]==1)then
			NPA_ScrollText_FlyingIconFilter["SPELL_HEAL"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_PERIODIC_HEAL"]=1
		end

		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Energized"]==1)then
			NPA_ScrollText_FlyingIconFilter["SPELL_ENERGIZE"]=1
			NPA_ScrollText_FlyingIconFilter["SPELL_PERIODIC_ENERGIZE"]=1
		end

	end


	---on event filters
	--In filters
	--dest filters
	NPA_ScrollText_OnEventFilterDest={
		[1]={},
		[2]={},
		[3]={},
	}
	--------------------------------------------------
	--1=damage
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowToHostile"]==1)then
		NPA_ScrollText_OnEventFilterDest[1]["ShowToHostile"]=NPA_ScrollText_OnEventFilterData["ShowToHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowToNonHostile"]==1)then
		NPA_ScrollText_OnEventFilterDest[1]["ShowToNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowToNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowToFocus"]==1)then
		NPA_ScrollText_OnEventFilterDest[1]["ShowToFocus"]=NPA_ScrollText_OnEventFilterData["ShowToFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowToTarget"]==1)then
		NPA_ScrollText_OnEventFilterDest[1]["ShowToTarget"]=NPA_ScrollText_OnEventFilterData["ShowToTarget"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowToSelf"]==1)then
		NPA_ScrollText_OnEventFilterDest[1]["ShowToSelf"]=NPA_ScrollText_OnEventFilterData["ShowToSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowToPet"]==1)then
		NPA_ScrollText_OnEventFilterDest[1]["ShowToPet"]=NPA_ScrollText_OnEventFilterData["ShowToPet"]
	end
	--2=heal
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowToHostile"]==1)then
		NPA_ScrollText_OnEventFilterDest[2]["ShowToHostile"]=NPA_ScrollText_OnEventFilterData["ShowToHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowToNonHostile"]==1)then
		NPA_ScrollText_OnEventFilterDest[2]["ShowToNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowToNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowToFocus"]==1)then
		NPA_ScrollText_OnEventFilterDest[2]["ShowToFocus"]=NPA_ScrollText_OnEventFilterData["ShowToFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowToTarget"]==1)then
		NPA_ScrollText_OnEventFilterDest[2]["ShowToTarget"]=NPA_ScrollText_OnEventFilterData["ShowToTarget"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowToSelf"]==1)then
		NPA_ScrollText_OnEventFilterDest[2]["ShowToSelf"]=NPA_ScrollText_OnEventFilterData["ShowToSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowToPet"]==1)then
		NPA_ScrollText_OnEventFilterDest[2]["ShowToPet"]=NPA_ScrollText_OnEventFilterData["ShowToPet"]
	end
	--3=misc
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowToHostile"]==1)then
		NPA_ScrollText_OnEventFilterDest[3]["ShowToHostile"]=NPA_ScrollText_OnEventFilterData["ShowToHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowToNonHostile"]==1)then
		NPA_ScrollText_OnEventFilterDest[3]["ShowToNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowToNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowToFocus"]==1)then
		NPA_ScrollText_OnEventFilterDest[3]["ShowToFocus"]=NPA_ScrollText_OnEventFilterData["ShowToFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowToTarget"]==1)then
		NPA_ScrollText_OnEventFilterDest[3]["ShowToTarget"]=NPA_ScrollText_OnEventFilterData["ShowToTarget"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowToSelf"]==1)then
		NPA_ScrollText_OnEventFilterDest[3]["ShowToSelf"]=NPA_ScrollText_OnEventFilterData["ShowToSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowToPet"]==1)then
		NPA_ScrollText_OnEventFilterDest[3]["ShowToPet"]=NPA_ScrollText_OnEventFilterData["ShowToPet"]
	end
	----------------------------------
	--source filters
	NPA_ScrollText_OnEventFilterFrom={
		[1]={},
		[2]={},
		[3]={},
	}
	--1=damage
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowFromHostile"]==1)then
		NPA_ScrollText_OnEventFilterFrom[1]["ShowFromHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromHostile"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowFromNonHostile"]==1)then
		NPA_ScrollText_OnEventFilterFrom[1]["ShowFromNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowFromSelf"]==1)then
		NPA_ScrollText_OnEventFilterFrom[1]["ShowFromSelf"]=NPA_ScrollText_OnEventFilterData["ShowFromSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowFromPet"]==1)then
		NPA_ScrollText_OnEventFilterFrom[1]["ShowFromPet"]=NPA_ScrollText_OnEventFilterData["ShowFromPet"]
	end


	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowFromFocus"]==1)then
		NPA_ScrollText_OnEventFilterFrom[1]["ShowFromFocus"]=NPA_ScrollText_OnEventFilterData["ShowFromFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Damage"]["ShowFromTarget"]==1)then
		NPA_ScrollText_OnEventFilterFrom[1]["ShowFromTarget"]=NPA_ScrollText_OnEventFilterData["ShowFromTarget"]
	end
	--2=heal
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowFromHostile"]==1)then
		NPA_ScrollText_OnEventFilterFrom[2]["ShowFromHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowFromNonHostile"]==1)then
		NPA_ScrollText_OnEventFilterFrom[2]["ShowFromNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowFromSelf"]==1)then
		NPA_ScrollText_OnEventFilterFrom[2]["ShowFromSelf"]=NPA_ScrollText_OnEventFilterData["ShowFromSelf"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowFromPet"]==1)then
		NPA_ScrollText_OnEventFilterFrom[2]["ShowFromPet"]=NPA_ScrollText_OnEventFilterData["ShowFromPet"]
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowFromFocus"]==1)then
		NPA_ScrollText_OnEventFilterFrom[2]["ShowFromFocus"]=NPA_ScrollText_OnEventFilterData["ShowFromFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Heal"]["ShowFromTarget"]==1)then
		NPA_ScrollText_OnEventFilterFrom[2]["ShowFromTarget"]=NPA_ScrollText_OnEventFilterData["ShowFromTarget"]
	end
	--3=misc
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowFromHostile"]==1)then
		NPA_ScrollText_OnEventFilterFrom[3]["ShowFromHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowFromNonHostile"]==1)then
		NPA_ScrollText_OnEventFilterFrom[3]["ShowFromNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowFromSelf"]==1)then
		NPA_ScrollText_OnEventFilterFrom[3]["ShowFromSelf"]=NPA_ScrollText_OnEventFilterData["ShowFromSelf"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowFromPet"]==1)then
		NPA_ScrollText_OnEventFilterFrom[3]["ShowFromPet"]=NPA_ScrollText_OnEventFilterData["ShowFromPet"]
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowFromFocus"]==1)then
		NPA_ScrollText_OnEventFilterFrom[3]["ShowFromFocus"]=NPA_ScrollText_OnEventFilterData["ShowFromFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_In_Misc"]["ShowFromTarget"]==1)then
		NPA_ScrollText_OnEventFilterFrom[3]["ShowFromTarget"]=NPA_ScrollText_OnEventFilterData["ShowFromTarget"]
	end

	----------out filter
	--dest filters
	NPA_ScrollText_Out_OnEventFilterDest={
		[1]={},
		[2]={},
		[3]={},
	}
	--------------------------------------------------
	--1=damage
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowToHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[1]["ShowToHostile"]=NPA_ScrollText_OnEventFilterData["ShowToHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowToNonHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[1]["ShowToNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowToNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowToFocus"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[1]["ShowToFocus"]=NPA_ScrollText_OnEventFilterData["ShowToFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowToTarget"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[1]["ShowToTarget"]=NPA_ScrollText_OnEventFilterData["ShowToTarget"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowToSelf"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[1]["ShowToSelf"]=NPA_ScrollText_OnEventFilterData["ShowToSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowToPet"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[1]["ShowToPet"]=NPA_ScrollText_OnEventFilterData["ShowToPet"]
	end
	--2=heal
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowToHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[2]["ShowToHostile"]=NPA_ScrollText_OnEventFilterData["ShowToHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowToNonHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[2]["ShowToNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowToNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowToFocus"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[2]["ShowToFocus"]=NPA_ScrollText_OnEventFilterData["ShowToFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowToTarget"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[2]["ShowToTarget"]=NPA_ScrollText_OnEventFilterData["ShowToTarget"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowToSelf"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[2]["ShowToSelf"]=NPA_ScrollText_OnEventFilterData["ShowToSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowToPet"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[2]["ShowToPet"]=NPA_ScrollText_OnEventFilterData["ShowToPet"]
	end
	--3=misc
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowToHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[3]["ShowToHostile"]=NPA_ScrollText_OnEventFilterData["ShowToHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowToNonHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[3]["ShowToNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowToNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowToFocus"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[3]["ShowToFocus"]=NPA_ScrollText_OnEventFilterData["ShowToFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowToTarget"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[3]["ShowToTarget"]=NPA_ScrollText_OnEventFilterData["ShowToTarget"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowToSelf"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[3]["ShowToSelf"]=NPA_ScrollText_OnEventFilterData["ShowToSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowToPet"]==1)then
		NPA_ScrollText_Out_OnEventFilterDest[3]["ShowToPet"]=NPA_ScrollText_OnEventFilterData["ShowToPet"]
	end
	----------------------------------
	--source filters
	NPA_ScrollText_Out_OnEventFilterFrom={
		[1]={},
		[2]={},
		[3]={},
	}
	--1=damage
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowFromHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[1]["ShowFromHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromHostile"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowFromNonHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[1]["ShowFromNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowFromSelf"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[1]["ShowFromSelf"]=NPA_ScrollText_OnEventFilterData["ShowFromSelf"]
	end
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowFromPet"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[1]["ShowFromPet"]=NPA_ScrollText_OnEventFilterData["ShowFromPet"]
	end


	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowFromFocus"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[1]["ShowFromFocus"]=NPA_ScrollText_OnEventFilterData["ShowFromFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Damage"]["ShowFromTarget"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[1]["ShowFromTarget"]=NPA_ScrollText_OnEventFilterData["ShowFromTarget"]
	end
	--2=heal
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowFromHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[2]["ShowFromHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowFromNonHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[2]["ShowFromNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowFromSelf"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[2]["ShowFromSelf"]=NPA_ScrollText_OnEventFilterData["ShowFromSelf"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowFromPet"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[2]["ShowFromPet"]=NPA_ScrollText_OnEventFilterData["ShowFromPet"]
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowFromFocus"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[2]["ShowFromFocus"]=NPA_ScrollText_OnEventFilterData["ShowFromFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Heal"]["ShowFromTarget"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[2]["ShowFromTarget"]=NPA_ScrollText_OnEventFilterData["ShowFromTarget"]
	end
	--3=misc
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowFromHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[3]["ShowFromHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowFromNonHostile"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[3]["ShowFromNonHostile"]=NPA_ScrollText_OnEventFilterData["ShowFromNonHostile"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowFromSelf"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[3]["ShowFromSelf"]=NPA_ScrollText_OnEventFilterData["ShowFromSelf"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowFromPet"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[3]["ShowFromPet"]=NPA_ScrollText_OnEventFilterData["ShowFromPet"]
	end
	
	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowFromFocus"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[3]["ShowFromFocus"]=NPA_ScrollText_OnEventFilterData["ShowFromFocus"]
	end

	if(NPA_ScrollText_Config["ScrollText_Filter_Out_Misc"]["ShowFromTarget"]==1)then
		NPA_ScrollText_Out_OnEventFilterFrom[3]["ShowFromTarget"]=NPA_ScrollText_OnEventFilterData["ShowFromTarget"]
	end


	-- -------------------------------
	--on event func
	NPA_ScrollText_OnEventFunc={}
	if(NPA_ScrollText_Config["ScrollText_Enabled"]==1)then
		NPA_ScrollText_OnEventFunc["In"]=function(uarg,targetguid,focusguid,myguid,petguid)
			local eventdata=NPA_ScrollText_CombatLogFilter[uarg[2]]
			if(eventdata)then
				local eventtype=eventdata.type
			
				local desthostile=bit_band(uarg[8],COMBATLOG_OBJECT_REACTION_HOSTILE)
				local show
				for _,func in pairs(NPA_ScrollText_OnEventFilterDest[eventtype])do
					if(func(desthostile,uarg[6],targetguid,focusguid,myguid)==1)then
						show=1
						break
					end
				end
				if(show)then
						show=nil
						local sourcehostile=bit_band(uarg[5],COMBATLOG_OBJECT_REACTION_HOSTILE)
						for _,func in pairs(NPA_ScrollText_OnEventFilterFrom[eventtype])do
							if(func(sourcehostile,uarg[3],targetguid,focusguid,myguid,petguid)==1)then
								show=1
							break
						end
					end
					if(show)then
						local name
						if(NPA_ScrollText_Config["ScrollText_Filter_ShowSelf"]==1 and (uarg[3]==myguid or uarg[3]==petguid))then
							name=" |cffff0000<=="
						elseif(NPA_ScrollText_Config["ScrollText_Filter_ShowCaster"]==1)then
							if(not uarg[4])then
								name="("..Localization["Unknow"]..")"
							else
								name="("..uarg[4]..")"
							end
						else
							name=""
						end	

						eventdata.func(name,uarg)
					end
				end
			end
		end
	end

	if(NPA_ScrollText_Config["ScrollText_Out_Enabled"]==1)then
		NPA_ScrollText_OnEventFunc["Out"]=function(uarg,targetguid,focusguid,myguid,petguid)
			local eventdata=NPA_ScrollText_Out_CombatLogFilter[uarg[2]]
			if(eventdata)then
				local eventtype=eventdata.type
				local show
				local sourcehostile=bit_band(uarg[5],COMBATLOG_OBJECT_REACTION_HOSTILE)

				for _,func in pairs(NPA_ScrollText_Out_OnEventFilterFrom[eventtype])do
					if(func(sourcehostile,uarg[3],targetguid,focusguid,myguid)==1)then
						show=1
						break
					end
				end
				if(show)then
						show=nil
						local desthostile=bit_band(uarg[8],COMBATLOG_OBJECT_REACTION_HOSTILE)
						for _,func in pairs(NPA_ScrollText_Out_OnEventFilterDest[eventtype])do
						if(func(desthostile,uarg[6],targetguid,focusguid,myguid,petguid)==1)then
							show=1
							break
						end
					end
					if(show)then
						local name
						if(NPA_ScrollText_Config["ScrollText_Out_Filter_ShowSelf"]==1 and (uarg[6]==myguid or uarg[6]==petguid))then
							name=" |cffff0000<=="
						elseif(NPA_ScrollText_Config["ScrollText_Out_Filter_ShowCaster"]==1)then
							if(not uarg[7])then
								name="("..Localization["Unknow"]..")"
							else
								name="("..uarg[7]..")"
							end
						else
							name=""
						end	

						eventdata.func(name,uarg)
					end
				end
			end
		end
	end
end



local abs=abs
	
local function NPA_ScrollText_ScrollOnUpdate(self,elapsed)
	self.TimeStack=self.TimeStack+elapsed
	if(self.TimeStack<NPA_ScrollText_Config["ScrollText_UpdateInterval"])then
		return
	end

	local nTime=GetTime()
	local frame=GUIDToFrame[self.GUID]
	local show
	if(frame and frame:IsShown())then
		show=1
	end
	if(self.Life > 0 and (show or self.HideByFrame~=1))then
		local modalpha=1
		local scale=UIParent:GetScale()
		if(show)then
			local ox,oy=frame:GetCenter()
			if(frame.IsTracker)then
				self.OffsetX=(ox or 0)*scale
				self.OffsetY=(oy or 0)*scale
			else
				self.OffsetX=(ox or 0)
				self.OffsetY=(oy or 0)
			end
			if(self.AlphaByFrame==1)then
				modalpha=frame.ModuleMain:GetAlpha() or 1
			end
		end

		local step = self.TimeStack

		
		local alpha=(self.Life+0.1) / self.MaxLife * modalpha
		self:SetAlpha(alpha)

		self.X=self.X + self.StepX * step
		self.Y=self.Y + self.StepY * step
		self.StepY=self.StepY+self.AccY*step
		self.StepX=self.StepX+self.AccX*step


		if(self.Crit==1)then
			if(self.StickCrit==1)then
				local sx=self.StepX
				local sy=self.StepY
				if(abs(sx)>0.1)then
					sx=sx*0.8
				else
					sx=0
				end
				if(abs(sy)>0.1)then
					sy=sy*0.8
				else
					sy=0
				end
				self.StepX=sx
				self.StepY=sy
			end
			if(self.ShakeCrit==1)then
				local shakex=self.X+(random()-0.5)*2
				local shakey=self.Y+(random()-0.5)*2

				self:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",(self.OffsetX+self.X+shakex)/scale,(self.OffsetY+self.Y+shakey)/scale)
			else
				self:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",(self.OffsetX+self.X)/scale,(self.OffsetY+self.Y)/scale)
			end
		else
			self:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",(self.OffsetX+self.X)/scale,(self.OffsetY+self.Y)/scale)
		end

		self.Life = self.Life - step
	else
		self:Hide()
	end

	self.TimeStack=0
end
local function NPA_ScrollText_IconOnUpdate(self,elapsed)
	self.TimeStack=self.TimeStack+elapsed
	if(self.TimeStack<NPA_ScrollText_Config["ScrollText_UpdateInterval"])then
		return
	end

	local nTime=GetTime()
	local frame=GUIDToFrame[self.GUID]
	local show
	if(frame and frame:IsShown())then
		show=1
	end
	if((show or NPA_ScrollText_Config["ScrollText_FlyingIcon_HideByFrame"]~=1) and
		(abs(self.X-self.TargetX)>15 or abs(self.Y-self.TargetY)>15))then
		local modalpha=1
		local scale=UIParent:GetScale()
		if(show)then
			local tx,ty=frame:GetCenter()
			tx=tx or 0
			ty=ty or 0
			if(frame.IsTracker)then
				tx=tx*scale
				ty=ty*scale
			end
			self.TargetX=tx
			self.TargetY=ty

			if(NPA_ScrollText_Config["ScrollText_FlyingIcon_AlphaByFrame"]==1)then
				modalpha=frame.ModuleMain:GetAlpha() or 1
			end
		end

		self:SetAlpha(modalpha)

		self.X=self.X + (self.TargetX-self.X)/8
		self.Y=self.Y + (self.TargetY-self.Y)/8

		self:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",self.X/scale,self.Y/scale)

	else
		self:Hide()
	end

	self.TimeStack=0
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_ScrollText_SetScroll(frame)
	frame:Hide()
	ManageFont(nil,frame.Text,NPA_ScrollText_Config["ScrollText_TextData"],frame)

	ManageFont(nil,frame.CritText,NPA_ScrollText_Config["ScrollText_CritTextData"],frame)

	ManageTexture(nil,frame.Icon,NPA_ScrollText_Config["ScrollText_IconData"],frame)
	ManageTexture(nil,frame.Overlay,NPA_ScrollText_Config["ScrollText_OverlayData"],frame.Icon)
	ManageTexture(nil,frame.Background,NPA_ScrollText_Config["ScrollText_BackgroundData"],frame.Icon)
	
	ManageTexture(nil,frame.CritIcon,NPA_ScrollText_Config["ScrollText_CritIconData"],frame)
	ManageTexture(nil,frame.CritOverlay,NPA_ScrollText_Config["ScrollText_CritOverlayData"],frame.CritIcon)
	ManageTexture(nil,frame.CritBackground,NPA_ScrollText_Config["ScrollText_CritBackgroundData"],frame.CritIcon)
end

local function NPA_ScrollText_Out_SetScroll(frame)
	frame:Hide()
	ManageFont(nil,frame.Text,NPA_ScrollText_Config["ScrollText_Out_TextData"],frame)

	ManageFont(nil,frame.CritText,NPA_ScrollText_Config["ScrollText_Out_CritTextData"],frame)

	ManageTexture(nil,frame.Icon,NPA_ScrollText_Config["ScrollText_Out_IconData"],frame)
	ManageTexture(nil,frame.Overlay,NPA_ScrollText_Config["ScrollText_Out_OverlayData"],frame.Icon)
	ManageTexture(nil,frame.Background,NPA_ScrollText_Config["ScrollText_Out_BackgroundData"],frame.Icon)
	
	ManageTexture(nil,frame.CritIcon,NPA_ScrollText_Config["ScrollText_Out_CritIconData"],frame)
	ManageTexture(nil,frame.CritOverlay,NPA_ScrollText_Config["ScrollText_Out_CritOverlayData"],frame.CritIcon)
	ManageTexture(nil,frame.CritBackground,NPA_ScrollText_Config["ScrollText_Out_CritBackgroundData"],frame.CritIcon)
end

local function NPA_ScrollText_SetIcon(frame)
	frame:Hide()
	ManageTexture(nil,frame.Icon,NPA_ScrollText_Config["ScrollText_FlyingIcon_IconData"],frame)
	ManageTexture(nil,frame.Overlay,NPA_ScrollText_Config["ScrollText_FlyingIcon_OverlayData"],frame)
	ManageTexture(nil,frame.Background,NPA_ScrollText_Config["ScrollText_FlyingIcon_BackgroundData"],frame)
end

local function NPA_ScrollText_CreateIcon()
	local frame=CreateFrame("Frame","NPA_ScrollText_FlyingIconFrame",NPA_MainFrame)
	frame:SetScript("OnUpdate",NPA_ScrollText_IconOnUpdate)
	frame:SetHeight(1)
	frame:SetWidth(1)
	frame:Hide()
	frame.Icon=frame:CreateTexture(nil,"ARTWORK")
	frame.Overlay=frame:CreateTexture(nil,"OVERLAY")
	frame.Background=frame:CreateTexture(nil,"BACKGROUND")

	frame.TimeStack=0
	return frame
end

local function NPA_ScrollText_CreateScroll()
	local frame=CreateFrame("Frame","NPA_ScrollText_ScrollFrame",NPA_MainFrame)
	frame:SetHeight(1)
	frame:SetWidth(1)
	frame:Hide()

	frame.Text=frame:CreateFontString("NPA_ScrollText_Text","OVERLAY",nil)
	frame.Text:Show()

	frame.CritText=frame:CreateFontString("NPA_ScrollText_CritText","OVERLAY",nil)
	frame.CritText:Show()

	frame.Icon=frame:CreateTexture("NPA_ScrollText_Icon","ARTWORK",nil)
	frame.Icon:Show()

	frame.Overlay=frame:CreateTexture("NPA_ScrollText_Overlay","OVERLAY",nil)
	frame.Overlay:Show()

	frame.Background=frame:CreateTexture("NPA_ScrollText_Background","BACKGROUND",nil)
	frame.Background:Show()
	
	frame.CritIcon=frame:CreateTexture("NPA_ScrollText_CritIcon","ARTWORK",nil)
	frame.CritIcon:Show()

	frame.CritOverlay=frame:CreateTexture("NPA_ScrollText_CritOverlay","OVERLAY",nil)
	frame.CritOverlay:Show()

	frame.CritBackground=frame:CreateTexture("NPA_ScrollText_CritBackground","BACKGROUND",nil)
	frame.CritBackground:Show()

	frame.TimeStack=0
	
	frame:SetScript("OnUpdate",NPA_ScrollText_ScrollOnUpdate)

	return frame
end


local function NPA_ScrollText_OnEvent(uarg)
--               2             3          4       5    6         7      8      9     10   11   12   13   14   15   16   17    18                            
--_,event,_,combatevent ,sourceGUID, sourceName, flag, destGUID,name,destFlags,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)


	--timestamp , event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, 1spellID,2spellName,3spellSchool, 4amount, 5overkill,6 school, 7risisted, 8blocked, 9absorbed, 10critical, 11glancing,12 crushing
	--timestamp , event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, 1amount, 2overkill, 3school, 4risisted, 5blocked, 6absorbed, 7cricital, 8glancing, 9crushing

	local flyingiconfilter=NPA_ScrollText_FlyingIconFilter[uarg[2]]
	if(flyingiconfilter)then
		NPA_ScrollText_AddIcon(uarg[3],uarg[6],uarg[9],flyingiconfilter)
	end


	local focusguid=UnitGUID("focus") or -1
	local targetguid=UnitGUID("target") or -2
	local myguid=UnitGUID("player") or 0
	local petguid=UnitGUID("playerpet") or -3
	for _,func in pairs(NPA_ScrollText_OnEventFunc) do
			func(uarg,targetguid,focusguid,myguid,petguid)
	end
end



function NPA_ScrollText:Test()
	if(NPA_ScrollText_Config["ScrollText_Enabled"]==1)then
		local crit,text
		if(random()>0.5)then
			crit=1
			text="(crit)"
		else
			crit=nil
			text="(normal)"
		end

		--(guid,spellid,text,spelltype,large,extratype)

		NPA_ScrollText_AddScroll(-100,33763,floor(random()*1000)..text,1,crit)
	end

	if(NPA_ScrollText_Config["ScrollText_Out_Enabled"]==1)then
		if(random()>0.5)then
			crit=1
			text="(crit)"
		else
			crit=nil
			text="(normal)"
		end

		NPA_ScrollText_Out_AddScroll(-100,33763,floor(random()*1000)..text,1,crit)
	end
end

function NPA_ScrollText:ApplyConfig()
	NPA_Core:CheckConfigEntry("ScrollText",NPA_ScrollText_DefaultSetting)

	NPA_ScrollText_Config=NPA_Config["ScrollText"]

	NPA_ScrollText_BuildFilter()
	
	NPA_ScrollText_Template={}

	NPA_ScrollText_Out_Template={}

	if(NPA_Config["Core"]["EnableModule"]["ScrollText"]==1 and 
		(NPA_ScrollText_Config["ScrollText_Enabled"]==1 or NPA_ScrollText_Config["ScrollText_Out_Enabled"]==1 or NPA_ScrollText_Config["ScrollText_FlyingIcon_Enabled"]==1))then
		if(NPA_ScrollText_Config["ScrollText_Enabled"]==1)then
			NPA_ScrollText_Max=NPA_ScrollText_Config["ScrollText_Max"]

			NPA_ScrollText_Template.X=NPA_ScrollText_Config["ScrollText_OffsetX"]
			NPA_ScrollText_Template.Y=NPA_ScrollText_Config["ScrollText_OffsetY"]
			NPA_ScrollText_Template.AccX=NPA_ScrollText_Config["ScrollText_AccX"]
			NPA_ScrollText_Template.AccY=NPA_ScrollText_Config["ScrollText_AccY"]
			NPA_ScrollText_Template.Life=NPA_ScrollText_Config["ScrollText_Life"]
			NPA_ScrollText_Template.MaxLife=NPA_ScrollText_Config["ScrollText_Life"]
			NPA_ScrollText_Template.StickCrit=NPA_ScrollText_Config["ScrollText_Filter_StickCrit"]
			NPA_ScrollText_Template.ShakeCrit=NPA_ScrollText_Config["ScrollText_Filter_ShakeCrit"]
			NPA_ScrollText_Template.HideByFrame=NPA_ScrollText_Config["ScrollText_Filter_HideByFrame"]
			NPA_ScrollText_Template.AlphaByFrame=NPA_ScrollText_Config["ScrollText_Filter_AlphaByFrame"]

			for i=1,NPA_ScrollText_Max do
				if(not NPA_ScrollText_Scrolls[i])then
					NPA_ScrollText_Scrolls[i]=NPA_ScrollText_CreateScroll()
				end
				NPA_ScrollText_SetScroll(NPA_ScrollText_Scrolls[i])
			end

		else
			NPA_ScrollText_Max=0	
		end
		if(NPA_ScrollText_Config["ScrollText_Out_Enabled"]==1)then
			NPA_ScrollText_Out_Max=NPA_ScrollText_Config["ScrollText_Out_Max"]

			NPA_ScrollText_Out_Template.X=NPA_ScrollText_Config["ScrollText_Out_OffsetX"]
			NPA_ScrollText_Out_Template.Y=NPA_ScrollText_Config["ScrollText_Out_OffsetY"]
			NPA_ScrollText_Out_Template.AccX=NPA_ScrollText_Config["ScrollText_Out_AccX"]
			NPA_ScrollText_Out_Template.AccY=NPA_ScrollText_Config["ScrollText_Out_AccY"]
			NPA_ScrollText_Out_Template.Life=NPA_ScrollText_Config["ScrollText_Out_Life"]
			NPA_ScrollText_Out_Template.MaxLife=NPA_ScrollText_Config["ScrollText_Out_Life"]
			NPA_ScrollText_Out_Template.StickCrit=NPA_ScrollText_Config["ScrollText_Out_Filter_StickCrit"]
			NPA_ScrollText_Out_Template.ShakeCrit=NPA_ScrollText_Config["ScrollText_Out_Filter_ShakeCrit"]
			NPA_ScrollText_Out_Template.HideByFrame=NPA_ScrollText_Config["ScrollText_Out_Filter_HideByFrame"]
			NPA_ScrollText_Out_Template.AlphaByFrame=NPA_ScrollText_Config["ScrollText_Out_Filter_AlphaByFrame"]

			for i=1,NPA_ScrollText_Out_Max do
				if(not NPA_ScrollText_Out_Scrolls[i])then
					NPA_ScrollText_Out_Scrolls[i]=NPA_ScrollText_CreateScroll()
				end
				NPA_ScrollText_Out_SetScroll(NPA_ScrollText_Out_Scrolls[i])
			end
		else
			NPA_ScrollText_Out_Max=0
		end

		if(NPA_ScrollText_Config["ScrollText_FlyingIcon_Enabled"]==1)then
			NPA_ScrollText_FlyingIcon_Max=NPA_ScrollText_Config["ScrollText_FlyingIcon_Max"]

			for i=1,NPA_ScrollText_FlyingIcon_Max do
				if(not NPA_ScrollText_Icons[i])then
					NPA_ScrollText_Icons[i]=NPA_ScrollText_CreateIcon()
				end
				NPA_ScrollText_SetIcon(NPA_ScrollText_Icons[i])
			end
		else
			NPA_ScrollText_FlyingIcon_Max=0
		end

		NPA_Core.CombatEventFunc["ScrollText"]=NPA_ScrollText_OnEvent
	else
		NPA_Core.CombatEventFunc["ScrollText"]=nil
	end

end

NPA_Core:AddModule("ScrollText",NPA_ScrollText)