﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime


local COMBATLOG_OBJECT_TYPE_PLAYER=COMBATLOG_OBJECT_TYPE_PLAYER
local COMBATLOG_OBJECT_TYPE_PET=COMBATLOG_OBJECT_TYPE_PET
local bit_band=bit.band
local tostring=tostring
local floor=floor

local NPA_RoleCheck={}
--config
local NPA_RoleCheck_DefaultSetting={
		["RoleCheck_OffsetX"]=85,
		["RoleCheck_OffsetY"]=-22,

		["RoleCheck_ShowText"]=1,
		["RoleCheck_ShowTotal"]=1,
		["RoleCheck_ShowPerSecond"]=0,
		["RoleCheck_BreakLongNumber"]=1,
		["RoleCheck_ShortLongNumber"]=1,
		["RoleCheck_ShowPercent"]=1,

		["RoleCheck_ShowBar"]=0,
		["RoleCheck_AlwaysShowIcon"]=0,

		["RoleCheck_ShowHealerBar"]=1,
		["RoleCheck_ShowTankBar"]=1,
		["RoleCheck_ShowDamagerBar"]=1,
		["RoleCheck_OnlyBestBar"]=1,
		["RoleCheck_ShowHealerIcon"]=1,
		["RoleCheck_ShowDamagerIcon"]=1,
		["RoleCheck_ShowTankIcon"]=1,

		["RoleCheck_TotalAsMax"]=0,
		["RoleCheck_OnlyEffective"]=0,
		["RoleCheck_UseBattleFieldScore"]=1,
		["RoleCheck_ResetWhenCombat"]=1,
		["RoleCheck_StopWhenOutCombat"]=1,

		["RoleCheck_OnlyBattleground"]=1,
		["RoleCheck_DontFade"]=0,

		["RoleCheck_HealerBarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=18,
			Width=56,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RoleCheck_HealerOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=60,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["RoleCheck_HealerBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=55,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["RoleCheck_HealerTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RoleCheck_DamagerBarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=18,
			Width=56,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RoleCheck_DamagerOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=60,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["RoleCheck_DamagerBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=55,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["RoleCheck_DamagerTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RoleCheck_TankBarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=18,
			Width=56,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RoleCheck_TankOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=60,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["RoleCheck_TankBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=55,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["RoleCheck_TankTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["RoleCheck_HealerData"]={
			OffsetX=-60,
			OffsetY=20,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\healer",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RoleCheck_DamagerData"]={
			OffsetX=-60,
			OffsetY=20,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\damager",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RoleCheck_TankData"]={
			OffsetX=-60,
			OffsetY=20,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\tank",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	

	}
local NPA_RoleCheck_Config=NPA_RoleCheck_DefaultSetting

function NPA_RoleCheck:ResetConfig()
	NPA_Config["RoleCheck"]=CopyTable(NPA_RoleCheck_DefaultSetting)
end


--global function
local NPA_RoleCheck_Frame={}
local table_insert=table.insert
local tonumber=tonumber

local ManageBar=NPA_Core.ManageBar

local NPA_RoleCheck_DamageCount={}
local NPA_RoleCheck_HealCount={}
local NPA_RoleCheck_TankCount={}

local NPA_RoleCheck_DamageMax=1
local NPA_RoleCheck_HealMax=1

local NPA_RoleCheck_BattleFieldScore={}

local NPA_RoleCheck_NameToGUID={}

local NPA_RoleCheck_StartTime=1

local function NPA_RoleCheck_ShortNumber(value)
	local ret
	local short=floor(value/100000000)/10
	if(short>1)then
		return (short).."g"
	else
		short=floor(value/100000)/10
		if(short>1)then
			return (short).."m"
		else
			short=floor(value/100)/10
			if(short>1)then
				return (short).."k"
			else
				return value
			end
		end
	end
end

local function NPA_RoleCheck_BreakNumber(value)
	local str=""
	
	local bre=floor(value/1000000000)
	if(bre>0)then
		value=value-bre*1000000000
		str=bre..","
	end
	bre=floor(value/1000000)
	if(bre>0)then
		value=value-bre*1000000
		str=str..bre..","
	end
	bre=floor(value/1000)
	if(bre>0)then
		value=value-bre*1000
		str=str..bre..","
	end
	str=str..value

	return str
end

local function NPA_RoleCheck_SetDisplay(nTime,text,bar,background,overlay,
			showtext,amount,max)
	if(max<amount)then
		max=amount
	end

	local show
	
	-------bar
	bar:Show()
	background:Show()
	overlay:Show()

	bar.Percent=amount/max
	ManageBar(nil,bar)
	show=1

	-----text
	if(showtext==1)then
		local str
		if(NPA_RoleCheck_Config["RoleCheck_ShowTotal"]==1)then
			local value=amount
			if(NPA_RoleCheck_Config["RoleCheck_ShortLongNumber"]==1)then
				value=NPA_RoleCheck_ShortNumber(value)
			elseif(NPA_RoleCheck_Config["RoleCheck_BreakLongNumber"]==1)then
				value=NPA_RoleCheck_BreakNumber(value)
			end
			str=tostring(value)
		end

		if(NPA_RoleCheck_Config["RoleCheck_ShowPerSecond"]==1)then
			local value=floor(amount/(nTime-NPA_RoleCheck_StartTime)*10)/10
			if(NPA_RoleCheck_Config["RoleCheck_ShortLongNumber"]==1)then
				value=NPA_RoleCheck_ShortNumber(value)
			elseif(NPA_RoleCheck_Config["RoleCheck_BreakLongNumber"]==1)then
				value=NPA_RoleCheck_BreakNumber(value)
			end
			if(str)then
				str=str.."("..tostring(value)..")"
			else
				str=tostring(value)
			end
		end
		
		if(NPA_RoleCheck_Config["RoleCheck_ShowPercent"]==1)then
			local value=floor(amount/max*100)
			if(str)then
				str=str.."("..tostring(value).."%)"
			else
				str=tostring(value).."%"
			end
		end

		if(str)then
			text:SetText(str)
			text:Show()
			show=1
		else
			text:Hide()
		end
	else
		text:Hide()
	end


	return show
end

		--nTime,main,guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed,isfriend,isguild,isparty,israid,isinstance,NPA_Core_IsInArena,NPA_Core_IsInBattleground
local function NPA_RoleCheck_OnUpdate(nTime,self,guid,_,_,_,_,_,isplayer,_,_,_,_,_,_,_,_,_,isinbattleground,ispet)
	if((not (isplayer==1)) and (not (ispet==1)))then
		return
	end
	if((not isinbattleground) and NPA_RoleCheck_Config["RoleCheck_OnlyBattleground"]==1)then
		self:Hide()
		return
	end

	local show
	local type
	local heal
	local damage
	local tank
	local totaldamage
	local totalheal


	if(isinbattleground and NPA_RoleCheck_Config["RoleCheck_UseBattleFieldScore"]==1)then
		local bgdata=NPA_RoleCheck_BattleFieldScore[guid]
		if(bgdata)then
			heal=bgdata.Heal or 0
			damage=bgdata.Damage or 0
		else
			heal=NPA_RoleCheck_HealCount[guid] or 0
			damage=NPA_RoleCheck_DamageCount[guid] or 0
		end
		totalheal=NPA_RoleCheck_BattleFieldScore["Total_Heal"] or 1
		totaldamage=NPA_RoleCheck_BattleFieldScore["Total_Damage"] or 1
		tank=0
	else
		heal=NPA_RoleCheck_HealCount[guid] or 0
		damage=NPA_RoleCheck_DamageCount[guid] or 0
		totaldamage=NPA_RoleCheck_DamageMax
		totalheal=NPA_RoleCheck_HealMax
		tank=NPA_RoleCheck_TankCount[guid] or 0
	end

	local totaltank=totaldamage*5
	tank=tank*5

	--healer
	if(heal>damage and heal>tank)then
		type=1
		
		self.Tank:Hide()
		self.Damager:Hide()
		if(NPA_RoleCheck_Config["RoleCheck_ShowHealerIcon"]==1)then
			self.Healer:Show()
			show=1
		else
			self.Healer:Hide()
		end
	else
		self.Healer:Hide()

		--------damager
		if(damage>heal and damage>tank)then
			type=2
			self.Tank:Hide()
			if(NPA_RoleCheck_Config["RoleCheck_ShowDamagerIcon"]==1)then
				self.Damager:Show()
				show=1
			else
				self.Damager:Hide()
			end
		else
			self.Damager:Hide()

			------tank
			if(tank>heal and tank>damage)then
				type=3
				if(NPA_RoleCheck_Config["RoleCheck_ShowTankIcon"]==1)then
					self.Tank:Show()
					show=1
				else
					self.Tank:Hide()
				end
			else
				self.Tank:Hide()
			end
		end
	end

	if(NPA_RoleCheck_Config["RoleCheck_ShowBar"]==1)then
		local showtext=NPA_RoleCheck_Config["RoleCheck_ShowText"]
		if(NPA_RoleCheck_Config["RoleCheck_OnlyBestBar"]==1)then
			if(type==1 and NPA_RoleCheck_Config["RoleCheck_ShowHealerBar"]==1)then
				show=NPA_RoleCheck_SetDisplay(nTime,self.HealerText,self.HealerBar,
					self.HealerBackground,self.HealerOverlay,
					showtext,
					heal,totalheal) or show


				self.DamagerBar:Hide()
				self.DamagerOverlay:Hide()
				self.DamagerBackground:Hide()
				self.DamagerText:Hide()

				self.TankBar:Hide()
				self.TankOverlay:Hide()
				self.TankBackground:Hide()
				self.TankText:Hide()

			elseif(type==2 and NPA_RoleCheck_Config["RoleCheck_ShowDamagerBar"]==1)then
				show=NPA_RoleCheck_SetDisplay(nTime,self.DamagerText,self.DamagerBar,
					self.DamagerBackground,self.DamagerOverlay,
					showtext,
					damage,totaldamage) or show

				self.HealerBar:Hide()
				self.HealerOverlay:Hide()
				self.HealerBackground:Hide()
				self.HealerText:Hide()

				self.TankBar:Hide()
				self.TankOverlay:Hide()
				self.TankBackground:Hide()
				self.TankText:Hide()

			elseif(type==3 and NPA_RoleCheck_Config["RoleCheck_ShowTankBar"]==1)then
				show=NPA_RoleCheck_SetDisplay(nTime,self.TankText,self.TankBar,
					self.TankBackground,self.TankOverlay,
					showtext,
					tank,totaltank) or show

				self.HealerBar:Hide()
				self.HealerOverlay:Hide()
				self.HealerBackground:Hide()
				self.HealerText:Hide()

				self.DamagerBar:Hide()
				self.DamagerOverlay:Hide()
				self.DamagerBackground:Hide()
				self.DamagerText:Hide()
			else
				self.HealerBar:Hide()
				self.HealerOverlay:Hide()
				self.HealerBackground:Hide()
				self.HealerText:Hide()

				self.DamagerBar:Hide()
				self.DamagerOverlay:Hide()
				self.DamagerBackground:Hide()
				self.DamagerText:Hide()

				self.TankBar:Hide()
				self.TankOverlay:Hide()
				self.TankBackground:Hide()
				self.TankText:Hide()
			end
		else
			show=NPA_RoleCheck_SetDisplay(nTime,self.HealerText,self.HealerBar,
				self.HealerBackground,self.HealerOverlay,
				NPA_RoleCheck_Config["RoleCheck_ShowHealerBar"],showtext,
				heal,totalheal) or show
			show=NPA_RoleCheck_SetDisplay(nTime,self.DamagerText,self.DamagerBar,
				self.DamagerBackground,self.DamagerOverlay,
				NPA_RoleCheck_Config["RoleCheck_ShowDamagerBar"],showtext,
				damage,totaldamage) or show
			show=NPA_RoleCheck_SetDisplay(nTime,self.TankText,self.TankBar,
				self.TankBackground,self.TankOverlay,
				NPA_RoleCheck_Config["RoleCheck_ShowTankBar"],showtext,
				tank,totaltank) or show

			if(NPA_RoleCheck_Config["RoleCheck_AlwaysShowIcon"]==1)then
				self.Tank:Show()
				self.Healer:Show()
				self.Damager:Show()
			end
		end
	end

	if(show)then
		self:Show()
	else
		self:Hide()
	end
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager



local function NPA_RoleCheck_SetFrame(main)
	if(NPA_RoleCheck_Config["RoleCheck_DontFade"]==1)then
		main:SetParent(main.ParentParent)
	else
		main:SetParent(main.Parent)
	end
	main:SetPoint("CENTER",main:GetParent(),"CENTER",0,0)

	
	main:Hide()
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_RoleCheck_Config["RoleCheck_OffsetX"],NPA_RoleCheck_Config["RoleCheck_OffsetY"])

	ManageTexture(nil,main.HealerBar,NPA_RoleCheck_Config["RoleCheck_HealerBarData"],main,1)
	ManageTexture(nil,main.HealerOverlay,NPA_RoleCheck_Config["RoleCheck_HealerOverlayData"],main)
	ManageTexture(nil,main.HealerBackground,NPA_RoleCheck_Config["RoleCheck_HealerBackgroundData"],main)

	ManageTexture(nil,main.DamagerBar,NPA_RoleCheck_Config["RoleCheck_DamagerBarData"],main,1)
	ManageTexture(nil,main.DamagerOverlay,NPA_RoleCheck_Config["RoleCheck_DamagerOverlayData"],main)
	ManageTexture(nil,main.DamagerBackground,NPA_RoleCheck_Config["RoleCheck_DamagerBackgroundData"],main)

	ManageTexture(nil,main.TankBar,NPA_RoleCheck_Config["RoleCheck_TankBarData"],main,1)
	ManageTexture(nil,main.TankOverlay,NPA_RoleCheck_Config["RoleCheck_TankOverlayData"],main)
	ManageTexture(nil,main.TankBackground,NPA_RoleCheck_Config["RoleCheck_TankBackgroundData"],main)

	ManageTexture(nil,main.Healer,NPA_RoleCheck_Config["RoleCheck_HealerData"],main:GetParent())
	ManageTexture(nil,main.Damager,NPA_RoleCheck_Config["RoleCheck_DamagerData"],main:GetParent())
	ManageTexture(nil,main.Tank,NPA_RoleCheck_Config["RoleCheck_TankData"],main:GetParent())

	ManageFont(nil,main.HealerText,NPA_RoleCheck_Config["RoleCheck_HealerTextData"],main)
	ManageFont(nil,main.DamagerText,NPA_RoleCheck_Config["RoleCheck_DamagerTextData"],main)
	ManageFont(nil,main.TankText,NPA_RoleCheck_Config["RoleCheck_TankTextData"],main)

	if(NPA_RoleCheck_Config["RoleCheck_ShowBar"]~=1)then
		main.HealerBar:Hide()
		main.HealerOverlay:Hide()
		main.HealerBackground:Hide()
		main.HealerText:Hide()

		main.DamagerBar:Hide()
		main.DamagerOverlay:Hide()
		main.DamagerBackground:Hide()
		main.DamagerText:Hide()

		main.TankBar:Hide()
		main.TankOverlay:Hide()
		main.TankBackground:Hide()
		main.TankText:Hide()
	end
end

local function NPA_RoleCheck_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_RoleCheck_MainFrame",frame)
	main:SetHeight(1)
	main:SetWidth(1)
	main:SetPoint("CENTER",frame,"CENTER",0,0)
	main:Hide()

	local healer=main:CreateTexture("NPA_RoleCheck_Healer","OVERLAY")
	healer:Hide()

	local healerbar=main:CreateTexture("NPA_RoleCheck_HealerBar","BORDER")
	healerbar:Hide()
	local healerbackground=main:CreateTexture("NPA_RoleCheck_HealerBackground","BACKGROUND")
	healerbackground:Hide()
	local healeroverlay=main:CreateTexture("NPA_RoleCheck_HealerOverlay","ARTWORK")
	healeroverlay:Hide()
	local healertext=main:CreateFontString("NPA_RoleCheck_HealerText","ARTWORK")
	healertext:Hide()

	---------------------
	local damager=main:CreateTexture("NPA_RoleCheck_Damager","OVERLAY")
	damager:Hide()

	local damagerbar=main:CreateTexture("NPA_RoleCheck_DamagerBar","BORDER")
	damagerbar:Hide()
	local damagerbackground=main:CreateTexture("NPA_RoleCheck_DamagerBackground","BACKGROUND")
	damagerbackground:Hide()
	local damageroverlay=main:CreateTexture("NPA_RoleCheck_DamagerOverlay","ARTWORK")
	damageroverlay:Hide()
	local damagertext=main:CreateFontString("NPA_RoleCheck_DamagerText","ARTWORK")
	damagertext:Hide()

	-----------------------
	local tank=main:CreateTexture("NPA_RoleCheck_Tank","OVERLAY")
	tank:Hide()
	local tankbar=main:CreateTexture("NPA_RoleCheck_TankBar","BORDER")
	tankbar:Hide()
	local tankbackground=main:CreateTexture("NPA_RoleCheck_TankBackground","BACKGROUND")
	tankbackground:Hide()
	local tankoverlay=main:CreateTexture("NPA_RoleCheck_TankOverlay","ARTWORK")
	tankoverlay:Hide()
	local tanktext=main:CreateFontString("NPA_RoleCheck_TankText","ARTWORK")
	tanktext:Hide()

	------------------------
	main.Healer=healer
	main.HealerText=healertext
	main.HealerBar=healerbar
	main.HealerOverlay=healeroverlay
	main.HealerBackground=healerbackground

	main.Damager=damager
	main.DamagerText=damagertext
	main.DamagerBar=damagerbar
	main.DamagerOverlay=damageroverlay
	main.DamagerBackground=damagerbackground

	main.Tank=tank
	main.TankText=tanktext
	main.TankBar=tankbar
	main.TankOverlay=tankoverlay
	main.TankBackground=tankbackground

	main.Parent=frame
	main.ParentParent=frame.Parent
	
	NPA_RoleCheck_SetFrame(main)
	table_insert(NPA_RoleCheck_Frame,main)

	frame["RoleCheck"]=main
	
	frame:HookScript("OnHide",function(self)
		self["RoleCheck"]:Hide()
		end)
end

local function NPA_RoleCheck_ClearData()
	NPA_RoleCheck_DamageCount={}
	NPA_RoleCheck_HealCount={}
	NPA_RoleCheck_TankCount={}
	NPA_RoleCheck_DamageMax=1
	NPA_RoleCheck_HealMax=1

	NPA_RoleCheck_StartTime=GetTime()
end

function NPA_RoleCheck:ClearData()
	NPA_RoleCheck_ClearData()
end

function NPA_RoleCheck:Test()
	NPA_RoleCheck_DamageCount[-100]=floor(random()*1000000)
	NPA_RoleCheck_TankCount[-100]=floor(random()*200000)
	NPA_RoleCheck_HealCount[-100]=floor(random()*1000000)
end

local NPA_RoleCheck_CombatEvent={
	["SWING_DAMAGE"]=1,
	["SPELL_DAMAGE"]=2,
	["RANGE_DAMAGE"]=2,
	["SPELL_PERIODIC_DAMAGE"]=2,
	["SPELL_HEAL"]=3,
	["SPELL_PERIODIC_HEAL"]=3
	}


local function NPA_RoleCheck_OnEvent(uarg)
	if(NPA_RoleCheck_Config["RoleCheck_StopWhenOutCombat"]==1 and (not UnitAffectingCombat("player")))then
		return
	end
	
	local match1
	local match2
	if(bit_band(uarg[5],COMBATLOG_OBJECT_TYPE_PET)>0 or bit_band(uarg[5],COMBATLOG_OBJECT_TYPE_PLAYER)>0)then
		NPA_RoleCheck_NameToGUID[uarg[4]]=uarg[3]
		match1=1
	end
	if(bit_band(uarg[8],COMBATLOG_OBJECT_TYPE_PET)>0 or bit_band(uarg[8],COMBATLOG_OBJECT_TYPE_PLAYER)>0)then
		NPA_RoleCheck_NameToGUID[uarg[7]]=uarg[6]
		match2=1
	end

	local event=NPA_RoleCheck_CombatEvent[uarg[2]]

	local match=match1 or match2
	if(event==1 and match)then
		local amount=uarg[9]
		if(NPA_RoleCheck_Config["RoleCheck_OnlyEffective"]~=1)then
			amount=amount+uarg[12]+uarg[13]+uarg[14]
		end

		if(match1)then
			NPA_RoleCheck_DamageCount[uarg[3]]=(NPA_RoleCheck_DamageCount[uarg[3]] or 0)+amount

			if(NPA_RoleCheck_Config["RoleCheck_TotalAsMax"]==1)then
				NPA_RoleCheck_DamageMax=NPA_RoleCheck_DamageMax+amount
			else
				if(NPA_RoleCheck_DamageCount[uarg[3]]>NPA_RoleCheck_DamageMax)then
					NPA_RoleCheck_DamageMax=NPA_RoleCheck_DamageCount[uarg[3]]
				end
			end
		end

		if(match2)then
			NPA_RoleCheck_TankCount[uarg[6]]=(NPA_RoleCheck_TankCount[uarg[6]] or 0)+amount
		end
	
	elseif(event==2 and match)then
		local amount=uarg[12]
		if(NPA_RoleCheck_Config["RoleCheck_OnlyEffective"]~=1)then
			amount=amount+uarg[15]+uarg[16]+uarg[17]
		end

		if(match1)then
			NPA_RoleCheck_DamageCount[uarg[3]]=(NPA_RoleCheck_DamageCount[uarg[3]] or 0)+amount
		
		
			if(NPA_RoleCheck_Config["RoleCheck_TotalAsMax"]==1)then
				NPA_RoleCheck_DamageMax=NPA_RoleCheck_DamageMax+amount
			else
				if(NPA_RoleCheck_DamageCount[uarg[3]]>NPA_RoleCheck_DamageMax)then
					NPA_RoleCheck_DamageMax=NPA_RoleCheck_DamageCount[uarg[3]]
				end
			end
		end
		if(match2)then
			NPA_RoleCheck_TankCount[uarg[6]]=(NPA_RoleCheck_TankCount[uarg[6]] or 0)+amount
		end

	elseif(event==3 and match1)then
		local amount=uarg[12]
		if(NPA_RoleCheck_Config["RoleCheck_OnlyEffective"]==1)then
			amount=amount-uarg[13]-uarg[14]
		end
		NPA_RoleCheck_HealCount[uarg[3]]=(NPA_RoleCheck_HealCount[uarg[3]] or 0)+amount

		if(NPA_RoleCheck_Config["RoleCheck_TotalAsMax"]==1)then
			NPA_RoleCheck_HealMax=NPA_RoleCheck_HealMax+amount
		else
			if(NPA_RoleCheck_HealCount[uarg[3]]>NPA_RoleCheck_HealMax)then
				NPA_RoleCheck_HealMax=NPA_RoleCheck_HealCount[uarg[3]]
			end
		end
	end
end

local function NPA_RoleCheck_GetBattleFieldScore()
	NPA_RoleCheck_BattleFieldScore={}

	NPA_RoleCheck_BattleFieldScore["Total_Damage"]=1
	NPA_RoleCheck_BattleFieldScore["Total_Heal"]=1

	local maxdamage=1
	local maxheal=1

	for i=1, GetNumBattlefieldScores() do
		--local name, killingBlows, honorKills, deaths, honorGained, faction, rank, race, class, classtoken, damageDone, healingDone = GetBattlefieldScore(i)
		local name, _, _, _, _, _, _, _, _, damageDone, healingDone = GetBattlefieldScore(i)
		local guid=NPA_RoleCheck_NameToGUID[name]
		if(guid)then
			NPA_RoleCheck_BattleFieldScore[guid]={
				Heal=healingDone,
				Damage=damageDone
			}
			if(NPA_RoleCheck_Config["RoleCheck_TotalAsMax"]==1)then
				maxdamage=maxdamage+damageDone
				maxheal=maxheal+healingDone
			else
				if(damageDone>maxdamage)then
					maxdamage=damageDone
				end
				if(healingDone>maxheal)then
					maxheal=healingDone
				end
			end
		end
	end

	NPA_RoleCheck_BattleFieldScore["Total_Damage"]=maxdamage
	NPA_RoleCheck_BattleFieldScore["Total_Heal"]=maxheal
end

function NPA_RoleCheck:ApplyConfig()
	NPA_Core:CheckConfigEntry("RoleCheck",NPA_RoleCheck_DefaultSetting)

	NPA_RoleCheck_Config=NPA_Config["RoleCheck"]

	for _,main in pairs(NPA_RoleCheck_Frame) do
		NPA_RoleCheck_SetFrame(main)
	end

	if(NPA_Config["Core"]["EnableModule"]["RoleCheck"]==1)then
		if(NPA_RoleCheck_Config["RoleCheck_ResetWhenCombat"]==1)then
			NPA_Core:RegisteEvent("PLAYER_REGEN_DISABLED",NPA_RoleCheck_ClearData)
			NPA_Core:RegisteEvent("PLAYER_REGEN_ENABLED",NPA_RoleCheck_ClearData)
		else
			NPA_Core:RegisteEvent("PLAYER_REGEN_DISABLED",nil)
			NPA_Core:RegisteEvent("PLAYER_REGEN_ENABLED",nil)
		end
		NPA_Core.CombatEventFunc["RoleCheck"]=NPA_RoleCheck_OnEvent

		if(NPA_RoleCheck_Config["RoleCheck_UseBattleFieldScore"]==1)then
			NPA_Core:RegisteEvent("UPDATE_BATTLEFIELD_SCORE",NPA_RoleCheck_GetBattleFieldScore)
		else
			NPA_Core:RegisteEvent("UPDATE_BATTLEFIELD_SCORE",nil)
		end
	else
		NPA_Core:RegisteEvent("PLAYER_REGEN_DISABLED",nil)
		NPA_Core:RegisteEvent("PLAYER_REGEN_ENABLED",nil)
		NPA_Core.CombatEventFunc["RoleCheck"]=nil
		NPA_Core:RegisteEvent("UPDATE_BATTLEFIELD_SCORE",nil)
	end
end


NPA_Core:AddHook("RoleCheck",NPA_RoleCheck_HookFrame)
NPA_Core:AddModule("RoleCheck",NPA_RoleCheck)
NPA_Core:HookUpdate("RoleCheck",NPA_RoleCheck_OnUpdate,2)