﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime
local table_insert=table.insert
local NPA_RangeCheck_Frame={}

local NPA_RangeCheck={}
--config
local NPA_RangeCheck_DefaultSetting={
		["RangeCheck_Close"]=5,
		["RangeCheck_Middle"]=25,
		["RangeCheck_Far"]=40,
		["RangeCheck_Hostile"]=1,
		["RangeCheck_NonHostile"]=1,
		["RangeCheck_Target"]=1,
		["RangeCheck_PetTarget"]=1,
		["RangeCheck_Focus"]=1,
		["RangeCheck_HideOutRange"]=1,
		["RangeCheck_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=-50,
			OffsetY=-30,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

	}
local NPA_RangeCheck_Config=NPA_RangeCheck_DefaultSetting

function NPA_RangeCheck:ResetConfig()
	NPA_Config["RangeCheck"]=CopyTable(NPA_RangeCheck_DefaultSetting)
end


local function NPA_RangeCheck_OnUpdate(_,self,guid,unitdata,_,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed)
	local range=unitdata.Range
	if(recentUpdated and range and (NPA_RangeCheck_Config["RangeCheck_HideOutRange"]~=1 or unitdata.Range.Min<NPA_RangeCheck_Config["RangeCheck_Far"]) and
		((unitdata.IsEnemy and NPA_RangeCheck_Config["RangeCheck_Hostile"]==1) or
			(unitdata.IsEnemy==nil and NPA_RangeCheck_Config["RangeCheck_NonHostile"]==1) or
			(guid==UnitGUID("target") and NPA_RangeCheck_Config["RangeCheck_Target"]==1) or
			(guid==UnitGUID("pettarget") and NPA_RangeCheck_Config["RangeCheck_PetTarget"]==1) or
			(guid==UnitGUID("focus") and NPA_RangeCheck_Config["RangeCheck_Focus"]==1))) then
	

		if(range.Min~=range.Max)then
			if(range.Max==1000)then
				self:SetText(range.Min.." - *")
				self:SetTextColor(1,0,0,1)
			else
				self:SetText(range.Min.." - "..range.Max)

			end

		else
			self:SetText(floor(range.Min))

		end
		if(range.Min<=NPA_RangeCheck_Config["RangeCheck_Close"])then
			self:SetTextColor(0,1,0,1)
			self.RangeType=1
		elseif(range.Min<=NPA_RangeCheck_Config["RangeCheck_Middle"])then
			self:SetTextColor(1,1,0,1)
			self.RangeType=2
		elseif(range.Min<=NPA_RangeCheck_Config["RangeCheck_Far"])then
			self:SetTextColor(1,0.5,0,1)
			self.RangeType=3
		else
			self:SetTextColor(1,0,0,1)
			self.RangeType=0
		end

		self:Show()	
	else
		self:Hide()
	end

end

local ManageFont=NPA_Core.FontManager

local function NPA_RangeCheck_SetText(text)
	ManageFont(nil,text,NPA_RangeCheck_Config["RangeCheck_TextData"],text:GetParent())
end
local function NPA_RangeCheck_HookFrame(frame)
	local text=frame:CreateFontString(nil,"OVERLAY",nil)
	text:Hide()
	
	NPA_RangeCheck_SetText(text)
	table_insert(NPA_RangeCheck_Frame,text)

	frame["RangeCheck"]=text	

end

function NPA_RangeCheck:ApplyConfig()
	NPA_Core:CheckConfigEntry("RangeCheck",NPA_RangeCheck_DefaultSetting)
	
	NPA_RangeCheck_Config=NPA_Config["RangeCheck"]
	NPA_RangeCheck_Config["RangeCheck"]=NPA_Config["Core"]["Core_RangeCheck"]

	for _,text in pairs(NPA_RangeCheck_Frame) do
		NPA_RangeCheck_SetText(text)
	end
end

NPA_Core:AddHook("RangeCheck",NPA_RangeCheck_HookFrame)
NPA_Core:AddModule("RangeCheck",NPA_RangeCheck)
NPA_Core:HookUpdate("RangeCheck",NPA_RangeCheck_OnUpdate,2)