﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local NPA_RaidIcon={}
--config

local NPA_RaidIcon_DefaultSetting={
		["RaidIcon_IconData"]={
			OffsetX=0,
			OffsetY=70,
			Height=40,
			Width=40,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-RaidTargetingIcons",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RaidIcon_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=42,
			Width=42,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RaidIcon_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=42,
			Width=42,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["RaidIcon_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=50,
			OffsetY=-30,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["RaidIcon_ShowText"]=0,
		["RaidIcon_ShowPartyID"]=1,
		["RaidIcon_ShowRaidID"]=1,
		["RaidIcon_ShowArenaID"]=1,
		["RaidIcon_ShowPrefix"]=1,
		["RaidIcon_ColorText"]=1,
	}
local NPA_RaidIcon_Config=NPA_RaidIcon_DefaultSetting

function NPA_RaidIcon:ResetConfig()
	NPA_Config["RaidIcon"]=CopyTable(NPA_RaidIcon_DefaultSetting)
end

local NPA_RaidIcon_Frame={}

local NPA_RaidIcon_GUIDToPartyID={}
local NPA_RaidIcon_GUIDToRaidID={}
local NPA_RaidIcon_GUIDToArenaID={}


local table_insert=table.insert
local unpack=unpack

--1 = Yellow 4-point Star 
--2 = Orange Circle 
--3 = Purple Diamond 
--4 = Green Triangle 
--5 = White Crescent Moon 
--6 = Blue Square 
--7 = Red "X" Cross 
--8 = White Skull

local NPA_RaidIcon_Table={
		[1]={0,0.25,0,0.25},
		[2]={0.25,0.5,0,0.25},
		[3]={0.5,0.75,0,0.25},
		[4]={0.75,1,0,0.25},
		[5]={0,0.25,0.25,0.5},
		[6]={0.25,0.5,0.25,0.5},
		[7]={0.5,0.75,0.25,0.5},
		[8]={0.75,1,0.25,0.5},
	}
local function NPA_RaidIcon_OnUpdate(_,self,guid,unitdata,_,_,frame,_,_,default)
	local show
	if(default)then
		local raidicon=default.RaidIcon
		if(raidicon:IsShown())then
			self.Icon:SetTexCoord(raidicon:GetTexCoord())
			self.Icon:Show()
			show=1
		else
			self.Icon:Hide()
		end
	elseif(unitdata and guid~=UnitGUID("player"))then
		local index=unitdata.RaidTarget
		if(index)then
			self.Icon:SetTexCoord(unpack(NPA_RaidIcon_Table[index]))
			self.Icon:Show()
			show=1
		else
			self.Icon:Hide()
		end
	else
		self.Icon:Hide()
	end
	if(guid and NPA_RaidIcon_Config["RaidIcon_ShowText"]==1)then
		local text
		if(NPA_RaidIcon_Config["RaidIcon_ShowArenaID"]==1)then
			local arenaid=NPA_RaidIcon_GUIDToArenaID[guid]
			if(arenaid)then
				if(NPA_RaidIcon_Config["RaidIcon_ShowPrefix"]==1)then
					text="Arena"..arenaid
				else
					text=arenaid
				end
				if(NPA_RaidIcon_Config["RaidIcon_ColorText"]==1)then
					text="|cffff0000"..text
				end
			end
		end
		if(NPA_RaidIcon_Config["RaidIcon_ShowRaidID"]==1)then
			local raidid=NPA_RaidIcon_GUIDToRaidID[guid]
			if(raidid)then
				if(NPA_RaidIcon_Config["RaidIcon_ShowPrefix"]==1)then
					text="Raid"..raidid
				else
					text=raidid
				end
				if(NPA_RaidIcon_Config["RaidIcon_ColorText"]==1)then
					text="|cffffff00"..text
				end
			end
		end
		if(NPA_RaidIcon_Config["RaidIcon_ShowPartyID"]==1)then
			local partyid=NPA_RaidIcon_GUIDToPartyID[guid]
			if(partyid)then
				if(NPA_RaidIcon_Config["RaidIcon_ShowPrefix"]==1)then
					text="Party"..partyid
				else
					text=partyid
				end
				if(NPA_RaidIcon_Config["RaidIcon_ColorText"]==1)then
					text="|cff0000ff"..text
				end
			end
		end
		self.Text:SetText(text)
		if(text)then
			show=1
		end
	else
		self.Text:SetText(nil)
	end
	if(show==1)then
		self:Show()
	else
		self:Hide()
	end
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_RaidIcon_SetFrame(mainframe)
	mainframe:Hide()

	ManageTexture(nil,mainframe.Icon,NPA_RaidIcon_Config["RaidIcon_IconData"],mainframe)
	ManageTexture(nil,mainframe.Overlay,NPA_RaidIcon_Config["RaidIcon_Overlay"],mainframe.Icon)
	ManageTexture(nil,mainframe.Background,NPA_RaidIcon_Config["RaidIcon_BackgroundData"],mainframe.Icon)
	
	ManageFont(nil,mainframe.Text,NPA_RaidIcon_Config["RaidIcon_TextData"],mainframe)

	if(NPA_RaidIcon_Config["RaidIcon_ShowText"]==1)then
		mainframe.Text:Show()
	else
		mainframe.Text:Hide()
	end
end

local function NPA_RaidIcon_HookFrame(frame)
	local mainframe=CreateFrame("Frame","NPA_RaidIcon_MainFrame",frame:GetParent())
	mainframe:SetHeight(1)
	mainframe:SetWidth(1)
	mainframe:SetPoint("CENTER",frame,"CENTER",0,0)
	mainframe:Hide()

	local icon=mainframe:CreateTexture("NPA_RaidIcon_Icon","BACKGROUND",nil)
	icon:Show()
	local overlay=mainframe:CreateTexture("NPA_RaidIcon_Overlay","OVERLAY",nil)
	overlay:Show()
	local background=mainframe:CreateTexture("NPA_RaidIcon_Background","BACKGROUND",nil)
	background:Show()

	local text=mainframe:CreateFontString("NPA_RaidIcon_Text","OVERLAY",nil)
	text:Hide()
	
	if(frame.Parent.Default)then
		frame.Parent.Default.RaidIcon:SetTexture(nil)
	end

	mainframe.Icon=icon
	mainframe.Overlay=overlay
	mainframe.Background=background
	mainframe.Text=text

	NPA_RaidIcon_SetFrame(mainframe)
	table_insert(NPA_RaidIcon_Frame,mainframe)

	frame["RaidIcon"]=mainframe

end

local function NPA_RaidIcon_OnEvent()
	NPA_RaidIcon_GUIDToRaidID={}
	local raidn=GetNumRaidMembers()
	local playerguid=UnitGUID("player")
	if(raidn)then
		for i=1,raidn do
			local guid=UnitGUID("raid"..i)
			if(guid and guid~=playerguid)then
				NPA_RaidIcon_GUIDToRaidID[guid]=i
			end
		end
	end
	
	NPA_RaidIcon_GUIDToPartyID={}
	local partyn=GetNumPartyMembers()
	if(partyn)then
		for i=1,partyn do
			local guid=UnitGUID("party"..i)
			if(guid)then
				NPA_RaidIcon_GUIDToPartyID[guid]=i
			end

		end
	end

	NPA_RaidIcon_GUIDToArenaID={}
	for i=1,5 do
		local guid=UnitGUID("arena"..i)
		if(guid)then
			NPA_RaidIcon_GUIDToArenaID[guid]=i
		end
	end
end

----hard search

function NPA_RaidIcon:ApplyConfig()
	NPA_Core:CheckConfigEntry("RaidIcon",NPA_RaidIcon_DefaultSetting)

	NPA_RaidIcon_Config=NPA_Config["RaidIcon"]
	NPA_RaidIcon_Config["RaidIcon"]=NPA_Config["Core"]["Core_RaidIcon"]

	for _,mainframe in pairs(NPA_RaidIcon_Frame) do
		NPA_RaidIcon_SetFrame(mainframe)
	end

	NPA_RaidIcon_OnEvent()
end
function NPA_RaidIcon:ClearData()
	NPA_RaidIcon_GUIDToArenaID={}
end

NPA_Core:AddHook("RaidIcon",NPA_RaidIcon_HookFrame)
NPA_Core:AddModule("RaidIcon",NPA_RaidIcon)
NPA_Core:RegisteEvent("UNIT_NAME_UPDATE",NPA_RaidIcon_OnEvent)
NPA_Core:RegisteEvent("ARENA_OPPONENT_UPDATE",NPA_RaidIcon_OnEvent)

NPA_Core:HookUpdate("RaidIcon",NPA_RaidIcon_OnUpdate,1)