﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local table_insert=table.insert
local NPA_QuestMark_Frame={}
local strlen=string.len
local strfind=string.find
local table_insert=table.insert
local table_getn=table.getn
local table_remove=table.remove
local pairs=pairs
local string_gmatch=string.gmatch
local string_gsub=string.gsub
local getglobal=getglobal
local tonumber=tonumber

local locale=GetLocale()

local NPA_QuestMark={}
--config
local NPA_QuestMark_DefaultSetting={
		["QuestMark_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=50,
			OffsetY=-30,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["QuestMark_ShowFinished"]=1
	}
local NPA_QuestMark_Config=NPA_QuestMark_DefaultSetting

function NPA_QuestMark:ResetConfig()
	NPA_Config["QuestMark"]=CopyTable(NPA_QuestMark_DefaultSetting)
end


local NPA_QuestCache={}


local NPA_QuestMark_QuestStringFilter={
	"\124c%x+",
	"\124H(.+)",
	"\124h%[.+%]",
	"\124r",
	"%[+",
	"%]+",
	"%-+",
	"'",
}

local function NPA_QuestMark_Format(str)
	local newstr=str

	for _,filter in pairs(NPA_QuestMark_QuestStringFilter) do
		newstr=string_gsub(newstr,filter,"")
	end

	return newstr
end

local NPA_QuestMark_QuestList={}
local NPA_QuestMark_TooltipsFilter={}

local NPA_QuestMark_BuildQuestList

if(locale=="zhCN" or locale=="enCN")then

	NPA_QuestMark_BuildQuestList=function()
	NPA_QuestCache={}

	NPA_QuestMark_QuestList={}
	local numEntries,numQuests=GetNumQuestLogEntries()

	for questid=1,numEntries do
		--local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questID)
		local title,_,_,_,isHeader,_,isComplete=GetQuestLogTitle(questid)
		
		if((not isHeader) and title)then--is questentry
			local numobj=GetNumQuestLeaderBoards(questid)

			local questdata={}
			if(numobj>0)then
				for objid=1,numobj do
					local text,typ,finished=GetQuestLogLeaderBoard(objid,questid)
					if((not text) or strlen(text)==0)then
						text=typ
					else
						text=NPA_QuestMark_Format(text)
					end
					

					for item,current,max in string_gmatch(text,"([^:]+)：(%d+)/(%d+)$") do
						item=string_gsub(item,"：","")
						current=tonumber(current)
						max=tonumber(max)
						table_insert(questdata,{Text=text,Item=item,Current=current,Max=max})
					end
				end
			end
			NPA_QuestMark_QuestList[NPA_QuestMark_Format(title)]=questdata
		end
					
	end
	--check tooltips filter
	for index,quest in pairs(NPA_QuestMark_TooltipsFilter) do
		local match=nil
		for _,obj in pairs(quest) do
			if(NPA_QuestMark_QuestList[obj.QuestName])then
				match=1
			end
		end
		if(match==nil)then --remove it
			NPA_QuestMark_TooltipsFilter[index]=nil
		end
	end

	end

else
	NPA_QuestMark_BuildQuestList=function()
	NPA_QuestCache={}

	NPA_QuestMark_QuestList={}
	local numEntries,numQuests=GetNumQuestLogEntries()

	for questid=1,numEntries do
		--local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questID)
		local title,_,_,_,isHeader,_,isComplete=GetQuestLogTitle(questid)
		
		if((not isHeader) and title)then--is questentry
			local numobj=GetNumQuestLeaderBoards(questid)

			local questdata={}
			if(numobj>0)then
				for objid=1,numobj do
					local text,typ,finished=GetQuestLogLeaderBoard(objid,questid)
					if((not text) or strlen(text)==0)then
						text=typ
					else
						text=NPA_QuestMark_Format(text)
					end
					

					for item,current,max in string_gmatch(text,"([^:]+): (%d+)/(%d+)$") do
						current=tonumber(current)
						max=tonumber(max)
						table_insert(questdata,{Text=text,Item=item,Current=current,Max=max})
					end
				end
			end
			NPA_QuestMark_QuestList[NPA_QuestMark_Format(title)]=questdata
		end
					
	end
	--check tooltips filter
	for index,quest in pairs(NPA_QuestMark_TooltipsFilter) do
		local match=nil
		for _,obj in pairs(quest) do
			if(NPA_QuestMark_QuestList[obj.QuestName])then
				match=1
			end
		end
		if(match==nil)then --remove it
			NPA_QuestMark_TooltipsFilter[index]=nil
		end
	end

	end
end



local function NPA_QuestMark_HookToolTipOnShow(self)
	if(UnitExists("mouseover"))then
		local name=NPA_QuestMark_Format(UnitName("mouseover"))
		if(not name)then
			return
		end
		local i=1
		local select=nil
		local max=0
						
		while(getglobal("GameTooltipTextLeft"..i))do
			local line=(getglobal("GameTooltipTextLeft"..i):GetText())
			if(line~=nil)then
				line=NPA_QuestMark_Format(line)
				if(NPA_QuestMark_QuestList[line]~=nil)then
					select=line
					if(NPA_QuestMark_TooltipsFilter[name]==nil)then
						NPA_QuestMark_TooltipsFilter[name]={}
					end
				else
					if(NPA_QuestMark_QuestList[select])then
						for i,quest in pairs(NPA_QuestMark_QuestList[select]) do
							if(strfind(line,quest.Text))then
								--check if already there
								local match=nil
								for _,filter in pairs(NPA_QuestMark_TooltipsFilter[name]) do
									if(filter.QuestName==select and filter.ObjIndex==i)then
										match=1
									end
								end
								if(match==nil)then
									table_insert(NPA_QuestMark_TooltipsFilter[name],{QuestName=select,ObjIndex=i})
								end
							end
						end
					end
				end				
			end
			i=i+1
		end	
	end
end

local function NPA_QuestMark_OnUpdate(_,self,_,unitdata,_,_,_,_,_,default)
	local name
	if(default)then
		name=NPA_QuestMark_Format(default.NameText:GetText())
	elseif(unitdata)then
		name=NPA_QuestMark_Format(unitdata.Name)
	else
		self:Hide()
		return
	end

	local current=0
	local max=0

	---do tooltips filter first
	local cache=NPA_QuestCache[name]
	if(cache)then
		local quest=NPA_QuestMark_QuestList[cache.Quest]
		local obj=quest[cache.Obj]
		current=obj.Current
		max=obj.Max
	else

		local tooltipsfilter=NPA_QuestMark_TooltipsFilter[name]
		if(tooltipsfilter)then
			local match=nil	
			for i,filter in pairs(tooltipsfilter) do
				if(NPA_QuestMark_QuestList[filter.QuestName])then
					match=1
					local quest=NPA_QuestMark_QuestList[filter.QuestName]
					local obj=quest[filter.ObjIndex]
					if((max-current)<=(obj.Max-obj.Current))then
						max=obj.Max
						current=obj.Current
						NPA_QuestCache[name]={
							Quest=filter.QuestName,
							Obj=filter.ObjIndex
							}
					end	
				end
			end
	
			if(match==1)then
				if(max==0)then  -----not number quest target
					max=-1
				end
			else
				---not in quest log any more, remove it
				NPA_QuestMark_TooltipsFilter[name]=nil
			end
		else
			for questindex,quest in pairs(NPA_QuestMark_QuestList) do
				for objindex,obj in pairs(quest) do
					if(strfind(obj.Item,name))then
						if((max-current)<=(obj.Max-obj.Current))then
							current=obj.Current
							max=obj.Max
						
							NPA_QuestCache[name]={
								Quest=questindex,
								Obj=objindex
								}
						end
					end
				end	
			end
		end
	end

	if(max==-1)then
		self:SetText("! ")
		self:Show()
	elseif(max==0)then
		self:Hide()
	else
		if(current==max)then
			if(NPA_QuestMark_Config["QuestMark_ShowFinished"]==1)then
				self:SetText("|cff00ff00"..current.."/"..max)
				self:Show()
			else
				self:Hide()
			end
		else
			self:SetText(current.."/"..max)
			self:Show()
		end
	end
end
local ManageFont=NPA_Core.FontManager


local function NPA_QuestMark_SetText(text)
	ManageFont(nil,text,NPA_QuestMark_Config["QuestMark_TextData"],text:GetParent())
end

local function NPA_QuestMark_HookFrame(frame)

	local text=frame:CreateFontString(nil,"OVERLAY",nil)
	text:Hide()
	
	NPA_QuestMark_SetText(text)
	table_insert(NPA_QuestMark_Frame,text)

	
	frame["QuestMark"]=text

end

function NPA_QuestMark:ApplyConfig()
	NPA_Core:CheckConfigEntry("QuestMark",NPA_QuestMark_DefaultSetting)

	NPA_QuestMark_Config=NPA_Config["QuestMark"]

	for _,text in pairs(NPA_QuestMark_Frame) do
		NPA_QuestMark_SetText(text)
	end
	NPA_QuestMark_BuildQuestList()
end

local function NPA_QuestMark_OnLogEvent()
	NPA_QuestMark_BuildQuestList()
end

function NPA_QuestMark:Test()
	local max=floor(random()*10+1)
	NPA_QuestCache["Test object"]={Quest="Test",Obj="Test"}
	NPA_QuestMark_QuestList["Test"]={["Test"]={Current=floor(random()*max),Max=max,Item=""}}

end


NPA_QuestMark_BuildQuestList()

local questlogframe=CreateFrame("Frame","NPA_QuestMark_MainFrame",NPA_MainFrame)
questlogframe:RegisterEvent("QUEST_LOG_UPDATE")
questlogframe:SetScript("OnEvent",NPA_QuestMark_OnLogEvent)
questlogframe:Show()

if(GameTooltip ~=nil)then
	GameTooltip:HookScript("OnShow",NPA_QuestMark_HookToolTipOnShow)
end

NPA_Core:AddHook("QuestMark",NPA_QuestMark_HookFrame)
NPA_Core:AddModule("QuestMark",NPA_QuestMark)
NPA_Core:HookUpdate("QuestMark",NPA_QuestMark_OnUpdate,1)