﻿-- Author      : Nogarder
-- Create Date : 2010/7/1 16:34:28

local NPA_NameText={}
--config
local NPA_NameText_DefaultSetting={
		["NameText_Name"]=1,
		["NameText_Guild"]=0,
		["NameText_BoldHostile"]=1,
		["NameText_BoldNonHostile"]=1,
		["NameText_NameByFaction"]=1,

		["NameText_NameByClass"]=0,
		["NameText_HideGuildInInstance"]=1,

		["NameText_HideWithHealthBar"]=1,

		["NameText_Mark"]=0,
		["NameText_MarkTarget"]=1,
		["NameText_MarkFocus"]=1,
		["NameText_MarkMouseover"]=1,

		["NameText_MarkGuildMember"]=1,
		["NameText_MarkFriend"]=1,
		["NameText_MarkRaidMember"]=1,
		["NameText_MarkPartyMember"]=1,
		["NameText_MarkHideInInstance"]=1,

		["NameText_ColorTarget"]=0,
		["NameText_ColorMouseover"]=0,
		["NameText_ColorFocus"]=0,
		
		["NameText_MarkColorByType"]=1,
		["NameText_HideTotemName"]=1,

		["NameText_MarkPartyAsRaid"]=0,
		["NameText_Tapped"]=0,
		["NameText_FullName"]=0,

		["NameText_ShowPortrait"]=0,
		["NameText_ShowHostilePortrait"]=1,
		["NameText_ShowNonHostilePortrait"]=1,
		["NameText_ShowPartyPortrait"]=1,
		["NameText_ShowRaidPortrait"]=1,
		["NameText_ShowGuildPortrait"]=1,
		["NameText_ShowOnlyPlayerPortrait"]=0,

		["NameText_AutoHideGuild"]=0,

		["NameText_SeparateNameText"]=0,

		["NameText_ShowBorder"]=0,
		["NameText_ShowBackground"]=0,
		["NameText_ShowPVPFriendly"]=0,
		["NameText_ShowPVPHostile"]=0,
		
		["NameText_ShowPVPFlag"]=0,

		["NameText_HostilePlayerName"]=1,
		["NameText_NonHostilePlayerName"]=1,
		["NameText_HostileNonPlayerName"]=1,
		["NameText_NonHostileNonPlayerName"]=1,
		["NameText_QuestUnitName"]=1,
		["NameText_TargetName"]=1,
		["NameText_FocusName"]=1,
		["NameText_MouseoverName"]=1,


		["NameText_PVPFlagData"]={
			OffsetX=0,
			OffsetY=20,
			Height=15,
			Width=18,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\combaticon",
			TextureBlend="BLEND",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},


		["NameText_BorderData"]={
			OffsetX=0,
			OffsetY=10,
			Height=20,
			Width=140,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["NameText_BackgroundData"]={
			OffsetX=0,
			OffsetY=10,
			Height=20,
			Width=140,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["NameText_PortraitData"]={
			OffsetX=0,
			OffsetY=-50,
			Height=40,
			Width=40,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	

		["NameText_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["NameText_TextHostileData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["NameText_TextFriendlyData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=0,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["NameText_TextNeutralData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["NameText_TextTappedData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["NameText_TextPVPFriendlyData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["NameText_TextPVPHostileData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["NameText_GuildData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["NameText_MarkData"]={
			OffsetX=0,
			OffsetY=70,
			Height=30,
			Width=30,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\animated\\star-white@11@11@50",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

	}
local NPA_NameText_Config=NPA_NameText_DefaultSetting

function NPA_NameText:ResetConfig()
	NPA_Config["NameText"]=CopyTable(NPA_NameText_DefaultSetting)
end



-- get global functions
local pairs = pairs
local floor = floor
local table_insert = table.insert
local unpack=unpack


--main

local NPA_NameText_Frame={}


local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local BindPortrait=NPA_Core.BindPortrait
local UnbindPortrait=NPA_Core.UnbindPortrait

NPA_NameText_HideFilter={}

local function NPA_NameText_OnUpdate(_,self,guid,unitdata,_,guids,frame,hostile,isplayer,default,recentUpdated,_,isfriend,isguild,isparty,israid,isinstance)
	if(NPA_NameText_Config["NameText_HideWithHealthBar"]==1)then
		local healthbar=frame["HealthBar"]
		if(not (healthbar and healthbar:IsShown()))then
			self:Hide()
			return
		end
	end

	--alpha

	if((not default) or (NPA_NameText_Config["NameText_BoldHostile"]==1 and hostile==1) or
		(NPA_NameText_Config["NameText_BoldNonHostile"]==1 and hostile~=1))then
	
		self:SetAlpha(1)
	else
		self:SetAlpha(frame:GetAlpha())
	end


		
	--nametext
	local show
	for _,func in pairs(NPA_NameText_HideFilter) do
		if(func(frame,hostile,isplayer,guid,guids))then
			show=1
			break
		end
	end

	local class=frame["ClassIcon"]
	if(NPA_NameText_Config["NameText_Name"]~=1 or show~=1 or (NPA_NameText_Config["NameText_HideTotem"]==1 and class and class:IsShown() and class.IsTotem==1))then
			self.Name:Hide()
			self.HostileName:Hide()
			self.FriendlyName:Hide()
			self.NeutralName:Hide()
			self.TappedName:Hide()
			self.PVPFriendlyName:Hide()
			self.PVPHostileName:Hide()
	else
		--pvpflag

		if(isplayer==1 and unitdata and unitdata.IsPvP and NPA_NameText_Config["NameText_ShowPVPFlag"]==1)then
			self.PVPFlag:Show()
		else
			self.PVPFlag:Hide()
		end

		if(NPA_NameText_Config["NameText_SeparateNameText"]==1)then
			local nametext
			local text

			if(default)then
				if(isplayer==1 and unitdata and (not unitdata.IsPvP) and
					((NPA_NameText_Config["NameText_ShowPVPHostile"]==1 and hostile==1) or
					(NPA_NameText_Config["NameText_ShowPVPFriendly"]==1 and hostile~=1)))then
					
					if(hostile==1)then
						nametext=self.PVPHostileName
					else
						nametext=self.PVPFriendlyName
					end				

				elseif(NPA_NameText_Config["NameText_Tapped"]==1 and unitdata and unitdata.Tapped)then
					nametext=self.TappedName
				elseif(NPA_NameText_Config["NameText_NameByFaction"]==1)then
					if(hostile==1)then
						nametext=self.HostileName
					elseif(hostile==2)then
						nametext=self.NeutralName
					else
						nametext=self.FriendlyName
					end
				else
					nametext=self.Name
				end

				if(NPA_NameText_Config["NameText_NameByClass"]==1 and unitdata and isplayer==1)then
					local color=RAID_CLASS_COLORS[unitdata.ClassMark] or {r=1,g=1,b=0}
					nametext:SetTextColor(color.r*nametext.R,color.g*nametext.G,color.b*nametext.B)
				else
					nametext:SetTextColor(nametext.R,nametext.G,nametext.B)
				end

				if(NPA_NameText_Config["NameText_FullName"]==1 and unitdata and unitdata.PVPName)then
					text=unitdata.PVPName
				else
					text=default.NameText:GetText()
				end

			elseif(unitdata)then
				if(NPA_NameText_Config["NameText_Tapped"]==1 and unitdata.Tapped)then
					nametext=self.TappedName
				elseif(NPA_NameText_Config["NameText_NameByFaction"]==1)then
					if(unitdata.IsEnemy==1)then
						nametext=self.HostileName
					elseif(unitdata.IsFriend==1)then
						nametext=self.FriendlyName
					else
						nametext=self.NeutralName
					end
				else
					nametext=self.Name
				end

				if(NPA_NameText_Config["NameText_NameByClass"]==1 and isplayer==1)then
					local color=RAID_CLASS_COLORS[unitdata.ClassMark] or {r=1,g=1,b=0}
					nametext:SetTextColor(color.r,color.g,color.b)
				else
					nametext:SetTextColor(nametext.R,nametext.G,nametext.B)
				end

				if(NPA_NameText_Config["NameText_FullName"]==1 and unitdata.PVPName)then
					text=unitdata.PVPName
				else
					text=unitdata.Name
				end
			end

			if(guid~=0 and text)then
				if((NPA_NameText_Config["NameText_ColorTarget"]==1 and guid==guids.Target) or
					(NPA_NameText_Config["NameText_ColorMouseover"]==1 and guid==guids.Mouseover) or
					(NPA_NameText_Config["NameText_ColorFocus"]==1 and guid==guids.Focus))then

					text="|cffffff00"..text
				end
			end

			nametext:SetText(text)

			self.Name:Hide()		
			self.HostileName:Hide()
			self.FriendlyName:Hide()
			self.NeutralName:Hide()
			self.TappedName:Hide()
			self.PVPFriendlyName:Hide()
			self.PVPHostileName:Hide()
			nametext:Show()
		else
			self.HostileName:Hide()
			self.FriendlyName:Hide()
			self.NeutralName:Hide()
			self.TappedName:Hide()
			self.PVPFriendlyName:Hide()
			self.PVPHostileName:Hide()


			local nametext=self.Name
			local text

			if(default)then
				if(NPA_NameText_Config["NameText_Tapped"]==1 and unitdata and unitdata.Tapped)then
					nametext:SetTextColor(0.5,0.5,0.5)
				elseif(NPA_NameText_Config["NameText_NameByClass"]==1 and unitdata and isplayer==1)then
					local color=RAID_CLASS_COLORS[unitdata.ClassMark] or {r=1,g=1,b=0}
					nametext:SetTextColor(color.r*nametext.R,color.g*nametext.G,color.b*nametext.B)
				elseif(NPA_NameText_Config["NameText_NameByFaction"]==1)then
					if(hostile==1)then
						nametext:SetTextColor(nametext.R,0,0)
					elseif(hostile==2)then
						nametext:SetTextColor(nametext.R,nametext.G,0)
					else
						nametext:SetTextColor(0,nametext.G,0)
					end
				else
					nametext:SetTextColor(default.NameText:GetTextColor())
				end

				if(NPA_NameText_Config["NameText_FullName"]==1 and unitdata and unitdata.PVPName)then
					text=unitdata.PVPName
				else
					text=default.NameText:GetText()
				end
	
			elseif(unitdata)then
				if(NPA_NameText_Config["NameText_Tapped"]==1 and unitdata.Tapped)then
					nametext:SetTextColor(0.5,0.5,0.5)
				elseif(NPA_NameText_Config["NameText_NameByClass"]==1 and isplayer==1)then
					local color=RAID_CLASS_COLORS[unitdata.ClassMark] or {r=1,g=1,b=0}
					nametext:SetTextColor(color.r*nametext.R,color.g*nametext.G,color.b*nametext.B)
				elseif(NPA_NameText_Config["NameText_NameByFaction"]==1)then
					if(unitdata.IsEnemy==1)then
						nametext:SetTextColor(nametext.R,0,0)
					elseif(unitdata.IsFriend==1)then
						nametext:SetTextColor(0,nametext.G,0)
					else
						nametext:SetTextColor(nametext.R,nametext.G,0)
					end
				else
					nametext:SetTextColor(0.5*nametext.R,0.5*nametext.G,nametext.B)
				end
				if(NPA_NameText_Config["NameText_FullName"]==1 and unitdata.PVPName)then
					text=unitdata.PVPName
				else	
					text=unitdata.Name
				end
			end

			if(guid~=0 and text)then
				if((NPA_NameText_Config["NameText_ColorTarget"]==1 and guid==guids.Target) or
					(NPA_NameText_Config["NameText_ColorMouseover"]==1 and guid==guids.Mouseover) or
					(NPA_NameText_Config["NameText_ColorFocus"]==1 and guid==guids.Focus))then

					text="|cffffff00"..text
				end
			end

			nametext:SetText(text)
			nametext:Show()
		end
	end
	--guild

	if(unitdata and unitdata.Guild and NPA_NameText_Config["NameText_Guild"]==1 and 
		(NPA_NameText_Config["NameText_HideGuildInInstance"]~=1 or (not isinstance)) and
		(NPA_NameText_Config["NameText_AutoHideGuild"]~=1 or frame:GetAlpha()~=1))then

		local guildtext=self.Guild
		guildtext:SetText("<"..unitdata.Guild..">")
		if(isguild)then
			guildtext:SetTextColor(0.5*guildtext.R,guildtext.G,0.5*guildtext.B)
		else
			guildtext:SetTextColor(guildtext.R,guildtext.G,guildtext.B)
		end
		guildtext:Show()
	else
		self.Guild:Hide()
	end

	--mark

	local mark=self.Mark
	if(NPA_NameText_Config["NameText_Mark"]==1 and 
		((not isinstance) or NPA_NameText_Config["NameText_MarkHideInInstance"]~=1))then
		if(NPA_NameText_Config["NameText_MarkTarget"]==1 and guid and guid==guids.Target)then
			if(NPA_NameText_Config["NameText_MarkColorByType"]==1)then
				mark:SetVertexColor(mark.R,0,0)
			else
				mark:SetVertexColor(mark.R,mark.G,mark.B)
			end
			mark:Show()
		elseif(NPA_NameText_Config["NameText_MarkMouseover"]==1 and guid and guid==guids.Mouseover)then
			if(NPA_NameText_Config["NameText_MarkColorByType"]==1)then
				mark:SetVertexColor(mark.R*0.6,mark.G*0.6,0)
			else
				mark:SetVertexColor(mark.R,mark.G,mark.B)
			end
			mark:Show()
		elseif(NPA_NameText_Config["NameText_MarkFocus"]==1 and guid and guid==guids.Focus)then
			if(NPA_NameText_Config["NameText_MarkColorByType"]==1)then
				mark:SetVertexColor(mark.R,mark.G,0)
			else
				mark:SetVertexColor(mark.R,mark.G,mark.B)
			end
			mark:Show()
		elseif(isplayer==1)then
			if(NPA_NameText_Config["NameText_MarkFriend"]==1 and isfriend)then
				if(NPA_NameText_Config["NameText_MarkColorByType"]==1)then
					mark:SetVertexColor(0,mark.G,mark.B)
				else
					mark:SetVertexColor(mark.R,mark.G,mark.B)
				end
				mark:Show()
			elseif(NPA_NameText_Config["NameText_MarkPartyMember"]==1 and isparty and
				(NPA_NameText_Config["NameText_MarkPartyAsRaid"]~=1 or (not israid)))then
				if(NPA_NameText_Config["NameText_MarkColorByType"]==1)then
					mark:SetVertexColor(0,0,mark.B)
				else
					mark:SetVertexColor(mark.R,mark.G,mark.B)
				end
	
				mark:Show()
			elseif(NPA_NameText_Config["NameText_MarkRaidMember"]==1 and israid)then
				if(NPA_NameText_Config["NameText_MarkColorByType"]==1)then
					mark:SetVertexColor(mark.R,0.5*mark.G,0)
				else
					mark:SetVertexColor(mark.R,mark.G,mark.B)
				end
	
				mark:Show()
			elseif(NPA_NameText_Config["NameText_MarkGuildMember"]==1 and isguild)then
				if(NPA_NameText_Config["NameText_MarkColorByType"]==1)then
					mark:SetVertexColor(0,mark.G,0)
				else
					mark:SetVertexColor(mark.R,mark.G,mark.B)
				end
	
				mark:Show()
			else
				mark:Hide()
			end
		else
			mark:Hide()
		end
	else
		mark:Hide()
	end

	if(NPA_NameText_Config["NameText_ShowPortrait"]==1 and unitdata and (isplayer==1 or NPA_NameText_Config["NameText_ShowOnlyPlayerPortrait"]~=1))then
		if((hostile==1 and NPA_NameText_Config["NameText_ShowHostilePortrait"]==1) or 
			(hostile~=1 and NPA_NameText_Config["NameText_ShowNonHostilePortrait"]==1 and (not isparty) and (not israid) and not (isguild)) or
			(isparty and NPA_NameText_Config["NameText_ShowPartyPortrait"]==1) or
			(israid and NPA_NameText_Config["NameText_ShowRaidPortrait"]==1) or
			(isguild and NPA_NameText_Config["NameText_ShowGuildPortrait"]==1))then

			BindPortrait(guid,unitdata.Portrait,self,NPA_NameText_Config["NameText_PortraitData"])
		else
			UnbindPortrait(self)
		end
	else
		UnbindPortrait(self)
	end

	self:SetScale(frame:GetScale())
	self:Show()
end



local function NPA_NameText_SetFrame(frame)

	frame:Hide()
	local nametext=frame.Name

	ManageFont(nil,frame.Name,NPA_NameText_Config["NameText_TextData"],frame)
	ManageFont(nil,frame.Guild,NPA_NameText_Config["NameText_GuildData"],frame)
	ManageTexture(nil,frame.Mark,NPA_NameText_Config["NameText_MarkData"],frame)
	ManageTexture(nil,frame.PVPFlag,NPA_NameText_Config["NameText_PVPFlagData"],frame)

	ManageTexture(nil,frame.Border,NPA_NameText_Config["NameText_BorderData"],frame)
	ManageTexture(nil,frame.Background,NPA_NameText_Config["NameText_BackgroundData"],frame)

	if(NPA_NameText_Config["NameText_ShowBorder"]==1)then
		frame.Border:Show()
	else
		frame.Border:Hide()
	end

	if(NPA_NameText_Config["NameText_ShowBackground"]==1)then
		frame.Background:Show()
	else
		frame.Background:Hide()
	end

	ManageFont(nil,frame.HostileName,NPA_NameText_Config["NameText_TextHostileData"],frame)
	ManageFont(nil,frame.FriendlyName,NPA_NameText_Config["NameText_TextFriendlyData"],frame)
	ManageFont(nil,frame.NeutralName,NPA_NameText_Config["NameText_TextNeutralData"],frame)
	ManageFont(nil,frame.TappedName,NPA_NameText_Config["NameText_TextTappedData"],frame)
	ManageFont(nil,frame.PVPFriendlyName,NPA_NameText_Config["NameText_TextPVPFriendlyData"],frame)
	ManageFont(nil,frame.PVPHostileName,NPA_NameText_Config["NameText_TextPVPHostileData"],frame)

	frame.Name:Hide()
	frame.HostileName:Hide()
	frame.FriendlyName:Hide()
	frame.TappedName:Hide()
	frame.PVPFriendlyName:Hide()
	frame.Guild:Hide()
	frame.Mark:Hide()
	frame.PVPFlag:Hide()

	UnbindPortrait(frame)

end



local function NPA_NameText_HookFrame(frame)
	local nametextframe=CreateFrame("Frame","NPA_NameText_LayerFrame",frame:GetParent())
	nametextframe:SetPoint("CENTER",frame,"CENTER")
	nametextframe:SetWidth(1)
	nametextframe:SetHeight(1)
	nametextframe:Show()

	nametextframe:SetFrameStrata("TOOLTIP")

	local nametext=nametextframe:CreateFontString("NPA_NameText_Name","ARTWORK",nil)
	local guildtext=nametextframe:CreateFontString("NPA_NameText_Guild","ARTWORK",nil)
	local mark=nametextframe:CreateTexture("NPA_NameText_Mark","BORDER",nil)

	local namehostiletext=nametextframe:CreateFontString("NPA_NameText_HostileName","ARTWORK",nil)
	local namefriendlytext=nametextframe:CreateFontString("NPA_NameText_FriendlyName","ARTWORK",nil)
	local nameneutraltext=nametextframe:CreateFontString("NPA_NameText_NeutralName","ARTWORK",nil)
	local nametappedtext=nametextframe:CreateFontString("NPA_NameText_TappedName","ARTWORK",nil)
	local namepvpfriendlytext=nametextframe:CreateFontString("NPA_NameText_PVPFriendlyName","ARTWORK",nil)
	local namepvphostiletext=nametextframe:CreateFontString("NPA_NameText_PVPHostileName","ARTWORK",nil)

	local border=nametextframe:CreateTexture("NPA_HealthBar_Border","OVERLAY",nil)
	local background=nametextframe:CreateTexture("NPA_HealthBar_Background","BACKGROUND",nil)
	
	local pvpflag=nametextframe:CreateTexture("NPA_NameText_PvPFlag","BORDER",nil)

	nametextframe.Border=border
	nametextframe.Background=background

	nametextframe.HostileName=namehostiletext
	nametextframe.FriendlyName=namefriendlytext
	nametextframe.NeutralName=nameneutraltext
	nametextframe.TappedName=nametappedtext
	nametextframe.PVPFriendlyName=namepvpfriendlytext
	nametextframe.PVPHostileName=namepvphostiletext

	nametextframe.Name=nametext
	nametextframe.Guild=guildtext
	nametextframe.Mark=mark
	nametextframe.Portrait=nil
	
	nametextframe.PVPFlag=pvpflag

	nametextframe.Parent=frame
	nametextframe:Hide()

	nametextframe:HookScript("OnHide",function(self)
		if(self.Portrait)then
			self.Portrait:Hide()
			self.Portrait=nil
		end
		end)


	table_insert(NPA_NameText_Frame,nametextframe)

	NPA_NameText_SetFrame(nametextframe)
	
	frame["NameText"]=nametextframe
	
	return framedata
end

local function NPA_NameText_BuildHideFilter()
	NPA_NameText_HideFilter={}

	if(NPA_NameText_Config["NameText_HostilePlayerName"]==1)then
		NPA_NameText_HideFilter["HostilePlayerName"]=function(_,hostile,isplayer)
				if(isplayer==1 and hostile~=0)then
					return 1
				end
			end
	end
	
	if(NPA_NameText_Config["NameText_NonHostilePlayerName"]==1)then
		NPA_NameText_HideFilter["NonHostilePlayerName"]=function(_,hostile,isplayer)
				if(isplayer==1 and hostile~=1)then
					return 1
				end
			end
	end

	if(NPA_NameText_Config["NameText_HostileNonPlayerName"]==1)then
		NPA_NameText_HideFilter["HostileNonPlayerName"]=function(_,hostile,isplayer)
				if((not (isplayer==1)) and hostile~=0)then
					return 1
				end
			end
	end

	if(NPA_NameText_Config["NameText_NonHostileNonPlayerName"]==1)then
		NPA_NameText_HideFilter["NonHostileNonPlayerName"]=function(_,hostile,isplayer)
				if((not (isplayer==1)) and hostile~=1)then
					return 1
				end
			end
	end

	if(NPA_NameText_Config["NameText_QuestUnitName"]==1)then
		NPA_NameText_HideFilter["QuestUnitName"]=function(frame)
				local questmark=frame["QuestMark"]
				if(questmark and questmark:IsShown())then
					return 1
				end
			end
	end

	if(NPA_NameText_Config["NameText_QuestUnitName"]==1)then
		NPA_NameText_HideFilter["QuestUnitName"]=function(frame)
				local questmark=frame["QuestMark"]
				if(questmark and questmark:IsShown())then
					return 1
				end
			end
	end
	if(NPA_NameText_Config["NameText_TargetName"]==1)then
		NPA_NameText_HideFilter["TargetName"]=function(_,_,_,guid,guids)
				if(guid==guids.Target)then
					return 1
				end
			end
	end
	if(NPA_NameText_Config["NameText_FocusName"]==1)then
		NPA_NameText_HideFilter["FocusName"]=function(_,_,_,guid,guids)
				if(guid==guids.Focus)then
					return 1
				end
			end
	end

	if(NPA_NameText_Config["NameText_MouseoverName"]==1)then
		NPA_NameText_HideFilter["MouseoverName"]=function(_,_,_,guid,guids)
				if(guid==guids.Mouseover)then
					return 1
				end
			end
	end
end



function NPA_NameText:ApplyConfig()
	NPA_Core:CheckConfigEntry("NameText",NPA_NameText_DefaultSetting)

	NPA_NameText_Config=NPA_Config["NameText"]

	for _,frame in pairs(NPA_NameText_Frame) do
		NPA_NameText_SetFrame(frame)
	end


	if(NPA_NameText_Config["NameText_ShowPortrait"]==1)then
		NPA_Core:RequestPortrait("NameText")
	else
		NPA_Core:UnrequestPortrait("NameText")
	end

	NPA_NameText_BuildHideFilter()

end

NPA_Core:AddHook("NameText",NPA_NameText_HookFrame)
NPA_Core:AddModule("NameText",NPA_NameText)
NPA_Core:HookUpdate("NameText",NPA_NameText_OnUpdate,1)
