﻿-- Author      : Nogarder
-- Create Date : 2010/7/7 18:46:38

local NPA_ManaBar={}
--config
local NPA_ManaBar_DefaultSetting={
		["ManaBar_OffsetX"]=0,
		["ManaBar_OffsetY"]=-10,
		
		["ManaBar_PowerText"]=1,
		["ManaBar_PowerMax"]=0,
		["ManaBar_PowerPercent"]=1,
		
		["ManaBar_ShowBorder"]=1,
		["ManaBar_Short"]=1,
		["ManaBar_Break"]=1,

		["ManaBar_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ManaBar_BorderData"]={
			OffsetX=0,
			OffsetY=0,
			Height=18,
			Width=126,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["ManaBar_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["ManaBar_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	}

local NPA_ManaBar_Config=NPA_ManaBar_DefaultSetting

function NPA_ManaBar:ResetConfig()
	NPA_Config["ManaBar"]=CopyTable(NPA_ManaBar_DefaultSetting)
end


--global functions
local pairs = pairs
local floor = floor
local table_insert = table.insert
local unpack=unpack

local GetTime = GetTime

local NPA_ManaBar_Frame={}

--bar color data
local NPA_ManaBar_BarColor={
	[0]={r=0,g=0,b=1},
	[1]={r=1,g=0,b=0},
	[2]={r=0.9,g=0.5,b=0.2},
	[3]={r=1,g=1,b=0},
	[6]={r=0,g=0.8,b=0.9}
}
--main


local function NPA_ManaBar_ShortNumber(value)
	local ret
	local short=floor(value/100000000)/10
	if(short>1)then
		return (short).."g"
	else
		short=floor(value/100000)/10
		if(short>1)then
			return (short).."m"
		else
			short=floor(value/100)/10
			if(short>1)then
				return (short).."k"
			else
				return value
			end
		end
	end
end

local function NPA_ManaBar_BreakNumber(value)
	local str=""
	
	local bre=floor(value/1000000000)
	if(bre>0)then
		value=value-bre*1000000000
		str=bre..","
	end
	bre=floor(value/1000000)
	if(bre>0)then
		value=value-bre*1000000
		str=str..bre..","
	end
	bre=floor(value/1000)
	if(bre>0)then
		value=value-bre*1000
		str=str..bre..","
	end
	str=str..value

	return str
end

local ManageBar=NPA_Core.ManageBar

local function NPA_ManaBar_OnUpdate(nTime,self,guid,unitdata,_,_,frame,_,_,_,recentUpdated)
	local classicon=frame["ClassIcon"]
	if((not recentUpdated) or (classicon and classicon.IsTotem==1))then
		self:Hide()
		return
	end

	local value=unitdata.Mana or 0
	local max=unitdata.ManaMax or 0
	local powertype=unitdata.PowerType or 10

	local percent
	if(max==0)then
		percent=0
	else
		percent=(value)/(max)
	end

	local bar=self.Bar
	bar.Percent=percent
	ManageBar(nil,bar)

	local typecolor=NPA_ManaBar_BarColor[powertype]
	if(typecolor)then
		bar:SetVertexColor(typecolor.r*bar.R,typecolor.g*bar.G,typecolor.b*bar.B)
	else
		bar:SetVertexColor(bar.R,bar.G,bar.B)
	end

	local str=nil
	if(NPA_ManaBar_Config["ManaBar_PowerText"]==1)then
		if(NPA_ManaBar_Config["ManaBar_Short"]==1)then
			value=NPA_ManaBar_ShortNumber(value)
		elseif(NPA_ManaBar_Config["ManaBar_Break"]==1)then
			value=NPA_ManaBar_BreakNumber(value)
		end
		str=value
	end
	if(NPA_ManaBar_Config["ManaBar_PowerMax"]==1)then
		if(NPA_ManaBar_Config["ManaBar_Short"]==1)then
			value=NPA_ManaBar_ShortNumber(max)
		elseif(NPA_ManaBar_Config["ManaBar_Break"]==1)then
			value=NPA_ManaBar_BreakNumber(max)
		end
		if(str==nil)then
			str=max
		else
			str=str.."/"..max
		end
	end
	if(NPA_ManaBar_Config["ManaBar_PowerPercent"]==1)then
		local bpercent=floor(percent*100).."%"
		if(str==nil)then
			str=bpercent
		else
			str=str.."("..bpercent..")"
		end
	end

	self.Text:SetText(str)

	self:Show()
end	


local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_ManaBar_SetFrame(main)
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_ManaBar_Config["ManaBar_OffsetX"],NPA_ManaBar_Config["ManaBar_OffsetY"])

	ManageTexture(nil,main.Bar,NPA_ManaBar_Config["ManaBar_BarData"],main,1)
	ManageTexture(nil,main.Background,NPA_ManaBar_Config["ManaBar_BackgroundData"],main)
	ManageTexture(nil,main.Border,NPA_ManaBar_Config["ManaBar_BorderData"],main)
	ManageFont(nil,main.Text,NPA_ManaBar_Config["ManaBar_TextData"],main)
end

local function NPA_ManaBar_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_ManaBar_MainFrame",frame)
	main:SetHeight(1)
	main:SetWidth(1)
	main:Hide()
	main:SetFrameStrata("LOW")
	
	local bar=main:CreateTexture("NPA_ManaBar_Bar","ARTWORK",nil)
	bar:Show()

	local background=main:CreateTexture("NPA_ManaBar_Background","BACKGROUND",nil)
	background:Show()

	local barborder=main:CreateTexture("NPA_ManaBar_BarBorder","OVERLAY",nil)
	barborder:Show()

	local text=main:CreateFontString("NPA_ManaBar_Text","OVERLAY",nil)
	text:Show()

	main.Text=text
	main.Border=barborder
	main.Background=background
	main.Bar=bar


	NPA_ManaBar_SetFrame(main)
	table_insert(NPA_ManaBar_Frame,main)

	frame["ManaBar"]=main

	
end

function NPA_ManaBar:ApplyConfig()
	NPA_Core:CheckConfigEntry("ManaBar",NPA_ManaBar_DefaultSetting)

	NPA_ManaBar_Config=NPA_Config["ManaBar"]

	for _,main in pairs(NPA_ManaBar_Frame) do
		NPA_ManaBar_SetFrame(main)
	end

end


NPA_Core:AddHook("ManaBar",NPA_ManaBar_HookFrame)
NPA_Core:AddModule("ManaBar",NPA_ManaBar)
NPA_Core:HookUpdate("ManaBar",NPA_ManaBar_OnUpdate,2)