﻿-- Author      : Nogarder
-- Create Date : 2010/7/1 16:34:28

local NPA_HealthBar={}
--config
local NPA_HealthBar_DefaultSetting={
		["HealthBar_UpdateInterval"]=0.03,

	
		["HealthBar_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		---------------------------------------------

		["HealthBar_HostilePlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_HostileNonPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_FriendlyPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_FriendlyNonPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_NeutralNonPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_NeutralPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_TankingPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_HighThreatPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_LowThreatPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_HighThreatNonPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_LowThreatNonPlayer_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_TappedMob_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

	------------------------------
		["HealthBar_CustomBarData"]={
			["HostilePlayer"]=0,
			["FriendlyPlayer"]=0,
			["FriendlyNonPlayer"]=0,
			["HostileNonPlayer"]=0,
			["NeutralPlayer"]=0,
			["NeutralNonPlayer"]=0,
			["HighThreatPlayer"]=0,
			["HighThreatNonPlayer"]=0,
			["LowThreatPlayer"]=0,
			["LowThreatNonPlayer"]=0,
			["TankingPlayer"]=0,
			["TappedMob"]=0,
			DeepCheck=1,
			},

		["HealthBar_EnableCustomBar"]=0,

		------------------

		--0=by health
		--1=by faction
		--2=by class
		--3=dont change

		["HealthBar_ColorHostilePlayerBarData"]=2,
		["HealthBar_ColorNeutralPlayerBarData"]=2,
		["HealthBar_ColorFriendlyPlayerBarData"]=2,
		["HealthBar_ColorHostileNonPlayerBarData"]=1,
		["HealthBar_ColorFriendlyNonPlayerBarData"]=1,
		["HealthBar_ColorNeutralNonPlayerBarData"]=1,

		["HealthBar_DontColorTappedMob"]=1,
	------------------------------

		["HealthBar_BorderData"]={
			OffsetX=0,
			OffsetY=0,
			Height=18,
			Width=126,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
	
		["HealthBar_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=0,
			Green=0,
			Blue=0,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_HighlightData"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_FocusHighlightData"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_MouseoverHighlightData"]={
			OffsetX=0,
			OffsetY=0,
			Height=28,
			Width=136,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_LowHealthData"]={
			OffsetX=0,
			OffsetY=0,
			Height=40,
			Width=140,
			Red=1,
			Green=0,
			Blue=0,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\glow",
			TextureBlend="ADD",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},


		["HealthBar_EliteData"]={
			OffsetX=-70,
			OffsetY=-3,
			Height=26,
			Width=65,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\EliteNameplateIcon",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=1,
			Right=0,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},


		["HealthBar_BossData"]={
			OffsetX=50,
			OffsetY=0,
			Height=15,
			Width=15,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-TargetingFrame-Skull",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["HealthBar_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["HealthBar_LevelTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=50,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},	
		["HealthBar_OffsetX"]=0,
		["HealthBar_OffsetY"]=0,

		["HealthBar_HealthText"]=1,
		["HealthBar_HealthMax"]=0,
		["HealthBar_HealthPercent"]=1,
		["HealthBar_LevelText"]=1,
		
		["HealthBar_BreakDown"]=1,
		["HealthBar_Short"]=1,

		["HealthBar_HideTotem"]=1,

		["HealthBar_Elite"]=1,
		["HealthBar_LeftElite"]=1,
		["HealthBar_BossIcon"]=1,

		["HealthBar_PercentMarker"]=1,
		["HealthBar_ColorTextByClass"]=0,
		["HealthBar_ColorTextByHealth"]=0,
		
		["HealthBar_AlwaysHide"]=1,
		["HealthBar_ShowLowHealth"]=0,
		["HealthBar_LowHealthPercent"]=25,

		["HealthBar_SeparateHighlight"]=0,
		["HealthBar_ColorByFaction"]=0,
	}
local NPA_HealthBar_Config=NPA_HealthBar_DefaultSetting

function NPA_HealthBar:ResetConfig()
	NPA_Config["HealthBar"]=CopyTable(NPA_HealthBar_DefaultSetting)
end


-- get global functions
local pairs = pairs
local floor = floor
local table_insert = table.insert
local unpack=unpack
local table_getn=table.getn
local table_sort=table.sort


--main

local NPA_HealthBar_Frame={}
local NPA_HealthBar_CustomBarFunc={}
local NPA_HealthBar_ColorBarFuncList={
	[0]={
		[0]=4,
		[1]=4,
		},
	[1]={
		[0]=4,
		[1]=4,
		},
	[2]={
		[0]=4,
		[1]=4,
		},
	}
local function NPA_HealthBar_ShortNumber(value)
	local ret
	local short=floor(value/100000000)/10
	if(short>1)then
		return (short).."g"
	else
		short=floor(value/100000)/10
		if(short>1)then
			return (short).."m"
		else
			short=floor(value/100)/10
			if(short>1)then
				return (short).."k"
			else
				return value
			end
		end
	end
end

local function NPA_HealthBar_BreakNumber(value)
	local str=""
	
	local bre=floor(value/1000000000)
	if(bre>0)then
		value=value-bre*1000000000
		str=bre..","
	end
	bre=floor(value/1000000)
	if(bre>0)then
		value=value-bre*1000000
		str=str..bre..","
	end
	bre=floor(value/1000)
	if(bre>0)then
		value=value-bre*1000
		str=str..bre..","
	end
	str=str..value

	return str
end

local NPA_ManageBar=NPA_Core.ManageBar

local function NPA_HealthBar_UpdateValue(value,max,mainframe,onupdate)
	if(value==nil or max==nil or max==0)then
		value=1
		max=1
	end
	local percent=floor(value/max*1000)/1000

	local bar=mainframe.HealthBar

	if(onupdate and percent==bar.Percent)then
		return
	end
	bar.Percent=percent

	NPA_ManageBar(nil,bar)

	local str=nil

	if(NPA_HealthBar_Config["HealthBar_HealthText"]==1)then
		if(NPA_HealthBar_Config["HealthBar_Short"]==1)then
			value=NPA_HealthBar_ShortNumber(value)
		elseif(NPA_HealthBar_Config["HealthBar_BreakDown"]==1)then
			value=NPA_HealthBar_BreakNumber(value)
		end
		str=value

	end

	if(NPA_HealthBar_Config["HealthBar_HealthMax"]==1)then
		if(NPA_HealthBar_Config["HealthBar_Short"]==1)then
			max=NPA_HealthBar_ShortNumber(max)
		elseif(NPA_HealthBar_Config["HealthBar_BreakDown"]==1)then
			max=NPA_HealthBar_BreakNumber(max)
		end

		str=value
		if(str==nil)then
			str=max
		else
			str=str.."/"..max
		end
	end

	if(NPA_HealthBar_Config["HealthBar_HealthPercent"]==1)then
		if(str==nil)then
			str=floor(percent*100)
			if(NPA_HealthBar_Config["HealthBar_PercentMarker"]==1)then
				str=str.."%"
			end
		else
			if(NPA_HealthBar_Config["HealthBar_PercentMarker"]==1)then
				str=str.." ("..floor(percent*100).."%)"
			else
				str=str.." ("..floor(percent*100)..")"
			end
		end
	end


	--colored by health
	local ht=mainframe.Text
	ht:SetText(str)
	if(NPA_HealthBar_Config["HealthBar_ColorTextByHealth"]==1)then
		ht:SetTextColor((1-percent)*ht.R,percent*ht.G,0,1)
	end

	--lowhealth warning
	if(NPA_HealthBar_Config["HealthBar_ShowLowHealth"]==1 and percent<=NPA_HealthBar_Config["HealthBar_LowHealthPercent"]/100)then
		mainframe.LowHealth:Show()
	else
		mainframe.LowHealth:Hide()
	end

end

local function NPA_HealthBar_OnValueChanged(frame)
	-- --healthbar
	local value=frame:GetValue()
	local _,max =frame:GetMinMaxValues()

	NPA_HealthBar_UpdateValue(value,max,frame.NPAHook)
end


local function NPA_HealthBar_ReplaceDefault(default,plate,hostile)
	if(NPA_HealthBar_Config["HealthBar_BossIcon"]==1 and default.BossIcon:IsShown())then
		plate.LevelText:Hide()
		plate.Boss:Show()
	else
		plate.Boss:Hide()

		if(NPA_HealthBar_Config["HealthBar_LevelText"]==1)then
			local leveltext=default.LevelText
			local lt=plate.LevelText
			lt:SetText(leveltext:GetText())
			local r,g,b=leveltext:GetTextColor()
			lt:SetTextColor(r*lt.R,g*lt.G,b*lt.B)
			lt:Show()
		else
			plate.LevelText:Hide()
		end
	end

	--highlight
	local highlight=default.Highlight
	if(highlight:IsShown())then
		plate.Highlight:Show()
	else
		plate.Highlight:Hide()
	end

	--elite
	if(NPA_HealthBar_Config["HealthBar_Elite"]==1 and default.StateIcon:IsShown())then
		plate.Elite:Show()
	else
		plate.Elite:Hide()
	end

		
end


local function NPA_HealthBar_CheckHighlight(guid,guids,self)
	if(not guid)then
		return
	end

	if(NPA_HealthBar_Config["HealthBar_SeparateHighlight"]==1)then
		if(guid==guids.Target)then
			self.Highlight:Show()
			self.MouseoverHighlight:Hide()
			self.FocusHighlight:Hide()
		elseif(guid==guids.Mouseover)then
			self.Highlight:Hide()
			self.MouseoverHighlight:Show()
			self.FocusHighlight:Hide()
		elseif(guid==guids.Focus)then
			self.Highlight:Hide()
			self.MouseoverHighlight:Hide()
			self.FocusHighlight:Show()
		else
			self.Highlight:Hide()
			self.MouseoverHighlight:Hide()
			self.FocusHighlight:Hide()
		end
	else
		self.MouseoverHighlight:Hide()
		self.FocusHighlight:Hide()

		if(guid==guids.Target or guid==guids.Mouseover)then
			self.Highlight:Show()
		else
			self.Highlight:Hide()
		end
	end
end

local NPA_HealthBar_ColorBarFunc={
		--0=by health
		--1=by faction
		--2=by class
		--3=don't change
		--4=by default
		[0]=function(healthbar,_,unitdata,_,_,_,_,default,_,recentGuessed)
				local percent
				if(default)then
					local defaultbar=default.HealthBar
					local value=defaultbar:GetValue()
					local _,max =defaultbar:GetMinMaxValues()
					percent=value/(max+0.1)
				elseif(recentGuessed)then
					percent=healthbar.Percent
				else
					healthbar:SetVertexColor(0.5*healthbar.R,0.5*healthbar.G,0.5*healthbar.B)
					return
				end
				healthbar:SetVertexColor((1-percent)*healthbar.R,percent*healthbar.G,0)
			end,
		[1]=function(healthbar,_,_,_,_,hostile)
				if(hostile==1)then
					healthbar:SetVertexColor(healthbar.R,0,0)
				elseif(hostile==0)then
					healthbar:SetVertexColor(0,healthbar.G,0)
				else
					healthbar:SetVertexColor(healthbar.R,healthbar.G,0)
				end
			end,
		[2]=function(healthbar,_,unitdata,_,_,_,_,default,_,recentGuessed)
				if(unitdata and unitdata.IsPlayer==1)then
					local color=RAID_CLASS_COLORS[unitdata.ClassMark] or {r=0.5,b=0.5,g=0.5}
					healthbar:SetVertexColor(color.r*healthbar.R,color.g*healthbar.G,color.b*healthbar.B)
				elseif(default)then
					local r,g,b=default.HealthBar:GetStatusBarColor()
					healthbar:SetVertexColor(r*healthbar.R,g*healthbar.G,b*healthbar.B)
				else
					healthbar:SetVertexColor(healthbar.R,healthbar.G,healthbar.B)
				end
			end,
		[3]=function(healthbar)
				healthbar:SetVertexColor(healthbar.R,healthbar.G,healthbar.B)
			end,
		[4]=function(healthbar,_,_,_,_,_,_,default)
				local r,g,b=default.HealthBar:GetStatusBarColor()
				healthbar:SetVertexColor(r*healthbar.R,g*healthbar.G,b*healthbar.B)
			end
	}


	
local function NPA_HealthBar_OnUpdate(_,self,guid,unitdata,_,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed,_,_,_,_,_,_,_,_,threat)
	local classicon=frame["ClassIcon"]
	if(classicon and classicon.IsTotem==1 and NPA_HealthBar_Config["HealthBar_HideTotem"]==1 and (NPA_HealthBar_Config["HealthBar_AlwaysHide"]==1 or (guid~=guids.Target and guid~=guids.Mouseover)))then
		self:Hide()
		return
	elseif(default)then
		NPA_HealthBar_ReplaceDefault(default,self,hostile)
		NPA_HealthBar_CheckHighlight(guid,guids,self)
	elseif(unitdata)then
		NPA_HealthBar_CheckHighlight(guid,guids,self)

		NPA_HealthBar_UpdateValue(unitdata.GuessedHealth,unitdata.HealthMax,self,1)
	
		if((NPA_HealthBar_Config["HealthBar_BossIcon"]==1 and unitdata.Classification=="worldboss") or unitdata.Level==-1)then
			self.LevelText:Hide()
			self.Boss:Show()
		else
			self.Boss:Hide()

			if(NPA_HealthBar_Config["HealthBar_LevelText"]==1)then
				local lt=self.LevelText
				lt:SetText(unitdata.Level)
				lt:SetTextColor(lt.R,lt.G,lt.B)
				lt:Show()
			else
				self.LevelText:Hide()
			end
		end

		--elite
		if(NPA_HealthBar_Config["HealthBar_Elite"]==1 and (unitdata.Classification=="elite" or unitdata.Classification=="worldboss"))then
			self.Elite:Show()
		else
			self.Elite:Hide()
		end
	else
		self:Hide()
		return
	end

	------------

		--set bar
	local ls=self.LastState
	local tapped
	if(unitdata)then
		tapped=unitdata.Tapped
	end
	if(ls.Hostile~=hostile or ls.IsPlayer~=isplayer or ls.Threat~=threat or ls.Tapped~=tapped)then
		for i=1,NPA_HealthBar_CustomBarFunc.Max do
			if(NPA_HealthBar_CustomBarFunc[i](self,guid,unitdata,_,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed,_,_,_,_,_,_,_,_,threat))then
				ls.Hostile=hostile
				ls.IsPlayer=isplayer
				ls.Threat=threat
				ls.Tapped=tapped
				NPA_ManageBar(nil,self.HealthBar)
				break
			end
		end
	end
	--------------
		
	if(not (NPA_HealthBar_Config["HealthBar_DontColorTappedMob"]==1 and tapped==1) and
		NPA_HealthBar_ColorBarFuncList)then

		local index=NPA_HealthBar_ColorBarFuncList[hostile][isplayer]
		NPA_HealthBar_ColorBarFunc[index](self.HealthBar,guid,unitdata,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed)
	end


	--healthtext
	if(NPA_HealthBar_Config["HealthBar_ColorHealthByClass"]==1 and isplayer)then
		local ht=self.Text
		local color=RAID_CLASS_COLORS[unitdata.ClassMark] or {r=1,b=1,g=1}
		ht:SetTextColor(color.r*ht.R,color.g*ht.G,color.b*ht.B)
	end


	--background
	if(NPA_HealthBar_Config["HealthBar_ColorByFaction"]==1)then
		local bg=self.Background
		if(hostile==1)then
			bg:SetVertexColor(bg.R,0,0)
		elseif(hostile==2)then
			bg:SetVertexColor(bg.R,bg.G,0)
		else
			bg:SetVertexColor(0,bg.G,0)
		end
	end

	self:Show()
end


local function NPA_HealthBar_OnShow(frame)
	NPA_HealthBar_OnValueChanged(frame)
	frame:Hide()
end


local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager


local function NPA_HealthBar_SetFrame(mainframe)
	mainframe.LastState={
		Hostile=-1,
		IsPlayer=-1,
		Threat=-1,
		Tapped=-1}

	mainframe:SetPoint("CENTER",mainframe:GetParent(),"CENTER",NPA_HealthBar_Config["HealthBar_OffsetX"],NPA_HealthBar_Config["HealthBar_OffsetY"])

	ManageTexture(nil,mainframe.HealthBar,NPA_HealthBar_Config["HealthBar_BarData"],mainframe,1)

	ManageTexture(nil,mainframe.Border,NPA_HealthBar_Config["HealthBar_BorderData"],mainframe)

	ManageTexture(nil,mainframe.Highlight,NPA_HealthBar_Config["HealthBar_HighlightData"],mainframe)
	ManageTexture(nil,mainframe.LowHealth,NPA_HealthBar_Config["HealthBar_LowHealthData"],mainframe)

	ManageTexture(nil,mainframe.FocusHighlight,NPA_HealthBar_Config["HealthBar_FocusHighlightData"],mainframe)
	ManageTexture(nil,mainframe.MouseoverHighlight,NPA_HealthBar_Config["HealthBar_MouseoverHighlightData"],mainframe)


	ManageTexture(nil,mainframe.Elite,NPA_HealthBar_Config["HealthBar_EliteData"],mainframe)
		
	ManageTexture(nil,mainframe.Boss,NPA_HealthBar_Config["HealthBar_BossData"],mainframe)
	ManageTexture(nil,mainframe.Background,NPA_HealthBar_Config["HealthBar_BackgroundData"],mainframe)
	
	ManageFont(nil,mainframe.Text,NPA_HealthBar_Config["HealthBar_TextData"],mainframe)
	ManageFont(nil,mainframe.LevelText,NPA_HealthBar_Config["HealthBar_LevelTextData"],mainframe)

end

local function NPA_HealthBar_HookFrame(frame)
	local mainframe=CreateFrame("Frame","NPA_HealthBar_MainFrame",frame)
	mainframe:SetHeight(1)
	mainframe:SetWidth(1)
	mainframe:SetPoint("CENTER",frame,"CENTER",0,0)
	mainframe:SetFrameStrata("LOW")
	mainframe:Hide()

	--create frame
	--use default for now


	local bar=mainframe:CreateTexture("NPA_HealthBar_Bar","BORDER",nil)
	bar:Show()
	
	local background=mainframe:CreateTexture("NPA_HealthBar_Background","BACKGROUND",nil)
	
	local barhighlight=mainframe:CreateTexture("NPA_HealthBar_Highlight","ARTWORK",nil)
	barhighlight:Hide()

	local mouseoverhighlight=mainframe:CreateTexture("NPA_HealthBar_MouseoverHighlight","ARTWORK",nil)
	mouseoverhighlight:Hide()

	local focushighlight=mainframe:CreateTexture("NPA_HealthBar_FocusHighlight","ARTWORK",nil)	
	focushighlight:Hide()

	local lowhealth=mainframe:CreateTexture("NPA_HealthBar_LowHealth","ARTWORK",nil)
	lowhealth:Hide()

	local overlay=mainframe:CreateTexture("NPA_HealthBar_HealthBarOverlay","ARTWORK",nil)
	overlay:Show()
	
	local healthtext=mainframe:CreateFontString("NPA_HealthBar_Text","OVERLAY",nil)
	healthtext:Show()
	
	local leveltext=mainframe:CreateFontString("NPA_HealthBar_LevelText","OVERLAY",nil)
	leveltext:Hide()


	local elite=mainframe:CreateTexture("NPA_HealthBar_Elite","OVERLAY",nil)
	elite:Hide()

	local boss=mainframe:CreateTexture("NPA_HealthBar_Boss","OVERLAY",nil)
	boss:Hide()
	
	mainframe.HealthBar=bar
	mainframe.Text=healthtext
	mainframe.LevelText=leveltext
	mainframe.Highlight=barhighlight
	mainframe.FocusHighlight=focushighlight
	mainframe.MouseoverHighlight=mouseoverhighlight


	mainframe.Border=overlay
	mainframe.Elite=elite
	mainframe.Boss=boss
	mainframe.Background=background
	mainframe.LowHealth=lowhealth

	NPA_HealthBar_SetFrame(mainframe)
	table_insert(NPA_HealthBar_Frame,mainframe)


	--disable default
	local default=frame.Default
	if(default)then
		default.SpellIcon:SetTexCoord(0,0,0,0)

		default.Overlay:SetWidth(0)
		default.Overlay:SetTexCoord(0,0,0,0)
		default.Overlay:SetTexture(nil)

		default.Highlight:SetTexture(nil)

		default.NameText:SetWidth(0.1)
		default.LevelText:SetWidth(0.1)

		default.BossIcon:SetTexture(nil)
		default.StateIcon:SetTexture(nil)

		default.NativeGlow:SetTexture(nil)

		default.HealthBar:SetWidth(0.1)

		--hook scripts
		local bar=default.HealthBar
		bar.NPAHook=mainframe
		bar:HookScript("OnValueChanged",NPA_HealthBar_OnValueChanged)
		bar:HookScript("OnShow",NPA_HealthBar_OnShow)
		bar:Hide()
		NPA_HealthBar_OnValueChanged(bar)
	end

	--update
	
	frame["HealthBar"]=mainframe
	
end

local function NPA_HealthBar_BuildColorBarFunc()
	-- index=[hostile]  [player]
	--[0][0]=frienly + non-player
	--[0][1]=frienly + player
	--[1][1]=hostile + player
	NPA_HealthBar_ColorBarFuncList={
		[0]={
			[0]=NPA_HealthBar_Config["HealthBar_ColorFriendlyNonPlayerBarData"],
			[1]=NPA_HealthBar_Config["HealthBar_ColorFriendlyPlayerBarData"],
			},
		[1]={
			[0]=NPA_HealthBar_Config["HealthBar_ColorHostileNonPlayerBarData"],
			[1]=NPA_HealthBar_Config["HealthBar_ColorHostilePlayerBarData"],
			},
		[2]={
			[0]=NPA_HealthBar_Config["HealthBar_ColorNeutralNonPlayerBarData"],
			[1]=NPA_HealthBar_Config["HealthBar_ColorNeutralPlayerBarData"],
			},
		}
end

local function NPA_HealthBar_BuildCustomBarFunc()
	if(NPA_HealthBar_Config["HealthBar_EnableCustomBar"]~=1)then
		NPA_HealthBar_CustomBarFunc={Max=0}
		return
	end

	local sortedtable=CopyTable(NPA_HealthBar_Config["HealthBar_CustomBarData"])
	for name,value in pairs(sortedtable)do
		if(name=="DeepCheck" or value==0)then
			sortedtable[name]=nil
		end
	end
	table_sort(sortedtable)

	NPA_HealthBar_CustomBarFunc={}

	local count=0

	for name,value in pairs(sortedtable) do
		count=count+1
		if(name=="HostilePlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,hostile,isplayer)
				if(hostile==1 and isplayer==1)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_HostilePlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="FriendlyPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,hostile,isplayer)
				if(hostile==0 and isplayer==1)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_FriendlyPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="FriendlyNonPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,hostile,isplayer)
				if(hostile==0 and isplayer==0)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_FriendlyNonPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="HostileNonPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,hostile,isplayer)
				if(hostile==1 and isplayer==0)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_HostileNonPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="NeutralPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,hostile,isplayer)
				if(hostile==2 and isplayer==1)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_NeutralPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="NeutralNonPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,hostile,isplayer)
				if(hostile==2 and isplayer==0)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_NeutralNonPlayer_BarData"],self,1)
					return 1
				end
			end
		-----------------------------
		elseif(name=="HighThreatPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,_,isplayer,_,recentUpdated,_,_,_,_,_,_,_,_,_,threat)
				if(isplayer==1 and (threat==1 or threat==2))then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_HighThreatPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="HighThreatNonPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,unitdata,_,_,_,_,isplayer,_,recentUpdated,_,_,_,_,_,_,_,_,_,threat)
				if(isplayer==0 and (threat==1 or threat==2 or threat==3))then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_HighThreatNonPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="LowThreatPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,_,_,_,_,_,isplayer,_,recentUpdated,_,_,_,_,_,_,_,_,_,threat)
				if(isplayer==1 and threat==0)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_LowThreatPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="LowThreatNonPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,unitdata,_,_,_,_,isplayer,_,recentUpdated,_,_,_,_,_,_,_,_,_,threat)
				if(isplayer==0 and threat==0)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_LowThreatNonPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="TankingPlayer")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,unitdata,_,_,_,_,isplayer,_,recentUpdated,_,_,_,_,_,_,_,_,_,threat)
				if(isplayer==1 and threat==3)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_TankingPlayer_BarData"],self,1)
					return 1
				end
			end
		elseif(name=="TappedMob")then
			NPA_HealthBar_CustomBarFunc[value]=function(self,_,unitdata)
				if(unitdata and unitdata.Tapped==1)then
					ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_TappedMob_BarData"],self,1)
					return 1
				end
			end
		end
	end

	NPA_HealthBar_CustomBarFunc.Max=count+1
	NPA_HealthBar_CustomBarFunc[NPA_HealthBar_CustomBarFunc.Max]=function(self)
		ManageTexture(nil,self.HealthBar,NPA_HealthBar_Config["HealthBar_BarData"],self,1)
		return 1
	end
end

function NPA_HealthBar:ApplyConfig()
	NPA_Core:CheckConfigEntry("HealthBar",NPA_HealthBar_DefaultSetting)

	NPA_HealthBar_Config=NPA_Config["HealthBar"]

	NPA_HealthBar_BuildCustomBarFunc()
	NPA_HealthBar_BuildColorBarFunc()

	for _,mainframe in pairs(NPA_HealthBar_Frame) do
		NPA_HealthBar_SetFrame(mainframe)
		local parent=mainframe:GetParent().Parent
		if(parent.Default and parent.Default.HealthBar)then
			NPA_HealthBar_OnValueChanged(parent.Default.HealthBar)
		else--if(parent.GUID and NPA_Core_GetUnitData[parent.GUID])then
			NPA_HealthBar_UpdateValue(1,1,mainframe)
			mainframe.HealthBar.Percent=0
		end
	end


end


NPA_Core:AddHook("HealthBar",NPA_HealthBar_HookFrame)
NPA_Core:AddModule("HealthBar",NPA_HealthBar)
NPA_Core:HookUpdate("HealthBar",NPA_HealthBar_OnUpdate,1)