﻿-- Author      : Nogarder
-- Create Date : 2010/7/3 20:40:36

local NPA_CrowdControl_Frame={}

local NPA_CrowdControl={}
---config
local NPA_CrowdControl_DefaultSetting={
		["CrowdControl_OffsetX"]=75,
		["CrowdControl_OffsetY"]=-22,
		["CrowdControl_Max"]=6,
		["CrowdControl_MaxPerRow"]=3,
		["CrowdControl_GapHeight"]=22,
		["CrowdControl_GapWidth"]=22,

		["CrowdControl_GrowRightward"]=1,
		["CrowdControl_GrowUpward"]=0,

		["CrowdControl_Decile"]=0,
		["CrowdControl_ShowBar"]=1,
		["CrowdControl_ColorBarByTime"]=0,
		["CrowdControl_ColorTextByTime"]=0,
		["CrowdControl_AlterDecile"]=0,
		["CrowdControl_ColorHighlight"]=0,
		["CrowdControl_ColorBackground"]=0,
		["CrowdControl_ColorMagic"]=1,
		["CrowdControl_ColorPosion"]=1,
		["CrowdControl_ColorDisease"]=1,
		["CrowdControl_ColorCurse"]=1,
		["CrowdControl_ColorPhysic"]=1,
		["CrowdControl_ColorEnrage"]=1,
		["CrowdControl_ColorBar"]=0,

		["CrowdControl_ShowDR"]=0,
		["CrowdControl_ShowCC"]=1,

		["CrowdControl_DRHideList"]={},

		["CrowdControl_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="ADD",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["CrowdControl_IconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CrowdControl_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\blank",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CrowdControl_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CrowdControl_TimeData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=5,
			OffsetY=-5,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	

		["CrowdControl_StackData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=-5,
			OffsetY=5,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CrowdControl_DRData"]={
			--[[ TAUNT ]]--
			[  355] = "taunt", -- Taunt (Warrior)
			[53477] = "taunt", -- Taunt (Hunter tenacity pet)
			[ 6795] = "taunt", -- Growl (Druid)
			[56222] = "taunt", -- Dark Command
			[62124] = "taunt", -- Hand of Reckoning
			[31790] = "taunt", -- Righteous Defense
			[20736] = "taunt", -- Distracting Shot
			[ 1161] = "taunt", -- Challenging Shout
			[ 5209] = "taunt", -- Challenging Roar
			[57603] = "taunt", -- Death Grip
			[36213] = "taunt", -- Angered Earth -- FIXME: NPC ability ?
			[17735] = "taunt", -- Suffering (Voidwalker)
			[58857] = "taunt", -- Twin Howl (Spirit wolves)

			--[[ DISORIENTS ]]--
			[49203] = "disorient", -- Hungering Cold
			[ 6770] = "disorient", -- Sap
			[ 1776] = "disorient", -- Gouge
			[51514] = "disorient", -- Hex
			[ 9484] = "disorient", -- Shackle Undead
			[  118] = "disorient", -- Polymorph
			[28272] = "disorient", -- Polymorph (pig)
			[28271] = "disorient", -- Polymorph (turtle)
			[61305] = "disorient", -- Polymorph (black cat)
			[61025] = "disorient", -- Polymorph (serpent) -- FIXME: gone ?
			[61721] = "disorient", -- Polymorph (rabbit)
			[61780] = "disorient", -- Polymorph (turkey)
			[ 3355] = "disorient", -- Freezing Trap
			[19386] = "disorient", -- Wyvern Sting
			[20066] = "disorient", -- Repentance
			[90337] = "disorient", -- Bad Manner (Monkey) -- FIXME: to check
			[ 2637] = "disorient", -- Hibernate
			[82676] = "disorient", -- Ring of Frost

			--[[ SILENCES ]]--
			[50479] = "silence", -- Nether Shock (Nether ray)
			[ 1330] = "silence", -- Garrote
			[25046] = "silence", -- Arcane Torrent (Energy version)
			[28730] = "silence", -- Arcane Torrent (Mana version)
			[50613] = "silence", -- Arcane Torrent (Runic power version)
			[69179] = "silence", -- Arcane Torrent (Rage version)
			[80483] = "silence", -- Arcane Torrent (Focus version)
			[15487] = "silence", -- Silence
			[34490] = "silence", -- Silencing Shot
			[18425] = "silence", -- Improved Kick (rank 1)
			[86759] = "silence", -- Improved Kick (rank 2)
			[18469] = "silence", -- Improved Counterspell (rank 1)
			[55021] = "silence", -- Improved Counterspell (rank 2)
			[24259] = "silence", -- Spell Lock (Felhunter)
			[47476] = "silence", -- Strangulate
			[18498] = "silence", -- Gag Order (Warrior talent)
			[81261] = "silence", -- Solar Beam
			[31935] = "silence", -- Avenger's Shield

			--[[ DISARMS ]]--
			[91644] = "disarm", -- Snatch (Bird of Prey)
			[51722] = "disarm", -- Dismantle
			[  676] = "disarm", -- Disarm
			[64058] = "disarm", -- Psychic Horror (Disarm effect)
			[50541] = "disarm", -- Clench (Scorpid)

			--[[ FEARS ]]--
			[ 2094] = "fear", -- Blind
			[ 5782] = "fear", -- Fear (Warlock)
			[ 6358] = "fear", -- Seduction (Succubus)
			[ 5484] = "fear", -- Howl of Terror
			[ 8122] = "fear", -- Psychic Scream
			[65545] = "fear", -- Psychic Horror
			[ 1513] = "fear", -- Scare Beast
			[10326] = "fear", -- Turn Evil
			[ 5246] = "fear", -- Intimidating Shout (main target)
			[20511] = "fear", -- Intimidating Shout (secondary targets)

			--[[ CONTROL STUNS ]]--
			[89766] = "stun", -- Axe Toss (Felguard)
			[50519] = "stun", -- Sonic Blast (Bat)
			[12809] = "stun", -- Concussion Blow
			[46968] = "stun", -- Shockwave
			[  853] = "stun", -- Hammer of Justice
			[ 5211] = "stun", -- Bash
			[19577] = "stun", -- Intimidation
			[22570] = "stun", -- Maim
			[  408] = "stun", -- Kidney Shot
			[20549] = "stun", -- War Stomp
			[44572] = "stun", -- Deep Freeze
			[30283] = "stun", -- Shadowfury
			[ 2812] = "stun", -- Holy Wrath
			[22703] = "stun", -- Inferno Effect
			[54785] = "stun", -- Demon Leap (Warlock)
			[47481] = "stun", -- Gnaw (Ghoul)
			[93433] = "stun", -- Burrow Attack (Worm)
			[56626] = "stun", -- Sting (Wasp)
			[85388] = "stun", -- Throwdown
			[ 1833] = "stun", -- Cheap Shot
			[ 9005] = "stun", -- Pounce
			[88625] = "stun", -- Holy Word: Chastise

			------changed in 4.1
			[ 7922] = "chargestun", -- Charge
			[20252] = "chargestun", -- Intercept

			--[[ RANDOM STUNS ]]--
			[64343] = "rndstun", -- Impact
			[39796] = "rndstun", -- Stoneclaw Stun
			[11210] = "rndstun", -- Improved Polymorph (rank 1)
			[12592] = "rndstun", -- Improved Polymorph (rank 2)

			--[[ CYCLONE ]]--
			[33786] = "cyclone", -- Cyclone

			--[[ ROOTS ]]--
			[33395] = "root", -- Freeze (Water Elemental)
			[50245] = "root", -- Pin (Crab)
			[  122] = "root", -- Frost Nova
			[  339] = "root", -- Entangling Roots
			[19975] = "root", -- Nature's Grasp (Uses different spellIDs than Entangling Roots for the same spell)
			[64695] = "root", -- Earthgrab (Storm, Earth and Fire talent)
			[ 4167] = "root", -- Web (Spider)
			[54706] = "root",	-- Venom Web Spray (Silithid)
			[19306] = "root", -- Counterattack
			[90327] = "root", -- Lock Jaw (Dog)
			[11190] = "root", -- Improved Cone of Cold (rank 1)
			[12489] = "root", -- Improved Cone of Cold (rank 2)

			--[[ RANDOM ROOTS ]]--
			[23694] = "rndroot", -- Improved Hamstring -- FIXME: to check
			[44745] = "rndroot", -- Shattered Barrier (rank 1)
			[54787] = "rndroot", -- Shattered Barrier (rank 2)

			--[[ HORROR ]]--
			[ 6789] = "horror", -- Death Coil
			[64044] = "horror", -- Psychic Horror
			[87099] = "horror", -- Sin and Punishment (rank 1)
			[87100] = "horror", -- Sin and Punishment (rank 2)

			--[[ MISC ]]--
			[19503] = "scatters",   -- Scatter Shot
			[31661] = "dragons",    -- Dragon's Breath
			[  605] = "mc",         -- Mind Control
			[  710] = "banish",     -- Banish
			[19185] = "entrapment", -- Entrapment

			},
	
		["CrowdControl_Data"]={
			--placeholder
			--cc,
			[33786]=3, --cyclone
			[2637]=3, --hibernate
			[3355]=3, --freezing trap
			[6770]=3, --sap
			[2094]=3, --blind
			[5782]=3, --fear
			[6789]=3, --warlock death coil
			[6358]=3, --seduction
			[5484]=3, --howl of terror
			[5246]=3, --intimidating shout
			[8122]=3, --psychic scream
			[118]=3, --polymorph
			[28272]=3, --polymorph pig
			[28271]=3, --polymorh turtle
			[61305]=3, --polymorph black cat
			[61025]=3, --polymorph serpent
			[61780]=3, --polymorph turkey
			[61721]=3, --polymorph rabbit
			[51514]=3, --hex
			[710]=3, --banish
			[9484]=3, --shackle undead
			[76780]=3,--bind elemental
			[20066]=3,--repentance
			[1776]=3, --gouge(rogue)
			[1513]=3, --scare beast(hunter)
			--stuns
			[5211]=3, --bash (druid)
			[1833]=3, --cheap shot(rogue)
			[408]=3, --kidney shot(rogue)
			[44572]=3, --deep freeze(mage)
			[19386]=3, --wyvern sting(hunter)
			[19503]=3, --scatter shot (hunter)
			[9005]=3, --pounce(druid)
			[22570]=3, --maim (druid)
			[853]=3, --hammar of justice
			[46968]=3, --shockwave(warrior)
			[49203]=3, --hungering cold (deathknight)
			[47481]=3, --gnaw (dk pet stun)
			[30283]=3, --shadow fury(warlock)
			[54786]=3,--demon leap stun(warlock)
			[91807]=3,--ghoul stun&counterspell(deathknight)
			[91797]=3,--ghoul stun(deathknight)
			--roots & snare,
			[339]=2, --entangling roots
			[122]=2, --frost nova
			[45334]=2, --feral charge (bear)
			[13809]=2, --frost trap
			[16689]=2, -- nature's grasp
			[23694]=2, --improved hamstring(warrior)
			[33395]=2,-- water elemental nova(mage)
			--silences
			[18469]=1, --improved counterspell(mage)
			[15487]=1, --silence(priest)
			[34490]=1, --silencing shot(hunter)
			[18425]=1, --improved kick(rogue)
			[47476]=1, --strangulate(deathknight)
			[1330]=1,--garrote(rogue)
			--misc
			[20164]=1, --seal of justice(paladin)
			[91342]=1, --shadow infusion(deathknight ghoul)
			--disarms
			[676]=1, --disarm(warrior)
			[51722]=1, --dismantle(rogue)
			--buffs
			[12472]=1,--icy veins(mage)
			[12042] = 120,--Arcane Power (mage)	
--			[80353]=1, --time warp(mage)
			[44544]=1, --fingers of frost
			[1022]=1, --blessing of protection(paladin)
			[1044]=1, --blessing of freedom(paladin)
--			[2825]=1, --bloodlust(shaman)
--			[32182]=1, --heroism(shaman)
			[33206]=1, --pain suppression(priest)
			[29166]=1, --innervate(druid)
			[74434]=1, --soulburn(warlock)
			[54428]=1, --divine plea(paladin)
			[31821]=1, --aura mastery(paladin)
			[48792]=1,-- ice bound fortitude(deathknight)
			[18499]=1,--berserker rage(warrior)
			[1719]=1,--recklessness(warrior)
			[23920]=1,--spell reflection(warrior)
			[13877]=1, --blade flurry(rogue)
			[2983]=2,--sprint(rogue)
			[13750]=1,--adrenaline rush(rogue)
			[86346]=1,--colossus smash(warrior)
			--turtling abilities
			[871]=2, --shield wall(warrior)
			[48707]=2, --anti-magic shell(deathknight)
			[31224]=2, --cloak of shadows(rogue)
			[19263]=2, --deterrence(hunter)
			[74002]=2, --combat insight(rogue)
			[5277]=2,--evasion(rogue)
			--immunities
			[45438]=3, --ice block (mage)
			[642]=3, --divine shield (paladin)

		}
	}

local NPA_CrowdControl_Config=NPA_CrowdControl_DefaultSetting

function NPA_CrowdControl:ResetConfig()
	NPA_Config["CrowdControl"]=CopyTable(NPA_CrowdControl_DefaultSetting)
end


-- get global functions
local pairs = pairs
local table_insert = table.insert
local table_remove = table.remove
local table_getn=table.getn
local CopyTable=CopyTable
local GetTime = GetTime

local SpellData=NPA_Core.SpellData

local DRLength=18

local NPA_CrowdControl_DRData={}

local NPA_ManageBar=NPA_Core.ManageBar



local NPA_CrowdControl_SchoolToColor={		
	["Magic"]={r=0,g=0,b=1},
	["Poison"]={r=0,g=1,b=0},
	["Curse"]={r=1,g=0,b=1},
	["Disease"]={r=0.6,g=0.6,b=0},
	["Physic"]={r=1,g=1,b=0}
}

local function NPA_CrowdControl_SetCCDisplay(main,auras,nTime,spellid,maxduration,showbar)
	local bestindex=1
	local besttime=3600
	for index,saura in pairs(auras) do
		local auratime=saura.ExpirationTime
		if(auratime and besttime>auratime)then
			besttime=auratime
			bestindex=index
		end
	end

	local aura=auras[bestindex]

	local data=SpellData[spellid]
	if(data)then
		main.Icon:SetTexture(data.Icon)

		local school=data.School
		local color
		if((NPA_CrowdControl_Config["CrowdControl_ColorMagic"]==1 and school=="Magic") or
			(NPA_CrowdControl_Config["CrowdControl_ColorPosion"]==1 and school=="Posion") or
			(NPA_CrowdControl_Config["CrowdControl_ColorCurse"]==1 and school=="Curse") or
			(NPA_CrowdControl_Config["CrowdControl_ColorDisease"]==1 and school=="Disease") or
			(NPA_CrowdControl_Config["CrowdControl_ColorEnrage"]==1 and school=="") or
			(NPA_CrowdControl_Config["CrowdControl_ColorPhysic"]==1 and school==nil))then

			color=NPA_CrowdControl_SchoolToColor[(school or "Physic")] or {r=1,g=1,b=1}
		else
			color={r=1,g=1,b=1}
		end

		if(NPA_CrowdControl_Config["CrowdControl_ColorBackground"]==1)then
			local bg=main.Background
			bg:SetVertexColor(bg.R*color.r,bg.G*color.g,bg.B*color.b)
		else
			local bg=main.Background
			bg:SetVertexColor(bg.R,bg.G,bg.B)
		end

		if(NPA_CrowdControl_Config["CrowdControl_ColorBar"]==1)then
			local bar=main.Bar
			bar:SetVertexColor(bar.R*color.r,bar.G*color.g,bar.B*color.b)
		else
			local bar=main.Bar
			bar:SetVertexColor(bar.R,bar.G,bar.B)
		end
	else
		main.Icon:SetTexture(nil)
	end

	local exptime=aura.ExpirationTime

	if(exptime)then
		local timeleft=exptime-nTime
		local timetext
		if(timeleft<0 or timeleft>100)then
			timetext="*"
		elseif(timeleft<2 and NPA_CrowdControl_Config["CrowdControl_Decile"]==1)then
			if(NPA_CrowdControl_Config["CrowdControl_AlterDecile"]~=1)then
				timetext=floor(timeleft*10)/10
			elseif(timeleft<1)then
				timetext="."..floor(timeleft*10)
			else
				timetext=floor(timeleft)
			end
		else
			timetext=floor(timeleft)
		end

		if(NPA_CrowdControl_Config["CrowdControl_ColorTextByTime"]==1)then
			if(timeleft>60)then
				timetext="|cff00ff00"..timetext
			elseif(timeleft>3)then
				timetext="|cffffff00"..timetext
			else
				timetext="|cffff0000"..timetext
			end
		end
				
		main.Text:SetText(timetext)

		--bar
		if(showbar==1)then
			local guid=aura.CasterGUID or 0
			if(maxduration and maxduration[guid])then
				local bar=main.Bar
				bar.Percent=timeleft/maxduration[guid]
				NPA_ManageBar(nil,bar)
				
				if(NPA_CrowdControl_Config["CrowdControl_ColorBarByTime"]==1)then
					local percent=bar.Percent
					bar:SetVertexColor(bar.R*(1-percent),bar.G*percent,0)
				end
			else
				main.Bar:Hide()
			end
		else
			main.Bar:Hide()
		end
	else
		main.Text:SetText("*")
	end

	local count=aura.Count
	if(count and count>1)then
		main.Stack:SetText(count)
	else
		main.Stack:SetText(nil)
	end
	main:Show()
end


local NPA_CrowdControlSchoolToColor={		
	["Magic"]={r=0,g=0,b=1},
	["Poison"]={r=0,g=1,b=0},
	["Curse"]={r=1,g=0,b=1},
	["Disease"]={r=0.6,g=0.6,b=0},
	["Physic"]={r=1,g=1,b=0}
}

local function NPA_CrowdControl_SetDRDisplay(main,timeleft,nTime,drdata,showbar)
	local count=drdata.Count
	local spellid=drdata.SpellID

	--icon
	local data=SpellData[spellid]
	if(data)then
		main.Icon:SetTexture(data.Icon)
	else
		main.Icon:SetTexture(nil)
	end

	--count
	if(count<8)then
		main.Stack:SetText("1/"..count)
	else
		main.Stack:SetText("X")
	end

	--time
	local timetext	
	if(timeleft<0 or timeleft>100)then
		timetext="*"
	elseif(timeleft<2 and NPA_CrowdControl_Config["CrowdControl_Decile"]==1)then
		timetext=floor(timeleft*10)/10
	else
		timetext=floor(timeleft)
	end
	
	if(NPA_CrowdControl_Config["CrowdControl_ColorTextByTime"]==1)then
		if(timeleft>100)then
			timetext="|cff00ff00"..timetext
		elseif(timeleft>20)then
			timetext="|cffffff00"..timetext
		else
			timetext="|cffff0000"..timetext
		end
	end

	main.Text:SetText(timetext)
	
	--bar
	if(showbar)then
		local bar=main.Bar
		bar.Percent=timeleft/15
		NPA_ManageBar(nil,bar)
	
		if(NPA_CrowdControl_Config["CrowdControl_ColorBarByTime"]==1)then
			local percent=bar.Percent
			bar:SetVertexColor(bar.R*(1-percent),bar.G*percent,0)
		end
	
	else
		main.Bar:Hide()
	end

	main:Show()
end

local function NPA_CrowdControl_OnUpdate(nTime,self,guid,unitdata)
	local auras=unitdata.Aura
	if(not auras)then
		self:Hide()
		return
	end

	icon=self.IconFrame

	local bestid
	local bestlevel
	local auralist={}
	local endindex
	local maxdurationcache=NPA_Core.Aura_Duration_Cache
	local showbar=NPA_CrowdControl_Config["CrowdControl_ShowBar"]

	if(NPA_CrowdControl_Config["CrowdControl_ShowCC"]==1)then
		for i=1,NPA_CrowdControl_Config["CrowdControl_Max"] do
			bestid=nil
			bestlevel=0
			for spellid,bauras in pairs(auras) do
				if(table_getn(bauras)>0 and (not auralist[spellid])) then
					local level=NPA_CrowdControl_Config["CrowdControl_Data"][spellid]
					if(level and level>=bestlevel)then
						bestlevel=level
						bestid=spellid
					end
				end
			end
			if(bestid)then
				NPA_CrowdControl_SetCCDisplay(icon[i],auras[bestid],nTime,bestid,maxdurationcache[bestid],showbar)
				auralist[bestid]=1
			else
				icon[i]:Hide()
				endindex=i
				break
			end
		end
	end

	if(not endindex)then
		endindex=NPA_CrowdControl_Config["CrowdControl_Max"]+1
	end

	auralist={}
	if(NPA_CrowdControl_Config["CrowdControl_ShowDR"]==1)then
		local drdata=NPA_CrowdControl_DRData[guid]
		if(drdata)then
			for i=endindex,NPA_CrowdControl_Config["CrowdControl_Max"] do
				bestid=nil
				local timeleft
				local count
				for drid,data in pairs(drdata) do
					timeleft=data.EndTime-nTime
					if(timeleft>=0)then
						if(auralist[drid]~=1) then
							bestid=drid
							break
						end
					else
						drdata[drid]=nil
					end
				end
				if(bestid)then
					NPA_CrowdControl_SetDRDisplay(icon[i],timeleft,nTime,drdata[bestid],showbar)
					auralist[bestid]=1
				else
					icon[i]:Hide()
					endindex=i
					break
				end
			end
		end

	end


	if(not endindex)then
		endindex=NPA_CrowdControl_Config["CrowdControl_Max"]+1
	end

	for i=endindex,self.Count do
		icon[i]:Hide()
	end

	if(icon[1]:IsShown())then
		self:Show()
	else
		self:Hide()
	end
end

local function NPA_CrowdControl_CreateIcon(main)
	local iconframe=CreateFrame("Frame","NPA_CrowdControl_IconFrame",main)
	iconframe:SetHeight(1)
	iconframe:SetWidth(1)
	iconframe:Hide()
		
	iconframe.Icon=iconframe:CreateTexture(nil,"BORDER",nil)
	iconframe.Icon:Show()
		
	iconframe.Background=iconframe:CreateTexture(nil,"BACKGROUND",nil)
	iconframe.Background:Show()

	iconframe.Overlay=iconframe:CreateTexture(nil,"OVERLAY",nil)
	iconframe.Overlay:Show()

	iconframe.Text=iconframe:CreateFontString(nil,"OVERLAY",nil)
	iconframe.Text:Show()

	iconframe.Stack=iconframe:CreateFontString(nil,"OVERLAY",nil)
	iconframe.Text:Show()

	iconframe.Bar=iconframe:CreateTexture(nil,"ARTWORK",nil)
	iconframe.Bar:Hide()

	return iconframe
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_CrowdControl_SetIconFrame(main)
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_CrowdControl_Config["CrowdControl_OffsetX"],NPA_CrowdControl_Config["CrowdControl_OffsetY"])

	local frame=main.IconFrame
	for i=1,NPA_CrowdControl_Config["CrowdControl_Max"] do 
		if(not frame[i])then
			frame[i]=NPA_CrowdControl_CreateIcon(main)
		end
		local iconframe=frame[i]

		ManageTexture(nil,iconframe.Icon,NPA_CrowdControl_Config["CrowdControl_IconData"],iconframe)
		ManageTexture(nil,iconframe.Background,NPA_CrowdControl_Config["CrowdControl_BackgroundData"],iconframe)
		ManageTexture(nil,iconframe.Overlay,NPA_CrowdControl_Config["CrowdControl_OverlayData"],iconframe)
		ManageTexture(nil,iconframe.Bar,NPA_CrowdControl_Config["CrowdControl_BarData"],iconframe,1)
		ManageFont(nil,iconframe.Text,NPA_CrowdControl_Config["CrowdControl_TimeData"],iconframe)
		ManageFont(nil,iconframe.Stack,NPA_CrowdControl_Config["CrowdControl_StackData"],iconframe)

		local offset=i-1
					
		local offsetx=(offset % NPA_CrowdControl_Config["CrowdControl_MaxPerRow"])*NPA_CrowdControl_Config["CrowdControl_GapWidth"]
		local offsety=floor(offset/NPA_CrowdControl_Config["CrowdControl_MaxPerRow"])*NPA_CrowdControl_Config["CrowdControl_GapHeight"]
		
		if(NPA_CrowdControl_Config["CrowdControl_GrowUpward"]~=1)then
			offsety=-offsety
		end
		if(NPA_CrowdControl_Config["CrowdControl_GrowRightward"]~=1)then
			offsetx=-offsetx
		end

		iconframe:SetPoint("TOPLEFT",main,"TOPLEFT",offsetx,offsety)
		iconframe:Hide()
	end
	for i=NPA_CrowdControl_Config["CrowdControl_Max"]+1 ,table_getn(frame) do
		frame[i]:Hide()
	end

	main.Count=table_getn(frame)
end


local function NPA_CrowdControl_CreateIconFrames(main)
	local data={}
	for i=1, NPA_CrowdControl_Config["CrowdControl_Max"] do		
		data[i]=NPA_CrowdControl_CreateIcon(main)
	end
	return data
end


local function NPA_CrowdControl_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_CrowdControl_MainFrame",frame)
	main:SetHeight(1)
	main:SetWidth(1)
	
	main.IconFrame=NPA_CrowdControl_CreateIconFrames(main)

	table_insert(NPA_CrowdControl_Frame,main)
	NPA_CrowdControl_SetIconFrame(main)

	frame["CrowdControl"]=main
end

local NPA_CrowdControl_RemoveFilter={
	["SPELL_DISPEL"]=1,
	["SPELL_STOLEN"]=1,
	["SPELL_AURA_REMOVED"]=1,
	["SPELL_AURA_REFRESH"]=1
}
local NPA_CrowdControl_ApplyFilter={
	["SPELL_AURA_APPLIED"]=1,
}


local function NPA_CrowdControl_OnEvent(uarg)
	local data=SpellData[uarg[9]]
	if(data and data.Type=="DEBUFF")then

	if(NPA_CrowdControl_RemoveFilter[uarg[2]]==1)then
		local drtype=NPA_CrowdControl_Config["CrowdControl_DRData"][uarg[9]]
		if(drtype and NPA_CrowdControl_Config["CrowdControl_DRHideList"][drtype]~=1)then
			if(not NPA_CrowdControl_DRData[uarg[6]])then
				NPA_CrowdControl_DRData[uarg[6]]={[drtype]={Count=2,EndTime=GetTime()+DRLength,SpellID=uarg[9]}}
			else
				local drdata=NPA_CrowdControl_DRData[uarg[6]][drtype]
				if(drdata)then
					if(drdata.EndTime and GetTime()-drdata.EndTime<DRLength)then
						local count=drdata.Count*2
						if(count>4 and uarg[2]=="SPELL_AURA_REFRESH")then
							NPA_CrowdControl_DRData[uarg[6]][drtype]=nil
						else
							NPA_CrowdControl_DRData[uarg[6]][drtype]={Count=count,EndTime=GetTime()+DRLength,SpellID=uarg[9]}
						end
					else
						NPA_CrowdControl_DRData[uarg[6]][drtype]={Count=2,EndTime=GetTime()+DRLength,SpellID=uarg[9]}
					end
				else
					NPA_CrowdControl_DRData[uarg[6]][drtype]={Count=2,EndTime=GetTime()+DRLength,SpellID=uarg[9]}
				end
			end
		end
	elseif(NPA_CrowdControl_ApplyFilter[uarg[2]]==1)then
		local drtype=NPA_CrowdControl_Config["CrowdControl_DRData"][uarg[9]]
		if(drtype and NPA_CrowdControl_Config["CrowdControl_DRHideList"][drtype]~=1)then
			if(NPA_CrowdControl_DRData[uarg[6]])then
				local drdata=NPA_CrowdControl_DRData[uarg[6]][drtype]
				if(drdata)then
					if(drdata.EndTime and GetTime()-drdata.EndTime<DRLength)then
						if(drdata.Count>4)then
							NPA_CrowdControl_DRData[uarg[6]][drtype]=nil
						else
							drdata.EndTime=drdata.EndTime+DRLength
						end
					end
				end
			end
		end
	end

	end
end

function NPA_CrowdControl:ApplyConfig()
	NPA_Core:CheckConfigEntry("CrowdControl",NPA_CrowdControl_DefaultSetting)

	NPA_CrowdControl_Config=NPA_Config["CrowdControl"]

	for _,mainframe in pairs(NPA_CrowdControl_Frame) do
		NPA_CrowdControl_SetIconFrame(mainframe)
	end

	if(NPA_Config["Core"]["EnableModule"]["CrowdControl"]==1 and NPA_CrowdControl_Config["CrowdControl_ShowDR"]==1)then
		NPA_Core.CombatEventFunc["CrowdControl"]=NPA_CrowdControl_OnEvent
	else
		NPA_Core.CombatEventFunc["CrowdControl"]=nil
	end
end

--onload functions
NPA_Core:AddHook("CrowdControl",NPA_CrowdControl_HookFrame)
NPA_Core:AddModule("CrowdControl",NPA_CrowdControl)
NPA_Core:HookUpdate("CrowdControl",NPA_CrowdControl_OnUpdate,2)