﻿-- Author      : Nogarder
-- Create Date : 2010/7/4 16:33:11

local GetTime=GetTime
local table_insert=table.insert
local NPA_CounterSpell_Frame={}
local pairs=pairs

local NPA_CounterSpell={}
local NPA_CounterSpell_Data={}

local bit_band=bit.band
local COMBATLOG_OBJECT_TYPE_PLAYER=COMBATLOG_OBJECT_TYPE_PLAYER

--config
local NPA_CounterSpell_DefaultSetting={
		["CounterSpell_OffsetX"]=0,
		["CounterSpell_OffsetY"]=-40,
		["CounterSpell_Data"]={
			[57994]=2, -- shaman -wind shear 
			[1766]=5, -- rogue -kick
			[2139]=8, -- mage -counterspell
			[47528]=4, --death knight - mind freeze
			[6552]=4, --warrior -pummel
			[72]=4, --warrior -shiled bash
			[34490]=3, -- hunter - silencing shot
			[85285]=4, -- paladin -rebuke
			[93985]=4, -- druid -skull bash
			[19647]=3  -- warlock felhound - spell lock
			},

		["CounterSpell_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=30,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CounterSpell_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CounterSpell_BarOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CounterSpell_BarBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

	}
local NPA_CounterSpell_Config=NPA_CounterSpell_DefaultSetting

function NPA_CounterSpell:ResetConfig()
	NPA_Config["CounterSpell"]=CopyTable(NPA_CounterSpell_DefaultSetting)
end


local function NPA_CounterSpell_Interrupt(guid,spell,school,flag,countertime)
	if(NPA_CounterSpell_Data[guid]==nil)then
		NPA_CounterSpell_Data[guid]={}
	end
	if(NPA_CounterSpell_Data[guid].Interrupt==nil)then
		NPA_CounterSpell_Data[guid].Interrupt={}
	end
	if(NPA_CounterSpell_Data[guid].DR==nil)then
		NPA_CounterSpell_Data[guid].DR={}
	end

	local nTime=GetTime()

	local interrupt=NPA_CounterSpell_Data[guid].Interrupt[school]
	
	--no dr

	--if(interrupt and nTime - interrupt<15 and bit_band(flag,COMBATLOG_OBJECT_TYPE_PLAYER)>0)then
	--	local dr=NPA_CounterSpell_Data[guid].DR[school]
	--	dr=dr*2
	--	if(dr<8)then
	--		NPA_CounterSpell_Data[guid].Interrupt[school]=nTime + countertime/dr
	--	end
	--	NPA_CounterSpell_Data[guid].DR[school]=dr
	--else
		NPA_CounterSpell_Data[guid].Interrupt[school]=nTime + countertime
		NPA_CounterSpell_Data[guid].DR[school]=1
	--end
end

local NPA_CounterSpell_SpellTypeColor={
	[1]="|cffffff00",
	[2]="|cffffff88",
	[4]="|cffff4800",
	[8]="|cff40ff40",
	[16]="|cff88ffff",
	[32]="|cff8888ff",
	[64]="|cffff88ff"
}

local ManageBar=NPA_Core.ManageBar

local function NPA_CounterSpell_OnUpdate(nTime,self,guid)
	local data=NPA_CounterSpell_Data[guid]
	if(data) then
		local text=""
		local nTime=GetTime()
		local besttime=0
		for school,endtime in pairs(data.Interrupt) do
			if(endtime>nTime)then
				local color=NPA_CounterSpell_SpellTypeColor[school]
				if(color==nil)then
					color="|cffffffff"
				end
				local time=floor(endtime-nTime)
				if(time>besttime)then
					besttime=time
				end
				text=text..color.."["..time.."]"
			end
		end
		
		local bar=self.Bar
		bar.Percent=besttime/8
		ManageBar(nil,bar)

		if(text=="")then
			self:Hide()
		else
			self.Text:SetText(text)
			self:Show()
		end
	else
		self:Hide()
	end

end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_CounterSpell_SetFrame(main)
	main:Hide()
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_CounterSpell_Config["CounterSpell_OffsetX"],NPA_CounterSpell_Config["CounterSpell_OffsetY"])
	ManageTexture(nil,main.Bar,NPA_CounterSpell_Config["CounterSpell_BarData"],main,1)
	ManageTexture(nil,main.Background,NPA_CounterSpell_Config["CounterSpell_BarBackgroundData"],main)
	ManageTexture(nil,main.Overlay,NPA_CounterSpell_Config["CounterSpell_BarOverlayData"],main)

	ManageFont(nil,main.Text,NPA_CounterSpell_Config["CounterSpell_TextData"],main)
end
local function NPA_CounterSpell_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_CounterSpell_MainFrame",frame)
	main:SetHeight(1)
	main:SetWidth(1)
	main:Hide()

	local text=main:CreateFontString("NPA_CounterSpell_Text","OVERLAY",nil)
	text:Show()
	local bar=main:CreateTexture("NPA_CounterSpell_Bar","ARTWORK")
	local overlay=main:CreateTexture("NPA_CounterSpell_Overlay","OVERLAY")
	local background=main:CreateTexture("NPA_CounterSpell_Background","BACKGROUND")

	
	main.Bar=bar
	main.Overlay=overlay
	main.Background=background

	main.Text=text
	
	NPA_CounterSpell_SetFrame(main)
	table_insert(NPA_CounterSpell_Frame,main)

	frame["CounterSpell"]=main	
end

function NPA_CounterSpell:Test()
	local id,dtime
	local nTime=GetTime()
	for spellid,time in pairs(NPA_CounterSpell_Config["CounterSpell_Data"]) do
		id=spellid
		dtime=time
		if(random()>0.5)then
			break
		end
	end
	local school=2^floor(random()*6)
	NPA_CounterSpell_Data[-100]={
			Interrupt={[school]=nTime+random()*100},
			DR={[school]=1},
			}
end


local counterspelldata=NPA_CounterSpell_Config["CounterSpell_Data"]


local function NPA_CounterSpell_OnEvent(uarg)
	if(uarg[2]=="SPELL_INTERRUPT")then
		local countertime=counterspelldata[uarg[9]]
		if(countertime)then
			NPA_CounterSpell_Interrupt(uarg[6],uarg[9],uarg[14],uarg[8],countertime)
		end
	end
end

function NPA_CounterSpell:ApplyConfig()
	NPA_Core:CheckConfigEntry("CounterSpell",NPA_CounterSpell_DefaultSetting)

	NPA_CounterSpell_Config=NPA_Config["CounterSpell"]

	for _,main in pairs(NPA_CounterSpell_Frame) do
		NPA_CounterSpell_SetFrame(main)
	end

	counterspelldata=NPA_CounterSpell_Config["CounterSpell_Data"]

	if(NPA_Config["Core"]["EnableModule"]["CounterSpell"]==1)then
		NPA_Core.CombatEventFunc["CounterSpell"]=NPA_CounterSpell_OnEvent
	else
		NPA_Core.CombatEventFunc["CounterSpell"]=nil
	end
end


NPA_Core:AddHook("CounterSpell",NPA_CounterSpell_HookFrame)
NPA_Core:AddModule("CounterSpell",NPA_CounterSpell)
NPA_Core:HookUpdate("CounterSpell",NPA_CounterSpell_OnUpdate,2)