﻿-- Author      : Nogarder
-- Create Date : 2010/7/3 20:40:36


local NPA_CoolDown_Frame={}

local NPA_CoolDown={}
---config
local NPA_CoolDown_DefaultSetting={
		["CoolDown_OffsetX"]=75,
		["CoolDown_OffsetY"]=0,
		["CoolDown_Row"]=3,
		["CoolDown_Max"]=6,
		["CoolDown_Short"]=1,
		["CoolDown_GrowUp"]=1,
		["CoolDown_GrowRight"]=1,
		["CoolDown_GapHeight"]=22,
		["CoolDown_GapWidth"]=22,

		["CoolDown_ShowBar"]=1,
		["CoolDown_Decile"]=0,
		["CoolDown_ColorBarByTime"]=0,
		["CoolDown_ColorTextByTime"]=0,
		["CoolDown_AlterDecile"]=0,

		["CoolDown_CombiePet"]=0,

		["CoolDown_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="ADD",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["CoolDown_IconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CoolDown_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\blank",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CoolDown_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CoolDown_TimeData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=5,
			OffsetY=-5,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
		["CoolDown_Reseter"]={
			[11958]={
				[11426]=0,
				[122]=0,
				[44572]=0,
				[120]=0,
				[82676]=0,
				[31687]=0,
				[12472]=0,
				[45438]=0
				},
			[14185]={
				[51722]=0,
				[1766]=0,
				[2983]=0,
				[36554]=0,
				[76577]=0,
				[1856]=0,
				},
			[89485]={
				[89485]=-1,
				},
			[2060]={
				[89485]=5,
				},
			[17116]={
				[17116]=-1,
				},
			[1719]={
				[20230]=-12,
				[871]=-12,
				},
			[20230]={
				[1719]=-12,
				[871]=-12,
				},
			[871]={
				[1719]=-12,
				[20230]=-12
				},
			},

		["CoolDown_Data"]={
			-- Mage
			[11129] = 120,	 --combustion
			[12043]	= 120,	 --presence of mind
			[11113]	= 15,	 --blast wave
			[80353] = 300,	 --time warp
			[82676] = 120,	 --ring of frost
			[1463]	= 12,	 --mana shield
			[120]	= 10,	 --cone of cold
			[1953] 	= 15,    --Blink
			[122] 	= 25,    --Frost Nova
 			[2139] 	= 24,    --Counterspell
			[44572] = 30,    --Deep Freze
			[45438] = 300,   --Ice Block
 		        [55342] = 180,   --Mirror Image
 		        [12472] = 180,   --Icy Veins
			[31687] = 180,   --Summon Water Elemental    
			[12043] = 120,   --Presence of Mind
			[11129] = 120,   --Combustion
			[12042] = 120,   --Arcane Power  
			[11958] = 480,   --Coldsnap
			[12051] = 240,	 --evocation
			[43987] = 300,	 --ritual of refrestment
			[66]	= 300,	 --invisibility
			[82731] = 60,	 --flame orb
			[31661] = 20,	 --dragon's breath
			[11426] = 30,	 --ice barrier
			[12042]	= 120,	 --arcane power
			[31687]	= 180,	 --summon water elemental
			[33395]	= 25,	 --water elemental nova
			-- Priest
			[586]	= 30,	--fade
			[8092]	= 8,	--mind blast
			[17]	= 3,	--power word:shield
			[8122] = 30,    --Psychic Scream  
			[34433] = 300,  --Shadowfiend
			[15487] = 45,   --Silence
			[64044] = 120,  --Psychic Horror   
			[64843] = 480,  --Divine Hymn
			[64901] = 360,  --Hymn of Hope
 		        [47585] = 75,   --Dispersion (+ Glyph)
			[10060] = 120,	--Power Infusion
			[33206] = 80,	--Pain Suppression
			[32379]	= 10,	--shadow word:death
			[6346]	= 180,	--fear ward
			[64901]	= 360,	--hymn of hope
			[34433]	= 300,	--shadowfiend
			[33076] = 10,	--prayer of mending
			[64843] = 480,	--divine hymn
			[73325]	= 90,	--leap of faith
			[19236]	= 120,	--desperate prayer
			[89485]	= 45,	--inner focus
			[724]	= 180,	--lightwell
			[14751]	= 30,	--chakra
			[34861]	= 10,	--circle of healing
			[47788]	= 180,	--guardian spirit
			[62618]	= 120,	--power word:barrier
			[47540]	= 12,	--penance
			[88625]	= 25,	--holy word:chastise
			-- Death Knight
			[47476] = 120,   --Strangulate
			[47528] = 10,    --Mind Freeze
			[48707] = 45,    --Anti-Magic Shell
			[48792] = 120,   --Icebound Fortitude
			[49576] = 35,    --Death Grip
			[47568] = 300,   --Empower Rune Weapon
			[48743] = 120,   --Death Pact
			[51052] = 120,   --Anti-Magic Zone         
			[46585] = 180,	 --Raise Dead
			[49206] = 180,   --Summon Gargoyle
			[49028] = 90,    --Dancing Rune Weapon
			[49203] = 60,    --Hungering Cold    
			[45529]	= 60,	 --blood tap     
			[56222] = 8,	 --dark command
			[57330]	= 20,	 --horn of winter
			[61999] = 600,	 --raise ally
			[42650]	= 600,	 --army of the dead
			[77575] = 60,	 --outbreak
			[77606] = 60,	 --dark simulacrum
			[49039]	= 120,	 --lichborne
			[49222]	= 60,	 --bone shield
			[49016] = 180,	 --unholy frenzy
			[51271]	= 60,	 --pillar of frost
			[48982]	= 30,	 --rune tap
			[55233] = 60,	 --vampiric blood
			[47481] = 60,	 --ghoul gnaw
			[91800]	= 60,	 --ghoul gnaw
			[47484]	= 45,	 --ghoul huddle
			[91838]	= 45,	 --ghoul huddle
			[91797] = 60,	 --ghoul monstrous blow
			[91837]	= 45,	 --ghoul putrid bulwark
			[91802]	= 30,	 --ghoul shambling rush
			[47482]	= 30,	 --ghoul leap
			[91809]	= 30,	 --shoul leap
			-- Druid
			[5217]	= 30,	 --tiger's fury
			[16857] = 6,	 --faerie fire(feral)
			[20484]	= 600,	 --rebrith
			[6795]	= 8,	 --growl
			[467]	= 25,	 --thorns(glyphed)
			[22812]	= 60,    --Barkskin
			[29166]	= 180,   --Innervate
			[5211] 	= 50,    --Bash
			[16689]	= 60,    --Natures Grasp
			[48505]	= 90,    --Starfall
			[50334]	= 180,   --Berserk
			[17116]	= 120,	 --Natures Swiftness
			[33831]	= 180,   --Force of Nature
			[22570] = 10, 	 --maim
			[80964]	= 10,	 --skull bash (cat)
			[80965]	= 10,	 --skull bash (bear)
			[77761]	= 120,	 --stapmeding roar (bear)
			[77764]	= 120,	 --stapmeding roar (cat)
			[8998]	= 10,	 --cower
			[779]	= 6,	 --swipe  (bear)
			[16689]	= 60,	 --nature's grasp
			[740]	= 480,	 --tranquility
			[77758]	= 6,	 --trash
			[88751] = 10,	 --wild mushroom: detonate
			[33891] = 300,	 --tree of life
			[16979]	= 15,	 --feral charge(bear)
			[49376]	= 30,	 --feral charge(cat)
			[17116]	= 180,	 --nature's swiftness
			[50516]	= 20,	 --typhoon
			[78675]	= 60,	 --solar beam
			[33831]	= 180,	 --force of nature
			[61336]	= 180,	 --survival instincts
			[5229]	= 60,	 --enrage(bear)
			[1850]  = 180,	 --dash(cat)
			[22842] = 180,	 --frenzied regeneration
			[18562]	= 15,	 --swiftmend
			-- Shaman
			[57994] = 6,     --Wind Shear 
			[51514] = 30,    --Hex (glyphed)
			[30823] = 60,    --Shamanistic Rage
			[16166] = 180,	 --Elemental Mastery
			[16188] = 120,	 --Natures Swiftness
			[51533] = 180,	 --Feral Spirit         
			[16190] = 300,   --Mana Tide Totem 
          		[8050]	= 6,	 --flame shock
			[8056]	= 6,	 --frost shock
    			[20608]	= 1800,	 --reincarnation
			[2062]	= 600,	 --earth elemental totem
			[5730]	= 20,	 --stoneclaw totem
			[2894]	= 600,	 --fire elemental totem
			[2825]	= 300,	 --bloodlust
			[32182]	= 300,	 --heroism
			[73680] = 15,	 --unleash elements
			[73920] = 10,	 --healing rain
			[79206]	= 120,	 --spiritwalker's grace
			[17364]	= 8,	 --stormstrike
			[61295]	= 6,	 --riptide
			[60103] = 10,	 --lava lash
			[51490]	= 45,	 --thunderstorm
			-- Paladin
			[1022]  = 300,   --Hand of Protection
			[1044] 	= 25,    --Hand of Freedom
			[54428]	= 60,    --Divine Plea   
			[70940]	= 120,   --Divine Guardian
			[853]	= 60,    --Hammer of Justice
 			[642] 	= 300,   --Divine Shield
			[31884] = 180,   --Avenging Wrath
			[31821] = 120,	 --Aura Mastery         
			[20066] = 60,    --Repentance
			[31842] = 180,   --Divine Favor
			[31935] = 30, 	 --Avengers Shield
			[85285]	= 10,    --rebuke
      			[20271]	= 8,	 --judgement
			[62124]	= 8,	 --hand of reckoning
			[633]	= 600,	 --lay on hands
			[26573]	= 30,	 --consecration
			[2812]	= 15,	 --holy wrath
			[498]	= 60,	 --divine protection
			[31789]	= 8,	 --righteous defense
			[24275]	= 6,	 --hammer of wrath
			[1038]	= 120,	 --hand of salvation
			[6940]	= 120,	 --hand of sacrifice
			[82327]	= 60,	 --holy radiance
			[86150]	= 300,	 --guardian of ancient kings
			[31850]	= 180,	 --ardent defender
			[85696]	= 120,	 --zealotry
			[20473]	= 6,	 --holy shock
			-- Warlock
			[5484] 	= 40,    --Howl of Terror
			[6789] 	= 120,   --Death Coil         
			[48020] = 30,    --Demonic Circle: Port
			[30283] = 20,    --Shadowfury
			[59672] = 180,   --Metamorphosis         
			[1122] 	= 600,   --Inferno              
			[19647]	= 24,    --spell lock
			[19505]	= 8,	 --devour magic
			[89808]	= 6,     --singe magic
   			[74434]	= 45,	 --soul burn
			[79268]	= 30,	 --soul harvest
			[6229]	= 30,	 --shadow ward
			[698]	= 120,	 --ritual of summoning
			[1122]	= 600,	 --summon infernal
			[18540]	= 600,	 --summon doomguard
			[54785]	= 45,	 --demon leap
			[29858]	= 120,	 --soul shatter
			[29893]	= 300,	 --ritual of souls
			[47897]	= 12,	 --shadowflame
			[77801]	= 120,	 --demon soul
			[47193]	= 60,	 --demonic empowerment
			[17877]	= 15,	 --shadowburn
			[71521]	= 12,	 --hand of gul'dan
			[91711]	= 30,	 --nether ward
			[50796]	= 12,	 --chaos bolt
			[48181]	= 8,	 --haunt
			[17962]	= 10,	 --conflagrate
			-- Warrior
			[6552] 	=  10,   --Pummel
--removed		[72] 	= 12,    --Shield Bash 
			[23920] = 10,    --Spell Reflection
 			[3411] 	= 30,    --Intervene
			[676] 	= 60,    --Disarm       
			[5246] 	= 120,   --Intimidating Shout 
			[2565] = 60,     --Shield Block
			[55694] = 180,   --Enraged Regeneration
			[20230] = 300,   --Retaliation
			[1719] 	= 300,   --Recklessness                   
			[871] 	= 300,   --Shield Wall
			[12292] = 180,   --Death Wish
			[46924] = 90,    --Bladestorm
			[46968] = 20,    --Shockwave               
			[12975] = 180,   --Last Stand         
			[12809] = 30,    --Concussion Blow
			[100]	= 15,	 --charge
			[355]	= 8,	 --taunt
			[6673]	= 60,	 --battle shout
			[6572]	= 5,	 --revenge
			[1161]	= 180,	 --challenging shout
			[20252]	= 30,	 --intercept
			[18499]	= 30,	 --berserker rage
			[1719]	= 300,	 --recklessness
			[23920]	= 10,	 --spell reflection
			[469]	= 60,	 --commanding shout
			[64382]	= 300,	 --shattering throw
			[55694]	= 180,	 --enraged regeneration
			[57755] = 60,	 --heroic throw
			[86346]	= 20,	 --colossus smash
			[6544]	= 60,	 --heroic leap
			[12809]	= 30,	 --concussion blow
			[12292]	= 180,	 --death wish
			[12975]	= 180,	 --last stand
			[12328]	= 60,	 --sweeping strikes
			[85730]	= 120,	 --deadly calm
			[60970] = 30,	 --heroic fury
			[85388]	= 45,	 --throwdown
			[46924]	= 90,	 --bladestorm
			[46968]	= 20,	 --shockwave
			[12294] = 4.5,	 --mortal strike
			[23922]	= 6,	 --shield slam
			-- Hunter
			[5384]	= 30,	 --feign death
			[53351]	= 10,	 --kill shot
			[13813]	= 30,	 --explosive trap
			[1543]	= 20,	 --flare
			[13809]	= 30,	 --ice trap
			[82939]	= 30,	 --explosive trap
			[60192]	= 30,	 --freezing trap
			[82941]	= 30,	 --ice trap
			[82945]	= 30,	 --immolation trap
			[82948]	= 30,	 --snake trap
			[20736]	= 8,	 --distracting shot
			[3045]	= 180,	 --rapid fire (talented)
			[34600]	= 30,	 --snake trap
			[53271]	= 60,	 --master's call
			[34477]	= 30,	 --misdirection
			[19263]	= 120,	 --deterrence
			[51753]	= 60,	 --camouflage
			[19306]	= 5,	 --counterattack
			[82726]	= 120,	 --fervor
			[82692]	= 15,	 --focus fire
			[34490]	= 20,	 --silencing shot
			[19574]	= 120,	 --bestial wrath
			[23989]	= 180,	 --readiness
			[19386]	= 60,	 --wyvern sting
			[3674]	= 30,	 --black arrow
			[53209]	= 9,	 --chimera shot(glyphed)
			[53301]	= 6,	 --explosive shot
			[19577]	= 60,	 --intimidation
			-- Rogue
			[5277]	= 120,	 --evasion (talented)
			[1766]	= 10,	 --kick
			[1776]	= 10,	 --gouge
			[2983]	= 60,	 --sprint
			[1856]	= 120,	 --vanish (talented)
			[1725]	= 30,	 --distract
			[408]	= 20,	 --kidney shot
			[2094]	= 120,	 --blind(talented)
			[51722]	= 60,	 --dismantle
			[1966]	= 10,	 --feint
			[31224]	= 60,	 --cloak of shadows(talented)
			[57934]	= 30,	 --tricks of the trade
			[74001] = 120,	 --combat readiness
			[73981]	= 60,	 --redirect
			[76577]	= 180,	 --smoke bomb
			[14177]	= 120,	 --cold blood
			[14183]	= 20,	 --premediation
			[13750]	= 180,	 --ardenaline rush
			[14185]	= 300,	 --preparation
			[51690]	= 120,	 --killing spree
			[51713]	= 60,	 --shadow dance
			[79140]	= 120,	 --vendetta
			[31230] = 90,	 --cheat death
			[36554]	= 20,	 --shadowstep
			--trinket
			[42292] = 120,	 --trinket
			--racial
			--draenei
			[59543] = 180,	 --gift of the naaru
			--dwarf
			[65116]	= 120,	 --stoneform
			--gnome
			[20589]	= 90,	 --escape artist
			--human
			[59752] = 120,	 --every man for himself
			--night elf
			[58984]	= 120,	 --shadowmeld
			--worgen
			[68992]	= 180,	 --darkflight
			--bloodelf
			[28730]	= 120,	 --arcane torrent
			--goblin
			[69070]	= 120,	 --rocket jump
			[69046]	= 1800,	 --pack hobgoblin
			[69041]	= 120,	 --rocket barrage
			--orc
			[20572]	= 120,	 --blood fury
			--tauren
			[20549]	= 120,	 --war stomp
			--troll
			[26297]	= 180,	 --berserking
			--undead
			[7744] = 45, 	 -- will of the forsaken
		}
	}

local NPA_CoolDown_Config=NPA_CoolDown_DefaultSetting

function NPA_CoolDown:ResetConfig()
	NPA_Config["CoolDown"]=CopyTable(NPA_CoolDown_DefaultSetting)
end


local NPA_CoolDown_IconCache={}

-- get global functions
local pairs = pairs
local table_insert = table.insert
local table_remove = table.remove
local CopyTable=CopyTable
local table_getn=table.getn
local abs=abs

local string_gmatch=string.gmatch


--cooldown data , copied from gladius
local NPA_UnitCoolDown={}

function NPA_CoolDown:ClearData()
	NPA_UnitCoolDown={}
end

local NPA_ManageBar=NPA_Core.ManageBar

local function NPA_CoolDown_SetIconDisplay(main,spellid,timeleft,showbar)
	main.Icon:SetTexture(NPA_CoolDown_IconCache[spellid])
	local timetext
	if(NPA_CoolDown_Config["CoolDown_Short"]==1 and timeleft>100)then
		timetext=floor(timeleft/60).."m"
	else
		if(timeleft<2 and NPA_CoolDown_Config["CoolDown_Decile"]==1)then
			if(NPA_CoolDown_Config["CoolDown_AlterDecile"]~=1)then
				timetext=floor(timeleft*10)/10
			elseif(timeleft<1)then
				timetext="."..floor(timeleft*10)
			else
				timetext=floor(timeleft)
			end
		else
			timetext=floor(timeleft)
		end
	end

	if(NPA_CoolDown_Config["CoolDown_ColorTextByTime"]==1)then
		if(timeleft>60)then
			timetext="|cffffff00"..timetext
		elseif(timeleft>3)then
			timetext="|cffffff00"..timetext
		else
			timetext="|cffff0000"..timetext
		end
	end

	main.Text:SetText(timetext)


	if(showbar==1)then
		local bar=main.Bar
		bar.Percent=timeleft/(NPA_CoolDown_Config["CoolDown_Data"][spellid] or 1)
		NPA_ManageBar(nil,bar)

		if(NPA_CoolDown_Config["CoolDown_ColorBarByTime"]==1)then
			local percent=bar.Percent
			bar:SetVertexColor(bar.R*(1-percent),bar.G*percent,0)
		end
	
	else
		main.Bar:Hide()
	end

	main:Show()
end	

local function NPA_CoolDown_OnUpdate(nTime,self,guid,unitdata)
	local cooldown=NPA_UnitCoolDown[guid]
	local petcooldown
	if(NPA_CoolDown_Config["CoolDown_CombiePet"]==1 and unitdata and unitdata.PetGUID)then
		petcooldown=NPA_UnitCoolDown[unitdata.PetGUID]
	end

	if(cooldown==nil and petcooldown==nil)then
		self:Hide()
		return
	end
	
	icon=self.IconFrame

	local bestid
	local besttime
	local cdlist={}
	local endindex
	local showbar=NPA_CoolDown_Config["CoolDown_ShowBar"]

	if(cooldown)then
		for i=1,NPA_CoolDown_Config["CoolDown_Max"] do
			bestid=0
			besttime=10000
			for spellid,endtime in pairs(cooldown) do
				local timeleft=endtime-nTime
				if(endtime>nTime  and timeleft<besttime and (not cdlist[spellid]))then
					besttime=timeleft
					bestid=spellid
				end
			end
			if(bestid~=0)then
				NPA_CoolDown_SetIconDisplay(icon[i],bestid,besttime,showbar)
				cdlist[bestid]=1
			else
				icon[i]:Hide()
				endindex=i
				break
			end
		end	
	end

	if(petcooldown)then
		if(not endindex)then
			endindex=1
		end
		for i=endindex,NPA_CoolDown_Config["CoolDown_Max"] do
			bestid=0
			besttime=10000
			for spellid,endtime in pairs(petcooldown) do
				local timeleft=endtime-nTime
				if(endtime>nTime  and timeleft<besttime and (not cdlist[spellid]))then
					besttime=timeleft
					bestid=spellid
				end
			end
			if(bestid~=0)then
				NPA_CoolDown_SetIconDisplay(icon[i],bestid,besttime,showbar)
				cdlist[bestid]=1
			else
				icon[i]:Hide()
				endindex=i
				break
			end
		end
	elseif(not endindex)then
		endindex=NPA_CoolDown_Config["CoolDown_Max"]+1
	end


	if(not endindex)then
		endindex=NPA_CoolDown_Config["CoolDown_Max"]+1
	end

	for i=endindex,self.Count do
		icon[i]:Hide()
	end

	if(icon[1]:IsShown())then
		self:Show()
	else
		self:Hide()
	end

end
local function NPA_CoolDown_CreateIconFrame(mainframe)
	local iconframe=CreateFrame("Frame","NPA_CoolDown_IconFrame",mainframe)
	iconframe:SetWidth(1)
	iconframe:SetHeight(1)
	iconframe:Hide()

	iconframe.Icon=iconframe:CreateTexture(nil,"BORDER")
	iconframe.Icon:Show()
	iconframe.Background=iconframe:CreateTexture(nil,"BACKGROUND")
	iconframe.Background:Show()
	iconframe.Overlay=iconframe:CreateTexture(nil,"OVERLAY")
	iconframe.Overlay:Show()
	iconframe.Text=iconframe:CreateFontString(nil,"OVERLAY")
	iconframe.Text:Show()

	iconframe.Bar=iconframe:CreateTexture(nil,ARTWORK)
	iconframe.Bar:Hide()

	return iconframe
end


local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_CoolDown_SetIconFrame(main)
	main:SetPoint("CENTER",main:GetParent(),"CENTER",NPA_CoolDown_Config["CoolDown_OffsetX"],NPA_CoolDown_Config["CoolDown_OffsetY"])

	local frame=main.IconFrame

	for i=1,NPA_CoolDown_Config["CoolDown_Max"] do
		if(not frame[i])then
			frame[i]=NPA_CoolDown_CreateIconFrame(main)
		end
		local iconframe=frame[i]

		ManageTexture(nil,iconframe.Icon,NPA_CoolDown_Config["CoolDown_IconData"],iconframe)
		ManageTexture(nil,iconframe.Background,NPA_CoolDown_Config["CoolDown_BackgroundData"],iconframe)
		ManageTexture(nil,iconframe.Overlay,NPA_CoolDown_Config["CoolDown_OverlayData"],iconframe)
		ManageFont(nil,iconframe.Text,NPA_CoolDown_Config["CoolDown_TimeData"],iconframe)
		ManageTexture(nil,iconframe.Bar,NPA_CoolDown_Config["CoolDown_BarData"],iconframe,1)

		local offset=i-1
		local offsetx=(offset % NPA_CoolDown_Config["CoolDown_Row"])*NPA_CoolDown_Config["CoolDown_GapWidth"]
		local offsety=floor(offset/NPA_CoolDown_Config["CoolDown_Row"])*NPA_CoolDown_Config["CoolDown_GapHeight"]
		if(NPA_CoolDown_Config["CoolDown_GrowUp"]~=1)then
			offsety=-offsety
		end
		if(NPA_CoolDown_Config["CoolDown_GrowRight"]~=1)then
			offsetx=-offsetx
		end

		iconframe:SetPoint("TOPLEFT",main,"TOPLEFT",offsetx,offsety)
		iconframe:Hide()
	end
	for i=NPA_CoolDown_Config["CoolDown_Max"]+1, table_getn(frame) do
		frame[i]:Hide()
	end

	main.Count=table_getn(frame)
end


local function NPA_CoolDown_CreateIconFrames(mainframe)
	local data={}
	for i=1,NPA_CoolDown_Config["CoolDown_Max"] do 
		data[i]=NPA_CoolDown_CreateIconFrame(mainframe)
	end
	return data
end

local function NPA_CoolDown_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_CoolDown_MainFrame",frame)
	main:SetPoint("CENTER",frame,"CENTER")
	main:SetHeight(1)
	main:SetWidth(1)

	main.IconFrame=NPA_CoolDown_CreateIconFrames(main)

	table_insert(NPA_CoolDown_Frame,main)

	NPA_CoolDown_SetIconFrame(main)

	frame["CoolDown"]=main
end

function NPA_CoolDown:Test()
	local cddata={}

	local nTime=GetTime()
	for i=1,NPA_Config["CoolDown"]["CoolDown_Max"] do
		for spellid,time in pairs(NPA_CoolDown_Config["CoolDown_Data"]) do
			if(random()>0.5)then
				cddata[spellid]=nTime+time
				break
			end
		end
	end

	NPA_UnitCoolDown[-100]=cddata
end

local function NPA_CoolDown_ResetCheck(spellid)
	local list=NPA_CoolDown_Config["CoolDown_Reseter"][spellid]
	if(list)then
		for id,value in pairs(list) do
			if(id==spellid and value==-1)then
				return 1
			end
		end
	end
end


local NPA_Unit_CoolDownFunc={
	[1]=function(casterguid,spellid)
		if(NPA_CoolDown_Config["CoolDown_Data"][spellid] and not(NPA_CoolDown_ResetCheck(spellid)))then	
			if(NPA_UnitCoolDown[casterguid]==nil)then
				NPA_UnitCoolDown[casterguid]={}
			end

		
			NPA_UnitCoolDown[casterguid][spellid]=GetTime()+NPA_CoolDown_Config["CoolDown_Data"][spellid]
		end

		local list=NPA_CoolDown_Config["CoolDown_Reseter"][spellid]
		if(list)then
			if(NPA_UnitCoolDown[casterguid]==nil)then
				NPA_UnitCoolDown[casterguid]={}
			end
			
			for id,value in pairs(list) do
				if(value==0)then
					NPA_UnitCoolDown[casterguid][id]=nil
				elseif(value<-1)then
					local endtime=GetTime()+abs(value)
					local otime=NPA_UnitCoolDown[casterguid][id]
					if((not otime) or otime<endtime)then
						NPA_UnitCoolDown[casterguid][id]=endtime
					end
				else
					NPA_UnitCoolDown[casterguid][id]=(NPA_UnitCoolDown[casterguid][id] or 0)-value
				end
			end
		end
	end,

	---special check

	[2]=function(casterguid,spellid)
		local list=NPA_CoolDown_Config["CoolDown_Reseter"][spellid]
		if(list)then
			if(NPA_UnitCoolDown[casterguid]==nil)then
				NPA_UnitCoolDown[casterguid]={}
			end
			
			for id,value in pairs(list) do
				if(value==-1)then
					local cd=NPA_CoolDown_Config["CoolDown_Data"][id]
					if(cd)then
						NPA_UnitCoolDown[casterguid][id]=GetTime()+cd
					end
				end
			end
		end
	end

	}


local NPA_CoolDown_CombatLogFilter={
	["SPELL_CAST_SUCCESS"]=1,
	["SPELL_HEAL"]=1,
	["SPELL_DAMAGE"]=1,
	["SPELL_MISSED"]=1,
--	["SPELL_DISPEL_FAILED"]=2,
	["SPELL_AURA_APPLIED"]=1,
--	["SPELL_AURA_REFRESH"]=1,

	["SPELL_AURA_REMOVED"]=2,
	["SPELL_STOLEN"]=2,
	["SPELL_DISPEL"]=2
	}
local function NPA_CoolDown_OnEvent(uarg)
	--handle events
	local i=NPA_CoolDown_CombatLogFilter[uarg[2]]
	if(i)then
		NPA_Unit_CoolDownFunc[i](uarg[3],uarg[9])
	end

end



function NPA_CoolDown:ApplyConfig()
	NPA_Core:CheckConfigEntry("CoolDown",NPA_CoolDown_DefaultSetting)

	NPA_CoolDown_Config=NPA_Config["CoolDown"]

	for _,mainframe in pairs(NPA_CoolDown_Frame) do
		NPA_CoolDown_SetIconFrame(mainframe)
	end

	for spellid,_ in pairs(NPA_CoolDown_Config["CoolDown_Data"]) do
		_,_,NPA_CoolDown_IconCache[spellid]=GetSpellInfo(spellid)
	end
	for spellid,list in pairs(NPA_CoolDown_Config["CoolDown_Reseter"]) do
		_,_,NPA_CoolDown_IconCache[spellid]=GetSpellInfo(spellid)
		for id,_ in pairs(list) do
			_,_,NPA_CoolDown_IconCache[id]=GetSpellInfo(id)
		end
	end

	--custom spell icon pvp icon 
	NPA_CoolDown_IconCache[42292]="Interface\\Icons\\INV_Jewelry_TrinketPVP_01"
	NPA_CoolDown_IconCache[59752]="Interface\\Icons\\INV_Jewelry_TrinketPVP_01"

	if(NPA_Config["Core"]["EnableModule"]["CoolDown"]==1)then
		NPA_Core.CombatEventFunc["CoolDown"]=NPA_CoolDown_OnEvent
	else
		NPA_Core.CombatEventFunc["CoolDown"]=nil
	end
end

--onload functions
NPA_Core:AddHook("CoolDown",NPA_CoolDown_HookFrame)
NPA_Core:AddModule("CoolDown",NPA_CoolDown)
NPA_Core:HookUpdate("CoolDown",NPA_CoolDown_OnUpdate,2)