-- Author      : Nogarder
-- Create Date : 2010/7/4 18:39:17


local NPA_ComboPoint_TargetGUID=nil
local NPA_ComboPoint_Num=0

local NPA_ComboPoint={}
--config
local NPA_ComboPoint_DefaultSetting={
		["ComboPoint_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=-75,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ComboPoint_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ComboPoint_BarOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ComboPoint_BarBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["ComboPoint_OffsetX"]=0,
		["ComboPoint_OffsetY"]=0,

		["ComboPoint_Color"]=1,
		["ComboPoint_ShowText"]=1,
		["ComboPoint_ShowBar"]=0,

	}
local NPA_ComboPoint_Config=NPA_ComboPoint_DefaultSetting

function NPA_ComboPoint:ResetConfig()
	NPA_Config["ComboPoint"]=CopyTable(NPA_ComboPoint_DefaultSetting)
end


--global function
local UnitGUID=UnitGUID

local NPA_ComboPoint_Frame={}
local table_insert=table.insert

function NPA_ComboPoint:GetComboPoint()
	return NPA_ComboPoint_Num
end

local ManageBar=NPA_Core.ManageBar

local function NPA_ComboPoint_OnUpdate(_,self,guid)
	if(guid==NPA_ComboPoint_TargetGUID and NPA_ComboPoint_Num>0)then
		local percent=NPA_ComboPoint_Num/5
		local bpercent=1-percent
		
		if(NPA_ComboPoint_Config["ComboPoint_ShowText"]==1)then
			local text=self.Text
			text:SetText(NPA_ComboPoint_Num)
			text:SetTextColor(percent,bpercent,0,1)
			text:Show()
		else
			self.Text:Hide()
		end
		if(NPA_ComboPoint_Config["ComboPoint_ShowBar"]==1)then
			local bar=self.Bar
			bar.Percent=percent
			ManageBar(nil,bar)
			if(NPA_ComboPoint_Config["ComboPoint_Color"]==1)then
				bar:SetVertexColor(bar.R*percent,bar.G*bpercent,0)
			else
				bar:SetVertexColor(bar.R,bar.G,bar.B)
			end
			bar:Show()
		else
			self.Bar:Hide()
		end
		
		self:Show()
	else
		self:Hide()		
	end
end


local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_ComboPoint_SetFrame(mainframe)
	mainframe:SetPoint("CENTER",mainframe:GetParent(),"CENTER",NPA_ComboPoint_Config["ComboPoint_OffsetX"],NPA_ComboPoint_Config["ComboPoint_OffsetY"])
	ManageTexture(nil,mainframe.Bar,NPA_ComboPoint_Config["ComboPoint_BarData"],mainframe,1)
	ManageTexture(nil,mainframe.Background,NPA_ComboPoint_Config["ComboPoint_BarBackgroundData"],mainframe)
	ManageTexture(nil,mainframe.Overlay,NPA_ComboPoint_Config["ComboPoint_BarOverlayData"],mainframe)

	ManageFont(nil,mainframe.Text,NPA_ComboPoint_Config["ComboPoint_TextData"],mainframe)

	if(NPA_ComboPoint_Config["ComboPoint_ShowBar"]==1)then
		mainframe.Background:Show()
		mainframe.Overlay:Show()
	else
		mainframe.Background:Hide()
		mainframe.Overlay:Hide()
	end
end

local function NPA_ComboPoint_HookFrame(frame)
	local mainframe=CreateFrame("Frame","NPA_ComboPoint_MainFrame",frame)
	mainframe:SetPoint("CENTER",frame,"CENTER")
	mainframe:SetHeight(1)
	mainframe:SetWidth(1)
	mainframe:Hide()

	local text=mainframe:CreateFontString("NPA_ComboPoint_Text","OVERLAY",nil)

	local bar=mainframe:CreateTexture("NPA_ComboPoint_Bar","ARTWORK",nil)
	local overlay=mainframe:CreateTexture("NPA_ComboPoint_Bar","OVERLAY",nil)
	local background=mainframe:CreateTexture("NPA_ComboPoint_Bar","BACKGROUND",nil)

	mainframe.Bar=bar
	mainframe.Background=background
	mainframe.Overlay=overlay
	mainframe.Text=text
	
	NPA_ComboPoint_SetFrame(mainframe)

	table_insert(NPA_ComboPoint_Frame,mainframe)

	frame["ComboPoint"]=mainframe
end


local function NPA_ComboPoint_OnEvent()
	NPA_ComboPoint_TargetGUID=UnitGUID("target")
	NPA_ComboPoint_Num=GetComboPoints("player","target")
end


function NPA_ComboPoint:ApplyConfig()
	NPA_Core:CheckConfigEntry("ComboPoint",NPA_ComboPoint_DefaultSetting)

	NPA_ComboPoint_Config=NPA_Config["ComboPoint"]

	for _,mainframe in pairs(NPA_ComboPoint_Frame) do
		NPA_ComboPoint_SetFrame(mainframe)
	end

	if(NPA_Config["Core"]["EnableModule"]["ComboPoint"]==1)then
		NPA_Core:RegisteEvent("UNIT_COMBO_POINTS",NPA_ComboPoint_OnEvent)
	else
		NPA_Core:RegisteEvent("UNIT_COMBO_POINTS",nil)
	end
end

NPA_Core:AddHook("ComboPoint",NPA_ComboPoint_HookFrame)
NPA_Core:AddModule("ComboPoint",NPA_ComboPoint)
NPA_Core:HookUpdate("ComboPoint",NPA_ComboPoint_OnUpdate,2)