﻿-- Author      : Nogarder
-- Create Date : 2010/7/7 18:46:38

local NPA_ClassInfo={}
local locale=GetLocale()
--config
local NPA_ClassInfo_DefaultSetting={
		["ClassInfo_CPTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=0,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_CPBarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=0,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_CPBarOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_CPBarBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["ClassInfo_PetIconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=40,
			Width=40,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_PetBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=42,
			Width=42,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\blank",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_PetOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=42,
			Width=42,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_PetTextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=5,
			OffsetY=-5,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_IconData"]={
			OffsetX=-70,
			OffsetY=-15,
			Height=15,
			Width=15,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_IconBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_IconOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["ClassInfo_SparkData"]={
			OffsetX=0,
			OffsetY=0,
			Height=30,
			Width=30,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\CastingBar\\UI-CastingBar-Spark",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_LunarBarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			RAngle=0,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassInfo_StanceOffsetX"]=-68,
		["ClassInfo_StanceOffsetY"]=0,
		["ClassInfo_ResourceOffsetX"]=0,
		["ClassInfo_ResourceOffsetY"]=-20,
		["ClassInfo_ResourceWidth"]=120,
		["ClassInfo_ResourceHeight"]=7,
		["ClassInfo_ResourceBarTexture"]="Interface\\TargetingFrame\\UI-StatusBar",
		["ClassInfo_ResourceBorderTexture"]="Interface\\Tooltips\\UI-StatusBar-Border",
		["ClassInfo_ResourceBorderTextureBlend"]="BLEND",
		["ClassInfo_Stance"]=1,
		["ClassInfo_Totem"]=1,
		["ClassInfo_ComboPoint"]=1,
		["ClassInfo_Rune"]=1,
		["ClassInfo_HolyPower"]=1,
		["ClassInfo_ComboPointDruid"]=1,
		["ClassInfo_HunterCombo"]=1,
		["ClassInfo_LunarEnergy"]=1,
		["ClassInfo_Shard"]=1,
		["ClassInfo_Stick"]=1,

		["ClassInfo_Ghoul"]=1,
		["ClassInfo_ShadowFiend"]=1,
		["ClassInfo_Treant"]=1,
		["ClassInfo_Inferno"]=1,
		["ClassInfo_PetFrameOffsetX"]=0,
		["ClassInfo_PetFrameOffsetY"]=-50,
		["ClassInfo_CPOffsetX"]=0,
		["ClassInfo_CPOffsetY"]=0,
		["ClassInfo_LunarOffsetX"]=0,
		["ClassInfo_LunarOffsetY"]=0,
		["ClassInfo_TotemOffsetX"]=0,
		["ClassInfo_TotemOffsetY"]=0,


	}

local NPA_ClassInfo_Config=NPA_ClassInfo_DefaultSetting

function NPA_ClassInfo:ResetConfig()
	NPA_Config["ClassInfo"]=CopyTable(NPA_ClassInfo_DefaultSetting)
end


--global functions
local abs=abs
local pairs = pairs
local floor = floor
local table_insert = table.insert
local table_getn = table.getn
local unpack=unpack

local bit_band=bit.band
local COMBATLOG_OBJECT_TYPE_PLAYER=COMBATLOG_OBJECT_TYPE_PLAYER

local GetTime = GetTime

local NPA_ClassInfo_Frame={}

local NPA_ClassInfo_StanceData={}
--main

local NPA_ClassInfo_StanceSpellData={
	--warrior
	[2458]=1,
	[2457]=1,
	[71]=1,
}
local NPA_ClassInfo_StanceAuraData={
	--deathknight
	[48263]=1,
	[48266]=1,
	[48265]=1,
	--hunter
	[13165]=1,
	[82661]=1,
	[5118]=1,
	[13159]=1,
	[20043]=1,
	--paladin
	[19746]=1,
	[19891]=1,
	[7294]=1,
	[32223]=1,
	[465]=1,
	--druid
	[5487]=1,
	[1066]=1,
	[768]=1,
	[783]=1,
	[40120]=1,
	[24858]=1,
	[33891]=1,
	--warlock
	[687]=1,
	[28176]=1,
	--mage
	[30482]=1,
	[86941]=1,
	[7302]=1,
	[6117]=1,
	--priest
	[15473]=1
}
local NPA_ClassInfo_FinishSpellData={
	--rogue
	[26679]=0,
	[32645]=0,
	[2098]=0,
	[408]=0,
	[1943]=0,
	[5171]=0,
	[73651]=0,
	[73981]=-1,
	[8676]=3,
	[1833]=3,
	[703]=2,
	[14183]=2,

	--druid
	[22570]=0,
	[22568]=0,
	[1079]=0,
	[52610]=0,
}

local NPA_ClassInfo_ComboSpellData={
	--rogue
	[53]=1,
	[1776]=1,
	[84617]=1,
	[5938]=1,
	[1752]=1,
	[16511]=1,
	
	[5374]=1,
	[27576]=1,
	--druid
	[1082]=1,
	[33876]=1,
	[1822]=1,
	[6785]=1,
	[5221]=1,
}
local NPA_ClassInfo_HPSpellData={
	[85673]=1,
	[84963]=1,
	[85256]=1,
	[53600]=1,	
	
}

local NPA_ClassInfo_TotemSpellData={
	--1=earth ,2=water, 3=wind, 4=fire
	[3599]=4,--Searing Totem
	[2484]=1,--Earthbind Totem
	[8190]=4,--Magma Totem
	[5730]=1,--Stoneclaw Totem
	[2894]=4,--Fire Elemental Totem
	[8075]=1,--Strength of Earth Totem
	[8227]=4,--Flametongue Totem
	[8512]=3,--Windfury Totem
	[8177]=1,--Grounding Totem
	[3738]=3,--Wrath of Air Totem
	[8071]=1,--Stoneskin Totem
	[2062]=1,--Earth Elemental Totem
	[8184]=2,--Elemental Resistance Totem
	[5394]=2,--Healing Stream Totem
	[5675]=2,--Mana Spring Totem
	[8143]=1,--Tremor Totem
	[87718]=2,--Totem of Tranquil Mind
	[16190]=2,--Mana Tide Totem
}
local NPA_ClassInfo_RuneAttackSpellData={
	--1= blood, 10=frost, 100=unholy 110=unholy&frost,11=blood&frost,0=reset blood, 111=blood&unholy&frost,-1=reset all
	[45902]=1,
	[49998]=110,
	[55050]=1,
	[85948]=11,		
	[45477]=10,
	[49020]=110,
	[45462]=100,
	[73975]=100,
	[55090]=100
}
local NPA_ClassInfo_RuneCastSpellData={
	[48721]=1,
	[45529]=1,
	[50842]=1,
	[49222]=100,
	[48982]=1,
	[3714]=10,
	[47568]=-1,
	[45529]=0,
	[43265]=100,
	[50977]=100,
	[42650]=111,
}
local NPA_ClassInfo_RuneDebuffSpellData={
	[47476]=1,
	[45524]=1,
}
local NPA_ClassInfo_RuneTypeColor={
	[1]={1,0,0,1},
	[2]={0,0.5,0.8,1},
	[3]={0,0.8,0.1},
	[4]={0.8,0,0.5,1},
	[5]={0.8,0,0.5,1},
	[6]={0.8,0,0.5,1},
}

local NPA_ClassInfo_RuneCoolDownTime=8

local NPA_ClassInfo_TalentSpellData={
	--deathknight --1=blood, 2=unholy
	[55050]=1,
	[49222]=1,
	[48982]=1,
	[49028]=1,
	[55090]=2,
	[49206]=2,
	[49016]=2,
	[51052]=2
}

local NPA_ClassInfo_DKBloodSpellData={
	[49998]=1,
	[49020]=1,
}
local NPA_ClassInfo_DKUnholySpellData={
	[45902]=1,
	[50842]=1,
	[85948]=1
}

local NPA_ClassInfo_PetSpellData={
	[46585]=60,
	[34433]=15,
	[33831]=30,
	[1122]=45,
}
local NPA_ClassInfo_PetIconData={
	[34433]="Interface\\Icons\\Spell_Shadow_ShadowFiend",
	[46585]="Interface\\Icons\\Spell_Shadow_AnimateDead",
	[33831]="Interface\\Icons\\Ability_Druid_ForceofNature",
	[1122]="Interface\\Icons\\Spell_Shadow_SummonInfernal",
	}

local NPA_ClassInfo_ComboPoint={}
local NPA_ClassInfo_ComboTarget={}
local NPA_ClassInfo_ComboLastCrit={}
local NPA_ClassInfo_HPData={}
local NPA_ClassInfo_TotemData={}
local NPA_ClassInfo_TotemOwner={}
local NPA_ClassInfo_Rune={}
local NPA_ClassInfo_RuneType={}
local NPA_ClassInfo_TalentData={}
local NPA_ClassInfo_HunterCombo={}
local NPA_ClassInfo_LPData={}
local NPA_ClassInfo_SoulShard={}
local NPA_ClassInfo_PetData={}
local NPA_ClassInfo_PetOwner={}

local SpellData=NPA_Core.SpellData

local function NPA_ClassInfo_CheckStance(auralist,guid)
	if(not auralist)then
		return
	end

	for spellid,auras in pairs(auralist) do
		if(table_getn(auras)>0 and NPA_ClassInfo_StanceAuraData[spellid])then
			for _,aura in pairs(auras) do
				if(aura.CasterGUID==guid)then
					return spellid
				end
			end
		end
	end
		
end

function NPA_ClassInfo:ClearData()
	NPA_ClassInfo_ComboPoint={}
	NPA_ClassInfo_ComboTarget={}
	NPA_ClassInfo_ComboLastCrit={}
	NPA_ClassInfo_HPData={}
	NPA_ClassInfo_TotemData={}
	NPA_ClassInfo_TotemOwner={}
	NPA_ClassInfo_Rune={}
	NPA_ClassInfo_RuneType={}
	NPA_ClassInfo_TalentData={}
	NPA_ClassInfo_HunterCombo={}
	NPA_ClassInfo_LPData={}
	NPA_ClassInfo_SoulShard={}
	NPA_ClassInfo_PetData={}
	NPA_ClassInfo_PetOwner={}
end

local function NPA_ClassInfo_SetRuneIcon(runecd,runetype,icon,time)
	if((not runecd) or runecd<time)then
		icon:SetWidth(icon.Max)
	else
		local width=(1-(runecd-time)/NPA_ClassInfo_RuneCoolDownTime)*icon.Max
		if(width<1)then
			width=1
		end
		icon:SetWidth(width)
	end
	if(runetype)then
		icon:SetTexture(unpack(NPA_ClassInfo_RuneTypeColor[runetype]))
	else
		icon:SetTexture(unpack(NPA_ClassInfo_RuneTypeColor[icon.Type]))
	end
end

local NPA_ClassInfo_LunarAura={
	[48518]=1,
	[48517]=2
}

local function NPA_ClassInfo_CheckLunar(auralist)
	if(not auralist)then
		return
	end

	for spellid,auras in pairs(auralist) do
		if(table_getn(auras)>0)then
			local check=NPA_ClassInfo_LunarAura[spellid]	
			if(check)then
				return check
			end
		end
	end
	return nil
end
local NPA_ClassInfo_Modules={}

local ManageBar=NPA_Core.ManageBar

local function NPA_ClassInfo_BuildModules()
	NPA_ClassInfo_Modules={}

	--stance
	if(NPA_ClassInfo_Config["ClassInfo_Stance"]==1)then
		NPA_ClassInfo_Modules["Stance"]=function(_,self,guid,unitdata)
			local stance
			if(NPA_ClassInfo_StanceData[guid])then
				stance=NPA_ClassInfo_StanceData[guid]
			else	
				stance=NPA_ClassInfo_CheckStance(unitdata.Aura,guid)
			end
			if(stance)then
				local spelldata=SpellData[stance]
				if(spelldata)then
					self.Stance.Stance:SetTexture(spelldata.Icon)
					self.Stance:Show()
				else
					self.Stance:Hide()
				end
			else
				self.Stance:Hide()
			end
		end
	end

	if(NPA_ClassInfo_Config["ClassInfo_Stick"]==1)then
		NPA_ClassInfo_Modules["Stick"]=function(_,self,_,_,_,frame)
			self.Resource:ClearAllPoints()

			local castwarning=frame["CastWarning"]
			if(castwarning and castwarning:IsShown())then
				if(castwarning.Text:IsShown())then
					self.Resource:SetPoint("TOP",castwarning.Text,"BOTTOM",0,-10)
				else
					self.Resource:SetPoint("TOP",castwarning,"BOTTOM",0,-10)
				end
			else
				local manabar=frame["ManaBar"]
				if(manabar and manabar:IsShown())then
					self.Resource:SetPoint("TOP",manabar,"BOTTOM",0,-10)
				else
					local healthbar=frame["HealthBar"]
					if(healthbar and healthbar:IsShown())then
						self.Resource:SetPoint("TOP",healthbar,"BOTTOM",0,-10)
					else
						self:Hide()
						return
					end
				end
			end
		end
	end
	--combopoint
	if(NPA_ClassInfo_Config["ClassInfo_ComboPoint"]==1 or 
	   NPA_ClassInfo_Config["ClassInfo_HolyPower"]==1 or
	   NPA_ClassInfo_Config["ClassInfo_ComboPointDruid"]==1 or 
	   NPA_ClassInfo_Config["ClassInfo_HunterCombo"]==1)then
		NPA_ClassInfo_Modules["ComboPoint"]=function(_,self,guid,unitdata,selfguid)
			local classmark=unitdata.ClassMark
			--rogue
			if(classmark=="ROGUE" and NPA_ClassInfo_Config["ClassInfo_ComboPoint"]==1)then
				local bar=self.ComboPoint.Bar
				if(guid==selfguid)then
					bar.Percent=GetComboPoints("player","target")/5
				else
					bar.Percent=NPA_ClassInfo_ComboPoint[guid]
				end
				ManageBar(nil,bar,1)
				self.ComboPoint:Show()
			--druid
			elseif(classmark=="DRUID" and NPA_ClassInfo_Config["ClassInfo_ComboPointDruid"]==1)then
				local bar=self.ComboPoint.Bar
				if(guid==selfguid)then
					bar.Percent=GetComboPoints("player","target")/5
				else
					bar.Percent=NPA_ClassInfo_ComboPoint[guid]
				end
				ManageBar(nil,bar,1)
				self.ComboPoint:Show()
			--paladin
			elseif(classmark=="PALADIN" and NPA_ClassInfo_Config["ClassInfo_HolyPower"]==1)then
				local bar=self.ComboPoint.Bar
				if(guid==selfguid)then
					bar.Percent=UnitPower("player",9)/3
				else
					bar.Percent=NPA_ClassInfo_HPData[guid]
				end
				ManageBar(nil,bar,1)
				self.ComboPoint:Show()
			--hunter
			elseif(classmark=="HUNTER" and NPA_ClassInfo_Config["ClassInfo_HunterCombo"]==1)then
				local bar=self.ComboPoint.Bar
				bar.Percent=NPA_ClassInfo_HunterCombo[guid]
				ManageBar(nil,bar,1)
				self.ComboPoint:Show()
			else
				self.ComboPoint:Hide()
			end
		end
	end


	--lunar energy
	if(NPA_ClassInfo_Config["ClassInfo_LunarEnergy"]==1)then
		NPA_ClassInfo_Modules["LunarBar"]=function(_,self,guid,unitdata,selfguid)
			if(unitdata.ClassMark=="DRUID")then
				local lpercent
				if(guid==selfguid)then
					lpercent=UnitPower("player",8)/100
				else
					lpercent=NPA_ClassInfo_LPData[guid]
				end
				if(lpercent and lpercent~=0)then
					local lunar=self.Lunar
					local spark=lunar.Spark
					local offsetx=lunar.Bar:GetWidth()/2
					local eclipsecheck=NPA_ClassInfo_CheckLunar(unitdata.Aura)

					if(abs(lpercent)>0.9 or eclipsecheck)then
						local shakex=random()*2-1
						local shakey=random()*2-1
						spark:SetPoint("CENTER",lunar,"CENTER",offsetx*lpercent+shakex,shakey)
					else
						spark:SetPoint("CENTER",lunar,"CENTER",offsetx*lpercent,0)
					end
					if(eclipsecheck==1)then
						lunar.Bar:SetVertexColor(0,0,0.7)
					elseif(eclipsecheck==2)then
						lunar.Bar:SetVertexColor(0.7,0.7,0)
					else
						lunar.Bar:SetVertexColor(0.4,0.4,0.4)
					end
					self.Lunar:Show()
					percent=nil
				else
					self.Lunar:Hide()
				end
			else
				self.Lunar:Hide()
			end
		end
	end

	--totem
	if(NPA_ClassInfo_Config["ClassInfo_Totem"]==1)then
		NPA_ClassInfo_Modules["Totem"]=function(_,self,guid)
			local totem=NPA_ClassInfo_TotemData[guid]
			if(totem)then
				local totemicon=self.Totem.Totem
				for i=1,4 do
					if(totem[i])then
						totemicon[i]:SetTexture(totem[i].Icon)
						totemicon[i]:Show()
					else
						totemicon[i]:Hide()
					end
				end
				self.Totem:Show()
			else
				self.Totem:Hide()
			end
		end
	end

	--rune
	if(NPA_ClassInfo_Config["ClassInfo_Rune"]==1)then
		NPA_ClassInfo_Modules["Rune"]=function(nTime,self,guid,unitdata,selfguid)
			if(unitdata.ClassMark=="DEATHKNIGHT")then
				if(guid==selfguid)then
					for i=1,6 do
						---blz didn't make GetRuneCooldown by left to right order, left 1&2, mid 5&6, right 3&4
						local index
						if(i==3 or i==4)then
							index=i+2
						elseif(i==5 or i==6)then
							index=i-2
						else
							index=i
						end
						local start,duration,ready=GetRuneCooldown(index)
						local endtime
						if(ready)then
							endtime=nil
						else
							endtime=start+duration
						end
						---and GetRuneType is by left to right order, why?
						NPA_ClassInfo_SetRuneIcon(endtime,GetRuneType(i),self.Rune.Rune[i],nTime)
					end
				else
					local runecd=NPA_ClassInfo_Rune[guid] or {}
					local runetype=NPA_ClassInfo_RuneType[guid] or {}
					for i=1,6 do
						NPA_ClassInfo_SetRuneIcon(runecd[i],runetype[i],self.Rune.Rune[i],nTime)
					end
				end
				self.Rune:Show()
			else
				self.Rune:Hide()
			end
		end
	end

	--shard
	if(NPA_ClassInfo_Config["ClassInfo_Shard"]==1)then
		NPA_ClassInfo_Modules["Shard"]=function(_,self,guid,unitdata,selfguid)
			if(unitdata.ClassMark=="WARLOCK")then
				local count
				if(guid==selfguid)then
					count=UnitPower("player",7)
				else
					count=NPA_ClassInfo_Shard[guid] or 0
					count=3-count
				end
				if(count>3)then
					count=3
				end

				local shard=self.Shard
				for i=1,count do
					shard[i]:Show()
				end
				for i=count+1,3 do
					shard[i]:Hide()
				end
		
				shard:Show()
			else
				self.Shard:Hide()
			end
		end
	end

	--pet
	if(NPA_ClassInfo_Config["ClassInfo_Ghoul"]==1 or 
	   NPA_ClassInfo_Config["ClassInfo_ShadowFiend"]==1 or 
	   NPA_ClassInfo_Config["ClassInfo_Treant"]==1 or
	   NPA_ClassInfo_Config["ClassInfo_Inferno"]==1)then
		NPA_ClassInfo_Modules["Pet"]=function(nTime,self,guid,unitdata)
			if((unitdata.ClassMark=="DEATHKNIGHT" and NPA_ClassInfo_Config["ClassInfo_Ghoul"]==1) or 
			   (unitdata.ClassMark=="PRIEST" and NPA_ClassInfo_Config["ClassInfo_ShadowFiend"]==1) or
			   (unitdata.ClassMark=="DRUID" and NPA_ClassInfo_Config["ClassInfo_Treant"]==1) or
			   (unitdata.ClassMark=="WARLOCK" and NPA_ClassInfo_Config["ClassInfo_Inferno"]==1))then
				local data=NPA_ClassInfo_PetData[guid]
				if(data and nTime<data.EndTime)then
					self.Pet.Pet:SetTexture(NPA_ClassInfo_PetIconData[data.Spell])
					local endtime=floor(data.EndTime-nTime)
					local timetext
					if(endtime<10)then
						timetext="|cffff0000"..endtime
					elseif(endtime<30)then
						timetext="|cffffff00"..endtime
					else
						timetext="|cff00ff00"..endtime
					end

					self.Pet.Text:SetText(timetext)
					self.Pet:Show()
				else
					self.Pet:Hide()
				end
			else
				self.Pet:Hide()
			end
		end
	end
			

end


local function NPA_ClassInfo_OnUpdate(nTime,self,guid,unitdata,selfguid,_,frame,_,isplayer)
	if(isplayer==1)then
		self:Show()
		for _,func in pairs(NPA_ClassInfo_Modules)do
			func(nTime,self,guid,unitdata,selfguid,frame)
		end
	else
		self:Hide()
	end
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_ClassInfo_SetFrame(main)

	--stance
	local stance=main.Stance
	ManageTexture(nil,stance.Stance,NPA_ClassInfo_Config["ClassInfo_IconData"],stance)
	ManageTexture(nil,stance.StanceOverlay,NPA_ClassInfo_Config["ClassInfo_IconBackgroundData"],stance)
	ManageTexture(nil,stance.StanceBG,NPA_ClassInfo_Config["ClassInfo_IconOverlayData"],stance)
	stance:Hide()

	local resource=main.Resource
	resource:SetPoint("CENTER",main,"CENTER",NPA_ClassInfo_Config["ClassInfo_ResourceOffsetX"],NPA_ClassInfo_Config["ClassInfo_ResourceOffsetY"])
	resource:Show()

	---combopoint
	local combopoint=main.ComboPoint
	combopoint:SetPoint("CENTER",resource,"CENTER",NPA_ClassInfo_Config["ClassInfo_CPOffsetX"],NPA_ClassInfo_Config["ClassInfo_CPOffsetY"])
	ManageTexture(nil,combopoint.Bar,NPA_ClassInfo_Config["ClassInfo_CPBarData"],combopoint,1)
	ManageTexture(nil,combopoint.Overlay,NPA_ClassInfo_Config["ClassInfo_CPOverlayData"],combopoint)
	ManageTexture(nil,combopoint.Background,NPA_ClassInfo_Config["ClassInfo_CPBackgroundData"],combopoint)
	--ManageFont(nil,combopoint.Text,NPA_ClassInfo_Config["ClassInfo_CPTextData"],"CENTER",combopoint,"CENTER")
	combopoint:Hide()

	---totem
	local totemframe=main.Totem
	totemframe:SetWidth(NPA_ClassInfo_Config["ClassInfo_ResourceWidth"])
	totemframe:SetPoint("CENTER",resource,"CENTER",NPA_ClassInfo_Config["ClassInfo_TotemOffsetX"],NPA_ClassInfo_Config["ClassInfo_TotemOffsetY"])
	local step=NPA_ClassInfo_Config["ClassInfo_ResourceWidth"]/5
	local size=step/5*4
	for i=1,4 do
		totemframe.Totem[i]:SetPoint("TOP",totemframe,"TOPLEFT",i*step,0)
		totemframe.Totem[i]:SetHeight(size)
		totemframe.Totem[i]:SetWidth(size)
	end
	totemframe:Hide()

	--rune
	local runeframe=main.Rune
	runeframe:SetWidth(NPA_ClassInfo_Config["ClassInfo_ResourceWidth"])
	--runeframe.Border:SetTexture(NPA_ClassInfo_Config["ClassInfo_ResourceBorderTexture"])
	----
	NPA_Core:TextureManager(runeframe.Border,NPA_ClassInfo_Config["ClassInfo_ResourceBorderTexture"])

	runeframe.Border:SetWidth(NPA_ClassInfo_Config["ClassInfo_ResourceWidth"]+4)
	runeframe.Border:SetHeight(NPA_ClassInfo_Config["ClassInfo_ResourceHeight"]+4)

	local step=NPA_ClassInfo_Config["ClassInfo_ResourceWidth"]/6
	local width=step/5*4
	for i=1,6 do
		runeframe.Rune[i]:SetPoint("LEFT",runeframe,"LEFT",(i-1)*step,0)
		runeframe.Rune[i]:SetHeight(NPA_ClassInfo_Config["ClassInfo_ResourceHeight"])
		runeframe.Rune[i]:SetWidth(width)
		runeframe.Rune[i].Max=width
	end
	runeframe:Hide()

	-- lunar energy
	local lunar=main.Lunar
	lunar:SetPoint("CENTER",resource,"CENTER",NPA_ClassInfo_Config["ClassInfo_LunarOffsetX"],NPA_ClassInfo_Config["ClassInfo_LunarOffsetY"])
	ManageTexture(nil,lunar.Spark,NPA_ClassInfo_Config["ClassInfo_SparkData"],lunar)
	ManageTexture(nil,lunar.Bar,NPA_ClassInfo_Config["ClassInfo_LunarBarData"],lunar)
	lunar:Hide()

	--shard
	local shard=main.Shard
	shard:SetWidth(NPA_ClassInfo_Config["ClassInfo_ResourceWidth"])
	local step=NPA_ClassInfo_Config["ClassInfo_ResourceWidth"]/4
	local size=step/3*2
	for i=1,3 do
		shard[i]:SetPoint("TOP",shard,"TOPLEFT",i*step,0)
		shard[i]:SetWidth(size)
		shard[i]:SetHeight(size/4*3)
		shard[i]:Hide()
		shard[i].Outline:SetWidth(step)
		shard[i].Outline:SetHeight(step/4*3)
		shard[i].Outline:Show()
	end
	shard:Hide()

	--pet
	local pet=main.Pet
	pet:SetPoint("CENTER",main,"CENTER",NPA_ClassInfo_Config["ClassInfo_PetFrameOffsetX"],NPA_ClassInfo_Config["ClassInfo_PetFrameOffsetY"])
	pet:Hide()

	ManageTexture(nil,pet.Pet,NPA_ClassInfo_Config["ClassInfo_PetIconData"],pet)
	ManageTexture(nil,pet.PetOverlay,NPA_ClassInfo_Config["ClassInfo_PetOverlayData"],pet)
	ManageTexture(nil,pet.PetBG,NPA_ClassInfo_Config["ClassInfo_PetBackgroundData"],pet)
	ManageFont(nil,pet.Text,NPA_ClassInfo_Config["ClassInfo_PetTextData"],pet)
end



local function NPA_ClassInfo_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_ClassInfo",frame)
	main:SetPoint("CENTER",frame,"CENTER")
	main:Hide()
	main:SetHeight(1)
	main:SetWidth(1)
	--main:SetFrameStrata("MEDIUM")

	---stance icon
	local stancelayer=CreateFrame("Frame","NPA_ClassInfo_StanceFrame",main)
	stancelayer:SetPoint("CENTER",main,"CENTER")
	stancelayer:Hide()
	stancelayer:SetHeight(1)
	stancelayer:SetWidth(1)

	stancelayer.Stance=stancelayer:CreateTexture("NPA_ClassInfo_StanceTexture","ARTWORK")
	stancelayer.StanceBG=stancelayer:CreateTexture("NPA_ClassInfo_StanceBackground","BACKGROUND")
	stancelayer.StanceOverlay=stancelayer:CreateTexture("NPA_ClassInfo_StanceOverlay","OVERLAY")

	--resourcebar
	local resourcebar=CreateFrame("Frame","NPA_ClassInfo_ResourceMain",main)
	resourcebar:SetHeight(1)
	resourcebar:SetWidth(1)

	--lunar 
	local lunarframe=CreateFrame("Frame","NPA_ClassInfo_LunarFrame",main)
	lunarframe:SetHeight(1)
	lunarframe:SetWidth(1)
	lunarframe:Hide()

	lunarframe.Spark=lunarframe:CreateTexture("NPA_ClassInfo_Spark","OVERLAY",nil)
	lunarframe.Bar=lunarframe:CreateTexture("NPA_ClassInfo_LunarBar","BACKGROUND",nil)

	--shard

	local shardframe=CreateFrame("Frame","NPA_ClassInfo_ShardFrame",resourcebar)
	shardframe:SetHeight(1)
	shardframe:SetWidth(1)
	shardframe:SetPoint("CENTER",resourcebar,"CENTER",0,0)
	shardframe:Hide()

	for i=1,3 do
		local shard=shardframe:CreateTexture("NPA_ClassInfo_Shard","OVERLAY",nil)
		shard:SetTexture("Interface\\PlayerFrame\\UI-WarlockShard")
		shard:SetTexCoord(0.02,0.32,0,0.11)
		shard:Hide()
		shardframe[i]=shard

		local shardoutline=shardframe:CreateTexture("NPA_ClassInfo_ShardOutline","ARTWORK",nil)
		shardoutline:SetPoint("CENTER",shard,"CENTER",0,0)
		shardoutline:SetTexture("Interface\\PlayerFrame\\UI-WarlockShard")
		shardoutline:SetTexCoord(0.01,0.58,0.61,0.8)
		shardoutline:Show()
		shardframe[i].Outline=shardoutline
	end

	main.Shard=shardframe

	---totem icon
	local totemframe=CreateFrame("Frame","NPA_ClassInfo",resourcebar)
	totemframe:SetPoint("CENTER",resourcebar,"CENTER",0,0)
	totemframe:SetHeight(1)

	totemframe.Totem={}
	for i=1,4 do
		totemframe.Totem[i]=totemframe:CreateTexture()
	end

	---combopoint
	local combopoint=CreateFrame("Frame","NPA_ClassInfo_ComboPoint",resourcebar)
	combopoint:SetWidth(1)
	combopoint:SetHeight(1)
	combopoint:Hide()

	combopoint.Overlay=combopoint:CreateTexture("NPA_ClassInfo_ComboPointBarOverlay","ARTWORK",nil)
	combopoint.Bar=combopoint:CreateTexture("NPA_ClassInfo_ComboPointBar","BORDER",nil)
	combopoint.Background=combopoint:CreateTexture("NPA_ClassInfo_ComboPointBarBackground","BACKGROUND",nil)
	--combopoint.Text=combopoint:CreateFontString("NPA_ClassInfo_ComboPointText","OVERLAY",nil)

	---rune

	local runeframe=CreateFrame("Frame","NPA_ClassInfo",resourcebar)
	runeframe:SetPoint("CENTER",resourcebar,"CENTER",0,0)
	runeframe:SetHeight(1)
	runeframe:SetWidth(1)
	runeframe.Border=runeframe:CreateTexture("NPA_ClassInfo_RuneBarBorder","OVERLAY",nil)
	runeframe.Border:SetPoint("CENTER",runeframe,"CENTER",0,0)

	runeframe.Rune={}
	for i=1,6 do
		runeframe.Rune[i]=runeframe:CreateTexture()
	end
	runeframe.Rune[1].Type=1
	runeframe.Rune[2].Type=1
	runeframe.Rune[3].Type=2
	runeframe.Rune[4].Type=2
	runeframe.Rune[5].Type=3
	runeframe.Rune[6].Type=3
	

	--pet timer
	local petlayer=CreateFrame("Frame","NPA_ClassInfo_PetIconLayer",main)
	petlayer:SetPoint("CENTER",main,"CENTER")
	petlayer:Hide()
	petlayer:SetHeight(1)
	petlayer:SetWidth(1)

	petlayer.Pet=petlayer:CreateTexture("NPA_ClassInfo_PetTexture","BORDER")
	petlayer.PetBG=petlayer:CreateTexture("NPA_ClassInfo_PetBackground","BACKGROUND")
	petlayer.PetOverlay=petlayer:CreateTexture("NPA_ClassInfo_PetOverlay","ARTWORK")
	petlayer.Text=petlayer:CreateFontString("NPA_ClassInfo_PetText","OVERLAY")

	main.Resource=resourcebar
	main.Stance=stancelayer
	main.Totem=totemframe
	main.ComboPoint=combopoint
	main.Rune=runeframe
	main.Lunar=lunarframe
	main.Pet=petlayer

	NPA_ClassInfo_SetFrame(main)
	table_insert(NPA_ClassInfo_Frame,main)

	frame["ClassInfo"]=main

end


local function NPA_ClassInfo_CheckCombo(sourceGUID,destGUID,combo)
	if(combo==0)then
		NPA_ClassInfo_ComboPoint[sourceGUID]=0
	elseif(combo==-1)then
		if(destGUID)then
			NPA_ClassInfo_ComboTarget[sourceGUID]=destGUID
		end
	elseif(combo)then
		if(destGUID==NPA_ClassInfo_ComboTarget[sourceGUID])then
			NPA_ClassInfo_ComboPoint[sourceGUID]=(NPA_ClassInfo_ComboPoint[sourceGUID] or 0)+ combo/5
		elseif(destGUID)then
			NPA_ClassInfo_ComboTarget[sourceGUID]=destGUID
			NPA_ClassInfo_ComboPoint[sourceGUID]=combo
		end
		local nTime=GetTime()
		if(arg10 and ((not NPA_ClassInfo_ComboLastCrit[sourceGUID]) or nTime-NPA_ClassInfo_ComboLastCrit[sourceGUID]>0.5))then
			NPA_ClassInfo_ComboPoint[sourceGUID]=NPA_ClassInfo_ComboPoint[sourceGUID]+0.2
			NPA_ClassInfo_ComboLastCrit[sourceGUID]=nTime
		end
		if(NPA_ClassInfo_ComboPoint[sourceGUID]>1)then
			NPA_ClassInfo_ComboPoint[sourceGUID]=1
		end
		
	end

end

local function NPA_ClassInfo_CheckTotem(sourceGUID,destGUID,spell,slot)
	if(not NPA_ClassInfo_TotemData[sourceGUID])then
		NPA_ClassInfo_TotemData[sourceGUID]={}
	end
	if(not NPA_ClassInfo_TotemData[sourceGUID][slot])then
		NPA_ClassInfo_TotemData[sourceGUID][slot]={}
	end
	
	local _,_,icon=GetSpellInfo(spell)

	NPA_ClassInfo_TotemData[sourceGUID][slot].Totem=destGUID
	NPA_ClassInfo_TotemData[sourceGUID][slot].Icon=icon

	if(not NPA_ClassInfo_TotemOwner[destGUID])then
		NPA_ClassInfo_TotemOwner[destGUID]={}
	end

	NPA_ClassInfo_TotemOwner[destGUID].GUID=sourceGUID
	NPA_ClassInfo_TotemOwner[destGUID].Slot=slot
end

local function NPA_ClassInfo_TotemDied(totemGUID)
	local owner=NPA_ClassInfo_TotemOwner[totemGUID]
	if(owner)then
		if(NPA_ClassInfo_TotemData[owner.GUID] and NPA_ClassInfo_TotemData[owner.GUID][owner.Slot] and NPA_ClassInfo_TotemData[owner.GUID][owner.Slot].Totem==totemGUID)then
			NPA_ClassInfo_TotemData[owner.GUID][owner.Slot]=nil
		end
		NPA_ClassInfo_TotemOwner[totemGUID]=nil
	end
end

local NPA_ClassInfo_RuneCheckTable={
	[1]=2,
	[2]=1,
	[3]=4,
	[4]=3,
	[5]=6,
	[6]=5
}

local function NPA_ClassInfo_SetRuneCD(guid,type,ntime,cdtype)
	local rune=NPA_ClassInfo_Rune[guid]
	local runetype=NPA_ClassInfo_RuneType[guid]
	local r1=type*2-1
	local r2=type*2
	local index
	
	if(rune[r1]<ntime and rune[r1]<rune[r2])then
		index=r1
	elseif(rune[r2]<ntime)then
		index=r2
	else	
		for i=1,6 do
			if(runetype[i]==4 and rune[i]<ntime)then
				index=i
				break
			end	
		end
	end

	if(not index)then
		if(rune[r1]>rune[r2])then
			index=r2
		else
			index=r1
		end
	end


	local time
	local i=NPA_ClassInfo_RuneCheckTable[index]
	if(rune[i]>ntime)then
		time=rune[i]
	else
		time=ntime
	end

	rune[index]=time+NPA_ClassInfo_RuneCoolDownTime
	local endtime=ntime+NPA_ClassInfo_RuneCoolDownTime*2
	if(rune[index]>endtime)then
		rune[index]=endtime
	end


	if(cdtype==1 and runetype[index]<4)then
		runetype[index]=4
	else
		runetype[index]=floor(index/2+0.5)
	end

	NPA_ClassInfo_Rune[guid]=rune
	NPA_ClassInfo_RuneType[guid]=runetype
end

local function NPA_ClassInfo_CheckRune(guid,spell,spellid)
	if((not NPA_ClassInfo_Rune[guid]) or spell==-1)then
		NPA_ClassInfo_Rune[guid]={
			[1]=0,
			[2]=0,
			[3]=0,
			[4]=0,
			[5]=0,
			[6]=0,
			}
		NPA_ClassInfo_RuneType[guid]={
			[1]=1,
			[2]=1,
			[3]=2,
			[4]=2,
			[5]=3,
			[6]=3,
			}
	end
	--1&2 blood, 3&4 frost, 5&6 unholy
	local nTime=GetTime()

	--1= blood, 10=frost, 100=unholy 110=unholy&frost,11=blood&frost,0=reset blood, 111=blood&unholy&frost,-1=reset all
	if(spell==-1)then
		return
	elseif(spell==0)then
		NPA_ClassInfo_Rune[guid][1]=nTime
		NPA_ClassInfo_RuneType[guid][1]=1
	else
		local talent=NPA_ClassInfo_TalentData[guid]
		local type
		if(talent==1 and NPA_ClassInfo_DKBloodSpellData[spellid])then
			type=1
		elseif(talent==2 and NPA_ClassInfo_DKUnholySpellData[spellid])then
			type=1
		elseif(talent and locale~="zhCN")then
			NPA_ClassInfo_RuneType[guid][1]=4
			NPA_ClassInfo_RuneType[guid][2]=4
		end

		if(spell>11)then
			spell=spell-100
			NPA_ClassInfo_SetRuneCD(guid,3,nTime,type)	
		end
		if(spell>1)then
			spell=spell-10
			NPA_ClassInfo_SetRuneCD(guid,2,nTime,type)	
		end
		if(spell>0)then
			NPA_ClassInfo_SetRuneCD(guid,1,nTime,type)
		end
	end
end

local NPA_ClassInfo_CombatEvent={
	["SPELL_CAST_SUCCESS"]=1,
	["SPELL_DAMAGE"]=2,
	["SPELL_ENERGIZE"]=3,
	["SPELL_PERIODIC_ENERGIZE"]=3,
	["SPELL_SUMMON"]=4,
	["UNIT_DESTROYED"]=5,
	["UNIT_DIED"]=5,
	["SPELL_AURA_APPLIED"]=6,
	["SPELL_AURA_REFRESH"]=6,
	["SPELL_AURA_APPLIED_DOSE"]=6,
	["SPELL_AURA_REMOVED"]=7,
	["SPELL_AURA_REMOVED_DOSE"]=7,
	["SPELL_AURA_DISPEL"]=7
}

local NPA_ClassInfo_CombatEventFunction={}
NPA_ClassInfo_CombatEventFunction[1]=function(sourceGUID,destGUID,arg1)
	if(sourceGUID==UnitGUID("player"))then
		return
	end
	--talent
	local talent=NPA_ClassInfo_TalentSpellData[arg1]
	if(talent)then
		NPA_ClassInfo_TalentData[sourceGUID]=talent
	end

		--stance
	if(NPA_ClassInfo_StanceSpellData[arg1])then
		NPA_ClassInfo_StanceData[sourceGUID]=arg1
		---hp finish move
	elseif(NPA_ClassInfo_HPSpellData[arg1])then
		NPA_ClassInfo_HPData[sourceGUID]=0
	else
		---combopoint finish moves
		local spelldata=NPA_ClassInfo_FinishSpellData[arg1]
		if(spelldata)then
			NPA_ClassInfo_CheckCombo(sourceGUID,destGUID,spelldata)
			return
		end
		---rune cast
		spelldata=NPA_ClassInfo_RuneCastSpellData[arg1]
		if(spelldata)then
			NPA_ClassInfo_CheckRune(sourceGUID,spelldata)
		end

		--soul shard
		if(arg1==74434)then
			if(not NPA_ClassInfo_SoulShard[sourceGUID])then
				NPA_ClassInfo_SoulShard[sourceGUID]=1
			else
				NPA_ClassInfo_SoulShard[sourceGUID]=NPA_ClassInfo_SoulShard[sourceGUID]+1
			end
		end
	end



end
NPA_ClassInfo_CombatEventFunction[2]=function(sourceGUID,destGUID,arg1)
	if(sourceGUID==UnitGUID("player"))then
		return
	end
	---combopoint finish moves
	local spelldata=NPA_ClassInfo_FinishSpellData[arg1]
	if(spelldata)then
		NPA_ClassInfo_CheckCombo(sourceGUID,destGUID,spelldata)
		return
	end
	--combo moves
	local spelldata=NPA_ClassInfo_ComboSpellData[arg1]
	if(spelldata)then
		NPA_ClassInfo_CheckCombo(sourceGUID,destGUID,spelldata)
		return
	end
	--rune attack
	spelldata=NPA_ClassInfo_RuneAttackSpellData[arg1]
	if(spelldata)then
		NPA_ClassInfo_CheckRune(sourceGUID,spelldata,arg1)
	end
end
NPA_ClassInfo_CombatEventFunction[3]=function(_,destGUID,arg1,arg4,arg5)
	if(destGUID==UnitGUID("player"))then
		return
	end
	if(arg5==9)then
		if(not NPA_ClassInfo_HPData[destGUID])then
			NPA_ClassInfo_HPData[destGUID]=0
		end	
		NPA_ClassInfo_HPData[destGUID]=NPA_ClassInfo_HPData[destGUID]+(arg4 or 0)/3
		if(NPA_ClassInfo_HPData[destGUID]>1)then
			NPA_ClassInfo_HPData[destGUID]=1
		end	
	elseif(arg5==8)then
		if(not NPA_ClassInfo_LPData[destGUID])then
			NPA_ClassInfo_LPData[destGUID]=0
		end
		NPA_ClassInfo_LPData[destGUID]=NPA_ClassInfo_LPData[destGUID]+(arg4 or 0)/100
		if(NPA_ClassInfo_LPData[destGUID]>1)then
			NPA_ClassInfo_LPData[destGUID]=1
		elseif(NPA_ClassInfo_LPData[destGUID]<-1)then
			NPA_ClassInfo_LPData[destGUID]=-1
		end
	elseif(arg5==7)then
		if(not NPA_ClassInfo_SoulShard[destGUID])then
			NPA_ClassInfo_SoulShard[destGUID]=0
		else
			NPA_ClassInfo_SoulShard[destGUID]=NPA_ClassInfo_SoulShard[destGUID]-1
			if(NPA_ClassInfo_SoulShard[destGUID]<0)then
				NPA_ClassInfo_SoulShard[destGUID]=0
			end
		end
		
	end
end
NPA_ClassInfo_CombatEventFunction[4]=function(sourceGUID,destGUID,arg1)
	local totemslot=NPA_ClassInfo_TotemSpellData[arg1]
	if(totemslot)then
		NPA_ClassInfo_CheckTotem(sourceGUID,destGUID,arg1,totemslot)
	end
	local petslot=NPA_ClassInfo_PetSpellData[arg1]
	if(petslot)then
		NPA_ClassInfo_PetData[sourceGUID]={EndTime=GetTime()+petslot,Spell=arg1}
		NPA_ClassInfo_PetOwner[destGUID]=sourceGUID
	end
end
NPA_ClassInfo_CombatEventFunction[5]=function(destGUID,arg1)
	NPA_ClassInfo_TotemDied(destGUID)
	NPA_ClassInfo_LPData[destGUID]=nil
	NPA_ClassInfo_HPData[destGUID]=nil
	NPA_ClassInfo_ComboPoint[destGUID]=nil

	local owner=NPA_ClassInfo_PetOwner[destGUID]
	if(owner)then
		NPA_ClassInfo_PetData[owner]=nil
	end
end
NPA_ClassInfo_CombatEventFunction[6]=function(sourceGUID,_,arg1,_,arg5)
	if(sourceGUID==UnitGUID("player"))then
		return
	end

	spelldata=NPA_ClassInfo_RuneAttackSpellData[arg1]
	if(spelldata)then
		NPA_ClassInfo_CheckRune(sourceGUID,spelldata)
	end

	--druid eclipse
	if(arg1==48518)then
		NPA_ClassInfo_LPData[sourceGUID]=-1
	elseif(arg1==48517)then
		NPA_ClassInfo_LPData[sourceGUID]=1
	--hunter aimed shot
	elseif(arg1==82925)then
		NPA_ClassInfo_HunterCombo[sourceGUID]=(arg5 or 1)/5
	elseif(arg1==82926)then
		NPA_ClassInfo_HunterCombo[sourceGUID]=2
	end
end
NPA_ClassInfo_CombatEventFunction[7]=function(sourceGUID,_,arg1)
	if((arg1==82925 and NPA_ClassInfo_HunterCombo[sourceGUID]~=2) or arg1==82926)then
		NPA_ClassInfo_HunterCombo[sourceGUID]=0
	end
end

local function NPA_ClassInfo_OnEvent(uarg)--  
--  2                   3                       4                      5                    6                 7                8                 9               10                 11                12              13              14         15             16               17                    18               19                    20                              
--event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, 1spellID,2spellName,3spellSchool, 4amount, 5overkill,6 school, 7risisted, 8blocked, 9absorbed, 10critical, 11glancing,12 crushing
	local event=NPA_ClassInfo_CombatEvent[uarg[2]]
	if(event)then
		if(uarg[6] and bit_band(uarg[6],COMBATLOG_OBJECT_TYPE_PLAYER)>0 and uarg[9])then
			NPA_ClassInfo_CombatEventFunction[event](uarg[3],uarg[6],uarg[9],uarg[12],uarg[13])
		elseif(event==5)then
			NPA_ClassInfo_CombatEventFunction[5](uarg[7],uarg[9])
		end
	end
end

function NPA_ClassInfo:ApplyConfig()
	NPA_Core:CheckConfigEntry("ClassInfo",NPA_ClassInfo_DefaultSetting)

	NPA_ClassInfo_Config=NPA_Config["ClassInfo"]

	for _,main in pairs(NPA_ClassInfo_Frame) do
		NPA_ClassInfo_SetFrame(main)
	end

	if(NPA_Config["Core"]["EnableModule"]["ClassInfo"]==1)then
		NPA_Core.CombatEventFunc["ClassInfo"]=NPA_ClassInfo_OnEvent
	else
		NPA_Core.CombatEventFunc["ClassInfo"]=nil
	end
	NPA_ClassInfo_BuildModules()
end


NPA_Core:AddHook("ClassInfo",NPA_ClassInfo_HookFrame)
NPA_Core:AddModule("ClassInfo",NPA_ClassInfo)
NPA_Core:HookUpdate("ClassInfo",NPA_ClassInfo_OnUpdate,2)