-- Author      : Nogarder
-- Create Date : 2010/7/4 18:39:17
--global function
local table_insert=table.insert
local pairs=pairs
local strfind=string.find

local NPA_ClassIcon_Frame={}
local NPA_ClassIcon={}

local tonumber=tonumber


--------build totem list
local NPA_TotemIcon_TotemSpellid
--4.0
local _,_,_,interfaceversion=GetBuildInfo()
if(interfaceversion<40000)then --special...
	NPA_TotemIcon_TotemSpellid={
		1535,--firenova totem
		2062,--earth elemental totem
		2484,--earthbind totem
		2894,--fire elemental totem
		3599,--searing totem
		3738,--wrath of air totem
		5394,--healing stream totem
		5675,--mana spring totem
		5730,--stoneclaw totem
		6495,--sight totem(whats its name ?)
		8075,--strength of earth totem
		8143,--tremor totem
		8170,--cleanse totem
		8177,--grounding totem
		8181,--cold resistance totem
		8184,--fire resistance totem
		8190,--magma totem
		8227,--flametongue totem
		8512,--windfury totem
		10406,--stoneskin totem
		16190,--mana tide totem(can't even find it in pre4.0 data base!?)
		57720,--totem of wrath
		57721,--totem of wrath
		57722,--totem of wrath
		30706,--totem of wrath
		}
else
	NPA_TotemIcon_TotemSpellid={
		3599,--Searing Totem
		2484,--Earthbind Totem
		8190,--Magma Totem
		5730,--Stoneclaw Totem
		2894,--Fire Elemental Totem
		8075,--Strength of Earth Totem
		8227,--Flametongue Totem
		8512,--Windfury Totem
		8177,--Grounding Totem
		3738,--Wrath of Air Totem
		8071,--Stoneskin Totem
		2062,--Earth Elemental Totem
		8184,--Elemental Resistance Totem
		5394,--Healing Stream Totem
		5675,--Mana Spring Totem
		8143,--Tremor Totem
		87718,--Totem of Tranquil Mind
		16190,--Mana Tide Totem
		57658,--totem of wrath
		98008,--Spirit Link Totem
		}
end


--config
local NPA_ClassIcon_DefaultSettings={
		["ClassIcon_OffsetX"]=-75,
		["ClassIcon_OffsetY"]=-10,

		["ClassIcon_Center"]=1,
		["ClassIcon_Double"]=1,

		["ClassIcon_ShowClass"]=1,
		["ClassIcon_ShowTotem"]=1,

		["ClassIcon_IconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassIcon_IconBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassIcon_IconOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassIcon_TotemIconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassIcon_TotemIconBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["ClassIcon_TotemIconOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},	
		["ClassIcon_HideList"]={},
		["ClassIcon_Separate"]=0,
		["ClassIcon_EnlargeLevel"]=2,

		["ClassIcon_TotemList"]={},
		["ClassIcon_HideWhenSelected"]=0,

		["ClassIcon_FuzzyMatch"]=0,
	}
local NPA_ClassIcon_Config=NPA_ClassIcon_DefaultSettings

local NPA_TotemIcon_TotemList={}

function NPA_ClassIcon:ResetConfig()
	NPA_Config["ClassIcon"]=CopyTable(NPA_ClassIcon_DefaultSettings)
end



local function NPA_ClassIcon_GetClassPos(class)
	local classicon=CLASS_ICON_TCOORDS[class] or {0.25, 0.5, 0.5, 0.75}
	return classicon
end


local NPA_ClassIcon_ClassColorTable={}
--generate colortable
for class,color in pairs(RAID_CLASS_COLORS) do
	local r=floor(color.r*100/4)
	local g=floor(color.g*100/4)
	local b=floor(color.b*100/4)
	if(not NPA_ClassIcon_ClassColorTable[r])then
		NPA_ClassIcon_ClassColorTable[r]={}
	end
	if(not  NPA_ClassIcon_ClassColorTable[r][g])then
		NPA_ClassIcon_ClassColorTable[r][g]={}
	end
	if(not  NPA_ClassIcon_ClassColorTable[r][g][b])then
		NPA_ClassIcon_ClassColorTable[r][g][b]=class
	end
end

local function NPA_ClassIcon_OnUpdate(_,self,guid,unitdata,_,guids,frame,_,isplayer,default)
	local icon=self.Icon
	if(isplayer==1)then
		local classmark
		if(unitdata) then
			classmark=unitdata.ClassMark
		else
			local r,g,b = default.HealthBar:GetStatusBarColor()
			r=floor(r*25)
			g=floor(g*25)
			b=floor(b*25)
			if(NPA_ClassIcon_ClassColorTable[r] and NPA_ClassIcon_ClassColorTable[r][g] and NPA_ClassIcon_ClassColorTable[r][g][b])then
				classmark=NPA_ClassIcon_ClassColorTable[r][g][b]
			end
		end
		
		self.IsTotem=0
		if(NPA_ClassIcon_Config["ClassIcon_ShowClass"]==1 and classmark)then
			local texcoord=NPA_ClassIcon_GetClassPos(classmark)
			icon:SetTexture(NPA_ClassIcon_Config["ClassIcon_IconData"].Texture)
			icon:SetTexCoord(unpack(texcoord))
			self:Show()
			icon:Show()
			self.Background:Show()
			self.Overlay:Show()
			self.TotemIcon:Hide()
			self.TotemBackground:Hide()
			self.TotemOverlay:Hide()
		else
			self:Hide()
		end
	else
		self.Background:Hide()
		self.Overlay:Hide()
		icon:Hide()

		icon=self.TotemIcon

		local name
		if(default)then
			name=default.NameText:GetText()
		elseif(unitdata)then
			name=unitdata.Name
		else
			self:Hide()
			return
		end

		local match
		if(name)then
			if(NPA_ClassIcon_Config["ClassIcon_FuzzyMatch"]==1)then
				for tname,_ in pairs(NPA_TotemIcon_TotemList)do
					if(strfind(name,tname))then
						name=tname
						match=1
					end
				end
			else
				if(NPA_TotemIcon_TotemList[name])then
					match=1
				end
			end
		end

		if(match and NPA_ClassIcon_Config["ClassIcon_ShowTotem"]==1)then
			local health
			local level

			if(default)then
				_,health=default.HealthBar:GetMinMaxValues()
				level=tonumber(default.LevelText:GetText()) or 1
				if(not health)then
					health=1
				end
			else
				health=unitdata.HealthMax or 1
				level=unitdata.Level or 5
			end
			local healthcheck
			if(level<81)then
				if(health<level*25)then
					healthcheck=1
				end
			else
				if(health<level*250)then
					healthcheck=1
				end
			end

			if(healthcheck)then
				self.IsTotem=1
				if(NPA_ClassIcon_Config["ClassIcon_HideList"][name]~=1 
					or ((guid==guids.Target or guid==guids.Mouseover) and NPA_ClassIcon_Config["ClassIcon_HideWhenSelected"]~=1 ) )then
					icon:SetTexture(NPA_TotemIcon_TotemList[name])
					icon:SetTexCoord(0,1,0,1)
					icon:Show()
					self.TotemBackground:Show()
					self.TotemOverlay:Show()
					self:Show()
				else
					self:Hide()
				end	
			else
				self.IsTotem=0
				self:Hide()
				return
			end
		else
			self.IsTotem=0
			self:Hide()
			return
		end
	end

	local healthbar=frame["HealthBar"]

	if(healthbar and (not healthbar:IsShown()) and NPA_ClassIcon_Config["ClassIcon_Center"]==1)then
		self:SetPoint("BOTTOM",frame,"TOP",0,NPA_ClassIcon_Config["ClassIcon_OffsetY"])
		if(NPA_ClassIcon_Config["ClassIcon_Double"])then
			self:SetScale(NPA_ClassIcon_Config["ClassIcon_EnlargeLevel"])
		end
	else
		self:SetPoint("BOTTOM",frame,"TOP",NPA_ClassIcon_Config["ClassIcon_OffsetX"],NPA_ClassIcon_Config["ClassIcon_OffsetY"])
		self:SetScale(1)
	end
end


local ManageTexture=NPA_Core.TextureManager2

local function NPA_ClassIcon_SetFrame(iconframe)
	iconframe:SetPoint("BOTTOM",frame,"TOP")
	ManageTexture(nil,iconframe.Icon,NPA_ClassIcon_Config["ClassIcon_IconData"],iconframe)
	ManageTexture(nil,iconframe.Background,NPA_ClassIcon_Config["ClassIcon_IconBackgroundData"],iconframe)
	ManageTexture(nil,iconframe.Overlay,NPA_ClassIcon_Config["ClassIcon_IconOverlayData"],iconframe)

	if(NPA_ClassIcon_Config["ClassIcon_Separate"]==1)then
		ManageTexture(nil,iconframe.TotemIcon,NPA_ClassIcon_Config["ClassIcon_TotemIconData"],iconframe)
		ManageTexture(nil,iconframe.TotemBackground,NPA_ClassIcon_Config["ClassIcon_TotemIconBackgroundData"],iconframe)
		ManageTexture(nil,iconframe.TotemOverlay,NPA_ClassIcon_Config["ClassIcon_TotemIconOverlayData"],iconframe)

	else
		ManageTexture(nil,iconframe.TotemIcon,NPA_ClassIcon_Config["ClassIcon_IconData"],iconframe)
		ManageTexture(nil,iconframe.TotemBackground,NPA_ClassIcon_Config["ClassIcon_IconBackgroundData"],iconframe)
		ManageTexture(nil,iconframe.TotemOverlay,NPA_ClassIcon_Config["ClassIcon_IconOverlayData"],iconframe)
	end

	
end

local function NPA_ClassIcon_HookFrame(frame)
	local iconframe=CreateFrame("Frame","NPA_ClassIcon_Main",frame)
	iconframe:SetFrameStrata("LOW")
	iconframe:SetHeight(1)
	iconframe:SetWidth(1)

	local icon=iconframe:CreateTexture("NPA_ClassIcon_Icon","ARTWORK",nil)
	local background=iconframe:CreateTexture("NPA_ClassIcon_Icon","BACKGROUND",nil)
	local overlay=iconframe:CreateTexture("NPA_ClassIcon_Icon","OVERLAY",nil)

	local totemicon=iconframe:CreateTexture("NPA_ClassIcon_Icon","ARTWORK",nil)
	local totembackground=iconframe:CreateTexture("NPA_ClassIcon_Icon","BACKGROUND",nil)
	local totemoverlay=iconframe:CreateTexture("NPA_ClassIcon_Icon","OVERLAY",nil)


	iconframe.Icon=icon
	iconframe.Background=background
	iconframe.Overlay=overlay

	iconframe.TotemIcon=totemicon
	iconframe.TotemBackground=totembackground
	iconframe.TotemOverlay=totemoverlay

	table_insert(NPA_ClassIcon_Frame,iconframe)

	NPA_ClassIcon_SetFrame(iconframe)

	frame["ClassIcon"]=iconframe
end


local function NPA_ClassIcon_BuildTotemList()
	NPA_TotemIcon_TotemList={}
	for _,id in pairs(NPA_TotemIcon_TotemSpellid) do
		local name,_,texture=GetSpellInfo(id)
		if(name and texture)then
			NPA_TotemIcon_TotemList[name]=texture
		end
	end

	for name,_ in pairs(NPA_ClassIcon_Config["ClassIcon_TotemList"])do
		for j=1,100000 do
			local spellname,_,texture=GetSpellInfo(j)
			if(spellname and texture and (strfind(spellname,name) or strfind(name,spellname)))then
				NPA_TotemIcon_TotemList[spellname]=texture
			end
		end
			
	end
end

function NPA_ClassIcon:ApplyConfig()
	NPA_Core:CheckConfigEntry("ClassIcon",NPA_ClassIcon_DefaultSettings)

	NPA_ClassIcon_Config=NPA_Config["ClassIcon"]

	for _,iconframe in pairs(NPA_ClassIcon_Frame) do
		NPA_ClassIcon_SetFrame(iconframe)
	end

	NPA_ClassIcon_BuildTotemList()

	local hidelist=NPA_ClassIcon_Config["ClassIcon_HideList"]
	local list={}

	for name,_ in pairs(NPA_TotemIcon_TotemList) do
		if(hidelist[name]==1)then
			list[name]=1
		else
			list[name]=0
		end
	end
	NPA_ClassIcon_Config["ClassIcon_HideList"]=list
end

NPA_Core:AddHook("ClassIcon",NPA_ClassIcon_HookFrame)
NPA_Core:AddModule("ClassIcon",NPA_ClassIcon)
NPA_Core:HookUpdate("ClassIcon",NPA_ClassIcon_OnUpdate,1)


